<?php
if(!defined('ABSPATH')) exit;

/**
 * Class MikadoCPT
 *
 * @package Mikado Core
 *
 * This class is used to register custom post types and taxonomies. It is a singletone class and main method
 * is registerCPT
 * It registers:
 * - portfolio
 * - portfolio category
 * - testimonials
 * - testimonials category
 * - carousels
 * - carousels category
 * - sliders
 * - sliders category
 */
class MikadoCPT {
    private static $instance;

    /**
     * Private constructor so this class can't instantiated multiple times
     */
    private function __construct() {}

    /**
     * Method that returns instance of current class
     * @return MikadoCPT
     */
    public static function getInstance() {
        if(self::$instance == null) {
            return new self();
        }

        return self::$instance;
    }

    /**
     * Method that registers all CPTs
     *
     * @see MikadoCPT::registerPortfolio
     * @see MikadoCPT::registerTestimonials
     * @see MikadoCPT::registerCarousels
     * @see MikadoCPT::registerMkdSlider
     */
    public function registerCPT() {
        $this->registerPortfolio();
        $this->registerTestimonials();
        $this->registerCarousels();
        $this->registerMkdSlider();
    }

    /**
     * Method that registers portfolio CPT and portfolio category taxonomy
     */
    public function registerPortfolio() {
        global $mkd_options;

        $slug = 'portfolio_page';
        if(is_array($mkd_options) && isset($mkd_options['portfolio_single_slug']) &&
            $mkd_options['portfolio_single_slug'] !== '') {
            $slug = $mkd_options['portfolio_single_slug'];
        }

        register_post_type( 'portfolio_page',
            array(
                'labels' => array(
                    'name' => esc_html__( 'Portfolio','mikado-core' ),
                    'singular_name' => esc_html__( 'Portfolio Item','mikado-core' ),
                    'add_item' => esc_html__('New Portfolio Item','mikado-core'),
                    'add_new_item' => esc_html__('Add New Portfolio Item','mikado-core'),
                    'edit_item' => esc_html__('Edit Portfolio Item','mikado-core')
                ),
                'public' => true,
                'has_archive' => true,
                'rewrite' => array('slug' => $slug),
                'menu_position' => 4,
                'show_ui' => true,
                'supports' => array('author', 'title', 'editor', 'thumbnail', 'excerpt', 'page-attributes', 'comments')
            )
        );

        $labels = array(
            'name' => esc_html__( 'Portfolio Categories','mikado-core' ),
            'singular_name' => esc_html__( 'Portfolio Category','mikado-core' ),
            'search_items' =>  esc_html__( 'Search Portfolio Categories','mikado-core' ),
            'all_items' => esc_html__( 'All Portfolio Categories','mikado-core' ),
            'parent_item' => esc_html__( 'Parent Portfolio Category','mikado-core' ),
            'parent_item_colon' => esc_html__( 'Parent Portfolio Category:','mikado-core' ),
            'edit_item' => esc_html__( 'Edit Portfolio Category','mikado-core' ),
            'update_item' => esc_html__( 'Update Portfolio Category','mikado-core' ),
            'add_new_item' => esc_html__( 'Add New Portfolio Category','mikado-core' ),
            'new_item_name' => esc_html__( 'New Portfolio Category Name','mikado-core' ),
            'menu_name' => esc_html__( 'Portfolio Categories','mikado-core' ),
        );

        register_taxonomy('portfolio_category', array('portfolio_page'), array(
            'hierarchical' => true,
            'labels' => $labels,
            'show_ui' => true,
            'query_var' => true,
            'rewrite' => array( 'slug' => 'portfolio-category' ),
        ));

        $labels = array(
            'name' => esc_html__( 'Portfolio Tags','mikado-core' ),
            'singular_name' => esc_html__( 'Portfolio Tag','mikado-core' ),
            'search_items' =>  esc_html__( 'Search Portfolio Tags','mikado-core' ),
            'all_items' => esc_html__( 'All Portfolio Tags','mikado-core' ),
            'parent_item' => esc_html__( 'Parent Portfolio Tag','mikado-core' ),
            'parent_item_colon' => esc_html__( 'Parent Portfolio Tags:','mikado-core' ),
            'edit_item' => esc_html__( 'Edit Portfolio Tag','mikado-core' ),
            'update_item' => esc_html__( 'Update Portfolio Tag','mikado-core' ),
            'add_new_item' => esc_html__( 'Add New Portfolio Tag','mikado-core' ),
            'new_item_name' => esc_html__( 'New Portfolio Tag Name','mikado-core' ),
            'menu_name' => esc_html__( 'Portfolio Tags','mikado-core' ),
        );

        register_taxonomy('portfolio_tag',array('portfolio_page'), array(
            'hierarchical' => false,
            'labels' => $labels,
            'show_ui' => true,
            'query_var' => true,
            'rewrite' => array( 'slug' => 'portfolio-tag' ),
        ));
    }

    /**
     * Method that registers testimonials CPT and testimonials category taxonomy
     */
    public function registerTestimonials() {
        register_post_type('testimonials',
            array(
                'labels' 		=> array(
                    'name' 				=> esc_html__('Testimonials','mikado-core' ),
                    'singular_name' 	=> esc_html__('Testimonial','mikado-core' ),
                    'add_item'			=> esc_html__('New Testimonial','mikado-core'),
                    'add_new_item' 		=> esc_html__('Add New Testimonial','mikado-core'),
                    'edit_item' 		=> esc_html__('Edit Testimonial','mikado-core')
                ),
                'public'		=>	false,
                'show_in_menu'	=>	true,
                'rewrite' 		=> 	array('slug' => 'testimonials'),
                'menu_position' => 	4,
                'show_ui'		=>	true,
                'has_archive'	=>	false,
                'hierarchical'	=>	false,
                'supports'		=>	array('title', 'thumbnail')
            )
        );

        $labels = array(
            'name' => esc_html__( 'Testimonials Categories','mikado-core' ),
            'singular_name' => esc_html__( 'Testimonial Category','mikado-core' ),
            'search_items' =>  esc_html__( 'Search Testimonials Categories','mikado-core' ),
            'all_items' => esc_html__( 'All Testimonials Categories','mikado-core' ),
            'parent_item' => esc_html__( 'Parent Testimonial Category','mikado-core' ),
            'parent_item_colon' => esc_html__( 'Parent Testimonial Category:','mikado-core' ),
            'edit_item' => esc_html__( 'Edit Testimonials Category','mikado-core' ),
            'update_item' => esc_html__( 'Update Testimonials Category','mikado-core' ),
            'add_new_item' => esc_html__( 'Add New Testimonials Category','mikado-core' ),
            'new_item_name' => esc_html__( 'New Testimonials Category Name','mikado-core' ),
            'menu_name' => esc_html__( 'Testimonials Categories','mikado-core' ),
        );

        register_taxonomy('testimonials_category',array('testimonials'), array(
            'hierarchical' => true,
            'labels' => $labels,
            'show_ui' => true,
            'query_var' => true,
            'show_admin_column' => true,
            'rewrite' => array( 'slug' => 'testimonials-category' ),
        ));
    }

    /**
     * Method that registers carousel item CPT and carousel taxonomy
     */
    public function registerCarousels() {
        $menu_icon = mkdcore_is_theme_installed() ? MIKADO_ROOT.'/img/favicon.ico' : 'dashicons-admin-post';
        register_post_type('carousels',
            array(
                'labels'    => array(
                    'name'        => esc_html__('Mikado Carousel','mikado-core' ),
                    'menu_name' => esc_html__('Mikado Carousel','mikado-core' ),
                    'all_items' => esc_html__('Carousel Items','mikado-core' ),
                    'add_new' =>  esc_html__('Add New Carousel Item','mikado-core'),
                    'singular_name'   => esc_html__('Carousel Item','mikado-core' ),
                    'add_item'      => esc_html__('New Carousel Item','mikado-core'),
                    'add_new_item'    => esc_html__('Add New Carousel Item','mikado-core'),
                    'edit_item'     => esc_html__('Edit Carousel Item','mikado-core')
                ),
                'public'    =>  false,
                'show_in_menu'  =>  true,
                'rewrite'     =>  array('slug' => 'carousels'),
                'menu_position' =>  4,
                'show_ui'   =>  true,
                'has_archive' =>  false,
                'hierarchical'  =>  false,
                'supports'    =>  array('title','page-attributes'),
                'menu_icon'  =>  $menu_icon
            )
        );

        $labels = array(
            'name' => esc_html__( 'Carousels','mikado-core' ),
            'singular_name' => esc_html__( 'Carousel','mikado-core' ),
            'search_items' =>  esc_html__( 'Search Carousels','mikado-core' ),
            'all_items' => esc_html__( 'All Carousels','mikado-core' ),
            'parent_item' => esc_html__( 'Parent Carousel','mikado-core' ),
            'parent_item_colon' => esc_html__( 'Parent Carousel:','mikado-core' ),
            'edit_item' => esc_html__( 'Edit Carousel','mikado-core' ),
            'update_item' => esc_html__( 'Update Carousel','mikado-core' ),
            'add_new_item' => esc_html__( 'Add New Carousel','mikado-core' ),
            'new_item_name' => esc_html__( 'New Carousel Name','mikado-core' ),
            'menu_name' => esc_html__( 'Carousels','mikado-core' ),
        );

        register_taxonomy('carousels_category',array('carousels'), array(
            'hierarchical' => true,
            'labels' => $labels,
            'show_ui' => true,
            'query_var' => true,
            'show_admin_column' => true,
            'rewrite' => array( 'slug' => 'carousels-category' ),
        ));
    }

    /**
     * Method that registers slide CPT and slider taxonomy
     */
    public function registerMkdSlider() {
        $menu_icon = mkdcore_is_theme_installed() ? MIKADO_ROOT.'/img/favicon.ico' : 'dashicons-admin-post';
;        register_post_type('slides',
            array(
                'labels' 		=> array(
                    'name' 				=> esc_html__('Mikado Slider','mikado-core' ),
                    'menu_name'	=> esc_html__('Mikado Slider','mikado-core' ),
                    'all_items'	=> esc_html__('Slides','mikado-core' ),
                    'add_new' =>  esc_html__('Add New Slide','mikado-core'),
                    'singular_name' 	=> esc_html__('Slide','mikado-core' ),
                    'add_item'			=> esc_html__('New Slide','mikado-core'),
                    'add_new_item' 		=> esc_html__('Add New Slide','mikado-core'),
                    'edit_item' 		=> esc_html__('Edit Slide','mikado-core')
                ),
                'public'		=>	false,
                'show_in_menu'	=>	true,
                'rewrite' 		=> 	array('slug' => 'slides'),
                'menu_position' => 	4,
                'show_ui'		=>	true,
                'has_archive'	=>	false,
                'hierarchical'	=>	false,
                'supports'		=>	array('title', 'thumbnail', 'page-attributes'),
                'menu_icon'  =>  $menu_icon
            )
        );

        $labels = array(
            'name' => esc_html__( 'Sliders','mikado-core' ),
            'singular_name' => esc_html__( 'Slider','mikado-core' ),
            'search_items' =>  esc_html__( 'Search Sliders','mikado-core' ),
            'all_items' => esc_html__( 'All Sliders','mikado-core' ),
            'parent_item' => esc_html__( 'Parent Slider','mikado-core' ),
            'parent_item_colon' => esc_html__( 'Parent Slider:','mikado-core' ),
            'edit_item' => esc_html__( 'Edit Slider','mikado-core' ),
            'update_item' => esc_html__( 'Update Slider','mikado-core' ),
            'add_new_item' => esc_html__( 'Add New Slider','mikado-core' ),
            'new_item_name' => esc_html__( 'New Slider Name','mikado-core' ),
            'menu_name' => esc_html__( 'Sliders','mikado-core' ),
        );

        register_taxonomy('slides_category',array('slides'), array(
            'hierarchical' => true,
            'labels' => $labels,
            'show_ui' => true,
            'query_var' => true,
            'show_admin_column' => true,
            'rewrite' => array( 'slug' => 'slides-category' ),
        ));
    }
}

//Hook MikadoCPT::registerCPT method to init action
add_action('init', array(MikadoCPT::getInstance(), 'registerCPT'), 0);