<?php

class MkdCarouselShortcode {
    public function __construct() {
        add_shortcode('no_carousel', array($this, 'render'));
        add_action('vc_before_init', array($this, 'vcMap'));
    }

    public function vcMap() {
        if(function_exists('vc_map')) {
            vc_map( array(
                "name" => "Mikado Carousel",
                "base" => "no_carousel",
                "category" => 'by MIKADO',
                "icon" => "icon-wpb-mkd_carousel",
                "allowed_container_element" => 'vc_row',
                "params" => array(
                    array(
                        "type" => "dropdown",
                        "class" => "",
                        "heading" => "Carousel Slider",
                        "param_name" => "carousel",
                        "value" => mkdcore_get_carousel_slider_array_vc(),
                        "description" => ""
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Order By",
                        "param_name" => "orderby",
                        "value" => array(
                            "" => "",
                            "Menu Order" => "menu_order",
                            "Title" => "title",
                            "Date" => "date"
                        ),
                        "description" => ""
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Order",
                        "param_name" => "order",
                        "value" => array(
                            "" => "",
                            "ASC" => "ASC",
                            "DESC" => "DESC",
                        ),
                        "description" => ""
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Show navigation?",
                        "param_name" => "show_navigation",
                        "value" => array(
                            "Yes" => "yes",
                            "No" => "no",
                        ),
                        "description" => ""
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Show Items In Two Rows?",
                        "param_name" => "show_in_two_rows",
                        "value" => array(
                            "No" => "",
                            "Yes" => "yes",
                        ),
                        "description" => ""
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Margin Between Two Rows (px)",
                        "param_name" => "margin_between_rows",
                        "description" => "Default value is 50",
                        "dependency" => array('element' => "show_in_two_rows", 'value' => array('yes'))
                    ),
                )
            ) );
        }
    }

    public function render($atts, $content = null) {
        $args = array(
            "carousel" 			    => "",
            "orderby"  			    => "date",
            "order"    			    => "ASC",
            "show_navigation"	    => "",
            "show_in_two_rows" 	    => "",
            "margin_between_rows" 	=> ""
        );

        extract(shortcode_atts($args, $atts));

        $carousel = esc_attr($carousel);
        $orderby = esc_attr($orderby);
        $order = esc_attr($order);
        $show_navigation = esc_attr($show_navigation);
        $show_in_two_rows = esc_attr($show_in_two_rows);
        $margin_between_rows = esc_attr($margin_between_rows);

        $html = "";


        if ($carousel != "") {
            $carousel_holder_classes = array();
            $margin_between_rows_style = '';

            if($show_in_two_rows == 'yes') {
                $carousel_holder_classes[] = 'two_rows';


                if($margin_between_rows != ''){
                    $valid_margin_between_rows = (strstr($margin_between_rows, 'px', true)) ? $margin_between_rows : $margin_between_rows.'px';
                    $margin_between_rows_style = 'style="margin-bottom:'. esc_attr($valid_margin_between_rows) .';"';
                }
            }

            $html .= "<div class='mkd_carousels_holder clearfix ".implode(' ', $carousel_holder_classes)."'><div class='mkd_carousels'><ul class='slides'>";

            $q = array('post_type'=> 'carousels', 'carousels_category' => $carousel, 'orderby' => $orderby, 'order' => $order, 'posts_per_page' => '-1');

            query_posts($q);
            $have_posts = false;

            if ( have_posts() ) : $post_count = 1; $have_posts = true; while ( have_posts() ) : the_post();

                if(get_post_meta(get_the_ID(), "mkd_carousel-image", true) != "") {
                    $image = esc_url(get_post_meta(get_the_ID(), "mkd_carousel-image", true));
                } else {
                    $image = "";
                }

                if(get_post_meta(get_the_ID(), "mkd_carousel-hover-image", true) != ""){
                    $hover_image = esc_url(get_post_meta(get_the_ID(), "mkd_carousel-hover-image", true));
                    $has_hover_image = "has_hover_image";
                } else {
                    $hover_image = "";
                    $has_hover_image = "";
                }

                if(get_post_meta(get_the_ID(), "mkd_carousel-item-link", true) != ""){
                    $link = esc_url(get_post_meta(get_the_ID(), "mkd_carousel-item-link", true));
                } else {
                    $link = "";
                }

                if(get_post_meta(get_the_ID(), "mkd_carousel-item-target", true) != ""){
                    $target = esc_attr(get_post_meta(get_the_ID(), "mkd_carousel-item-target", true));
                } else {
                    $target = "_self";
                }

                $title = get_the_title();

                //is current item not on even position in array and two rows option is chosen?
                if($post_count % 2 !== 0 && $show_in_two_rows == 'yes') {
                    $html .= "<li class='item'>";
                } elseif($show_in_two_rows == '') {
                    $html .= "<li class='item'>";
                }

                $html .= '<div class="carousel_item_holder" '. esc_html($margin_between_rows_style) .'>';

                if($link != ""){
                    $html .= "<a href='". esc_url($link) ."' target='". esc_attr($target) ."'>";
                }

                if($image != ""){
                    $html .= "<span class='first_image_holder ". esc_attr($has_hover_image) ."'><img src='". esc_url($image) ."' alt='". esc_attr($title) ."'></span>";
                }

                if($hover_image != ""){
                    $html .= "<span class='second_image_holder ". esc_attr($has_hover_image) ."'><img src='". esc_url($hover_image) ."' alt='". esc_attr($title) ."'></span>";
                }

                if($link != ""){
                    $html .= "</a>";
                }

                $html .= '</div>';

                //is current item on even position in array and two rows option is chosen?
                if($post_count % 2 == 0 && $show_in_two_rows == 'yes') {
                    $html .= "</li>";
                } elseif($show_in_two_rows == '') {
                    $html .= "</li>";
                }

                $post_count++;

            endwhile;

            else:
                $html .= esc_html__('Sorry, no posts matched your criteria.','mikado-core');
            endif;

            wp_reset_query();

            $html .= "</ul>";

            if($show_navigation != 'no' && $have_posts) {
                //generate navigation html
                $html .= '<ul class="caroufredsel-direction-nav">';

                $html .= '<li class="caroufredsel-prev-holder">';

                $html .= '<a id="caroufredsel-prev" class="mkd_carousel_prev caroufredsel-navigation-item caroufredsel-prev" href="javascript: void(0)">';

                $html .= '<span class="arrow_carrot-left"></span>';

                $html .= '</a>';

                $html .= '</li>'; //close li.caroufredsel-prev-holder

                $html .= '<li class="caroufredsel-next-holder">';
                $html .= '<a class="mkd_carousel_next caroufredsel-next caroufredsel-navigation-item" id="caroufredsel-next" href="javascript: void(0)">';

                $html .= '<span class="arrow_carrot-right"></span>';

                $html .= '</a>';

                $html .= '</li>'; //close li.caroufredsel-next-holder

                $html .= '</ul>'; //close ul.caroufredsel-direction-nav
            }
            $html .= "</div></div>";

        }

        return $html;
    }
}

new MkdCarouselShortcode();