<?php


if ( ! function_exists( 'mikado_one_core_header_options_map' ) ) {
    function mikado_one_core_header_options_map() {
        $mkdFramework = mikado_one_mikado_return_framework();

        $headerPage = new MikadoAdminPage("2", "Header");
        $mkdFramework->mkdOptions->addAdminPage("header",$headerPage);

        // Header (Top Position)

        $panel_header_general = new MikadoPanel("General Settings","header_panel","vertical_area","yes");
        $headerPage->addChild("panel_header_general",$panel_header_general);

        	$header_in_grid = new MikadoField("yesno","header_in_grid","yes","Header in Grid","Enabling this option will display header content in grid");
        	$panel_header_general->addChild("header_in_grid",$header_in_grid);

        	$header_bottom_appearance = new MikadoField("select","header_bottom_appearance","fixed","Header Type","Choose the header layout & behavior", array( 
                "regular" => "Regular",
                "fixed" => "Fixed",
                "fixed_hiding" => "Fixed Advanced",
                "stick" => "Sticky",
                "stick menu_bottom" => "Sticky Expanded",
                "stick_with_left_right_menu" => "Sticky Divided"
              ),
              array("dependence" => true,
              	"hide" => array(
              		"regular"=>"#mkdf_menu_background_color_container,#mkdf_scroll_amount_for_sticky_container,#mkdf_header_height_scroll,#mkdf_header_height_sticky,#mkdf_header_height_scroll_hidden,#mkdf_header_background_color_scroll,#mkdf_header_background_color_sticky,#mkdf_header_background_transparency_scroll,#mkdf_header_background_transparency_sticky,#mkdf_scroll_amount_for_fixed_hiding_container",
        	        "fixed"=>"#mkdf_menu_background_color_container,#mkdf_scroll_amount_for_sticky_container,#mkdf_header_height_sticky,#mkdf_header_height_scroll_hidden,#mkdf_header_background_color_sticky,#mkdf_header_background_transparency_sticky,#mkdf_scroll_amount_for_fixed_hiding_container",
        	        "fixed_hiding"=>"#mkdf_scroll_amount_for_sticky_container,#mkdf_menu_position_container,#mkdf_header_height_scroll,#mkdf_header_height_sticky,#mkdf_header_background_color_sticky,#mkdf_header_background_transparency_sticky",
              		"stick menu_bottom"=>"#mkdf_menu_position_container,#mkdf_header_height_scroll,#mkdf_header_height_scroll_hidden,#mkdf_header_background_transparency_scroll,#mkdf_header_background_color_scroll,#mkdf_scroll_amount_for_fixed_hiding_container",
                    "stick_with_left_right_menu"=>"#mkdf_menu_background_color_container,#mkdf_menu_position_container,#mkdf_header_height_scroll,#mkdf_header_height_scroll_hidden,#mkdf_header_background_transparency_scroll,#mkdf_header_background_color_scroll,#mkdf_scroll_amount_for_fixed_hiding_container",
              		"stick"=>"#mkdf_menu_background_color_container,#mkdf_header_height_scroll,#mkdf_header_height_scroll_hidden,#mkdf_header_background_color_scroll,#mkdf_header_background_transparency_scroll,#mkdf_scroll_amount_for_fixed_hiding_container"),
              	"show" => array(
              		"regular"=>"#mkdf_menu_position_container",
              		"fixed"=>"#mkdf_menu_position_container,#mkdf_header_height_scroll,#mkdf_header_background_color_scroll,#mkdf_header_background_transparency_scroll",
              		"stick"=>"#mkdf_scroll_amount_for_sticky_container,#mkdf_menu_position_container,#mkdf_header_height_sticky,#mkdf_header_background_color_sticky,#mkdf_header_background_transparency_sticky",
              		"stick menu_bottom"=>"#mkdf_menu_background_color_container,#mkdf_scroll_amount_for_sticky_container,#mkdf_header_height_sticky,#mkdf_header_background_color_sticky,#mkdf_header_background_transparency_sticky",
                    "stick_with_left_right_menu"=>"#mkdf_scroll_amount_for_sticky_container,#mkdf_header_height_sticky,#mkdf_header_background_color_sticky,#mkdf_header_background_transparency_sticky",
              		"fixed_hiding"=>"#mkdf_menu_background_color_container,#mkdf_header_height_scroll_hidden,#mkdf_header_background_color_scroll,#mkdf_header_background_transparency_scroll,#mkdf_scroll_amount_for_fixed_hiding_container") ));
        	$panel_header_general->addChild("header_bottom_appearance",$header_bottom_appearance);

        	$scroll_amount_for_sticky_container = new MikadoContainer("scroll_amount_for_sticky_container","header_bottom_appearance","fixed", array( "regular","fixed","fixed_hiding") );
        	$panel_header_general->addChild("scroll_amount_for_sticky_container",$scroll_amount_for_sticky_container);

        		$scroll_amount_for_sticky = new MikadoField("text","scroll_amount_for_sticky","","Scroll Amount for Sticky (px)","Enter scroll amount (in pixels) for Sticky Menu to appear", array(), array("col_width" => 3));
        		$scroll_amount_for_sticky_container->addChild("scroll_amount_for_sticky",$scroll_amount_for_sticky);

            $scroll_amount_for_fixed_hiding_container = new MikadoContainer("scroll_amount_for_fixed_hiding_container","header_bottom_appearance","fixed", array( "regular","fixed","stick", "stick menu_bottom", "stick_with_left_right_menu") );
            $panel_header_general->addChild("scroll_amount_for_fixed_hiding_container",$scroll_amount_for_fixed_hiding_container);
                $scroll_amount_for_fixed_hiding = new MikadoField("text","scroll_amount_for_fixed_hiding","","Scroll Amount (px)","Enter scroll amount (in pixels) for menu to hide", array(), array("col_width" => 3));
                $scroll_amount_for_fixed_hiding_container->addChild("scroll_amount_for_fixed_hiding",$scroll_amount_for_fixed_hiding);

        	$menu_position_container = new MikadoContainer("menu_position_container","header_bottom_appearance","fixed_hiding", array( "stick menu_bottom","stick_with_left_right_menu","fixed_hiding") );
        	$panel_header_general->addChild("menu_position_container",$menu_position_container);

        		$menu_position = new MikadoField("select","menu_position","","Menu Position","Choose a menu position (default is right alignment)", array( "-1" => "Default",
               "center" => "Center","left" => "Left"
              ));
        		$menu_position_container->addChild("menu_position",$menu_position);

        	    $center_logo_image = new MikadoField("yesno","center_logo_image","no","Center Logo","Enabling this option will center logo and position it above menu", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_center_logo_image_container"));
        	    $menu_position_container->addChild("center_logo_image",$center_logo_image);

            	$center_logo_image_container = new MikadoContainer("center_logo_image_container","center_logo_image","no");
            	$menu_position_container->addChild("center_logo_image_container",$center_logo_image_container);

                $enable_border_top_bottom_menu = new MikadoField("yesno","enable_border_top_bottom_menu","no","Enable Top/Bottom Border in Menu","", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_menu_border_container"));
                $center_logo_image_container->addChild("enable_border_top_bottom_menu",$enable_border_top_bottom_menu);

                    $menu_border_container = new MikadoContainer("menu_border_container","enable_border_top_bottom_menu","no");
                    $center_logo_image_container->addChild("menu_border_container",$menu_border_container);

                        $color_border_top_bottom_menu = new MikadoField("color","color_border_top_bottom_menu","","Border Color","Choose a color for the top/bottom border in menu.");
                        $menu_border_container->addChild("color_border_top_bottom_menu",$color_border_top_bottom_menu);             

            $group1 = new MikadoGroup("Header Height","Enter header height in pixels");
            $panel_header_general->addChild("group1",$group1);

                $row1 = new MikadoRow();
                $group1->addChild("row1",$row1);

                    $header_height = new MikadoField("textsimple","header_height","","Initial (px)","Initial header (px)");
                    $row1->addChild("header_height",$header_height);

                    $header_height_scroll = new MikadoField("textsimple","header_height_scroll","","After Scroll (px)","This is some description", array(), array(),"header_bottom_appearance", array( "regular","stick","stick menu_bottom","stick_with_left_right_menu","fixed_hiding"));
                    $row1->addChild("header_height_scroll",$header_height_scroll);

                    $header_height_sticky = new MikadoField("textsimple","header_height_sticky","","After Scroll (px)","This is some description", array(), array(),"header_bottom_appearance", array( "regular","fixed","fixed_hiding"));
                    $row1->addChild("header_height_sticky",$header_height_sticky);

                    $header_height_scroll_hidden = new MikadoField("textsimple","header_height_scroll_hidden","","After Scroll (px)","This is some description", array(), array(),"header_bottom_appearance", array( "regular","fixed","stick","stick menu_bottom","stick_with_left_right_menu"));
                    $row1->addChild("header_height_scroll_hidden",$header_height_scroll_hidden);

            $group2 = new MikadoGroup("Header Background Color","Choose a background color for header area");
            $panel_header_general->addChild("group2",$group2);

                $row1 = new MikadoRow();
                $group2->addChild("row1",$row1);

                    $header_background_color = new MikadoField("colorsimple","header_background_color","","Initial","This is some description");
                    $row1->addChild("header_background_color",$header_background_color);

                    $header_background_color_scroll = new MikadoField("colorsimple","header_background_color_scroll","","After Scroll","This is some description", array(), array(),"header_bottom_appearance", array( "regular","stick","stick menu_bottom","stick_with_left_right_menu"));
                    $row1->addChild("header_background_color_scroll",$header_background_color_scroll);

                    $header_background_color_sticky = new MikadoField("colorsimple","header_background_color_sticky","","After Scroll","This is some description", array(), array(),"header_bottom_appearance", array( "regular","fixed","fixed_hiding"));
                    $row1->addChild("header_background_color_sticky",$header_background_color_sticky);

            $group3 = new MikadoGroup("Header Transparency","Choose a transparency for the header background color (0 = fully transparent, 1 = opaque)");
            $panel_header_general->addChild("group3",$group3);

                $row1 = new MikadoRow();
                $group3->addChild("row1",$row1);

                    $header_background_transparency_initial = new MikadoField("textsimple","header_background_transparency_initial","","Initial","This is some description");
                    $row1->addChild("header_background_transparency_initial",$header_background_transparency_initial);

                    $header_background_transparency_scroll = new MikadoField("textsimple","header_background_transparency_scroll","","After Scroll","This is some description", array(), array(),"header_bottom_appearance", array( "regular","stick","stick menu_bottom","stick_with_left_right_menu"));
                    $row1->addChild("header_background_transparency_scroll",$header_background_transparency_scroll);

                    $header_background_transparency_sticky = new MikadoField("textsimple","header_background_transparency_sticky","","After Scroll","This is some description", array(), array(),"header_bottom_appearance", array( "regular","fixed","fixed_hiding"));
                    $row1->addChild("header_background_transparency_sticky",$header_background_transparency_sticky);
        			
        	$header_style = new MikadoField("select","header_style","","Header Skin","Choose a header style to make header elements (logo, main menu, side menu button) in that predefined style", array(
                "-1" => "",
                "light" => "Light",
                "dark" => "Dark"
            ));
            $panel_header_general->addChild("header_style",$header_style);

            $enable_header_style_on_scroll = new MikadoField("yesno","enable_header_style_on_scroll","no","Enable Header Style on Scroll","Enabling this option, header will change style depending on row settings for dark/light style");
            $panel_header_general->addChild("enable_header_style_on_scroll",$enable_header_style_on_scroll);

            $header_left_right_padding = new MikadoField("text","header_left_right_padding","","Header padding (left and right)","Set left and right padding for header. Defaul value is 45px.", array(), array("col_width" => 3));
            $panel_header_general->addChild("header_left_right_padding",$header_left_right_padding);

            $disable_text_shadow_for_sticky = new MikadoField("yesno","disable_text_shadow_for_sticky","yes","Disable Bottom Shadow For Scrolled Header","Enabling this option will display bottom shadow for scrolled/sticky header");
            $panel_header_general->addChild("disable_text_shadow_for_sticky",$disable_text_shadow_for_sticky);

            $enable_header_top_border = new MikadoField("yesno","enable_header_top_border","no","Enable Header Top Border","", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_header_top_border_container"));
            $panel_header_general->addChild("enable_header_top_border",$enable_header_top_border);

                $header_top_border_container = new MikadoContainer("header_top_border_container","enable_header_top_border","no");
                $panel_header_general->addChild("header_top_border_container",$header_top_border_container);

                    $header_top_border_width = new MikadoField("text","header_top_border_width","","Header Top Border Width (px)","Choose a width for the header top border. Note: If width has not been set, border top will not be displayed", array(), array("col_width" => 3));
                    $header_top_border_container->addChild("header_top_border_width",$header_top_border_width);
        			
        			$header_top_border_color = new MikadoField("color","header_top_border_color","","Header Top Border Color","Choose a color for the header top border. ");
                    $header_top_border_container->addChild("header_top_border_color",$header_top_border_color);

                    $header_top_border_transparency = new MikadoField("text","header_top_border_transparency","","Header Top Border Transparency","Choose a transparency for the header border color (0 = fully transparent, 1 = opaque). Note: Works only if Header top Border Color is filled", array(), array("col_width" => 3));
                    $header_top_border_container->addChild("header_top_border_transparency",$header_top_border_transparency);
        	
        	$enable_header_bottom_border = new MikadoField("yesno","enable_header_bottom_border","no","Enable Header Bottom Border","", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_header_bottom_border_container"));
            $panel_header_general->addChild("enable_header_bottom_border",$enable_header_bottom_border);

                $header_bottom_border_container = new MikadoContainer("header_bottom_border_container","enable_header_bottom_border","no");
                $panel_header_general->addChild("header_bottom_border_container",$header_bottom_border_container);

                    $header_bottom_border_width = new MikadoField("text","header_bottom_border_width","","Header Bottom Border Width (px)","Choose a width for the header bottom  border. Note: If width has not been set, border bottom will not be displayed", array(), array("col_width" => 3));
                    $header_bottom_border_container->addChild("header_bottom_border_width",$header_bottom_border_width);
        			
        			$header_bottom_border_color = new MikadoField("color","header_bottom_border_color","","Header Bottom Border Color","Choose a color for the header bottom border.");
                    $header_bottom_border_container->addChild("header_bottom_border_color",$header_bottom_border_color);

                    $header_botom_border_transparency = new MikadoField("text","header_botom_border_transparency","","Header Bottom Border Transparency","Choose a transparency for the header border color (0 = fully transparent, 1 = opaque). Note: Works only if Header Bottom Border Color is filled", array(), array("col_width" => 3));
                    $header_bottom_border_container->addChild("header_botom_border_transparency",$header_botom_border_transparency);

                    $header_botom_border_in_grid = new MikadoField("yesno","header_botom_border_in_grid","no","Enable Header Bottom Border in Grid","Enabling this option will set header border bottom width in grid");
                    $header_bottom_border_container->addChild("header_botom_border_in_grid",$header_botom_border_in_grid);     

        // Menu

        $panel_menu = new MikadoPanel("Main Menu", "top_menu_panel","vertical_area","yes");
        $headerPage->addChild("panel_menu",$panel_menu);

        	$menu_first_level_styles = new MikadoTitle("menu_first_level_styles","First Level Menu");
        	$panel_menu->addChild("menu_first_level_styles",$menu_first_level_styles);

        	$menu_background_color_container = new MikadoContainer("menu_background_color_container","header_bottom_appearance","fixed", array( "regular","fixed","stick","stick_with_left_right_menu") );
        	$panel_menu->addChild("menu_background_color_container",$menu_background_color_container);
        	
        		$menu_background_color = new MikadoField("color","menu_background_color","","Background Color of 1st Level Menu","Choose a color for the menu background (works only for Fixed Advanced and Sticky Expanded header types)");
        		$menu_background_color_container->addChild("menu_background_color",$menu_background_color);
        		
        		$enable_menu_top_bottom_border = new MikadoField("yesno","enable_menu_top_bottom_border","no","Enable Top/Bottom Borders in 1st Level Menu","Enabling this option will display top and bottom borders around 1st level menu (works only for Fixed Advanced and Sticky Expanded header types)", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_menu_top_bottom_border_container"));
        		$menu_background_color_container->addChild("enable_menu_top_bottom_border",$enable_menu_top_bottom_border);
        			$menu_top_bottom_border_container = new MikadoContainer("menu_top_bottom_border_container","enable_menu_top_bottom_border","no");
        			$menu_background_color_container->addChild("menu_top_bottom_border_container",$menu_top_bottom_border_container);
        				$color_menu_top_bottom_border = new MikadoField("color","color_menu_top_bottom_border","","Border Color","Choose a color for the top/bottom border in 1st level menu.");
        				$menu_top_bottom_border_container->addChild("color_menu_top_bottom_border",$color_menu_top_bottom_border);
        		
        		$enable_menu_wide_background = new MikadoField("yesno","enable_menu_wide_background","no","Enable wide background in 1st Level Menu","Enabling this option will show wide background or borders in 1st level menu (works only for Fixed Advanced and Sticky Expanded header types)", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => ""));
        		$menu_background_color_container->addChild("enable_menu_wide_background",$enable_menu_wide_background);

        	$group3 = new MikadoGroup("1st Level Menu Style","Define styles for 1st level in Top Navigation Menu");
        	$panel_menu->addChild("group3",$group3);
        		$row1 = new MikadoRow(true);
        		$group3->addChild("row1",$row1);
        			$menu_color = new MikadoField("colorsimple","menu_color","","Text Color","This is some description");
        			$row1->addChild("menu_color",$menu_color);
        			$menu_hovercolor = new MikadoField("colorsimple","menu_hovercolor","","Hover Text Color","This is some description");
        			$row1->addChild("menu_hovercolor",$menu_hovercolor);
        			$menu_activecolor = new MikadoField("colorsimple","menu_activecolor","","Active Text Color","This is some description");
        			$row1->addChild("menu_activecolor",$menu_activecolor);
        		$row2 = new MikadoRow(true);
        		$group3->addChild("row2",$row2);
        			$menu_google_fonts = new MikadoField("Fontsimple","menu_google_fonts","-1","Font Family","This is some description");
        			$row2->addChild("menu_google_fonts",$menu_google_fonts);
        			$menu_fontsize = new MikadoField("textsimple","menu_fontsize","","Font Size (px)","This is some description");
        			$row2->addChild("menu_fontsize",$menu_fontsize);
        			$menu_lineheight = new MikadoField("textsimple","menu_lineheight","","Line Height (px)","This is some description");
        			$row2->addChild("menu_lineheight",$menu_lineheight);
        			$menu_padding_left_right = new MikadoField("textsimple","menu_padding_left_right","","Padding Left/Right(px)","This is some description");
        			$row2->addChild("menu_padding_left_right",$menu_padding_left_right);
        		$row3 = new MikadoRow(true);
        		$group3->addChild("row3",$row3);
        			$menu_fontstyle = new MikadoField("selectblanksimple","menu_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
        			$row3->addChild("menu_fontstyle",$menu_fontstyle);
        			$menu_fontweight = new MikadoField("selectblanksimple","menu_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
        			$row3->addChild("menu_fontweight",$menu_fontweight);
        			$menu_letterspacing = new MikadoField("textsimple","menu_letterspacing","","Letter Spacing (px)","This is some description");
        			$row3->addChild("menu_letterspacing",$menu_letterspacing);
        			$menu_texttransform = new MikadoField("selectblanksimple","menu_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
        			$row3->addChild("menu_texttransform",$menu_texttransform);
        			
        	$group10 = new MikadoGroup("1st Level Menu Background","Define background colors for 1st level in Top Navigation Menu");
        	$panel_menu->addChild("group10",$group10);
        		$row1 = new MikadoRow(true);
        		$group10->addChild("row1",$row1);
        			$menu_text_background_color = new MikadoField("colorsimple","menu_text_background_color","","Text Background Color","This is some description");
        			$row1->addChild("menu_text_background_color",$menu_text_background_color);
        		$row2 = new MikadoRow(true);
        		$group10->addChild("row2",$row2);
        			$menu_hover_background_color = new MikadoField("colorsimple","menu_hover_background_color","","Hover Text Background Color","This is some description");
        			$row2->addChild("menu_hover_background_color",$menu_hover_background_color);
        			$menu_hover_background_color_transparency = new MikadoField("textsimple","menu_hover_background_color_transparency","","Hover Background Color Transparency","This is some description");
        			$row2->addChild("menu_hover_background_color_transparency",$menu_hover_background_color_transparency);
        		$row3 = new MikadoRow(true);
        		$group10->addChild("row3",$row3);
        			$menu_active_background_color = new MikadoField("colorsimple","menu_active_background_color","","Active Text Background Color","This is some description");
        			$row3->addChild("menu_active_background_color",$menu_active_background_color);
        			$menu_active_background_color_transparency = new MikadoField("textsimple","menu_active_background_color_transparency","","Active Background Color Transparency","This is some description");
        			$row3->addChild("menu_active_background_color_transparency",$menu_active_background_color_transparency);
        			
        	$group9 = new MikadoGroup("1st Level Menu Light/Dark Style","Define light/dark styles for 1st level in Top Navigation Menu");
        	$panel_menu->addChild("group9",$group9);
        		$row1 = new MikadoRow(true);
        		$group9->addChild("row1",$row1);
        			$menu_light_hovercolor = new MikadoField("colorsimple","menu_light_hovercolor","","Light Menu Hover Text Color","This is some description");
        			$row1->addChild("menu_light_hovercolor",$menu_light_hovercolor);
        			$menu_light_activecolor = new MikadoField("colorsimple","menu_light_activecolor","","Light Menu Active Text Color","This is some description");
        			$row1->addChild("menu_light_activecolor",$menu_light_activecolor);
        		$row2 = new MikadoRow(true);
        		$group9->addChild("row2",$row2);
        			$menu_dark_hovercolor = new MikadoField("colorsimple","menu_dark_hovercolor","","Dark Menu Hover Text Color","This is some description");
        			$row2->addChild("menu_dark_hovercolor",$menu_dark_hovercolor);
        			$menu_dark_activecolor = new MikadoField("colorsimple","menu_dark_activecolor","","Dark Menu Active Text Color","This is some description");
        			$row2->addChild("menu_dark_activecolor",$menu_dark_activecolor);
        			
        	$menu_margin_left_right = new MikadoField("text","menu_margin_left_right","","Margin Left/Right (px)","Set item left and right margins", array(), array("col_width" => 3));
        	$panel_menu->addChild("menu_margin_left_right",$menu_margin_left_right);
        			
        	$menu_item_icon_position = new MikadoField("select","menu_item_icon_position","left","Icon Position in 1st Level Menu","Choose position of icon selected in Appearance->Menu->Menu Structure", array( 
        			"left" => "Left",
        			"top" => "Top"
        		),
        		array("dependence" => true, 
        			"hide" => array(
              		"left"=>"#mkdf_menu_item_icon_position_container"),
        			"show" => array(
              		"top"=>"#mkdf_menu_item_icon_position_container")
        		));	
        	$panel_menu->addChild("menu_item_icon_position",$menu_item_icon_position);
        	
        	$menu_item_icon_position_container = new MikadoContainer("menu_item_icon_position_container","menu_item_icon_position","left");
        	$panel_menu->addChild("menu_item_icon_position_container",$menu_item_icon_position_container);
        				
        		$menu_item_icon_size = new MikadoField("text","menu_item_icon_size","","Icon Size (px)","Enter icon size in pixels", array(), array("col_width" => 3));
        		$menu_item_icon_position_container->addChild("menu_item_icon_size",$menu_item_icon_size);

        	$menu_item_style = new MikadoField("select","menu_item_style","small_item","Item Height in 1st Level Menu","Visible if item background color or border is filled.", array( 
        			"small_item" => "Small",
        			"large_item" => "Big"
        		));
        	$panel_menu->addChild("menu_item_style",$menu_item_style);

        	$enable_manu_item_border = new MikadoField("yesno","enable_manu_item_border","no","Enable 1st Level Menu Item Borders","Enabling this option will display border around menu items", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_menu_item_border_container"));
        	$panel_menu->addChild("enable_manu_item_border",$enable_manu_item_border);
        	
            $menu_item_border_container = new MikadoContainer("menu_item_border_container","enable_manu_item_border","no");
        	$panel_menu->addChild("menu_item_border_container",$menu_item_border_container);
        			
        		$menu_item_border_style = new MikadoField("select","menu_item_border_style","","Menu Item Border Style","Visible only if border width and one of the border color fields are filled.", array( 
        			   "all_borders" => "All Borders",
        			   "top_bottom_borders" => "Top/Bottom Borders",
        			   "right_border" => "Right Border",
        			   "bottom_border" => "Bottom Border",
        			   "bottom_border_double" => "Bottom Double Borders"
        			  ),
        			array("dependence" => true,
        				"hide" => array(
        					"bottom_border_double"=>"#mkdf_menu_item_border_width_container"
        					),
        				"show" => array(
        					"all_borders"=>"#mkdf_menu_item_border_width_container",
        					"top_bottom_borders"=>"#mkdf_menu_item_border_width_container",
        					"right_border"=>"#mkdf_menu_item_border_width_container",
        					"bottom_border"=>"#mkdf_menu_item_border_width_container"
        				)
        			));
        		$menu_item_border_container->addChild("menu_item_border_style",$menu_item_border_style);
        			
        		$menu_item_border_width_container = new MikadoContainer("menu_item_border_width_container","menu_item_border_style","bottom_border_double");
        		$menu_item_border_container->addChild("menu_item_border_width_container",$menu_item_border_width_container);
        		
        			$menu_item_border_width = new MikadoField("text","menu_item_border_width","","Border Width (px)","Enter border width (in pixels) ", array(), array("col_width" => 3));
        			$menu_item_border_width_container->addChild("menu_item_border_width",$menu_item_border_width);
        			
        			$menu_item_border_radius = new MikadoField("text","menu_item_border_radius","","Border Radius (px)","Enter border radius (in pixels)", array(), array("col_width" => 3));
        			$menu_item_border_width_container->addChild("menu_item_border_radius",$menu_item_border_radius);

        		$group1 = new MikadoGroup("Border Color","Choose a color for border");
                $menu_item_border_container->addChild("group1",$group1);
                        
        			$row1 = new MikadoRow();
                    $group1->addChild("row1",$row1);
        				$menu_item_border_color = new MikadoField("colorsimple","menu_item_border_color","","Border Color","Choose border color");
        				$row1->addChild("menu_item_border_color",$menu_item_border_color);
        				$menu_item_hover_border_color = new MikadoField("colorsimple","menu_item_hover_border_color","","Border Hover Color","Choose border color on menu item hover");
        				$row1->addChild("menu_item_hover_border_color",$menu_item_hover_border_color);	
        				$menu_item_active_border_color = new MikadoField("colorsimple","menu_item_active_border_color","","Border Active Color","Choose border color on active menu item");
        				$row1->addChild("menu_item_active_border_color",$menu_item_active_border_color);	

        	$enable_menu_item_separators = new MikadoField("yesno","enable_menu_item_separators","no","Enable 1st Level Menu Item Separators","Enabling this option will display separators between menu items", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_menu_item_separators_container"));
        	$panel_menu->addChild("enable_menu_item_separators",$enable_menu_item_separators);
        	
            $menu_item_separators_container = new MikadoContainer("menu_item_separators_container","enable_menu_item_separators","no");
        	$panel_menu->addChild("menu_item_separators_container",$menu_item_separators_container);
        		
        	    $group1 = new MikadoGroup("Menu Item Separators Style","");
        	    $menu_item_separators_container->addChild("group1",$group1);
        	        $row1 = new MikadoRow();
        	        $group1->addChild("row1",$row1);
        			$menu_item_separators_color = new MikadoField("colorsimple","menu_item_separators_color","","Separators Color","Enter separators color");
        			$row1->addChild("menu_item_separators_color",$menu_item_separators_color);
        				
        	
        	$enable_menu_item_text_decoration = new MikadoField("yesno","enable_menu_item_text_decoration","no","Enable 1st Level Menu Item Text Decoration","Enabling this option will display text decoration", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_menu_item_text_decoration_container"));
        	$panel_menu->addChild("enable_menu_item_text_decoration",$enable_menu_item_text_decoration);
        	
        	$menu_item_text_decoration_container = new MikadoContainer("menu_item_text_decoration_container","enable_menu_item_text_decoration","no");
        	$panel_menu->addChild("menu_item_text_decoration_container",$menu_item_text_decoration_container);

        		$group1 = new MikadoGroup("Menu Item Text Decoration","");
        		$menu_item_text_decoration_container->addChild("group1",$group1);
        			$row1 = new MikadoRow();
        			$group1->addChild("row1",$row1);
        			$menu_item_text_decoration_style = new MikadoField("selectsimple","menu_item_text_decoration_style","none","Hover Item Text Decoration","Choose text decoration type for hover menu items", array( 
        			   "none" => "None",
        			   "underline" => "Underline",
        			   "line-through" => "Line-through",
        			   "overline" => "Overline"
        			  ));
        			$row1->addChild("menu_item_text_decoration_style",$menu_item_text_decoration_style);
        			$menu_item_active_text_decoration_style = new MikadoField("selectsimple","menu_item_active_text_decoration_style","none","Active Item Text Decoration","Choose text decoration type for active menu items", array( 
        			   "none" => "None",
        			   "underline" => "Underline",
        			   "line-through" => "Line-through",
        			   "overline" => "Overline"
        			  ));
        			$row1->addChild("menu_item_active_text_decoration_style",$menu_item_active_text_decoration_style);
        			
        	$menu_dropdown_styles = new MikadoTitle("menu_dropdown_styles","Dropdown Menu");
        	$panel_menu->addChild("menu_dropdown_styles",$menu_dropdown_styles);
        	
            $group1 = new MikadoGroup("Main Dropdown Menu","Choose a color and transparency for the main menu background (0 = fully transparent, 1 = opaque)");
            $panel_menu->addChild("group1",$group1);
                $row1 = new MikadoRow();
                $group1->addChild("row1",$row1);
                    $dropdown_background_color = new MikadoField("colorsimple","dropdown_background_color","","Background Color","This is some description");
                    $row1->addChild("dropdown_background_color",$dropdown_background_color);
                    $dropdown_background_transparency = new MikadoField("textsimple","dropdown_background_transparency","","Transparency","This is some description");
                    $row1->addChild("dropdown_background_transparency",$dropdown_background_transparency);
                    $dropdown_separator_color = new MikadoField("colorsimple","dropdown_separator_color","","Item Separator Bottom Color","This is some description");
                    $row1->addChild("dropdown_separator_color",$dropdown_separator_color);
        			$enable_dropdown_separator_full_width = new MikadoField("yesnosimple","enable_dropdown_separator_full_width","no","Item Separator Full Width","This is some description");
                    $row1->addChild("enable_dropdown_separator_full_width",$enable_dropdown_separator_full_width);
        		
        	$group2 = new MikadoGroup("Main Dropdown Menu Padding","Choose a top/bottom padding for dropdown menu");
            $panel_menu->addChild("group2",$group2);
                $row1 = new MikadoRow();
                $group2->addChild("row1",$row1);
                    $dropdown_top_padding = new MikadoField("textsimple","dropdown_top_padding","","Top Padding (px)","This is some description");
                    $row1->addChild("dropdown_top_padding",$dropdown_top_padding);
        			$dropdown_bottom_padding = new MikadoField("textsimple","dropdown_bottom_padding","","Bottom Padding (px)","This is some description");
                    $row1->addChild("dropdown_bottom_padding",$dropdown_bottom_padding);

        	$dropdown_top_position = new MikadoField("text","dropdown_top_position", "", "Dropdown Menu Position", "Enter value in percentage of entire header height", array(), array("col_width" => 3));
        	$panel_menu->addChild("dropdown_top_position", $dropdown_top_position);

            $enable_dropdown_top_separator = new MikadoField("yesno","enable_dropdown_top_separator","no","Enable Dropdown Top Separator","Enabling this option will display top separator for second level in dropdown menu", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_disable_dropdown_top_separator_container"));
            $panel_menu->addChild("enable_dropdown_top_separator",$enable_dropdown_top_separator);

            $disable_dropdown_top_separator_container = new MikadoContainer("disable_dropdown_top_separator_container","enable_dropdown_top_separator","no");
            $panel_menu->addChild("disable_dropdown_top_separator_container",$disable_dropdown_top_separator_container);

                $dropdown_top_separator_color = new MikadoField("color","dropdown_top_separator_color","","Dropdown Top Separator Color","Choose color for top separator");
        		$disable_dropdown_top_separator_container->addChild("dropdown_top_separator_color",$dropdown_top_separator_color);

            $dropdown_border_around = new MikadoField("yesno","dropdown_border_around","yes","Enable Dropdown Menu Border","Enabling this option will display border around dropdown menu", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_dropdown_border_around_container"));
            $panel_menu->addChild("dropdown_border_around",$dropdown_border_around);

            $dropdown_border_around_container = new MikadoContainer("dropdown_border_around_container","dropdown_border_around","no");
            $panel_menu->addChild("dropdown_border_around_container",$dropdown_border_around_container);

                $dropdown_border_around_color = new MikadoField("color","dropdown_border_around_color","","Dropdown Border Color","Choose a color for border around dropdown menu");
        		$dropdown_border_around_container->addChild("dropdown_border_around_color",$dropdown_border_around_color);

        	$menu_second_level_styles = new MikadoTitle("menu_second_level_styles","Second Level Menu");
        	$panel_menu->addChild("menu_second_level_styles",$menu_second_level_styles);
        	
        	$group4 = new MikadoGroup("2nd Level Menu Style","Define styles for 2nd level in Top Navigation Menu");
        	$panel_menu->addChild("group4",$group4);
        		$row1 = new MikadoRow();
        		$group4->addChild("row1",$row1);
        			$dropdown_color = new MikadoField("colorsimple","dropdown_color","","Text Color","This is some description");
        			$row1->addChild("dropdown_color",$dropdown_color);
        			$dropdown_hovercolor = new MikadoField("colorsimple","dropdown_hovercolor","","Hover/Active Color","This is some description");
        			$row1->addChild("dropdown_hovercolor",$dropdown_hovercolor);
        		$row2 = new MikadoRow(true);
        		$group4->addChild("row2",$row2);
        			$dropdown_google_fonts = new MikadoField("Fontsimple","dropdown_google_fonts","-1","Font Family","This is some description");
        			$row2->addChild("dropdown_google_fonts",$dropdown_google_fonts);
        			$dropdown_fontsize = new MikadoField("textsimple","dropdown_fontsize","","Font Size (px)","This is some description");
        			$row2->addChild("dropdown_fontsize",$dropdown_fontsize);
        			$dropdown_lineheight = new MikadoField("textsimple","dropdown_lineheight","","Line Height (px)","This is some description");
        			$row2->addChild("dropdown_lineheight",$dropdown_lineheight);
        			$dropdown_padding_top_bottom = new MikadoField("textsimple","dropdown_padding_top_bottom","","Padding Top/Bottom","This is some description");
        			$row2->addChild("dropdown_padding_top_bottom",$dropdown_padding_top_bottom);
        		$row3 = new MikadoRow(true);
        		$group4->addChild("row3",$row3);
        			$dropdown_fontstyle = new MikadoField("selectblanksimple","dropdown_fontstyle","","Font style","This is some description",mikado_one_mikado_options_font_style());
        			$row3->addChild("dropdown_fontstyle",$dropdown_fontstyle);
        			$dropdown_fontweight = new MikadoField("selectblanksimple","dropdown_fontweight","","Font weight","This is some description",mikado_one_mikado_options_font_weight());
        			$row3->addChild("dropdown_fontweight",$dropdown_fontweight);
        			$dropdown_letterspacing = new MikadoField("textsimple","dropdown_letterspacing","","Letter spacing (px)","This is some description");
        			$row3->addChild("dropdown_letterspacing",$dropdown_letterspacing);
        			$dropdown_texttransform = new MikadoField("selectblanksimple","dropdown_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
        			$row3->addChild("dropdown_texttransform",$dropdown_texttransform);
        			
        	$group5 = new MikadoGroup("2nd Level Wide Menu Style","Define styles for 2nd level in Wide Menu");
        	$panel_menu->addChild("group5",$group5);
        		$row1 = new MikadoRow();
        		$group5->addChild("row1",$row1);
        			$dropdown_wide_color = new MikadoField("colorsimple","dropdown_wide_color","","Text Color","This is some description");
        			$row1->addChild("dropdown_wide_color",$dropdown_wide_color);
        			$dropdown_wide_hovercolor = new MikadoField("colorsimple","dropdown_wide_hovercolor","","Hover Text Color","This is some description");
        			$row1->addChild("dropdown_wide_hovercolor",$dropdown_wide_hovercolor);
        		$row2 = new MikadoRow(true);
        		$group5->addChild("row2",$row2);
        			$dropdown_wide_google_fonts = new MikadoField("Fontsimple","dropdown_wide_google_fonts","-1","Font Family","This is some description");
        			$row2->addChild("dropdown_wide_google_fonts",$dropdown_wide_google_fonts);
        			$dropdown_wide_fontsize = new MikadoField("textsimple","dropdown_wide_fontsize","","Font Size (px)","This is some description");
        			$row2->addChild("dropdown_wide_fontsize",$dropdown_wide_fontsize);
        			$dropdown_wide_lineheight = new MikadoField("textsimple","dropdown_wide_lineheight","","Line Height (px)","This is some description");
        			$row2->addChild("dropdown_wide_lineheight",$dropdown_wide_lineheight);
        		$row3 = new MikadoRow(true);
        		$group5->addChild("row3",$row3);
        			$dropdown_wide_fontstyle = new MikadoField("selectblanksimple","dropdown_wide_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
        			$row3->addChild("dropdown_wide_fontstyle",$dropdown_wide_fontstyle);
        			$dropdown_wide_fontweight = new MikadoField("selectblanksimple","dropdown_wide_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
        			$row3->addChild("dropdown_wide_fontweight",$dropdown_wide_fontweight);
        			$dropdown_wide_letterspacing = new MikadoField("textsimple","dropdown_wide_letterspacing","","Letter Spacing (px)","This is some description");
        			$row3->addChild("dropdown_wide_letterspacing",$dropdown_wide_letterspacing);
        			$dropdown_wide_texttransform = new MikadoField("selectblanksimple","dropdown_wide_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
        			$row3->addChild("dropdown_wide_texttransform",$dropdown_wide_texttransform);

        	$menu_third_level_styles = new MikadoTitle("menu_third_level_styles","Third Level Menu");
        	$panel_menu->addChild("menu_third_level_styles",$menu_third_level_styles);

        	$group6 = new MikadoGroup("3rd Level Menu Style","Define styles for 3nd level in Top Navigation Menu");
        	$panel_menu->addChild("group6",$group6);
        		$row1 = new MikadoRow();
        		$group6->addChild("row1",$row1);
        			$dropdown_color_thirdlvl = new MikadoField("colorsimple","dropdown_color_thirdlvl","","Text Color","This is some description");
        			$row1->addChild("dropdown_color_thirdlvl",$dropdown_color_thirdlvl);
        			$dropdown_hovercolor_thirdlvl = new MikadoField("colorsimple","dropdown_hovercolor_thirdlvl","","Hover/Active Color","This is some description");
        			$row1->addChild("dropdown_hovercolor_thirdlvl",$dropdown_hovercolor_thirdlvl);
        		$row2 = new MikadoRow(true);
        		$group6->addChild("row2",$row2);
        			$dropdown_google_fonts_thirdlvl = new MikadoField("Fontsimple","dropdown_google_fonts_thirdlvl","-1","Font Family","This is some description");
        			$row2->addChild("dropdown_google_fonts_thirdlvl",$dropdown_google_fonts_thirdlvl);
        			$dropdown_fontsize_thirdlvl = new MikadoField("textsimple","dropdown_fontsize_thirdlvl","","Font Size (px)","This is some description");
        			$row2->addChild("dropdown_fontsize_thirdlvl",$dropdown_fontsize_thirdlvl);
        			$dropdown_lineheight_thirdlvl = new MikadoField("textsimple","dropdown_lineheight_thirdlvl","","Line Height (px)","This is some description");
        			$row2->addChild("dropdown_lineheight_thirdlvl",$dropdown_lineheight_thirdlvl);
        		$row3 = new MikadoRow(true);
        		$group6->addChild("row3",$row3);
        			$dropdown_fontstyle_thirdlvl = new MikadoField("selectblanksimple","dropdown_fontstyle_thirdlvl","","Font Style","This is some description",mikado_one_mikado_options_font_style());
        			$row3->addChild("dropdown_fontstyle_thirdlvl",$dropdown_fontstyle_thirdlvl);
        			$dropdown_fontweight_thirdlvl = new MikadoField("selectblanksimple","dropdown_fontweight_thirdlvl","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
        			$row3->addChild("dropdown_fontweight_thirdlvl",$dropdown_fontweight_thirdlvl);
        			$dropdown_letterspacing_thirdlvl = new MikadoField("textsimple","dropdown_letterspacing_thirdlvl","","Letter Spacing (px)","This is some description");
        			$row3->addChild("dropdown_letterspacing",$dropdown_letterspacing_thirdlvl);
        			$dropdown_texttransform_thirdlvl = new MikadoField("selectblanksimple","dropdown_texttransform_thirdlvl","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
        			$row3->addChild("dropdown_texttransform_thirdlvl",$dropdown_texttransform_thirdlvl);

        	$menu_fixed_styles = new MikadoTitle("menu_fixed_styles","Fixed Menu");
        	$panel_menu->addChild("menu_fixed_styles",$menu_fixed_styles);
        	
        	$group7 = new MikadoGroup("Fixed Menu Style","This is some description");
        	$panel_menu->addChild("group7",$group7);
        		$row1 = new MikadoRow();
        		$group7->addChild("row1",$row1);
        			$fixed_color = new MikadoField("colorsimple","fixed_color","","Text Color","This is some description");
        			$row1->addChild("fixed_color",$fixed_color);
        			$fixed_hovercolor = new MikadoField("colorsimple","fixed_hovercolor","","Hover/Active Color","This is some description");
        			$row1->addChild("fixed_hovercolor",$fixed_hovercolor);
        		$row2 = new MikadoRow(true);
        		$group7->addChild("row2",$row2);
        			$fixed_google_fonts = new MikadoField("Fontsimple","fixed_google_fonts","-1","Font Family","This is some description");
        			$row2->addChild("fixed_google_fonts",$fixed_google_fonts);
        			$fixed_fontsize = new MikadoField("textsimple","fixed_fontsize","","Font Size (px)","This is some description");
        			$row2->addChild("fixed_fontsize",$fixed_fontsize);
        			$fixed_lineheight = new MikadoField("textsimple","fixed_lineheight","","Line height (px)","This is some description");
        			$row2->addChild("fixed_lineheight",$fixed_lineheight);
        			$fixed_texttransform = new MikadoField("selectblanksimple","fixed_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
        			$row2->addChild("fixed_texttransform",$fixed_texttransform);
        		$row3 = new MikadoRow(true);
        		$group7->addChild("row3",$row3);
        			$fixed_fontstyle = new MikadoField("selectblanksimple","fixed_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
        			$row3->addChild("fixed_fontstyle",$fixed_fontstyle);
        			$fixed_fontweight = new MikadoField("selectblanksimple","fixed_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
        			$row3->addChild("fixed_fontweight",$fixed_fontweight);
        			$fixed_letterspacing = new MikadoField("textsimple","fixed_letterspacing","","Letter Spacing (px)","This is some description");
        			$row3->addChild("fixed_letterspacing",$fixed_letterspacing);

        	$menu_sticky_styles = new MikadoTitle("menu_sticky_styles","Sticky Menu");
        	$panel_menu->addChild("menu_sticky_styles",$menu_sticky_styles);
        	
        	$group8 = new MikadoGroup("Sticky Menu Style","This is some description");
        	$panel_menu->addChild("group8",$group8);
        		$row1 = new MikadoRow();
        		$group8->addChild("row1",$row1);
                    $sticky_color = new MikadoField("colorsimple","sticky_color","","Text Color","This is some description");
        			$row1->addChild("sticky_color",$sticky_color);
        			$sticky_hovercolor = new MikadoField("colorsimple","sticky_hovercolor","","Hover/Active color","This is some description");
        			$row1->addChild("sticky_hovercolor",$sticky_hovercolor);
        		$row2 = new MikadoRow(true);
        		$group8->addChild("row2",$row2);
        			$sticky_google_fonts = new MikadoField("Fontsimple","sticky_google_fonts","-1","Font family","This is some description");
        			$row2->addChild("sticky_google_fonts",$sticky_google_fonts);
        			$sticky_fontsize = new MikadoField("textsimple","sticky_fontsize","","Font size (px)","This is some description");
        			$row2->addChild("sticky_fontsize",$sticky_fontsize);
        			$sticky_lineheight = new MikadoField("textsimple","sticky_lineheight","","Line height (px)","This is some description");
        			$row2->addChild("sticky_lineheight",$sticky_lineheight);
        			$sticky_texttransform = new MikadoField("selectblanksimple","sticky_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
        			$row2->addChild("sticky_texttransform",$sticky_texttransform);
        		$row3 = new MikadoRow(true);
        		$group8->addChild("row3",$row3);
        			$sticky_fontstyle = new MikadoField("selectblanksimple","sticky_fontstyle","","Font style","This is some description",mikado_one_mikado_options_font_style());
        			$row3->addChild("sticky_fontstyle",$sticky_fontstyle);
        			$sticky_fontweight = new MikadoField("selectblanksimple","sticky_fontweight","","Font weight","This is some description",mikado_one_mikado_options_font_weight());
        			$row3->addChild("sticky_fontweight",$sticky_fontweight);
        			$sticky_letterspacing = new MikadoField("textsimple","sticky_letterspacing","","Letter Spacing (px)","This is some description");
        			$row3->addChild("sticky_letterspacing",$sticky_letterspacing);
        			
        // Header Top

        $panel_header_top = new MikadoPanel("Header Top Area","header_top_panel","vertical_area","yes");
        $headerPage->addChild("panel_header_top",$panel_header_top);

            $header_top_area = new MikadoField("yesno","header_top_area","no","Show Header Top Area","Enabling this option will show Header Top area (this setting applies to Header Left and Header Right widgets)
            ", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_header_top_area_container"));
            $panel_header_top->addChild("header_top_area",$header_top_area);

            $header_top_area_container = new MikadoContainer("header_top_area_container","header_top_area","no");
            $panel_header_top->addChild("header_top_area_container",$header_top_area_container);

                $header_top_area_scroll = new MikadoField("yesno","header_top_area_scroll","no","Hide on Scroll","Enabling this option will hide Header Top on scroll (if Fixed, Sticky or Sticky Expanded menu is chosen)");
                $header_top_area_container->addChild("header_top_area_scroll",$header_top_area_scroll);

                $header_top_background_color = new MikadoField("color","header_top_background_color","","Background Color","Choose a background color for Header Top area");
                $header_top_area_container->addChild("header_top_background_color",$header_top_background_color);

                $top_header_border_color = new MikadoField("color","top_header_border_color","","Border Bottom Color","This is some description");
                $header_top_area_container->addChild("top_header_border_color",$top_header_border_color);

                $top_header_border_weight = new MikadoField("text","top_header_border_weight","","Border Width (px)","This is some description",array(), array("col_width" => 3));
                $header_top_area_container->addChild("top_header_border_weight",$top_header_border_weight);
                
        	$group8 = new MikadoGroup("Header Top Style","Define styles for Header Top area");
        	$header_top_area_container->addChild("group8",$group8);
        		$row1 = new MikadoRow();
        		$group8->addChild("row1",$row1);
        			$top_header_text_color = new MikadoField("colorsimple","top_header_text_color","","Text Color","This is some description");
        			$row1->addChild("top_header_text_color",$top_header_text_color);
        			$top_header_text_hover_color = new MikadoField("colorsimple","top_header_text_hover_color","","Hover Text Color","This is some description");
        			$row1->addChild("top_header_text_hover_color",$top_header_text_hover_color);
        		$row2 = new MikadoRow(true);
        		$group8->addChild("row2",$row2);
        			$top_header_text_font_family = new MikadoField("Fontsimple","top_header_text_font_family","-1","Font Family","This is some description");
        			$row2->addChild("top_header_text_font_family",$top_header_text_font_family);
        			$top_header_text_font_size = new MikadoField("textsimple","top_header_text_font_size","","Font Size (px)","This is some description");
        			$row2->addChild("top_header_text_font_size",$top_header_text_font_size);
        			$top_header_text_line_height = new MikadoField("textsimple","top_header_text_line_height","","Line Height (max 35 px)","This is some description");
        			$row2->addChild("top_header_text_line_height",$top_header_text_line_height);
        		$row3 = new MikadoRow(true);
        		$group8->addChild("row3",$row3);
        		$group8->addChild("row3",$row3);
        			$top_header_text_font_style = new MikadoField("selectblanksimple","top_header_text_font_style","","Font Style","This is some description",mikado_one_mikado_options_font_style());
        			$row3->addChild("top_header_text_font_style",$top_header_text_font_style);
        			$top_header_text_font_weight = new MikadoField("selectblanksimple","top_header_text_font_weight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
        			$row3->addChild("top_header_text_font_weight",$top_header_text_font_weight);
        			$top_header_text_letter_spacing = new MikadoField("textsimple","top_header_text_letter_spacing","","Letter Spacing (px)","This is some description");
        			$row3->addChild("top_header_text_letter_spacing",$top_header_text_letter_spacing);

        // Additional Features

        $panel_additional_features = new MikadoPanel("Additional Features","panel_additional_features","vertical_area","yes");
        $headerPage->addChild("panel_additional_features",$panel_additional_features);

        	$group1 = new MikadoGroup("Header Icons Style","Define styles for header icons (Search Icon, Fullscreen Menu Icon and Side Area Icon)");
            $panel_additional_features->addChild("group1",$group1);

                $row1 = new MikadoRow(true);
                $group1->addChild("row1",$row1);
        			$header_buttons_color = new MikadoField("colorsimple","header_buttons_color","","Color","Choose a color for Header icons");
        			$row1->addChild("header_buttons_color",$header_buttons_color);
        			$header_buttons_hover_color = new MikadoField("colorsimple","header_buttons_hover_color","","Hover Color","Choose a hover color for Header icons");
        			$row1->addChild("header_buttons_hover_color",$header_buttons_hover_color);

        	$header_buttons_font_size = new MikadoField("text","header_buttons_font_size","","Side Area Icon / Search Icon Size","Choose a size for Side Area / Search icons (px)", array(), array("col_width" => 3));
        	$panel_additional_features->addChild("header_buttons_font_size",$header_buttons_font_size);

        	$header_buttons_size = new MikadoField("select","header_buttons_size","normal","Fullscreen Menu Icon Size","Choose predefined size for Fullscreen Menu icon", array( "normal" => "Normal",
        		   "medium" => "Medium",
        		   "large" => "Large"
        		  ));
        	$panel_additional_features->addChild("header_buttons_size",$header_buttons_size); 
        	
        	$group2 = new MikadoGroup("Fullscreen Menu Icon Backround","Define background for header icon that opens fullscreen menu");
            $panel_additional_features->addChild("group2",$group2);

                $row1 = new MikadoRow(true);
                $group2->addChild("row1",$row1);	
        			$header_buttons_fullscreen_button_background = new MikadoField("colorsimple","header_buttons_fullscreen_button_background","","Background Color","Choose a background color for Fullscreen Menu icon");
        			$row1->addChild("header_buttons_fullscreen_button_background",$header_buttons_fullscreen_button_background); 
        			$header_buttons_fullscreen_button_background_hover = new MikadoField("colorsimple","header_buttons_fullscreen_button_background_hover","","Background Hover Color","Choose a background hover color for Fullscreen Menu icon");
        			$row1->addChild("header_buttons_fullscreen_button_background_hover",$header_buttons_fullscreen_button_background_hover); 
        	
        	$title_mikado_search = new MikadoTitle("title_mikado_search", "Mikado Search");
        	$panel_additional_features->addChild("title_mikado_search", $title_mikado_search);
        	
            $enable_search = new MikadoField("yesno","enable_search","no","Enable Mikado Search Bar","This option enables Mikado Search functionality (search icon will appear next to main navigation)",
            	array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_enable_search_container"));
            $panel_additional_features->addChild("enable_search",$enable_search);

            $enable_search_container = new MikadoContainer("enable_search_container","enable_search","no");
            $panel_additional_features->addChild("enable_search_container",$enable_search_container);
        		
        		$search_type = new MikadoField("select","search_type","search_slides_from_header_bottom","Mikado Search Type","Choose a type of Mikado search bar (Note: Slide From Header Bottom search type doesn't work with transparent header)", array(
        			"search_slides_from_header_bottom" => "Slide From Header Bottom",
        			"search_covers_header" => "Search Covers Header"
        		),
        		array("dependence" => true,
        			"hide" => array(
        				"search_covers_header"=>"#mkdf_search_height_container"
        				),
        			"show" => array(
        				"search_slides_from_header_bottom"=>"#mkdf_search_height_container"
        			)
        		));
        		$enable_search_container->addChild("search_type",$search_type);

                $search_height_container = new MikadoContainer("search_height_container","search_type","search_covers_header");
                $enable_search_container->addChild("search_height_container",$search_height_container);

                    $search_height= new MikadoField("text","search_height","","Search bar height","Set search bar height (in pixels)",  array(), array("col_width" => 3));
                    $search_height_container->addChild("search_height",$search_height);
        		
        			$search_background_color = new MikadoField("color","search_background_color","","Background Color","Choose a background color for Mikado search bar");
        			$enable_search_container->addChild("search_background_color",$search_background_color);

        		$group1 = new MikadoGroup("Search Text","Define Style for Search text");
        		$enable_search_container->addChild("group1",$group1);
        			$row1 = new MikadoRow();
        			$group1->addChild("row1",$row1);
        				$search_text_color = new MikadoField("colorsimple","search_text_color","","Text Color","This is some description");
        				$row1->addChild("search_text_color",$search_text_color);
        				$search_text_disabled_color = new MikadoField("colorsimple","search_text_disabled_color","","Disabled Text Color","This is some description");
        				$row1->addChild("search_text_disabled_color",$search_text_disabled_color);
        				$search_text_fontsize = new MikadoField("textsimple","search_text_fontsize","","Font Size (px)","This is some description");
        				$row1->addChild("search_text_fontsize",$search_text_fontsize);
        				$search_text_texttransform = new MikadoField("selectblanksimple","search_text_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
        				$row1->addChild("search_text_texttransform",$search_text_texttransform);
        				
        			$row2 = new MikadoRow(true);
        			$group1->addChild("row2",$row2);
        				$search_text_google_fonts = new MikadoField("Fontsimple","search_text_google_fonts","-1","Font Family","This is some description");
        				$row2->addChild("search_text_google_fonts",$search_text_google_fonts);
        				$search_text_fontstyle = new MikadoField("selectblanksimple","search_text_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
        				$row2->addChild("search_text_fontstyle",$search_text_fontstyle);
        				$search_text_fontweight = new MikadoField("selectblanksimple","search_text_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
        				$row2->addChild("search_text_fontweight",$search_text_fontweight);
        				$search_text_letterspacing = new MikadoField("textsimple","search_text_letterspacing","","Letter Spacing (px)","This is some description");
        				$row2->addChild("search_text_letterspacing",$search_text_letterspacing);
        			
        		$group2 = new MikadoGroup("Search Icon","Define Style for Search icon");
        		$enable_search_container->addChild("group2",$group2);
        			$row1 = new MikadoRow();
        			$group2->addChild("row1",$row1);
        				$search_icon_color = new MikadoField("colorsimple","search_icon_color","","Icon Color","Choose icon color for Mikado search bar");
        				$row1->addChild("search_icon_color",$search_icon_color);
        				$search_icon_hover_color = new MikadoField("colorsimple","search_icon_hover_color","","Icon Hover Color","Choose icon hover color for Mikado search bar");
        				$row1->addChild("search_icon_hover_color",$search_icon_hover_color);
        				$search_icon_disabled_color = new MikadoField("colorsimple","search_icon_disabled_color","","Icon Disabled Color","Choose icon disabled color for Mikado search bar");
        				$row1->addChild("search_icon_disabled_color",$search_icon_disabled_color);
        				$search_icon_size= new MikadoField("textsimple","search_icon_size","","Icon Size","Set size for icon (ix pixels)",  array(), array("col_width" => 3));
        				$row1->addChild("search_icon_size",$search_icon_size);
        	
        	$title_side_area = new MikadoTitle("title_side_area", "Side Area");
        	$panel_additional_features->addChild("title_side_area", $title_side_area);
        	
            $enable_side_area = new MikadoField("yesno","enable_side_area","yes","Enable Side Area","This option enables a side area to be opened from main menu navigation", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_enable_side_area_container"));
            $panel_additional_features->addChild("enable_side_area",$enable_side_area);

            $enable_side_area_container = new MikadoContainer("enable_side_area_container","enable_side_area","no");
            $panel_additional_features->addChild("enable_side_area_container",$enable_side_area_container);
        		
        		$side_area_type = new MikadoField("select","side_area_type","side_menu_slide_from_right","Side Area Type","Choose a type of Side Area", array(
        				"side_menu_slide_from_right" => "Slide from right over content",
        				"side_menu_slide_with_content" => "Slide from right with content"
        			),
        			array("dependence" => true,
        			"hide" => array(
              		"side_menu_slide_with_content"=>"#mkdf_side_area_width_container"),
        			"show" => array(
              		"side_menu_slide_from_right"=>"#mkdf_side_area_width_container")
        			));
        		$enable_side_area_container->addChild("side_area_type",$side_area_type);
        		
        		$side_area_width_container = new MikadoContainer("side_area_width_container","side_area_type","side_menu_slide_with_content");
        		$enable_side_area_container->addChild("side_area_width_container",$side_area_width_container);
        	
        			$side_area_width = new MikadoField("text","side_area_width","","Side Area Width","Enter a width for Side Area (in percentages, enter more than 30)", array(), array("col_width" => 3));
        			$side_area_width_container->addChild("side_area_width",$side_area_width);
        			
        			$side_area_content_overlay_color= new MikadoField("color","side_area_content_overlay_color","","Content Overlay Background Color","Choose a background color for a content overlay", array(), array("col_width" => 3));
        			$side_area_width_container->addChild("side_area_content_overlay_color",$side_area_content_overlay_color);
        			
        			$side_area_content_overlay_opacity = new MikadoField("text","side_area_content_overlay_opacity","","Content Overlay Background Transparency","Choose a transparency for the content overlay background color (0 = fully transparent, 1 = opaque)", array(), array("col_width" => 3));
        			$side_area_width_container->addChild("side_area_content_overlay_opacity",$side_area_content_overlay_opacity);

        		$side_area_aligment = new MikadoField("selectblank","side_area_aligment","","Text Aligment","Choose text aligment for side area", array(
        				"center" => "Center",
        				"left" => "Left",
        				"right" => "Right"
        				
        			));
        		$enable_side_area_container->addChild("side_area_aligment",$side_area_aligment);
        		
                $side_area_title = new MikadoField("text","side_area_title","","Side Area Title","Enter a title to appear in Side Area", array(), array("col_width" => 3));
                $enable_side_area_container->addChild("side_area_title",$side_area_title);

                $side_area_background_color = new MikadoField("color","side_area_background_color","","Background Color","Choose a background color for Side Area");
                $enable_side_area_container->addChild("side_area_background_color",$side_area_background_color);
        		
        		$side_area_close_icon = new MikadoField("select","side_area_close_icon","light","Close Icon Style","Choose a type of close icon", array(
        				"light" => "Light",
        				"dark" => "Dark"
        			));
        		$enable_side_area_container->addChild("side_area_close_icon",$side_area_close_icon);

                $group1 = new MikadoGroup("Title","Define Style for Side Area title");
                $enable_side_area_container->addChild("group1",$group1);
                    $row1 = new MikadoRow();
                    $group1->addChild("row1",$row1);
                        $side_area_title_color = new MikadoField("colorsimple","side_area_title_color","","Text Color","This is some description");
                        $row1->addChild("side_area_title_color",$side_area_title_color);
                        $side_area_title_fontsize = new MikadoField("textsimple","side_area_title_fontsize","","Font Size (px)","This is some description");
                        $row1->addChild("side_area_title_fontsize",$side_area_title_fontsize);
                        $side_area_title_lineheight = new MikadoField("textsimple","side_area_title_lineheight","","Line Height (px)","This is some description");
                        $row1->addChild("side_area_title_lineheight",$side_area_title_lineheight);
                        $side_area_title_texttransform = new MikadoField("selectblanksimple","side_area_title_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
                        $row1->addChild("side_area_title_texttransform",$side_area_title_texttransform);
                    $row2 = new MikadoRow(true);
                    $group1->addChild("row2",$row2);
                        $side_area_title_google_fonts = new MikadoField("Fontsimple","side_area_title_google_fonts","-1","Font Family","This is some description");
                        $row2->addChild("side_area_title_google_fonts",$side_area_title_google_fonts);
                        $side_area_title_fontstyle = new MikadoField("selectblanksimple","side_area_title_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
                        $row2->addChild("side_area_title_fontstyle",$side_area_title_fontstyle);
                        $side_area_title_fontweight = new MikadoField("selectblanksimple","side_area_title_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
                        $row2->addChild("side_area_title_fontweight",$side_area_title_fontweight);
                        $side_area_title_letterspacing = new MikadoField("textsimple","side_area_title_letterspacing","","Letter Spacing (px)","This is some description");
                        $row2->addChild("side_area_title_letterspacing",$side_area_title_letterspacing);

        		$group3 = new MikadoGroup("Text","Define Style for Side Area text");
                $enable_side_area_container->addChild("group3",$group3);
                    $row1 = new MikadoRow();
                    $group3->addChild("row1",$row1);
                        $side_area_text_color = new MikadoField("colorsimple","side_area_text_color","","Text Color","This is some description");
                        $row1->addChild("side_area_text_color",$side_area_text_color);
                        $side_area_text_fontsize = new MikadoField("textsimple","side_area_text_fontsize","","Font Size (px)","This is some description");
                        $row1->addChild("side_area_text_fontsize",$side_area_text_fontsize);
                        $side_area_text_lineheight = new MikadoField("textsimple","side_area_text_lineheight","","Line Height (px)","This is some description");
                        $row1->addChild("side_area_text_lineheight",$side_area_text_lineheight);
                        $side_area_text_texttransform = new MikadoField("selectblanksimple","side_area_text_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
                        $row1->addChild("side_area_text_texttransform",$side_area_text_texttransform);
                    $row2 = new MikadoRow(true);
                    $group3->addChild("row2",$row2);
                        $side_area_text_google_fonts = new MikadoField("Fontsimple","side_area_text_google_fonts","-1","Font Family","This is some description");
                        $row2->addChild("side_area_text_google_fonts",$side_area_text_google_fonts);
                        $side_area_text_fontstyle = new MikadoField("selectblanksimple","side_area_text_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
                        $row2->addChild("side_area_text_fontstyle",$side_area_text_fontstyle);
                        $side_area_text_fontweight = new MikadoField("selectblanksimple","side_area_text_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
                        $row2->addChild("side_area_text_fontweight",$side_area_text_fontweight);
                        $side_area_text_letterspacing = new MikadoField("textsimple","side_area_text_letterspacing","","Letter Spacing (px)","This is some description");
                        $row2->addChild("side_area_text_letterspacing",$side_area_text_letterspacing);

                $group2 = new MikadoGroup("Link Style","Define styles for side area widget links");
                $enable_side_area_container->addChild("group2",$group2);
                    $row1 = new MikadoRow();
                    $group2->addChild("row1",$row1);
                        $sidearea_link_color = new MikadoField("colorsimple","sidearea_link_color","","Text Color","This is some description");
                        $row1->addChild("sidearea_link_color",$sidearea_link_color);
                        $sidearea_link_font_size = new MikadoField("textsimple","sidearea_link_font_size","","Font Size (px)","This is some description");
                        $row1->addChild("sidearea_link_font_size",$sidearea_link_font_size);
                        $sidearea_link_line_height = new MikadoField("textsimple","sidearea_link_line_height","","Line Height (px)","This is some description");
                        $row1->addChild("sidearea_link_line_height",$sidearea_link_line_height);
                        $sidearea_link_text_transform = new MikadoField("selectblanksimple","sidearea_link_text_transform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
                        $row1->addChild("sidearea_link_text_transform",$sidearea_link_text_transform);
                    $row2 = new MikadoRow(true);
                    $group2->addChild("row2",$row2);
                        $sidearea_link_font_family = new MikadoField("Fontsimple","sidearea_link_font_family","-1","Font Family","This is some description");
                        $row2->addChild("sidearea_link_font_family",$sidearea_link_font_family);
                        $sidearea_link_font_style = new MikadoField("selectblanksimple","sidearea_link_font_style","","Font Style","This is some description",mikado_one_mikado_options_font_style());
                        $row2->addChild("sidearea_link_font_style",$sidearea_link_font_style);
                        $sidearea_link_font_weight = new MikadoField("selectblanksimple","sidearea_link_font_weight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
                        $row2->addChild("sidearea_link_font_weight",$sidearea_link_font_weight);
                        $sidearea_link_letter_spacing = new MikadoField("textsimple","sidearea_link_letter_spacing","","Letter Spacing (px)","This is some description");
                        $row2->addChild("sidearea_link_letter_spacing",$sidearea_link_letter_spacing);
                    $row3 = new MikadoRow(true);  
                    $group2->addChild("row3",$row3);
                        $sidearea_link_hover_color = new MikadoField("colorsimple","sidearea_link_hover_color","","Hover Color","This is some description");
                        $row3->addChild("sidearea_link_hover_color",$sidearea_link_hover_color);  
        	
        	$title_fullscreen_menu = new MikadoTitle("title_fullscreen_menu", "Fullscreen Menu");
        	$panel_additional_features->addChild("title_fullscreen_menu", $title_fullscreen_menu);
        	
            $enable_popup_menu = new MikadoField("yesno","enable_popup_menu","no","Enable Fullscreen Menu","This option enables a fullscreen menu to be opened from main menu navigation", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_enable_popup_menu_container"));
            $panel_additional_features->addChild("enable_popup_menu",$enable_popup_menu);

            $enable_popup_menu_container = new MikadoContainer("enable_popup_menu_container","enable_popup_menu","no");
            $panel_additional_features->addChild("enable_popup_menu_container",$enable_popup_menu_container);

        	    $logo_image_popup = new MikadoField("image","logo_image_popup","","Logo in Fullscreen Menu Overlay","Place logo in top left corner of fullscreen menu overlay");
        	    $enable_popup_menu_container->addChild("logo_image_popup",$logo_image_popup);

        	    $group1 = new MikadoGroup("1st Level Style","Define styles for 1st level in Fullscreen Menu");
        	    $enable_popup_menu_container->addChild("group1",$group1);
        	        $row1 = new MikadoRow();
        	        $group1->addChild("row1",$row1);
        	            $popup_menu_color = new MikadoField("colorsimple","popup_menu_color","","Text Color","This is some description");
        	            $row1->addChild("popup_menu_color",$popup_menu_color);
        	            $popup_menu_hover_color = new MikadoField("colorsimple","popup_menu_hover_color","","Hover Text Color","This is some description");
        	            $row1->addChild("popup_menu_hover_color",$popup_menu_hover_color);
        	            $popup_menu_hover_background_color = new MikadoField("colorsimple","popup_menu_hover_background_color","","Background Hover Color","This is some description");
        	            $row1->addChild("popup_menu_hover_background_color",$popup_menu_hover_background_color);
        	        $row2 = new MikadoRow(true);
        	        $group1->addChild("row2",$row2);
        	            $popup_menu_google_fonts = new MikadoField("Fontsimple","popup_menu_google_fonts","-1","Font Family","This is some description");
        	            $row2->addChild("popup_menu_google_fonts",$popup_menu_google_fonts);
        	            $popup_menu_fontsize = new MikadoField("textsimple","popup_menu_fontsize","","Font Size (px)","This is some description");
        	            $row2->addChild("popup_menu_fontsize",$popup_menu_fontsize);
        	            $popup_menu_lineheight = new MikadoField("textsimple","popup_menu_lineheight","","Line Height (px)","This is some description");
        	            $row2->addChild("popup_menu_lineheight",$popup_menu_lineheight);
        	        $row3 = new MikadoRow(true);
        	        $group1->addChild("row3",$row3);
        	            $popup_menu_fontstyle = new MikadoField("selectblanksimple","popup_menu_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
        	            $row3->addChild("popup_menu_fontstyle",$popup_menu_fontstyle);
        	            $popup_menu_fontweight = new MikadoField("selectblanksimple","popup_menu_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
        	            $row3->addChild("popup_menu_fontweight",$popup_menu_fontweight);
        	            $popup_menu_letterspacing = new MikadoField("textsimple","popup_menu_letterspacing","","Letter Spacing (px)","This is some description");
        	            $row3->addChild("popup_menu_letterspacing",$popup_menu_letterspacing);
        	            $popup_menu_texttransform = new MikadoField("selectblanksimple","popup_menu_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
        	            $row3->addChild("popup_menu_texttransform",$popup_menu_texttransform);

        	    $group2 = new MikadoGroup("2nd Level Style","Define styles for 2nd level in Fullscreen Menu");
        	    $enable_popup_menu_container->addChild("group2",$group2);
        	        $row1 = new MikadoRow();
        	        $group2->addChild("row1",$row1);
        	            $popup_menu_color_2nd = new MikadoField("colorsimple","popup_menu_color_2nd","","Text Color","This is some description");
        	            $row1->addChild("popup_menu_color_2nd",$popup_menu_color_2nd);
        	            $popup_menu_hover_color_2nd = new MikadoField("colorsimple","popup_menu_hover_color_2nd","","Hover Text Color","This is some description");
        	            $row1->addChild("popup_menu_hover_color_2nd",$popup_menu_hover_color_2nd);
        	            $popup_menu_hover_background_color_2nd = new MikadoField("colorsimple","popup_menu_hover_background_color_2nd","","Background Hover Color","This is some description");
        	            $row1->addChild("popup_menu_hover_background_color_2nd",$popup_menu_hover_background_color_2nd);
        	        $row2 = new MikadoRow(true);
        	        $group2->addChild("row2",$row2);
        	            $popup_menu_google_fonts_2nd = new MikadoField("Fontsimple","popup_menu_google_fonts_2nd","-1","Font Family","This is some description");
        	            $row2->addChild("popup_menu_google_fonts_2nd",$popup_menu_google_fonts_2nd);
        	            $popup_menu_fontsize_2nd = new MikadoField("textsimple","popup_menu_fontsize_2nd","","Font Size (px)","This is some description");
        	            $row2->addChild("popup_menu_fontsize_2nd",$popup_menu_fontsize_2nd);
        	            $popup_menu_lineheight_2nd = new MikadoField("textsimple","popup_menu_lineheight_2nd","","Line Height (px)","This is some description");
        	            $row2->addChild("popup_menu_lineheight_2nd",$popup_menu_lineheight_2nd);
        	        $row3 = new MikadoRow(true);
        	        $group2->addChild("row3",$row3);
        	            $popup_menu_fontstyle_2nd = new MikadoField("selectblanksimple","popup_menu_fontstyle_2nd","","Font Style","This is some description",mikado_one_mikado_options_font_style());
        	            $row3->addChild("popup_menu_fontstyle_2nd",$popup_menu_fontstyle_2nd);
        	            $popup_menu_fontweight_2nd = new MikadoField("selectblanksimple","popup_menu_fontweight_2nd","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
        	            $row3->addChild("popup_menu_fontweight_2nd",$popup_menu_fontweight_2nd);
        	            $popup_menu_letterspacing_2nd = new MikadoField("textsimple","popup_menu_letterspacing_2nd","","Letter Spacing (px)","This is some description");
        	            $row3->addChild("popup_menu_letterspacing_2nd",$popup_menu_letterspacing_2nd);
        	            $popup_menu_texttransform_2nd = new MikadoField("selectblanksimple","popup_menu_texttransform_2nd","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
        	            $row3->addChild("popup_menu_texttransform_2nd",$popup_menu_texttransform_2nd);

        	    $group3 = new MikadoGroup("3rd Level Style","Define styles for 3rd level in Fullscreen Menu");
        	    $enable_popup_menu_container->addChild("group3",$group3);
        	        $row1 = new MikadoRow();
        	        $group3->addChild("row1",$row1);
        	            $popup_menu_3rd_color = new MikadoField("colorsimple","popup_menu_3rd_color","","Text Color","This is some description");
        	            $row1->addChild("popup_menu_3rd_color",$popup_menu_3rd_color);
        	            $popup_menu_3rd_hover_color = new MikadoField("colorsimple","popup_menu_3rd_hover_color","","Hover Text Color","This is some description");
        	            $row1->addChild("popup_menu_3rd_hover_color",$popup_menu_3rd_hover_color);
        	            $popup_menu_3rd_hover_background_color = new MikadoField("colorsimple","popup_menu_3rd_hover_background_color","","Background Hover Color","This is some description");
        	            $row1->addChild("popup_menu_3rd_hover_background_color",$popup_menu_3rd_hover_background_color);
        	        $row2 = new MikadoRow(true);
        	        $group3->addChild("row2",$row2);
        	            $popup_menu_3rd_google_fonts = new MikadoField("Fontsimple","popup_menu_3rd_google_fonts","-1","Font Family","This is some description");
        	            $row2->addChild("popup_menu_3rd_google_fonts",$popup_menu_3rd_google_fonts);
        	            $popup_menu_3rd_fontsize = new MikadoField("textsimple","popup_menu_3rd_fontsize","","Font Size (px)","This is some description");
        	            $row2->addChild("popup_menu_3rd_fontsize",$popup_menu_3rd_fontsize);
        	            $popup_menu_3rd_lineheight = new MikadoField("textsimple","popup_menu_3rd_lineheight","","Line Height (px)","This is some description");
        	            $popup_menu_3rd_lineheight = new MikadoField("textsimple","popup_menu_3rd_lineheight","","Line Height (px)","This is some description");
        	            $row2->addChild("popup_menu_3rd_lineheight",$popup_menu_3rd_lineheight);
        	        $row3 = new MikadoRow(true);
        	        $group3->addChild("row3",$row3);
        	            $popup_menu_3rd_fontstyle = new MikadoField("selectblanksimple","popup_menu_3rd_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
        	            $row3->addChild("popup_menu_3rd_fontstyle",$popup_menu_3rd_fontstyle);
        	            $popup_menu_3rd_fontweight = new MikadoField("selectblanksimple","popup_menu_3rd_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
        	            $row3->addChild("popup_menu_3rd_fontweight",$popup_menu_3rd_fontweight);
        	            $popup_menu_3rd_letterspacing = new MikadoField("textsimple","popup_menu_3rd_letterspacing","","Letter Spacing (px)","This is some description");
        	            $row3->addChild("popup_menu_3rd_letterspacing",$popup_menu_3rd_letterspacing);
        	            $popup_menu_3rd_texttransform = new MikadoField("selectblanksimple","popup_menu_3rd_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
        	            $row3->addChild("popup_menu_3rd_texttransform",$popup_menu_3rd_texttransform);

        		$popup_menu_background_color = new MikadoField("color","popup_menu_background_color","","Background","Choose a background color for Fullscreen Menu Overlay");
        		$enable_popup_menu_container->addChild("popup_menu_background_color",$popup_menu_background_color);
        		
        		$pattern_image_popup = new MikadoField("image","pattern_image_popup","","Pattern Background Image","Choose a pattern image for Fullscreen Menu background");
        		$enable_popup_menu_container->addChild("pattern_image_popup",$pattern_image_popup);

        // Header (Side Position)

        $panel_side_general = new MikadoPanel("General Settings","vertical_areas_panel","vertical_area","no");
        $headerPage->addChild("panel_side_general",$panel_side_general);

            $vertical_area_type = new MikadoField("select","vertical_area_type","left","Side Menu Area Type","Specify menu type", array(
                "" => "Always Opened (Default)",
                "hidden" => "Initially Hidden"
        	    ),
        	    array("dependence" => true,
                "hide" => array(
                    ""=>"#mkdf_vertical_area_hidden_button_color_container",
                    "hidden"=>"#mkdf_vertical_area_transparency_container"),
                "show" => array(
                    ""=>"#mkdf_vertical_area_transparency_container",
                    "hidden"=>"#mkdf_vertical_area_hidden_button_color_container"
                )
            ));
            $panel_side_general->addChild("vertical_area_type",$vertical_area_type);

            $vertical_area_hidden_button_color_container = new MikadoContainer("vertical_area_hidden_button_color_container","vertical_area_type","");
            $panel_side_general->addChild("vertical_area_hidden_button_color_container",$vertical_area_hidden_button_color_container);

                $vertical_area_hidden_button_color = new MikadoField("color","vertical_area_hidden_button_color","","Button Color","Choose a color for button that opens/closes Hidden Side Menu Area");
                $vertical_area_hidden_button_color_container->addChild("vertical_area_hidden_button_color",$vertical_area_hidden_button_color);

        	$vertical_area_width = new MikadoField("select","vertical_area_width","width_290","Side Menu Area Width","Choose width for side menu area.", array(
                "width_290" => "290px",
                "width_350" => "350px",
        		"width_400" => "400px"
            ));
            $panel_side_general->addChild("vertical_area_width",$vertical_area_width);
        	
        	$vertical_area_position = new MikadoField("select","vertical_area_position","left","Side Menu Area Position","Choose side menu position relative to browser screen", array(
                "left" => "Left",
                "right" => "Right"
            ));
            $panel_side_general->addChild("vertical_area_position",$vertical_area_position);

            $vertical_area_dropdown_showing = new MikadoField("select","vertical_area_dropdown_showing","left","Submenu Opening Behaviour","Specify 2nd and 3rd level menu opening style", array(
                "hover" => "On Hover",
                "click" => "On Click",
                "side" => "Slide In"
        	    ),
        	    array("dependence" => true,
                "hide" => array(
                    "hover"=>"",
                    "click"=>"",
                    "side"=>"#mkdf_vertical_area_transparency_container, #mkdf_vertical_area_background_container"),
                "show" => array(
                    "hover"=>"#mkdf_vertical_area_transparency_container, #mkdf_vertical_area_background_container",
                    "click"=>"#mkdf_vertical_area_transparency_container, #mkdf_vertical_area_background_container",
                    "side"=>""
                )
            ));
            $panel_side_general->addChild("vertical_area_dropdown_showing",$vertical_area_dropdown_showing);

            $vertical_area_transparency_container = new MikadoContainer("vertical_area_transparency_container","vertical_area_dropdown_showing","side");
            $panel_side_general->addChild("vertical_area_transparency_container",$vertical_area_transparency_container);
        		
        		$vertical_area_background = new MikadoField("color","vertical_area_background","","Side Menu Area Background Color","Choose a color for Side Menu Area background");
        		$vertical_area_transparency_container->addChild("vertical_area_background",$vertical_area_background);

        		$vertical_area_background_container = new MikadoContainer("vertical_area_background_container","vertical_area_dropdown_showing","side");
        		$vertical_area_transparency_container->addChild("vertical_area_background_container",$vertical_area_background_container);

        			$vertical_area_background_image = new MikadoField("image","vertical_area_background_image","","Side Menu Area Background Image","Choose an image for Side Menu background");
        			$vertical_area_background_container->addChild("vertical_area_background_image",$vertical_area_background_image);
        			
        		$vertical_area_transparency = new MikadoField("yesno","vertical_area_transparency","no","Enable Transparent Side Menu Area Over Slider","Enabling this option will make Side Menu background transparent",  array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_vertical_area_transparency_fonts_container"));
                $vertical_area_transparency_container->addChild("vertical_area_transparency",$vertical_area_transparency);
        			
        		$vertical_area_transparency_fonts_container = new MikadoContainer("vertical_area_transparency_fonts_container","vertical_area_transparency","no");
        		$vertical_area_transparency_container->addChild("vertical_area_transparency_fonts_container",$vertical_area_transparency_fonts_container);
        		
        			$group1 = new MikadoGroup("1st Level Transparent Menu Style","Define styles for 1st level in Transparent Side Menu");
        			$vertical_area_transparency_fonts_container->addChild("group1",$group1);

        				$row1 = new MikadoRow();
        				$group1->addChild("row1",$row1);
        					$vertical_transparent_menu_color = new MikadoField("colorsimple","vertical_transparent_menu_color","","Text Color","This is some description");
        					$row1->addChild("vertical_transparent_menu_color",$vertical_transparent_menu_color);
        					$vertical_transparent_menu_hovercolor = new MikadoField("colorsimple","vertical_transparent_menu_hovercolor","","Hover Color","This is some description");
        					$row1->addChild("vertical_transparent_menu_hovercolor",$vertical_transparent_menu_hovercolor);
        					$vertical_transparent_menu_activecolor = new MikadoField("colorsimple","vertical_transparent_menu_activecolor","","Active Color","This is some description");
        					$row1->addChild("vertical_transparent_menu_activecolor",$vertical_transparent_menu_activecolor);
        				$row2 = new MikadoRow(true);
        				$group1->addChild("row2",$row2);
        					$vertical_transparent_menu_google_fonts = new MikadoField("fontsimple","vertical_transparent_menu_google_fonts","-1","Font family","This is some description");
        					$row2->addChild("vertical_transparent_menu_google_fonts",$vertical_transparent_menu_google_fonts);
        					$vertical_transparent_menu_fontsize = new MikadoField("textsimple","vertical_transparent_menu_fontsize","","Font size (px)","This is some description");
        					$row2->addChild("vertical_transparent_menu_fontsize",$vertical_transparent_menu_fontsize);
        					$vertical_transparent_menu_lineheight = new MikadoField("textsimple","vertical_transparent_menu_lineheight","","Line Height (px)","This is some description");
        					$row2->addChild("vertical_transparent_menu_lineheight",$vertical_transparent_menu_lineheight);
        				$row3 = new MikadoRow(true);
        				$group1->addChild("row3",$row3);
        					$vertical_transparent_menu_fontstyle = new MikadoField("selectblanksimple","vertical_transparent_menu_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
        					$row3->addChild("vertical_transparent_menu_fontstyle",$vertical_transparent_menu_fontstyle);
        					$vertical_transparent_menu_fontweight = new MikadoField("selectblanksimple","vertical_transparent_menu_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
        					$row3->addChild("vertical_transparent_menu_fontweight",$vertical_transparent_menu_fontweight);
        					$vertical_transparent_menu_letterspacing = new MikadoField("textsimple","vertical_transparent_menu_letterspacing","","Letter Spacing (px)","This is some description");
        					$row3->addChild("vertical_transparent_menu_letterspacing",$vertical_transparent_menu_letterspacing);
        					$vertical_transparent_menu_texttransform = new MikadoField("selectblanksimple","vertical_transparent_menu_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
        					$row3->addChild("vertical_transparent_menu_texttransform",$vertical_transparent_menu_texttransform);

        			$group2 = new MikadoGroup("2nd Level Transparent Menu Style","Define styles for 2nd level in Transparent Side Menu");
        			$vertical_area_transparency_fonts_container->addChild("group2",$group2);
        				$row1 = new MikadoRow();
        				$group2->addChild("row1",$row1);
        					$vertical_transparent_dropdown_color = new MikadoField("colorsimple","vertical_transparent_dropdown_color","","Text Color","This is some description");
        					$row1->addChild("vertical_transparent_dropdown_color",$vertical_transparent_dropdown_color);
        					$vertical_transparent_dropdown_hovercolor = new MikadoField("colorsimple","vertical_transparent_dropdown_hovercolor","","Hover Color","This is some description");
        					$row1->addChild("vertical_transparent_dropdown_hovercolor",$vertical_transparent_dropdown_hovercolor);
        				$row2 = new MikadoRow(true);
        				$group2->addChild("row2",$row2);
        					$vertical_transparent_dropdown_google_fonts = new MikadoField("fontsimple","vertical_transparent_dropdown_google_fonts","-1","Font Family","This is some description");
        					$row2->addChild("vertical_transparent_dropdown_google_fonts",$vertical_transparent_dropdown_google_fonts);
        					$vertical_transparent_dropdown_fontsize = new MikadoField("textsimple","vertical_transparent_dropdown_fontsize","","Font Size (px)","This is some description");
        					$row2->addChild("vertical_transparent_dropdown_fontsize",$vertical_transparent_dropdown_fontsize);
        					$vertical_transparent_dropdown_lineheight = new MikadoField("textsimple","vertical_transparent_dropdown_lineheight","","Line Height (px)","This is some description");
        					$row2->addChild("vertical_transparent_dropdown_lineheight",$vertical_transparent_dropdown_lineheight);
        				$row3 = new MikadoRow(true);
        				$group2->addChild("row3",$row3);
        					$vertical_transparent_dropdown_fontstyle = new MikadoField("selectblanksimple","vertical_transparent_dropdown_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
        					$row3->addChild("vertical_transparent_dropdown_fontstyle",$vertical_transparent_dropdown_fontstyle);
        					$vertical_transparent_dropdown_fontweight = new MikadoField("selectblanksimple","vertical_transparent_dropdown_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
        					$row3->addChild("vertical_transparent_dropdown_fontweight",$vertical_transparent_dropdown_fontweight);
        					$vertical_transparent_dropdown_letterspacing = new MikadoField("textsimple","vertical_transparent_dropdown_letterspacing","","Letter Spacing (px)","This is some description");
        					$row3->addChild("vertical_transparent_dropdown_letterspacing",$vertical_transparent_dropdown_letterspacing);
        					$vertical_transparent_dropdown_texttransform = new MikadoField("selectblanksimple","vertical_transparent_dropdown_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
        					$row3->addChild("vertical_transparent_dropdown_texttransform",$vertical_transparent_dropdown_texttransform);

        			$group3 = new MikadoGroup("3rd Level Transparent Menu Style","Define styles for 3rd level in Transparent Side Menu");
        			$vertical_area_transparency_fonts_container->addChild("group3",$group3);
        				$row1 = new MikadoRow();
        				$group3->addChild("row1",$row1);
        					$vertical_transparent_dropdown_color_thirdlvl = new MikadoField("colorsimple","vertical_transparent_dropdown_color_thirdlvl","","Text Color","This is some description");
        					$row1->addChild("vertical_transparent_dropdown_color_thirdlvl",$vertical_transparent_dropdown_color_thirdlvl);
        					$vertical_transparent_dropdown_hovercolor_thirdlvl = new MikadoField("colorsimple","vertical_transparent_dropdown_hovercolor_thirdlvl","","Hover Color","This is some description");
        					$row1->addChild("vertical_transparent_dropdown_hovercolor_thirdlvl",$vertical_transparent_dropdown_hovercolor_thirdlvl);
        				$row2 = new MikadoRow(true);
        				$group3->addChild("row2",$row2);
        					$vertical_transparent_dropdown_google_fonts_thirdlvl = new MikadoField("fontsimple","vertical_transparent_dropdown_google_fonts_thirdlvl","-1","Font Family","This is some description");
        					$row2->addChild("vertical_transparent_dropdown_google_fonts_thirdlvl",$vertical_transparent_dropdown_google_fonts_thirdlvl);
        					$vertical_transparent_dropdown_fontsize_thirdlvl = new MikadoField("textsimple","vertical_transparent_dropdown_fontsize_thirdlvl","","Font Size (px)","This is some description");
        					$row2->addChild("vertical_transparent_dropdown_fontsize_thirdlvl",$vertical_transparent_dropdown_fontsize_thirdlvl);
        					$vertical_transparent_dropdown_lineheight_thirdlvl = new MikadoField("textsimple","vertical_transparent_dropdown_lineheight_thirdlvl","","Line Height (px)","This is some description");
        					$row2->addChild("vertical_transparent_dropdown_lineheight_thirdlvl",$vertical_transparent_dropdown_lineheight_thirdlvl);
        				$row3 = new MikadoRow(true);
        				$group3->addChild("row3",$row3);
        					$vertical_transparent_dropdown_fontstyle_thirdlvl = new MikadoField("selectblanksimple","vertical_transparent_dropdown_fontstyle_thirdlvl","","Font Style","This is some description",mikado_one_mikado_options_font_style());
        					$row3->addChild("vertical_transparent_dropdown_fontstyle_thirdlvl",$vertical_transparent_dropdown_fontstyle_thirdlvl);
        					$vertical_transparent_dropdown_fontweight_thirdlvl = new MikadoField("selectblanksimple","vertical_transparent_dropdown_fontweight_thirdlvl","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
        					$row3->addChild("vertical_transparent_dropdown_fontweight_thirdlvl",$vertical_transparent_dropdown_fontweight_thirdlvl);
        					$vertical_transparent_dropdown_letterspacing_thirdlvl = new MikadoField("textsimple","vertical_transparent_dropdown_letterspacing_thirdlvl","","Letter Spacing (px)","This is some description");
        					$row3->addChild("vertical_transparent_dropdown_letterspacing_thirdlvl",$vertical_transparent_dropdown_letterspacing_thirdlvl);
        					$vertical_transparent_dropdown_texttransform_thirdlvl = new MikadoField("selectblanksimple","vertical_transparent_dropdown_texttransform_thirdlvl","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
        					$row3->addChild("vertical_transparent_dropdown_texttransform_thirdlvl",$vertical_transparent_dropdown_texttransform_thirdlvl);     
        	
            $vertical_area_padding = new MikadoField("text","vertical_area_padding","","Side Menu Area Padding","Set padding for Side Menu Area in pixels (default value is 20px 40px 20px 40px)", array(), array("col_width" => 3));
            $panel_side_general->addChild("vertical_area_padding",$vertical_area_padding);
        	
        	$vertical_area_navigation_top_margin = new MikadoField("text","vertical_area_navigation_top_margin","","Navigation Top Margin","Set the space between logo and navigation in pixels (default value is 40px)", array(), array("col_width" => 3));
            $panel_side_general->addChild("vertical_area_navigation_top_margin",$vertical_area_navigation_top_margin);

            $vertical_area_text_color = new MikadoField("color","vertical_area_text_color","","Side Menu Area Text Color (for Widgets)","Choose a text color for widgets in Side Menu");
            $panel_side_general->addChild("vertical_area_text_color",$vertical_area_text_color);

            $vertical_area_alignment = new MikadoField("selectblank","vertical_area_alignment","","Side Menu Area Aligment","Specify alignment for logo, menu and widgets.", array(
                "left" => "Left",
                "center" => "Center",
                "right" => "Right"
            ));
            $panel_side_general->addChild("vertical_area_alignment",$vertical_area_alignment);

            $full_width_vertical_menu_items = new MikadoField("yesno","full_width_vertical_menu_items","no","Full Width Menu Items","Enabling this option will set menu item area to full width of vertical menu", array(), array("dependence" => true, "dependence_hide_on_yes" => "#mkdf_vertical_menu_separators_width_container", "dependence_show_on_yes" => "#mkdf_vertical_menu_top_bottom_separators_container"));
            $panel_side_general->addChild("full_width_vertical_menu_items",$full_width_vertical_menu_items);

        	$enable_vertical_menu_separators= new MikadoField("yesno","enable_vertical_menu_separators","no","Enable Separators for 1st Level Menu Items","Enabling this option will display separators in first level menu", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_vertical_menu_separators_container"));
            $panel_side_general->addChild("enable_vertical_menu_separators",$enable_vertical_menu_separators);

        		$vertical_menu_separators_container = new MikadoContainer("vertical_menu_separators_container","enable_vertical_menu_separators","no");
        		$panel_side_general->addChild("vertical_menu_separators_container",$vertical_menu_separators_container);

        			$vertical_menu_separators_width_container = new MikadoContainer("vertical_menu_separators_width_container","full_width_vertical_menu_items","yes");
        			$vertical_menu_separators_container->addChild("vertical_menu_separators_width_container",$vertical_menu_separators_width_container);

        			$vertical_menu_separators_width = new MikadoField("text","vertical_menu_separators_width","","Width (px)","Enter width for the menu item separators.", array(), array("col_width" => 1));
        			$vertical_menu_separators_width_container->addChild("vertical_menu_separators_width",$vertical_menu_separators_width);
        			
        			$vertical_menu_separators_color = new MikadoField("color","vertical_menu_separators_color","","Color","Choose a color for the menu item separators.");
        			$vertical_menu_separators_container->addChild("vertical_menu_separators_color",$vertical_menu_separators_color);
        			
        			$vertical_menu_top_bottom_separators_container = new MikadoContainer("vertical_menu_top_bottom_separators_container","full_width_vertical_menu_items","no");
                    $vertical_menu_separators_container->addChild("vertical_menu_top_bottom_separators_container",$vertical_menu_top_bottom_separators_container);
        			
        				$enable_vertical_menutop_bottom_separators= new MikadoField("yesno","enable_vertical_menutop_bottom_separators","no","Enable Menu Top and Bottom Separators","Enabling this option will display separators at top and bottom of menu also");
        				$vertical_menu_top_bottom_separators_container->addChild("enable_vertical_menutop_bottom_separators",$enable_vertical_menutop_bottom_separators);

        	$enable_vertical_menu_items_background= new MikadoField("yesno","enable_vertical_menu_items_background","no","Enable Background for 1st Level Menu Items","Enable this option and choose background color for items in first level menu", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_vertical_menu_items_background_container"));
            $panel_side_general->addChild("enable_vertical_menu_items_background",$enable_vertical_menu_items_background);

        		$vertical_menu_items_background_container = new MikadoContainer("vertical_menu_items_background_container","enable_vertical_menu_items_background","no");
        		$panel_side_general->addChild("vertical_menu_items_background_container",$vertical_menu_items_background_container);

        			$vertical_menu_items_background_color = new MikadoField("color","vertical_menu_items_background_color","","Background Color","Choose a background color for the menu items");
        			$vertical_menu_items_background_container->addChild("vertical_menu_items_background_color",$vertical_menu_items_background_color);
        			
        			$vertical_menu_items_hover_background_color = new MikadoField("color","vertical_menu_items_hover_background_color","","Hover Background Color","Choose a background color for the hover menu items");
        			$vertical_menu_items_background_container->addChild("vertical_menu_items_hover_background_color",$vertical_menu_items_hover_background_color);
        			
        			$vertical_menu_items_active_background_color = new MikadoField("color","vertical_menu_items_active_background_color","","Active Background Color","Choose a background color for the active menu items");
        			$vertical_menu_items_background_container->addChild("vertical_menu_items_active_background_color",$vertical_menu_items_active_background_color);
        		
        		
        	$enable_vertical_menu_item_left_border= new MikadoField("yesno","enable_vertical_menu_item_left_border","no","Enable Left Border for 1st Level Menu Items","Enabling this option will display left border in first level menu items", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_vertical_menu_item_left_border_container"));
            $panel_side_general->addChild("enable_vertical_menu_item_left_border",$enable_vertical_menu_item_left_border);

        		$vertical_menu_item_left_border_container = new MikadoContainer("vertical_menu_item_left_border_container","enable_vertical_menu_item_left_border","no");
        		$panel_side_general->addChild("vertical_menu_item_left_border_container",$vertical_menu_item_left_border_container);


        			$vertical_menu_item_left_border_width = new MikadoField("text","vertical_menu_item_left_border_width","","Border Width (px)","Enter width for the menu item border", array(), array("col_width" => 1));
        			$vertical_menu_item_left_border_container->addChild("vertical_menu_item_left_border_width",$vertical_menu_item_left_border_width);
        			
        			$vertical_menu_item_left_border_color = new MikadoField("color","vertical_menu_item_left_border_color","","Border Color","Choose a color for the menu item border");
        			$vertical_menu_item_left_border_container->addChild("vertical_menu_item_left_border_color",$vertical_menu_item_left_border_color);
        			
        			$vertical_menu_item_left_border_hover_color = new MikadoField("color","vertical_menu_item_left_border_hover_color","","Border Hover Color","Choose a hover color for the menu item border");
        			$vertical_menu_item_left_border_container->addChild("vertical_menu_item_left_border_hover_color",$vertical_menu_item_left_border_hover_color);
        			
        			$vertical_menu_item_left_border_active_color = new MikadoField("color","vertical_menu_item_left_border_active_color","","Border Active Color","Choose a color for the active menu item border");
        			$vertical_menu_item_left_border_container->addChild("vertical_menu_item_left_border_active_color",$vertical_menu_item_left_border_active_color);
        			
            $group1 = new MikadoGroup("1st Level Menu Style","Define styles for 1st level in Side Menu");
            $panel_side_general->addChild("group1",$group1);

                $row1 = new MikadoRow();
                $group1->addChild("row1",$row1);
                    $vertical_menu_color = new MikadoField("colorsimple","vertical_menu_color","","Text Color","This is some description");
                    $row1->addChild("vertical_menu_color",$vertical_menu_color);
                    $vertical_menu_hovercolor = new MikadoField("colorsimple","vertical_menu_hovercolor","","Hover Color","This is some description");
                    $row1->addChild("vertical_menu_hovercolor",$vertical_menu_hovercolor);
        			$vertical_menu_activecolor = new MikadoField("colorsimple","vertical_menu_activecolor","","Active Color","This is some description");
                    $row1->addChild("vertical_menu_activecolor",$vertical_menu_activecolor);
                $row2 = new MikadoRow(true);
                $group1->addChild("row2",$row2);
                    $vertical_menu_google_fonts = new MikadoField("fontsimple","vertical_menu_google_fonts","-1","Font family","This is some description");
                    $row2->addChild("vertical_menu_google_fonts",$vertical_menu_google_fonts);
                    $vertical_menu_fontsize = new MikadoField("textsimple","vertical_menu_fontsize","","Font size (px)","This is some description");
                    $row2->addChild("vertical_menu_fontsize",$vertical_menu_fontsize);
                    $vertical_menu_lineheight = new MikadoField("textsimple","vertical_menu_lineheight","","Line Height (px)","This is some description");
                    $row2->addChild("vertical_menu_lineheight",$vertical_menu_lineheight);
                $row3 = new MikadoRow(true);
                $group1->addChild("row3",$row3);
                    $vertical_menu_fontstyle = new MikadoField("selectblanksimple","vertical_menu_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
                    $row3->addChild("vertical_menu_fontstyle",$vertical_menu_fontstyle);
                    $vertical_menu_fontweight = new MikadoField("selectblanksimple","vertical_menu_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
                    $row3->addChild("vertical_menu_fontweight",$vertical_menu_fontweight);
                    $vertical_menu_letterspacing = new MikadoField("textsimple","vertical_menu_letterspacing","","Letter Spacing (px)","This is some description");
                    $row3->addChild("vertical_menu_letterspacing",$vertical_menu_letterspacing);
                    $vertical_menu_texttransform = new MikadoField("selectblanksimple","vertical_menu_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
                    $row3->addChild("vertical_menu_texttransform",$vertical_menu_texttransform);

            $group2 = new MikadoGroup("2nd Level Menu Style","Define styles for 2nd level in Side Menu");
            $panel_side_general->addChild("group2",$group2);
                $row1 = new MikadoRow();
                $group2->addChild("row1",$row1);
                    $vertical_dropdown_color = new MikadoField("colorsimple","vertical_dropdown_color","","Text Color","This is some description");
                    $row1->addChild("vertical_dropdown_color",$vertical_dropdown_color);
                    $vertical_dropdown_hovercolor = new MikadoField("colorsimple","vertical_dropdown_hovercolor","","Hover Color","This is some description");
                    $row1->addChild("vertical_dropdown_hovercolor",$vertical_dropdown_hovercolor);
                $row2 = new MikadoRow(true);
                $group2->addChild("row2",$row2);
                    $vertical_dropdown_google_fonts = new MikadoField("fontsimple","vertical_dropdown_google_fonts","-1","Font Family","This is some description");
                    $row2->addChild("vertical_dropdown_google_fonts",$vertical_dropdown_google_fonts);
                    $vertical_dropdown_fontsize = new MikadoField("textsimple","vertical_dropdown_fontsize","","Font Size (px)","This is some description");
                    $row2->addChild("vertical_dropdown_fontsize",$vertical_dropdown_fontsize);
                    $vertical_dropdown_lineheight = new MikadoField("textsimple","vertical_dropdown_lineheight","","Line Height (px)","This is some description");
                    $row2->addChild("vertical_dropdown_lineheight",$vertical_dropdown_lineheight);
                $row3 = new MikadoRow(true);
                $group2->addChild("row3",$row3);
                    $vertical_dropdown_fontstyle = new MikadoField("selectblanksimple","vertical_dropdown_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
                    $row3->addChild("vertical_dropdown_fontstyle",$vertical_dropdown_fontstyle);
                    $vertical_dropdown_fontweight = new MikadoField("selectblanksimple","vertical_dropdown_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
                    $row3->addChild("vertical_dropdown_fontweight",$vertical_dropdown_fontweight);
                    $vertical_dropdown_letterspacing = new MikadoField("textsimple","vertical_dropdown_letterspacing","","Letter Spacing (px)","This is some description");
                    $row3->addChild("vertical_dropdown_letterspacing",$vertical_dropdown_letterspacing);
                    $vertical_dropdown_texttransform = new MikadoField("selectblanksimple","vertical_dropdown_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
                    $row3->addChild("vertical_dropdown_texttransform",$vertical_dropdown_texttransform);

            $group3 = new MikadoGroup("3rd Level Menu Style","Define styles for 3rd level in Side Menu");
            $panel_side_general->addChild("group3",$group3);
                $row1 = new MikadoRow();
                $group3->addChild("row1",$row1);
                    $vertical_dropdown_color_thirdlvl = new MikadoField("colorsimple","vertical_dropdown_color_thirdlvl","","Text Color","This is some description");
                    $row1->addChild("vertical_dropdown_color_thirdlvl",$vertical_dropdown_color_thirdlvl);
                    $vertical_dropdown_hovercolor_thirdlvl = new MikadoField("colorsimple","vertical_dropdown_hovercolor_thirdlvl","","Hover Color","This is some description");
                    $row1->addChild("vertical_dropdown_hovercolor_thirdlvl",$vertical_dropdown_hovercolor_thirdlvl);
                $row2 = new MikadoRow(true);
                $group3->addChild("row2",$row2);
                    $vertical_dropdown_google_fonts_thirdlvl = new MikadoField("fontsimple","vertical_dropdown_google_fonts_thirdlvl","-1","Font Family","This is some description");
                    $row2->addChild("vertical_dropdown_google_fonts_thirdlvl",$vertical_dropdown_google_fonts_thirdlvl);
                    $vertical_dropdown_fontsize_thirdlvl = new MikadoField("textsimple","vertical_dropdown_fontsize_thirdlvl","","Font Size (px)","This is some description");
                    $row2->addChild("vertical_dropdown_fontsize_thirdlvl",$vertical_dropdown_fontsize_thirdlvl);
                    $vertical_dropdown_lineheight_thirdlvl = new MikadoField("textsimple","vertical_dropdown_lineheight_thirdlvl","","Line Height (px)","This is some description");
                    $row2->addChild("vertical_dropdown_lineheight_thirdlvl",$vertical_dropdown_lineheight_thirdlvl);
                $row3 = new MikadoRow(true);
                $group3->addChild("row3",$row3);
                    $vertical_dropdown_fontstyle_thirdlvl = new MikadoField("selectblanksimple","vertical_dropdown_fontstyle_thirdlvl","","Font Style","This is some description",mikado_one_mikado_options_font_style());
                    $row3->addChild("vertical_dropdown_fontstyle_thirdlvl",$vertical_dropdown_fontstyle_thirdlvl);
                    $vertical_dropdown_fontweight_thirdlvl = new MikadoField("selectblanksimple","vertical_dropdown_fontweight_thirdlvl","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
                    $row3->addChild("vertical_dropdown_fontweight_thirdlvl",$vertical_dropdown_fontweight_thirdlvl);
                    $vertical_dropdown_letterspacing_thirdlvl = new MikadoField("textsimple","vertical_dropdown_letterspacing_thirdlvl","","Letter Spacing (px)","This is some description");
                    $row3->addChild("vertical_dropdown_letterspacing_thirdlvl",$vertical_dropdown_letterspacing_thirdlvl);
                    $vertical_dropdown_texttransform_thirdlvl = new MikadoField("selectblanksimple","vertical_dropdown_texttransform_thirdlvl","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
                    $row3->addChild("vertical_dropdown_texttransform_thirdlvl",$vertical_dropdown_texttransform_thirdlvl);  

        //Mobile header

        $panel_mobile_header = new MikadoPanel("Mobile Header","mobile_menu_panel");
        $headerPage->addChild("panel_mobile_header",$panel_mobile_header);
        	
        	$header_height_mobile = new MikadoField("text","header_height_mobile","","Mobile Header Height","Enter height for mobile header in pixels", array(), array("col_width" => 3));
            $panel_mobile_header->addChild("header_height_mobile",$header_height_mobile);
        	           
            $mobile_background_color = new MikadoField("color","mobile_background_color","","Mobile Header & Menu Background Color","Choose color for mobile header & menu background");
            $panel_mobile_header->addChild("mobile_background_color",$mobile_background_color);	

        	$logo_mobile_header_height = new MikadoField("text","logo_mobile_header_height","","Logo Height For Mobile Header (px)","Define logo height for screen size smaller than 1000px", array(), array("col_width" => 3));
        	$panel_mobile_header->addChild("logo_mobile_header_height",$logo_mobile_header_height);

        	$logo_mobile_height = new MikadoField("text","logo_mobile_height","","Logo Height For Mobile Devices (px)","Define logo height for screen size smaller than 480px", array(), array("col_width" => 3));
        	$panel_mobile_header->addChild("logo_mobile_height",$logo_mobile_height);
        			
        	$group3 = new MikadoGroup("Mobile Header Icons Color","Choose color for mobile header icons (search icon, fullscreen menu icon and side area icon)");
            $panel_mobile_header->addChild("group3",$group3);

                $row1 = new MikadoRow(true);
                $group3->addChild("row1",$row1);	
        			$mobile_button_color = new MikadoField("colorsimple","mobile_button_color","","Icon Color","Choose a color for mobile menu icon");
        			$row1->addChild("mobile_button_color",$mobile_button_color); 
        			$mobile_button_color_hover = new MikadoField("colorsimple","mobile_button_color_hover","","Icon Hover Color","Choose a hover color for mobile menu icon");
        			$row1->addChild("mobile_button_color_hover",$mobile_button_color_hover);

        	$mobile_separator_color = new MikadoField("color","mobile_separator_color","","Mobile Menu Item Separator Color","Choose color for mobile menu horizontal separators");
            $panel_mobile_header->addChild("mobile_separator_color",$mobile_separator_color);
            
        	$group7 = new MikadoGroup("Mobile Menu Style","Define styles for Mobile Menu (as seen on small screens)");
        	$panel_mobile_header->addChild("group7",$group7);
        		$row1 = new MikadoRow();
        		$group7->addChild("row1",$row1);
        			$mobile_color = new MikadoField("colorsimple","mobile_color","","Text Color","This is some description");
        			$row1->addChild("mobile_color",$mobile_color);
        			$mobile_hovercolor = new MikadoField("colorsimple","mobile_hovercolor","","Hover/Active Color","This is some description");
        			$row1->addChild("mobile_hovercolor",$mobile_hovercolor);
        		$row2 = new MikadoRow(true);
        		$group7->addChild("row2",$row2);
        			$mobile_google_fonts = new MikadoField("Fontsimple","mobile_google_fonts","-1","Font Family","This is some description");
        			$row2->addChild("mobile_google_fonts",$mobile_google_fonts);
        			$mobile_fontsize = new MikadoField("textsimple","mobile_fontsize","","Font Size (px)","This is some description");
        			$row2->addChild("mobile_fontsize",$mobile_fontsize);
        			$mobile_lineheight = new MikadoField("textsimple","mobile_lineheight","","Line Height (px)","This is some description");
        			$row2->addChild("mobile_lineheight",$mobile_lineheight);
        			$mobile_texttransform = new MikadoField("selectblanksimple","mobile_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
        			$row2->addChild("mobile_texttransform",$mobile_texttransform);
        		$row3 = new MikadoRow(true);
        		$group7->addChild("row3",$row3);
        			$mobile_fontstyle = new MikadoField("selectblanksimple","mobile_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
        			$row3->addChild("mobile_fontstyle",$mobile_fontstyle);
        			$mobile_fontweight = new MikadoField("selectblanksimple","mobile_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
        			$row3->addChild("mobile_fontweight",$mobile_fontweight);
        			$mobile_letter_spacing = new MikadoField("textsimple","mobile_letter_spacing","","Letter Spacing (px)","This is some description");
        			$row3->addChild("mobile_letter_spacing",$mobile_letter_spacing);
    }

	add_action('mikado_one_mikado_action_options', 'mikado_one_core_header_options_map', 3);
}