<?php
/**
 * @package Mikado Core
 * @version 1.0.4
 */
/*
Plugin Name: Mikado Core
Description: Mikado CPT plugin
Author: Mikado
Version: 2.0.4
*/

if ( ! class_exists( 'MikadoCore' ) ) {
	class MikadoCore {
		private static $instance;

		public function __construct() {

			//load const
			require_once 'const.php';
			require_once MKD_CORE_ABS_PATH . '/helpers/mikado-helpers.php';

			// Make plugin available for translation
			add_action( 'plugins_loaded', array( $this, 'load_plugin_textdomain' ) );

			// Add plugin's body classes
			add_filter( 'body_class', array( $this, 'add_body_classes' ) );

			add_action( 'after_setup_theme', array( $this, 'init' ), 5 );
		}

		public static function get_instance() {
			if ( self::$instance == null ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		function load_plugin_textdomain() {
			load_plugin_textdomain( 'mikado-core', false, MKD_CORE_REL_PATH . '/languages' );
		}

		function add_body_classes( $classes ) {
			$classes[] = 'mikado-core-' . MKD_CORE_VERSION;

			return $classes;
		}

		function init() {

			if ( mkdcore_is_theme_installed() ) {
				include_once MKD_CORE_ABS_PATH . '/load.php';
				include_once MKD_CORE_ABS_PATH . '/lib/mikado-helper.php';

				add_action( 'init', array( $this, 'cpt_activation' ), 0 );
			}
		}

		function cpt_activation() {
			do_action( 'mikado_one_mikado_action_core_on_activate' );

			MikadoCPT::getInstance()->registerCPT();
			flush_rewrite_rules();
		}
	}

	MikadoCore::get_instance();
}
