<?php


if(!function_exists( 'mikado_one_mikado_theme_menu' )) {
	/**
	 * Function that registers theme options menu with WP admin menu.
	 * It registers page for each tab that we have in our theme options.
	 */
	function mikado_one_mikado_theme_menu() {
		if(mkdcore_is_theme_installed()) {
			$mkdFramework = mikado_one_mikado_return_framework();

			init_mkd_theme_options();

			$page_hook_suffix = add_menu_page( 'Mikado Settings', 'Mikado Settings', 'administrator', 'mkd_theme_menu', 'mikado_one_mikado_theme_display' );

			foreach ( $mkdFramework->mkdOptions->adminPages as $key => $value ) {
				$slug = "";

				if ( ! empty( $value->slug ) ) {
					$slug = "_tab" . $value->slug;
				}

				$subpage_hook_suffix = add_submenu_page( 'mkd_theme_menu', 'Mikado Settings - ' . $value->title, $value->title, 'administrator', 'mkd_theme_menu' . $slug, 'mikado_one_mikado_theme_display' );

				add_action( 'admin_print_scripts-' . $subpage_hook_suffix, 'mikado_one_mikado_enqueue_admin_scripts' );
				add_action( 'admin_print_styles-' . $subpage_hook_suffix, 'mikado_one_mikado_enqueue_admin_styles' );
			};

			add_action( 'admin_print_scripts-' . $page_hook_suffix, 'mikado_one_mikado_enqueue_admin_scripts' );
			add_action( 'admin_print_styles-' . $page_hook_suffix, 'mikado_one_mikado_enqueue_admin_styles' );
		}
	}

	add_action( 'admin_menu', 'mikado_one_mikado_theme_menu' );
}

if(!function_exists('register_mkd_theme_settings')) {
	/**
	 * Function that hooks to admin_init action and registers our theme options setting.
	 *
	 * @see register_setting()
	 */
	function register_mkd_theme_settings() {
		register_setting( 'mkd_theme_menu', 'mkd_options' );
	}

	add_action('admin_init', 'register_mkd_theme_settings');
}

if(!function_exists( 'mikado_one_mikado_get_admin_tab' )) {
	/**
	 * Function that gets current tab slug
	 * @return null|string returns string if slug exists, else returns NULL
	 *
	 * @see mikado_one_mikado_strafter()
	 */
	function mikado_one_mikado_get_admin_tab(){
		return isset($_GET['page']) ? mikado_one_mikado_strafter($_GET['page'],'tab') : NULL;
	}
}


if(!function_exists( 'mikado_one_mikado_theme_display' )) {
	/**
	 * Function that is generating theme options page.
	 * Used as a callback function from mkd_theme_menu
	 *
	 * @see mikado_one_mikado_theme_menu()
	 * @see mikado_one_mikado_get_admin_tab()
	 */
	function mikado_one_mikado_theme_display() {
		if ( mkdcore_is_theme_installed() ) {
			$mkdFramework  = mikado_one_mikado_return_framework();
			$tab           = mikado_one_mikado_get_admin_tab();
			$active_page   = $mkdFramework->mkdOptions->getAdminPageFromSlug( $tab );
			$current_theme = wp_get_theme();

			if ( $active_page == null ) {
				return;
			}
			?>
			<div class="mkdf-options-page mkdf-page">

				<div class="mkdf-page-header page-header clearfix">

					<div class="mkdf-theme-name pull-left">
						<img src="<?php echo esc_url( get_template_directory_uri() . '/mkdinc/admin/assets/img/mkd-logo.png' ); ?>" alt="<?php esc_attr_e( 'mkd_logo', 'mikado1' ); ?>"
						     class="mkdf-header-logo pull-left"/>
						<h1 class="pull-left">
							<?php echo esc_html( $current_theme->get( 'Name' ) ); ?>
							<small><?php echo esc_html( $current_theme->get( 'Version' ) ); ?></small>
						</h1>
					</div>
					<div class="mkdf-top-section-holder">
						<div class="mkdf-top-section-holder-inner">
							<div class="mkdf-notification-holder">
								<div class="mkdf-input-change"><i class="fa fa-exclamation-circle"></i><?php esc_html_e( 'You should save your changes', 'mikado1' ); ?></div>
								<div class="mkdf-changes-saved"><i class="fa fa-check-circle"></i><?php esc_html_e( 'All your changes are successfully saved', 'mikado1' ); ?></div>
							</div>
							<div class="mkdf-top-buttons-holder">
								<input type="button" id="mkd_top_save_button" class="btn btn-info btn-sm" value="<?php esc_attr_e( 'Save Changes', 'mikado1' ); ?>"/>
							</div>
						</div>
					</div>

				</div> <!-- close div.mkdf-page-header -->

				<div class="mkdf-page-content-wrapper">
					<div class="mkdf-page-content">
						<div class="mkdf-page-navigation mkdf-tabs-wrapper vertical left clearfix">

							<div class="mkdf-tabs-navigation-wrapper">

								<ul class="nav nav-tabs clearfix">
									<?php
									foreach ( $mkdFramework->mkdOptions->adminPages as $key => $page ) {
										$slug = "";
										if ( ! empty( $page->slug ) ) {
											$slug = "_tab" . $page->slug;
										}
										$icon = "icon_building";
										switch ( $page->slug ) {
											case 1:
												$icon = 'icon_pencil-edit_alt';
												break;
											case 2:
												$icon = 'icon_folder-open_alt';
												break;
											case 3:
												$icon = 'icon_archive_alt';
												break;
											case 4:
												$icon = 'icon_clipboard';
												break;
											case 5:
												$icon = 'icon_cone_alt';
												break;
											case 6:
												$icon = 'icon_rook';
												break;
											case 7:
												$icon = 'icon_genius';
												break;
											case 8:
												$icon = 'icon_book_alt';
												break;
											case 9:
												$icon = 'icon_images';
												break;
											case 10:
												$icon = 'arrow_left-right';
												break;
											case 11:
												$icon = 'arrow_up-down_alt';
												break;
											case 12:
												$icon = 'icon_group';
												break;
											case 13:
												$icon = 'icon_error-triangle_alt';
												break;
											case 14:
												$icon = 'icon_mail_alt';
												break;
											case 15:
												$icon = 'icon_cart_alt';
												break;
											case 16:
												$icon = 'icon_contacts_alt';
												break;
											case 17:
												$icon = 'icon_refresh';
												break;
											case 18:
												$icon = 'icon_tools';
												break;
											case 19:
												$icon = 'icon_cart_alt';
												break;
											case 20:
												$icon = 'arrow_back';
												break;
										}
										?>
										<li<?php if ( $page->slug == $tab ) {
											echo " class=\"active\"";
										} ?>><a href="<?php echo get_admin_url(); ?>admin.php?page=mkd_theme_menu<?php echo esc_attr( $slug ); ?>"><i
													class="<?php echo esc_attr( $icon ); ?> mkdf-tooltip mkdf-inline-tooltip left" data-placement="top" data-toggle="tooltip"
													title="<?php echo esc_attr( $page->title ); ?>"></i><span><?php echo esc_attr( $page->title ); ?></span></a></li>
										<?php
									}
									?>
									<li><a href="<?php echo get_admin_url(); ?>admin.php?page=mkd_theme_menu_tabimport"><i class="icon_download mkdf-tooltip mkdf-inline-tooltip left"
									                                                                                       data-placement="top" data-toggle="tooltip"
									                                                                                       title="<?php esc_attr_e( 'Import', 'mikado1' ); ?>"></i><span><?php esc_html_e( 'Import', 'mikado1' ); ?></span></a>
									</li>

								</ul>
							</div> <!-- close div.mkdf-tabs-navigation-wrapper -->

							<div class="mkdf-tabs-content">
								<div class="tab-content">
									<?php
									foreach ( $mkdFramework->mkdOptions->adminPages as $key => $page ) {
										if ( $page->slug == $tab ) {
											?>
											<div class="tab-pane fade<?php if ( $page->slug == $tab ) {
												echo " in active";
											} ?>" id="<?php echo esc_attr( $key ); ?>">
												<div class="mkdf-tab-content">
													<div class="mkdf-page-title-holder clearfix">
														<h2 class="mkdf-page-title"><?php echo esc_html( $page->title ); ?></h2>
														<div class="mkdf-anchor-holder">
															<?php if ( is_array( $page->layout ) && count( $page->layout ) ) { ?>
																<span><?php esc_html_e( 'Scroll To:', 'mikado1' ); ?></span>
																<select class="nav-select mkdf-selectpicker" data-width="315px" data-hide-disabled="true" data-live-search="true"
																        id="mkdf-select-anchor">
																	<option value="" disabled selected></option>
																	<?php foreach ( $page->layout as $panel ) { ?>
																		<option data-anchor="#mkdf_<?php echo esc_attr( $panel->name ); ?>"><?php echo esc_attr( $panel->title ); ?></option>
																	<?php } ?>
																</select>

															<?php } ?>
														</div>
													</div>

													<form method="post" class="mkd_ajax_form">
														<?php wp_nonce_field( "mkdf_ajax_save_nonce", "mkdf_ajax_save_nonce" ) ?>
														<div class="mkdf-page-form">

															<?php $page->render(); ?>
														</div>
													</form>

												</div><!-- close mkdf-tab-content -->
											</div>
											<?php
										}
									}
									?>
								</div>
							</div> <!-- close div.mkdf-tabs-content -->

						</div> <!-- close div.mkdf-page-navigation -->

					</div> <!-- close div.mkdf-page-content -->

				</div> <!-- close div.mkdf-page-content-wrapper -->

			</div> <!-- close div.mkd-options-page -->

			<a id='back_to_top' href='#'>
            <span class="fa-stack">
                <span class="arrow_carrot-up"></span>
            </span>
			</a>
		<?php }
	}
}