<?php
/**
 * Lost password form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-lost-password.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.5.2
 */

defined( 'ABSPATH' ) || exit;

wc_print_notices(); ?>

<form method="post" class="woocommerce-ResetPassword lost_reset_password">

    <?php if( 'lost_password' == $args['form'] ) : ?>

        <p><?php echo apply_filters( 'woocommerce_lost_password_message', esc_html__( 'Lost your password? Please enter your username or email address. You will receive a link to create a new password via email.', 'mikado1' ) ); ?></p>

        <p class="woocommerce-form-row woocommerce-form-row--first form-row form-row-first"><label for="user_login"><?php esc_html_e( 'Username or email', 'mikado1' ); ?></label> <input class="woocommerce-Input woocommerce-Input--text input-text placeholder" placeholder="<?php esc_attr_e('Username or email', 'mikado1'); ?>" type="text" name="user_login" id="user_login" /></p>

    <?php else : ?>

        <p><?php echo apply_filters( 'woocommerce_reset_password_message', esc_html__( 'Enter a new password below.', 'mikado1') ); ?></p>

        <p class="woocommerce-form-row woocommerce-form-row--first form-row form-row-first">
            <label for="password_1"><?php esc_html_e( 'New password', 'mikado1' ); ?> <span class="required">*</span></label>
            <input type="password" placeholder="<?php esc_attr_e('New password', 'mikado1'); ?>" class="woocommerce-Input woocommerce-Input--text input-text placeholder" name="password_1" id="password_1" />
        </p>
        <p class="woocommerce-form-row woocommerce-form-row--last form-row form-row-last">
            <label for="password_2"><?php esc_html_e( 'Re-enter new password', 'mikado1' ); ?> <span class="required">*</span></label>
            <input type="password" placeholder="<?php esc_attr_e('Re-enter new password', 'mikado1'); ?>" class="woocommerce-Input woocommerce-Input--text input-text placeholder" name="password_2" id="password_2" />
        </p>

        <input type="hidden" name="reset_key" value="<?php echo isset( $args['key'] ) ? $args['key'] : ''; ?>" />
        <input type="hidden" name="reset_login" value="<?php echo isset( $args['login'] ) ? $args['login'] : ''; ?>" />

    <?php endif; ?>

    <div class="clear"></div>

    <p class="woocommerce-FormRow form-row">
        <input type="hidden" name="wc_reset_password" value="true" />
        <input type="submit" class="woocommerce-Button button" value="<?php echo 'lost_password' == $args['form'] ? esc_attr__( 'Reset Password', 'mikado1' ) : esc_attr__( 'Save', 'mikado1' ); ?>" />
    </p>

    <?php wp_nonce_field( $args['form'] ); ?>

</form>