<?php 
$mkd_options = mikado_one_mikado_return_global_options();

if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_responsive-title-image", true) != ""){
 $responsive_title_image = esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_responsive-title-image", true));
}else{
	$responsive_title_image = esc_attr($mkd_options['responsive_title_image']);
}

if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_fixed-title-image", true) != ""){
 $fixed_title_image = esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_fixed-title-image", true));
}else{
	$fixed_title_image = esc_attr($mkd_options['fixed_title_image']);
}

$title_image = '';
if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_title-image", true) != ""){
    $title_image = esc_url(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_title-image", true));
}else{
    $title_image = esc_url($mkd_options['title_image']);
}
$title_image_height = "";
$title_image_width = "";
if($title_image !== ''){
	$title_image_dimensions_array = mikado_one_mikado_get_image_dimensions($title_image);
	if (count($title_image_dimensions_array)) {
    	$title_image_height = $title_image_dimensions_array["height"];
    	$title_image_width = $title_image_dimensions_array["width"];
	}
}

if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_title-overlay-image", true) != ""){
 $title_overlay_image = esc_url(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_title-overlay-image", true));
}else{
	$title_overlay_image = esc_url($mkd_options['title_overlay_image']);
}
$logo_width = $mkd_options['logo_width'];
$logo_height = $mkd_options['logo_height'];
$header_bottom_appearance = '';
if (isset($mkd_options['header_bottom_appearance'])) {
    $header_bottom_appearance = esc_attr($mkd_options['header_bottom_appearance']);
}

$header_top_border=0;
$header_bottom_border=0;
if(isset($mkd_options['enable_header_top_border']) && $mkd_options['enable_header_top_border']=='yes' && isset($mkd_options['header_top_border_width']) && $mkd_options['header_top_border_width']!==''){
    $header_top_border = esc_attr($mkd_options['header_top_border_width']);
}
if(isset($mkd_options['enable_header_bottom_border']) && $mkd_options['enable_header_bottom_border']=='yes' && isset($mkd_options['header_bottom_border_width']) && $mkd_options['header_bottom_border_width']!==''){
    $header_bottom_border = esc_attr($mkd_options['header_bottom_border_width']);
}

$header_centered_logo_border = 0;
if(isset($mkd_options['center_logo_image']) && $mkd_options['center_logo_image'] == "yes" && isset($mkd_options['enable_border_top_bottom_menu']) && $mkd_options['enable_border_top_bottom_menu'] == "yes"){
    $header_centered_logo_border = 2;
}

$header_height = 90;
if ($mkd_options['header_height'] && !empty($mkd_options['header_height']) && $header_bottom_appearance != "fixed_hiding") {
    $header_height = esc_attr($mkd_options['header_height']);
} elseif($header_bottom_appearance == "fixed_hiding"){
    $header_height = 90 + $logo_height/2 + 40; // 40 is top and bottom margin of logo
} elseif(isset($mkd_options['center_logo_image']) && $mkd_options['center_logo_image'] == "yes" && $header_bottom_appearance == "fixed") {
    if($header_bottom_appearance == "fixed" && $logo_height > 90){
        $header_height = 90 + 90 + 20; //20 is top and bottom margin of logo, 90 is default header height, other 90 is logo height
    }
    if($header_bottom_appearance == "fixed" && $logo_height < 90){
        $header_height = 90 + $logo_height + 20; //20 is top and bottom margin of logo, 90 is default header height
    }
}

if($mkd_options['header_bottom_appearance'] == 'stick menu_bottom'){
    $menu_bottom = 60;
    if(is_active_sidebar('header_fixed_right')){
        $menu_bottom = $menu_bottom + 26;
    }
} else {
    $menu_bottom = 0;
}


$header_height = $header_height + $menu_bottom + $header_top_border + $header_bottom_border + $header_centered_logo_border;

$header_top = 0;
if(isset($mkd_options['header_top_area']) && $mkd_options['header_top_area'] == "yes"){
    $header_top = 36;
}




$header_height_padding = 0;

if ($header_bottom_appearance != "fixed" && $header_bottom_appearance != "fixed_hiding" && $header_bottom_appearance != "regular") {
    if ($mkd_options['center_logo_image'] != "yes") {

        $header_height_padding = $header_top + $header_height;

    } else {
        if($header_bottom_appearance == "stick menu_bottom") {

            $header_height_padding = 20 + $logo_height/2 + $menu_bottom + $header_top + $header_top_border + $header_bottom_border + $header_centered_logo_border; // 20 is top margin of centered logo

        } elseif($header_bottom_appearance == "stick_with_left_right_menu"){

            $header_height_padding = $header_height + $header_top;

        }  else {

            $header_height_padding = (20 + $logo_height/2 + $header_height + $header_top); // 20 is top margin of centered logo
        }
    }
} else {
    $header_height_padding = $header_height + $header_top;
}

if (!empty($mkd_options['header_height'])) {
    if($header_bottom_appearance == "fixed_hiding") {
		$header_height_scroll_hidden_margin = $logo_height/2 + 20; //20 is top + bottom margin
		if(isset($mkd_options['header_height_scroll_hidden']) && $mkd_options['header_height_scroll_hidden'] != "" && ($logo_height/2 + 20) < $mkd_options['header_height_scroll_hidden']){
			$header_height_scroll_hidden_margin = esc_attr($mkd_options['header_height_scroll_hidden']) + 20; //20 is top + bottom margin
		}
        $header_height_padding =  esc_attr($mkd_options['header_height']) + $header_top + $header_height_scroll_hidden_margin + $header_top_border + $header_bottom_border + $header_centered_logo_border; // 40 is top and bottom margin of logo

	} elseif($mkd_options['center_logo_image'] == "yes"){
        if($header_bottom_appearance == "fixed") {
            if ($mkd_options['header_height'] > $logo_height) {
                $header_height_padding = esc_attr($mkd_options['header_height']) + $header_top + $logo_height + 20 + $header_top_border + $header_bottom_border + $header_centered_logo_border; // 20 is top margin of logo
            } else {
                $header_height_padding = (esc_attr($mkd_options['header_height'])) * 2 + $header_top + 20 + $header_top_border + $header_bottom_border + $header_centered_logo_border; // 20 is top margin of logo
            }
        }
        if($header_bottom_appearance == "stick"){
            $header_height_padding = (20 + $logo_height/2 + esc_attr($mkd_options['header_height']) + $header_top + $header_top_border + $header_bottom_border + $header_centered_logo_border); // 20 is top margin of centered logo
        }
    } else {
        if($header_bottom_appearance != "stick menu_bottom") {
            $header_height_padding = esc_attr($mkd_options['header_height']) + $header_top + $header_top_border + $header_bottom_border + $header_centered_logo_border;
        }
    }
}

$title_type = "standard_title";
if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page_title_type", true) != ""){
    $title_type = esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page_title_type", true));
}else{
    if(isset($mkd_options['title_type'])){
        $title_type = esc_attr($mkd_options['title_type']);
    }
}
if(is_404()){
	$title_type = "breadcrumbs_title";
}

//init variables
$title_subtitle_padding 	= '';
$header_transparency 		= '';
$is_header_transparent  	= false;
$transparent_values_array 	= array('0.00', '0');
$solid_values_array			= array('', '1');
$header_bottom_border		= '';
$is_title_area_visible		= true;
$is_title_text_visible		= true;
$is_title_oblique_visible	= false;

//this is done this way because content was already created
//and we had to keep current settings for existing pages
//checkbox that was previously here had 'yes' value when title area is hidden
if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_show-page-title", true) == 'yes') {
	$is_title_area_visible = true;
} elseif(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_show-page-title", true) == 'no') {
	$is_title_area_visible = false;
} elseif(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_show-page-title", true) == '' && (isset($mkd_options['show_page_title']) && $mkd_options['show_page_title'] == 'yes')) {
	$is_title_area_visible = true;
} elseif(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_show-page-title", true) == '' && (isset($mkd_options['show_page_title']) && $mkd_options['show_page_title'] == 'no')) {
	$is_title_area_visible = false;
} elseif(isset($mkd_options['show_page_title']) && $mkd_options['show_page_title'] == 'yes') {
	$is_title_area_visible = true;
}

//is title text visible
if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_show_page_title_text", true) == 'yes') {
	$is_title_text_visible = true;
} elseif(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_show_page_title_text", true) == 'no') {
	$is_title_text_visible = false;
} elseif(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_show_page_title_text", true) == '' && (isset($mkd_options['show_page_title_text']) && $mkd_options['show_page_title_text'] == 'yes')) {
	$is_title_text_visible = true;
} elseif(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_show_page_title_text", true) == '' && (isset($mkd_options['show_page_title_text']) && $mkd_options['show_page_title_text'] == 'no')) {
	$is_title_text_visible = false;
} elseif(isset($mkd_options['show_page_title_text']) && $mkd_options['show_page_title_text'] == 'yes') {
	$is_title_text_visible = true;
}

//is title oblique enabled
if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_enable_page_title_oblique", true) == 'yes') {
	$is_title_oblique_visible = true;
} elseif(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_enable_page_title_oblique", true) == 'no') {
	$is_title_oblique_visible = false;
} elseif(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_enable_page_title_oblique", true) == '' && (isset($mkd_options['enable_title_oblique']) && $mkd_options['enable_title_oblique'] == 'yes')) {
	$is_title_oblique_visible = true;
} elseif(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_enable_page_title_oblique", true) == '' && (isset($mkd_options['enable_title_oblique']) && $mkd_options['enable_title_oblique'] == 'no')) {
	$is_title_oblique_visible = false;
} elseif(isset($mkd_options['enable_title_oblique']) && $mkd_options['enable_title_oblique'] == 'yes') {
	$is_title_oblique_visible = true;
}

//title oblique background color
$title_oblique_background_color = '';
if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_title_oblique_section_color", true) != ""){
    $title_oblique_background_color = esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_title_oblique_section_color", true));
}else{
	if(isset($mkd_options['title_oblique_section_color'])){
		$title_oblique_background_color = esc_attr($mkd_options['title_oblique_section_color']);
	}
}

//title oblique position
$title_oblique_position = '';
if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_title_oblique_section_position", true) == 'from_left_to_right') {
	$title_oblique_position = 'from_left_to_right';
}elseif(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_title_oblique_section_position", true) == 'from_right_to_left') {
	$title_oblique_position = 'from_right_to_left';
}elseif(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_title_oblique_section_position", true) == '' && (isset($mkd_options['title_oblique_section_position']) && $mkd_options['title_oblique_section_position'] == 'from_left_to_right')) {
	$title_oblique_position = 'from_left_to_right';
} elseif(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_title_oblique_section_position", true) == '' && (isset($mkd_options['title_oblique_section_position']) && $mkd_options['title_oblique_section_position'] == 'from_right_to_left')) {
	$title_oblique_position = 'from_right_to_left';
}



//is header transparent not set on current page?
if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_header_color_transparency_per_page", true) === "") {
	//take global value set in Mikado Options
	$header_transparency = esc_attr($mkd_options['header_background_transparency_initial']);
} else {
	//take value set for current page
	$header_transparency = esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_header_color_transparency_per_page", true));
}

//is header completely transparent?
$is_header_transparent 	= in_array($header_transparency, $transparent_values_array);

//is header solid?
$is_header_solid		= in_array($header_transparency, $solid_values_array);

$title_height = 200; // default title height without header height
if($title_type == "breadcrumbs_title") {
    $title_height = 88;
}

if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_title-height", true) != ""){
	$title_height = esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_title-height", true));
}elseif($mkd_options['title_height'] != ''){
	$title_height = esc_attr($mkd_options['title_height']);
}
//is header solid?
if(!$is_header_solid && $mkd_options['header_bottom_appearance'] != 'regular' && get_post_meta(mikado_one_mikado_get_page_id(), "mkd_enable_content_top_margin", true) != "yes"){
//	if ((isset($mkd_options['center_logo_image']) && $mkd_options['center_logo_image'] == "yes") || $mkd_options['header_bottom_appearance'] == 'fixed_hiding') {
//		if($mkd_options['header_bottom_appearance'] == 'stick menu_bottom'){
//	        $title_height = $title_height + $header_height + $header_top + $logo_height + 20; // 20 is top margin of centered logo
//	    } elseif($mkd_options['header_bottom_appearance'] == 'fixed_hiding' || $mkd_options['header_bottom_appearance'] == 'fixed'){
//	        if(!empty($mkd_options['header_height']) && $mkd_options['header_bottom_appearance'] == "fixed"){
//	        	$title_height = $title_height + $mkd_options['header_height'] + $header_top + $logo_height + 20;
//	        } else {
//	        	$title_height = $title_height + $header_height + $header_top;
//	        }
//	    } else {
//	        $title_height = $title_height + $header_height + $header_top + $logo_height + 20; // 20 is top margin of centered logo
//	    }
//	} else {
//		$title_height = $title_height + $header_height + $header_top;
//	}
    $title_height = $title_height + $header_height_padding;
	//is header semi-transparent?
	if(!$is_header_transparent) {
		$title_calculated_height = $title_height - $header_height_padding;

		if($title_calculated_height < 0) {
			$title_calculated_height = 0;
		}

		//center title between border and end of title section
		$title_holder_height = 'padding-top:' . $header_height_padding . 'px;height:' . ($title_calculated_height) . 'px;';
		$title_subtitle_padding = 'padding-top:' . $header_height_padding . 'px;';
	} else {
		//header is transparent
		$title_holder_height = 'padding-top:'.$header_height_padding.'px;height:'.($title_height - $header_height_padding).'px;';
		$title_subtitle_padding = 'padding-top:'.$header_height_padding.'px;';
	}
} else {
	$title_holder_height = 'height:'.$title_height.'px;';
	$title_subtitle_padding = '';
}

$title_background_color = '';
if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page-title-background-color", true) != ""){
    $title_background_color = esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page-title-background-color", true));
}else{
    $title_background_color = esc_attr($mkd_options['title_background_color']);
}

$show_title_image = true;
if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_show-page-title-image", true) == "yes") {
    $show_title_image = false;
}
$mkd_page_title_style = "standard";
if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page_title_style", true) != ""){
    $mkd_page_title_style = esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page_title_style", true));
}else{
    if(isset($mkd_options['title_style'])) {
        $mkd_page_title_style = esc_attr($mkd_options['title_style']);
    } else {
        $mkd_page_title_style = "standard";
    }
}

$animate_title_area = '';
if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_animate_page_title", true) != ""){
    $animate_title_area = esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_animate_page_title", true));
}else{
    $animate_title_area = esc_attr($mkd_options['animate_title_area']);
}

if($animate_title_area == "text_right_left") {
    $animate_title_class = "animate_title_text";
} elseif($animate_title_area == "area_top_bottom"){
    $animate_title_class = "animate_title_area";
} else {
    $animate_title_class = "title_without_animation";
}

$enable_paspartu = false;
if(isset($mkd_options['paspartu']) && $mkd_options['paspartu'] == 'yes'){
    $enable_paspartu = true;
}


//is vertical menu activated in Mikado Options?
if(isset($mkd_options['vertical_area']) && $mkd_options['vertical_area'] =='yes' && !$enable_paspartu){
    $title_subtitle_padding = 0;
    $title_holder_height = 200;
    if($title_type == "breadcrumbs_title") {
        $title_holder_height = 100;
    }
    $title_height = 200; // default title height without header height
    if($title_type == "breadcrumbs_title") {
        $title_height = 100;
    }
    if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_title-height", true) != ""){
        $title_holder_height = esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_title-height", true));
        $title_height = esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_title-height", true));
    }else if($mkd_options['title_height'] != ''){
        $title_holder_height = esc_attr($mkd_options['title_height']);
        $title_height = esc_attr($mkd_options['title_height']);
    }
    $title_holder_height = 'height:' . $title_holder_height . 'px;';
}

$enable_breadcrumbs = 'no';
if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_enable_breadcrumbs", true) != ""){
	$enable_breadcrumbs = esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_enable_breadcrumbs", true));
}elseif(isset($mkd_options['enable_breadcrumbs'])){
	$enable_breadcrumbs = esc_attr($mkd_options['enable_breadcrumbs']);
}

$title_text_shadow = '';
if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_title_text_shadow", true) != ""){
	if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_title_text_shadow", true) == "yes"){
		$title_text_shadow = ' title_text_shadow';
	}
}else{
	if($mkd_options['title_text_shadow'] == "yes"){
		$title_text_shadow = ' title_text_shadow';
	}
}
$subtitle_color ="";
if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page_subtitle_color", true) != ""){
	$subtitle_color = "color:" . esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page_subtitle_color", true)) . ";";
}

if (is_tag()) {
	$title = single_term_title("", false)." Tag";
}elseif (is_date()) {
	$title = get_the_time('F Y');
}elseif (is_author()){
	$title = esc_html__('Author:','mikado1').get_the_author();
}elseif (is_category()){
	$title = single_cat_title('', false);
}elseif (is_home()){
	$title = get_option('blogname');
}elseif (is_search()){
	$title = esc_html__('Results for','mikado1').': '.get_search_query();
}elseif (is_404()){
	if($mkd_options['404_title'] != "") {
		$title = esc_html($mkd_options['404_title']);
	} else { 
		$title = esc_html__('404 - Page not found','mikado1');
	}
}elseif(function_exists("is_woocommerce") && (is_shop() || is_singular('product'))){
	global $woocommerce;
	$shop_id = get_option('woocommerce_shop_page_id');
	$shop= get_page($shop_id);
    if(isset($shop->post_title) && $shop->post_title !== '') {
	$title = $shop->post_title;
    }
}elseif(function_exists("is_woocommerce") && (is_product_category() || is_product_tag())){
	global $wp_query;
	$tax = $wp_query->get_queried_object();
	$category_title = $tax->name;
	$title = $category_title;
}elseif (is_archive()){
	$title = esc_html__('Archive','mikado1');
}else {
	$title = get_the_title(mikado_one_mikado_get_page_id());
}

$title_separator = "";
$title_separator_style = "";
$separator_title_position = "";
if(!empty($mkd_options['title_separator']) && $mkd_options['title_separator']=='yes'){
    $title_separator = "yes";

    if(isset($mkd_options['page_title_position']) && !empty($mkd_options['page_title_position'])) {
        $separator_title_position = "position_".esc_attr($mkd_options['page_title_position']);
    }

    if(!empty($mkd_options['title_separator_color'])){
        $title_separator_style .= 'border-color:'.esc_attr($mkd_options['title_separator_color']).';';
    }

    if(isset($mkd_options['title_separator_thickness']) && !empty($mkd_options['title_separator_thickness'])) {
        $title_separator_style .= 'border-width: ' . esc_attr($mkd_options['title_separator_thickness']) . 'px 0 0;';
    }

    if(isset($mkd_options['title_separator_width']) && !empty($mkd_options['title_separator_width'])) {
        $title_separator_style .= 'width: ' . esc_attr($mkd_options['title_separator_width']) . 'px;';
    }

    if(isset($mkd_options['title_separator_topmargin']) && !empty($mkd_options['title_separator_topmargin'])) {
        $title_separator_style .= 'margin-top: ' . esc_attr($mkd_options['title_separator_topmargin']) . 'px;';
    }

    if(isset($mkd_options['title_separator_bottommargin']) && !empty($mkd_options['title_separator_bottommargin'])) {
        $title_separator_style .= 'margin-bottom: ' . esc_attr($mkd_options['title_separator_bottommargin']) . 'px;';
    }

    if(isset($mkd_options['title_separator_type']) && !empty($mkd_options['title_separator_type'])) {
        $title_separator_style .= 'border-style: ' . esc_attr($mkd_options['title_separator_type']) . ';';
    }

}

$title_classes = '';

if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_show_page_title_text", true) == 'no') {
	$title_classes = 'without_title_text';
}
if($is_title_area_visible) { ?>
	<div class="title_outer <?php echo esc_attr($animate_title_class.$title_text_shadow); if($responsive_title_image == 'yes' && $show_title_image == true && $title_image !== ''){ echo ' with_image'; }?>" <?php echo 'data-height="'.esc_attr($title_height).'"'; if($title_height != '' && $animate_title_area == 'area_top_bottom'){ echo ' style="opacity:0;height:' . esc_attr($header_height_padding) .'px;"'; } ?>>
		<div class="title <?php mikado_one_mikado_title_classes(); ?>" style="<?php if( $responsive_title_image == 'no' && $title_image != "" && $show_title_image == true){ if( $title_image_width != ''){ echo 'background-size:' . esc_attr($title_image_width) . 'px auto;'; } echo 'background-image:url(' . esc_url($title_image) . ');';  } if( $title_height != ''){ echo 'height:' . esc_attr($title_height) . 'px;'; } if( $title_background_color != ''){ echo 'background-color:' . esc_attr($title_background_color) . ';'; } ?>">
			<div class="image <?php if($responsive_title_image == 'yes' && $title_image != "" && $show_title_image == true){ echo "responsive"; }else{ echo "not_responsive"; } ?>"><?php if($title_image != ""){ ?><img src="<?php echo esc_url($title_image); ?>" alt="&nbsp;" /> <?php } ?></div>
			<?php if($title_overlay_image != ""){ ?>
				<div class="title_overlay" style="background-image:url('<?php echo esc_url($title_overlay_image); ?>');"></div>
			<?php } ?>

			<div class="title_holder" <?php if(($title_image !== '' && $responsive_title_image != 'yes' && $show_title_image == true) || ($title_type == 'breadcrumbs_title' && $title_image == '')){ mikado_one_mikado_style_attr($title_holder_height); }?>>
				<div class="container">
					<div class="container_inner clearfix">
						<div class="title_subtitle_holder" <?php if($title_image !== '' && $responsive_title_image == 'yes' && $show_title_image == true){ mikado_one_mikado_style_attr($title_subtitle_padding); }?>>
							<?php if(($responsive_title_image == 'yes' && $show_title_image == true) || ($fixed_title_image == "yes" || $fixed_title_image == "yes_zoom") || ($responsive_title_image == 'no' && $title_image != "" && $fixed_title_image == "no" && $show_title_image == true)){ ?>
							<div class="title_subtitle_holder_inner">
							<?php } ?>
								<?php if($title_type != "breadcrumbs_title") { ?>
									<?php if($is_title_text_visible) { ?>
										<h1<?php if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page-title-color", true)) { ?> style="color:<?php echo esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page-title-color", true)) ?>" <?php } ?>><span><?php echo esc_html($title); ?></span></h1>
									<?php } ?>
									<?php if($title_separator == "yes"){ ?>
										<span class="separator small <?php echo esc_attr($separator_title_position); ?>" <?php mikado_one_mikado_style_attr($title_separator_style); ?>></span>
									<?php } ?>

									<?php if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page_subtitle", true) != ""){ ?>
										<span class="subtitle" <?php mikado_one_mikado_style_attr($subtitle_color); ?>><?php echo wp_kses(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page_subtitle", true), array( 'br' => array())); ?></span>
									<?php } ?>
									<?php if ( function_exists( 'mikado_one_mikado_custom_breadcrumbs' ) && $enable_breadcrumbs == "yes") { ?>
										<div class="breadcrumb"> <?php mikado_one_mikado_custom_breadcrumbs(); ?></div>
									<?php } ?>

								<?php } else { ?>

									<div class="breadcrumb"> <?php mikado_one_mikado_custom_breadcrumbs(); ?></div>

								<?php } ?>
							<?php if(($responsive_title_image == 'yes' && $show_title_image == true)  || ($fixed_title_image == "yes" || $fixed_title_image == "yes_zoom") || ($responsive_title_image == 'no' && $title_image != "" && $fixed_title_image == "no" && $show_title_image == true)){ ?>
							</div>
							<?php } ?>
						</div>
					</div>
				</div>
			</div>
			 <?php if ($is_title_oblique_visible){ ?>
			<svg class="oblique-section svg-title-bottom" preserveAspectRatio="none" viewBox="0 0 86 86" width="100%" height="86">
				<?php if($title_oblique_position == 'from_left_to_right'){ ?>
					<polygon style="fill: <?php echo esc_attr($title_oblique_background_color)?>;" points="0,0 0,86 86,86" />
				<?php }
				if($title_oblique_position == 'from_right_to_left'){ ?>
					<polygon style="fill: <?php echo esc_attr($title_oblique_background_color); ?>;" points="0,86 86,0 86,86" />
				<?php } ?>
			</svg>
		<?php } ?>
		</div>
	</div>
<?php } ?>