<?php

//init variables
$portfolio_template = 'small-images';

//is portfolio template set for current portfolio?
if(get_post_meta(get_the_ID(), "mkd_choose-portfolio-single-view", true) != "") {
	$portfolio_template = esc_attr(get_post_meta(get_the_ID(), "mkd_choose-portfolio-single-view", true));
} elseif($mkd_options['portfolio_style'] !== '') {
	//get default portfolio template if set in theme's options
	$portfolio_template = esc_attr($mkd_options['portfolio_style']);
}
?>

<?php get_header(); ?>
	<?php if (have_posts()) : ?>
		<?php while (have_posts()) : the_post(); ?>
			<?php if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page_scroll_amount_for_sticky", true)) { ?>
				<script>
				var page_scroll_amount_for_sticky = <?php echo esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page_scroll_amount_for_sticky", true)); ?>;
				</script>
			<?php } ?>
				<?php get_template_part( 'title' ); ?>
			<?php
			$revslider = get_post_meta(mikado_one_mikado_get_page_id(), "mkd_revolution-slider", true);
			if (!empty($revslider)){ ?>
				<div class="mkd_slider">
					<div class="mkd_slider_inner">
						<?php echo do_shortcode($revslider); ?>
					</div> <!-- close div.mkd_slider_inner -->
				</div> <!-- close div.mkd_slider -->
			<?php
			}

			//is current portfolio template full width?
			if($portfolio_template !== 'full-width-custom') {
				//load general portfolio structure which will load proper template
				get_template_part('templates/portfolio/portfolio-structure');
			} else {
				//load custom full width template that doesn't have anything in common with other
				get_template_part('templates/portfolio/portfolio', $portfolio_template);
			}
			?>
		<?php endwhile; ?>
		<?php wp_reset_postdata(); ?>
	<?php endif; ?>	
<?php get_footer(); ?>	