<?php

if(!function_exists( 'mikado_one_mikado_title_classes' )) {
	/**
	 * Function that adds classes to title div.
	 * All other functions are tied to it with add_filter function
	 * @param array $classes array of classes
	 */
	function mikado_one_mikado_title_classes($classes = array()) {
		$classes = array();
		$classes = apply_filters('mikado_one_mikado_filter_title_classes', $classes);

		if(is_array($classes) && count($classes)) {
			echo esc_attr(implode(' ', $classes));
		}
	}
}

if(!function_exists( 'mikado_one_mikado_title_position_class' )) {
	/**
	 * Function that adds class on title based on title position option
	 * Could be left, centered or right
	 * @param $classes original array of classes
	 * @return array changed array of classes
	 */
	function mikado_one_mikado_title_position_class($classes) {
		$mkd_options = mikado_one_mikado_return_global_options();

		//init variables
		$title_position = 'left';

		if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page_title_position", true) != "") {
			$title_position = esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page_title_position", true));

		} elseif($mkd_options['page_title_position'] !== '') {
			$title_position = esc_attr($mkd_options['page_title_position']);
		}

		$classes[] = 'position_'.$title_position;

		return $classes;
	}

	add_filter('mikado_one_mikado_filter_title_classes', 'mikado_one_mikado_title_position_class');
}

if(!function_exists( 'mikado_one_mikado_title_background_image_classes' )) {
	function mikado_one_mikado_title_background_image_classes($classes) {
		$mkd_options = mikado_one_mikado_return_global_options();

		$is_img_responsive 		= '';
		$is_image_fixed			= '';
		$is_image_fixed_array 	= array('yes', 'yes_zoom');
		$show_title_img			= true;
		$title_img				= '';

		//is responsive image is set for current page?
		if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_responsive-title-image", true) != "") {
			$is_img_responsive = esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_responsive-title-image", true));
		} elseif ( $mkd_options['responsive_title_image'] !== '' ) {
			//take value from theme options
			$is_img_responsive = esc_attr($mkd_options['responsive_title_image']);
		}

		//is title image chosen for current page?
		if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_title-image", true) != ""){
			$title_img = esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_title-image", true));
		} elseif ( $mkd_options['title_image'] !== '' ){
			//take image that is set in theme options
			$title_img = esc_attr($mkd_options['title_image']);
		}

		//is image set to be fixed for current page?
		if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_fixed-title-image", true) != ""){
			$is_image_fixed = esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_fixed-title-image", true));
		}elseif($mkd_options['fixed_title_image'] !== ''){
			//take setting from theme options
			$is_image_fixed = esc_attr($mkd_options['fixed_title_image']);
		}

		//is title image hidden for current page?
		if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_show-page-title-image", true) == "yes") {
			$show_title_img = false;
		}

		//is title image set and visible?
		if($title_img !== '' && $show_title_img == true) {
			//is image not responsive and parallax title is set?
			if($is_img_responsive == 'no' && in_array($is_image_fixed, $is_image_fixed_array)) {
				$classes[] = 'has_fixed_background';

				if($is_image_fixed == 'yes_zoom') {
					$classes[] = 'zoom_out';
				}
			}
			//is image not responsive and parallax title isn't set?
			elseif($is_img_responsive == 'no') {
				$classes[] = 'has_background';
			}
		}

		return $classes;
	}

	add_filter('mikado_one_mikado_filter_title_classes', 'mikado_one_mikado_title_background_image_classes');
}

if(!function_exists( 'mikado_one_mikado_title_text_is_hidden_class' )) {
	function mikado_one_mikado_title_text_is_hidden_class($classes) {
		$mkd_options = mikado_one_mikado_return_global_options();
		$is_title_text_visible = true;

		if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_show_page_title_text", true) == 'yes') {
			$is_title_text_visible = true;
		} elseif(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_show_page_title_text", true) == 'no') {
			$is_title_text_visible = false;
		} elseif(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_show_page_title_text", true) == '' && (isset($mkd_options['show_page_title_text']) && $mkd_options['show_page_title_text'] == 'yes')) {
			$is_title_text_visible = true;
		} elseif(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_show_page_title_text", true) == '' && (isset($mkd_options['show_page_title_text']) && $mkd_options['show_page_title_text'] == 'no')) {
			$is_title_text_visible = false;
		} elseif(isset($mkd_options['show_page_title_text']) && $mkd_options['show_page_title_text'] == 'yes') {
			$is_title_text_visible = true;
		}

		if(!$is_title_text_visible) {
			$classes[] = 'without_title_text';
		}

		return $classes;
	}

	add_filter('mikado_one_mikado_filter_title_classes', 'mikado_one_mikado_title_text_is_hidden_class');
}

if(!function_exists( 'mikado_one_mikado_title_oblique_class' )) {
	function mikado_one_mikado_title_oblique_class($classes) {
		$mkd_options = mikado_one_mikado_return_global_options();
		$is_title_oblique_visible = true;

		//is title oblique enabled
		if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_enable_page_title_oblique", true) == 'yes') {
			$is_title_oblique_visible = true;
		} elseif(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_enable_page_title_oblique", true) == 'no') {
			$is_title_oblique_visible = false;
		} elseif(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_enable_page_title_oblique", true) == '' && (isset($mkd_options['enable_title_oblique']) && $mkd_options['enable_title_oblique'] == 'yes')) {
			$is_title_oblique_visible = true;
		} elseif(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_enable_page_title_oblique", true) == '' && (isset($mkd_options['enable_title_oblique']) && $mkd_options['enable_title_oblique'] == 'no')) {
			$is_title_oblique_visible = false;
		} elseif(isset($mkd_options['enable_title_oblique']) && $mkd_options['enable_title_oblique'] == 'yes') {
			$is_title_oblique_visible = true;
		}

		if($is_title_oblique_visible) {
			$classes[] = 'with_oblique';
		}

		return $classes;
	}

	add_filter('mikado_one_mikado_filter_title_classes', 'mikado_one_mikado_title_oblique_class');
}

if(!function_exists( 'mikado_one_mikado_title_breadcrumb_type_class' )) {
    function mikado_one_mikado_title_breadcrumb_type_class($classes) {
	    $mkd_options = mikado_one_mikado_return_global_options();

        $title_type = "standard_title";
        if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page_title_type", true) != ""){
            $title_type = get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page_title_type", true);
        }else if(is_404()){
            $title_type = "breadcrumbs_title";
        }else if ($mkd_options['title_type'] !== ''){
            $title_type = esc_attr($mkd_options['title_type']);
        }

        $classes[] = $title_type;

        return $classes;
    }

    add_filter('mikado_one_mikado_filter_title_classes', 'mikado_one_mikado_title_breadcrumb_type_class');
}

if(!function_exists( 'mikado_one_mikado_title_background_color_class' )) {
	function mikado_one_mikado_title_background_color_class($classes) {
		$mkd_options = mikado_one_mikado_return_global_options();

		//init variables
		$title_img	= '';
		$title_bg_color = '';

		//is title image chosen for current page?
		if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_title-image", true) != ""){
			$title_img = esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_title-image", true));
		} elseif ( $mkd_options['title_image'] !== '' ){
			//take image that is set in theme options
			$title_img = esc_attr($mkd_options['title_image']);
		}

		//is title background color set?
		if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page-title-background-color", true) != ""){
			$title_bg_color = esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page-title-background-color", true));
		}else if($mkd_options['title_background_color'] !== ''){
			//take background color from
			$title_bg_color = esc_attr($mkd_options['title_background_color']);
		}

		if($title_bg_color !== '' && $title_img === '') {
			$classes[] = 'with_background_color';
		}

		return $classes;
	}

	add_filter('mikado_one_mikado_filter_title_classes', 'mikado_one_mikado_title_background_color_class');
}