<?php

if(!function_exists( 'mikado_one_mikado_option_has_value' )) {
	/**
	 * Function that checks if field exists either in theme options or in custom fields
	 * @param $name string name of the field
	 * @return bool
	 */
	function mikado_one_mikado_option_has_value($name) {
		$mkd_options = mikado_one_mikado_return_global_options();
		$mkdFramework = mikado_one_mikado_return_framework();

		if (array_key_exists($name, $mkdFramework->mkdOptions->options)) {
			if(isset($mkd_options[$name])){
				return true;
			} else {
				return false;
			}
		} else {
			global $post;

			$value = get_post_meta( $post->ID, $name, true );
			if (isset($value) && $value !== "") {
				return true;
			} else {
				return false;
			}
		}
	}

}

if(!function_exists( 'mikado_one_mikado_option_get_value' )) {
	/**
	 * Function that retrieves field's value from theme options or from custom fields
	 * @param $name string name of the field
	 * @return mixed|void
	 */
	function mikado_one_mikado_option_get_value($name) {
		$mkd_options = mikado_one_mikado_return_global_options();
		$mkdFramework = mikado_one_mikado_return_framework();

		if (array_key_exists($name, $mkdFramework->mkdOptions->options)) {
			if(isset($mkd_options[$name])){
				return $mkd_options[$name];
			} else {
				return $mkdFramework->mkdOptions->getOption($name);
			}
		} else {
			global $post;
			if(is_object($post) && property_exists($post, 'ID')) {
				$value = get_post_meta( $post->ID, $name, true );
				if (isset($value) && $value !== "") {
					return $value;
				} else {
					return $mkdFramework->mkdMetaBoxes->getOption($name);
				}

			}

			return '';
		}
	}
}

if(!function_exists( 'mikado_one_mikado_get_attachment_thumb_url' )) {
	/**
	 * Function that get's url of thumbnail. Searches in database for attachment post based on url
	 *
	 * @param $attachment_url string url of the attachment
	 *
	 * @return bool|string url of thumbnail or false if attachment doesn't exists in database
	 *
	 * @see mikado_one_mikado_get_attachment_id_from_url()
	 */
	function mikado_one_mikado_get_attachment_thumb_url($attachment_url) {
		$attachment_id = mikado_one_mikado_get_attachment_id_from_url($attachment_url);

		if(!empty($attachment_id)) {
			return wp_get_attachment_thumb_url($attachment_id);
		} else {
			return $attachment_url;
		}
	}
}
