var $j = jQuery.noConflict();

$j(window).load(function(){
	"use strict";

	initMikadoCarousel();
});

/*
 ** Init Mikado Carousel
 */
function initMikadoCarousel(){
	"use strict";

	if($j('.mkd_carousels').length){
		$j('.mkd_carousels').each(function(){
			var itemWidth = ($j(this).parents('.grid_section').length == 1) ? 216 : 380;
			var instance = this;
			$j(this).find('.slides').carouFredSel({
				circular: true,
				responsive: true,
				scroll : {
					items           : 1,
					duration        : 1000,
					pauseOnHover    : false
				},
				prev : {
					button : function() {
						return $j(this).parent().siblings('.caroufredsel-direction-nav').find('.mkd_carousel_prev');
					}
				},
				next : {
					button : function() {
						return $j(this).parent().siblings('.caroufredsel-direction-nav').find('.mkd_carousel_next');
					}
				},
				items: {
					width: itemWidth,
					visible: {
						min: 1,
						max: 5
					}
				},
				auto: true,
				mousewheel: false,
				swipe: {
					onMouse: true,
					onTouch: true
				}

			}).animate({'opacity': 1},1000);
		});
		calculateHeights();
	}
}