<?php

global $mkd_toolbar;
$mkd_toolbar = false;
global $mkd_demo_landing;
$mkd_demo_landing = false;

//defined content width variable
if ( ! isset( $content_width ) ) {
	$content_width = 1060;
}

if ( isset( $mkd_toolbar ) ) {
	/*
	 * Add actions if toolbar is shown
	 */
	add_action( 'after_setup_theme', 'mikado_one_mikado_start_sesstion', 1 );
	add_action( 'wp_logout', 'mikado_one_mikado_end_session' );
	add_action( 'wp_login', 'mikado_one_mikado_end_session' );

	/* Start session */
	if ( ! function_exists( 'mikado_one_mikado_start_sesstion' ) ) {
		function mikado_one_mikado_start_sesstion() {
			if ( ! session_id() ) {
				session_start();
			}
			if ( ! empty( $_GET['animation'] ) ) {
				$_SESSION['mkd_animation'] = $_GET['animation'];
			}
			if ( isset( $_SESSION['mkd_animation'] ) ) {
				if ( $_SESSION['mkd_animation'] == "off" ) {
					$_SESSION['mkd_animation'] = "";
				}
			}
		}
	}

	/* End session */

	if ( ! function_exists( 'mikado_one_mikado_end_session' ) ) {
		function mikado_one_mikado_end_session() {
			session_destroy();
		}
	}
}


if ( ! function_exists( 'mikado_one_mikado_get_demo_landing_param' ) ) {
	function mikado_one_mikado_get_demo_landing_param() {
		global $mkd_demo_landing;

		return $mkd_demo_landing;


	}
}

if ( ! function_exists( 'mikado_one_mikado_get_toolbar_param' ) ) {
	function mikado_one_mikado_get_toolbar_param() {
		global $mkd_toolbar;

		return $mkd_toolbar;


	}
}


if ( ! function_exists( 'mikado_one_mikado_return_global_options' ) ) {
	function mikado_one_mikado_return_global_options() {
		global $mkd_options;

		return $mkd_options;
	}
}

if ( ! function_exists( 'mikado_one_mikado_return_is_ie' ) ) {
	function mikado_one_mikado_return_is_ie() {
		global $is_IE;

		return $is_IE;
	}
}


if ( ! function_exists( 'mikado_one_mikado_return_template_name' ) ) {
	function mikado_one_mikado_return_template_name() {
		return get_page_template_slug( mikado_one_mikado_get_page_id() );
	}
}


if ( ! function_exists( 'mikado_one_mikado_return_framework' ) ) {
	function mikado_one_mikado_return_framework() {
		global $mkdFramework;

		return $mkdFramework;
	}
}

if ( ! function_exists( 'mikado_one_mikado_get_page_id' ) ) {
	/**
	 * Function that returns current page / post id.
	 * Checks if current page is woocommerce page and returns that id if it is.
	 * Checks if current page is any archive page (category, tag, date, author etc.) and returns -1 because that isn't
	 * page that is created in WP admin.
	 *
	 * @return int
	 *
	 * @version 0.1
	 *
	 * @see mikado_one_mikado_is_plugin_installed()
	 * @see mikado_one_mikado_is_woocommerce_shop()
	 */
	function mikado_one_mikado_get_page_id() {
		if ( mikado_one_mikado_is_plugin_installed( 'woocommerce' ) && mikado_one_mikado_is_woocommerce_shop() ) {
			return mikado_one_mikado_get_woo_shop_page_id();
		}

		if ( mikado_one_mikado_is_default_wp_template() ) {
			return - 1;
		}

		return get_queried_object_id();
	}
}


if ( ! function_exists( 'mikado_one_mikado_is_plugin_installed' ) ) {
	/**
	 * Function that checks if forward plugin installed
	 *
	 * @param $plugin string
	 *
	 * @return bool
	 */
	function mikado_one_mikado_is_plugin_installed( $plugin ) {
		switch ( $plugin ) {
			case 'core':
				return defined( 'MKD_CORE_VERSION' );
				break;
			case 'woocommerce':
				return function_exists( 'is_woocommerce' );
				break;
			case 'visual-composer':
				return class_exists( 'WPBakeryVisualComposerAbstract' );
				break;
			case 'revolution-slider':
				return class_exists( 'RevSliderFront' );
				break;
			case 'layerslider':
				return defined( 'LS_PLUGIN_VERSION' );
				break;
			case 'contact-form-7':
				return defined( 'WPCF7_VERSION' );
				break;
			case 'wpml':
				return defined( 'ICL_SITEPRESS_VERSION' );
				break;
			case 'gutenberg-editor':
				return class_exists( 'WP_Block_Type' );
				break;
			case 'gutenberg-plugin':
				return function_exists( 'is_gutenberg_page' ) && is_gutenberg_page();
				break;
			case 'yoast':
				return defined( 'WPSEO_VERSION' );
				break;
			case 'buddypress':
				return function_exists( 'bp_is_active' );
				break;
			default:
				return false;
				break;
		}
	}
}

if ( ! function_exists( 'mikado_one_mikado_get_module_part' ) ) {
	function mikado_one_mikado_get_module_part( $module ) {
		return $module;
	}
}

if ( ! function_exists( 'mikado_one_mikado_is_woocommerce_shop' ) ) {
	/**
	 * Function that checks if current page is shop or product page
	 * @return bool
	 *
	 * @see is_shop()
	 */
	function mikado_one_mikado_is_woocommerce_shop() {
		return function_exists( 'is_shop' ) && ( is_shop() || is_product() );
	}
}

if ( ! function_exists( 'mikado_one_mikado_get_woo_shop_page_id' ) ) {
	/**
	 * Function that returns shop page id that is set in WooCommerce settings page
	 * @return int id of shop page
	 */
	function mikado_one_mikado_get_woo_shop_page_id() {
		if ( mikado_one_mikado_is_plugin_installed( 'woocommerce' ) ) {
			//get shop page id from options table
			$shop_id = get_option( 'woocommerce_shop_page_id' );
			$page_id = ! empty( $shop_id ) ? $shop_id : '-1';

			return $page_id;
		}
	}
}


if ( ! function_exists( 'mikado_one_mikado_is_default_wp_template' ) ) {
	/**
	 * Function that checks if current page archive page, search, 404 or default home blog page
	 * @return bool
	 *
	 * @see is_archive()
	 * @see is_search()
	 * @see is_404()
	 * @see is_front_page()
	 * @see is_home()
	 */
	function mikado_one_mikado_is_default_wp_template() {
		return is_archive() || is_search() || is_404() || ( is_front_page() && is_home() );
	}
}

if ( ! function_exists( 'mikado_one_mikado_is_woocommerce_installed' ) ) {
	/**
	 * Function that checks if woocommerce is installed
	 * @return bool
	 */
	function mikado_one_mikado_is_woocommerce_installed() {
		return mikado_one_mikado_is_plugin_installed( 'woocommerce' );
	}
}

if ( ! function_exists( 'mikado_one_mikado_is_woocommerce_page' ) ) {
	/**
	 * Function that checks if current page is woocommerce shop, product or product taxonomy
	 * @return bool
	 *
	 * @see is_woocommerce()
	 */
	function mikado_one_mikado_is_woocommerce_page() {
		if ( function_exists( 'is_woocommerce' ) && is_woocommerce() ) {
			return is_woocommerce();
		} elseif ( function_exists( 'is_cart' ) && is_cart() ) {
			return is_cart();
		} elseif ( function_exists( 'is_checkout' ) && is_checkout() ) {
			return is_checkout();
		} elseif ( function_exists( 'is_account_page' ) && is_account_page() ) {
			return is_account_page();
		}
	}
}

if ( ! function_exists( 'mikado_one_mikado_is_product_category' ) ) {
	/**
	 * Function that checks if current page is product category page
	 * @return bool
	 */
	function mikado_one_mikado_is_product_category() {
		return function_exists( 'is_product_category' ) && is_product_category();
	}
}

if ( ! function_exists( 'mikado_one_mikado_has_woocommerce_shortcode' ) ) {
	/**
	 * Function that checks if current page has at least one of WooCommerce shortcodes added
	 * @return bool
	 */
	function mikado_one_mikado_has_woocommerce_shortcode() {
		$woocommerce_shortcodes = array(
			'woocommerce_order_tracking',
			'add_to_cart',
			'product',
			'products',
			'product_categories',
			'product_category',
			'recent_products',
			'featured_products',
			'woocommerce_messages',
			'woocommerce_cart',
			'woocommerce_checkout',
			'woocommerce_my_account',
			'woocommerce_edit_address',
			'woocommerce_change_password',
			'woocommerce_view_order',
			'woocommerce_pay',
			'woocommerce_thankyou'
		);

		foreach ( $woocommerce_shortcodes as $woocommerce_shortcode ) {
			$has_shortcode = mikado_one_mikado_has_shortcode( $woocommerce_shortcode );

			if ( $has_shortcode ) {
				return true;
			}
		}

		return false;
	}
}

if ( ! function_exists( 'mikado_one_mikado_has_woocommerce_widgets' ) ) {
	/**
	 * Function that checks if some of WooCommerce widgets is added to widget area
	 * @return bool
	 */
	function mikado_one_mikado_has_woocommerce_widgets() {
		$widgets_array = array(
			'woocommerce-dropdown-cart',
			'woocommerce_widget_cart',
			'woocommerce_layered_nav',
			'woocommerce_layered_nav_filters',
			'woocommerce_price_filter',
			'woocommerce_product_categories',
			'woocommerce_product_search',
			'woocommerce_product_tag_cloud',
			'woocommerce_products',
			'woocommerce_recent_reviews',
			'woocommerce_recently_viewed_products',
			'woocommerce_top_rated_products'
		);

		foreach ( $widgets_array as $widget ) {
			$active_widget = is_active_widget( false, false, $widget );

			if ( $active_widget ) {
				return true;
			}
		}

		return false;
	}
}


if ( ! function_exists( 'mikado_one_mikado_get_woocommerce_loop' ) ) {
	function mikado_one_mikado_get_woocommerce_loop() {
		global $mikado_one_mikado_woocommerce_loop;

		return $mikado_one_mikado_woocommerce_loop;
	}
}

if ( ! function_exists( 'mikado_one_mikado_register_menus' ) ) {
	/**
	 * Function that registers menu locations
	 */
	function mikado_one_mikado_register_menus() {
		$mkd_options = mikado_one_mikado_return_global_options();;

		if ( ( isset( $mkd_options['header_bottom_appearance'] ) && $mkd_options['header_bottom_appearance'] != "stick_with_left_right_menu" ) || ( isset( $mkd_options['vertical_area'] ) && $mkd_options['vertical_area'] == "yes" ) ) {
			//header and left menu location
			register_nav_menus( array(
				'top-navigation' => esc_html__( 'Top Navigation', 'mikado1' )
			) );
		}

		//popup menu location
		register_nav_menus( array(
			'popup-navigation' => esc_html__( 'Fullscreen Navigation', 'mikado1' )
		) );

		if ( ( isset( $mkd_options['header_bottom_appearance'] ) && $mkd_options['header_bottom_appearance'] == "stick_with_left_right_menu" ) && ( isset( $mkd_options['vertical_area'] ) && $mkd_options['vertical_area'] == "no" ) ) {
			//header left menu location
			register_nav_menus( array(
				'left-top-navigation' => esc_html__( 'Left Top Navigation', 'mikado1' )
			) );

			//header right menu location
			register_nav_menus( array(
				'right-top-navigation' => esc_html__( 'Right Top Navigation', 'mikado1' )
			) );
		}
	}

	add_action( 'after_setup_theme', 'mikado_one_mikado_register_menus' );
}


if ( ! function_exists( 'mikado_one_mikado_wp_title' ) ) {
	/**
	 * Function that prints title tag html. Used for little older versions of WordPress
	 */
	function mikado_one_mikado_wp_title() {
		if ( ! function_exists( '_wp_render_title_tag' ) ) { ?>
            <title><?php wp_title( '' ); ?></title>
		<?php }
	}
}


if ( ! function_exists( 'mikado_one_mikado_excerpt_more' ) ) {
	/**
	 * Function that adds three dotes on the end excerpt
	 *
	 * @param $more
	 *
	 * @return string
	 */
	function mikado_one_mikado_excerpt_more( $more ) {
		return '...';
	}

	add_filter( 'excerpt_more', 'mikado_one_mikado_excerpt_more' );
}

if ( ! function_exists( 'mikado_one_mikado_excerpt_length' ) ) {
	/**
	 * Function that changes excerpt length based on theme options
	 *
	 * @param $length int original value
	 *
	 * @return int changed value
	 */
	function mikado_one_mikado_excerpt_length( $length ) {
		$mkd_options = mikado_one_mikado_return_global_options();;

		if ( $mkd_options['number_of_chars'] ) {
			return esc_attr( $mkd_options['number_of_chars'] );
		} else {
			return 45;
		}
	}

	add_filter( 'excerpt_length', 'mikado_one_mikado_excerpt_length', 999 );
}

if ( ! function_exists( 'mikado_one_mikado_the_excerpt_max_charlength' ) ) {
	/**
	 * Function that sets character length for social share shortcode
	 *
	 * @param $charlength string original text
	 *
	 * @return string shortened text
	 */
	function mikado_one_mikado_the_excerpt_max_charlength( $charlength ) {
		$mkd_options = mikado_one_mikado_return_global_options();;

		if ( isset( $mkd_options['twitter_via'] ) && ! empty( $mkd_options['twitter_via'] ) ) {
			$via = " via " . esc_attr( $mkd_options['twitter_via'] ) . " ";
		} else {
			$via = "";
		}

		$excerpt    = get_the_excerpt();
		$charlength = 140 - ( mb_strlen( $via ) + $charlength );

		if ( mb_strlen( $excerpt ) > $charlength ) {
			$subex   = mb_substr( $excerpt, 0, $charlength );
			$exwords = explode( ' ', $subex );
			$excut   = - ( mb_strlen( $exwords[ count( $exwords ) - 1 ] ) );
			if ( $excut < 0 ) {
				return mb_substr( $subex, 0, $excut );
			} else {
				return $subex;
			}
		} else {
			return $excerpt;
		}
	}
}

if ( ! function_exists( 'mikado_one_mikado_gallery_post_format_content' ) ) {
	/**
	 * Function that removes gallery shortcode from content of gallery post format.
	 * This is necessary because gallery shortcode is used to generate slider but it shouldn't be in the content.
	 * Hooks to the_content filter.
	 *
	 * @see the_content()
	 *
	 * @param $content
	 *
	 * @return mixed
	 */
	function mikado_one_mikado_gallery_post_format_content( $content ) {
		if ( get_post_type() == 'post' && get_post_format() == 'gallery' ) {

			$content = preg_replace( '/\[gallery.*ids=.(.*).\]/', '', $content );
		}

		return $content;
	}

	add_filter( 'the_content', 'mikado_one_mikado_gallery_post_format_content' );
}

if ( ! function_exists( 'mikado_one_mikado_gallery_post_format_ids_images' ) ) {
	/**
	 * Function that extracts ids of attachments in gallery from posts' content
	 *
	 * @param $content string content
	 *
	 * @return array|bool returns array of attachments ids if found, else returns false
	 */
	function mikado_one_mikado_gallery_post_format_ids_images( $content ) {

		preg_match( '/\[gallery.*ids=.(.*).\]/', $content, $ids );

		if ( is_array( $ids ) && count( $ids ) >= 2 ) {
			return explode( ',', $ids[1] );
		}

		return false;
	}

}
if ( ! function_exists( 'mikado_one_mikado_excerpt' ) ) {
	/**
	 * Function that cuts post excerpt to the number of word based on previosly set global
	 * variable $word_count, which is defined in mkd_set_blog_word_count function.
	 *
	 * It current post has read more tag set it will return content of the post, else it will return post excerpt
	 *
	 */
	function mikado_one_mikado_excerpt() {
		global $word_count, $post;

		$mkd_options = mikado_one_mikado_return_global_options();

		if ( post_password_required() ) {
			echo get_the_password_form();
		} //does current post has read more tag set?
        elseif ( mikado_one_mikado_post_has_read_more() ) {
			global $more;

			//override global $more variable so this can be used in blog templates
			$more = 0;
			the_content( true );
		} //is word count set to something different that 0?
        elseif ( $word_count != '0' ) {
			//if word count is set and different than empty take that value, else that general option from theme options
			$word_count = isset( $word_count ) && $word_count !== "" ? $word_count : esc_attr( $mkd_options['number_of_chars'] );

			//if post excerpt field is filled take that as post excerpt, else that content of the post
			$post_excerpt = $post->post_excerpt != "" ? $post->post_excerpt : strip_tags( $post->post_content );

			//remove leading dots if those exists
			$clean_excerpt = strlen( $post_excerpt ) && strpos( $post_excerpt, '...' ) ? strstr( $post_excerpt, '...', true ) : $post_excerpt;

			//if clean excerpt has text left
			if ( $clean_excerpt !== '' ) {
				//explode current excerpt to words
				$excerpt_word_array = explode( ' ', $clean_excerpt );

				//cut down that array based on the number of the words option
				$excerpt_word_array = array_slice( $excerpt_word_array, 0, $word_count );

				//add exerpt postfix
				$excert_postfix = apply_filters( 'mkd_excerpt_postfix', '...' );

				//and finally implode words together
				$excerpt = implode( ' ', $excerpt_word_array ) . $excert_postfix;

				//is excerpt different than empty string?
				if ( $excerpt !== '' ) {
					echo '<p class="post_excerpt">' . esc_html( $excerpt ) . '</p>';
				}
			}
		}
	}
}

if ( ! function_exists( 'mikado_one_mikado_set_blog_word_count' ) ) {
	/**
	 * Function that sets global blog word count variable used by mkd_excerpt function
	 */
	function mikado_one_mikado_set_blog_word_count( $word_count_param ) {
		global $word_count;

		$word_count = $word_count_param;
	}
}

if ( ! function_exists( 'mikado_one_mikado_compare_portfolio_images' ) ) {
	/**
	 * Function that compares two portfolio image for sorting
	 *
	 * @param $a int first image
	 * @param $b int second image
	 *
	 * @return int result of comparison
	 */
	function mikado_one_mikado_compare_portfolio_images( $a, $b ) {
		if ( isset( $a['portfolioimgordernumber'] ) && isset( $b['portfolioimgordernumber'] ) ) {
			if ( $a['portfolioimgordernumber'] == $b['portfolioimgordernumber'] ) {
				return 0;
			}

			return ( $a['portfolioimgordernumber'] < $b['portfolioimgordernumber'] ) ? - 1 : 1;
		}

		return 0;
	}
}

if ( ! function_exists( 'mikado_one_mikado_compare_portfolio_options' ) ) {
	/**
	 * Function that compares two portfolio options for sorting
	 *
	 * @param $a int first option
	 * @param $b int second option
	 *
	 * @return int result of comparison
	 */
	function mikado_one_mikado_compare_portfolio_options( $a, $b ) {
		if ( isset( $a['optionlabelordernumber'] ) && isset( $b['optionlabelordernumber'] ) ) {
			if ( $a['optionlabelordernumber'] == $b['optionlabelordernumber'] ) {
				return 0;
			}

			return ( $a['optionlabelordernumber'] < $b['optionlabelordernumber'] ) ? - 1 : 1;
		}

		return 0;
	}
}

if ( ! function_exists( 'mikado_one_mikado_gallery_upload_get_images' ) ) {
	/**
	 * Function that displays images after user has selected them in media popup.
	 * Used in multiple upload on portfolio page in wp-admin
	 */
	function mikado_one_mikado_gallery_upload_get_images() {
		$ids = sanitize_text_field($_POST['ids']);
		$ids = explode( ",", $ids );
		foreach ( $ids as $id ):
			$image = wp_get_attachment_image_src( $id, 'thumbnail', true );
			echo '<li class="mkd-gallery-image-holder"><img src="' . esc_url( $image[0] ) . '"/></li>';
		endforeach;
		exit;
	}

	add_action( 'wp_ajax_mikado_one_mikado_gallery_upload_get_images', 'mikado_one_mikado_gallery_upload_get_images' );
}

if ( ! function_exists( 'mikado_one_mikado_rgba_color' ) ) {
	/**
	 * Function that generates rgba part of css color property
	 *
	 * @param $color string hex color
	 * @param $transparency float transparency value between 0 and 1
	 *
	 * @return string generated rgba string
	 */
	function mikado_one_mikado_rgba_color( $color, $transparency ) {
		if ( $color !== '' && $transparency !== '' ) {
			$rgba_color = '';

			$rgb_color_array = mikado_one_mikado_hex2rgb( $color );
			$rgba_color      .= 'rgba(' . implode( ', ', $rgb_color_array ) . ', ' . $transparency . ')';

			return $rgba_color;
		}
	}
}

if ( ! function_exists( 'mikado_one_mikado_hex2rgb' ) ) {
	/**
	 * Function that transforms hex color to rgb color
	 *
	 * @param $hex string original hex string
	 *
	 * @return array array containing three elements (r, g, b)
	 */
	function mikado_one_mikado_hex2rgb( $hex ) {
		$hex = str_replace( "#", "", $hex );

		if ( strlen( $hex ) == 3 ) {
			$r = hexdec( substr( $hex, 0, 1 ) . substr( $hex, 0, 1 ) );
			$g = hexdec( substr( $hex, 1, 1 ) . substr( $hex, 1, 1 ) );
			$b = hexdec( substr( $hex, 2, 1 ) . substr( $hex, 2, 1 ) );
		} else {
			$r = hexdec( substr( $hex, 0, 2 ) );
			$g = hexdec( substr( $hex, 2, 2 ) );
			$b = hexdec( substr( $hex, 4, 2 ) );
		}
		$rgb = array( $r, $g, $b );

		//return implode(",", $rgb); // returns the rgb values separated by commas
		return $rgb; // returns an array with the rgb values
	}
}

if ( ! function_exists( 'mikado_one_mikado_addslashes' ) ) {
	/**
	 * Function that checks if magic quotes are turned on (for older versions of php) and returns escaped string
	 *
	 * @param $str string string to be escaped
	 *
	 * @return string escaped string
	 */
	function mikado_one_mikado_addslashes( $str ) {
		//is magic quotes turned off in php.ini?
		if ( ! get_magic_quotes_gpc() ) {
			//apply addslashes
			$str = addslashes( $str );
		}

		//return escaped string
		return $str;
	}
}

if ( ! function_exists( 'mikado_one_mikado_get_attachment_meta' ) ) {
	/**
	 * Function that returns attachment meta data from attachment id
	 *
	 * @param $attachment_id
	 * @param array $keys sub array of attachment meta
	 *
	 * @return array|mixed
	 */
	function mikado_one_mikado_get_attachment_meta( $attachment_id, $keys = array() ) {
		$meta_data = array();

		//is attachment id set?
		if ( ! empty( $attachment_id ) ) {
			//get all post meta for given attachment id
			$meta_data = get_post_meta( $attachment_id, '_wp_attachment_metadata', true );

			//is subarray of meta array keys set?
			if ( is_array( $keys ) && count( $keys ) ) {
				$sub_array = array();

				//for each defined key
				foreach ( $keys as $key ) {
					//check if that key exists in all meta array
					if ( array_key_exists( $key, $meta_data ) ) {
						//assign key from meta array for current key to meta subarray
						$sub_array[ $key ] = $meta_data[ $key ];
					}
				}

				//we want meta array to be subarray because that is what used whants to get
				$meta_data = $sub_array;
			}
		}

		//return meta array
		return $meta_data;
	}
}

if ( ! function_exists( 'mikado_one_mikado_get_attachment_id_from_url' ) ) {
	/**
	 * Function that retrieves attachment id for passed attachment url
	 *
	 * @param $attachment_url
	 *
	 * @return null|string
	 */
	function mikado_one_mikado_get_attachment_id_from_url( $attachment_url ) {
		global $wpdb;
		$attachment_id = '';

		//is attachment url set?
		if ( $attachment_url !== '' ) {
			//prepare query

			$query = $wpdb->prepare( "SELECT ID FROM {$wpdb->posts} WHERE guid=%s", $attachment_url );

			//get attachment id
			$attachment_id = $wpdb->get_var( $query );
		}

		//return id
		return $attachment_id;
	}
}

if ( ! function_exists( 'mikado_one_mikado_get_attachment_meta_from_url' ) ) {
	/**
	 * Function that returns meta array for give attachment url
	 *
	 * @param $attachment_url
	 * @param array $keys sub array of attachment meta
	 *
	 * @return array|mixed
	 *
	 * @see mikado_one_mikado_get_attachment_id_from_url()
	 * @see mikado_one_mikado_get_attachment_meta()
	 *
	 * @version 0.1
	 */
	function mikado_one_mikado_get_attachment_meta_from_url( $attachment_url, $keys = array() ) {
		$attachment_meta = array();

		//get attachment id for attachment url
		$attachment_id = mikado_one_mikado_get_attachment_id_from_url( $attachment_url );

		//is attachment id set?
		if ( ! empty( $attachment_id ) ) {
			//get post meta
			$attachment_meta = mikado_one_mikado_get_attachment_meta( $attachment_id, $keys );
		}

		//return post meta
		return $attachment_meta;
	}
}

if ( ! function_exists( 'mikado_one_mikado_get_image_dimensions' ) ) {
	/**
	 * Function that returns image sizes array. First looks in post_meta table if attachment exists in the database,
	 * if it doesn't than it uses getimagesize PHP function to get image sizes
	 *
	 * @param $url string url of the image
	 *
	 * @return array array of image sizes that containes height and width
	 *
	 * @see  mikado_one_mikado_get_attachment_meta_from_url()
	 * @uses getimagesize
	 *
	 * @version 0.1
	 */
	function mikado_one_mikado_get_image_dimensions( $url ) {

		$image_sizes = array();

		//is url passed?
		if ( $url !== '' && $url !== null ) {
			//get image sizes from posts meta if attachment exists
			$image_sizes = mikado_one_mikado_get_attachment_meta_from_url( $url, array( 'width', 'height' ) );

			//image does not exists in post table, we have to use PHP way of getting image size
			if ( ! count( $image_sizes ) ) {
				require_once( ABSPATH . 'wp-admin/includes/file.php' );

				//can we open file by url?
				if ( ini_get( 'allow_url_fopen' ) == 1 && file_exists( $url ) ) {
					list( $width, $height, $type, $attr ) = getimagesize( $url );
				} else {
					//we can't open file directly, have to locate it with relative path.
					$image_obj           = parse_url( $url );
					$image_relative_path = rtrim( get_home_path(), '/' ) . $image_obj['path'];
					if ( file_exists( $image_relative_path ) ) {
						list( $width, $height, $type, $attr ) = getimagesize( $image_relative_path );
					}
				}

				//did we get width and height from some of above methods?
				if ( isset( $width ) && isset( $height ) ) {
					//set them to our image sizes array
					$image_sizes = array(
						'width'  => $width,
						'height' => $height
					);
				}
			}
		}

		return $image_sizes;
	}
}

if ( ! function_exists( 'mikado_one_mikado_set_logo_sizes' ) ) {
	/**
	 * Function that sets logo image dimensions to global mkd options array so it can be used in the theme
	 */
	function mikado_one_mikado_set_logo_sizes() {
		global $mkd_options;

		if ( isset( $mkd_options['logo_image'] ) ) {
			//get logo image size
			$logo_image_sizes           = mikado_one_mikado_get_image_dimensions( $mkd_options['logo_image'] );
			$mkd_options['logo_width']  = 280;
			$mkd_options['logo_height'] = 130;

			//is image width and height set?
			if ( isset( $logo_image_sizes['width'] ) && isset( $logo_image_sizes['height'] ) ) {
				//set those variables in global array
				$mkd_options['logo_width']  = $logo_image_sizes['width'];
				$mkd_options['logo_height'] = $logo_image_sizes['height'];
			}
		}
	}

	add_action( 'init', 'mikado_one_mikado_set_logo_sizes', 0 );
}


if ( ! function_exists( 'mikado_one_mikado_get_page_template_name' ) ) {
	/**
	 * Returns current template file name without extension
	 * @return string name of current template file
	 */
	function mikado_one_mikado_get_page_template_name() {
		$file_name = '';

		//check if current isn't default WordPress template. get_page_template displays notice if called on default template
		if ( ! mikado_one_mikado_is_default_wp_template() ) {
			$file_name_without_ext = preg_replace( '/\\.[^.\\s]{3,4}$/', '', basename( get_page_template() ) );

			if ( $file_name_without_ext !== '' ) {
				$file_name = $file_name_without_ext;
			}
		}


		return $file_name;
	}
}

if ( ! function_exists( 'mikado_one_mikado_is_full_screen_template' ) ) {
	/**
	 * Function that checks if current page has full screen template set
	 * @return bool
	 *
	 * @see mikado_one_mikado_get_page_template_name()
	 */
	function mikado_one_mikado_is_full_screen_template() {
		return mikado_one_mikado_get_page_template_name() === 'full_screen';
	}

}

if ( ! function_exists( 'mikado_one_mikado_is_main_menu_set' ) ) {
	/**
	 * Function that checks if any of main menu locations are set.
	 * Checks whether top-navigation location is set, or left-top-navigation and right-top-navigation is set
	 * @return bool
	 *
	 * @version 0.1
	 */
	function mikado_one_mikado_is_main_menu_set() {
		$has_top_nav     = has_nav_menu( 'top-navigation' );
		$has_divided_nav = has_nav_menu( 'left-top-navigation' ) && has_nav_menu( 'right-top-navigation' );

		return $has_top_nav || $has_divided_nav;
	}
}

if ( ! function_exists( 'mikado_one_mikado_modify_read_more_link' ) ) {
	/**
	 * Function that hooks to read more link filter and alters it.
	 *
	 * @return string
	 */
	function mikado_one_mikado_modify_read_more_link() {
		$link = '<div class="more-link-container">';
		$link .= '<a class="qbutton small" href="' . get_permalink() . '#more-' . get_the_ID() . '"><span>' . esc_html__( 'Continue reading', 'mikado1' ) . '</span></a>';
		$link .= '</div>';

		return $link;
	}

	add_filter( 'the_content_more_link', 'mikado_one_mikado_modify_read_more_link' );
}

if ( ! function_exists( 'mikado_one_mikado_visual_composer_installed' ) ) {
	/**
	 * Function that checks if visual composer installed
	 * @return bool
	 */
	function mikado_one_mikado_visual_composer_installed() {
		//is Visual Composer installed?
		if ( mikado_one_mikado_is_plugin_installed( 'WPBakeryVisualComposerAbstract' ) ) {
			return true;
		}

		return false;
	}
}

if ( ! function_exists( 'mikado_one_mikado_seo_plugin_installed' ) ) {
	/**
	 * Function that checks if popular seo plugins are installed
	 * @return bool
	 */
	function mikado_one_mikado_seo_plugin_installed() {
		//is YOAST installed?
		if ( mikado_one_mikado_is_plugin_installed( 'yoast' ) ) {
			return true;
		}

		return false;
	}
}

if ( ! function_exists( 'mikado_one_mikado_contact_form_7_installed' ) ) {
	/**
	 * Function that checks if contact form 7 installed
	 * @return bool
	 */
	function mikado_one_mikado_contact_form_7_installed() {
		//is Contact Form 7 installed?
		if ( mikado_one_mikado_is_plugin_installed( 'contact-form-7' ) ) {
			return true;
		}

		return false;
	}
}

if ( ! function_exists( 'mikado_one_mikado_buddy_press_installed' ) ) {
	/**
	 * Function that checks if buddyPress  installed
	 * @return bool
	 */
	function mikado_one_mikado_buddy_press_installed() {
		//is Buddy Press installed?

		if ( mikado_one_mikado_is_plugin_installed( 'buddypress' ) ) {
			return true;
		}

		return false;
	}
}

if ( ! function_exists( 'mikado_one_mikado_is_buddy_press_page' ) ) {
	/**
	 * Function that checks if current page is buddy press page
	 * @return bool
	 */
	function mikado_one_mikado_is_buddy_press_page() {
		return mikado_one_mikado_buddy_press_installed() && is_buddypress();
	}
}

if ( ! function_exists( 'mikado_one_mikado_get_buddy_press_pages' ) ) {
	/**
	 * Function that returns array of urls of buddy press pages
	 * @return array array of pages' urls
	 */
	function mikado_one_mikado_get_buddy_press_pages() {
		$buddy_press_pages_array = array();

		if ( mikado_one_mikado_buddy_press_installed() ) {
			$buddy_press_pages = get_option( 'bp-pages' );

			if ( is_array( $buddy_press_pages ) && count( $buddy_press_pages ) ) {
				foreach ( $buddy_press_pages as $buddy_press_page ) {
					$buddy_press_pages_array[] = get_permalink( $buddy_press_page );
				}

			}
		}

		return $buddy_press_pages_array;
	}
}

if ( ! function_exists( 'mikado_one_mikado_has_buddy_press_shortcode' ) ) {
	/**
	 * Function that cheks if some of buddy press shortcodes exists on current page
	 * @return bool
	 */
	function mikado_one_mikado_has_buddy_press_shortcode() {
		$buddy_press_shortcodes = array(
			'no_get_buddy_press_groups',
			'no_get_buddy_press_activities'
		);

		foreach ( $buddy_press_shortcodes as $buddy_press_shortcode ) {
			$has_shortcode = mikado_one_mikado_has_shortcode( $buddy_press_shortcode );

			if ( $has_shortcode ) {
				return true;
			}
		}

		return false;
	}
}


if ( ! function_exists( 'mikado_one_mikado_is_wpml_installed' ) ) {
	/**
	 * Function that checks if WPML plugin is installed
	 * @return bool
	 *
	 * @version 0.1
	 */
	function mikado_one_mikado_is_wpml_installed() {
		if ( mikado_one_mikado_is_plugin_installed( 'wpml' ) ) {
			return true;
		}

		return false;
	}
}

if ( ! function_exists( 'mikado_one_mikado_is_gutenberg_installed' ) ) {
	/**
	 * Function that checks if Gutenberg plugin installed
	 * @return bool
	 */
	function mikado_one_mikado_is_gutenberg_installed() {
		if ( mikado_one_mikado_is_plugin_installed( 'gutenberg-plugin' ) ) {
			return true;
		}

		return false;
	}
}


if ( ! function_exists( 'mikado_one_mikado_writable_assets_folders_notice' ) ) {
	/**
	 * Function that prints notice that css and js folders aren't writable. Hooks to admin_notices action
	 *
	 * @version 0.1
	 * @link http://codex.wordpress.org/Plugin_API/Action_Reference/admin_notices
	 */
	function mikado_one_mikado_writable_assets_folders_notice() {
		global $pagenow;

		$is_theme_options_page = isset( $_GET['page'] ) && strstr( $_GET['page'], 'mkd_theme_menu' );

		if ( $pagenow === 'admin.php' && $is_theme_options_page ) {
			if ( ! mikado_one_mikado_assets_folders_writable() ) { ?>
                <div class="error">
                    <p><?php esc_html_e( 'Note that writing permissions aren\'t set for folders containing css and js files on your server. We recommend setting writing permissions in order to optimize your site performance.	 For further instructions, please refer to our', 'mikado1' ) ?>
                        <a target="_blank" href="https://demo.mikado-themes.com/mikado100-help/#!/getting_started"><?php esc_html_e( 'documentation', 'mikado1' ) ?></a></p>
                </div>
			<?php }
		}
	}

	add_action( 'admin_notices', 'mikado_one_mikado_writable_assets_folders_notice' );
}


if ( ! function_exists( 'mikado_one_mikado_get_objects_without_ajax' ) ) {
	/**
	 * Function that returns urls of objects that have ajax disabled.
	 * Works for posts, pages and portfolio pages.
	 * @return array array of urls of posts that have ajax disabled
	 *
	 * @version 0.1
	 */
	function mikado_one_mikado_get_objects_without_ajax() {
		$posts_without_ajax = array();

		$posts_args = array(
			'post_type'   => array( 'post', 'portfolio_page', 'page' ),
			'post_status' => 'publish',
			'meta_key'    => 'mkd_show-animation',
			'meta_value'  => 'no_animation'
		);

		$posts_query = new WP_Query( $posts_args );

		if ( $posts_query->have_posts() ) {
			while ( $posts_query->have_posts() ) {
				$posts_query->the_post();
				$posts_without_ajax[] = get_permalink( get_the_ID() );
			}
		}

		wp_reset_postdata();

		return $posts_without_ajax;
	}
}

if ( ! function_exists( 'mikado_one_mikado_get_wpml_pages_for_current_page' ) ) {
	/**
	 * Function that returns urls translated pages for current page.
	 * @return array array of url urls translated pages for current page.
	 *
	 * @version 0.1
	 */
	function mikado_one_mikado_get_wpml_pages_for_current_page() {
		$wpml_pages_for_current_page = array();

		if ( mikado_one_mikado_is_wpml_installed() ) {
			$language_pages = icl_get_languages( 'skip_missing=0' );

			foreach ( $language_pages as $key => $language_page ) {
				$wpml_pages_for_current_page[] = $language_page["url"];
			}
		}

		return $wpml_pages_for_current_page;
	}
}

if ( ! function_exists( 'mikado_one_mikado_is_ajax_enabled' ) ) {
	/**
	 * Function that checks if ajax is enabled.
	 * @return bool
	 *
	 * @version 0.1
	 */
	function mikado_one_mikado_is_ajax_enabled() {
		$mkd_options = mikado_one_mikado_return_global_options();;

		$has_ajax = false;

		if ( isset( $mkd_options['page_transitions'] ) && ! empty( $mkd_options['page_transitions'] ) ) {
			$has_ajax = true;
		}

		return $has_ajax;
	}
}

if ( ! function_exists( 'mikado_one_mikado_rewrite_rules_on_theme_activation' ) ) {
	/**
	 * Function that flushes rewrite rules after theme is deactivated.
	 * This is necessary because all rewrite rules that are defined in theme
	 * must be flushed after deactivation
	 */
	function mikado_one_mikado_rewrite_rules_on_theme_activation() {
		flush_rewrite_rules();
	}

	add_action( 'after_switch_theme', 'mikado_one_mikado_rewrite_rules_on_theme_activation' );
}

if ( ! function_exists( 'mikado_one_mikado_maintenance_mode' ) ) {
	/**
	 * Function that redirects user to desired landing page if maintenance mode is turned on in options.
	 * Works only if current visitor isn't logged in
	 */
	function mikado_one_mikado_maintenance_mode() {
		$mkd_options = mikado_one_mikado_return_global_options();;

		$protocol = is_ssl() ? "https://" : "http://";
		if ( isset( $mkd_options['mkd_maintenance_mode'] ) && $mkd_options['mkd_maintenance_mode'] == 'yes' && isset( $mkd_options['mkd_maintenance_page'] ) && $mkd_options['mkd_maintenance_page'] != "" && ! in_array( $GLOBALS['pagenow'], array(
				'wp-login.php',
				'wp-register.php'
			) ) && ! is_admin() && ! is_user_logged_in() && $protocol . getenv('HTTP_HOST') . getenv('REQUEST_URI') != get_permalink( esc_attr( $mkd_options['mkd_maintenance_page'] ) ) ) {

			wp_redirect( get_permalink( esc_attr( $mkd_options['mkd_maintenance_page'] ) ) );
			exit;
		}
	}

	if ( isset( $mkd_options['mkd_maintenance_mode'] ) && $mkd_options['mkd_maintenance_mode'] == 'yes' ) {
		add_action( 'init', 'mkd_maintenance_mode', 1 );
	}
}

if ( ! function_exists( 'mikado_one_mikado_post_has_read_more' ) ) {
	/**
	 * Function that checks if current post has read more tag set
	 * @return int position of read more tag text. It will return false if read more tag isn't set
	 */
	function mikado_one_mikado_post_has_read_more() {
		global $post;

		return strpos( $post->post_content, '<!--more-->' );
	}
}


if ( ! function_exists( 'mikado_one_mikado_post_has_title' ) ) {
	function mikado_one_mikado_post_has_title() {
		return get_the_title() !== '';
	}
}

if ( ! function_exists( 'mikado_one_mikado_is_blog_template' ) ) {
	/**
	 * Checks if current template page is blog template page.
	 *
	 * @param string current page. Optional parameter. If not passed mkd_get_page_template_name() function will be used
	 *
	 * @return bool
	 *
	 * @see mikado_one_mikado_get_page_template_name()
	 */
	function mikado_one_mikado_is_blog_template( $current_page = '' ) {

		if ( $current_page == '' ) {
			$current_page = mikado_one_mikado_get_page_template_name();
		}

		$blog_templates = array(
			'blog-category-title-first-centered',
			'blog-date-in-title',
			'blog-date-in-title-whole-post',
			'blog-image-with-icon-centered',
			'blog-masonry',
			'blog-masonry-full-width',
			'blog-post-info-vertical-content',
			'blog-post-info-vertical-image',
			'blog-title-author-centered',
			'blog-title-date-first'
		);

		return in_array( $current_page, $blog_templates );
	}
}


if ( ! function_exists( 'mikado_one_mikado_style_attr' ) ) {
	/**
	 * Function that echoes generated style attribute
	 *
	 * @param $value string | array attribute value
	 *
	 * @see mikado_one_mikado_get_style_attr()
	 */
	function mikado_one_mikado_style_attr( $value ) {
		echo mikado_one_mikado_get_style_attr( $value );
	}
}

if ( ! function_exists( 'mikado_one_mikado_get_style_attr' ) ) {
	/**
	 * Function that generates style attribute and returns generated string
	 *
	 * @param $value string | array value of style attribute
	 *
	 * @return string generated style attribute
	 *
	 * @see mikado_one_mikado_get_html_attr()
	 */
	function mikado_one_mikado_get_style_attr( $value ) {
		return mikado_one_mikado_get_html_attr( $value, 'style' );
	}
}


if ( ! function_exists( 'mikado_one_mikado_class_attr' ) ) {
	/**
	 * Function that echoes class attribute
	 *
	 * @param $value string value of class attribute
	 *
	 * @see mikado_one_mikado_get_class_attr()
	 */
	function mikado_one_mikado_class_attr( $value ) {
		echo mikado_one_mikado_get_class_attr( $value );
	}
}

if ( ! function_exists( 'mikado_one_mikado_get_class_attr' ) ) {
	/**
	 * Function that returns generated class attribute
	 *
	 * @param $value string value of class attribute
	 *
	 * @return string generated class attribute
	 *
	 * @see mikado_one_mikado_get_html_attr()
	 */
	function mikado_one_mikado_get_class_attr( $value ) {
		return mikado_one_mikado_get_html_attr( $value, 'class' );
	}
}

if ( ! function_exists( 'mikado_one_mikado_get_html_attr' ) ) {
	/**
	 * Function that generates html attribute
	 *
	 * @param $value string | array value of html attribute
	 * @param $attr string name of html attribute to generate
	 *
	 * @return string generated html attribute
	 */
	function mikado_one_mikado_get_html_attr( $value, $attr ) {
		if ( ! empty( $value ) ) {
			$properties = '';
			if ( is_array( $value ) && count( $value ) ) {
				$properties = implode( ' ', $value );
			} elseif ( $value !== '' ) {
				$properties = $value;
			}

			return $attr . '="' . esc_attr( $properties ) . '"';
		}

		return '';
	}
}

if ( ! function_exists( 'mikado_one_mikado_core_plugin_message' ) ) {
	/**
	 * Function that prints a mesasge in the admin if user hides TGMPA plugin activation message
	 */
	function mikado_one_mikado_core_plugin_message() {
		if ( get_user_meta( get_current_user_id(), 'tgmpa_dismissed_notice', true ) && ! mikado_one_mikado_core_installed() ) {
			echo apply_filters( 'mkd_core_plugin_message', '<div class="update-nag">' . esc_html__( 'Installation of the "Mikado Core" plugin is essential for proper theme functioning. Please', 'mikado1') . '<a href="' . admin_url( 'themes.php?page=install-required-plugins' ) . '">' . esc_html__( 'install', 'mikado1' ) . '</a>' . esc_html__( 'this plugin and activate it', 'mikado1' ) . '</div>' );
		}
	}

	add_action( 'admin_notices', 'mikado_one_mikado_core_plugin_message' );
}

if ( ! function_exists( 'mikado_one_mikado_core_installed' ) ) {
	/**
	 * Function that checks if core CPT plugin is installed
	 * @return bool whether core plugin is installed
	 */
	function mikado_one_mikado_core_installed() {
		return mikado_one_mikado_is_plugin_installed( 'core' );
	}
}

if ( ! function_exists( 'mikado_one_mikado_visual_composer_grid_elements' ) ) {

	/**
	 * Removes Visual Composer Grid Elements post type
	 */
	function mikado_one_mikado_visual_composer_grid_elements() {

		remove_action( 'init', 'vc_grid_item_editor_create_post_type' );

	}

	add_action( 'vc_after_init', 'mikado_one_mikado_visual_composer_grid_elements', 12 );
}

if ( ! function_exists( 'mikado_one_mikado_get_vc_version' ) ) {
	/**
	 * Return Visual Composer version string
	 *
	 * @return bool|string
	 */
	function mikado_one_mikado_get_vc_version() {
		if ( mikado_one_mikado_visual_composer_installed() ) {
			return WPB_VC_VERSION;
		}

		return false;
	}
}

if ( ! function_exists( 'mikado_one_mikado_has_blog_widget' ) ) {
	/**
	 * Function that checks if latest posts widget is added to widget area
	 * @return bool
	 */
	function mikado_one_mikado_has_blog_widget() {
		$widgets_array = array(
			'mkd_latest_posts_widget'
		);

		foreach ( $widgets_array as $widget ) {
			$active_widget = is_active_widget( false, false, $widget );

			if ( $active_widget ) {
				return true;
			}
		}

		return false;
	}
}


if ( ! function_exists( 'mikado_one_mikado_get_blog_query' ) ) {
	/**
	 * Function which create query for blog lists
	 *
	 * @return wp query object
	 */
	function mikado_one_mikado_get_blog_query() {
		$id                       = mikado_one_mikado_get_page_id();
		$category                 = esc_attr( get_post_meta( $id, 'mkd_choose-blog-category', true ) );
		$number_of_posts_per_page = get_post_meta( $id, 'mkd_show-posts-per-page', true );
		$post_number              = ! empty( $number_of_posts_per_page ) ? esc_attr( $number_of_posts_per_page ) : esc_attr( get_option( 'mkd_show-posts-per-page' ) );

		if ( get_query_var( 'paged' ) ) {
			$paged = get_query_var( 'paged' );
		} elseif ( get_query_var( 'page' ) ) {
			$paged = get_query_var( 'page' );
		} else {
			$paged = 1;
		}

		$query_array = array(
			'post_status'    => 'publish',
			'post_type'      => 'post',
			'paged'          => $paged,
			'category_name'  => $category,
			'posts_per_page' => $post_number
		);

		$blog_query = new WP_Query( $query_array );
		if ( is_archive() ) {
			global $wp_query;
			$blog_query = $wp_query;
		}

		return $blog_query;
	}
}


if ( ! function_exists( 'mikado_one_mikado_get_max_number_of_pages' ) ) {
	/**
	 * Function that return max number of posts/pages for pagination
	 */
	function mikado_one_mikado_get_max_number_of_pages() {
		global $wp_query;
		$mkd_options = mikado_one_mikado_return_global_options();

		$max_number_of_pages = 1; //default value

		if(isset($mkd_options['blog_page_range']) && $mkd_options['blog_page_range'] != "") {
			$max_number_of_pages = esc_attr( $mkd_options['blog_page_range'] );
		}

		if ( $wp_query ) {
			$max_number_of_pages = $wp_query->max_num_pages;
		}

		return $max_number_of_pages;
	}
}


if ( ! function_exists( 'mikado_one_mikado_get_sidebar_layout' ) ) {
	function mikado_one_mikado_get_sidebar_layout( $default_value = true ) {
		$mkd_options        = mikado_one_mikado_return_global_options();
		$mikado_one_page_id = mikado_one_mikado_get_page_id();

		$sidebar = $default_value ? get_post_meta( $mikado_one_page_id, "mkd_show-sidebar", true ) : $mkd_options['category_blog_sidebar'];

		if ( ! empty( $sidebar ) && ! is_active_sidebar( mikado_one_mikado_get_sidebar_name() ) ) {
			$sidebar = '';
		}

		return $sidebar;
	}
}

if ( ! function_exists( 'mikado_one_mikado_get_sidebar_name' ) ) {
	function mikado_one_mikado_get_sidebar_name() {

		if (is_singular("post")) {
			$sidebar = "sidebar";
		} else {
			$sidebar = "sidebar_page";
		}

		return $sidebar;
	}
}

if ( ! function_exists( 'mikado_one_mikado_wp_link_pages_exist' ) ) {
	function mikado_one_mikado_wp_link_pages_exist() {
		$args_pages = array(
			'echo' => 0
		);

		return wp_link_pages( $args_pages );
	}
}