<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<?php
$mkd_options = mikado_one_mikado_return_global_options();
global $wp_query;
?>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<?php
	if (mikado_one_mikado_return_is_ie()) { ?>
        <meta content="IE=edge,chrome=1" http-equiv="X-UA-Compatible">
	<?php }

	$responsiveness = "yes";
	if (isset($mkd_options['responsiveness'])) $responsiveness = $mkd_options['responsiveness'];
	if($responsiveness != "no"){
		?>
		<meta name=viewport content="width=device-width,initial-scale=1,user-scalable=no">
	<?php
	}else{
		?>
		<meta name=viewport content="width=1200,user-scalable=no">
	<?php } ?>

    <?php mikado_one_mikado_wp_title(); ?>

	<?php do_action('mikado_mikado_one_header_meta'); ?>
	
	<link rel="profile" href="https://gmpg.org/xfn/11" />
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
	<link rel="shortcut icon" type="image/x-icon" href="<?php echo esc_url($mkd_options['favicon_image']); ?>">
	<link rel="apple-touch-icon" href="<?php echo esc_url($mkd_options['favicon_image']); ?>"/>

	<?php wp_head(); ?>

</head>

<body <?php body_class(); ?>>

<?php
$loading_animation = true;
if (isset($mkd_options['loading_animation'])){ if($mkd_options['loading_animation'] == "off") { $loading_animation = false; }};

if (isset($mkd_options['loading_image']) && $mkd_options['loading_image'] != ""){ $loading_image = $mkd_options['loading_image'];}else{ $loading_image =  ""; }
?>
<?php if($loading_animation){ ?>
	<div class="ajax_loader"><div class="ajax_loader_1"><?php if($loading_image != ""){ ?><div class="ajax_loader_2"><img src="<?php echo esc_url($loading_image); ?>" alt="ajax-loader-2" /></div><?php } else{ mikado_one_mikado_loading_spinners(); } ?></div></div>
<?php } ?>
<?php
$enable_side_area = "yes";
if (isset($mkd_options['enable_side_area'])){ if($mkd_options['enable_side_area'] == "no") { $enable_side_area = "no"; }};

$enable_popup_menu = "no";
if (isset($mkd_options['enable_popup_menu'])){ if($mkd_options['enable_popup_menu'] == "yes" && has_nav_menu('popup-navigation')) { $enable_popup_menu = "yes"; }};

$enable_paspartu = false;
if(isset($mkd_options['paspartu']) && $mkd_options['paspartu'] == 'yes'){
    $enable_paspartu = true;
}

$enable_vertical_menu = false;
if(isset($mkd_options['vertical_area']) && $mkd_options['vertical_area'] =='yes' && !$enable_paspartu){
	$enable_vertical_menu = true;
}

$header_button_size = '';
if(isset($mkd_options['header_buttons_size'])){
	$header_button_size = $mkd_options['header_buttons_size'];
}
?>
<?php if($enable_side_area == "yes" && $enable_popup_menu == 'no' && !$enable_vertical_menu) { ?>
	<section class="side_menu right">
		<?php if(isset($mkd_options['side_area_title']) && $mkd_options['side_area_title'] != "") { ?>
			<div class="side_menu_title">
				<h5><?php echo esc_html($mkd_options['side_area_title']); ?></h5>
			</div>
		<?php } ?>
		<a href="#" target="_self" class="close_side_menu"></a>
		<?php dynamic_sidebar('sidearea'); ?>
	</section>
<?php } ?>
<div class="wrapper">
<div class="wrapper_inner">

    <?php do_action('mikado_mikado_one_after_wrapper_inner'); ?>

<?php
$paspartu_header_alignment = false;
if(isset($mkd_options['paspartu_header_alignment']) && $mkd_options['paspartu_header_alignment'] == 'yes' && isset($mkd_options['paspartu']) && $mkd_options['paspartu'] == 'yes'){$paspartu_header_alignment = true;}

$header_in_grid = true;
if(isset($mkd_options['header_in_grid'])){
    if ($mkd_options['header_in_grid'] == "no"){ $header_in_grid = false; }
    if ($paspartu_header_alignment) { $header_in_grid = false; }
}

$menu_item_icon_position = "";
if(isset($mkd_options['menu_item_icon_position'])){$menu_item_icon_position = $mkd_options['menu_item_icon_position']; }

$menu_position = "";
if(isset($mkd_options['menu_position'])){$menu_position = $mkd_options['menu_position']; }

$centered_logo = false;
if (isset($mkd_options['center_logo_image'])){ if($mkd_options['center_logo_image'] == "yes" && $mkd_options['header_bottom_appearance'] !== "stick_with_left_right_menu") { $centered_logo = true; }};

$enable_border_top_bottom_menu = false;
if (isset($mkd_options['enable_border_top_bottom_menu'])){ if($mkd_options['enable_border_top_bottom_menu'] == "yes") { $enable_border_top_bottom_menu = true; }};

if(isset($mkd_options['header_bottom_appearance']) && $mkd_options['header_bottom_appearance'] == "fixed_hiding"){
    $centered_logo = true;
}

//check if header is sticky divided and set width of logo wrapper
$logo_wrapper_style = "";
$divided_left_menu_padding = "";
$divided_right_menu_padding = "";
if(isset($mkd_options['header_bottom_appearance']) && $mkd_options['header_bottom_appearance'] == "stick_with_left_right_menu"){
    $logo_wrapper_style = 'width:'.(esc_attr($mkd_options['logo_width']/2)).'px;';
    $divided_left_menu_padding = 'padding-right:'.(esc_attr($mkd_options['logo_width'])/4).'px;';
    $divided_right_menu_padding = 'padding-left:'.(esc_attr($mkd_options['logo_width'])/4).'px;';
}
if(isset($mkd_options['center_logo_image']) && $mkd_options['center_logo_image'] == "yes" && isset($mkd_options['header_bottom_appearance']) && $mkd_options['header_bottom_appearance'] == "regular"){
	$logo_wrapper_style = 'height:'.(esc_attr($mkd_options['logo_height'])/2).'px;';
}

$display_header_top = "yes";
if(isset($mkd_options['header_top_area'])){
	$display_header_top = $mkd_options['header_top_area'];
}
if (!empty($_SESSION['mkd_cayman_header_top'])){
	$display_header_top = $_SESSION['mkd_cayman_header_top'];
}
$header_top_area_scroll = "no";
if(isset($mkd_options['header_top_area_scroll'])){
	$header_top_area_scroll = $mkd_options['header_top_area_scroll'];
}

global $wp_query;
$is_woocommerce=false;


$header_style = "";
if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_header-style", true) != ""){
	$header_style = esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_header-style", true));
}else if(isset($mkd_options['header_style'])){
	$header_style = esc_attr($mkd_options['header_style']);
}

$header_color_transparency_per_page = "";
if($mkd_options['header_background_transparency_initial'] != "") {
	$header_color_transparency_per_page = esc_attr($mkd_options['header_background_transparency_initial']);
}
if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_header_color_transparency_per_page", true) != ""){
	$header_color_transparency_per_page = esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_header_color_transparency_per_page", true));
}

$header_color_per_page = "";
if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_header_color_per_page", true) != ""){
	if($header_color_transparency_per_page != ""){
		$header_background_color = mikado_one_mikado_hex2rgb(esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_header_color_per_page", true)));
		$header_color_per_page .= " background-color:rgba(" . $header_background_color[0] . ", " . $header_background_color[1] . ", " . $header_background_color[2] . ", " . esc_attr($header_color_transparency_per_page) . ");";
	}else{
		$header_color_per_page .= " background-color:" . esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_header_color_per_page", true)) . ";";
	}
} else if($header_color_transparency_per_page != "" && get_post_meta(mikado_one_mikado_get_page_id(), "mkd_header_color_per_page", true) == ""){
	$header_background_color = $mkd_options['header_background_color'] ? mikado_one_mikado_hex2rgb(esc_attr($mkd_options['header_background_color'])) : mikado_one_mikado_hex2rgb("#ffffff");
	$header_color_per_page .= " background-color:rgba(" . $header_background_color[0] . ", " . $header_background_color[1] . ", " . $header_background_color[2] . ", " . esc_attr($header_color_transparency_per_page) . ");";
}

if(isset($mkd_options['header_botom_border_in_grid']) && $mkd_options['header_botom_border_in_grid'] != "yes" && get_post_meta(mikado_one_mikado_get_page_id(), "mkd_header_bottom_border_color", true) != ""){
	$header_color_per_page .= "border-bottom: 1px solid ".esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_header_bottom_border_color", true)).";";
}

$header_top_color_per_page = '';
if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_header_color_per_page", true) != ""){
	if($header_color_transparency_per_page != ""){
		$header_background_color = mikado_one_mikado_hex2rgb(esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_header_color_per_page", true)));
		$header_top_color_per_page .= "background-color:rgba(" . $header_background_color[0] . ", " . $header_background_color[1] . ", " . $header_background_color[2] . ", " . esc_attr($header_color_transparency_per_page) . ");";
	}else{
		$header_top_color_per_page .= "background-color:" . esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_header_color_per_page", true)) . ";";
	}
} else if($header_color_transparency_per_page != "" && get_post_meta(mikado_one_mikado_get_page_id(), "mkd_header_color_per_page", true) == ""){
	$header_background_color = $mkd_options['header_top_background_color'] ? mikado_one_mikado_hex2rgb(esc_attr($mkd_options['header_top_background_color'])) : mikado_one_mikado_hex2rgb("#ffffff");
	$header_top_color_per_page .= "background-color:rgba(" . $header_background_color[0] . ", " . $header_background_color[1] . ", " . $header_background_color[2] . ", " . esc_attr($header_color_transparency_per_page) . ");";
}

$header_color_transparency_on_scroll="";
if(isset($mkd_options['header_background_transparency_sticky']) && $mkd_options['header_background_transparency_sticky'] != ""){
	$header_color_transparency_on_scroll = esc_attr($mkd_options['header_background_transparency_sticky']);
}

$header_separator = mikado_one_mikado_hex2rgb("#c0c0c0");
if(isset($mkd_options['header_separator_color']) && $mkd_options['header_separator_color'] != ""){
	$header_separator = mikado_one_mikado_hex2rgb(esc_attr($mkd_options['header_separator_color']));
}

$header_bottom_border_style = '';
if(isset($mkd_options['header_botom_border_in_grid']) && $mkd_options['header_botom_border_in_grid'] == "yes" && get_post_meta(mikado_one_mikado_get_page_id(), "mkd_header_bottom_border_color", true) != ""){
	$header_bottom_border_style = 'border-bottom: 1px solid '.esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_header_bottom_border_color", true)).';';
}

//generate header classes based on mkd options
$header_classes = '';

$header_bottom_appearance = 'regular';
if(isset($mkd_options['header_bottom_appearance'])){
	$header_bottom_appearance = esc_attr($mkd_options['header_bottom_appearance']);
}

$per_page_header_transparency = esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), 'mkd_header_color_transparency_per_page', true));
$header_transparency = '';

if($per_page_header_transparency !== '') {
	$header_transparency = $per_page_header_transparency;
} else {
	$header_transparency = esc_attr($mkd_options['header_background_transparency_initial']);
}

$vertical_area_background_image = "";
if(isset($mkd_options['vertical_area_background_image']) && $mkd_options['vertical_area_background_image'] != "" && isset($mkd_options['vertical_area_dropdown_showing']) && $mkd_options['vertical_area_dropdown_showing'] != "side") {
	$vertical_area_background_image = 'background-image: url('.$mkd_options['vertical_area_background_image'].')';
}
if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page_vertical_area_background_image", true) != "" && isset($mkd_options['vertical_area_dropdown_showing']) && $mkd_options['vertical_area_dropdown_showing'] != "side"){
	$vertical_area_background_image = 'background-image: url('.get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page_vertical_area_background_image", true).')';
}

?>
<?php if($enable_vertical_menu) { ?>
	<?php


    $vertical_area_dropdown_showing = esc_attr($mkd_options['vertical_area_dropdown_showing']);

    switch($vertical_area_dropdown_showing){
        case 'hover':
            $vertical_menu_style = "toggle";
            break;
        case 'click':
            $vertical_menu_style = "toggle click";
            break;
        case 'side':
            $vertical_menu_style = "side";
            break;
        default:
            $vertical_menu_style = "toggle";

    }
	$vertical_area_scroll = " with_scroll";

	$page_vertical_area_background = "";
	if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page_vertical_area_background", true) != ""){
		$page_vertical_area_background = 'background-color:'.esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page_vertical_area_background", true)).';';
	}
	
	?>
	<aside class="vertical_menu_area<?php echo esc_attr($vertical_area_scroll); ?> <?php echo esc_attr($header_style); ?>" <?php mikado_one_mikado_style_attr($page_vertical_area_background); ?>>
		<div class="vertical_menu_area_inner">
			<?php if(isset($mkd_options['vertical_area_type']) && $mkd_options['vertical_area_type'] == 'hidden') { ?>
			<a href="#" class="vertical_menu_hidden_button">
				<span class="vertical_menu_hidden_button_line"></span>
			</a>
			<?php } ?>

			<div class="vertical_area_background" <?php mikado_one_mikado_style_attr($vertical_area_background_image); ?>></div>

			<?php if (!(isset($mkd_options['show_logo']) && $mkd_options['show_logo'] == "no")){ ?>
				<div class="vertical_logo_wrapper" >
					<?php
					if (isset($mkd_options['logo_image']) && $mkd_options['logo_image'] != ""){ $logo_image = $mkd_options['logo_image'];}else{ $logo_image =  get_template_directory_uri().'/img/logo.png'; };
					if (isset($mkd_options['logo_image_light']) && $mkd_options['logo_image_light'] != ""){ $logo_image_light = $mkd_options['logo_image_light'];}else{ $logo_image_light =  get_template_directory_uri().'/img/logo.png'; };
					if (isset($mkd_options['logo_image_dark']) && $mkd_options['logo_image_dark'] != ""){ $logo_image_dark = $mkd_options['logo_image_dark'];}else{ $logo_image_dark =  get_template_directory_uri().'/img/logo_black.png'; };

					?>
					<div class="mkd_logo_vertical" style="height: <?php echo intval($mkd_options['logo_height'])/2 ?>px;">
						<a href="<?php echo esc_url(home_url('/')); ?>">
							<img class="normal" src="<?php echo esc_url($logo_image); ?>" alt="<?php esc_attr_e( 'Logo', 'mikado1' ); ?>"/>
							<img class="light" src="<?php echo esc_url($logo_image_light); ?>" alt="<?php esc_attr_e( 'Logo', 'mikado1' ); ?>"/>
							<img class="dark" src="<?php echo esc_url($logo_image_dark); ?>" alt="<?php esc_attr_e( 'Logo', 'mikado1' ); ?>"/>
						</a>
					</div>

				</div>
			<?php } ?>

			<nav class="vertical_menu dropdown_animation vertical_menu_<?php echo esc_attr($vertical_menu_style); ?>">
				<?php

				wp_nav_menu( array( 'theme_location' => 'top-navigation' ,
					'container'  => '',
					'container_class' => '',
					'menu_class' => '',
					'menu_id' => '',
					'fallback_cb' => 'top_navigation_fallback',
					'link_before' => '<span>',
					'link_after' => '</span>',
					'walker' => new mikado_one_mikado_type1_walker_nav_menu()
				));
				?>
			</nav>
			<div class="vertical_menu_area_widget_holder">
				<?php dynamic_sidebar('vertical_menu_area'); ?>
			</div>
		</div>

	</aside>
	<?php if((isset($mkd_options['vertical_area_type']) && $mkd_options['vertical_area_type'] == 'hidden') &&
		(isset($mkd_options['vertical_logo_bottom']) && $mkd_options['vertical_logo_bottom'] !== '')) { ?>
		<div class="vertical_menu_area_bottom_logo">
			<div class="vertical_menu_area_bottom_logo_inner">
				<a href="javascript: void(0)">
					<img src="<?php echo esc_url($mkd_options['vertical_logo_bottom']); ?>" alt="vertical-logo-bottom"/>
				</a>
			</div>
		</div>
	<?php } ?>
<?php } ?>
<?php
global $mkd_toolbar;
?>
<?php if(!$enable_vertical_menu){ ?>
	<header class="<?php mikado_one_mikado_header_classes(); ?>">
	<div class="header_inner clearfix">

<!--insert start-->
	<?php if($header_bottom_appearance != "stick_with_left_right_menu") { ?>
		<?php if(isset($mkd_options['enable_search']) && $mkd_options['enable_search'] == "yes" ){ ?>
			<?php if( ($header_color_transparency_per_page == '' || $header_color_transparency_per_page == '1') && ($header_color_transparency_on_scroll=='' || $header_color_transparency_on_scroll == '1') &&  isset($mkd_options['search_type']) && $mkd_options['search_type'] == "search_slides_from_header_bottom"){ ?>
			<form role="search" action="<?php echo esc_url(home_url('/')); ?>" class="mkd_search_form_2" method="get">
				<?php if($header_in_grid){ ?>
				<div class="container">
					<div class="container_inner clearfix">
					 <?php } ?>
						<div class="form_holder_outer">
							<div class="form_holder">
								<input type="text" placeholder="<?php esc_attr_e('Search','mikado1'); ?>" name="s" class="mkd_search_field" autocomplete="off" />
								<input type="submit" value="&#xf002" />
							</div>
						</div>
						<?php if($header_in_grid){ ?>
					</div>
				</div>
			<?php } ?>
			</form>

		<?php } else if(isset($mkd_options['search_type']) && $mkd_options['search_type'] == "search_covers_header") { ?>

		<form role="search" action="<?php echo esc_url(home_url('/')); ?>" class="mkd_search_form_3" method="get">
				<?php if($header_in_grid){ ?>
				<div class="container">
					<div class="container_inner clearfix">
				<?php } ?>
						<div class="form_holder_outer">
							<div class="form_holder">
								
								<input type="text" placeholder="<?php esc_attr_e('Search','mikado1'); ?>" name="s" class="mkd_search_field" autocomplete="off" />
			<!--                    <input type="submit" value="&#xf002" />-->

								<div class="mkd_search_close">
									<a href="#">
										<i class="fa fa-times"></i>
									</a>
								</div>
							</div>
						</div>
				<?php if($header_in_grid){ ?>
					</div>
				</div>
			<?php } ?>
			</form>
			<?php } ?>
		<?php } ?>
	<?php } ?>
<!--insert end-->
	<div class="header_top_bottom_holder">
		<?php if($display_header_top == "yes"){ ?>
			<div class="header_top clearfix" <?php mikado_one_mikado_style_attr($header_top_color_per_page); ?> >
				<?php if($header_in_grid){ ?>
				<div class="container">
					<div class="container_inner clearfix" >
						<?php } ?>
						<div class="left">
							<div class="inner">
								<?php
								dynamic_sidebar('header_left');
								?>
							</div>
						</div>
						<div class="right">
							<div class="inner">
								<?php
								dynamic_sidebar('header_right');
								?>
							</div>
						</div>
						<?php if($header_in_grid){ ?>
					</div>
				</div>
			<?php } ?>
			</div>
		<?php } ?>
		<div class="header_bottom clearfix <?php if($menu_item_icon_position=="top"){echo 'with_large_icons ';} if($menu_position == "left" && $header_bottom_appearance != "fixed_hiding" && $header_bottom_appearance != "stick menu_bottom" && $header_bottom_appearance != "stick_with_left_right_menu"){ echo 'left_menu_position';} ?>" <?php mikado_one_mikado_style_attr($header_color_per_page); ?> >
			<?php if($header_in_grid){ ?>
			<div class="container">
				<div class="container_inner clearfix" <?php mikado_one_mikado_style_attr($header_bottom_border_style); ?>>
					<?php } ?>
                    <?php if($header_bottom_appearance == "stick_with_left_right_menu") { ?>
                        <nav class="main_menu drop_down left_side" <?php mikado_one_mikado_style_attr($divided_left_menu_padding); ?>>
                            <?php
                            wp_nav_menu( array( 'theme_location' => 'left-top-navigation' ,
                                'container'  => '',
                                'container_class' => '',
                                'menu_class' => '',
                                'menu_id' => '',
                                'fallback_cb' => 'top_navigation_fallback',
                                'link_before' => '<span>',
                                'link_after' => '</span>',
                                'walker' => new mikado_one_mikado_type1_walker_nav_menu()
                            ));
                            ?>
                        </nav>
                    <?php } ?>
					<div class="header_inner_left">
                        <?php if($centered_logo && $header_bottom_appearance !== "stick menu_bottom") {
                            dynamic_sidebar( 'header_left_from_logo' );
                        } ?>
						<?php if(mikado_one_mikado_is_main_menu_set()) { ?>
							<div class="mobile_menu_button"><span><i class="fa fa-bars"></i></span></div>
						<?php } ?>
						
						
						
						<?php if (!(isset($mkd_options['show_logo']) && $mkd_options['show_logo'] == "no")){ ?>
							<div class="logo_wrapper" <?php mikado_one_mikado_style_attr($logo_wrapper_style); ?> >
								<?php
								if (isset($mkd_options['logo_image']) && $mkd_options['logo_image'] != ""){ $logo_image = esc_url($mkd_options['logo_image']);}else{ $logo_image =  get_template_directory_uri().'/img/logo.png'; };
								if (isset($mkd_options['logo_image_light']) && $mkd_options['logo_image_light'] != ""){ $logo_image_light = esc_url($mkd_options['logo_image_light']);}else{ $logo_image_light =  get_template_directory_uri().'/img/logo.png'; };
								if (isset($mkd_options['logo_image_dark']) && $mkd_options['logo_image_dark'] != ""){ $logo_image_dark = esc_url($mkd_options['logo_image_dark']);}else{ $logo_image_dark =  get_template_directory_uri().'/img/logo_black.png'; };
								if (isset($mkd_options['logo_image_sticky']) && $mkd_options['logo_image_sticky'] != ""){ $logo_image_sticky = esc_url($mkd_options['logo_image_sticky']);}else{ $logo_image_sticky =  get_template_directory_uri().'/img/logo_black.png'; };
								if (isset($mkd_options['logo_image_popup']) && $mkd_options['logo_image_popup'] != ""){ $logo_image_popup = esc_url($mkd_options['logo_image_popup']);}else{ $logo_image_popup =  get_template_directory_uri().'/img/logo_white.png'; };
								if (isset($mkd_options['logo_image_fixed_hidden']) && $mkd_options['logo_image_fixed_hidden'] != ""){ $logo_image_fixed_hidden = esc_url($mkd_options['logo_image_fixed_hidden']);}else{ $logo_image_fixed_hidden =  get_template_directory_uri().'/img/logo.png'; };
								if (isset($mkd_options['logo_image_mobile']) && $mkd_options['logo_image_mobile'] != ""){
									$logo_image_mobile = esc_url($mkd_options['logo_image_mobile']);
								}else{ 
									if(isset($mkd_options['logo_image']) && $mkd_options['logo_image'] != ""){
										$logo_image_mobile = esc_url($mkd_options['logo_image']);
									}else{ 
										$logo_image_mobile =  get_template_directory_uri().'/img/logo.png'; 
									}
								}
								?>
								<div class="mkd_logo"><a <?php mikado_one_mikado_style_attr($logo_wrapper_style); ?> href="<?php echo esc_url(home_url('/')); ?>"><img class="normal" src="<?php echo esc_url($logo_image); ?>" alt="<?php esc_attr_e( 'Logo', 'mikado1' ); ?>"/><img class="light" src="<?php echo esc_url($logo_image_light); ?>" alt="<?php esc_attr_e( 'Logo', 'mikado1' ); ?>"/><img class="dark" src="<?php echo esc_url($logo_image_dark); ?>" alt="<?php esc_attr_e( 'Logo', 'mikado1' ); ?>"/><img class="sticky" src="<?php echo esc_url($logo_image_sticky); ?>" alt="<?php esc_attr_e( 'Logo', 'mikado1' ); ?>"/><img class="mobile" src="<?php echo esc_url($logo_image_mobile); ?>" alt="<?php esc_attr_e( 'Logo', 'mikado1' ); ?>"/><?php if($enable_popup_menu == 'yes'){ ?><img class="popup" src="<?php echo esc_url($logo_image_popup); ?>" alt="<?php esc_attr_e( 'Logo', 'mikado1' ); ?>"/><?php } ?></a></div>
								<?php if($header_bottom_appearance == "fixed_hiding") { ?>
									<div class="mkd_logo_hidden"><a href="<?php echo esc_url(home_url('/')); ?>"><img alt="<?php esc_attr_e( 'Logo', 'mikado1' ); ?>" src="<?php echo esc_url($logo_image_fixed_hidden); ?>" style="height: 100%;"></a></div>
								<?php } ?>
							</div>
						<?php } ?>
						
						
						<?php if($header_bottom_appearance == "stick menu_bottom" && is_active_sidebar('header_fixed_right')){ ?>
							<div class="header_fixed_right_area">
								<?php dynamic_sidebar('header_fixed_right'); ?>
							</div>
						<?php } ?>
                        <?php if($centered_logo && $header_bottom_appearance !== "stick menu_bottom") {
                            dynamic_sidebar( 'header_right_from_logo' );
                        } ?>
					</div>
					<?php if($header_bottom_appearance == "stick_with_left_right_menu") { ?>
                        <nav class="main_menu drop_down right_side" <?php mikado_one_mikado_style_attr($divided_right_menu_padding); ?>>
                            <?php
                            wp_nav_menu( array( 'theme_location' => 'right-top-navigation' ,
                                'container'  => '',
                                'container_class' => '',
                                'menu_class' => '',
                                'menu_id' => '',
                                'fallback_cb' => 'top_navigation_fallback',
                                'link_before' => '<span>',
                                'link_after' => '</span>',
                                'walker' => new mikado_one_mikado_type1_walker_nav_menu()
                            ));
                            ?>
                        </nav>
                    <?php } ?>
					<?php if($header_bottom_appearance != "stick menu_bottom" && $header_bottom_appearance != "stick_with_left_right_menu"){ ?>
                        <?php if($header_bottom_appearance == "fixed_hiding") { ?> <div class="holeder_for_hidden_menu"> <?php } //only for fixed with hiding menu ?>
                        <?php if(!$centered_logo) { ?>
							<div class="header_inner_right">
								<div class="side_menu_button_wrapper right">
									<?php if(is_active_sidebar('header_bottom_right')) { ?>
										<div class="header_bottom_right_widget_holder"><?php dynamic_sidebar('header_bottom_right'); ?></div>
									<?php } ?>
									<?php if(is_active_sidebar('woocommerce_dropdown')) {
										dynamic_sidebar('woocommerce_dropdown');
									} ?>
									<div class="side_menu_button">
<!-- insert start-->
                                    <?php if(isset($mkd_options['enable_search']) && $mkd_options['enable_search'] == 'yes') {
                                        $search_type_class = 'search_slides_from_top';
                                        if(isset($mkd_options['search_type']) && $mkd_options['search_type'] !== '') {
                                            $search_type_class = $mkd_options['search_type'];
                                        } ?>

                                        <a class="<?php echo esc_attr($search_type_class); ?>" href="javascript:void(0)">
                                            <i class="fa fa-search"></i>
                                        </a>

                                    <?php } ?>
<!--insert end-->
										<?php if($enable_popup_menu == "yes"){ ?>
											<a href="javascript:void(0)" class="popup_menu <?php echo esc_attr($header_button_size); ?>"><span class="popup_menu_inner"><i class="line">&nbsp;</i></span></a>
										<?php } ?>
										<?php if($enable_side_area == "yes" && $enable_popup_menu == 'no'){ ?>
										<a class="side_menu_button_link <?php echo esc_attr($header_button_size); ?>" href="javascript:void(0)">
												<i class="fa fa-bars"></i>
										</a><?php } ?>
									</div>
								</div>
							</div>
						<?php } ?>
						<?php if($centered_logo == true && $enable_border_top_bottom_menu == true) { ?> <div class="main_menu_and_widget_holder"> <?php } //only for logo is centered ?>
						<nav class="main_menu drop_down <?php if($menu_position == "" && $header_bottom_appearance != "stick menu_bottom"){ echo 'right';} ?>">
							<?php

							wp_nav_menu( array( 'theme_location' => 'top-navigation' ,
								'container'  => '',
								'container_class' => '',
								'menu_class' => '',
								'menu_id' => '',
								'fallback_cb' => 'top_navigation_fallback',
								'link_before' => '<span>',
								'link_after' => '</span>',
								'walker' => new mikado_one_mikado_type1_walker_nav_menu()
							));
							?>
						</nav>
						<?php if($centered_logo) { ?>
							<div class="header_inner_right">
								<div class="side_menu_button_wrapper right">
									<?php if(is_active_sidebar('header_bottom_right')) { ?>
										<div class="header_bottom_right_widget_holder"><?php dynamic_sidebar('header_bottom_right'); ?></div>
									<?php } ?>
									<?php if(is_active_sidebar('woocommerce_dropdown')) {
										dynamic_sidebar('woocommerce_dropdown');
									} ?>
									<div class="side_menu_button">
										<?php if(isset($mkd_options['enable_search']) && $mkd_options['enable_search'] == 'yes') {
											$search_type_class = 'search_slides_from_top';
											if(isset($mkd_options['search_type']) && $mkd_options['search_type'] !== '') {
												$search_type_class = $mkd_options['search_type'];
											} ?>

											<a class="<?php echo esc_attr($search_type_class); ?>" href="javascript:void(0)">
												<i class="fa fa-search"></i>
											</a>

										<?php } ?>
										<?php if($enable_popup_menu == "yes"){ ?>
											<a href="javascript:void(0)" class="popup_menu <?php echo esc_attr($header_button_size); ?>"><span class="popup_menu_inner"><i class="line">&nbsp;</i></span></a>
										<?php } ?>
										<?php if($enable_side_area == "yes" && $enable_popup_menu == 'no'){ ?>
											<a class="side_menu_button_link <?php echo esc_attr($header_button_size); ?>" href="javascript:void(0)">
												<i class="fa fa-bars"></i>
											</a>
										<?php } ?>

									</div>
								</div>
							</div>
						<?php } ?>
						<?php if($centered_logo == true && $enable_border_top_bottom_menu == true) { ?> </div> <?php } //only for logo is centered ?>
                        <?php if($header_bottom_appearance == "fixed_hiding") { ?> </div> <?php } //only for fixed with hiding menu ?>
					<?php }else if($header_bottom_appearance == "stick menu_bottom"){ ?>
					<div class="header_menu_bottom clearfix">
						<div class="header_menu_bottom_inner">
							<?php if($centered_logo) { ?>
							<div class="main_menu_header_inner_right_holder with_center_logo">
								<?php } else { ?>
								<div class="main_menu_header_inner_right_holder">
									<?php } ?>
									<nav class="main_menu drop_down">
										<?php
										wp_nav_menu( array(
											'theme_location' => 'top-navigation' ,
											'container'  => '',
											'container_class' => '',
											'menu_class' => 'clearfix',
											'menu_id' => '',
											'fallback_cb' => 'top_navigation_fallback',
											'link_before' => '<span>',
											'link_after' => '</span>',
											'walker' => new mikado_one_mikado_type1_walker_nav_menu()
										));
										?>
									</nav>
									<div class="header_inner_right">
										<div class="side_menu_button_wrapper right">
											<?php if(is_active_sidebar('header_bottom_right')) { ?>
												<div class="header_bottom_right_widget_holder"><?php dynamic_sidebar('header_bottom_right'); ?></div>
											<?php } ?>
											<?php if(is_active_sidebar('woocommerce_dropdown')) {
												dynamic_sidebar('woocommerce_dropdown');
											} ?>
											<div class="side_menu_button">
<!-- insert start-->
											<?php if(isset($mkd_options['enable_search']) && $mkd_options['enable_search'] == 'yes') {
												$search_type_class = 'search_slides_from_top';
												if(isset($mkd_options['search_type']) && $mkd_options['search_type'] !== '') {
													$search_type_class = esc_attr($mkd_options['search_type']);
												} ?>

												<a class="<?php echo esc_attr($search_type_class); ?>" href="javascript:void(0)">
													<i class="fa fa-search"></i>
												</a>

											<?php } ?>
<!--insert end-->
												<?php if($enable_popup_menu == "yes"){ ?>
													<a href="javascript:void(0)" class="popup_menu <?php echo esc_attr($header_button_size); ?>"><span class="popup_menu_inner"><i class="line">&nbsp;</i></span></a>
												<?php } ?>
												<?php if($enable_side_area == "yes" && $enable_popup_menu == 'no'){ ?>
													<a class="side_menu_button_link <?php echo esc_attr($header_button_size); ?>" href="javascript:void(0)">
														<i class="fa fa-bars"></i>
													</a>
												<?php } ?>
										
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
						<?php } ?>
						<nav class="mobile_menu">
							<?php
                            if($header_bottom_appearance == "stick_with_left_right_menu") {
                                echo '<ul>';
                                wp_nav_menu( array( 'theme_location' => 'left-top-navigation' ,
                                    'container'  => '',
                                    'container_class' => '',
                                    'menu_class' => '',
                                    'menu_id' => '',
                                    'fallback_cb' => '',
                                    'link_before' => '<span>',
                                    'link_after' => '</span>',
                                    'walker' => new mikado_one_mikado_type4_walker_nav_menu(),
                                    'items_wrap'      => '%3$s'
                                ));
                                wp_nav_menu( array( 'theme_location' => 'right-top-navigation' ,
                                    'container'  => '',
                                    'container_class' => '',
                                    'menu_class' => '',
                                    'menu_id' => '',
                                    'fallback_cb' => '',
                                    'link_before' => '<span>',
                                    'link_after' => '</span>',
                                    'walker' => new mikado_one_mikado_type4_walker_nav_menu(),
                                    'items_wrap'      => '%3$s'
                                ));
                                echo '</ul>';
                            }else{
                                wp_nav_menu( array( 'theme_location' => 'top-navigation' ,
                                    'container'  => '',
                                    'container_class' => '',
                                    'menu_class' => '',
                                    'menu_id' => '',
                                    'fallback_cb' => 'top_navigation_fallback',
                                    'link_before' => '<span>',
                                    'link_after' => '</span>',
                                    'walker' => new mikado_one_mikado_type2_walker_nav_menu()
                                ));
                            }
							?>
						</nav>
						<?php if($header_in_grid){ ?>
					</div>
				</div>
				<?php } ?>
			</div>
		</div>
	</div>

	</header>
<?php } else{?>
	<header class="page_header <?php if($display_header_top == "yes"){ echo 'has_top'; }  if($header_top_area_scroll == "yes"){ echo ' scroll_top'; }?> <?php if($centered_logo){ echo " centered_logo"; } ?> <?php echo esc_attr($header_bottom_appearance); ?>  <?php echo esc_attr($header_style); ?> <?php if(is_active_sidebar('header_fixed_right')) { echo 'has_header_fixed_right'; } ?>">
		<?php if(isset($mkd_toolbar)) include("toolbar.php") ?>
		<div class="header_inner clearfix">
			
			<div class="header_bottom clearfix" <?php mikado_one_mikado_style_attr($header_color_per_page); ?> >
				<?php if($header_in_grid){ ?>
				<div class="container">
					<div class="container_inner clearfix" <?php mikado_one_mikado_style_attr($header_bottom_border_style); ?>>
						<?php } ?>
						<div class="header_inner_left">
							<?php if(mikado_one_mikado_is_main_menu_set()) { ?>
								<div class="mobile_menu_button"><span><i class="fa fa-bars"></i></span></div>
							<?php } ?>
							<?php if (!(isset($mkd_options['show_logo']) && $mkd_options['show_logo'] == "no")){ ?>
								<div class="logo_wrapper">
									<?php
									if (isset($mkd_options['logo_image']) && $mkd_options['logo_image'] != ""){ $logo_image = esc_url($mkd_options['logo_image']);}else{ $logo_image =  get_template_directory_uri().'/img/logo.png'; };
									if (isset($mkd_options['logo_image_light']) && $mkd_options['logo_image_light'] != ""){ $logo_image_light = esc_url($mkd_options['logo_image_light']);}else{ $logo_image_light =  get_template_directory_uri().'/img/logo.png'; };
									if (isset($mkd_options['logo_image_dark']) && $mkd_options['logo_image_dark'] != ""){ $logo_image_dark = esc_url($mkd_options['logo_image_dark']);}else{ $logo_image_dark =  get_template_directory_uri().'/img/logo_black.png'; };
									if (isset($mkd_options['logo_image_sticky']) && $mkd_options['logo_image_sticky'] != ""){ $logo_image_sticky = esc_url($mkd_options['logo_image_sticky']);}else{ $logo_image_sticky =  get_template_directory_uri().'/img/logo_black.png'; };
									if (isset($mkd_options['logo_image_popup']) && $mkd_options['logo_image_popup'] != ""){ $logo_image_popup = esc_url($mkd_options['logo_image_popup']);}else{ $logo_image_popup =  get_template_directory_uri().'/img/logo_white.png'; };
									if (isset($mkd_options['logo_image_mobile']) && $mkd_options['logo_image_mobile'] != ""){
										$logo_image_mobile = esc_url($mkd_options['logo_image_mobile']);
									}else{ 
										if(isset($mkd_options['logo_image']) && $mkd_options['logo_image'] != ""){
											$logo_image_mobile = esc_url($mkd_options['logo_image']);
										}else{ 
											$logo_image_mobile =  get_template_directory_uri().'/img/logo.png'; 
										}
									}
									?>
									<div class="mkd_logo"><a href="<?php echo esc_url(home_url('/')); ?>"><img class="normal" src="<?php echo esc_url($logo_image); ?>" alt="<?php esc_attr_e( 'Logo', 'mikado1' ); ?>"/><img class="light" src="<?php echo esc_url($logo_image_light); ?>" alt="<?php esc_attr_e( 'Logo', 'mikado1' ); ?>"/><img class="dark" src="<?php echo esc_url($logo_image_dark); ?>" alt="<?php esc_attr_e( 'Logo', 'mikado1' ); ?>"/><img class="sticky" src="<?php echo esc_url($logo_image_sticky); ?>" alt="<?php esc_attr_e( 'Logo', 'mikado1' ); ?>"/><img class="mobile" src="<?php echo esc_url($logo_image_mobile); ?>" alt="<?php esc_attr_e( 'Logo', 'mikado1' ); ?>"/><?php if($enable_popup_menu == 'yes'){ ?><img class="popup" src="<?php echo esc_url($logo_image_popup); ?>" alt="<?php esc_attr_e( 'Logo', 'mikado1' ); ?>"/><?php } ?></a></div>
								</div>
							<?php } ?>
						</div>


						<?php if($header_in_grid){ ?>
					</div>
				</div>
			<?php } ?>
				<nav class="mobile_menu">
					<?php
					wp_nav_menu( array( 'theme_location' => 'top-navigation' ,
						'container'  => '',
						'container_class' => '',
						'menu_class' => '',
						'menu_id' => '',
						'fallback_cb' => 'top_navigation_fallback',
						'link_before' => '<span>',
						'link_after' => '</span>',
						'walker' => new mikado_one_mikado_type2_walker_nav_menu()
					));
					?>
				</nav>
			</div>
		</div>
	</header>
<?php } ?>
<?php if($mkd_options['show_back_button'] == "yes") {
    $mkd_back_to_top_button_styles = "";
    if(isset($mkd_options['back_to_top_position']) && !empty($mkd_options['back_to_top_position'])) {
        $mkd_back_to_top_button_styles = $mkd_options['back_to_top_position'];
    } ?>
	<a id='back_to_top' class="<?php echo esc_attr($mkd_back_to_top_button_styles);?>" href='#'>
			<span class="fa-stack">
				<span class="arrow_carrot-up"></span>
			</span>
	</a>
<?php } ?>
<?php if($enable_popup_menu == "yes"){ ?>
	<div class="popup_menu_holder_outer">
		<div class="popup_menu_holder">
			<div class="popup_menu_holder_inner">
				<nav class="popup_menu">
					<?php
					wp_nav_menu( array( 'theme_location' => 'popup-navigation' ,
						'container'  => '',
						'container_class' => '',
						'menu_class' => '',
						'menu_id' => '',
						'fallback_cb' => 'top_navigation_fallback',
						'link_before' => '<span>',
						'link_after' => '</span>',
						'walker' => new mikado_one_mikado_type3_walker_nav_menu()
					));
					?>
				</nav>
			</div>
		</div>
	</div>
<?php } ?>

<?php
$content_class = "";
$is_title_area_visible = true;
if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_show-page-title", true) == 'yes') {
	$is_title_area_visible = true;
} elseif(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_show-page-title", true) == 'no') {
	$is_title_area_visible = false;
} elseif(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_show-page-title", true) == '' && (isset($mkd_options['show_page_title']) && $mkd_options['show_page_title'] == 'yes')) {
	$is_title_area_visible = true;
} elseif(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_show-page-title", true) == '' && (isset($mkd_options['show_page_title']) && $mkd_options['show_page_title'] == 'no')) {
	$is_title_area_visible = false;
} elseif(isset($mkd_options['show_page_title']) && $mkd_options['show_page_title'] == 'yes') {
	$is_title_area_visible = true;
}

if((get_post_meta(mikado_one_mikado_get_page_id(), "mkd_revolution-slider", true) == "" && ($header_transparency == '' || $header_transparency == 1)) || get_post_meta(mikado_one_mikado_get_page_id(), "mkd_enable_content_top_margin", true) == "yes"){
	if($mkd_options['header_bottom_appearance'] == "fixed" || $mkd_options['header_bottom_appearance'] == "fixed_hiding"){
		$content_class = "content_top_margin";
	}else {
		$content_class = "content_top_margin_none";
	}
}
//check if there is slider added and set class to content div, this is used for content top margin in style_dynamic.php
if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_revolution-slider", true) != ""){
    $content_class .= " has_slider";
}
?>

<?php
if(isset($mkd_options['paspartu']) && $mkd_options['paspartu'] == 'yes'){

$paspartu_additional_classes = "";
if(isset($mkd_options['paspartu_on_top']) && $mkd_options['paspartu_on_top'] == 'no'){
    $paspartu_additional_classes .= " disable_top_paspartu";
}
if(isset($mkd_options['paspartu_on_bottom']) && $mkd_options['paspartu_on_bottom'] == 'no'){
    $paspartu_additional_classes .= " disable_bottom_paspartu";
}
if(isset($mkd_options['paspartu_on_top']) && $mkd_options['paspartu_on_top'] == 'no' && isset($mkd_options['paspartu_on_bottom_slider']) && $mkd_options['paspartu_on_bottom_slider'] == 'yes'){
    $paspartu_additional_classes .= " paspartu_on_bottom_slider";
}
if(isset($mkd_options['paspartu_on_bottom']) && $mkd_options['paspartu_on_bottom'] == 'yes' && isset($mkd_options['paspartu_on_bottom_fixed']) && $mkd_options['paspartu_on_bottom_fixed'] == 'yes'){
    $paspartu_additional_classes .= " paspartu_on_bottom_fixed";
}
?>
<div class="paspartu_outer <?php echo esc_attr($paspartu_additional_classes); ?>">
    <div class="paspartu_left"></div>
    <div class="paspartu_right"></div>
    <?php if(isset($mkd_options['paspartu_on_bottom']) && $mkd_options['paspartu_on_bottom'] == 'yes' && isset($mkd_options['paspartu_on_bottom_fixed']) && $mkd_options['paspartu_on_bottom_fixed'] == 'yes'){ ?>
        <div class="paspartu_bottom"></div>
    <?php }?>
        <div class="paspartu_inner">
<?php
}
?>

<div class="content <?php echo esc_attr($content_class); ?>">
	<?php
	$animation = get_post_meta(mikado_one_mikado_get_page_id(), "mkd_show-animation", true);
	if (!empty($_SESSION['mkd_animation']) && $animation == "")
		$animation = $_SESSION['mkd_animation'];

	?>
	<?php if($mkd_options['page_transitions'] == "1" || $mkd_options['page_transitions'] == "2" || $mkd_options['page_transitions'] == "3" || $mkd_options['page_transitions'] == "4" || ($animation == "updown") || ($animation == "fade") || ($animation == "updown_fade") || ($animation == "leftright")){ ?>
		<div class="meta">
			<?php do_action('mikado_one_mikado_action_header_meta'); ?>
			<span id="mkd_page_id"><?php echo esc_html($wp_query->get_queried_object_id()); ?></span>
			<div class="body_classes"><?php echo implode( ',', get_body_class()); ?></div>
		</div>
	<?php } ?>
	<div class="content_inner <?php echo esc_attr($animation);?> ">
		<?php if($mkd_options['page_transitions'] == "1" || $mkd_options['page_transitions'] == "2" || $mkd_options['page_transitions'] == "3" || $mkd_options['page_transitions'] == "4" || ($animation == "updown") || ($animation == "fade") || ($animation == "updown_fade") || ($animation == "leftright")){ ?>
		<?php do_action('mikado_one_mikado_visual_composer_custom_shortcodce_css');?>
	<?php } ?>