<?php
/*
Template Name: Full Screen Sections
*/
?>
<?php

$full_screen_holder_style = "";

if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page_background_color", true) != ""){
    $full_screen_holder_style .= "background-color:".esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page_background_color", true)).";";
}else{
    $full_screen_holder_style .= "";
}

$header_bottom_appearance = 'regular';
if(isset($mkd_options['header_bottom_appearance'])){
    $header_bottom_appearance = esc_attr($mkd_options['header_bottom_appearance']);
}

$enable_paspartu = false;
if(isset($mkd_options['paspartu']) && $mkd_options['paspartu'] == 'yes'){
    $enable_paspartu = true;
}

$enable_vertical_menu = false;
if(isset($mkd_options['vertical_area']) && $mkd_options['vertical_area'] =='yes' && !$enable_paspartu){
    $enable_vertical_menu = true;
}

$content_style = "";
if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_content-top-padding", true) != ""){
    if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_content-top-padding-mobile", true) == 'yes'){
        $content_style = "padding-top:".esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_content-top-padding", true))."px !important";
    }else{
        $content_style = "padding-top:".esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_content-top-padding", true))."px";
    }
}

?>
<?php get_header(); ?>
    <div class="full_screen_preloader">
        <?php
            if(isset($mkd_options['loading_animation']) && $mkd_options['loading_animation'] == "on") { ?>
                <div class="ajax_loader"><div class="ajax_loader_1"><?php mikado_one_mikado_loading_spinners(); ?></div></div>
            <?php }
        ?>
    </div>

    <div class="full_screen_holder"<?php mikado_one_mikado_style_attr($full_screen_holder_style); ?>>
        <div class="full_screen_inner" <?php mikado_one_mikado_style_attr($content_style); ?>>

            <?php if (have_posts()) : while (have_posts()) : the_post(); ?>

                <?php the_content(); ?>

            <?php endwhile; endif; ?>
            <?php wp_reset_postdata(); ?>

        </div>
        <div class="full_screen_navigation_holder">
            <div class="full_screen_navigation_inner">
                <a id="up_fs_button" href="#" target="_self"><span class='arrow_carrot-up'></span></a>
                <a id="down_fs_button" href="#" target="_self"><span class='arrow_carrot-down'></span></a>
            </div>
        </div>
    </div>

<?php get_footer(); ?>