<?php
$mkd_options = mikado_one_mikado_return_global_options();

//init variables
$page_id 							= mikado_one_mikado_get_page_id();
$content_bottom_area 				= "yes";
$content_bottom_area_sidebar 		= "";
$content_bottom_area_in_grid 		= true;
$content_bottom_background_color 	= '';
$uncovering_footer					= false;
$footer_classes_array				= array();
$footer_classes						= '';
$footer_border_columns				= 'yes';
$footer_top_border_color            = '';
$footer_top_border_in_grid          = '';
$footer_bottom_border_color         = '';
$footer_bottom_border_bottom_color  = '';
$footer_bottom_border_in_grid       = '';
$oblique_section_position           = '';

if(isset($mkd_options['footer_border_columns']) && $mkd_options['footer_border_columns'] !== '') {
	$footer_border_columns = esc_attr($mkd_options['footer_border_columns']);
}

if(!empty($mkd_options['footer_top_border_color'])) {
    if (isset($mkd_options['footer_top_border_width']) && $mkd_options['footer_top_border_width'] !== '') {
        $footer_border_height = esc_attr($mkd_options['footer_top_border_width']);
        }
    else{
        $footer_border_height = '1';
    }
	$footer_top_border_color = 'height: '.esc_attr($footer_border_height).'px;background-color: '.esc_attr($mkd_options['footer_top_border_color']).';';
}

if(isset($mkd_options['footer_top_border_in_grid']) && $mkd_options['footer_top_border_in_grid'] == 'yes') {
	$footer_top_border_in_grid = 'in_grid';
}

if(!empty($mkd_options['footer_bottom_border_color'])) {
    if(!empty($mkd_options['footer_bottom_border_width'])) {
        $footer_bottom_border_width = esc_attr($mkd_options['footer_bottom_border_width']).'px';
    }
    else{
        $footer_bottom_border_width = '1px';
    }

    $footer_bottom_border_color = 'height: '.esc_attr($footer_bottom_border_width).';background-color: '.esc_attr($mkd_options['footer_bottom_border_color']).';';
}

if(isset($mkd_options['footer_bottom_border_in_grid']) && $mkd_options['footer_bottom_border_in_grid'] == 'yes') {
	$footer_bottom_border_in_grid = 'in_grid';
}

if(!empty($mkd_options['footer_bottom_border_bottom_color'])) {
    if(!empty($mkd_options['footer_bottom_border_bottom_width'])) {
        $footer_bottom_border_bottom_width = esc_attr($mkd_options['footer_bottom_border_bottom_width']).'px';
    }
    else{
        $footer_bottom_border_bottom_width = '1px';
    }

    $footer_bottom_border_bottom_color = 'height: '. esc_attr($footer_bottom_border_bottom_width) .';background-color: '.esc_attr($mkd_options['footer_bottom_border_bottom_color']).';';
}

//is content bottom area enabled for current page?
if(get_post_meta($page_id, "mkd_enable_content_bottom_area", true) != ""){
	$content_bottom_area = esc_attr(get_post_meta($page_id, "mkd_enable_content_bottom_area", true));
} elseif(isset($mkd_options['enable_content_bottom_area'])) {
	//content bottom area is turned on in theme options
	$content_bottom_area = esc_attr($mkd_options['enable_content_bottom_area']);
}

//is content bottom area enabled?
if($content_bottom_area == 'yes') {
	//is sidebar chosen for content bottom area for current page?
	if(get_post_meta($page_id, 'mkd_choose_content_bottom_sidebar', true) != ""){
		$content_bottom_area_sidebar = esc_attr(get_post_meta($page_id, 'mkd_choose_content_bottom_sidebar', true));
	} elseif(isset($mkd_options['content_bottom_sidebar_custom_display'])) {
		//sidebar is chosen for content bottom area in theme options
		$content_bottom_area_sidebar = esc_attr($mkd_options['content_bottom_sidebar_custom_display']);
	}

	//take content bottom area in grid option for current page if set or from theme options otherwise
	if(get_post_meta($page_id, 'mkd_content_bottom_sidebar_in_grid', true) != ""){
		$content_bottom_area_in_grid = esc_attr(get_post_meta($page_id, 'mkd_content_bottom_sidebar_in_grid', true));
	} elseif(isset($mkd_options['content_bottom_in_grid'])) {
		$content_bottom_area_in_grid = esc_attr($mkd_options['content_bottom_in_grid']);
	}

	//is background color for content bottom area set for current page
	if(get_post_meta($page_id, "mkd_content_bottom_background_color", true) != ""){
		$content_bottom_background_color = 'background-color: '.get_post_meta($page_id, "mkd_content_bottom_background_color", true);
	}
}
?>
<?php if($content_bottom_area == "yes") { ?>

	<div class="content_bottom" <?php mikado_one_mikado_style_attr($content_bottom_background_color); ?>>
        <?php if($content_bottom_area_in_grid == 'yes'){ ?>
            <div class="container">
            <div class="container_inner clearfix">
        <?php } ?>
            <?php dynamic_sidebar($content_bottom_area_sidebar); ?>
        <?php if($content_bottom_area_in_grid == 'yes'){ ?>
            </div>
            </div>
        <?php } ?>
	</div>
<?php } ?>

<?php

$enable_paspartu = false;
if(isset($mkd_options['paspartu']) && $mkd_options['paspartu'] == 'yes'){
    $enable_paspartu = true;
}

//is uncovering footer option set in theme options?
if(isset($mkd_options['uncovering_footer']) && $mkd_options['uncovering_footer'] == "yes" && !$enable_paspartu) {
	//add uncovering footer class to array
	$footer_classes_array[] = 'uncover';
}

if($footer_border_columns == 'yes') {
	$footer_classes_array[] = 'footer_border_columns';
}

//is some class added to footer classes array?
if(is_array($footer_classes_array) && count($footer_classes_array)) {
	//concat all classes and prefix it with class attribute
	$footer_classes = esc_attr(implode(' ', $footer_classes_array));
}

?>
    </div>
</div>

<?php
if(isset($mkd_options['paspartu']) && $mkd_options['paspartu'] == 'yes'){?>
    </div> <!-- paspartu_inner close div -->
    </div> <!-- paspartu_outer close div -->
<?php
}
?>

<?php if(isset($mkd_options['enable_social_sidebar']) && $mkd_options['enable_social_sidebar'] == 'yes') {
    $icons_param_array = array();
    if(isset($mkd_options['social_sidebar_icon_style']) && $mkd_options['social_sidebar_icon_style'] !== '') {
        $icons_param_array[] = "type='".esc_attr($mkd_options['social_sidebar_icon_style'])."'";
    }
    if(isset($mkd_options['social_sidebar_icon_size']) && $mkd_options['social_sidebar_icon_size'] !== '') {
        $icons_param_array[] = "custom_size='".esc_attr($mkd_options['social_sidebar_icon_size'])."'";
    }
    else{
        $icons_param_array[] = "custom_size='20'";
    }
    if(isset($mkd_options['social_sidebar_icon_shape_size']) && $mkd_options['social_sidebar_icon_shape_size'] !== '') {
        $icons_param_array[] = "shape_size='".esc_attr($mkd_options['social_sidebar_icon_shape_size'])."'";
    }
    if(!empty($mkd_options['social_sidebar_icon_color'])){
        $icons_param_array[] = "icon_color='".esc_attr($mkd_options['social_sidebar_icon_color'])."'";
    }
    if(!empty($mkd_options['social_sidebar_icon_hover_color'])){
        $icons_param_array[] = "hover_icon_color='".esc_attr($mkd_options['social_sidebar_icon_hover_color'])."'";
    }
    if(!empty($mkd_options['social_sidebar_icon_background_color'])){
        $icons_param_array[] = "background_color='".esc_attr($mkd_options['social_sidebar_icon_background_color'])."'";
    }
    if(!empty($mkd_options['social_sidebar_icon_background_hover_color'])){
        $icons_param_array[] = "hover_background_color='".esc_attr($mkd_options['social_sidebar_icon_background_hover_color'])."'";
    }
    if(!empty($mkd_options['social_sidebar_icon_border_color'])){
        $icons_param_array[] = "border_color='".esc_attr($mkd_options['social_sidebar_icon_border_color'])."'";
    }
    if(!empty($mkd_options['social_sidebar_icon_border_hover_color'])){
        $icons_param_array[] = "hover_border_color='".esc_attr($mkd_options['social_sidebar_icon_border_hover_color'])."'";
    }
    if(isset($mkd_options['social_sidebar_icon_border_width']) && $mkd_options['social_sidebar_icon_border_width'] !== '') {
        $icons_param_array[] = "border_width='".esc_attr($mkd_options['social_sidebar_icon_border_width'])."'";
    }

    $icons_param_array[] = "target='_self'";

    ?>
<div id="social_icons_widget">
    <div class="social_icons_widget_inner">
            <?php
                if(isset($mkd_options['social_sidebar_facebook_icon']) && $mkd_options['social_sidebar_facebook_icon'] == 'yes') {
                    $social_link = "#";
                    if(isset($mkd_options['social_sidebar_facebook_icon_link']) && $mkd_options['social_sidebar_facebook_icon_link'] !== ''){
                        $social_link = esc_url($mkd_options['social_sidebar_facebook_icon_link']);
                    }
                    ?> <div class="mkd_social_icon_holder"> <?php
                    echo do_shortcode('[no_icons icon_pack="font_elegant" fe_icon="social_facebook" link="'.$social_link.'" '.implode(' ', $icons_param_array).']');
                    ?> </div> <?php
                }
                if(isset($mkd_options['social_sidebar_twitter_icon']) && $mkd_options['social_sidebar_twitter_icon'] == 'yes') {
                    $social_link = "#";
                    if(isset($mkd_options['social_sidebar_twitter_icon_link']) && $mkd_options['social_sidebar_twitter_icon_link'] !== ''){
                        $social_link = esc_url($mkd_options['social_sidebar_twitter_icon_link']);
                    }
                    ?> <div class="mkd_social_icon_holder"> <?php
                    echo do_shortcode('[no_icons icon_pack="font_elegant" fe_icon="social_twitter" link="'.$social_link.'" '.implode(' ', $icons_param_array).']');
                    ?> </div> <?php
                }
                if(isset($mkd_options['social_sidebar_google_plus_icon']) && $mkd_options['social_sidebar_google_plus_icon'] == 'yes') {
                    $social_link = "#";
                    if(isset($mkd_options['social_sidebar_google_plus_icon_link']) && $mkd_options['social_sidebar_google_plus_icon_link'] !== ''){
                        $social_link = esc_url($mkd_options['social_sidebar_google_plus_icon_link']);
                    }
                    ?> <div class="mkd_social_icon_holder"> <?php
                    echo do_shortcode('[no_icons icon_pack="font_elegant" fe_icon="social_googleplus" link="'.$social_link.'" '.implode(' ', $icons_param_array).']');
                    ?> </div> <?php
                }
                if(isset($mkd_options['social_sidebar_linkedIn_icon']) && $mkd_options['social_sidebar_linkedIn_icon'] == 'yes') {
                    $social_link = "#";
                    if(isset($mkd_options['social_sidebar_linkedIn_icon_link']) && $mkd_options['social_sidebar_linkedIn_icon_link'] !== ''){
                        $social_link = esc_url($mkd_options['social_sidebar_linkedIn_icon_link']);
                    }
                    ?> <div class="mkd_social_icon_holder"> <?php
                    echo do_shortcode('[no_icons icon_pack="font_elegant" fe_icon="social_linkedin" link="'.$social_link.'" '.implode(' ', $icons_param_array).']');
                    ?> </div> <?php
                }
                if(isset($mkd_options['social_sidebar_tumblr_icon']) && $mkd_options['social_sidebar_tumblr_icon'] == 'yes') {
                    $social_link = "#";
                    if(isset($mkd_options['social_sidebar_tumblr_icon_link']) && $mkd_options['social_sidebar_tumblr_icon_link'] !== ''){
                        $social_link = esc_url($mkd_options['social_sidebar_tumblr_icon_link']);
                    }
                    ?> <div class="mkd_social_icon_holder"> <?php
                    echo do_shortcode('[no_icons icon_pack="font_elegant" fe_icon="social_tumblr" link="'.$social_link.'" '.implode(' ', $icons_param_array).']');
                    ?> </div> <?php
                }
                if(isset($mkd_options['social_sidebar_pinterest_icon']) && $mkd_options['social_sidebar_pinterest_icon'] == 'yes') {
                    $social_link = "#";
                    if(isset($mkd_options['social_sidebar_pinterest_icon_link']) && $mkd_options['social_sidebar_pinterest_icon_link'] !== ''){
                        $social_link = esc_url($mkd_options['social_sidebar_pinterest_icon_link']);
                    }
                    ?> <div class="mkd_social_icon_holder"> <?php
                    echo do_shortcode('[no_icons icon_pack="font_elegant" fe_icon="social_pinterest" link="'.$social_link.'" '.implode(' ', $icons_param_array).']');
                    ?> </div> <?php
                }
                if(isset($mkd_options['social_sidebar_vk_icon']) && $mkd_options['social_sidebar_vk_icon'] == 'yes') {
                    $social_link = "#";
                    if(isset($mkd_options['social_sidebar_vk_icon_link']) && $mkd_options['social_sidebar_vk_icon_link'] !== ''){
                        $social_link = esc_url($mkd_options['social_sidebar_vk_icon_link']);
                    }
                    ?> <div class="mkd_social_icon_holder"> <?php
                    echo do_shortcode('[no_icons icon_pack="font_awesome" fa_icon="fa-vk" link="'.$social_link.'" '.implode(' ', $icons_param_array).']');
                    ?> </div> <?php
                }
            ?>
    </div>
</div>
<?php } ?>
<footer <?php mikado_one_mikado_class_attr($footer_classes); ?>>
	<div class="footer_inner clearfix">
		<?php
		$footer_in_grid = true;
		if(isset($mkd_options['footer_in_grid'])){
			if ($mkd_options['footer_in_grid'] != "yes") {
				$footer_in_grid = false;
			}
		}
		$display_footer_top = true;
		if (isset($mkd_options['show_footer_top'])) {
			if ($mkd_options['show_footer_top'] == "no") $display_footer_top = false;
		}

		if ( ! is_active_sidebar( 'footer_column_1' ) && ! is_active_sidebar( 'footer_column_2' ) && ! is_active_sidebar( 'footer_column_3' ) && ! is_active_sidebar( 'footer_column_4' ) ) {
			$display_footer_top = false;
		}

		$footer_top_columns = 4;
		if (isset($mkd_options['footer_top_columns'])) {
			$footer_top_columns = esc_attr($mkd_options['footer_top_columns']);
		}

        $footer_bottom_columns = 3;
		if (isset($mkd_options['footer_bottom_columns'])) {
            $footer_bottom_columns = esc_attr($mkd_options['footer_bottom_columns']);
		}

		if($display_footer_top) {
			if($footer_top_border_color != ''){ ?>
				<div class="footer_top_border_holder <?php echo esc_attr($footer_top_border_in_grid); ?>" <?php mikado_one_mikado_style_attr($footer_top_border_color); ?>></div>
			<?php } ?>
			<div class="footer_top_holder">
				<div class="footer_top<?php if(!$footer_in_grid) {echo " footer_top_full";} ?>">
					<?php if($footer_in_grid){ ?>
					<div class="container">
						<div class="container_inner">
							<?php } ?>
							<?php switch ($footer_top_columns) {
								case 6:
									?>
									<div class="two_columns_50_50 clearfix">
										<div class="mkd_column column1">
											<div class="column_inner">
												<?php dynamic_sidebar( 'footer_column_1' ); ?>
											</div>
										</div>
										<div class="mkd_column column2">
											<div class="column_inner">
												<div class="two_columns_50_50 clearfix">
													<div class="mkd_column column1">
														<div class="column_inner">
															<?php dynamic_sidebar( 'footer_column_2' ); ?>
														</div>
													</div>
													<div class="mkd_column column2">
														<div class="column_inner">
															<?php dynamic_sidebar( 'footer_column_3' ); ?>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
									<?php
									break;
								case 5:
									?>
									<div class="two_columns_50_50 clearfix">
										<div class="mkd_column column1">
											<div class="column_inner">
												<div class="two_columns_50_50 clearfix">
													<div class="mkd_column column1">
														<div class="column_inner">
															<?php dynamic_sidebar( 'footer_column_1' ); ?>
														</div>
													</div>
													<div class="mkd_column column2">
														<div class="column_inner">
															<?php dynamic_sidebar( 'footer_column_2' ); ?>
														</div>
													</div>
												</div>
											</div>
										</div>
										<div class="mkd_column column2">
											<div class="column_inner">
												<?php dynamic_sidebar( 'footer_column_3' ); ?>
											</div>
										</div>
									</div>
									<?php
									break;
								case 4:
									?>
									<div class="four_columns clearfix">
										<div class="mkd_column column1">
											<div class="column_inner">
												<?php dynamic_sidebar( 'footer_column_1' ); ?>
											</div>
										</div>
										<div class="mkd_column column2">
											<div class="column_inner">
												<?php dynamic_sidebar( 'footer_column_2' ); ?>
											</div>
										</div>
										<div class="mkd_column column3">
											<div class="column_inner">
												<?php dynamic_sidebar( 'footer_column_3' ); ?>
											</div>
										</div>
										<div class="mkd_column column4">
											<div class="column_inner">
												<?php dynamic_sidebar( 'footer_column_4' ); ?>
											</div>
										</div>
									</div>
									<?php
									break;
								case 3:
									?>
									<div class="three_columns clearfix">
										<div class="mkd_column column1">
											<div class="column_inner">
												<?php dynamic_sidebar( 'footer_column_1' ); ?>
											</div>
										</div>
										<div class="mkd_column column2">
											<div class="column_inner">
												<?php dynamic_sidebar( 'footer_column_2' ); ?>
											</div>
										</div>
										<div class="mkd_column column3">
											<div class="column_inner">
												<?php dynamic_sidebar( 'footer_column_3' ); ?>
											</div>
										</div>
									</div>
									<?php
									break;
								case 2:
									?>
									<div class="two_columns_50_50 clearfix">
										<div class="mkd_column column1">
											<div class="column_inner">
												<?php dynamic_sidebar( 'footer_column_1' ); ?>
											</div>
										</div>
										<div class="mkd_column column2">
											<div class="column_inner">
												<?php dynamic_sidebar( 'footer_column_2' ); ?>
											</div>
										</div>
									</div>
									<?php
									break;
								case 1:
									dynamic_sidebar( 'footer_column_1' );
									break;
							}
							?>
							<?php if($footer_in_grid){ ?>
						</div>
					</div>
				<?php } ?>
				</div>
                <?php
                if (isset($mkd_options['footer_oblique_section'])  && $mkd_options['footer_oblique_section'] == "yes"){ ?>
                    <svg class="oblique-section svg-footer-bottom" preserveAspectRatio="none" viewBox="0 0 86 86" width="100%" height="86">
                        <?php if($mkd_options['footer_oblique_section_position'] == 'from_left_to_right'){ ?>
                            <polygon points="0,0 0,86 86,86" />
                        <?php }
                        if($mkd_options['footer_oblique_section_position'] == 'from_right_to_left'){ ?>
                            <polygon points="0,86 86,0 86,86" />
                        <?php } ?>
                    </svg>
                <?php } ?>
			</div>
		<?php } ?>
		<?php
		$display_footer_text = false;
		if (isset($mkd_options['footer_text'])) {
			if ($mkd_options['footer_text'] == "yes") $display_footer_text = true;
		}
		$display_footer_bottom = true;
		if ( ! is_active_sidebar( 'footer_bottom_left' ) && ! is_active_sidebar( 'footer_text' ) && ! is_active_sidebar( 'footer_bottom_right' ) ) {
			$display_footer_bottom = false;
		}

		if($display_footer_bottom) {
		if($display_footer_text): ?>
            <?php if($footer_bottom_border_color != ''){ ?>
                <div class="footer_bottom_border_holder <?php echo esc_attr($footer_bottom_border_in_grid); ?>" <?php mikado_one_mikado_style_attr($footer_bottom_border_color); ?>></div>
            <?php } ?>
			<div class="footer_bottom_holder">
                <div class="footer_bottom_holder_inner">
                    <?php if($footer_in_grid){ ?>
                    <div class="container">
                        <div class="container_inner">
                            <?php } ?>

                            <?php switch ($footer_bottom_columns) {
                                case 3:
                                    ?>
                                    <div class="three_columns clearfix">
                                        <div class="mkd_column column1">
                                            <div class="column_inner">
                                                <?php dynamic_sidebar( 'footer_bottom_left' ); ?>
                                            </div>
                                        </div>
                                        <div class="mkd_column column2">
                                            <div class="column_inner">
                                                <?php dynamic_sidebar( 'footer_text' ); ?>
                                            </div>
                                        </div>
                                        <div class="mkd_column column3">
                                            <div class="column_inner">
                                                <?php dynamic_sidebar( 'footer_bottom_right' ); ?>
                                            </div>
                                        </div>
                                    </div>
                                    <?php
                                    break;
                                case 2:
                                    ?>
                                    <div class="two_columns_50_50 clearfix">
                                        <div class="mkd_column column1">
                                            <div class="column_inner">
                                                <?php dynamic_sidebar( 'footer_bottom_left' ); ?>
                                            </div>
                                        </div>
                                        <div class="mkd_column column2">
                                            <div class="column_inner">
                                                <?php dynamic_sidebar( 'footer_bottom_right' ); ?>
                                            </div>
                                        </div>
                                    </div>
                                    <?php
                                    break;
                                case 1:
                                    ?>
                                    <div class="column_inner">
                                        <?php dynamic_sidebar( 'footer_text' ); ?>
                                    </div>
                                    <?php
                                    break;
                            }
                            ?>
                            <?php if($footer_in_grid){ ?>
                        </div>
                    </div>
                <?php } ?>
                </div>
			</div>
            <?php if($footer_bottom_border_bottom_color != ''){ ?>
                <div class="footer_bottom_border_bottom_holder <?php echo esc_attr($footer_top_border_in_grid); ?>" <?php mikado_one_mikado_style_attr($footer_bottom_border_bottom_color); ?>></div>
            <?php } ?>
		<?php endif; ?>
        <?php } ?>
	</div>
</footer>
</div>
</div>
<?php wp_footer(); ?>
</body>
</html>