<?php
$root = dirname(dirname(dirname(dirname(dirname(__FILE__)))));
if ( file_exists( $root.'/wp-load.php' ) ) {
	require_once( $root.'/wp-load.php' );
} elseif ( file_exists( $root.'/wp-config.php' ) ) {
	require_once( $root.'/wp-config.php' );
}
header('Content-type: application/x-javascript');

$mkd_options = mikado_one_mikado_return_global_options();


		?>

		<?php if (!empty($mkd_options['selection_color'])) { ?>
            /* Webkit */
            ::selection {
            background: <?php echo esc_attr($mkd_options['selection_color']);  ?>;
            }
		<?php } ?>
		<?php if (!empty($mkd_options['selection_color'])) { ?>
            /* Gecko/Mozilla */
            ::-moz-selection {
            background: <?php echo esc_attr($mkd_options['selection_color']);  ?>;
            }
		<?php } ?>

		<?php if (!empty($mkd_options['first_color'])) { ?>

            h6, h6 a,h1 a:hover,h2 a:hover,h3 a:hover,h4 a:hover,h5 a:hover,h6 a:hover,a,p a,
            header:not(.with_hover_bg_color) nav.main_menu > ul > li:hover > a,
            nav.main_menu>ul>li.active > a,
            .drop_down .second .inner > ul > li > a:hover,
            .drop_down .second .inner ul li.sub ul li a:hover,
            nav.mobile_menu ul li a:hover,
            nav.mobile_menu ul li.active > a,
            .side_menu_button > a:hover,
            .mobile_menu_button span:hover,
            .vertical_menu ul li a:hover,
            .vertical_menu_toggle .second .inner ul li a:hover,
            nav.popup_menu ul li a:hover,
            nav.popup_menu ul li ul li a,
            .comment_holder .comment .text .comment_date,
            .comment_holder .comment .text .replay,
            .comment_holder .comment .text .comment-reply-link,
            .comment_holder .comment .text .comment-edit-link,
            div.comment_form form p.logged-in-as a,
            .latest_post_holder .latest_post_title a:hover,
            .latest_post_holder.minimal .latest_post_title a,
            .latest_post_holder .post_info_section:before,
            .latest_post_holder .post_info_section span,
            .latest_post_holder .post_info_section a,
            .latest_post_holder .post_author a.post_author_link:hover,
            .projects_holder article .portfolio_title a:hover,
            .projects_masonry_holder article .portfolio_title a:hover,
            .filter_holder ul li.current span,
            .filter_holder ul li:not(.filter_title):hover span,
            .mkd_accordion_holder.accordion .ui-accordion-header .accordion_mark_icon,
            .mkd_accordion_holder.accordion:not(.boxed) .ui-accordion-header.ui-state-active span.tab-title,
            blockquote.with_quote_icon i,
            blockquote h3,
            .mkd_dropcap,
            .price_in_table .value,
            .price_in_table .price,
            .price_in_table .mark,
            .mkd_font_elegant_holder.mkd_icon_shortcode:hover,
            .mkd_icon_shade.mkd_icon_shortcode:hover,
            .mkd_font_awsome_icon_holder.mkd_icon_shortcode:hover,
            .mkd_icon_with_title.normal_icon .icon_holder:hover .icon_text_icon,
            .box_holder_icon_inner.normal_icon .icon_holder_inner:hover .icon_text_icon,
            .mkd_progress_bars_icons_inner.square .bar.active i,
            .mkd_progress_bars_icons_inner.circle .bar.active i,
            .mkd_progress_bars_icons_inner.normal .bar.active i,
            .mkd_progress_bars_icons_inner .bar.active i.fa-circle,
            .mkd_progress_bars_icons_inner.square .bar.active .mkd_font_elegant_icon,
            .mkd_progress_bars_icons_inner.circle .bar.active .mkd_font_elegant_icon,
            .mkd_progress_bars_icons_inner.normal .bar.active .mkd_font_elegant_icon,
            .mkd_social_icon_holder.normal_social .simple_social,
            .mkd_social_icon_holder.normal_social.with_link .simple_social,
            .mkd_list.number ul>li:before,
            .social_share_list_holder ul li i:hover,
            .mkd_progress_bar .progress_number_wrapper.static .progress_number,
            .qbutton:hover,
            .load_more a:hover,
            #submit_comment:hover,
            .drop_down .wide .second ul li .qbutton:hover,
            .drop_down .wide .second ul li ul li .qbutton:hover,
            .post-password-form input[type='submit']:hover,
            nav.content_menu ul li.active:hover i,
            nav.content_menu ul li:hover i,
            nav.content_menu ul li.active:hover a,
            nav.content_menu ul li:hover a,
            aside.sidebar .widget:not(.woocommerce) li,
            .header-widget.widget_nav_menu ul.menu li a:hover,
            input.wpcf7-form-control.wpcf7-submit:not([disabled]):hover,
            .latest_post_holder .post_info_section .latest_post_categories a,
            .latest_post_holder .post_info_section .post_author_link,
            .latest_post_holder.boxes .date,
            .latest_post_holder.image_in_box .date,
            .qbutton.white,
            .qbutton.solid_color:hover,
            .qbutton.top_and_bottom_border,
            .mkd_progress_bars_vertical .progress_number,
            .mkd_counter_holder span.counter,
            .mkd_icon_shortcode span,
            .mkd_icon_shortcode i,
            .mkd_separator_with_icon .mkd_icon_holder .mkd_icon_shade i,
            .mkd_separator_with_icon .mkd_icon_holder .mkd_icon_shade span,
            .mkd_pricing_list .mkd_pricing_item_price span,
            .service_table_inner li.service_icon .service_table_icon,
            .mkd_search_form_3 .mkd_search_close a:hover,
            .mkd_search_form_2 input[type="submit"]:hover,
            .projects_holder article .item_holder.slide_from_left_hover .portfolio_title a,
            .projects_masonry_holder article .item_holder.slide_from_left_hover .portfolio_title a,
            .portfolio_slider li.item .item_holder.slide_from_left_hover .portfolio_title a,
            .projects_holder article .item_holder.image_text_zoom_hover .portfolio_title a,
            .projects_masonry_holder article .item_holder.image_text_zoom_hover .portfolio_title a,
            .portfolio_slider li.item .item_holder.image_text_zoom_hover .portfolio_title a,
            .projects_holder article .item_holder.opposite_corners_hover .portfolio_title a:hover,
            .projects_masonry_holder article .item_holder.opposite_corners_hover .portfolio_title a:hover,
            .portfolio_slider li.item .item_holder.opposite_corners_hover .portfolio_title a:hover,
            .projects_holder article .item_holder.upward_hover .icons_holder a:hover,
            .projects_masonry_holder article .item_holder.upward_hover .icons_holder a:hover,
            .portfolio_slider li.item .item_holder.upward_hover .icons_holder a:hover,
            .projects_holder article .item_holder.image_subtle_rotate_zoom_hover .icons_holder a:hover,
            .projects_masonry_holder article .item_holder.image_subtle_rotate_zoom_hover .icons_holder a:hover,
            .portfolio_slider li.item .item_holder.image_subtle_rotate_zoom_hover .icons_holder a:hover,
            .shopping_cart_dropdown ul li .item_info_holder .item_left a:hover,
            .shopping_cart_header .header_cart i,
            .shopping_cart_header .header_cart:hover i,
            .blog_holder.masonry article .post_text h4 .date,
            .blog_holder.masonry_full_width article .post_text h4 .date,
            .blog_holder.masonry article.sticky .post_text h5 a,
            .blog_holder.masonry_full_width article.sticky .post_text h5 a,
            .blog_holder article .post_text h2 .date,
            .blog_holder article .post_info a,
            .blog_holder article .post_info div a:hover,
            .blog_holder article.format-link .post_text .link_image .post_text_inner .post_title a,
            .blog_holder article.format-quote .post_text .quote_image .post_text_inner .post_title a,
            .comment_holder .comment .text .replay,
            .comment_holder .comment .text .comment-reply-link,
            .comment_holder .comment .text .comment-edit-link,
            .comment_respond_note i,
            div.comment_form form p.logged-in-as a,
            .blog_holder.masonry .post_author:hover,
            .blog_holder.masonry .post_author a:hover,
            .blog_holder.masonry_full_width .post_author:hover,
            .blog_holder.masonry_full_width .post_author a:hover,
            .blog_holder article h2 .date,
            .blog_holder article.format-quote h3 .date,
            .blog_holder article.format-link h3 .date,
            .blog_holder article.sticky h2 a,
            .blog_holder article h2 a:hover,
            .blog_holder article h4 a:hover,
            .mkd_tabs .tabs-nav li.active a,
            .mkd_tabs .tabs-nav li a:hover,
            .comment-list .post_author_comment .post-author-comment-icon {
            color: <?php echo esc_attr($mkd_options['first_color']); ?>;
            }

            .social_share_dropdown ul li:hover a span.social_network_icon,
            .social_share_dropdown ul li:hover,
            .social_share_dropdown ul li a:hover span.social_network_icon,
            .blog_holder article.format-link .post_text.link_image .post_text_inner:hover .post_info .social_share_dropdown ul li:hover span.social_network_icon{
            color: <?php echo esc_attr($mkd_options['first_color']); ?>;
            }

            .title,
            .popup_menu:hover .line,
            .popup_menu:hover .line:after,
            .popup_menu:hover .line:before,
            .blog_holder article.format-link .post_text .post_text_inner:hover,
            .blog_holder article.format-quote .post_text .post_text_inner:hover,
            .mejs-controls .mejs-time-rail .mejs-time-current,
            .mejs-controls .mejs-time-rail .mejs-time-handle,
            .mejs-controls .mejs-horizontal-volume-slider .mejs-horizontal-volume-current,
            .mkd_accordion_holder.accordion.boxed .ui-accordion-header.ui-state-active,
            .mkd_accordion_holder.accordion.boxed .ui-accordion-header.ui-state-hover,
            .mkd_accordion_holder.accordion .ui-accordion-header.ui-state-active .accordion_mark,
            .mkd_accordion_holder.accordion .ui-accordion-header.ui-state-hover .accordion_mark,
            .mkd_dropcap.circle,
            .mkd_dropcap.square,
            .gallery_holder ul li .gallery_hover i,
            .highlight,
            .testimonials_holder.light .flex-direction-nav a:hover,
            .testimonials_holder .flex-control-paging li a.flex-active,
            .mkd_tabs.boxed .tabs-nav li.active a,
            .mkd_tabs.boxed .tabs-nav li a:hover,
            .mkd_message,
            .price_table_inner .price_button a,
            .mkd_price_table.active .active_text,
            .box_holder_icon_inner.circle .icon_holder_inner,
            .box_holder_icon_inner.square .icon_holder_inner,
            .mkd_icon_with_title.circle .mkd_font_elegant_holder.circle,
            .mkd_icon_with_title.square .mkd_font_elegant_holder.square,
            .box_holder_icon_inner .mkd_font_elegant_holder.circle,
            .box_holder_icon_inner .mkd_font_elegant_holder.square,
            .box_holder_icon_inner.circle .icon_holder_inner,
            .mkd_social_icon_holder .fa-stack,
            .footer_top .mkd_social_icon_holder:hover .fa-stack,
            .mkd_list.circle ul>li:before,
            .mkd_list.number.circle_number ul>li:before,
            .mkd_pie_graf_legend ul li .color_holder,
            .mkd_line_graf_legend ul li .color_holder,
            .animated_icon_inner span.animated_icon_back .animated_icon,
            .mkd_progress_bar .progress_content,
            .mkd_progress_bars_vertical .progress_content_outer .progress_content,
            .mkd_progress_bar .progress_number,
            .qbutton,
            .load_more a,
            .blog_load_more_button a,
            #submit_comment,
            .post-password-form input[type='submit'],
            .call_to_action .column2.button_wrapper .qbutton,
            .call_to_action .column2.button_wrapper .qbutton:hover,
            #wp-calendar td#today,
            .mkd_image_gallery_no_space.light .controls a.prev-slide:hover,
            .mkd_image_gallery_no_space.light .controls a.next-slide:hover,
            input.wpcf7-form-control.wpcf7-submit,
            div.wpcf7-response-output.wpcf7-mail-sent-ok,
            .latest_post_holder.post_over_image .date_holder,
            .latest_post_holder.image_with_date .icon_date_holder,
            .qbutton.white:hover,
            .qbutton.solid_color,
            .qbutton.top_and_bottom_border:hover,
            .pagination ul li:hover a,
            .single_links_pages span:hover,
            .comment_pager .page-numbers:hover,
            .blog_holder.blog_post_info_vertical_content article .post_icon_date,
            .projects_holder article .item_holder.upward_hover .text_holder,
            .projects_masonry_holder article .item_holder.upward_hover .text_holder,
            .portfolio_slider li.item .item_holder.upward_hover .text_holder,
            .projects_holder article .item_holder.slide_from_left_hover .icons_holder,
            .projects_masonry_holder article .item_holder.slide_from_left_hover .icons_holder,
            .portfolio_slider li.item .item_holder.slide_from_left_hover .icons_holder,
            .projects_holder article .item_holder.opposite_corners_hover .text_holder .separator,
            .projects_masonry_holder article .item_holder.opposite_corners_hover .text_holder .separator,
            .portfolio_slider li.item .item_holder.opposite_corners_hover .text_holder .separator,
            .projects_holder article .item_holder.opposite_corners_hover .text_holder .separator.animate,
            .projects_masonry_holder article .item_holder.opposite_corners_hover .text_holder .separator.animate,
            .portfolio_slider li.item .item_holder.opposite_corners_hover .text_holder .separator.animate,
            .projects_holder article .item_holder.slide_from_left_hover .text_holder .separator,
            .projects_masonry_holder article .item_holder.slide_from_left_hover .text_holder .separator,
            .portfolio_slider li.item .item_holder.slide_from_left_hover .text_holder .separator,
            .projects_holder article .item_holder.slide_from_left_hover .text_holder .separator.animate,
            .projects_masonry_holder article .item_holder.slide_from_left_hover .text_holder .separator.animate,
            .portfolio_slider li.item .item_holder.slide_from_left_hover .text_holder .separator.animate,
            .projects_holder article .item_holder.subtle_vertical_hover .text_holder .separator,
            .projects_masonry_holder article .item_holder.subtle_vertical_hover .text_holder .separator,
            .portfolio_slider li.item .item_holder.subtle_vertical_hover .text_holder .separator,
            .projects_holder article .item_holder.subtle_vertical_hover .text_holder .separator.animate,
            .projects_masonry_holder article .item_holder.subtle_vertical_hover .text_holder .separator.animate,
            .portfolio_slider li.item .item_holder.subtle_vertical_hover .text_holder .separator.animate,
            .projects_holder article .item_holder.image_text_zoom_hover .text_holder .separator,
            .projects_masonry_holder article .item_holder.image_text_zoom_hover .text_holder .separator,
            .portfolio_slider li.item .item_holder.image_text_zoom_hover .text_holder .separator,
            .projects_holder article .item_holder.image_text_zoom_hover .text_holder .separator.animate,
            .projects_masonry_holder article .item_holder.image_text_zoom_hover .text_holder .separator.animate,
            .portfolio_slider li.item .item_holder.image_text_zoom_hover .text_holder .separator.animate,
            .projects_holder article .item_holder.opposite_corners_hover .icons_holder a,
            .projects_masonry_holder article .item_holder.opposite_corners_hover .icons_holder a,
            .portfolio_slider li.item .item_holder.opposite_corners_hover .icons_holder a,
            .projects_holder article .item_holder.subtle_vertical_hover .icons_holder a,
            .projects_masonry_holder article .item_holder.subtle_vertical_hover .icons_holder a,
            .portfolio_slider li.item .item_holder.subtle_vertical_hover .icons_holder a,
            .projects_holder article .item_holder.image_text_zoom_hover .icons_holder a,
            .projects_masonry_holder article .item_holder.image_text_zoom_hover .icons_holder a,
            .portfolio_slider li.item .item_holder.image_text_zoom_hover .icons_holder a,
            .projects_holder article .item_holder.gradient_hover .icons_holder a:hover,
            .projects_masonry_holder article .item_holder.gradient_hover .icons_holder a:hover,
            .portfolio_slider li.item .item_holder.gradient_hover .icons_holder a:hover,
            .vertical_menu_hidden_button_line,
            .vertical_menu_hidden_button_line:after,.vertical_menu_hidden_button_line:before,
            .popup_menu.opened:hover .line:after,
            .popup_menu.opened:hover .line:before,
            .shopping_cart_header .header_cart_span,
            .shopping_cart_dropdown .cart_bottom .checkout,
            .shopping_cart_dropdown .cart_bottom .view-cart:hover,
            .shopping_cart_dropdown ul li .item_info_holder .item_right .remove:hover,
            .popup_menu.opened:hover .line:before,
            .blog_holder article .post_social .post_comments i,
            .blog_holder article .post_social .blog_like i,
            .blog_holder.blog_post_info_vertical_content article .post_social .social_share_holder > a > i,
            .blog_holder article.format-link .post_text .post_text_inner:hover,
            .blog_holder article.format-quote .post_text .post_text_inner:hover,
            .blog_holder.blog_post_info_vertical_content article .post_icon_date,
            .single_tags  a:hover,
            aside.sidebar .widget .tagcloud a:hover,
            .widget .tagcloud a:hover{
            background-color: <?php echo esc_attr($mkd_options['first_color']); ?>;
            }

			<?php $bg_color = mikado_one_mikado_hex2rgb($mkd_options['first_color']); ?>

            .portfolio_main_holder .item_holder.image_subtle_rotate_zoom_hover .portfolio_shader,
            .portfolio_main_holder .item_holder.prominent_plain_hover .portfolio_shader,
            .portfolio_main_holder .item_holder.slide_up_hover .portfolio_shader,
            .portfolio_main_holder .item_holder.cursor_change_hover .portfolio_shader,
            .latest_post_holder .boxes_image a .latest_post_overlay{
            background-color: rgba(<?php echo esc_attr($bg_color[0]); ?>,<?php echo esc_attr($bg_color[1]); ?>,<?php echo esc_attr($bg_color[2]); ?>,0.7);
            }

            .qbutton.mid_transparent:hover{
            border-color: rgba(<?php echo esc_attr($bg_color[0]); ?>,<?php echo esc_attr($bg_color[1]); ?>,<?php echo esc_attr($bg_color[2]); ?>,0.25);
            background-color: rgba(<?php echo esc_attr($bg_color[0]); ?>,<?php echo esc_attr($bg_color[1]); ?>,<?php echo esc_attr($bg_color[2]); ?>,0.5);
            }
            .mkd_circles_holder .mkd_circle_inner:hover .mkd_circle_inner2,
            .mkd_team_social_holder .mkd_social_icon_holder:hover .fa-stack,
            .mkd_icon_shade.circle:hover,
            .mkd_icon_shade.square:hover,
            #social_icons_widget .mkd_icon_shade.circle:hover,
            #social_icons_widget .mkd_icon_shade.square:hover{
            background-color: <?php echo esc_attr($mkd_options['first_color']); ?> !important;
            }

            #respond textarea:focus,
            #respond input[type='text']:focus,
            .post-password-form input[type='password']:focus,
            .contact_form input[type='text']:focus,
            .contact_form  textarea:focus,
            .mkd_accordion_holder .ui-accordion-header .accordion_mark,
            .testimonials_holder.light .flex-direction-nav a:hover,
            .mkd_progress_bars_icons_inner.circle .bar .bar_noactive,
            .mkd_progress_bars_icons_inner.square .bar .bar_noactive,
            .animated_icon_inner span.animated_icon_back .animated_icon,
            .qbutton,
            .load_more a,
            .blog_load_more_button a,
            #submit_comment,
            .post-password-form input[type='submit'],
            .qbutton:hover,
            .load_more a:hover,
            .blog_load_more_button a:hover,
            #submit_comment:hover,
            .drop_down .wide .second ul li .qbutton:hover,
            .drop_down .wide .second ul li ul li .qbutton:hover,
            .post-password-form input[type='submit']:hover,
            .call_to_action .column2.button_wrapper .qbutton:hover,
            .header-widget.widget_nav_menu ul ul,
            input.wpcf7-form-control.wpcf7-text:focus,
            input.wpcf7-form-control.wpcf7-number:focus,
            input.wpcf7-form-control.wpcf7-date:focus,
            textarea.wpcf7-form-control.wpcf7-textarea:focus,
            select.wpcf7-form-control.wpcf7-select:focus,
            input.wpcf7-form-control.wpcf7-quiz:focus,
            input.wpcf7-form-control.wpcf7-submit,
            input.wpcf7-form-control.wpcf7-submit[disabled],
            input.wpcf7-form-control.wpcf7-submit:not([disabled]),
            input.wpcf7-form-control.wpcf7-submit:not([disabled]):hover,
            .qbutton.white,
            .qbutton.white:hover,
            .qbutton.solid_color,
            .qbutton.solid_color:hover,
            .qbutton.top_and_bottom_border,
            .qbutton.top_and_bottom_border:hover,
            .mkd_counter_holder .separator.medium,
            .mkd_icon_shade.circle,
            .mkd_icon_shade.square,
            .mkd_pricing_border,
            #respond textarea:focus,
            #respond input[type='text']:focus,
            .contact_form input[type='text']:focus,
            .contact_form  textarea:focus,
            .single_tags  a:hover,
            aside.sidebar .widget .tagcloud a:hover,
            .widget .tagcloud a:hover {
            border-color: <?php echo esc_attr($mkd_options['first_color']); ?>;
            }

            .drop_down .second,
            .mkd_progress_bar .progress_number_wrapper.floating .down_arrow{
            border-top-color: <?php echo esc_attr($mkd_options['first_color']); ?>;
            }

            .mkd_circles_holder .mkd_circle_inner:hover .mkd_circle_inner2,
            .mkd_circles_holder .mkd_circle_inner:hover{
            border-color: <?php echo esc_attr($mkd_options['first_color']); ?> !important;
            }

            .mkd_circles_holder .mkd_circle_inner:hover .mkd_circle_inner2{
            background-color: <?php echo esc_attr($mkd_options['first_color']); ?> !important;
            }
			<?php if(function_exists('is_woocommerce')) { ?>
                .woocommerce .myaccount_user a,
                .woocommerce ul.products li.product .added_to_cart,
                .woocommerce .select2-container .select2-choice .select2-arrow .select2-arrow:after ,
                .woocommerce-page .select2-container .select2-choice .select2-arrow:after,
                .woocommerce-checkout .form-row #billing_country_chzn.chzn-container-single .chzn-single div b:before,
                .woocommerce-checkout .form-row #shipping_country_chzn.chzn-container-single .chzn-single div b:before,
                .woocommerce-checkout .form-row .chosen-container-single .chosen-single div b:before,
                .woocommerce-account .form-row .chosen-container-single .chosen-single div b:before,
                .woocommerce-checkout .chosen-container .chosen-results li.active-result.highlighted,
                .woocommerce-account .chosen-container .chosen-results li.active-result.highlighted,
                .woocommerce ul.products li.product span.product-title:hover,
                .woocommerce .quantity input.qty,
                .woocommerce #content .quantity input.qty,
                .woocommerce-page .quantity input.qty,
                .woocommerce-page #content .quantity input.qty,
                .woocommerce .star-rating,
                .woocommerce-page .star-rating,
                .woocommerce div.cart-collaterals div.cart_totals table tr.order-total strong span.amount,
                .woocommerce-page div.cart-collaterals div.cart_totals table tr.order-total strong span.amount,
                .woocommerce div.cart-collaterals div.cart_totals table tr.order-total strong,
                .woocommerce form.checkout table.shop_table tfoot tr.order-total th,
                .woocommerce form.checkout table.shop_table tfoot tr.order-total td span.amount,
                .woocommerce aside ul.product_list_widget li > a:hover,
                aside ul.product-categories li > a:hover,
                .woocommerce aside ul.product_list_widget li span.amount,
                aside ul.product_list_widget li span.amount,
                .woocommerce aside .widget ul.product-categories a:hover,
                aside .widget ul.product-categories a:hover,
                .woocommerce-page aside .widget ul.product-categories a:hover,
                .woocommerce aside.sidebar .woocommerce.widget ul.product-categories ul.children li a:hover,
                aside ul.product-categories ul.children li a:hover,
                .woocommerce-page aside.sidebar .woocommerce.widget ul.product-categories ul.children li a:hover,
                .woocommerce aside.sidebar .woocommerce.widget ul.product-categories  a:hover,
                aside ul.product-categories a:hover,
                .woocommerce-page aside.sidebar .woocommerce.widget ul.product-categories li a:hover,
                .woocommerce .widget_shopping_cart_content .total .amount,
                .woocommerce-page .widget_shopping_cart_content .total .amount,
                .woocommerce .select2-results li.select2-highlighted,
                .woocommerce-page .select2-results li.select2-highlighted,
                .woocommerce .product .woocommerce-product-rating .woocommerce-review-link:hover,
                .shopping_cart_header .header_cart:hover i,
                .shopping_cart_dropdown ul li a:hover,
                .shopping_cart_dropdown span.total span,
                .woocommerce .product .woocommerce-product-rating .woocommerce-review-link:hover,
                .woocommerce .checkout-opener-text a,
                .woocommerce-account .woocommerce-MyAccount-navigation ul li.is-active a,
                .woocommerce-account .woocommerce-MyAccount-navigation ul li a:hover
                {
                color: <?php echo esc_attr($mkd_options['first_color']); ?>;
                }

                .woocommerce .button:hover,
                .woocommerce-page .button:hover,
                .woocommerce button.button:hover,
                .woocommerce-page button.button:hover,
                .woocommerce #submit:hover,
                .woocommerce ul.products li.product a.qbutton:hover,
                .woocommerce-page ul.products li.product a.qbutton:hover,
                .woocommerce ul.products li.product .added_to_cart:hover,
                .woocommerce .product .onsale.out-of-stock-button,
                .woocommerce .widget_price_filter .ui-slider .ui-slider-handle,
                .woocommerce-page .widget_price_filter .ui-slider .ui-slider-handle
                .woocommerce .quantity .minus:hover,
                .woocommerce #content .quantity .minus:hover,
                .woocommerce-page .quantity .minus:hover,
                .woocommerce-page #content .quantity .minus:hover,
                .woocommerce .quantity .plus:hover,
                .woocommerce #content .quantity .plus:hover,
                .woocommerce-page .quantity .plus:hover,
                .woocommerce-page #content .quantity .plus:hover,
                .woocommerce.single-product button.single_add_to_cart_button:hover,
                .woocommerce .product .onsale,
                .woocommerce .product .single-onsale,
                .woocommerce ul.products li.product .add-to-cart-button-inner2 a.button.add_to_cart_button:hover,
                .woocommerce ul.products li.product .add-to-cart-button-inner2 a.added_to_cart:hover,
                .woocommerce-pagination ul.page-numbers li:hover a,
                .woocommerce .widget_shopping_cart_content p.buttons a.button,
                .woocommerce .widget_shopping_cart_content p.buttons a.button:hover,
                .woocommerce .widget_price_filter .button,
                .woocommerce-page .widget_price_filter .button,
                .woocommerce #order_review #payment .button:hover,
                .woocommerce-page #order_review #payment .button:hover,
                .woocommerce .checkout_coupon .coupon .button:hover,
                .woocommerce-page .checkout_coupon .coupon .button:hover,
                .woocommerce .shop_table .coupon .button:hover,
                .woocommerce-page .shop_table .coupon .button:hover,
                .woocommerce .shop_table .button:hover,
                .woocommerce-page .shop_table .button:hover,
                .woocommerce .cart-collaterals .button:hover,
                .woocommerce-page .cart-collaterals .button:hover,
                .woocommerce-pagination ul.page-numbers li>span.dots:hover{
                background-color: <?php echo esc_attr($mkd_options['first_color']); ?>;
                }

                .woocommerce .button,
                .woocommerce-page .button,
                .woocommerce button.button,
                .woocommerce-page button.button,
                .woocommerce-page input[type="submit"],
                .woocommerce input[type="submit"],
                .woocommerce ul.products li.product .added_to_cart,
                .woocommerce.single-product button.single_add_to_cart_button:hover,
                .woocommerce.single-product .mkd_tabs form.comment-form textarea#comment,
                .woocommerce .quantity .minus:hover,
                .woocommerce #content .quantity .minus:hover,
                .woocommerce-page .quantity .minus:hover,
                .woocommerce-page #content .quantity .minus:hover,
                .woocommerce .quantity .plus:hover,
                .woocommerce #content .quantity .plus:hover,
                .woocommerce-page .quantity .plus:hover,
                .woocommerce-page #content .quantity .plus:hover,
                .woocommerce .product_info_box .separator.medium{
                border-color: <?php echo esc_attr($mkd_options['first_color']); ?>;
                }
			<?php } ?>
		<?php } ?>

		<?php if (!empty($mkd_options['spinner_color'])) { ?>
            .ajax_loader .pulse,
            .ajax_loader .double_pulse .double-bounce1, .ajax_loader .double_pulse .double-bounce2,
            .ajax_loader .cube,
            .ajax_loader .rotating_cubes .cube1, .ajax_loader .rotating_cubes .cube2,
            .ajax_loader .stripes > div,
            .ajax_loader .wave > div,
            .ajax_loader .two_rotating_circles .dot1, .ajax_loader .two_rotating_circles .dot2,
            .ajax_loader .five_rotating_circles .container1 > div, .ajax_loader .five_rotating_circles .container2 > div, .ajax_loader .five_rotating_circles .container3 > div{
            background-color: <?php echo esc_attr($mkd_options['spinner_color']); ?>;
            }
		<?php } ?>
		<?php if (!empty($mkd_options['background_color']) || !empty($mkd_options['text_color']) || !empty($mkd_options['text_fontsize']) || !empty($mkd_options['text_fontweight']) || $mkd_options['google_fonts'] != "-1") { ?>
            body{
			<?php if($mkd_options['google_fonts'] != "-1"){ ?>
				<?php $font = str_replace('+', ' ', $mkd_options['google_fonts']); ?>
                font-family: '<?php echo esc_attr($font); ?>', sans-serif;
			<?php } ?>
			<?php if (!empty($mkd_options['text_color'])) { ?> color: <?php echo esc_attr($mkd_options['text_color']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['text_fontsize'])) { ?> font-size: <?php echo esc_attr($mkd_options['text_fontsize']); ?>px; <?php } ?>
			<?php if (!empty($mkd_options['text_fontweight'])) { ?>font-weight: <?php echo esc_attr($mkd_options['text_fontweight']);  ?>;<?php } ?>
            }
			<?php if (!empty($mkd_options['background_color'])) { ?>
                body,
                .wrapper,
                .content,
                .full_width,
                .content .container,
                .more_facts_holder,
                ul.mkd_pricing_list_holder.with_leaders .mkd_pricing_item_text,
                ul.mkd_pricing_list_holder.with_leaders .mkd_pricing_item_price{
                background-color:<?php echo esc_attr($mkd_options['background_color']);  ?>;
                }
                .oblique-section polygon{
                fill: <?php echo esc_attr($mkd_options['background_color']);?>;
                }
			<?php } ?>
		<?php } ?>


		<?php if (isset($mkd_options['enable_title_oblique']) && ($mkd_options['enable_title_oblique']=='yes') && isset($mkd_options['title_oblique_section_color']) && !empty($mkd_options['title_oblique_section_color'])) { ?>
            .oblique-section.svg-title-bottom polygon{
            fill: <?php echo esc_attr($mkd_options['title_oblique_section_color']);?>;
            }
		<?php } ?>


		<?php if($mkd_options['google_fonts'] != "-1"){ ?>
            h3, h6, .pagination ul li.active span, .single_links_pages span, .comment_pager .page-numbers, .pagination ul li > a.inactive, .subtitle, .blog_holder article .post_info, .comment_holder .comment .text .comment_date, .blog_holder.masonry .post_author, .blog_holder.masonry .post_author a, .blog_holder.masonry_full_width .post_author, .blog_holder.masonry_full_width .post_author a, .latest_post_holder .post_info_section span, .latest_post_holder .post_info_section a, .latest_post_holder .post_author, .latest_post_holder a.post_author_link, .projects_holder article .project_category, .portfolio_slides .project_category, .projects_masonry_holder .project_category, .testimonials .testimonial_text_inner p:not(.testimonial_author), .price_in_table .mark, body div.pp_default .pp_description, .side_menu .widget li,aside.sidebar .widget:not(.woocommerce) li, aside .widget #lang_sel ul li a, aside .widget #lang_sel_click ul li a, section.side_menu #lang_sel ul li a, section.side_menu #lang_sel_click ul li a, footer #lang_sel ul li a, footer #lang_sel_click ul li a, .header_top #lang_sel ul li a, .header_top #lang_sel_click ul li a, .header_bottom #lang_sel ul li a, .header_bottom #lang_sel_click > ul > li a {
			<?php $font = str_replace('+', ' ',$mkd_options['google_fonts']); ?>
            font-family: '<?php echo esc_attr($font); ?>', sans-serif;
            }
			<?php if(function_exists('is_woocommerce')) { ?>
                .woocommerce ul.products li.product span.product-categories a,.woocommerce div.product div.product_meta > span, .woocommerce-page ul.products li.product span.product-categories a, .woocommerce ul.products li.product .price, .woocommerce-page ul.products li.product .price, .woocommerce aside ul.product_list_widget li span.amount, aside ul.product_list_widget li span.amount, .woocommerce .product .onsale.out-of-stock-button, .woocommerce-pagination ul.page-numbers li span.current, .woocommerce-pagination ul.page-numbers li a, .woocommerce div.product .summary p.price span.amount, .woocommerce .quantity input.qty, .woocommerce #content .quantity input.qty, .woocommerce-page .quantity input.qty, .woocommerce-page #content .quantity input.qty, .woocommerce div.product div.product_meta > span span, .woocommerce div.product div.product_meta > span a, .woocommerce aside.sidebar .woocommerce.widget ul.product-categories ul.children li a, aside ul.product-categories ul.children li a, .woocommerce-page aside.sidebar .woocommerce.widget ul.product-categories ul.children li a, .shopping_cart_header .header_cart span{
				<?php $font = str_replace('+', ' ', $mkd_options['google_fonts']); ?>
                font-family: '<?php echo esc_attr($font); ?>', sans-serif;
                }
			<?php } ?>
		<?php } ?>
		<?php if (!empty($mkd_options['background_color_box'])) { ?>
            .wrapper{
			<?php if (!empty($mkd_options['background_color_box'])) { ?> background-color:<?php echo esc_attr($mkd_options['background_color_box']);  ?>; <?php } ?>
            }
		<?php } ?>
		<?php
		$boxed = "no";
		if (isset($mkd_options['boxed']) && isset($mkd_options['transparent_content']) && $mkd_options['transparent_content'] == 'no')
			$boxed = esc_attr($mkd_options['boxed']);
		?>
		<?php if($boxed == "yes"){ ?>
            body.boxed,
            body.boxed .wrapper{
			<?php if (!empty($mkd_options['background_color_box'])) { ?> background-color:<?php echo esc_attr($mkd_options['background_color_box']);  ?>; <?php } ?>

			<?php if($mkd_options['pattern_background_image'] != ""){  ?>
                background-image: url('<?php echo esc_url($mkd_options['pattern_background_image']) ?>');
                background-position: 0px 0px;
                background-repeat: repeat;
			<?php } ?>

			<?php if($mkd_options['background_image'] != ""){  ?>
                background-image: url('<?php echo esc_url($mkd_options['background_image']) ?>');
                background-attachment: fixed;
                background-position: center 0px;
                background-repeat: no-repeat;
			<?php } ?>
            }
            body.boxed .content{
			<?php if (!empty($mkd_options['background_color'])) { ?> background-color:<?php echo esc_attr($mkd_options['background_color']);  ?>; <?php } ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['transparent_content']) && $mkd_options['transparent_content'] == 'yes'){ ?>
            .transparent_content{
			<?php if(isset($mkd_options['transparent_content_background_color']) && $mkd_options['transparent_content_background_color'] !== ''){ ?>
                background-color: <?php echo esc_attr($mkd_options['transparent_content_background_color']); ?>;
			<?php } ?>

			<?php if(isset($mkd_options['transparent_content_background_image']) && $mkd_options['transparent_content_background_image'] !== ''){ ?>
                background-image: url('<?php echo esc_url($mkd_options['transparent_content_background_image']) ?>');
                background-attachment: fixed;
                background-position: center 0px;
                background-repeat: no-repeat;
			<?php } ?>

			<?php if(isset($mkd_options['transparent_content_pattern_background_image']) && $mkd_options['transparent_content_pattern_background_image'] !== ''){ ?>
                background-image: url('<?php echo esc_url($mkd_options['transparent_content_pattern_background_image']) ?>');
                background-position: 0px 0px;
                background-repeat: repeat;
			<?php } ?>

            }

            .wrapper,
            .content,
            .full_width,
            .content .container,
            .more_facts_holder,
            ul.mkd_pricing_list_holder.with_leaders .mkd_pricing_item_text,
            ul.mkd_pricing_list_holder.with_leaders .mkd_pricing_item_price,
            .container_inner.default_template_holder,
            .paspartu_outer,
            .paspartu_left,
            .paspartu_right,
            .paspartu_bottom,
            .paspartu_outer .mkd_slider,
            .paspartu_outer .content:not(.has_slider) .content_inner{
            background-color: transparent !important;
            }

		<?php } ?>

		<?php if (!empty($mkd_options['highlight_color'])) { ?>
            span.highlight {
            background-color: <?php echo esc_attr($mkd_options['highlight_color']);  ?>;
            }
		<?php } ?>

		<?php if (!empty($mkd_options['header_background_color']) || $mkd_options['header_background_transparency_initial'] != "") {
			if(!empty($mkd_options['header_background_color'])){
				$bg_color = mikado_one_mikado_hex2rgb($mkd_options['header_background_color']);
			}else{
				$bg_color = mikado_one_mikado_hex2rgb('#ffffff');
			}
			if ($mkd_options['header_background_transparency_initial'] != "") {
				$bg_color_transparency = $mkd_options['header_background_transparency_initial'];
			}else{
				$bg_color_transparency = 1;
			}
			?>
            .header_bottom,
            .header_top {
            background-color: rgba(<?php echo esc_attr($bg_color[0]); ?>,<?php echo esc_attr($bg_color[1]); ?>,<?php echo esc_attr($bg_color[2]); ?>,<?php echo esc_attr($bg_color_transparency); ?>);
            }

			<?php if(isset($bg_color_transparency) && $bg_color_transparency == 0) { ?>

                .header_bottom,
                .header_top {
                border-bottom: 0;
                }

                .header_bottom {
                box-shadow: none;
                }

                .header_top .right .inner > div:first-child,
                .header_top .right .inner > div,
                .header_top .left .inner > div:last-child,
                .header_top .left .inner > div {
                border: none;
                }

			<?php } ?>

		<?php } ?>

		<?php if (isset($mkd_options['background_color_grid']) && !empty($mkd_options['background_color_grid'])) { ?>
            .container_inner.default_template_holder{
            background-color:<?php echo esc_attr($mkd_options['background_color_grid']);  ?>;
            }
		<?php } ?>



		<?php if(isset($mkd_options['content_grid_position']) && ($mkd_options['content_grid_position'])=="left") { ?>
            @media only screen and (min-width: 1000px){
            .container_inner{
            margin-left:0px;
            }
            }
		<?php } ?>

		<?php if(isset($mkd_options['content_grid_position']) && ($mkd_options['content_grid_position'])=="right") { ?>
            @media only screen and (min-width: 1000px){
            .container_inner{
            margin-right:0px;
            }
            }
		<?php } ?>




		<?php if (!empty($mkd_options['header_separator_color'])) { ?>
            .drop_down .wide .second ul li{
            border-color:<?php echo esc_attr($mkd_options['header_separator_color']);  ?>;
            }
		<?php } ?>

		<?php if (isset($mkd_options['content_top_padding']) && $mkd_options['content_top_padding'] !== '') { ?>
            .content .content_inner > .container > .container_inner,
            .content .content_inner > .full_width > .full_width_inner{
            padding-top: <?php echo esc_attr($mkd_options['content_top_padding']); ?>px;
            }
		<?php } ?>

		<?php if (isset($mkd_options['content_top_padding_default_template']) && $mkd_options['content_top_padding_default_template'] !== '') { ?>
            .content .content_inner > .container > .container_inner.default_template_holder{
            padding-top: <?php echo esc_attr($mkd_options['content_top_padding_default_template']); ?>px;
            }
		<?php } ?>

		<?php if (isset($mkd_options['content_top_padding_mobile']) && $mkd_options['content_top_padding_mobile'] !== '') { ?>
            @media only screen and (max-width: 1000px){
            .content .content_inner > .container > .container_inner,
            .content .content_inner > .full_width > .full_width_inner,
            .content .content_inner > .container > .container_inner.default_template_holder{
            padding-top: <?php echo esc_attr($mkd_options['content_top_padding_mobile']); ?>px !important;
            }
            }
		<?php } ?>


		<?php if ((isset($mkd_options['border_bottom_title_area']) && $mkd_options['border_bottom_title_area'] == "yes") && (!empty($mkd_options['border_bottom_title_area_color']) || !empty($mkd_options['border_bottom_title_area_width'])) ) { ?>
            .title{
            border-bottom-style:solid;
            border-bottom-color:<?php echo esc_attr($mkd_options['border_bottom_title_area_color']); ?>;
            border-bottom-width:<?php echo esc_attr($mkd_options['border_bottom_title_area_width']); ?>px;
            }
		<?php } ?>


		<?php if(isset($mkd_options['header_left_right_padding']) && $mkd_options['header_left_right_padding'] !== ""){?>
            @media only screen and (min-width: 1000px){
            .header_bottom{
            padding: 0 <?php echo esc_attr($mkd_options['header_left_right_padding']); ?>px;
            }
            header .header_inner_left{
            left: <?php echo esc_attr($mkd_options['header_left_right_padding']); ?>px;
            }
            }
		<?php } ?>

		<?php if( isset($mkd_options['header_bottom_appearance']) && $mkd_options['header_bottom_appearance']=="fixed_hiding" && isset($mkd_options['menu_background_color']) && !empty($mkd_options['menu_background_color'])){?>
            @media only screen and (min-width: 1000px){
            header:not(.sticky):not(.scrolled) .holeder_for_hidden_menu{
            background-color: <?php echo esc_attr($mkd_options['menu_background_color']); ?>;
            }
            }
		<?php } ?>

		<?php if( isset($mkd_options['header_bottom_appearance']) && $mkd_options['header_bottom_appearance']=="fixed_hiding" && isset($mkd_options['enable_menu_top_bottom_border']) && $mkd_options['enable_menu_top_bottom_border']=='yes' && isset($mkd_options['color_menu_top_bottom_border']) && !empty($mkd_options['color_menu_top_bottom_border'])){?>
            @media only screen and (min-width: 1000px){
            header:not(.sticky):not(.scrolled) .holeder_for_hidden_menu{
            border-bottom-width: 1px;
            border-top-width: 1px;
            border-style: solid;
            border-color: <?php echo esc_attr($mkd_options['color_menu_top_bottom_border']); ?>;
            }
            }
		<?php } ?>

		<?php if( isset($mkd_options['header_bottom_appearance']) && $mkd_options['header_bottom_appearance']=="stick menu_bottom" && isset($mkd_options['menu_background_color']) && !empty($mkd_options['menu_background_color'])){?>
            @media only screen and (min-width: 1000px){
            header:not(.sticky):not(.scrolled) .header_menu_bottom {
            background-color: <?php echo esc_attr($mkd_options['menu_background_color']); ?>;
            }
            }
		<?php } ?>

		<?php if( isset($mkd_options['header_bottom_appearance']) && $mkd_options['header_bottom_appearance']=="stick menu_bottom" && isset($mkd_options['enable_menu_top_bottom_border']) && $mkd_options['enable_menu_top_bottom_border']=='yes' && isset($mkd_options['color_menu_top_bottom_border']) && !empty($mkd_options['color_menu_top_bottom_border'])){?>
            @media only screen and (min-width: 1000px){
            header:not(.sticky):not(.scrolled) .header_menu_bottom {
            border-bottom-width: 1px;
            border-top-width: 1px;
            border-style: solid;
            border-color: <?php echo esc_attr($mkd_options['color_menu_top_bottom_border']); ?>;

            }
            }
		<?php } ?>

		<?php
		if (!empty($mkd_options['header_background_color_scroll']) || $mkd_options['header_background_transparency_scroll'] != "") {

			if(!empty($mkd_options['header_background_color_scroll'])){
				$bg_color_scroll = mikado_one_mikado_hex2rgb($mkd_options['header_background_color_scroll']);
			}else{
				$bg_color_scroll = mikado_one_mikado_hex2rgb('#ffffff');
			}

			if ($mkd_options['header_background_transparency_scroll'] != "") {
				$bg_color_scroll_transparency = $mkd_options['header_background_transparency_scroll'];
			}else{
				$bg_color_scroll_transparency = 1;
			}
			?>
            header.fixed.scrolled .header_bottom,
            header.fixed.scrolled .header_top,
            header.fixed_hiding.scrolled .header_bottom,
            header.fixed_hiding.scrolled .header_top{
            background-color: rgba(<?php echo esc_attr($bg_color_scroll[0]); ?>,<?php echo esc_attr($bg_color_scroll[1]); ?>,<?php echo esc_attr($bg_color_scroll[2]); ?>,<?php echo esc_attr($bg_color_scroll_transparency); ?>) !important;
            }
		<?php } ?>

		<?php if($mkd_options['header_background_transparency_scroll'] != "" && $mkd_options['header_background_transparency_scroll'] == 0) { ?>

            header.scrolled .header_bottom,
            header.scrolled .header_top {
            border-bottom: 0;
            }

            header.scrolled .header_bottom {
            box-shadow: none;
            }

            header.scrolled .header_top .right .inner > div:first-child,
            header.scrolled .header_top .right .inner > div,
            header.scrolled .header_top .left .inner > div:last-child,
            header.scrolled .header_top .left .inner > div {
            border: none;
            }
		<?php } ?>



		<?php
		if (!empty($mkd_options['header_background_color_sticky']) || $mkd_options['header_background_transparency_sticky'] != "") {

			if(!empty($mkd_options['header_background_color_sticky'])){
				$bg_color_sticky = mikado_one_mikado_hex2rgb($mkd_options['header_background_color_sticky']);
			}else{
				$bg_color_sticky = mikado_one_mikado_hex2rgb('#ffffff');
			}

			if ($mkd_options['header_background_transparency_sticky'] != "") {
				$bg_color_sticky_transparency = $mkd_options['header_background_transparency_sticky'];
			}else{
				$bg_color_sticky_transparency = 1;
			}
			?>
            header.sticky .header_bottom{
            background-color: rgba(<?php echo esc_attr($bg_color_sticky[0]); ?>,<?php echo esc_attr($bg_color_sticky[1]); ?>,<?php echo esc_attr($bg_color_sticky[2]); ?>,<?php echo esc_attr($bg_color_sticky_transparency); ?>) !important;
            }
		<?php } ?>

		<?php if (!empty($mkd_options['header_top_background_color']) || $mkd_options['header_background_transparency_initial'] != "") {
			if(!empty($mkd_options['header_top_background_color'])) {
				$bg_color_top = mikado_one_mikado_hex2rgb($mkd_options['header_top_background_color']);
			} else {
				$bg_color_top = mikado_one_mikado_hex2rgb('#fff');
			}

			if ($mkd_options['header_background_transparency_initial'] != "") {
				$bg_color_transparency = $mkd_options['header_background_transparency_initial'];
			} else{
				$bg_color_transparency = 1;
			}
			?>

            .header_top{
            background-color: rgba(<?php echo esc_attr($bg_color_top[0]); ?>,<?php echo esc_attr($bg_color_top[1]); ?>,<?php echo esc_attr($bg_color_top[2]); ?>,<?php echo esc_attr($bg_color_transparency); ?>);
            }
		<?php } ?>

		<?php if (isset($mkd_options['header_bottom_border_width']) && $mkd_options['header_bottom_border_width'] !== "" && ($mkd_options['enable_header_bottom_border']=='yes')) {?>

			<?php
			if (isset($mkd_options['header_botom_border_transparency']) && $mkd_options['header_botom_border_transparency'] !== "") {
				$header_border_transparency = mikado_one_mikado_hex2rgb($mkd_options['header_bottom_border_color']);

				if(isset($mkd_options['header_botom_border_in_grid']) && $mkd_options['header_botom_border_in_grid'] == "yes"){ ?>
                    header .header_bottom .container_inner{
                    border-color: rgba(<?php echo esc_attr($header_border_transparency[0]); ?>,<?php echo esc_attr($header_border_transparency[1]); ?>,<?php echo esc_attr($header_border_transparency[2]); ?>,<?php echo esc_attr($mkd_options['header_botom_border_transparency']); ?>);
                    border-style:solid;
                    border-bottom-width: <?php echo esc_attr($mkd_options['header_bottom_border_width']); ?>px;
                    }
				<?php } else { ?>
                    header .header_bottom{
                    border-color: rgba(<?php echo esc_attr($header_border_transparency[0]); ?>,<?php echo esc_attr($header_border_transparency[1]); ?>,<?php echo esc_attr($header_border_transparency[2]); ?>,<?php echo esc_attr($mkd_options['header_botom_border_transparency']); ?>);
                    border-style:solid;
                    border-bottom-width: <?php echo esc_attr($mkd_options['header_bottom_border_width']); ?>px;
                    }
				<?php }
			} else {
				if(isset($mkd_options['header_botom_border_in_grid']) && $mkd_options['header_botom_border_in_grid'] == "yes"){ ?>
                    header .header_bottom .container_inner{
                    border-color:<?php echo esc_attr($mkd_options['header_bottom_border_color']); ?>;
                    border-style:solid;
                    border-bottom-width: <?php echo esc_attr($mkd_options['header_bottom_border_width']); ?>px;
                    }
				<?php } else { ?>
                    header .header_bottom{
                    border-color: <?php echo esc_attr($mkd_options['header_bottom_border_color']); ?>;
                    border-style:solid;
                    border-bottom-width: <?php echo esc_attr($mkd_options['header_bottom_border_width']); ?>px;
                    }
				<?php }
			}
		}?>

		<?php if (isset($mkd_options['enable_header_top_border']) && ($mkd_options['enable_header_top_border']=='yes') && isset($mkd_options['header_top_border_width']) && ($mkd_options['header_top_border_width']!=='')) { ?>
            header .header_top_bottom_holder{
            border-style:solid;
            border-top-width: <?php echo esc_attr($mkd_options['header_top_border_width']); ?>px;
			<?php if (isset($mkd_options['header_top_border_transparency']) && ($mkd_options['header_top_border_transparency']!=='')) {
				$header_border_transparency = mikado_one_mikado_hex2rgb($mkd_options['header_top_border_color']);?>
                border-color: rgba(<?php echo esc_attr($header_border_transparency[0]); ?>,<?php echo esc_attr($header_border_transparency[1]); ?>,<?php echo esc_attr($header_border_transparency[2]); ?>,<?php echo esc_attr($mkd_options['header_top_border_transparency']); ?>);
			<?php } else { ?>
                border-color:  <?php echo esc_attr($mkd_options['header_top_border_color']); ?>;
			<?php } ?>
            }
		<?php }?>

		<?php
		if (!empty($mkd_options['header_top_background_color']) || $mkd_options['header_background_transparency_scroll'] != "") {

			if(!empty($mkd_options['header_top_background_color'])){
				$bg_color_scroll_top = mikado_one_mikado_hex2rgb($mkd_options['header_top_background_color']);
			}else{
				$bg_color_scroll_top = mikado_one_mikado_hex2rgb('#000000');
			}

			if ($mkd_options['header_background_transparency_scroll'] != "") {
				$bg_color_scroll_transparency = $mkd_options['header_background_transparency_scroll'];
			}else{
				$bg_color_scroll_transparency = 0.7;
			}
			?>
            header.sticky .header_top{
            background-color: rgba(<?php echo esc_attr($bg_color_scroll_top[0]); ?>,<?php echo esc_attr($bg_color_scroll_top[1]); ?>,<?php echo esc_attr($bg_color_scroll_top[2]); ?>,<?php echo esc_attr($bg_color_scroll_transparency); ?>);
            }
		<?php } ?>

		<?php
		$header_bottom_appearance = "fixed";
		if (isset($mkd_options['header_bottom_appearance'])) {
			$header_bottom_appearance = $mkd_options['header_bottom_appearance'];
		}
		?>

		<?php

		$header_top_border=0;
		$header_bottom_border=0;
		if(isset($mkd_options['enable_header_top_border']) && $mkd_options['enable_header_top_border']=='yes' && isset($mkd_options['header_top_border_width']) && $mkd_options['header_top_border_width']!==''){
			$header_top_border = $mkd_options['header_top_border_width'];
		}
		if(isset($mkd_options['enable_header_bottom_border']) && $mkd_options['enable_header_bottom_border']=='yes' && isset($mkd_options['header_bottom_border_width']) && $mkd_options['header_bottom_border_width']!==''){
			$header_bottom_border = $mkd_options['header_bottom_border_width'];
		}

		$large_menu_item_border=0;
		if(isset($mkd_options['enable_manu_item_border']) && $mkd_options['enable_manu_item_border']=='yes' && isset($mkd_options['menu_item_style']) && $mkd_options['menu_item_style']=='large_item'){
			if(isset($mkd_options['menu_item_border_style']) && $mkd_options['menu_item_border_style']=='all_borders'){
				$large_menu_item_border = $mkd_options['menu_item_border_width']*2;
			}
			if(isset($mkd_options['menu_item_border_style']) && $mkd_options['menu_item_border_style']=='top_bottom_borders'){
				$large_menu_item_border = $mkd_options['menu_item_border_width']*2;
			}
			if(isset($mkd_options['menu_item_border_style']) && $mkd_options['menu_item_border_style']=='bottom_border'){
				$large_menu_item_border = $mkd_options['menu_item_border_width'];
			}

		}

		$header_centered_logo_border = 0;
		if(isset($mkd_options['center_logo_image']) && $mkd_options['center_logo_image'] == "yes" && isset($mkd_options['enable_border_top_bottom_menu']) && $mkd_options['enable_border_top_bottom_menu'] == "yes"){
			$header_centered_logo_border = 2;
		}


		$display_header_top = "yes";
		if(isset($mkd_options['header_top_area'])){
			$display_header_top = esc_attr($mkd_options['header_top_area']);
		}
		if (!empty($_SESSION['mkd_cayman_header_top'])){
			$display_header_top = $_SESSION['mkd_cayman_header_top'];
		}

		if($display_header_top == "no"){
			$margin_top_add = 0;
		}else{
			$margin_top_add = 36;
		}

		$logo_width = $mkd_options['logo_width'];
		$logo_height = $mkd_options['logo_height'];

		if (!empty($mkd_options['header_height']) && $header_bottom_appearance != "fixed_hiding") {
			$header_height = $mkd_options['header_height'];
		} elseif($header_bottom_appearance == "fixed_hiding"){
			$header_height = 90 + $logo_height/2 + 20; // 20 is top and bottom margin of logo
		} elseif(isset($mkd_options['center_logo_image']) && $mkd_options['center_logo_image'] == "yes" && $header_bottom_appearance == "fixed") {
			if($header_bottom_appearance == "fixed" && $logo_height > 90){
				$header_height = 90 + 90 + 20; //20 is top and bottom margin of logo, 90 is default header height, other 90 is logo height
			}
			if($header_bottom_appearance == "fixed" && $logo_height < 90){
				$header_height = 90 + $logo_height + 20; //20 is top and bottom margin of logo, 90 is default header height
			}
		} else {
			$header_height = 90;
		}
		if($header_bottom_appearance == "stick menu_bottom") {
			$menu_bottom = 60; // border 1px
			if ($mkd_options['center_logo_image'] == "yes") {
				if(is_active_sidebar('header_fixed_right')){
					$menu_bottom = $menu_bottom + 26; // 26 is for right widget in header bottom (line height of text)
				}
			}
		} else {
			$menu_bottom = 0;
		}
		$header_height = $header_height + $menu_bottom + $header_top_border + $header_bottom_border + $header_centered_logo_border + $large_menu_item_border;

		?>

		<?php if ($header_bottom_appearance != "fixed" && $header_bottom_appearance != "fixed_hiding" && $header_bottom_appearance != "regular") {?>
			<?php if ($mkd_options['center_logo_image'] != "yes") { ?>
                .content{
                margin-top: <?php echo esc_attr('-'.intval(($margin_top_add + $header_height))); ?>px);
                }
                .content_wrapper{
                margin-top: <?php echo esc_attr(($margin_top_add) + ($header_height)); ?>px;
                }
			<?php } else {
				?>
				<?php if($header_bottom_appearance == "stick menu_bottom") { ?>
                    .content{
                    margin-top: <?php echo esc_attr('-'.intval((20 + $logo_height/2 + $menu_bottom + $margin_top_add + $header_top_border + $header_bottom_border + $header_centered_logo_border + $large_menu_item_border)));?>px);
                    }
                    .content_wrapper{
                    margin-top: <?php echo esc_attr(20 + $logo_height/2 + $menu_bottom + $margin_top_add + $header_top_border + $header_bottom_border + $header_centered_logo_border + $large_menu_item_border); // 20 is top margin of centered logo ?>px;
                    }
				<?php } elseif($header_bottom_appearance == "stick_with_left_right_menu"){ ?>
                    .content{
                    margin-top: <?php echo esc_attr('-'.intval(($header_height + $margin_top_add))); ?>px);
                    }
                    .content_wrapper{
                    margin-top: <?php echo esc_attr($header_height + $margin_top_add); ?>px;
                    }
				<?php }  else { ?>
                    .content{
                    margin-top: <?php echo esc_attr('-'.intval((20 + $logo_height/2 + $header_height + $margin_top_add))); // 20 is top margin of centered logo ?>px);
                    }
                    .content_wrapper{
                    margin-top: <?php echo esc_attr(20 + $logo_height/2 + $header_height + $margin_top_add); // 20 is top margin of centered logo ?>px;
                    }
				<?php } ?>
			<?php } ?>
		<?php } else { ?>

			<?php if ($header_bottom_appearance == "regular") {
				//only if regular header type and there is slider on the page
				?>
				<?php if ($mkd_options['center_logo_image'] != "yes") { ?>
                    .content.has_slider{
                    margin-top: <?php echo esc_attr('-'.intval(($margin_top_add + $header_height))); ?>px);
                    }
                    .content_wrapper{
                    margin-top: <?php echo esc_attr($margin_top_add + $header_height); ?>px;
                    }
				<?php } else{ ?>
					<?php if($header_height - $logo_height < 0){
						$logo_height = $header_height;
					} ?>

                    .content.has_slider{
                    margin-top: <?php echo esc_attr('-'.intval((20 + $logo_height/2 + $margin_top_add + $header_height))); // 20 is top margin of centered logo ?>px);
                    }
                    .content_wrapper{
                    margin-top: <?php echo esc_attr(20 + $logo_height/2 + $margin_top_add + $header_height); // 20 is top margin of centered logo ?>px;
                    }
				<?php } ?>
			<?php } ?>
            .content{
            margin-top: 0;
            }

		<?php } ?>

        @media only screen and (max-width: 1000px){
        .content_wrapper{
        margin-top: <?php echo esc_attr($margin_top_add) + esc_attr($mkd_options['header_height_mobile']); ?>px;
        }
        }

		<?php
		$search_text_styles = array();

		if(isset($mkd_options['search_text_google_fonts']) && $mkd_options['search_text_google_fonts'] !== '-1') {
			$search_text_styles[] = 'font-family: '.str_replace('+', ' ', $mkd_options['search_text_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['search_text_fontsize']) && $mkd_options['search_text_fontsize'] !== '') {
			$search_text_styles[] = 'font-size: '.intval($mkd_options['search_text_fontsize']).'px !important';
		}

		if(isset($mkd_options['search_text_letterspacing']) && $mkd_options['search_text_letterspacing'] !== '') {
			$search_text_styles[] = 'letter-spacing: '.intval($mkd_options['search_text_letterspacing']).'px';
		}

		if(isset($mkd_options['search_text_fontweight']) && $mkd_options['search_text_fontweight'] !== '') {
			$search_text_styles[] = 'font-weight: '.intval($mkd_options['search_text_fontweight']);
		}

		if(isset($mkd_options['search_text_fontstyle']) && $mkd_options['search_text_fontstyle'] !== '') {
			$search_text_styles[] = 'font-style: '.$mkd_options['search_text_fontstyle'];
		}

		if(isset($mkd_options['search_text_texttransform']) && $mkd_options['search_text_texttransform'] !== '') {
			$search_text_styles[] = 'text-transform: '.intval($mkd_options['search_text_texttransform']);
		}

		if(isset($mkd_options['search_text_color']) && $mkd_options['search_text_color'] !== '') {
			$search_text_styles[] = 'color: '.$mkd_options['search_text_color'];
		}
		?>
		<?php if(is_array($search_text_styles) && count($search_text_styles)) { ?>
            .mkd_search_form_2 input[type="text"],
            .mkd_search_form_2 input[type="text"]:focus,
            .mkd_search_form_3 input[type="text"],
            .mkd_search_form_3 input[type="text"]:focus{
			<?php echo esc_attr(implode(';', $search_text_styles)); ?>
            }
		<?php }  ?>

		<?php if(isset($mkd_options['search_text_disabled_color']) && !empty($mkd_options['search_text_disabled_color'])){ ?>
            .mkd_search_form_2 input[type="text"]::-webkit-input-placeholder,
            .mkd_search_form_3 input[type="text"]::-webkit-input-placeholder{
            color: <?php echo esc_attr($mkd_options['search_text_disabled_color']); ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['search_text_disabled_color']) && !empty($mkd_options['search_text_disabled_color'])){ ?>
            .mkd_search_form_2 input[type="text"]:-moz-placeholder,
            .mkd_search_form_3 input[type="text"]:-moz-placeholder{
            color: <?php echo esc_attr($mkd_options['search_text_disabled_color']); ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['search_text_disabled_color']) && !empty($mkd_options['search_text_disabled_color'])){ ?>
            .mkd_search_form_2 input[type="text"]::-moz-placeholder,
            .mkd_search_form_3 input[type="text"]::-moz-placeholder{
            color: <?php echo esc_attr($mkd_options['search_text_disabled_color']); ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['search_background_color']) && !empty($mkd_options['search_background_color'])){ ?>
            .mkd_search_form_2,
            .mkd_search_form_2 input[type="text"],
            .mkd_search_form_3,
            .mkd_search_form_3 input[type="text"]{
			<?php if(!empty($mkd_options['search_background_color'])){ ?>background-color: <?php echo esc_attr($mkd_options['search_background_color']); ?>; <?php } ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['search_icon_color']) && !empty($mkd_options['search_icon_color'])){ ?>
            .mkd_search_form_2 input[type="submit"],
            .mkd_search_form_3 .mkd_search_close a{
            color: <?php echo esc_attr($mkd_options['search_icon_color']); ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['search_icon_hover_color']) && !empty($mkd_options['search_icon_hover_color'])){ ?>
            .mkd_search_form_2 input[type="submit"]:hover,
            .mkd_search_form_3 .mkd_search_close a:hover{
            color: <?php echo esc_attr($mkd_options['search_icon_hover_color']); ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['search_icon_disabled_color']) && !empty($mkd_options['search_icon_disabled_color'])){ ?>
            .mkd_search_form_2.disabled input[type="submit"],
            .mkd_search_form_2.disabled input[type="submit"]:hover{
            color: <?php echo esc_attr($mkd_options['search_icon_disabled_color']); ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['search_icon_size']) && ($mkd_options['search_icon_size'])!==''){ ?>
			<?php $margin_top= -$mkd_options['search_icon_size']/2?>
            .mkd_search_form_2 input[type="submit"],
            .mkd_search_form_3 .mkd_search_close{
            font-size: <?php echo esc_attr($mkd_options['search_icon_size']); ?>px;
            margin-top: <?php echo esc_attr($margin_top);?>px;
            }
		<?php } ?>

		<?php if(isset($mkd_options['search_height']) && ($mkd_options['search_height'])!==''){ ?>
            .mkd_search_form_2 .form_holder_outer,
            .mkd_search_form_2.animated .form_holder_outer,
            .mkd_search_form_2{
            height: <?php echo esc_attr($mkd_options['search_height']); ?>px;
            }
		<?php } ?>

		<?php if (!(isset($mkd_options['header_height'])) || ($mkd_options['header_height'])=='') { ?>
            .logo_wrapper,
            .side_menu_button,
            .shopping_cart_inner{
            height: <?php echo esc_attr(90 + $large_menu_item_border); ?>px;
            }
		<?php } ?>

		<?php if ((isset($mkd_options['header_bottom_appearance'])) && ($mkd_options['header_bottom_appearance'])=='stick menu_bottom') { ?>
            .menu_bottom .side_menu_button,
            .menu_bottom .shopping_cart_inner{
            height: <?php echo esc_attr(60 + $large_menu_item_border); ?>px!important;
            }
		<?php } ?>

		<?php if (isset($mkd_options['header_height']) && ($mkd_options['header_height'])!=='') { ?>

            .logo_wrapper,
            .side_menu_button,
            .shopping_cart_inner{
            height: <?php echo esc_attr($mkd_options['header_height']) + $large_menu_item_border;  ?>px;
            }

			<?php if($header_bottom_appearance == "fixed_hiding") {
				$header_height_scroll_hidden_margin = $logo_height/2 + 20;
				if(isset($mkd_options['header_height_scroll_hidden']) && $mkd_options['header_height_scroll_hidden'] != "" && ($logo_height/2 + 20) < $mkd_options['header_height_scroll_hidden']){
					$header_height_scroll_hidden_margin = esc_attr($mkd_options['header_height_scroll_hidden']) + 20; //20 is top + bottom margin
				}
				?>
                .content.content_top_margin{
                margin-top: <?php echo esc_attr($mkd_options['header_height']) + $margin_top_add + $header_height_scroll_hidden_margin + $header_top_border + $header_bottom_border + $header_centered_logo_border + $large_menu_item_border; // 20 is top and bottom margin of logo ?>px !important;
                }
			<?php } elseif($header_bottom_appearance == "fixed" && $mkd_options['center_logo_image'] == "yes"){
				?>

                .content.content_top_margin{
				<?php if ($mkd_options['header_height'] > $logo_height) {?>
                    margin-top: <?php echo esc_attr($mkd_options['header_height']) + $margin_top_add + $logo_height + 20 + $header_top_border + $header_bottom_border + $header_centered_logo_border + $large_menu_item_border; // 20 is top margin of logo ?>px !important;
				<?php } else { ?>
                    margin-top: <?php echo esc_attr($mkd_options['header_height'])*2 + $margin_top_add + 20 + $header_top_border + $header_bottom_border + $header_centered_logo_border + $large_menu_item_border; // 20 is top margin of logo ?>px !important;
				<?php } ?>
                }
			<?php } else { ?>
                .content.content_top_margin{
                margin-top: <?php echo esc_attr($mkd_options['header_height']) + $margin_top_add + $header_top_border + $header_bottom_border + $header_centered_logo_border + $large_menu_item_border;  ?>px !important;
                }
			<?php } ?>

            header:not(.centered_logo) .header_fixed_right_area {
            line-height: <?php echo esc_attr($mkd_options['header_height']);  ?>px;
            }

            .vertical_menu_enabled .content.content_top_margin {
            margin-top: 0px !important;
            }

		<?php } else { ?>
            .content.content_top_margin{
            margin-top: <?php echo esc_attr($header_height + $margin_top_add); ?>px !important;
            }

            .vertical_menu_enabled .content.content_top_margin{
            margin-top: 0px !important;
            }
		<?php } ?>



		<?php if (!empty($mkd_options['header_height_scroll'])) { ?>
            header.scrolled .logo_wrapper,
            header.scrolled .side_menu_button{
            height: <?php echo esc_attr($mkd_options['header_height_scroll']);  ?>px;
            }

            header.scrolled nav.main_menu ul li a {
            line-height: <?php echo esc_attr($mkd_options['header_height_scroll']);  ?>px;
            }

            header.scrolled .drop_down .second{
            top: <?php echo esc_attr($mkd_options['header_height_scroll']);  ?>px;
            }
		<?php } ?>

		<?php if (!empty($mkd_options['header_height_sticky'])) { ?>
            header.sticky .logo_wrapper,
            header.sticky.centered_logo .logo_wrapper,
            header.sticky .side_menu_button,
            header.sticky .shopping_cart_inner
            {
            height: <?php echo esc_attr($mkd_options['header_height_sticky']) + $large_menu_item_border;  ?>px !important;
            }

            header.sticky nav.main_menu > ul > li > a,
            .light.sticky nav.main_menu > ul > li > a,
            .light.sticky nav.main_menu > ul > li > a:hover,
            .light.sticky nav.main_menu > ul > li.active > a,
            .dark.sticky nav.main_menu > ul > li > a,
            .dark.sticky nav.main_menu > ul > li > a:hover,
            .dark.sticky nav.main_menu > ul > li.active > a {
            line-height: <?php echo esc_attr($mkd_options['header_height_sticky']);  ?>px;
            }

            header.sticky .drop_down .second{
            top: <?php echo esc_attr($mkd_options['header_height_sticky']) + $large_menu_item_border;?>px;
            }
		<?php } ?>

		<?php if (!(isset($mkd_options['header_height_sticky'])) || ($mkd_options['header_height_sticky'])=='') { ?>
            header.sticky .logo_wrapper,
            header.sticky .side_menu_button,
            header.sticky .shopping_cart_inner{
            height: <?php echo esc_attr(60 + $large_menu_item_border);  ?>px !important;
            }
		<?php } ?>

		<?php if (isset($mkd_options['disable_text_shadow_for_sticky']) && $mkd_options['disable_text_shadow_for_sticky'] == "yes") { ?>
            header.sticky .header_bottom,
            header.fixed.scrolled .header_bottom,
            header.fixed_hiding.scrolled .header_bottom{
            box-shadow: none;
            -webkit-box-shadow: none;
            }
		<?php } ?>

		<?php if(isset($mkd_options['header_height_scroll_hidden']) && $mkd_options['header_height_scroll_hidden'] !== "") { ?>
            @media only screen and (min-width: 1000px){
            header.fixed_hiding.centered_logo.fixed_hiding .header_inner_left,
            header.fixed_hiding .mkd_logo_hidden a{
            height: <?php echo esc_attr($mkd_options['header_height_scroll_hidden']);  ?>px;
            }
            }

            header.scrolled nav.main_menu ul li a {
            line-height: <?php echo esc_attr($mkd_options['header_height_scroll_hidden']);  ?>px;
            }

            header.scrolled .drop_down .second{
            top: <?php echo esc_attr($mkd_options['header_height_scroll_hidden']) + $large_menu_item_border;  ?>px;
            }

            header.fixed_hiding.scrolled:hover .holeder_for_hidden_menu{
            max-height: <?php echo esc_attr($mkd_options['header_height_scroll_hidden']) + $large_menu_item_border; ?>px;
            }

            header.fixed_hiding.scrolled:hover .holeder_for_hidden_menu .side_menu_button,
            header.fixed_hiding.scrolled:hover .holeder_for_hidden_menu .shopping_cart_inner{
            height: <?php echo esc_attr($mkd_options['header_height_scroll_hidden']) + $large_menu_item_border;  ?>px !important;
            }
		<?php } ?>

		<?php if(isset($mkd_options['dropdown_top_position']) && $mkd_options['dropdown_top_position'] !== '') { ?>
            header:not(.sticky):not(.scrolled) .drop_down .second {
            top: <?php echo esc_attr($mkd_options['dropdown_top_position']).'%;'; ?>
            }
		<?php } ?>


		<?php if(isset($mkd_options['header_height_mobile']) && $mkd_options['header_height_mobile'] !== "") { ?>
            @media only screen and (max-width: 1000px){
            .mobile_menu_button,
            .logo_wrapper,
            .side_menu_button,
            .shopping_cart_inner,
            header.menu_bottom.has_header_fixed_right .side_menu_button,
            .mkd_logo a{
            height: <?php echo esc_attr($mkd_options['header_height_mobile']); ?>px !important;
            }
            }
		<?php } ?>

		<?php if(isset($mkd_options['logo_image'])){
			?>
            @media only screen and (min-width: 1000px){
            header.fixed_hiding .mkd_logo a,
            header.fixed_hiding .mkd_logo{
            max-height: <?php echo esc_attr($logo_height/2); ?>px;
            }
            }
			<?php
		} ?>

		<?php if(isset($mkd_options['header_height']) && $mkd_options['header_height'] != ''){
			?>
            @media only screen and (min-width: 1000px){
            header.fixed_hiding .holeder_for_hidden_menu{
            max-height: <?php echo esc_attr($mkd_options['header_height']) + $large_menu_item_border; ?>px;
            }
            }
			<?php
		} ?>

		<?php if((isset($mkd_options['color_border_top_bottom_menu']) && $mkd_options['color_border_top_bottom_menu'] != "")){ ?>
            header.centered_logo .main_menu_and_widget_holder{
            border-color: <?php echo esc_attr($mkd_options['color_border_top_bottom_menu']); ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['logo_mobile_header_height']) && !empty($mkd_options['logo_mobile_header_height'])){ ?>
            @media only screen and (max-width: 1000px){
            .mkd_logo a{
            height: <?php echo esc_attr($mkd_options['logo_mobile_header_height']); ?>px !important;
            }
            }
		<?php } ?>

		<?php if(isset($mkd_options['logo_mobile_height']) && !empty($mkd_options['logo_mobile_height'])){?>
            @media only screen and (max-width: 480px){
            .mkd_logo a{
            height: <?php echo esc_attr($mkd_options['logo_mobile_height']);?>px !important;
            }
            }
		<?php } ?>

		<?php
		$parallax_onoff = "on";
		if (isset($mkd_options['parallax_onoff']))
			$parallax_onoff = esc_attr($mkd_options['parallax_onoff']);
		if ($parallax_onoff == "off"){
			?>
            .touch section.parallax_section_holder{
            height: auto !important;
            min-height: 300px;
            background-position: center top !important;
            background-attachment: scroll;
            background-size: cover;
            }
		<?php } ?>
		<?php if (!empty($mkd_options['header_height'])) { ?>
            nav.main_menu > ul > li > a{
            line-height: <?php echo esc_attr($mkd_options['header_height']);  ?>px;
            }
		<?php } ?>

		<?php
		if((isset($mkd_options['dropdown_background_color']) && $mkd_options['dropdown_background_color'] != "") ||
		   (isset($mkd_options['dropdown_background_transparency'])) && $mkd_options['dropdown_background_transparency'] != "") {

			//dropdown background and transparency styles
			$dropdown_bg_styles                 = '';
			$dropdown_bg_color                  = '';
			$dropdown_bg_color_initial          = '#ffffff';
			$dropdown_bg_transparency           = '';
			$dropdown_bg_transparency_initial   = 1;

			$dropdown_bg_color        = $mkd_options['dropdown_background_color'] != "" ? $mkd_options['dropdown_background_color'] : $dropdown_bg_color_initial;
			$dropdown_bg_transparency = $mkd_options['dropdown_background_transparency'] != "" ? $mkd_options['dropdown_background_transparency'] : $dropdown_bg_transparency_initial;

			$dropdown_bg_color_rgb    = mikado_one_mikado_hex2rgb($dropdown_bg_color);

			?>

            .drop_down .second .inner ul,
            .drop_down .second .inner ul li ul,
            .shopping_cart_dropdown,
            li.narrow .second .inner ul,
            .header_top #lang_sel ul ul,
            .header_top #lang_sel_click ul ul,
            .header_bottom #lang_sel ul ul,
            .header_bottom #lang_sel_click  ul ul,
            .header-widget.widget_nav_menu ul ul {
            background-color: <?php echo esc_attr($dropdown_bg_color);  ?>;
            background-color: rgba(<?php echo esc_attr($dropdown_bg_color_rgb[0]); ?>,<?php echo esc_attr($dropdown_bg_color_rgb[1]); ?>,<?php echo esc_attr($dropdown_bg_color_rgb[2]); ?>,<?php echo esc_attr($dropdown_bg_transparency); ?>);
            }

		<?php  } //end dropdown background and transparency styles ?>



		<?php if(isset($mkd_options['dropdown_top_separator_color']) && !empty($mkd_options['dropdown_top_separator_color'])){?>
            .drop_down .second{
            border-top-color: <?php echo esc_attr($mkd_options['dropdown_top_separator_color']); ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['dropdown_top_padding']) && ($mkd_options['dropdown_top_padding'])!==''){?>
            li.narrow .second .inner ul{
            padding-top: <?php echo esc_attr($mkd_options['dropdown_top_padding']); ?>px;
            }
            .drop_down .narrow .second .inner ul li ul{
            top:-<?php echo esc_attr($mkd_options['dropdown_top_padding']); ?>px;
            }
		<?php } ?>
		<?php if(isset($mkd_options['dropdown_bottom_padding']) && ($mkd_options['dropdown_bottom_padding'])!==''){?>
            li.narrow .second .inner ul{
            padding-bottom: <?php echo esc_attr($mkd_options['dropdown_bottom_padding']); ?>px;
            }
		<?php } ?>


		<?php if(!empty($mkd_options['enable_dropdown_top_separator']) && $mkd_options['enable_dropdown_top_separator'] == "no"){?>
            .drop_down .second{
            border-top: 0 !important;
            }
		<?php } ?>



		<?php
		$dropdown_separator_full_width = 'no';
		if(!empty($mkd_options['enable_dropdown_separator_full_width']) && $mkd_options['enable_dropdown_separator_full_width'] == "yes"){
			$dropdown_separator_full_width = esc_attr($mkd_options['enable_dropdown_separator_full_width']);
		}
		if(!empty($mkd_options['dropdown_separator_color']) && $dropdown_separator_full_width != 'yes'){?>
            .drop_down .second .inner ul li a,
            .header-widget.widget_nav_menu ul.menu li ul li a {
            border-color: <?php echo esc_attr($mkd_options['dropdown_separator_color']); ?>;
            }
		<?php } ?>
		<?php
		if(!empty($mkd_options['dropdown_separator_color']) && $dropdown_separator_full_width == 'yes'){?>
            .drop_down .second .inner ul li,
            .header-widget.widget_nav_menu ul.menu li ul li{
            border-bottom: 1px solid <?php echo esc_attr($mkd_options['dropdown_separator_color']); ?>;
            }
		<?php } ?>

		<?php if (!empty($mkd_options['menu_lineheight'])) { ?>
            nav.main_menu > ul > li > a > span.item_inner{
			<?php if (!empty($mkd_options['menu_lineheight'])) { ?> line-height: <?php echo esc_attr($mkd_options['menu_lineheight']);  ?>px; <?php } ?>
            }
		<?php }?>

		<?php if (!empty($mkd_options['menu_color']) || !empty($mkd_options['menu_fontsize']) || !empty($mkd_options['menu_fontstyle']) || !empty($mkd_options['menu_fontweight']) || !empty($mkd_options['menu_texttransform']) || (isset($mkd_options['menu_letter_spacing']) && $mkd_options['menu_letter_spacing'] !== '') || $mkd_options['menu_google_fonts'] != "-1") { ?>
            nav.main_menu > ul > li > a{
			<?php if (!empty($mkd_options['menu_color'])) { ?> color: <?php echo esc_attr($mkd_options['menu_color']);  ?>; <?php } ?>
			<?php if($mkd_options['menu_google_fonts'] != "-1"){ ?>
                font-family: '<?php echo esc_attr(str_replace('+', ' ', $mkd_options['menu_google_fonts'])); ?>', sans-serif;
			<?php } ?>
			<?php if (!empty($mkd_options['menu_fontsize'])) { ?> font-size: <?php echo esc_attr($mkd_options['menu_fontsize']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['menu_fontstyle'])) { ?> font-style: <?php echo esc_attr($mkd_options['menu_fontstyle']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['menu_fontweight'])) { ?> font-weight: <?php echo esc_attr($mkd_options['menu_fontweight']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['menu_texttransform'])) { ?> text-transform: <?php echo esc_attr($mkd_options['menu_texttransform']);  ?>;  <?php } ?>
			<?php if ($mkd_options['menu_letterspacing'] !== '') { ?> letter-spacing: <?php echo esc_attr($mkd_options['menu_letterspacing']);  ?>px; <?php } ?>
            }
		<?php }?>

		<?php if (!empty($mkd_options['menu_color']) || !empty($mkd_options['menu_fontsize']) || !empty($mkd_options['menu_fontstyle']) || !empty($mkd_options['menu_fontweight']) || !empty($mkd_options['menu_texttransform']) || (isset($mkd_options['menu_letter_spacing']) && $mkd_options['menu_letter_spacing'] !== '') || $mkd_options['menu_google_fonts'] != "-1") { ?>
            .header_bottom #lang_sel > ul > li > a,
            .header_bottom #lang_sel_click > ul > li > a,
            .header_bottom #lang_sel ul > li:hover > a{
			<?php if (!empty($mkd_options['menu_color'])) { ?> color: <?php echo esc_attr($mkd_options['menu_color']);  ?> !important; <?php } ?>
			<?php if($mkd_options['menu_google_fonts'] != "-1"){ ?>
                font-family: '<?php echo esc_attr(str_replace('+', ' ', $mkd_options['menu_google_fonts'])); ?>', sans-serif;
			<?php } ?>
			<?php if (!empty($mkd_options['menu_fontsize'])) { ?> font-size: <?php echo esc_attr($mkd_options['menu_fontsize']);  ?>px !important; <?php } ?>
			<?php if (!empty($mkd_options['menu_fontstyle'])) { ?> font-style: <?php echo esc_attr($mkd_options['menu_fontstyle']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['menu_fontweight'])) { ?> font-weight: <?php echo esc_attr($mkd_options['menu_fontweight']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['menu_texttransform'])) { ?> text-transform: <?php echo esc_attr($mkd_options['menu_texttransform']);  ?>;  <?php } ?>
			<?php if ($mkd_options['menu_letterspacing'] !== '') { ?> letter-spacing: <?php echo esc_attr($mkd_options['menu_letterspacing']);  ?>px; <?php } ?>
            }
		<?php }?>


		<?php if($mkd_options['menu_google_fonts'] != "-1"){ ?>
            .header_bottom #lang_sel_list{
            font-family: '<?php echo esc_attr(str_replace('+', ' ', $mkd_options['menu_google_fonts'])); ?>', sans-serif !important;
            }
		<?php } ?>


		<?php if(!empty($mkd_options['menu_item_style']) && $mkd_options['menu_item_style']=='small_item'){ ?>
            nav.main_menu > ul > li > a > span.item_inner{
			<?php if (!empty($mkd_options['menu_text_background_color'])) { ?> background-color: <?php echo esc_attr($mkd_options['menu_text_background_color']);  ?>; <?php } ?>

			<?php if($mkd_options['enable_manu_item_border']=='yes' ){?>
				<?php if(isset($mkd_options['menu_item_border_radius']) && ($mkd_options['menu_item_border_radius'])!==''){?>border-radius: <?php echo esc_attr($mkd_options['menu_item_border_radius']); ?>px;<?php } ?>
				<?php if (isset($mkd_options['menu_item_border_width']) && $mkd_options['menu_item_border_width'] !== '') { ?> border-width: <?php echo esc_attr($mkd_options['menu_item_border_width']);  ?>px; <?php } ?>
				<?php if (!empty($mkd_options['menu_item_border_color']) ) { ?> border-color: <?php echo esc_attr($mkd_options['menu_item_border_color']);  ?>; <?php } ?>

				<?php if(!empty($mkd_options['menu_item_border_style'])){ ?>

					<?php if (($mkd_options['menu_item_border_style']=='top_bottom_borders')){?>
                        border-left: none;
                        border-right: none;
					<?php } ?>

					<?php if (($mkd_options['menu_item_border_style']=='right_border')) { ?>
                        border-left: none;
                        border-top: none;
                        border-bottom: none;
					<?php } ?>

					<?php if (($mkd_options['menu_item_border_style']=='bottom_border')) { ?>
                        border-left: none;
                        border-top: none;
                        border-right: none;
					<?php } ?>

				<?php } ?>
			<?php } ?>
            }
		<?php } ?>

		<?php if (!empty($mkd_options['menu_item_border_style']) && ($mkd_options['menu_item_border_style']=='right_border')) { ?>
            nav.main_menu > ul > li:last-child > a > span.item_inner{
            border-right: none;
            }
            nav.main_menu > ul > li:last-child > a{
            border-right: none;
            }

		<?php } ?>



		<?php if(!empty($mkd_options['menu_item_style']) && $mkd_options['menu_item_style']=='small_item' && $mkd_options['enable_manu_item_border']=='yes' && !empty($mkd_options['menu_item_border_color'])){ ?>
            .light:not(.sticky):not(.scrolled) nav.main_menu > ul > li > a > span.item_inner{
            border-color: #fff;
            }
            .dark:not(.sticky):not(.scrolled) nav.main_menu > ul > li > a > span.item_inner{
            border-color: #000;
            }
		<?php } ?>



		<?php if(!empty($mkd_options['menu_item_style']) && $mkd_options['menu_item_style']=='small_item' && $mkd_options['enable_manu_item_border']=='yes' && !empty($mkd_options['menu_item_hover_border_color'])){ ?>
            .light:not(.sticky):not(.scrolled) nav.main_menu > ul > li:hover > a > span.item_inner{
            border-color: #fff;
            }
            .dark:not(.sticky):not(.scrolled) nav.main_menu > ul > li:hover > a > span.item_inner{
            border-color: #000;
            }
		<?php } ?>


		<?php if(!empty($mkd_options['menu_item_style']) && $mkd_options['menu_item_style']=='small_item' && $mkd_options['enable_manu_item_border']=='yes' && !empty($mkd_options['menu_item_active_border_color'])){ ?>
            .light:not(.sticky):not(.scrolled) nav.main_menu > ul > li.active > a > span.item_inner{
            border-color: #fff;
            }
            .dark:not(.sticky):not(.scrolled) nav.main_menu > ul > li.active > a > span.item_inner{
            border-color: #000;
            }
		<?php } ?>


		<?php if(isset($mkd_options['enable_menu_item_text_decoration']) && ($mkd_options['enable_menu_item_text_decoration']=='yes')) { ?>

			<?php if (isset($mkd_options['menu_item_text_decoration_style']) &&  $mkd_options['menu_item_text_decoration_style']=='none'){ ?>
                nav.main_menu > ul > li:hover > a > span.item_inner,
                nav.main_menu > ul > li.active:hover > a > span.item_inner{
                text-decoration: none;
                }
			<?php }  ?>
			<?php if(isset($mkd_options['menu_item_text_decoration_style']) &&  $mkd_options['menu_item_text_decoration_style']=='underline'){ ?>
                nav.main_menu > ul > li:hover > a > span.item_inner,
                nav.main_menu > ul > li.active:hover > a > span.item_inner{
                text-decoration: underline;
                }
			<?php } ?>
			<?php if(isset($mkd_options['menu_item_text_decoration_style']) &&  $mkd_options['menu_item_text_decoration_style']=='line-through'){ ?>
                nav.main_menu > ul > li:hover > a > span.item_inner,
                nav.main_menu > ul > li.active:hover > a > span.item_inner{
                text-decoration: line-through;
                }
			<?php } ?>
			<?php if(isset($mkd_options['menu_item_text_decoration_style']) &&  $mkd_options['menu_item_text_decoration_style']=='overline'){ ?>
                nav.main_menu > ul > li:hover > a > span.item_inner,
                nav.main_menu > ul > li.active:hover > a > span.item_inner{
                text-decoration: overline;
                }
			<?php } ?>


			<?php if (isset($mkd_options['menu_item_active_text_decoration_style']) &&  $mkd_options['menu_item_active_text_decoration_style']=='none'){ ?>
                nav.main_menu > ul > li.active > a > span.item_inner{
                text-decoration: none;
                }
			<?php }  ?>
			<?php if(isset($mkd_options['menu_item_active_text_decoration_style']) &&  $mkd_options['menu_item_active_text_decoration_style']=='underline'){ ?>
                nav.main_menu > ul > li.active > a > span.item_inner{
                text-decoration: underline;
                }
			<?php } ?>
			<?php if(isset($mkd_options['menu_item_active_text_decoration_style']) &&  $mkd_options['menu_item_active_text_decoration_style']=='line-through'){ ?>
                nav.main_menu > ul > li.active > a > span.item_inner{
                text-decoration: line-through;
                }
			<?php } ?>
			<?php if(isset($mkd_options['menu_item_active_text_decoration_style']) &&  $mkd_options['menu_item_active_text_decoration_style']=='overline'){ ?>
                nav.main_menu > ul > li.active > a > span.item_inner{
                text-decoration: overline;
                }
			<?php } ?>

		<?php } ?>



		<?php if(isset($mkd_options['header_style']) && $mkd_options['header_style']=='light' && !empty($mkd_options['menu_item_style']) && $mkd_options['menu_item_style']=='large_item' && $mkd_options['enable_manu_item_border']=='yes' && !empty($mkd_options['menu_item_border_color'])){ ?>
            .light:not(.sticky):not(.scrolled) nav.main_menu > ul > li > a{
            border-color: #fff;
            }
		<?php } ?>

		<?php if(isset($mkd_options['header_style']) && $mkd_options['header_style']=='dark' && !empty($mkd_options['menu_item_style']) && $mkd_options['menu_item_style']=='large_item' && $mkd_options['enable_manu_item_border']=='yes' && !empty($mkd_options['menu_item_border_color'])){ ?>
            .dark:not(.sticky):not(.scrolled) nav.main_menu > ul > li > a{
            border-color: #000;
            }
		<?php } ?>

		<?php if(isset($mkd_options['header_style']) && $mkd_options['header_style']=='light' && !empty($mkd_options['menu_item_style']) && $mkd_options['menu_item_style']=='large_item' && $mkd_options['enable_manu_item_border']=='yes' && !empty($mkd_options['menu_item_hover_border_color'])){ ?>
            .light:not(.sticky):not(.scrolled) nav.main_menu > ul > li:hover > a{
            border-color: #fff;
            }
		<?php } ?>
		<?php if(isset($mkd_options['header_style']) && $mkd_options['header_style']=='dark' && !empty($mkd_options['menu_item_style']) && $mkd_options['menu_item_style']=='large_item' && $mkd_options['enable_manu_item_border']=='yes' && !empty($mkd_options['menu_item_hover_border_color'])){ ?>
            .dark:not(.sticky):not(.scrolled) nav.main_menu > ul > li:hover > a{
            border-color: #000;
            }
		<?php } ?>

		<?php if(isset($mkd_options['header_style']) && $mkd_options['header_style']=='light' && !empty($mkd_options['menu_item_style']) && $mkd_options['menu_item_style']=='large_item' && $mkd_options['enable_manu_item_border']=='yes' && !empty($mkd_options['menu_item_active_border_color'])){ ?>
            .light:not(.sticky):not(.scrolled) nav.main_menu > ul > li.active > a{
            border-color: #fff;
            }
		<?php } ?>
		<?php if(isset($mkd_options['header_style']) && $mkd_options['header_style']=='dark' && !empty($mkd_options['menu_item_style']) && $mkd_options['menu_item_style']=='large_item' && $mkd_options['enable_manu_item_border']=='yes' && !empty($mkd_options['menu_item_active_border_color'])){ ?>
            .dark:not(.sticky):not(.scrolled) nav.main_menu > ul > li.active > a{
            border-color: #000;
            }
		<?php } ?>





		<?php if(!empty($mkd_options['menu_item_style']) && $mkd_options['menu_item_style']=='large_item'){ ?>
            nav.main_menu > ul > li > a{
			<?php if (!empty($mkd_options['menu_text_background_color'])) { ?> background-color: <?php echo esc_attr($mkd_options['menu_text_background_color']);  ?>; <?php } ?>

			<?php if($mkd_options['enable_manu_item_border']=='yes' ){?>
				<?php if(isset($mkd_options['menu_item_border_radius']) && ($mkd_options['menu_item_border_radius'])!==''){?>border-radius: <?php echo esc_attr($mkd_options['menu_item_border_radius']); ?>px;<?php } ?>
				<?php if (isset($mkd_options['menu_item_border_width']) && $mkd_options['menu_item_border_width'] !== '') { ?> border-width: <?php echo esc_attr($mkd_options['menu_item_border_width']);  ?>px; <?php } ?>
				<?php if (!empty($mkd_options['menu_item_border_color']) ) { ?> border-color: <?php echo esc_attr($mkd_options['menu_item_border_color']);  ?>; <?php } ?>

				<?php if(!empty($mkd_options['menu_item_border_style'])){ ?>

					<?php if (($mkd_options['menu_item_border_style']=='top_bottom_borders')){?>
                        border-left: none;
                        border-right: none;
					<?php } ?>

					<?php if (($mkd_options['menu_item_border_style']=='right_border')) { ?>
                        border-left: none;
                        border-top: none;
                        border-bottom: none;
					<?php } ?>
					<?php if (($mkd_options['menu_item_border_style']=='bottom_border')) { ?>
                        border-left: none;
                        border-top: none;
                        border-right: none;
					<?php } ?>

				<?php } ?>
			<?php } ?>
            }
		<?php } ?>

		<?php if(!empty($mkd_options['menu_item_border_style']) && $mkd_options['menu_item_border_style']=='bottom_border_double' && !empty($mkd_options['menu_item_style']) && $mkd_options['menu_item_style']=='small_item' && $mkd_options['enable_manu_item_border']=='yes' && !empty($mkd_options['menu_item_border_style']) && !empty($mkd_options['menu_item_border_color'])){ ?>
            nav.main_menu >ul > li > a > span.item_inner:before,
            nav.main_menu >ul > li > a > span.item_inner:after{
			<?php if (!empty($mkd_options['menu_item_border_color'])) { ?> background-color: <?php echo esc_attr($mkd_options['menu_item_border_color']);  ?>; <?php } ?>
            display:block;
            }
            nav.main_menu >ul > li > a > span.item_inner,
            nav.main_menu >ul > li > a > span.item_inner{
            border:none;
            }
		<?php } ?>


		<?php if(!empty($mkd_options['menu_item_border_style']) && $mkd_options['menu_item_border_style']=='bottom_border_double' && !empty($mkd_options['menu_item_style']) && $mkd_options['menu_item_style']=='large_item' && $mkd_options['enable_manu_item_border']=='yes' && !empty($mkd_options['menu_item_border_style']) && !empty($mkd_options['menu_item_border_color'])){ ?>
            nav.main_menu >ul > li > a:before,
            nav.main_menu >ul > li > a:after{
			<?php if (!empty($mkd_options['menu_item_border_color'])) { ?> background-color: <?php echo esc_attr($mkd_options['menu_item_border_color']);  ?>; <?php } ?>
            display:block;
            }
            nav.main_menu >ul > li > a,
            nav.main_menu >ul > li > a{
            border:none;
            }
		<?php } ?>

		<?php if(!empty($mkd_options['menu_item_border_style']) && $mkd_options['menu_item_border_style']=='bottom_border_double' && !empty($mkd_options['menu_item_style']) && $mkd_options['menu_item_style']=='small_item' && $mkd_options['enable_manu_item_border']=='yes' && !empty($mkd_options['menu_item_border_style']) && !empty($mkd_options['menu_item_active_border_color'])){ ?>
            nav.main_menu >ul > li.active > a > span.item_inner:before,
            nav.main_menu >ul > li.active > a > span.item_inner:after{
			<?php if (!empty($mkd_options['menu_item_active_border_color'])) { ?> background-color: <?php echo esc_attr($mkd_options['menu_item_active_border_color']);  ?>; <?php } ?>
            }
            nav.main_menu >ul > li.active > a > span.item_inner,
            nav.main_menu >ul > li.active > a > span.item_inner{
            border:none;
            }
		<?php } ?>


		<?php if(!empty($mkd_options['menu_item_border_style']) && $mkd_options['menu_item_border_style']=='bottom_border_double' && !empty($mkd_options['menu_item_style']) && $mkd_options['menu_item_style']=='large_item' && $mkd_options['enable_manu_item_border']=='yes' && !empty($mkd_options['menu_item_border_style']) && !empty($mkd_options['menu_item_active_border_color'])){ ?>
            nav.main_menu >ul > li.active > a:before,
            nav.main_menu >ul > li.active > a:after{
			<?php if (!empty($mkd_options['menu_item_active_border_color'])) { ?> background-color: <?php echo esc_attr($mkd_options['menu_item_active_border_color']);  ?>; <?php } ?>
            }
            nav.main_menu >ul > li.active > a,
            nav.main_menu >ul > li.active > a{
            border:none;
            }
		<?php } ?>

		<?php if(!empty($mkd_options['menu_item_border_style']) && $mkd_options['menu_item_border_style']=='bottom_border_double' && !empty($mkd_options['menu_item_style']) && $mkd_options['menu_item_style']=='small_item' && $mkd_options['enable_manu_item_border']=='yes' && !empty($mkd_options['menu_item_border_style']) && !empty($mkd_options['menu_item_hover_border_color'])){ ?>
            nav.main_menu >ul > li:hover > a > span.item_inner:before,
            nav.main_menu >ul > li:hover > a > span.item_inner:after{
			<?php if (!empty($mkd_options['menu_item_hover_border_color'])) { ?> background-color: <?php echo esc_attr($mkd_options['menu_item_hover_border_color']);  ?>; <?php } ?>
            }
            nav.main_menu >ul > li:hover > a > span.item_inner,
            nav.main_menu >ul > li:hover > a > span.item_inner{
            border:none;
            }
		<?php } ?>

		<?php if(!empty($mkd_options['menu_item_border_style']) && $mkd_options['menu_item_border_style']=='bottom_border_double' && !empty($mkd_options['menu_item_style']) && $mkd_options['menu_item_style']=='large_item' && $mkd_options['enable_manu_item_border']=='yes' && !empty($mkd_options['menu_item_border_style']) && !empty($mkd_options['menu_item_hover_border_color'])){ ?>
            nav.main_menu >ul > li:hover > a:before,
            nav.main_menu >ul > li:hover > a:after{
			<?php if (!empty($mkd_options['menu_item_hover_border_color'])) { ?> background-color: <?php echo esc_attr($mkd_options['menu_item_hover_border_color']);  ?>; <?php } ?>
            }
            nav.main_menu >ul > li > a,
            nav.main_menu >ul > li > a{
            border:none;
            }
		<?php } ?>


		<?php if (!empty($mkd_options['menu_item_style']) && ($mkd_options['menu_item_style']=='large_item')&& (!empty($mkd_options['menu_item_border_style']) && ($mkd_options['menu_item_border_style']=='right_border') && ($mkd_options['enable_manu_item_border']=='yes' ))){ ?>
            nav.main_menu > ul > li:last-child > a > span.item_inner{
            border-right:none;
            }
		<?php } ?>

		<?php if (!empty($mkd_options['menu_item_style']) && ($mkd_options['menu_item_style']=='small_item')&& (!empty($mkd_options['menu_item_border_style']) && ($mkd_options['menu_item_border_style']=='right_border') && ($mkd_options['enable_manu_item_border']=='yes' ))){ ?>
            nav.main_menu > ul > li:last-child > a {
            border-right:none;
            }
		<?php } ?>

		<?php if (!empty($mkd_options['menu_item_style']) && $mkd_options['menu_item_style']=='small_item'){ ?>
			<?php if (!empty($mkd_options['menu_item_hover_border_color']) && ($mkd_options['enable_manu_item_border']=='yes' )) { ?>
                nav.main_menu > ul > li:hover > a > span.item_inner,
                nav.main_menu > ul > li.active:hover > a > span.item_inner,
                header:not(.with_hover_bg_color) nav.main_menu > ul > li:hover > a span.item_inner{
                border-color: <?php echo esc_attr($mkd_options['menu_item_hover_border_color']);  ?>;
                }
			<?php } ?>
		<?php } elseif(!empty($mkd_options['menu_item_style']) && $mkd_options['menu_item_style']=='large_item'){ ?>
			<?php if (!empty($mkd_options['menu_item_hover_border_color']) && ($mkd_options['enable_manu_item_border']=='yes' )) { ?>
                nav.main_menu > ul > li:hover > a,
                nav.main_menu > ul > li.active:hover > a,
                header:not(.with_hover_bg_color) nav.main_menu > ul > li:hover > a{
                border-color: <?php echo esc_attr($mkd_options['menu_item_hover_border_color']);  ?>;
                }
			<?php } ?>
		<?php } ?>

		<?php if (!empty($mkd_options['menu_item_style']) && $mkd_options['menu_item_style']=='small_item'){ ?>
			<?php if (!empty($mkd_options['menu_item_active_border_color']) && ($mkd_options['enable_manu_item_border']=='yes' )) { ?>
                nav.main_menu > ul > li.active > a > span.item_inner,
                nav.main_menu > ul > li.active > a > span.item_inner,
                header:not(.with_hover_bg_color) nav.main_menu > ul > li.active > a > span.item_inner{
                border-color: <?php echo esc_attr($mkd_options['menu_item_active_border_color']);  ?>;
                }
			<?php } ?>
		<?php } elseif (!empty($mkd_options['menu_item_style']) && $mkd_options['menu_item_style']=='large_item'){ ?>
			<?php if (!empty($mkd_options['menu_item_active_border_color']) && ($mkd_options['enable_manu_item_border']=='yes' )) { ?>
                nav.main_menu > ul > li.active,
                nav.main_menu > ul > li.active a,
                header:not(.with_hover_bg_color) nav.main_menu > ul > li.active > a{
                border-color: <?php echo esc_attr($mkd_options['menu_item_active_border_color']);  ?>;
                }
			<?php } ?>
		<?php } ?>


		<?php if((!empty($mkd_options['enable_menu_item_separators'])) && ($mkd_options['enable_menu_item_separators']=="yes") && (!empty($mkd_options['menu_item_separators_color']))){ ?>
            nav.main_menu >ul > li > a > span.plus{
            display: block;
            background-color: <?php echo esc_attr($mkd_options['menu_item_separators_color']);  ?>;
            }
		<?php } ?>


		<?php if(isset($mkd_options['menu_activecolor']) && $mkd_options['menu_activecolor'] !== '') { ?>
            nav.main_menu > ul > li.active > a,
            header:not(.with_hover_bg_color) nav.main_menu > ul > li.active > a{
            color: <?php echo esc_attr($mkd_options['menu_activecolor']); ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['menu_light_activecolor']) && $mkd_options['menu_light_activecolor'] !== '') { ?>
            .light:not(.sticky):not(.scrolled) nav.main_menu > ul > li.active > a{
            color: <?php echo esc_attr($mkd_options['menu_light_activecolor']); ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['menu_dark_activecolor']) && $mkd_options['menu_dark_activecolor'] !== '') { ?>
            .dark:not(.sticky):not(.scrolled) nav.main_menu > ul > li.active > a{
            color: <?php echo esc_attr($mkd_options['menu_dark_activecolor']); ?>;
            }
		<?php } ?>


		<?php if(isset($mkd_options['menu_hovercolor']) && $mkd_options['menu_hovercolor'] !== '') { ?>
            nav.main_menu > ul > li:hover > a,
            nav.main_menu > ul > li.active:hover > a,
            header:not(.with_hover_bg_color) nav.main_menu > ul > li:hover > a,
            header:not(.with_hover_bg_color) nav.main_menu > ul > li.active:hover > a,
            .header_bottom #lang_sel ul li a:hover,
            .header_bottom #lang_sel_click > ul > li a:hover{
            color: <?php echo esc_attr($mkd_options['menu_hovercolor']); ?> !important;
            }
		<?php } ?>

		<?php if(isset($mkd_options['menu_light_hovercolor']) && $mkd_options['menu_light_hovercolor'] !== '') { ?>
            .light:not(.sticky):not(.scrolled) nav.main_menu > ul > li:hover > a,
            .light:not(.sticky):not(.scrolled) nav.main_menu > ul > li.active:hover > a{
            color: <?php echo esc_attr($mkd_options['menu_light_hovercolor']); ?> !important;
            }
		<?php } ?>

		<?php if(isset($mkd_options['menu_dark_hovercolor']) && $mkd_options['menu_dark_hovercolor'] !== '') { ?>
            .dark:not(.sticky):not(.scrolled) nav.main_menu > ul > li:hover > a,
            .dark:not(.sticky):not(.scrolled) nav.main_menu > ul > li.active:hover > a{
            color: <?php echo esc_attr($mkd_options['menu_dark_hovercolor']); ?> !important;
            }
		<?php } ?>

		<?php if(isset($mkd_options['menu_padding_left_right']) && $mkd_options['menu_padding_left_right'] !== ''){ ?>
            nav.main_menu > ul > li > a span.item_inner{
            padding: 0  <?php echo esc_attr($mkd_options['menu_padding_left_right']); ?>px;
            }
		<?php } ?>

		<?php if(isset($mkd_options['menu_margin_left_right']) && $mkd_options['menu_margin_left_right'] !== ''){ ?>
            nav.main_menu > ul > li{
            margin: 0  <?php echo esc_attr($mkd_options['menu_margin_left_right']); ?>px;
            }
            header.stick_with_left_right_menu.sticky nav.main_menu.left_side > ul > li:last-child,
            header.stick_with_left_right_menu.sticky nav.main_menu.right_side > ul > li:first-child{
            margin-left:  <?php echo esc_attr($mkd_options['menu_margin_left_right']); ?>px !important;
            margin-right:  <?php echo esc_attr($mkd_options['menu_margin_left_right']); ?>px !important;
            }
		<?php } ?>

		<?php if(isset($mkd_options['menu_hover_background_color']) && $mkd_options['menu_hover_background_color'] !== '') {
			$menu_hover_background_color = $mkd_options['menu_hover_background_color'];

			if(isset($mkd_options['menu_hover_background_color_transparency']) && $mkd_options['menu_hover_background_color_transparency'] !== '') {
				$menu_hover_background_color_rgb = mikado_one_mikado_hex2rgb($menu_hover_background_color);
				$menu_hover_background_color = 'rgba('.$menu_hover_background_color_rgb[0].', '.$menu_hover_background_color_rgb[1].', '.$menu_hover_background_color_rgb[2].', '.esc_attr($mkd_options['menu_hover_background_color_transparency']).')';
			}?>

			<?php if (!empty($mkd_options['menu_item_style']) && $mkd_options['menu_item_style']=='small_item'){ ?>
                nav.main_menu > ul > li:hover > a > span.item_inner,
                header.sticky nav.main_menu > ul > li:hover > a > span.item_inner,
                nav.main_menu > ul > li.active:hover > a > span.item_inner,
                header.sticky nav.main_menu > ul > li.active:hover > a > span.item_inner		{
                background-color: <?php echo esc_attr($menu_hover_background_color); ?>;
                }
			<?php } elseif (!empty($mkd_options['menu_item_style']) && $mkd_options['menu_item_style']=='large_item'){ ?>
                nav.main_menu > ul > li:hover > a,
                header.sticky nav.main_menu > ul > li:hover > a,
                nav.main_menu > ul > li.active:hover > a,
                header.sticky nav.main_menu > ul > li.active:hover > a{
                background-color: <?php echo esc_attr($menu_hover_background_color); ?>;
                }
			<?php } ?>

			<?php

			if(isset($mkd_options['menu_hovercolor']) && $mkd_options['menu_hovercolor'] !== '') {
				?>
                nav.main_menu > ul > li:hover > a,
                nav.main_menu > ul > li.active:hover > a,
                header:not(.with_hover_bg_color) nav.main_menu > ul > li:hover > a,
                header:not(.with_hover_bg_color) nav.main_menu > ul > li.active:hover > a{
                color: <?php echo esc_attr($mkd_options['menu_hovercolor']); ?> !important;
                }
			<?php } ?>
		<?php } ?>

		<?php if(isset($mkd_options['menu_active_background_color']) && $mkd_options['menu_active_background_color'] !== '') {
			$menu_active_background_color = esc_attr($mkd_options['menu_active_background_color']);

			if(isset($mkd_options['menu_active_background_color_transparency']) && $mkd_options['menu_active_background_color_transparency'] !== '') {
				$menu_active_background_color_rgb = mikado_one_mikado_hex2rgb($menu_active_background_color);
				$menu_active_background_color = 'rgba('.$menu_active_background_color_rgb[0].', '.$menu_active_background_color_rgb[1].', '.$menu_active_background_color_rgb[2].', '.esc_attr($mkd_options['menu_active_background_color_transparency']).')';
			}
			?>
			<?php if (!empty($mkd_options['menu_item_style']) && $mkd_options['menu_item_style']=='small_item'){ ?>
                nav.main_menu > ul > li.active > a > span.item_inner,
                header.sticky nav.main_menu > ul > li.active > a > span.item_inner {
				<?php if($mkd_options['menu_active_background_color'] !== '') { ?>
                    background-color: <?php echo esc_attr($menu_active_background_color); ?>;
				<?php } ?>
                }
			<?php } elseif (!empty($mkd_options['menu_item_style']) && $mkd_options['menu_item_style']=='large_item'){ ?>
                nav.main_menu > ul > li.active > a,
                header.sticky nav.main_menu > ul > li.active > a {
				<?php if($mkd_options['menu_active_background_color'] !== '') { ?>
                    background-color: <?php echo esc_attr($menu_active_background_color); ?>;
                    }
				<?php } ?>
			<?php } ?>

			<?php

			if(isset($mkd_options['menu_activecolor']) && $mkd_options['menu_activecolor'] !== '') {
				?>
                nav.main_menu > ul > li.active > a,
                header:not(.with_hover_bg_color) nav.main_menu > ul > li.active > a{
                color: <?php echo esc_attr($mkd_options['menu_activecolor']); ?>;
                }
			<?php } ?>
		<?php } ?>

		<?php if(isset($mkd_options['menu_item_icon_position']) && ($mkd_options['menu_item_icon_position']=="top") && isset($mkd_options['menu_item_icon_size']) && ($mkd_options['menu_item_icon_size']!=="") ){?>
            .header_bottom.with_large_icons nav.main_menu >ul > li > a > span.item_inner i{
            font-size: <?php echo esc_attr($mkd_options['menu_item_icon_size']); ?>px !important;
            }
		<?php } ?>

		<?php if(!empty($mkd_options['dropdown_color']) || !empty($mkd_options['dropdown_fontsize']) || !empty($mkd_options['dropdown_lineheight']) || !empty($mkd_options['dropdown_fontstyle']) || !empty($mkd_options['dropdown_fontweight']) || $mkd_options['dropdown_google_fonts'] != "-1" || !empty($mkd_options['dropdown_texttransform'])  || $mkd_options['dropdown_letterspacing'] !== ''){ ?>
            .drop_down .second .inner > ul > li > a,
            .drop_down .second .inner > ul > li > h4,
            .drop_down .wide .second .inner > ul > li > h4,
            .drop_down .wide .second .inner > ul > li > a,
            .drop_down .wide .second ul li ul li.menu-item-has-children > a,
            .drop_down .wide .second .inner ul li.sub ul li.menu-item-has-children > a,
            .drop_down .wide .second .inner > ul li.sub .flexslider ul li  h4 a,
            .drop_down .wide .second .inner > ul li .flexslider ul li  h4 a,
            .drop_down .wide .second .inner > ul li.sub .flexslider ul li  h4,
            .drop_down .wide .second .inner > ul li .flexslider ul li  h4{
			<?php if (!empty($mkd_options['dropdown_color'])) { ?> color: <?php echo esc_attr($mkd_options['dropdown_color']); ?>; <?php } ?>
			<?php if($mkd_options['dropdown_google_fonts'] != "-1"){ ?>
                font-family: '<?php echo esc_attr(str_replace('+', ' ', $mkd_options['dropdown_google_fonts'])); ?>', sans-serif !important;
			<?php } ?>
			<?php if (!empty($mkd_options['dropdown_fontsize'])) { ?> font-size: <?php echo esc_attr($mkd_options['dropdown_fontsize']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['dropdown_lineheight'])) { ?> line-height: <?php echo esc_attr($mkd_options['dropdown_lineheight']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['dropdown_fontstyle'])) { ?> font-style: <?php echo esc_attr($mkd_options['dropdown_fontstyle']);  ?>;  <?php } ?>
			<?php if (!empty($mkd_options['dropdown_fontweight'])) { ?>font-weight: <?php echo esc_attr($mkd_options['dropdown_fontweight']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['dropdown_texttransform'])) { ?> text-transform: <?php echo esc_attr($mkd_options['dropdown_texttransform']);  ?>;  <?php } ?>
			<?php if ($mkd_options['dropdown_letterspacing'] !== '') { ?> letter-spacing: <?php echo esc_attr($mkd_options['dropdown_letterspacing']);  ?>px;  <?php } ?>
            }
		<?php } ?>

		<?php if (isset($mkd_options['dropdown_color']) && !empty($mkd_options['dropdown_color'])) { ?>
            .shopping_cart_dropdown ul li
            .item_info_holder .item_left a,
            .shopping_cart_dropdown ul li .item_info_holder .item_right .amount,
            .shopping_cart_dropdown ul li,
            .shopping_cart_dropdown .cart_bottom .subtotal_holder .total,
            .shopping_cart_dropdown .cart_bottom .subtotal_holder .total_amount{
            color: <?php echo esc_attr($mkd_options['dropdown_color']); ?>;
            }
		<?php } ?>

		<?php if(!empty($mkd_options['dropdown_color']) || !empty($mkd_options['dropdown_fontsize']) || !empty($mkd_options['dropdown_lineheight']) || !empty($mkd_options['dropdown_fontstyle']) || !empty($mkd_options['dropdown_fontweight']) || $mkd_options['dropdown_google_fonts'] != "-1" || !empty($mkd_options['dropdown_texttransform'])  || $mkd_options['dropdown_letterspacing'] !== ''){ ?>
            .header_bottom #lang_sel ul li li a,
            .header_bottom #lang_sel_click  ul li  ul li a,
            .header_top #lang_sel ul ul a,
            .header_top #lang_sel_click ul ul a{
			<?php if (!empty($mkd_options['dropdown_color'])) { ?> color: <?php echo esc_attr($mkd_options['dropdown_color']); ?>!important; <?php } ?>
			<?php if($mkd_options['dropdown_google_fonts'] != "-1"){ ?>
                font-family: '<?php echo esc_attr(str_replace('+', ' ', $mkd_options['dropdown_google_fonts'])); ?>', sans-serif !important;
			<?php } ?>
			<?php if (!empty($mkd_options['dropdown_fontsize'])) { ?> font-size: <?php echo esc_attr($mkd_options['dropdown_fontsize']);  ?>px !important; <?php } ?>
			<?php if (!empty($mkd_options['dropdown_fontstyle'])) { ?> font-style: <?php echo esc_attr($mkd_options['dropdown_fontstyle']);  ?>;  <?php } ?>
			<?php if (!empty($mkd_options['dropdown_fontweight'])) { ?>font-weight: <?php echo esc_attr($mkd_options['dropdown_fontweight']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['dropdown_texttransform'])) { ?> text-transform: <?php echo esc_attr($mkd_options['dropdown_texttransform']);  ?>;  <?php } ?>
			<?php if ($mkd_options['dropdown_letterspacing'] !== '') { ?> letter-spacing: <?php echo esc_attr($mkd_options['dropdown_letterspacing']);  ?>px;  <?php } ?>
            }
		<?php } ?>



		<?php if (!empty($mkd_options['dropdown_hovercolor'])) { ?>
            .drop_down .second .inner > ul > li > a:hover,
            .drop_down .wide .second ul li ul li.menu-item-has-children > a:hover,
            .drop_down .wide .second .inner ul li.sub ul li.menu-item-has-children > a:hover,
            .header_bottom #lang_sel ul li li a:hover,
            .header_bottom #lang_sel_click  ul li  ul li a:hover,
            .header_top #lang_sel ul ul a:hover,
            .header_top #lang_sel_click ul ul a:hover{
            color: <?php echo esc_attr($mkd_options['dropdown_hovercolor']);  ?> !important;
            }
		<?php } ?>

		<?php if(!empty($mkd_options['dropdown_padding_top_bottom'])){ ?>
            .drop_down .wide .second>.inner>ul>li.sub>ul>li>a,
            .drop_down .second .inner ul li a,
            .drop_down .wide .second ul li a,
            .drop_down .second .inner ul.right li a{
			<?php if (!empty($mkd_options['dropdown_padding_top_bottom'])) { ?> padding-top: <?php echo esc_attr($mkd_options['dropdown_padding_top_bottom']); ?>px; <?php } ?>
			<?php if (!empty($mkd_options['dropdown_padding_top_bottom'])) { ?> padding-bottom: <?php echo esc_attr($mkd_options['dropdown_padding_top_bottom']); ?>px; <?php } ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['dropdown_border_around']) && $mkd_options['dropdown_border_around'] == "yes" && !empty($mkd_options['dropdown_border_around_color'])){ ?>
            .drop_down .second .inner>ul,
            li.narrow .second .inner ul,
            .drop_down .narrow .second .inner ul li ul,
            .shopping_cart_dropdown,
            .shopping_cart_dropdown ul li{
            border-color:  <?php echo esc_attr($mkd_options['dropdown_border_around_color']);  ?>;
            }

		<?php } ?>

		<?php if(isset($mkd_options['dropdown_border_around']) && $mkd_options['dropdown_border_around'] == "no"){ ?>
            .drop_down .second .inner>ul,
            li.narrow .second .inner ul,
            .drop_down .narrow .second .inner ul li ul,
            .shopping_cart_dropdown,
            .shopping_cart_dropdown ul li{
            border: none;
            }

            .drop_down .second .inner ul.right li ul{
            margin-left: 0;
            }
		<?php } ?>



		<?php if(!empty($mkd_options['dropdown_wide_color']) || !empty($mkd_options['dropdown_wide_fontsize']) || !empty($mkd_options['dropdown_wide_lineheight']) || !empty($mkd_options['dropdown_wide_fontstyle']) || !empty($mkd_options['dropdown_wide_fontweight']) || $mkd_options['dropdown_wide_google_fonts'] != "-1" || !empty($mkd_options['dropdown_wide_texttransform'])  || $mkd_options['dropdown_wide_letterspacing'] !== ''){ ?>
            .drop_down .wide .second .inner>ul>li>a{
			<?php if (!empty($mkd_options['dropdown_wide_color'])) { ?> color: <?php echo esc_attr($mkd_options['dropdown_wide_color']); ?>; <?php } ?>
			<?php if($mkd_options['dropdown_wide_google_fonts'] != "-1"){ ?>
                font-family: '<?php echo esc_attr(str_replace('+', ' ', $mkd_options['dropdown_wide_google_fonts'])); ?>', sans-serif !important;
			<?php } ?>
			<?php if (!empty($mkd_options['dropdown_wide_fontsize'])) { ?> font-size: <?php echo esc_attr($mkd_options['dropdown_wide_fontsize']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['dropdown_wide_lineheight'])) { ?> line-height: <?php echo esc_attr($mkd_options['dropdown_wide_lineheight']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['dropdown_wide_fontstyle'])) { ?> font-style: <?php echo esc_attr($mkd_options['dropdown_wide_fontstyle']);  ?>;  <?php } ?>
			<?php if (!empty($mkd_options['dropdown_wide_fontweight'])) { ?>font-weight: <?php echo esc_attr($mkd_options['dropdown_wide_fontweight']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['dropdown_wide_texttransform'])) { ?> text-transform: <?php echo esc_attr($mkd_options['dropdown_wide_texttransform']);  ?>;  <?php } ?>
			<?php if ($mkd_options['dropdown_wide_letterspacing'] !== '') { ?> letter-spacing: <?php echo esc_attr($mkd_options['dropdown_wide_letterspacing']);  ?>px;  <?php } ?>
            }
		<?php } ?>
		<?php if (!empty($mkd_options['dropdown_wide_hovercolor'])) { ?>
            .drop_down .wide .second .inner>ul>li>a:hover{
            color: <?php echo esc_attr($mkd_options['dropdown_wide_hovercolor']);  ?> !important;
            }
		<?php } ?>
		<?php if(!empty($mkd_options['dropdown_color_thirdlvl']) || !empty($mkd_options['dropdown_fontsize_thirdlvl']) || !empty($mkd_options['dropdown_lineheight_thirdlvl']) || !empty($mkd_options['dropdown_fontstyle_thirdlvl']) || !empty($mkd_options['dropdown_fontweight_thirdlvl']) || $mkd_options['dropdown_google_fonts_thirdlvl'] != "-1" || !empty($mkd_options['dropdown_texttransform_thirdlvl']) || $mkd_options['dropdown_letterspacing_thirdlvl'] !== ''){ ?>
            .drop_down .wide .second .inner ul li.sub ul li a,
            .drop_down .wide .second ul li ul li a,
            .drop_down .second .inner ul li.sub ul li a{
			<?php if (!empty($mkd_options['dropdown_color_thirdlvl'])) { ?> color: <?php echo esc_attr($mkd_options['dropdown_color_thirdlvl']);  ?>;  <?php } ?>
			<?php if($mkd_options['dropdown_google_fonts_thirdlvl'] != "-1"){ ?>
                font-family: '<?php echo esc_attr(str_replace('+', ' ', $mkd_options['dropdown_google_fonts_thirdlvl'])); ?>', sans-serif;
			<?php } ?>
			<?php if (!empty($mkd_options['dropdown_fontsize_thirdlvl'])) { ?> font-size: <?php echo esc_attr($mkd_options['dropdown_fontsize_thirdlvl']);  ?>px;  <?php } ?>
			<?php if (!empty($mkd_options['dropdown_lineheight_thirdlvl'])) { ?> line-height: <?php echo esc_attr($mkd_options['dropdown_lineheight_thirdlvl']);  ?>px;  <?php } ?>
			<?php if (!empty($mkd_options['dropdown_fontstyle_thirdlvl'])) { ?> font-style: <?php echo esc_attr($mkd_options['dropdown_fontstyle_thirdlvl']);  ?>;   <?php } ?>
			<?php if (!empty($mkd_options['dropdown_fontweight_thirdlvl'])) { ?> font-weight: <?php echo esc_attr($mkd_options['dropdown_fontweight_thirdlvl']);  ?>;  <?php } ?>
			<?php if (!empty($mkd_options['dropdown_texttransform_thirdlvl'])) { ?> text-transform: <?php echo esc_attr($mkd_options['dropdown_texttransform_thirdlvl']);  ?>;  <?php } ?>
			<?php if ($mkd_options['dropdown_letterspacing_thirdlvl'] !== '') { ?> letter-spacing: <?php echo esc_attr($mkd_options['dropdown_letterspacing_thirdlvl']);  ?>px;  <?php } ?>
            }
		<?php } ?>
		<?php if (!empty($mkd_options['dropdown_hovercolor_thirdlvl'])) { ?>
            .drop_down .second .inner ul li.sub ul li a:hover,
            .drop_down .second .inner ul li ul li a:hover{
            color: <?php echo esc_attr($mkd_options['dropdown_hovercolor_thirdlvl']);  ?> !important;
            }
		<?php } ?>

		<?php if(!empty($mkd_options['fixed_color']) || !empty($mkd_options['fixed_fontsize']) || !empty($mkd_options['fixed_lineheight']) || !empty($mkd_options['fixed_fontstyle']) || !empty($mkd_options['fixed_fontweight']) || !empty($mkd_options['fixed_texttransform']) || (isset($mkd_options['fixed_letterspacing']) && $mkd_options['fixed_letterspacing'] !== '') || $mkd_options['fixed_google_fonts'] != "-1"){ ?>
            header.scrolled nav.main_menu > ul > li > a > span.item_inner,
            header.light.scrolled nav.main_menu > ul > li > a > span.item_inner,
            header.dark.scrolled nav.main_menu > ul > li > a > span.item_inner{
			<?php if (!empty($mkd_options['fixed_color'])) { ?> color: <?php echo esc_attr($mkd_options['fixed_color']); ?>; <?php } ?>
			<?php if($mkd_options['fixed_google_fonts'] != "-1"){ ?>
                font-family: '<?php echo esc_attr(str_replace('+', ' ', $mkd_options['fixed_google_fonts'])); ?>', sans-serif !important;
			<?php } ?>
			<?php if (!empty($mkd_options['fixed_fontsize'])) { ?> font-size: <?php echo esc_attr($mkd_options['fixed_fontsize']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['fixed_lineheight'])) { ?> line-height: <?php echo esc_attr($mkd_options['fixed_lineheight']);  ?>px !important; <?php } ?>
			<?php if (!empty($mkd_options['fixed_fontstyle'])) { ?> font-style: <?php echo esc_attr($mkd_options['fixed_fontstyle']);  ?>;  <?php } ?>
			<?php if (!empty($mkd_options['fixed_fontweight'])) { ?>font-weight: <?php echo esc_attr($mkd_options['fixed_fontweight']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['fixed_texttransform'])) { ?> text-transform: <?php echo esc_attr($mkd_options['fixed_texttransform']);  ?>;  <?php } ?>
			<?php if ($mkd_options['fixed_letterspacing'] !== '') { ?> letter-spacing: <?php echo esc_attr($mkd_options['fixed_letterspacing']);  ?>px;  <?php } ?>
            }
		<?php } ?>
		<?php if (!empty($mkd_options['fixed_color'])) { ?>
            header.scrolled .side_menu_button a {
			<?php if (!empty($mkd_options['fixed_color'])) { ?> color: <?php echo esc_attr($mkd_options['fixed_color']); ?> !important; <?php } ?>
            }
		<?php } ?>
		<?php if (!empty($mkd_options['fixed_hovercolor'])) { ?>
            header.scrolled nav.main_menu > ul > li > a:hover > span,
            header.scrolled nav.main_menu > ul > li:hover > a > span,
            header.scrolled nav.main_menu > ul > li.active > a > span,
            header.scrolled nav.main_menu > ul > li > a:hover > i,
            header.scrolled nav.main_menu > ul > li:hover > a > i,
            header.scrolled nav.main_menu > ul > li.active > a > i,
            header.scrolled .side_menu_button a:hover,
            .light.scrolled nav.main_menu > ul > li > a:hover,
            .light.scrolled nav.main_menu > ul > li.active > a,
            .light.scrolled .side_menu_button a:hover,
            .dark.scrolled nav.main_menu > ul > li > a:hover,
            .dark.scrolled nav.main_menu > ul > li.active > a,
            .dark.scrolled .side_menu_button a:hover {
            color: <?php echo esc_attr($mkd_options['fixed_hovercolor']);  ?> !important;
            }
		<?php } ?>

		<?php if(!empty($mkd_options['sticky_color']) || !empty($mkd_options['sticky_fontsize']) || !empty($mkd_options['sticky_lineheight']) || !empty($mkd_options['sticky_fontstyle']) || !empty($mkd_options['sticky_fontweight']) || !empty($mkd_options['sticky_texttransform']) || (isset($mkd_options['sticky_letterspacing']) && $mkd_options['sticky_letterspacing'] !== '') || $mkd_options['sticky_google_fonts'] != "-1"){ ?>
            header.sticky nav.main_menu > ul > li > a > span.item_inner,
            header.light.sticky nav.main_menu > ul > li > a > span.item_inner,
            header.dark.sticky nav.main_menu > ul > li > a > span.item_inner{
			<?php if (!empty($mkd_options['sticky_color'])) { ?> color: <?php echo esc_attr($mkd_options['sticky_color']); ?>; <?php } ?>
			<?php if($mkd_options['sticky_google_fonts'] != "-1"){ ?>
                font-family: '<?php echo esc_attr(str_replace('+', ' ', $mkd_options['sticky_google_fonts'])); ?>', sans-serif !important;
			<?php } ?>
			<?php if (!empty($mkd_options['sticky_fontsize'])) { ?> font-size: <?php echo esc_attr($mkd_options['sticky_fontsize']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['sticky_lineheight'])) { ?> line-height: <?php echo esc_attr($mkd_options['sticky_lineheight']);  ?>px !important; <?php } ?>
			<?php if (!empty($mkd_options['sticky_fontstyle'])) { ?> font-style: <?php echo esc_attr($mkd_options['sticky_fontstyle']);  ?>;  <?php } ?>
			<?php if (!empty($mkd_options['sticky_fontweight'])) { ?>font-weight: <?php echo esc_attr($mkd_options['sticky_fontweight']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['sticky_texttransform'])) { ?> text-transform: <?php echo esc_attr($mkd_options['sticky_texttransform']);  ?>;  <?php } ?>
			<?php if ($mkd_options['sticky_letterspacing'] !== '') { ?> letter-spacing: <?php echo esc_attr($mkd_options['sticky_letterspacing']);  ?>px;  <?php } ?>
            }
		<?php } ?>

		<?php if (!empty($mkd_options['sticky_color'])) { ?>
            header.sticky .side_menu_button a,
            header.sticky .side_menu_button a:hover{
			<?php if (!empty($mkd_options['sticky_color'])) { ?> color: <?php echo esc_attr($mkd_options['sticky_color']); ?>; <?php } ?>
            }
		<?php } ?>

		<?php if (!empty($mkd_options['sticky_hovercolor'])) { ?>
            header.sticky nav.main_menu > ul > li > a:hover span,
            header.sticky nav.main_menu > ul > li.active > a span,
            header.sticky nav.main_menu > ul > li:hover > a > span,
            header.sticky nav.main_menu > ul > li > a:hover > i,
            header.sticky nav.main_menu > ul > li:hover > a > i,
            header.sticky nav.main_menu > ul > li.active > a > i,
            .light.sticky nav.main_menu > ul > li > a:hover,
            .light.sticky nav.main_menu > ul > li.active > a,
            .dark.sticky nav.main_menu > ul > li > a:hover,
            .dark.sticky nav.main_menu > ul > li.active > a{
            color: <?php echo esc_attr($mkd_options['sticky_hovercolor']);  ?> !important;
            }
		<?php } ?>

		<?php if (!empty($mkd_options['mobile_color']) || !empty($mkd_options['mobile_fontsize']) || !empty($mkd_options['mobile_lineheight']) || !empty($mkd_options['mobile_fontstyle']) || !empty($mkd_options['mobile_fontweight']) || !empty($mkd_options['mobile_texttransform']) || $mkd_options['mobile_letter_spacing'] !== '' || $mkd_options['mobile_google_fonts'] != "-1") { ?>
            nav.mobile_menu ul li a,
            nav.mobile_menu ul li h4{
			<?php if (!empty($mkd_options['mobile_color'])) { ?> color: <?php echo esc_attr($mkd_options['mobile_color']);  ?>; <?php } ?>
			<?php if($mkd_options['mobile_google_fonts'] != "-1"){ ?>
                font-family: '<?php echo esc_attr(str_replace('+', ' ', $mkd_options['mobile_google_fonts'])); ?>', sans-serif;
			<?php } ?>
			<?php if (!empty($mkd_options['mobile_fontsize'])) { ?> font-size: <?php echo esc_attr($mkd_options['mobile_fontsize']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['mobile_lineheight'])) { ?> line-height: <?php echo esc_attr($mkd_options['mobile_lineheight']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['mobile_fontstyle'])) { ?> font-style: <?php echo esc_attr($mkd_options['mobile_fontstyle']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['mobile_fontweight'])) { ?> font-weight: <?php echo esc_attr($mkd_options['mobile_fontweight']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['mobile_texttransform'])) { ?> text-transform: <?php echo esc_attr($mkd_options['mobile_texttransform']);  ?>;  <?php } ?>
			<?php if ($mkd_options['mobile_letter_spacing'] !== ''){ ?>letter-spacing: <?php echo esc_attr($mkd_options['mobile_letter_spacing']);  ?>px;<?php } ?>
            }
			<?php if (!empty($mkd_options['mobile_color'])) { ?>
                nav.mobile_menu ul > li.has_sub > span.mobile_arrow{
                color: <?php echo esc_attr($mkd_options['mobile_color']);  ?>;
                }
			<?php } ?>

		<?php } ?>

		<?php if (!empty($mkd_options['mobile_hovercolor'])) { ?>
            nav.mobile_menu ul li a:hover,
            nav.mobile_menu ul li.active > a,
            nav.mobile_menu ul li.current-menu-item > a{
            color: <?php echo esc_attr($mkd_options['mobile_hovercolor']);  ?>;
            }
		<?php } ?>
		<?php if (!empty($mkd_options['mobile_separator_color'])) { ?>
            nav.mobile_menu ul li,
            nav.mobile_menu ul li.open_sub > ul{
            border-color: <?php echo esc_attr($mkd_options['mobile_separator_color']);  ?>;
            }
		<?php } ?>

		<?php if (!empty($mkd_options['mobile_background_color'])) { ?>
            @media only screen and (max-width: 1000px){
            .header_bottom,
            nav.mobile_menu{
            background-color: <?php echo esc_attr($mkd_options['mobile_background_color']);  ?> !important;
            }
            }
		<?php } ?>

		<?php if (isset($mkd_options['interactive_banners_background_color']) && !empty($mkd_options['interactive_banners_background_color'])) { ?>
			<?php $shader_bg_color = mikado_one_mikado_hex2rgb($mkd_options['interactive_banners_background_color']); ?>

			<?php if(isset($mkd_options['interactive_banners_background_transparency']) && !empty($mkd_options['interactive_banners_background_transparency'])){
				$interactive_banners_shader_transparency = $mkd_options['interactive_banners_background_transparency'];
			} else {
				$interactive_banners_shader_transparency = 0.9;
			}
			?>

            .mkd_image_with_text_over .shader{
            background-color: rgba(<?php echo esc_attr($shader_bg_color[0]); ?>,<?php echo esc_attr($shader_bg_color[1]); ?>,<?php echo esc_attr($shader_bg_color[2]); ?>,<?php echo esc_attr($interactive_banners_shader_transparency); ?>);
            }
		<?php } ?>

		<?php if (isset($mkd_options['interactive_banners_hover_background_color']) && !empty($mkd_options['interactive_banners_hover_background_color'])) { ?>
			<?php $shader_hover_bg_color = mikado_one_mikado_hex2rgb(esc_attr($mkd_options['interactive_banners_hover_background_color'])); ?>

			<?php if(isset($mkd_options['interactive_banners_hover_background_transparency']) && !empty($mkd_options['interactive_banners_hover_background_transparency'])){
				$interactive_banners_shader_transparency = esc_attr($mkd_options['interactive_banners_hover_background_transparency']);
			} else {
				$interactive_banners_shader_transparency = 0.9;
			}
			?>

            .mkd_image_with_text_over:hover .shader{
            background-color: rgba(<?php echo esc_attr($shader_hover_bg_color[0]); ?>,<?php echo esc_attr($shader_hover_bg_color[1]); ?>,<?php echo esc_attr($shader_hover_bg_color[2]); ?>,<?php echo esc_attr($interactive_banners_shader_transparency) ?>);
            }
		<?php } ?>



		<?php
		$list_styles = array();

		if(isset($mkd_options['list_fontfamily']) && $mkd_options['list_fontfamily'] !== '-1') {
			$list_styles[] = 'font-family: '.str_replace('+', ' ', $mkd_options['list_fontfamily']).', sans-serif';
		}

		if(isset($mkd_options['list_fontsize']) && $mkd_options['list_fontsize'] !== '') {
			$list_styles[] = 'font-size: '.intval($mkd_options['list_fontsize']).'px !important';
		}

		if(isset($mkd_options['list_lineheight']) && $mkd_options['list_lineheight'] !== '') {
			$list_styles[] = 'line-height: '.intval($mkd_options['list_lineheight']).'px';
		}

		if(isset($mkd_options['list_letterspacing']) && $mkd_options['list_letterspacing'] !== '') {
			$list_styles[] = 'letter-spacing: '.intval($mkd_options['list_letterspacing']).'px';
		}

		if(isset($mkd_options['list_fontweight']) && $mkd_options['list_fontweight'] !== '') {
			$list_styles[] = 'font-weight: '.intval($mkd_options['list_fontweight']);
		}

		if(isset($mkd_options['list_fontstyle']) && $mkd_options['list_fontstyle'] !== '') {
			$list_styles[] = 'font-style: '.$mkd_options['list_fontstyle'];
		}

		if(isset($mkd_options['list_texttransform']) && $mkd_options['list_texttransform'] !== '') {
			$list_styles[] = 'text-transform: '.$mkd_options['list_texttransform'];
		}

		if(isset($mkd_options['list_color']) && $mkd_options['list_color'] !== '') {
			$list_styles[] = 'color: '.$mkd_options['list_color'];
		}
		?>
		<?php if(is_array($list_styles) && count($list_styles)) { ?>
            .mkd_list.circle ul>li{
			<?php echo esc_attr(implode(';', $list_styles)); ?>
            }
		<?php }  ?>

		<?php if (isset($mkd_options['list_item_color']) && !empty($mkd_options['list_item_color'])) { ?>
            .mkd_list.circle ul>li:before{
            background-color: <?php echo esc_attr($mkd_options['list_item_color']);?>;
            }
		<?php } ?>



		<?php
		$list_ordered_styles = array();

		if(isset($mkd_options['list_ordered_fontfamily']) && $mkd_options['list_ordered_fontfamily'] !== '-1') {
			$list_ordered_styles[] = 'font-family: '.str_replace('+', ' ', $mkd_options['list_ordered_fontfamily']).', sans-serif';
		}

		if(isset($mkd_options['list_ordered_fontsize']) && $mkd_options['list_ordered_fontsize'] !== '') {
			$list_ordered_styles[] = 'font-size: '.intval($mkd_options['list_ordered_fontsize']).'px !important';
		}

		if(isset($mkd_options['list_ordered_lineheight']) && $mkd_options['list_ordered_lineheight'] !== '') {
			$list_ordered_styles[] = 'line-height: '.intval($mkd_options['list_ordered_lineheight']).'px';
		}

		if(isset($mkd_options['list_ordered_letterspacing']) && $mkd_options['list_ordered_letterspacing'] !== '') {
			$list_ordered_styles[] = 'letter-spacing: '.intval($mkd_options['list_ordered_letterspacing']).'px';
		}

		if(isset($mkd_options['list_ordered_fontweight']) && $mkd_options['list_ordered_fontweight'] !== '') {
			$list_ordered_styles[] = 'font-weight: '.intval($mkd_options['list_ordered_fontweight']);
		}

		if(isset($mkd_options['list_ordered_fontstyle']) && $mkd_options['list_ordered_fontstyle'] !== '') {
			$list_ordered_styles[] = 'font-style: '.$mkd_options['list_ordered_fontstyle'];
		}

		if(isset($mkd_options['list_ordered_texttransform']) && $mkd_options['list_ordered_texttransform'] !== '') {
			$list_ordered_styles[] = 'text-transform: '.$mkd_options['list_ordered_texttransform'];
		}

		if(isset($mkd_options['list_ordered_color']) && $mkd_options['list_ordered_color'] !== '') {
			$list_ordered_styles[] = 'color: '.$mkd_options['list_ordered_color'];
		}
		?>
		<?php if(is_array($list_ordered_styles) && count($list_ordered_styles)) { ?>
            .ordered ol li,
            .mkd_list.number ul>li{
			<?php echo esc_attr(implode(';', $list_ordered_styles)); ?>
            }
		<?php }  ?>

		<?php if (isset($mkd_options['list_ordered_item_color']) && !empty($mkd_options['list_ordered_item_color'])) { ?>
            .ordered ol>li:before,
            .mkd_list.number ul>li:before{
            color: <?php echo esc_attr($mkd_options['list_ordered_item_color']);?>;
            }
		<?php } ?>



		<?php if (!empty($mkd_options['input_background_color']) || !empty($mkd_options['input_border_color']) || !empty($mkd_options['input_text_color'])) { ?>
            #respond textarea,
            #respond input[type='text'],
            .contact_form input[type='text'],
            .contact_form  textarea,
            .comment_holder #respond textarea,
            .comment_holder #respond input[type='text'],
            input.wpcf7-form-control.wpcf7-text,
            input.wpcf7-form-control.wpcf7-number,
            input.wpcf7-form-control.wpcf7-date,
            textarea.wpcf7-form-control.wpcf7-textarea,
            select.wpcf7-form-control.wpcf7-select,
            input.wpcf7-form-control.wpcf7-quiz{
			<?php if (!empty($mkd_options['input_background_color'])) { ?>background-color: <?php echo esc_attr($mkd_options['input_background_color']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['input_border_color'])) { ?>border: 1px solid <?php echo esc_attr($mkd_options['input_border_color']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['input_text_color'])) { ?>color:<?php echo esc_attr($mkd_options['input_text_color']);  ?>; <?php } ?>
            }
		<?php } ?>

		<?php

		if(!empty($mkd_options['input_focus_text_color']) || !empty($mkd_options['input_focus_background_color']) || !empty($mkd_options['input_focus_border_color'])) { ?>
            #respond textarea:focus,
            #respond input[type='text']:focus,
            .contact_form input[type='text']:focus,
            .contact_form  textarea:focus,
            .comment_holder #respond textarea:focus,
            .comment_holder #respond input[type='text']:focus,
            input.wpcf7-form-control.wpcf7-text:focus,
            input.wpcf7-form-control.wpcf7-number:focus,
            input.wpcf7-form-control.wpcf7-date:focus,
            textarea.wpcf7-form-control.wpcf7-textarea:focus,
            select.wpcf7-form-control.wpcf7-select:focus,
            input.wpcf7-form-control.wpcf7-quiz:focus{
			<?php if (!empty($mkd_options['input_focus_text_color'])) { ?>color: <?php echo esc_attr($mkd_options['input_focus_text_color']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['input_focus_background_color'])) { ?>background-color: <?php echo esc_attr($mkd_options['input_focus_background_color']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['input_focus_border_color'])) { ?>border-color: <?php echo esc_attr($mkd_options['input_focus_border_color']);  ?>; <?php } ?>
            }
		<?php }

		if(!empty($mkd_options['input_focus_text_color'])) { ?>
            #respond textarea:focus::-webkit-input-placeholder,
            #respond input[type='text']:focus::-webkit-input-placeholder,
            .contact_form input[type='text']:focus::-webkit-input-placeholder,
            .contact_form  textarea:focus::-webkit-input-placeholder,
            input.wpcf7-form-control.wpcf7-text:focus::-webkit-input-placeholder,
            textarea.wpcf7-form-control.wpcf7-textarea:focus::-webkit-input-placeholder{
            color: <?php echo esc_attr($mkd_options['input_focus_text_color']);  ?>;
            }

            #respond textarea:focus:-moz-placeholder,
            #respond input[type='text']:focus:-moz-placeholder,
            .contact_form input[type='text']:focus:-moz-placeholder,
            .contact_form  textarea:focus:-moz-placeholder,
            input.wpcf7-form-control.wpcf7-text:focus:-moz-placeholder,
            textarea.wpcf7-form-control.wpcf7-textarea:focus:-moz-placeholder{
            color: <?php echo esc_attr($mkd_options['input_focus_text_color']);  ?>;
            }

            #respond textarea:focus::-moz-placeholder,
            #respond input[type='text']:focus::-moz-placeholder,
            .contact_form input[type='text']:focus::-moz-placeholder,
            .contact_form  textarea:focus::-moz-placeholder,
            input.wpcf7-form-control.wpcf7-text:focus::-moz-placeholder,
            textarea.wpcf7-form-control.wpcf7-textarea:focus::-moz-placeholder{
            color: <?php echo esc_attr($mkd_options['input_focus_text_color']);  ?>;
            }
		<?php } ?>

		<?php if (!empty($mkd_options['h1_color']) || !empty($mkd_options['h1_fontsize']) || !empty($mkd_options['h1_lineheight']) || !empty($mkd_options['h1_fontstyle']) || !empty($mkd_options['h1_fontweight']) || $mkd_options['h1_letterspacing'] !== '' || $mkd_options['h1_google_fonts'] != "-1" || !empty($mkd_options['h1_texttransform'])) { ?>
            h1{
			<?php if (!empty($mkd_options['h1_color'])) { ?>   color: <?php echo esc_attr($mkd_options['h1_color']);  ?>; <?php } ?>
			<?php if($mkd_options['h1_google_fonts'] != "-1"){ ?>
                font-family: '<?php echo esc_attr(str_replace('+', ' ', $mkd_options['h1_google_fonts'])); ?>', sans-serif;
			<?php } ?>
			<?php if (!empty($mkd_options['h1_fontsize'])) { ?>font-size: <?php echo esc_attr($mkd_options['h1_fontsize']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['h1_lineheight'])) { ?>line-height: <?php echo esc_attr($mkd_options['h1_lineheight']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['h1_fontstyle'])) { ?>font-style: <?php echo esc_attr($mkd_options['h1_fontstyle']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['h1_fontweight'])) { ?>font-weight: <?php echo esc_attr($mkd_options['h1_fontweight']);  ?>; <?php } ?>
			<?php if ($mkd_options['h1_letterspacing'] !== '') { ?>letter-spacing: <?php echo esc_attr($mkd_options['h1_letterspacing']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['h1_texttransform'])) { ?>text-transform: <?php echo esc_attr($mkd_options['h1_texttransform']);  ?>; <?php } ?>
            }
		<?php } ?>
		<?php if (!empty($mkd_options['h2_color']) || !empty($mkd_options['h2_fontsize']) || !empty($mkd_options['h2_lineheight']) || !empty($mkd_options['h2_fontstyle']) || !empty($mkd_options['h2_fontweight']) || $mkd_options['h2_letterspacing'] !== '' || $mkd_options['h2_google_fonts'] != "-1" || !empty($mkd_options['h2_texttransform'])) { ?>
            h2{
			<?php if($mkd_options['h2_google_fonts'] != "-1"){ ?>
                font-family: '<?php echo esc_attr(str_replace('+', ' ', $mkd_options['h2_google_fonts'])); ?>', sans-serif;
			<?php } ?>
			<?php if (!empty($mkd_options['h2_fontsize'])) { ?>font-size: <?php echo esc_attr($mkd_options['h2_fontsize']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['h2_lineheight'])) { ?>line-height: <?php echo esc_attr($mkd_options['h2_lineheight']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['h2_fontstyle'])) { ?>font-style: <?php echo esc_attr($mkd_options['h2_fontstyle']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['h2_fontweight'])) { ?>font-weight: <?php echo esc_attr($mkd_options['h2_fontweight']);  ?>; <?php } ?>
			<?php if ($mkd_options['h2_letterspacing'] !== '') { ?>letter-spacing: <?php echo esc_attr($mkd_options['h2_letterspacing']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['h2_texttransform'])) { ?>text-transform: <?php echo esc_attr($mkd_options['h2_texttransform']);  ?>; <?php } ?>
            }
            h2, h2 a{
			<?php if (!empty($mkd_options['h2_color'])) { ?>color: <?php echo esc_attr($mkd_options['h2_color']);  ?>; <?php } ?>
            }
		<?php } ?>
		<?php if (!empty($mkd_options['h3_color']) || !empty($mkd_options['h3_fontsize']) || !empty($mkd_options['h3_lineheight']) || !empty($mkd_options['h3_fontstyle']) || !empty($mkd_options['h3_fontweight']) || $mkd_options['h3_letterspacing'] !== '' || $mkd_options['h3_google_fonts'] != "-1" || !empty($mkd_options['h3_texttransform'])) { ?>
            h3{
			<?php if($mkd_options['h3_google_fonts'] != "-1"){ ?>
                font-family: '<?php echo esc_attr(str_replace('+', ' ', $mkd_options['h3_google_fonts'])); ?>', sans-serif;
			<?php } ?>
			<?php if (!empty($mkd_options['h3_fontsize'])) { ?>font-size: <?php echo esc_attr($mkd_options['h3_fontsize']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['h3_lineheight'])) { ?>line-height: <?php echo esc_attr($mkd_options['h3_lineheight']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['h3_fontstyle'])) { ?>font-style: <?php echo esc_attr($mkd_options['h3_fontstyle']);?>; <?php } ?>
			<?php if (!empty($mkd_options['h3_fontweight'])) { ?>font-weight: <?php echo esc_attr($mkd_options['h3_fontweight']);  ?>; <?php } ?>
			<?php if ($mkd_options['h3_letterspacing'] !== '') { ?>letter-spacing: <?php echo esc_attr($mkd_options['h3_letterspacing']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['h3_texttransform'])) { ?>text-transform: <?php echo esc_attr($mkd_options['h3_texttransform']);  ?>; <?php } ?>
            }
            h3, h3 a{
			<?php if (!empty($mkd_options['h3_color'])) { ?>color: <?php echo esc_attr($mkd_options['h3_color']);  ?>; <?php } ?>
            }
		<?php } ?>
		<?php if (!empty($mkd_options['h4_color']) || !empty($mkd_options['h4_fontsize']) || !empty($mkd_options['h4_lineheight']) || !empty($mkd_options['h4_fontstyle']) || !empty($mkd_options['h4_fontweight']) || $mkd_options['h4_letterspacing'] !== '' || $mkd_options['h4_google_fonts'] != "-1" || !empty($mkd_options['h4_texttransform'])) { ?>
            h4{
			<?php if($mkd_options['h4_google_fonts'] != "-1"){ ?>
                font-family: '<?php echo esc_attr(str_replace('+', ' ', $mkd_options['h4_google_fonts'])); ?>', sans-serif;
			<?php } ?>
			<?php if (!empty($mkd_options['h4_fontsize'])) { ?>font-size: <?php echo esc_attr($mkd_options['h4_fontsize']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['h4_lineheight'])) { ?>line-height: <?php echo esc_attr($mkd_options['h4_lineheight']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['h4_fontstyle'])) { ?>font-style: <?php echo esc_attr($mkd_options['h4_fontstyle']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['h4_fontweight'])) { ?>font-weight: <?php echo esc_attr($mkd_options['h4_fontweight']);  ?>; <?php } ?>
			<?php if ($mkd_options['h4_letterspacing'] !== '') { ?>letter-spacing: <?php echo esc_attr($mkd_options['h4_letterspacing']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['h4_texttransform'])) { ?>text-transform: <?php echo esc_attr($mkd_options['h4_texttransform']);  ?>; <?php } ?>
            }
            h4, h4 a{
			<?php if (!empty($mkd_options['h4_color'])) { ?>color: <?php echo esc_attr($mkd_options['h4_color']);  ?>; <?php } ?>
            }
		<?php } ?>
		<?php if (!empty($mkd_options['h5_color']) || !empty($mkd_options['h5_fontsize']) || !empty($mkd_options['h5_lineheight']) || !empty($mkd_options['h5_fontstyle']) || !empty($mkd_options['h5_fontweight']) || $mkd_options['h5_letterspacing'] !== '' || $mkd_options['h5_google_fonts'] != "-1" || !empty($mkd_options['h5_texttransform'])) { ?>
            h5{
			<?php if($mkd_options['h5_google_fonts'] != "-1"){ ?>
                font-family: '<?php echo esc_attr(str_replace('+', ' ', $mkd_options['h5_google_fonts'])); ?>', sans-serif;
			<?php } ?>
			<?php if (!empty($mkd_options['h5_fontsize'])) { ?>font-size: <?php echo esc_attr($mkd_options['h5_fontsize']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['h5_lineheight'])) { ?>line-height: <?php echo esc_attr($mkd_options['h5_lineheight']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['h5_fontstyle'])) { ?>font-style: <?php echo esc_attr($mkd_options['h5_fontstyle']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['h5_fontweight'])) { ?>font-weight: <?php echo esc_attr($mkd_options['h5_fontweight']);  ?>; <?php } ?>
			<?php if ($mkd_options['h5_letterspacing'] !== '') { ?>letter-spacing: <?php echo esc_attr($mkd_options['h5_letterspacing']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['h5_texttransform'])) { ?>text-transform: <?php echo esc_attr($mkd_options['h5_texttransform']);  ?>; <?php } ?>
            }
            h5, h5 a{
			<?php if (!empty($mkd_options['h5_color'])) { ?>color: <?php echo esc_attr($mkd_options['h5_color']);  ?>; <?php } ?>
            }
		<?php } ?>
		<?php if (!empty($mkd_options['h6_color']) || !empty($mkd_options['h6_fontsize']) || !empty($mkd_options['h6_lineheight']) || !empty($mkd_options['h6_fontstyle']) || !empty($mkd_options['h6_fontweight']) || $mkd_options['h6_letterspacing'] !== '' || $mkd_options['h6_google_fonts'] != "-1" || !empty($mkd_options['h6_texttransform'])) { ?>
            h6{
			<?php if($mkd_options['h6_google_fonts'] != "-1"){ ?>
                font-family: '<?php echo esc_attr(str_replace('+', ' ', $mkd_options['h6_google_fonts'])); ?>', sans-serif;
			<?php } ?>
			<?php if (!empty($mkd_options['h6_fontsize'])) { ?>font-size: <?php echo esc_attr($mkd_options['h6_fontsize']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['h6_lineheight'])) { ?>line-height: <?php echo esc_attr($mkd_options['h6_lineheight']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['h6_fontstyle'])) { ?>font-style: <?php echo esc_attr($mkd_options['h6_fontstyle']);  ?>;  <?php } ?>
			<?php if (!empty($mkd_options['h6_fontweight'])) { ?>font-weight: <?php echo esc_attr($mkd_options['h6_fontweight']);  ?>; <?php } ?>
			<?php if ($mkd_options['h6_letterspacing'] !== '') { ?>letter-spacing: <?php echo esc_attr($mkd_options['h6_letterspacing']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['h6_texttransform'])) { ?>text-transform: <?php echo esc_attr($mkd_options['h6_texttransform']);  ?>; <?php } ?>
            }
            h6, h6 a{
			<?php if (!empty($mkd_options['h6_color'])) { ?>color: <?php echo esc_attr($mkd_options['h6_color']);  ?>; <?php } ?>
            }
		<?php } ?>


		<?php
		$text_style = array();

		if(isset($mkd_options['text_google_fonts']) && $mkd_options['text_google_fonts'] !== '-1') {
			$text_style[] = 'font-family: '.esc_attr(str_replace('+', ' ', $mkd_options['text_google_fonts'])).', sans-serif';
		}

		if(isset($mkd_options['text_fontsize']) && $mkd_options['text_fontsize'] !== '') {
			$text_style[] = 'font-size: '.esc_attr($mkd_options['text_fontsize']).'px';
		}

		if(isset($mkd_options['text_lineheight']) && $mkd_options['text_lineheight'] !== '') {
			$text_style[] = 'line-height: '.esc_attr($mkd_options['text_lineheight']).'px';
		}

		if(isset($mkd_options['text_letter_spacing']) && $mkd_options['text_letter_spacing'] !== '') {
			$text_style[] = 'letter-spacing: '.esc_attr($mkd_options['text_letter_spacing']).'px';
		}

		if(isset($mkd_options['text_fontweight']) && $mkd_options['text_fontweight'] !== '') {
			$text_style[] = 'font-weight: '.esc_attr($mkd_options['text_fontweight']);
		}

		if(isset($mkd_options['text_fontstyle']) && $mkd_options['text_fontstyle'] !== '') {
			$text_style[] = 'font-style: '.esc_attr($mkd_options['text_fontstyle']);
		}

		if(isset($mkd_options['text_text_transform']) && $mkd_options['text_text_transform'] !== '') {
			$text_style[] = 'text-transform: '.esc_attr($mkd_options['text_text_transform']);
		}

		if(isset($mkd_options['text_color']) && $mkd_options['text_color'] !== '') {
			$text_style[] = 'color: '.esc_attr($mkd_options['text_color']);
		}

		if(isset($mkd_options['text_margin']) && $mkd_options['text_margin'] !== '') {
			$text_style[] = 'margin-top: '.esc_attr($mkd_options['text_margin']).'px';
			$text_style[] = 'margin-bottom: '.esc_attr($mkd_options['text_margin']).'px';
		}

		if(is_array($text_style) && count($text_style)) { ?>
            p{
			<?php echo esc_attr(implode(';', $text_style)); ?>
            }
		<?php }  ?>

		<?php if(function_exists('is_woocommerce') && isset($mkd_options['text_color']) && $mkd_options['text_color'] !== ''){ ?>
            .woocommerce .select2-container.orderby .select2-choice,.woocommerce-page .select2-container.orderby .select2-choice,.woocommerce .select2-dropdown-open.select2-drop-above.orderby .select2-choice,.woocommerce .select2-dropdown-open.select2-drop-above.orderby .select2-choices,.woocommerce-page .select2-dropdown-open.select2-drop-above.orderby .select2-choice,.woocommerce-page .select2-dropdown-open.select2-drop-above.orderby .select2-choices, .woocommerce div.cart-collaterals .select2-container .select2-choice,.woocommerce-page div.cart-collaterals .select2-container .select2-choice,.woocommerce .chosen-container.chosen-container-single .chosen-single,.woocommerce-page .chosen-container.chosen-container-single .chosen-single,.woocommerce-checkout .chosen-container.chosen-container-single .chosen-single,.woocommerce select#pa_color,.woocommerce .product .woocommerce-product-rating .woocommerce-review-link,.woocommerce-cart table.cart tbody tr td a,.woocommerce-checkout .checkout table tbody tr td a,.woocommerce table.cart tbody tr span.amount,.woocommerce-page table.cart tbody span.amount,.woocommerce  input[type="text"],.woocommerce-page input[type="text"],.woocommerce  textarea,.woocommerce-page textarea,.woocommerce input[type="password"], .woocommerce-page input[type="password"],.woocommerce form.checkout table.shop_table span.amount,.woocommerce-checkout table.shop_table td span.amount,    .woocommerce-account table.shop_table td span.amount,.woocommerce .widget #searchform input[type='text'],aside.sidebar .widget_product_search form#searchform input#s,.woocommerce .widget #searchsubmit, aside.sidebar .widget_product_search form#searchform input#searchsubmit,.select2-drop,.select2-container-multi .select2-choices .select2-search-choice{
            color: <?php echo esc_attr($mkd_options['text_color']); ?>;
            }
		<?php } ?>


		<?php if (!empty($mkd_options['link_color']) || !empty($mkd_options['link_fontstyle']) || !empty($mkd_options['link_fontweight']) || !empty($mkd_options['link_fontdecoration'])) { ?>
            a, p a{
			<?php if (!empty($mkd_options['link_color'])) { ?>color: <?php echo esc_attr($mkd_options['link_color']);  ?>;<?php } ?>
			<?php if (!empty($mkd_options['link_fontstyle'])) { ?>font-style: <?php echo esc_attr($mkd_options['link_fontstyle']);  ?>;<?php } ?>
			<?php if (!empty($mkd_options['link_fontweight'])) { ?>font-weight: <?php echo esc_attr($mkd_options['link_fontweight']);  ?>;<?php } ?>
			<?php if (!empty($mkd_options['link_fontdecoration'])) { ?>text-decoration: <?php echo esc_attr($mkd_options['link_fontdecoration']);  ?>;<?php } ?>
            }
		<?php } ?>

		<?php if (!empty($mkd_options['link_hovercolor']) || !empty($mkd_options['link_fontdecoration'])) { ?>
            a:hover,
            p a:hover{
			<?php if (!empty($mkd_options['link_hovercolor'])) { ?>color: <?php echo esc_attr($mkd_options['link_hovercolor']);  ?>;<?php } ?>
			<?php if (!empty($mkd_options['link_fontdecoration'])) { ?>text-decoration: <?php echo esc_attr($mkd_options['link_fontdecoration']);  ?>;<?php } ?>
            }
		<?php } ?>

		<?php
		$blockquote_title_style = array();

		if(isset($mkd_options['blockquote_font_family']) && $mkd_options['blockquote_font_family'] !== '-1') {
			$blockquote_title_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blockquote_font_family']).', sans-serif';
		}

		if(isset($mkd_options['blockquote_font_size']) && $mkd_options['blockquote_font_size'] !== '') {
			$blockquote_title_style[] = 'font-size: '.intval($mkd_options['blockquote_font_size']).'px';
		}

		if(isset($mkd_options['blockquote_line_height']) && $mkd_options['blockquote_line_height'] !== '') {
			$blockquote_title_style[] = 'line-height: '.intval($mkd_options['blockquote_line_height']).'px';
		}

		if(isset($mkd_options['blockquote_letter_spacing']) && $mkd_options['blockquote_letter_spacing'] !== '') {
			$blockquote_title_style[] = 'letter-spacing: '.intval($mkd_options['blockquote_letter_spacing']).'px';
		}

		if(isset($mkd_options['blockquote_font_weight']) && $mkd_options['blockquote_font_weight'] !== '') {
			$blockquote_title_style[] = 'font-weight: '.intval($mkd_options['blockquote_font_weight']);
		}

		if(isset($mkd_options['blockquote_font_style']) && $mkd_options['blockquote_font_style'] !== '') {
			$blockquote_title_style[] = 'font-style: '.$mkd_options['blockquote_font_style'];
		}

		if(isset($mkd_options['blockquote_text_transform']) && $mkd_options['blockquote_text_transform'] !== '') {
			$blockquote_title_style[] = 'text-transform: '.$mkd_options['blockquote_text_transform'];
		}

		if(isset($mkd_options['blockquote_color']) && $mkd_options['blockquote_color'] !== '') {
			$blockquote_title_style[] = 'color: '.$mkd_options['blockquote_color'];
		}

		if(is_array($blockquote_title_style) && count($blockquote_title_style)) { ?>
            blockquote .blockquote_text, blockquote > p{
			<?php echo esc_attr(implode(';', $blockquote_title_style)); ?>
            }
		<?php } ?>

		<?php if (!empty($mkd_options['blockquote_background_color']) || !empty($mkd_options['blockquote_border_color'])) { ?>
            blockquote{
			<?php if (!empty($mkd_options['blockquote_border_color'])) { ?>border-color: <?php echo esc_attr($mkd_options['blockquote_border_color']); ?>; <?php } ?>
			<?php if (!empty($mkd_options['blockquote_background_color'])) { ?>background-color: <?php echo esc_attr($mkd_options['blockquote_background_color']); ?>; <?php } ?>
            }
		<?php } ?>

		<?php if(!empty($mkd_options['blockquote_quote_icon_color'])) { ?>
            blockquote.with_quote_icon span.icon_quotations_holder{
            color: <?php echo esc_attr($mkd_options['blockquote_quote_icon_color']); ?>;
            }
		<?php } ?>

		<?php if (!empty($mkd_options['page_title_color']) || !empty($mkd_options['page_title_fontsize']) || !empty($mkd_options['page_title_lineheight']) || !empty($mkd_options['page_title_fontstyle']) || !empty($mkd_options['page_title_fontweight']) || !empty($mkd_options['page_title_texttransform']) || $mkd_options['page_title_google_fonts'] != "-1" || isset($mkd_options['page_title_letter_spacing']) && $mkd_options['page_title_letter_spacing'] !== '') { ?>
            .title h1{
			<?php if (!empty($mkd_options['page_title_color'])) { ?>color: <?php echo esc_attr($mkd_options['page_title_color']);  ?>; <?php } ?>
			<?php if($mkd_options['page_title_google_fonts'] != "-1"){ ?>
                font-family: '<?php echo esc_attr(str_replace('+', ' ', $mkd_options['page_title_google_fonts'])); ?>', sans-serif;
			<?php } ?>
			<?php if (!empty($mkd_options['page_title_fontsize'])) { ?>font-size: <?php echo esc_attr($mkd_options['page_title_fontsize']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['page_title_lineheight'])) { ?>line-height: <?php echo esc_attr($mkd_options['page_title_lineheight']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['page_title_fontstyle'])) { ?>font-style: <?php echo esc_attr($mkd_options['page_title_fontstyle']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['page_title_fontweight'])) { ?>font-weight: <?php echo esc_attr($mkd_options['page_title_fontweight']);  ?>; <?php } ?>
			<?php if ($mkd_options['page_title_letter_spacing'] !== '') { ?>letter-spacing: <?php echo esc_attr($mkd_options['page_title_letter_spacing']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['page_title_texttransform'])) { ?>text-transform: <?php echo esc_attr($mkd_options['page_title_texttransform']);  ?>; <?php } ?>
            }
		<?php } ?>

		<?php if (!empty($mkd_options['page_subtitle_color']) || !empty($mkd_options['page_subtitle_fontsize']) || $mkd_options['page_subtitle_google_fonts'] != "-1" || !empty($mkd_options['page_subtitle_lineheight']) || !empty($mkd_options['page_subtitle_fontstyle']) || !empty($mkd_options['page_subtitle_fontweight']) || !empty($mkd_options['page_subtitle_texttransform']) || $mkd_options['page_subtitle_letter_spacing'] !== '') { ?>
            .subtitle{
			<?php if (!empty($mkd_options['page_subtitle_color'])) { ?>color: <?php echo esc_attr($mkd_options['page_subtitle_color']);  ?>; <?php } ?>
			<?php if($mkd_options['page_subtitle_google_fonts'] != "-1"){ ?>
                font-family: '<?php echo esc_attr(str_replace('+', ' ', $mkd_options['page_subtitle_google_fonts'])); ?>', sans-serif;
			<?php } ?>
			<?php if (!empty($mkd_options['page_subtitle_fontsize'])) { ?>font-size: <?php echo esc_attr($mkd_options['page_subtitle_fontsize']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['page_subtitle_lineheight'])) { ?>line-height: <?php echo esc_attr($mkd_options['page_subtitle_lineheight']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['page_subtitle_fontstyle'])) { ?>font-style: <?php echo esc_attr($mkd_options['page_subtitle_fontstyle']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['page_subtitle_fontweight'])) { ?>font-weight: <?php echo esc_attr($mkd_options['page_subtitle_fontweight']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['page_subtitle_texttransform'])) { ?>text-transform: <?php echo esc_attr($mkd_options['page_subtitle_texttransform']);  ?>; <?php } ?>
			<?php if ($mkd_options['page_subtitle_letter_spacing'] !== '') { ?> letter-spacing: <?php echo esc_attr($mkd_options['page_subtitle_letter_spacing']); ?>px; <?php } ?>
            }
		<?php } ?>

		<?php if (!empty($mkd_options['page_breadcrumb_color']) || !empty($mkd_options['page_breadcrumb_fontsize']) || $mkd_options['page_breadcrumb_google_fonts'] != "-1" || !empty($mkd_options['page_breadcrumb_lineheight']) || !empty($mkd_options['page_breadcrumb_fontstyle']) || !empty($mkd_options['page_breadcrumb_fontweight']) || !empty($mkd_options['page_breadcrumb_texttransform']) || $mkd_options['page_breadcrumb_letter_spacing'] !== '') { ?>
            .breadcrumb a, .breadcrumb span{
			<?php if (!empty($mkd_options['page_breadcrumb_color'])) { ?>color: <?php echo esc_attr($mkd_options['page_breadcrumb_color']);  ?>; <?php } ?>
			<?php if($mkd_options['page_breadcrumb_google_fonts'] !== "-1"){ ?>
                font-family: '<?php echo esc_attr(str_replace('+', ' ', $mkd_options['page_breadcrumb_google_fonts'])); ?>', sans-serif;
			<?php } ?>
			<?php if (!empty($mkd_options['page_breadcrumb_fontsize'])) { ?>font-size: <?php echo esc_attr($mkd_options['page_breadcrumb_fontsize']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['page_breadcrumb_lineheight'])) { ?>line-height: <?php echo esc_attr($mkd_options['page_breadcrumb_lineheight']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['page_breadcrumb_fontstyle'])) { ?>font-style: <?php echo esc_attr($mkd_options['page_breadcrumb_fontstyle']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['page_breadcrumb_fontweight'])) { ?>font-weight: <?php echo esc_attr($mkd_options['page_breadcrumb_fontweight']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['page_breadcrumb_texttransform'])) { ?>text-transform: <?php echo esc_attr($mkd_options['page_breadcrumb_texttransform']);  ?>; <?php } ?>
			<?php if ($mkd_options['page_breadcrumb_letter_spacing'] !== '') { ?> letter-spacing: <?php echo esc_attr($mkd_options['page_breadcrumb_letter_spacing']); ?>px; <?php } ?>
            }
		<?php } ?>

		<?php if (!empty($mkd_options['page_breadcrumb_color'])){ ?>
            .breadcrumb a:hover, .breadcrumb span.current{
            color: <?php echo esc_attr($mkd_options['page_breadcrumb_hovercolor']);  ?>;
            }
		<?php } ?>

		<?php
		/******** BLOG SINGLE: POST INFO AUTHOR STYLES  ********/

		$blog_single_post_info_author_box_style = array();

		if(isset($mkd_options['blog_single_post_author_info_margin_top']) && $mkd_options['blog_single_post_author_info_margin_top'] !== '') {
			$blog_single_post_info_author_box_style[] = 'margin-top: '.intval($mkd_options['blog_single_post_author_info_margin_top']).'px';
		}

		if(isset($mkd_options['blog_single_post_author_info_background_color']) && $mkd_options['blog_single_post_author_info_background_color'] !== '') {
			$blog_single_post_info_author_box_style[] = 'background-color: '.$mkd_options['blog_single_post_author_info_background_color'];
		}

		if(isset($mkd_options['blog_single_post_author_info_border_width']) && $mkd_options['blog_single_post_author_info_border_width'] !== '') {
			$blog_single_post_info_author_box_style[] = 'border-width: '.intval($mkd_options['blog_single_post_author_info_border_width']).'px';
		}

		if(isset($mkd_options['blog_single_post_author_info_border_color']) && $mkd_options['blog_single_post_author_info_border_color'] !== '') {
			$blog_single_post_info_author_box_style[] = 'border-color: '.$mkd_options['blog_single_post_author_info_border_color'];
		}

		if(isset($mkd_options['blog_single_post_author_info_padding_top']) && $mkd_options['blog_single_post_author_info_padding_top'] !== '') {
			$blog_single_post_info_author_box_style[] = 'padding-top: '.intval($mkd_options['blog_single_post_author_info_padding_top']).'px';
		}

		if(isset($mkd_options['blog_single_post_author_info_padding_bottom']) && $mkd_options['blog_single_post_author_info_padding_bottom'] !== '') {
			$blog_single_post_info_author_box_style[] = 'padding-bottom: '.intval($mkd_options['blog_single_post_author_info_padding_bottom']).'px';
		}

		if(isset($mkd_options['blog_single_post_author_info_padding_left']) && $mkd_options['blog_single_post_author_info_padding_left'] !== '') {
			$blog_single_post_info_author_box_style[] = 'padding-left: '.intval($mkd_options['blog_single_post_author_info_padding_left']).'px';
		}

		if(isset($mkd_options['blog_single_post_author_info_padding_right']) && $mkd_options['blog_single_post_author_info_padding_right'] !== '') {
			$blog_single_post_info_author_box_style[] = 'padding-right: '.intval($mkd_options['blog_single_post_author_info_padding_right']).'px';
		}

		if(is_array($blog_single_post_info_author_box_style) && count($blog_single_post_info_author_box_style)) { ?>
            .blog_holder.blog_single .author_description{
			<?php echo esc_attr(implode(';', $blog_single_post_info_author_box_style)); ?>
            }
		<?php } ?>

		<?php
		/**************** BLOG SINGLE: POST INFO AUTHOR STYLES: Title Style ****************/
		$blog_single_post_info_author_title_style = array();

		if(isset($mkd_options['blog_single_post_author_info_title_font_family']) && $mkd_options['blog_single_post_author_info_title_font_family'] !== '-1') {
			$blog_single_post_info_author_title_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_single_post_author_info_title_font_family']).', sans-serif';
		}

		if(isset($mkd_options['blog_single_post_author_info_title_fontsize']) && $mkd_options['blog_single_post_author_info_title_fontsize'] !== '') {
			$blog_single_post_info_author_title_style[] = 'font-size: '.intval($mkd_options['blog_single_post_author_info_title_fontsize']).'px';
		}

		if(isset($mkd_options['blog_single_post_author_info_title_lineheight']) && $mkd_options['blog_single_post_author_info_title_lineheight'] !== '') {
			$blog_single_post_info_author_title_style[] = 'line-height: '.intval($mkd_options['blog_single_post_author_info_title_lineheight']).'px';
		}

		if(isset($mkd_options['blog_single_post_author_info_title_letterspacing']) && $mkd_options['blog_single_post_author_info_title_letterspacing'] !== '') {
			$blog_single_post_info_author_title_style[] = 'letter-spacing: '.intval($mkd_options['blog_single_post_author_info_title_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_single_post_author_info_title_fontweight']) && $mkd_options['blog_single_post_author_info_title_fontweight'] !== '') {
			$blog_single_post_info_author_title_style[] = 'font-weight: '.intval($mkd_options['blog_single_post_author_info_title_fontweight']);
		}

		if(isset($mkd_options['blog_single_post_author_info_title_fontstyle']) && $mkd_options['blog_single_post_author_info_title_fontstyle'] !== '') {
			$blog_single_post_info_author_title_style[] = 'font-style: '.$mkd_options['blog_single_post_author_info_title_fontstyle'];
		}

		if(isset($mkd_options['blog_single_post_author_info_title_texttransform']) && $mkd_options['blog_single_post_author_info_title_texttransform'] !== '') {
			$blog_single_post_info_author_title_style[] = 'text-transform: '.$mkd_options['blog_single_post_author_info_title_texttransform'];
		}

		if(isset($mkd_options['blog_single_post_author_info_title_color']) && $mkd_options['blog_single_post_author_info_title_color'] !== ''){
			$blog_single_post_info_author_title_style[] = 'color: '.$mkd_options['blog_single_post_author_info_title_color'];
		}

		if(isset($mkd_options['blog_single_post_author_info_title_margin_bottom']) && $mkd_options['blog_single_post_author_info_title_margin_bottom'] !== '') {
			$blog_single_post_info_author_title_style[] = 'margin-bottom: '.intval($mkd_options['blog_single_post_author_info_title_margin_bottom']).'px';
		}

		if(is_array($blog_single_post_info_author_title_style) && count($blog_single_post_info_author_title_style)) { ?>
            .blog_holder.blog_single .author_description .author_text_holder .author_name{
			<?php echo esc_attr(implode(';', $blog_single_post_info_author_title_style)); ?>
            }
		<?php } ?>

		<?php
		/**************** BLOG SINGLE: POST INFO AUTHOR STYLES: Text Style ****************/
		$blog_single_post_info_author_text_style = array();

		if(isset($mkd_options['blog_single_post_author_info_text_font_family']) && $mkd_options['blog_single_post_author_info_text_font_family'] !== '-1') {
			$blog_single_post_info_author_text_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_single_post_author_info_text_font_family']).', sans-serif';
		}

		if(isset($mkd_options['blog_single_post_author_info_text_fontsize']) && $mkd_options['blog_single_post_author_info_text_fontsize'] !== '') {
			$blog_single_post_info_author_text_style[] = 'font-size: '.intval($mkd_options['blog_single_post_author_info_text_fontsize']).'px';
		}

		if(isset($mkd_options['blog_single_post_author_info_text_lineheight']) && $mkd_options['blog_single_post_author_info_text_lineheight'] !== '') {
			$blog_single_post_info_author_text_style[] = 'line-height: '.intval($mkd_options['blog_single_post_author_info_text_lineheight']).'px';
		}

		if(isset($mkd_options['blog_single_post_author_info_text_letterspacing']) && $mkd_options['blog_single_post_author_info_text_letterspacing'] !== '') {
			$blog_single_post_info_author_text_style[] = 'letter-spacing: '.intval($mkd_options['blog_single_post_author_info_text_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_single_post_author_info_text_fontweight']) && $mkd_options['blog_single_post_author_info_text_fontweight'] !== '') {
			$blog_single_post_info_author_text_style[] = 'font-weight: '.intval($mkd_options['blog_single_post_author_info_text_fontweight']);
		}

		if(isset($mkd_options['blog_single_post_author_info_text_fontstyle']) && $mkd_options['blog_single_post_author_info_text_fontstyle'] !== '') {
			$blog_single_post_info_author_text_style[] = 'font-style: '.$mkd_options['blog_single_post_author_info_text_fontstyle'];
		}

		if(isset($mkd_options['blog_single_post_author_info_text_texttransform']) && $mkd_options['blog_single_post_author_info_text_texttransform'] !== '') {
			$blog_single_post_info_author_text_style[] = 'text-transform: '.intval($mkd_options['blog_single_post_author_info_text_texttransform']);
		}

		if(isset($mkd_options['blog_single_post_author_info_text_color']) && $mkd_options['blog_single_post_author_info_text_color'] !== ''){
			$blog_single_post_info_author_text_style[] = 'color: '.$mkd_options['blog_single_post_author_info_text_color'];
		}

		if(is_array($blog_single_post_info_author_text_style) && count($blog_single_post_info_author_text_style)) { ?>
            .blog_holder.blog_single .author_description .author_text_holder .author_email,
            .blog_holder.blog_single .author_description .author_text_holder .author_text{
			<?php echo esc_attr(implode(';', $blog_single_post_info_author_text_style)); ?>
            }
		<?php } ?>

		<?php
		/******** BLOG SINGLE: POST INFO COMMENTS STYLES  ********/

		$blog_single_post_comments_box_style = array();

		if(isset($mkd_options['blog_single_post_comments_margin_top']) && $mkd_options['blog_single_post_comments_margin_top'] !== '') {
			$blog_single_post_info_author_box_style[] = 'margin-top: '.intval($mkd_options['blog_single_post_comments_margin_top']).'px';
		}

		if(isset($mkd_options['blog_single_post_comments_background_color']) && $mkd_options['blog_single_post_comments_background_color'] !== '') {
			$blog_single_post_comments_box_style[] = 'background-color: '.$mkd_options['blog_single_post_comments_background_color'];
		}

		if(isset($mkd_options['blog_single_post_comments_border_width']) && $mkd_options['blog_single_post_comments_border_width'] !== '') {
			$blog_single_post_comments_box_style[] = 'border-width: '.intval($mkd_options['blog_single_post_comments_border_width']).'px';
		}

		if(isset($mkd_options['blog_single_post_comments_border_color']) && $mkd_options['blog_single_post_comments_border_color'] !== '') {
			$blog_single_post_comments_box_style[] = 'border-color: '.$mkd_options['blog_single_post_comments_border_color'];
		}

		if(isset($mkd_options['blog_single_post_comments_padding_top']) && $mkd_options['blog_single_post_comments_padding_top'] !== '') {
			$blog_single_post_comments_box_style[] = 'padding-top: '.intval($mkd_options['blog_single_post_comments_padding_top']).'px';
		}

		if(isset($mkd_options['blog_single_post_comments_padding_bottom']) && $mkd_options['blog_single_post_comments_padding_bottom'] !== '') {
			$blog_single_post_comments_box_style[] = 'padding-bottom: '.intval($mkd_options['blog_single_post_comments_padding_bottom']).'px';
		}

		if(isset($mkd_options['blog_single_post_comments_padding_left']) && $mkd_options['blog_single_post_comments_padding_left'] !== '') {
			$blog_single_post_comments_box_style[] = 'padding-left: '.intval($mkd_options['blog_single_post_comments_padding_left']).'px';
		}

		if(isset($mkd_options['blog_single_post_comments_padding_right']) && $mkd_options['blog_single_post_comments_padding_right'] !== '') {
			$blog_single_post_comments_box_style[] = 'padding-right: '.intval($mkd_options['blog_single_post_comments_padding_right']).'px';
		}

		if(is_array($blog_single_post_comments_box_style) && count($blog_single_post_comments_box_style)) { ?>
            .single-post .comment_holder .comments .comment{
			<?php echo esc_attr(implode(';', $blog_single_post_comments_box_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_single_post_comments_title_color']) && $mkd_options['blog_single_post_comments_title_color'] !== '') { ?>
            .single-post .comment_holder .comments .comment .text .name,
            .single-post .comment_holder .comments .comment .text .name a{
            color: <?php echo esc_attr($mkd_options['blog_single_post_comments_title_color']) ; ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_single_post_comments_text_color']) && $mkd_options['blog_single_post_comments_text_color'] !== '') { ?>
            .single-post .comment_holder .comments .comment .text .text_holder,
            .single-post .comment_holder .comments .comment .text .text_holder p{
            color: <?php echo esc_attr($mkd_options['blog_single_post_comments_text_color']) ; ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_single_post_comments_link_color']) && $mkd_options['blog_single_post_comments_link_color'] !== '') { ?>
            .single-post .comment_holder .comments .comment .text .comment-reply-link,
            .single-post .comment_holder .comments .comment .text .replay,
            .single-post .comment_holder .comments .comment .text .comment-edit-link{
            color: <?php echo esc_attr($mkd_options['blog_single_post_comments_link_color']) ; ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_single_post_comments_date_color']) && $mkd_options['blog_single_post_comments_date_color'] !== '') { ?>
            .single-post .comment_holder .comments .comment .text .comment_date{
            color: <?php echo esc_attr($mkd_options['blog_single_post_comments_date_color']) ; ?>
            }
		<?php } ?>

		<?php
		/******** BLOG: DATE IN TITLE Share options ********/
		if(isset($mkd_options['blog_date_in_title_show_share']) && $mkd_options['blog_date_in_title_show_share'] == 'yes') {

			if(isset($mkd_options['blog_date_in_title_share_icon_color']) && $mkd_options['blog_date_in_title_share_icon_color'] !== '') {?>
                .blog_holder.blog_date_in_title article .post_text .post_text_inner .post_info .blog_share .social_share_dropdown ul li .social_network_icon,
                .blog_holder.blog_date_in_title article.format-link .post_text.link_image .post_text_inner:hover .post_info .social_share_dropdown ul li span.social_network_icon{
                color:  <?php echo esc_attr($mkd_options['blog_date_in_title_share_icon_color']); ?> ;
                }
			<?php } ?>
			<?php if(isset($mkd_options['blog_date_in_title_share_background_color']) && $mkd_options['blog_date_in_title_share_background_color'] !== '') {?>
                .blog_holder.blog_date_in_title article .post_text .post_text_inner .post_info .blog_share .social_share_dropdown ul li a{
                background-color:  <?php echo esc_attr($mkd_options['blog_date_in_title_share_background_color']); ?> ;
                }
			<?php } ?>
			<?php if(isset($mkd_options['blog_date_in_title_share_icon_hover_color']) && $mkd_options['blog_date_in_title_share_icon_hover_color'] !== '') {?>
                .blog_holder.blog_date_in_title .social_share_dropdown ul li:hover,
                .blog_holder.blog_date_in_title .social_share_dropdown ul li:hover a span.social_network_icon{
                color:  <?php echo esc_attr($mkd_options['blog_date_in_title_share_icon_hover_color']); ?> !important;
                }
			<?php } ?>
		<?php } ?>


		<?php
		/******** BLOG: DATE IN TITLE Text Box ********/
		if(isset($mkd_options['blog_date_in_title_enable_text_box']) && $mkd_options['blog_date_in_title_enable_text_box'] == 'yes') {
			$blog_box_style = array();
			?>
            .blog_holder.blog_date_in_title article .audio_image,
            .blog_holder.blog_date_in_title article:not(.format-audio) .post_image{
            margin-bottom: 0;
            }
			<?php
			if(isset($mkd_options['blog_date_in_title_box_background_color']) && $mkd_options['blog_date_in_title_box_background_color'] !== '') {
				$blog_box_style[] = 'background-color: '.$mkd_options['blog_date_in_title_box_background_color'];
			}

			if(isset($mkd_options['blog_date_in_title_box_border_color']) && $mkd_options['blog_date_in_title_box_border_color'] !== '') {
				$blog_box_style[] = 'border: 1px solid';
				$blog_box_style[] = 'border-color: '.$mkd_options['blog_date_in_title_box_border_color'];
			}

			if(isset($mkd_options['blog_date_in_title_box_padding']) && $mkd_options['blog_date_in_title_box_padding'] !== '') {
				$blog_box_style[] = 'padding: '.$mkd_options['blog_date_in_title_box_padding'];
			}

			if(is_array($blog_box_style) && count($blog_box_style)) { ?>
                .blog_holder.blog_date_in_title article:not(.format-link):not(.format-quote) .post_text .post_text_inner{
				<?php echo esc_attr(implode(';', $blog_box_style)); ?>
                }
			<?php }} ?>

		<?php
		/******** BLOG: DATE IN TITLE Quote/Link Text Box ********/
		if(isset($mkd_options['blog_date_in_title_ql_background_color']) &&($mkd_options['blog_date_in_title_ql_background_color'])!==""){ ?>
            .blog_holder.blog_date_in_title article.format-link .post_text .post_text_inner,
            .blog_holder.blog_date_in_title article.format-quote .post_text .post_text_inner{
            background-color: <?php echo esc_attr($mkd_options['blog_date_in_title_ql_background_color']);  ?>;
            }
			<?php  $blog_date_in_title_ql_background_color = mikado_one_mikado_hex2rgb($mkd_options['blog_date_in_title_ql_background_color']); ?>

            .blog_holder.blog_date_in_title article.format-link .post_text.link_image .post_text_inner,
            .blog_holder.blog_date_in_title article.format-quote .post_text.quote_image .post_text_inner{
			<?php if (!empty($mkd_options['blog_date_in_title_ql_background_color'])) { ?>  background-color: rgba(<?php echo esc_attr($blog_date_in_title_ql_background_color[0]); ?>,<?php echo esc_attr($blog_date_in_title_ql_background_color[1]); ?>,<?php echo esc_attr($blog_date_in_title_ql_background_color[2]); ?>,0.85); <?php } ?>
            }

		<?php } ?>

		<?php if(isset($mkd_options['blog_date_in_title_ql_hover_background_color']) && !empty($mkd_options['blog_date_in_title_ql_hover_background_color'])){ ?>
            .blog_holder.blog_date_in_title article.format-link .post_text .post_text_inner:hover,
            .blog_holder.blog_date_in_title article.format-quote .post_text .post_text_inner:hover{
            background-color: <?php echo esc_attr($mkd_options['blog_date_in_title_ql_hover_background_color']);  ?>;
            }
			<?php  $blog_date_in_title_ql_hover_background_color = mikado_one_mikado_hex2rgb($mkd_options['blog_date_in_title_ql_hover_background_color']); ?>

            .blog_holder.blog_date_in_title article.format-link .post_text.link_image .post_text_inner:hover,
            .blog_holder.blog_date_in_title article.format-quote .post_text.quote_image .post_text_inner:hover{
			<?php if (!empty($mkd_options['blog_date_in_title_ql_hover_background_color'])) { ?>  background-color: rgba(<?php echo esc_attr($blog_date_in_title_ql_hover_background_color[0]); ?>,<?php echo esc_attr($blog_date_in_title_ql_hover_background_color[1]); ?>,<?php echo esc_attr($blog_date_in_title_ql_hover_background_color[2]); ?>,0.6); <?php } ?>
            }

		<?php } ?>

		<?php
		/**************** BLOG DATE IN TITLE: Spacing  ****************/
		if(isset($mkd_options['blog_date_in_title_image_margin_bottom']) && $mkd_options['blog_date_in_title_image_margin_bottom'] !== '') { ?>
            .blog_holder.blog_date_in_title article:not(.format-audio) .post_image,
            .blog_holder.blog_date_in_title article .audio_image{
            margin-bottom : <?php echo esc_attr($mkd_options['blog_date_in_title_image_margin_bottom']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_date_in_title_title_margin_bottom']) && $mkd_options['blog_date_in_title_title_margin_bottom'] !== '') { ?>
            .blog_holder.blog_date_in_title article h2{
            padding-bottom : <?php echo esc_attr($mkd_options['blog_date_in_title_title_margin_bottom']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_date_in_title_post_info_margin_top']) && $mkd_options['blog_date_in_title_post_info_margin_top'] !== '') { ?>
            .blog_holder.blog_date_in_title article:not(.format-link):not(.format-quote) .post_info{
            margin-top : <?php echo esc_attr($mkd_options['blog_date_in_title_post_info_margin_top']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_date_in_title_article_margin_bottom']) && $mkd_options['blog_date_in_title_article_margin_bottom'] !== '') { ?>
            .blog_holder.blog_date_in_title:not(.blog_single) article{
            margin-bottom : <?php echo esc_attr($mkd_options['blog_date_in_title_article_margin_bottom']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_date_in_title_ql_quote_author_margin_top']) && $mkd_options['blog_date_in_title_ql_quote_author_margin_top'] !== '') { ?>
            .blog_holder.blog_date_in_title article.format-quote .post_text .quote_author{
            margin-top : <?php echo esc_attr($mkd_options['blog_date_in_title_ql_quote_author_margin_top']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_date_in_title_ql_post_info_margin_top']) && $mkd_options['blog_date_in_title_ql_post_info_margin_top'] !== '') { ?>
            .blog_holder.blog_date_in_title article.format-link .post_info,
            .blog_holder.blog_date_in_title article.format-quote .post_info{
            margin-top : <?php echo esc_attr($mkd_options['blog_date_in_title_ql_post_info_margin_top']).'px';?>
            }
		<?php } ?>

		<?php
		/**************** BLOG DATE IN TITLE: Title Style ****************/
		$blog_date_in_title_title_style = array();

		if(isset($mkd_options['blog_date_in_title_title_google_fonts']) && $mkd_options['blog_date_in_title_title_google_fonts'] !== '-1') {
			$blog_date_in_title_title_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_date_in_title_title_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_date_in_title_title_fontsize']) && $mkd_options['blog_date_in_title_title_fontsize'] !== '') {
			$blog_date_in_title_title_style[] = 'font-size: '.intval($mkd_options['blog_date_in_title_title_fontsize']).'px';
		}

		if(isset($mkd_options['blog_date_in_title_title_lineheight']) && $mkd_options['blog_date_in_title_title_lineheight'] !== '') {
			$blog_date_in_title_title_style[] = 'line-height: '.intval($mkd_options['blog_date_in_title_title_lineheight']).'px';
		}

		if(isset($mkd_options['blog_date_in_title_title_letterspacing']) && $mkd_options['blog_date_in_title_title_letterspacing'] !== '') {
			$blog_date_in_title_title_style[] = 'letter-spacing: '.intval($mkd_options['blog_date_in_title_title_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_date_in_title_title_fontweight']) && $mkd_options['blog_date_in_title_title_fontweight'] !== '') {
			$blog_date_in_title_title_style[] = 'font-weight: '.intval($mkd_options['blog_date_in_title_title_fontweight']);
		}

		if(isset($mkd_options['blog_date_in_title_title_fontstyle']) && $mkd_options['blog_date_in_title_title_fontstyle'] !== '') {
			$blog_date_in_title_title_style[] = 'font-style: '.$mkd_options['blog_date_in_title_title_fontstyle'];
		}

		if(isset($mkd_options['blog_date_in_title_title_texttransform']) && $mkd_options['blog_date_in_title_title_texttransform'] !== '') {
			$blog_date_in_title_title_style[] = 'text-transform: '.$mkd_options['blog_date_in_title_title_texttransform'];
		}

		if(is_array($blog_date_in_title_title_style) && count($blog_date_in_title_title_style)) { ?>
            .blog_holder.blog_date_in_title article:not(.format-quote):not(.format-link) h2{
			<?php echo esc_attr(implode(';', $blog_date_in_title_title_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_date_in_title_title_color']) && !empty($mkd_options['blog_date_in_title_title_color'])){ ?>
            .blog_holder.blog_date_in_title article:not(.format-quote):not(.format-link) h2 a,
            .blog_holder.blog_date_in_title.blog_single article:not(.format-quote):not(.format-link) h2{
            color: <?php echo esc_attr($mkd_options['blog_date_in_title_title_color']);  ?>;
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_date_in_title_title_date_color']) && !empty($mkd_options['blog_date_in_title_title_date_color'])){ ?>
            .blog_holder.blog_date_in_title article:not(.format-quote):not(.format-link) h2 .date{
            color: <?php echo esc_attr($mkd_options['blog_date_in_title_title_date_color']);  ?>;
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_date_in_title_title_hover_color']) && !empty($mkd_options['blog_date_in_title_title_hover_color'])){ ?>
            .blog_holder.blog_date_in_title article:not(.format-quote):not(.format-link) h2 a:hover,
            .blog_holder.blog_date_in_title.blog_single article:not(.format-quote):not(.format-link) h2:hover{
            color: <?php echo esc_attr($mkd_options['blog_date_in_title_title_hover_color']);  ?>;
            }
		<?php } ?>

		<?php
		/**************** BLOG DATE IN TITLE: Qoute/Link Title Style ****************/
		$blog_date_in_title_ql_title_style = array();

		if(isset($mkd_options['blog_date_in_title_ql_title_google_fonts']) && $mkd_options['blog_date_in_title_ql_title_google_fonts'] !== '-1') {
			$blog_date_in_title_ql_title_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_date_in_title_ql_title_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_date_in_title_ql_title_fontsize']) && $mkd_options['blog_date_in_title_ql_title_fontsize'] !== '') {
			$blog_date_in_title_ql_title_style[] = 'font-size: '.intval($mkd_options['blog_date_in_title_ql_title_fontsize']).'px';
		}

		if(isset($mkd_options['blog_date_in_title_ql_title_lineheight']) && $mkd_options['blog_date_in_title_ql_title_lineheight'] !== '') {
			$blog_date_in_title_ql_title_style[] = 'line-height: '.intval($mkd_options['blog_date_in_title_ql_title_lineheight']).'px';
		}

		if(isset($mkd_options['blog_date_in_title_ql_title_letterspacing']) && $mkd_options['blog_date_in_title_ql_title_letterspacing'] !== '') {
			$blog_date_in_title_ql_title_style[] = 'letter-spacing: '.intval($mkd_options['blog_date_in_title_ql_title_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_date_in_title_ql_title_fontweight']) && $mkd_options['blog_date_in_title_ql_title_fontweight'] !== '') {
			$blog_date_in_title_ql_title_style[] = 'font-weight: '.intval($mkd_options['blog_date_in_title_ql_title_fontweight']);
		}

		if(isset($mkd_options['blog_date_in_title_ql_title_fontstyle']) && $mkd_options['blog_date_in_title_ql_title_fontstyle'] !== '') {
			$blog_date_in_title_ql_title_style[] = 'font-style: '.$mkd_options['blog_date_in_title_ql_title_fontstyle'];
		}

		if(isset($mkd_options['blog_date_in_title_ql_title_texttransform']) && $mkd_options['blog_date_in_title_ql_title_texttransform'] !== '') {
			$blog_date_in_title_ql_title_style[] = 'text-transform: '.$mkd_options['blog_date_in_title_ql_title_texttransform'];
		}

		if(is_array($blog_date_in_title_ql_title_style) && count($blog_date_in_title_ql_title_style)) { ?>
            .blog_holder.blog_date_in_title article.format-quote .post_text .post_title h3,
            .blog_holder.blog_date_in_title article.format-link .post_text .post_title h3{
			<?php echo esc_attr(implode(';', $blog_date_in_title_ql_title_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_date_in_title_ql_title_color']) && !empty($mkd_options['blog_date_in_title_ql_title_color'])){ ?>
            .blog_holder.blog_date_in_title article.format-quote .post_text .post_title h3 a,
            .blog_holder.blog_date_in_title article.format-link .post_text .post_title h3 a,
            .blog_holder.blog_date_in_title article.format-quote .post_text .post_title h3,
            .blog_holder.blog_date_in_title article.format-link .post_text .post_title h3
            {
            color: <?php echo esc_attr($mkd_options['blog_date_in_title_ql_title_color']);  ?>;
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_date_in_title_ql_title_date_color']) && !empty($mkd_options['blog_date_in_title_ql_title_date_color'])){ ?>
            .blog_holder.blog_date_in_title article.format-quote .post_text .post_title h3 .date,
            .blog_holder.blog_date_in_title article.format-link .post_text .post_title h3 .date{
            color: <?php echo esc_attr($mkd_options['blog_date_in_title_ql_title_date_color']);  ?>;
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_date_in_title_ql_title_hover_color']) && !empty($mkd_options['blog_date_in_title_ql_title_hover_color'])){ ?>
            .blog_holder.blog_date_in_title article.format-quote .post_text .post_text_inner:hover .post_title h3 a,
            .blog_holder.blog_date_in_title article.format-link .post_text .post_text_inner:hover .post_title h3 a,
            .blog_holder.blog_date_in_title article.format-quote .post_text .post_text_inner:hover .post_title h3,
            .blog_holder.blog_date_in_title article.format-link .post_text .post_text_inner:hover .post_title h3,
            .blog_holder.blog_date_in_title article.format-quote .post_text .post_text_inner:hover .post_title h3 .date,
            .blog_holder.blog_date_in_title article.format-link .post_text .post_text_inner:hover .post_title h3 .date{
            color: <?php echo esc_attr($mkd_options['blog_date_in_title_ql_title_hover_color']);  ?>;
            }
		<?php } ?>
		<?php
		/**************** BLOG DATE IN TITLE: Qoute Author Style ****************/
		$blog_date_in_title_ql_author_style = array();

		if(isset($mkd_options['blog_date_in_title_ql_author_google_fonts']) && $mkd_options['blog_date_in_title_ql_author_google_fonts'] !== '-1') {
			$blog_date_in_title_ql_author_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_date_in_title_ql_author_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_date_in_title_ql_author_fontsize']) && $mkd_options['blog_date_in_title_ql_author_fontsize'] !== '') {
			$blog_date_in_title_ql_author_style[] = 'font-size: '.intval($mkd_options['blog_date_in_title_ql_author_fontsize']).'px';
		}

		if(isset($mkd_options['blog_date_in_title_ql_author_lineheight']) && $mkd_options['blog_date_in_title_ql_author_lineheight'] !== '') {
			$blog_date_in_title_ql_author_style[] = 'line-height: '.intval($mkd_options['blog_date_in_title_ql_author_lineheight']).'px';
		}

		if(isset($mkd_options['blog_date_in_title_ql_author_letterspacing']) && $mkd_options['blog_date_in_title_ql_author_letterspacing'] !== '') {
			$blog_date_in_title_ql_author_style[] = 'letter-spacing: '.intval($mkd_options['blog_date_in_title_ql_author_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_date_in_title_ql_author_fontweight']) && $mkd_options['blog_date_in_title_ql_author_fontweight'] !== '') {
			$blog_date_in_title_ql_author_style[] = 'font-weight: '.intval($mkd_options['blog_date_in_title_ql_author_fontweight']);
		}

		if(isset($mkd_options['blog_date_in_title_ql_author_fontstyle']) && $mkd_options['blog_date_in_title_ql_author_fontstyle'] !== '') {
			$blog_date_in_title_ql_author_style[] = 'font-style: '.$mkd_options['blog_date_in_title_ql_author_fontstyle'];
		}

		if(isset($mkd_options['blog_date_in_title_ql_author_texttransform']) && $mkd_options['blog_date_in_title_ql_author_texttransform'] !== '') {
			$blog_date_in_title_ql_author_style[] = 'text-transform: '.$mkd_options['blog_date_in_title_ql_author_texttransform'];
		}

		if(is_array($blog_date_in_title_ql_author_style) && count($blog_date_in_title_ql_author_style)) { ?>
            .blog_holder.blog_date_in_title article.format-quote .post_text .quote_author{
			<?php echo esc_attr(implode(';', $blog_date_in_title_ql_author_style)); ?>
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_date_in_title_ql_author_color']) && !empty($mkd_options['blog_date_in_title_ql_author_color'])){ ?>
            .blog_holder.blog_date_in_title article.format-quote .post_text .quote_author{
            color: <?php echo esc_attr($mkd_options['blog_date_in_title_ql_author_color']);  ?>;
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_date_in_title_ql_author_hover_color']) && !empty($mkd_options['blog_date_in_title_ql_author_hover_color'])){ ?>
            .blog_holder.blog_date_in_title article.format-quote .post_text .post_text_inner:hover .quote_author{
            color: <?php echo esc_attr($mkd_options['blog_date_in_title_ql_author_hover_color']);  ?>;
            }
		<?php } ?>
		<?php
		/**************** BLOG DATE IN TITLE: Info Style ****************/
		$blog_date_in_title_info_style = array();

		if(isset($mkd_options['blog_date_in_title_info_google_fonts']) && $mkd_options['blog_date_in_title_info_google_fonts'] !== '-1') {
			$blog_date_in_title_info_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_date_in_title_info_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_date_in_title_info_fontsize']) && $mkd_options['blog_date_in_title_info_fontsize'] !== '') {
			$blog_date_in_title_info_style[] = 'font-size: '.intval($mkd_options['blog_date_in_title_info_fontsize']).'px';
		}

		if(isset($mkd_options['blog_date_in_title_info_lineheight']) && $mkd_options['blog_date_in_title_info_lineheight'] !== '') {
			$blog_date_in_title_info_style[] = 'line-height: '.intval($mkd_options['blog_date_in_title_info_lineheight']).'px';
		}

		if(isset($mkd_options['blog_date_in_title_info_letterspacing']) && $mkd_options['blog_date_in_title_info_letterspacing'] !== '') {
			$blog_date_in_title_info_style[] = 'letter-spacing: '.intval($mkd_options['blog_date_in_title_info_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_date_in_title_info_fontweight']) && $mkd_options['blog_date_in_title_info_fontweight'] !== '') {
			$blog_date_in_title_info_style[] = 'font-weight: '.intval($mkd_options['blog_date_in_title_info_fontweight']);
		}

		if(isset($mkd_options['blog_date_in_title_info_fontstyle']) && $mkd_options['blog_date_in_title_info_fontstyle'] !== '') {
			$blog_date_in_title_info_style[] = 'font-style: '.$mkd_options['blog_date_in_title_info_fontstyle'];
		}

		if(isset($mkd_options['blog_date_in_title_info_texttransform']) && $mkd_options['blog_date_in_title_info_texttransform'] !== '') {
			$blog_date_in_title_info_style[] = 'text-transform: '.$mkd_options['blog_date_in_title_info_texttransform'];
		}
		if(is_array($blog_date_in_title_info_style) && count($blog_date_in_title_info_style)) { ?>

            .blog_holder.blog_date_in_title article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info div{
			<?php echo esc_attr(implode(';', $blog_date_in_title_info_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_date_in_title_info_border_color']) && !empty($mkd_options['blog_date_in_title_info_border_color'])){ ?>
            .blog_holder.blog_date_in_title article .post_info{
            border-color: <?php echo esc_attr($mkd_options['blog_date_in_title_info_border_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_date_in_title_info_color']) && !empty($mkd_options['blog_date_in_title_info_color'])){ ?>
            .blog_holder.blog_date_in_title article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info{
            color: <?php echo esc_attr($mkd_options['blog_date_in_title_info_color']);  ?>;
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_date_in_title_info_link_color']) && !empty($mkd_options['blog_date_in_title_info_link_color'])){ ?>
            .blog_holder.blog_date_in_title article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info a{
            color: <?php echo esc_attr($mkd_options['blog_date_in_title_info_link_color']);  ?>;
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_date_in_title_info_hover_color']) && !empty($mkd_options['blog_date_in_title_info_hover_color'])){ ?>

            .blog_holder.blog_date_in_title article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info:hover div a:hover{
            color: <?php echo esc_attr($mkd_options['blog_date_in_title_info_hover_color']);  ?>;
            }
		<?php } ?>


		<?php
		/****************  BLOG DATE IN TITLE: Quote/Link Post Info Style *********************/
		$blog_date_in_title_ql_info_style = array();

		if(isset($mkd_options['blog_date_in_title_ql_info_google_fonts']) && $mkd_options['blog_date_in_title_ql_info_google_fonts'] !== '-1') {
			$blog_date_in_title_ql_info_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_date_in_title_ql_info_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_date_in_title_ql_info_fontsize']) && $mkd_options['blog_date_in_title_ql_info_fontsize'] !== '') {
			$blog_date_in_title_ql_info_style[] = 'font-size: '.intval($mkd_options['blog_date_in_title_ql_info_fontsize']).'px';
		}

		if(isset($mkd_options['blog_date_in_title_ql_info_lineheight']) && $mkd_options['blog_date_in_title_ql_info_lineheight'] !== '') {
			$blog_date_in_title_ql_info_style[] = 'line-height: '.intval($mkd_options['blog_date_in_title_ql_info_lineheight']).'px';
		}

		if(isset($mkd_options['blog_date_in_title_ql_info_letterspacing']) && $mkd_options['blog_date_in_title_ql_info_letterspacing'] !== '') {
			$blog_date_in_title_ql_info_style[] = 'letter-spacing: '.intval($mkd_options['blog_date_in_title_ql_info_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_date_in_title_ql_info_fontweight']) && $mkd_options['blog_date_in_title_ql_info_fontweight'] !== '') {
			$blog_date_in_title_ql_info_style[] = 'font-weight: '.intval($mkd_options['blog_date_in_title_ql_info_fontweight']);
		}

		if(isset($mkd_options['blog_date_in_title_ql_info_fontstyle']) && $mkd_options['blog_date_in_title_ql_info_fontstyle'] !== '') {
			$blog_date_in_title_ql_info_style[] = 'font-style: '.$mkd_options['blog_date_in_title_ql_info_fontstyle'];
		}

		if(isset($mkd_options['blog_date_in_title_ql_info_texttransform']) && $mkd_options['blog_date_in_title_ql_info_texttransform'] !== '') {
			$blog_date_in_title_ql_info_style[] = 'text-transform: '.$mkd_options['blog_date_in_title_ql_info_texttransform'];
		}
		if(is_array($blog_date_in_title_ql_info_style) && count($blog_date_in_title_ql_info_style)) { ?>
            .blog_holder.blog_date_in_title article.format-quote .post_text .post_text_inner .post_info div,
            .blog_holder.blog_date_in_title article.format-link .post_text .post_text_inner .post_info div{
			<?php echo esc_attr(implode(';', $blog_date_in_title_ql_info_style)); ?>
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_date_in_title_ql_info_border_color']) && !empty($mkd_options['blog_date_in_title_ql_info_border_color'])){ ?>
            .blog_holder.blog_date_in_title article.format-quote .post_text .post_info,
            .blog_holder.blog_date_in_title article.format-link .post_text .post_info
            {
            border-color: <?php echo esc_attr($mkd_options['blog_date_in_title_ql_info_border_color']);  ?>;
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_date_in_title_ql_info_border_hover_color']) && !empty($mkd_options['blog_date_in_title_ql_info_border_hover_color'])){ ?>
            .blog_holder.blog_date_in_title article.format-quote .post_text .post_text_inner:hover .post_info,
            .blog_holder.blog_date_in_title article.format-link .post_text .post_text_inner:hover .post_info
            {
            border-color: <?php echo esc_attr($mkd_options['blog_date_in_title_ql_info_border_hover_color']);  ?>;
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_date_in_title_ql_info_color']) && !empty($mkd_options['blog_date_in_title_ql_info_color'])){ ?>
            .blog_holder.blog_date_in_title article.format-quote .post_text .post_text_inner .post_info,
            .blog_holder.blog_date_in_title article.format-link .post_text .post_text_inner .post_info
            {
            color: <?php echo esc_attr($mkd_options['blog_date_in_title_ql_info_color']);  ?>;
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_date_in_title_ql_info_link_color']) && !empty($mkd_options['blog_date_in_title_ql_info_link_color'])){ ?>
            .blog_holder.blog_date_in_title article.format-quote .post_text .post_text_inner .post_info a,
            .blog_holder.blog_date_in_title article.format-link .post_text .post_text_inner .post_info a
            {
            color: <?php echo esc_attr($mkd_options['blog_date_in_title_ql_info_link_color']);  ?>;
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_date_in_title_ql_info_hover_color']) && !empty($mkd_options['blog_date_in_title_ql_info_hover_color'])){ ?>
            .blog_holder.blog_date_in_title article.format-quote .post_text .post_text_inner:hover .post_info,
            .blog_holder.blog_date_in_title article.format-link .post_text .post_text_inner:hover .post_info,
            .blog_holder.blog_date_in_title article.format-quote .post_text .post_text_inner:hover .post_info div a,
            .blog_holder.blog_date_in_title article.format-link .post_text .post_text_inner:hover .post_info div a{
            color: <?php echo esc_attr($mkd_options['blog_date_in_title_ql_info_hover_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_date_in_title_ql_mark_color']) && !empty($mkd_options['blog_date_in_title_ql_mark_color'])){ ?>
            .blog_holder.blog_date_in_title article.format-quote .post_text .post_text_inner .post_info_quote_mark .quote_mark,
            .blog_holder.blog_date_in_title article.format-link .post_text .post_text_inner .post_info_link_mark .link_mark{
            color: <?php echo esc_attr($mkd_options['blog_date_in_title_ql_mark_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_date_in_title_ql_mark_hover_color']) && !empty($mkd_options['blog_date_in_title_ql_mark_hover_color'])){ ?>
            .blog_holder.blog_date_in_title article.format-quote .post_text .post_text_inner:hover .post_info_quote_mark .quote_mark,
            .blog_holder.blog_date_in_title article.format-link .post_text .post_text_inner:hover .post_info_link_mark .link_mark{
            color: <?php echo esc_attr($mkd_options['blog_date_in_title_ql_mark_hover_color']);  ?>;
            }
		<?php } ?>


		<?php
		/******** BLOG:CATEGORY & TITLE FIRST (CENTERED) Share options ********/
		if(isset($mkd_options['blog_category_title_first_centered_show_share']) && $mkd_options['blog_category_title_first_centered_show_share'] == 'yes') {

			if(isset($mkd_options['blog_category_title_first_centered_share_icon_color']) && $mkd_options['blog_category_title_first_centered_share_icon_color'] !== '') {?>
                .blog_holder.blog_category_title_first_centered article .post_text .post_text_inner .post_info .blog_share .social_share_dropdown ul li .social_network_icon,
                .blog_holder.blog_category_title_first_centered article.format-link .post_text.link_image .post_text_inner:hover .post_info .social_share_dropdown ul li span.social_network_icon{
                color:  <?php echo esc_attr($mkd_options['blog_category_title_first_centered_share_icon_color']); ?> ;
                }
			<?php } ?>
			<?php if(isset($mkd_options['blog_category_title_first_centered_share_background_color']) && $mkd_options['blog_category_title_first_centered_share_background_color'] !== '') {?>
                .blog_holder.blog_category_title_first_centered article .post_text .post_text_inner .post_info .blog_share .social_share_dropdown ul li a{
                background-color:  <?php echo esc_attr($mkd_options['blog_category_title_first_centered_share_background_color']); ?> ;
                }
			<?php } ?>
			<?php if(isset($mkd_options['blog_category_title_first_centered_share_icon_hover_color']) && $mkd_options['blog_category_title_first_centered_share_icon_hover_color'] !== '') {?>
                .blog_holder.blog_category_title_first_centered .social_share_dropdown ul li:hover,
                .blog_holder.blog_category_title_first_centered .social_share_dropdown ul li:hover a span.social_network_icon{
                color:  <?php echo esc_attr($mkd_options['blog_category_title_first_centered_share_icon_hover_color']); ?> !important;
                }
			<?php } ?>
		<?php } ?>
		<?php
		/******** BLOG: CATEGORY & TITLE FIRST (CENTERED) Separator ********/
		$blog_category_title_first_centered_separator_style = array();
		if(isset($mkd_options['blog_category_title_first_centered_separator_border_color']) && $mkd_options['blog_category_title_first_centered_separator_border_color'] !== '') {
			$blog_category_title_first_centered_separator_style[] = 'border-color: '.$mkd_options['blog_category_title_first_centered_separator_border_color'];
		}
		if(isset($mkd_options['blog_category_title_first_centered_separator_width']) && $mkd_options['blog_category_title_first_centered_separator_width'] !== '') {
			$blog_category_title_first_centered_separator_style[] = 'width: '.intval($mkd_options['blog_category_title_first_centered_separator_width']).'px';
		}
		if(isset($mkd_options['blog_category_title_first_centered_separator_thickness']) && $mkd_options['blog_category_title_first_centered_separator_thickness'] !== '') {
			$blog_category_title_first_centered_separator_style[] = 'border-width: '.intval($mkd_options['blog_category_title_first_centered_separator_thickness']).'px';
		}

		if(is_array($blog_category_title_first_centered_separator_style) && count($blog_category_title_first_centered_separator_style)) { ?>
            .blog_holder.blog_category_title_first_centered .separator.small{
			<?php echo esc_attr(implode(';', $blog_category_title_first_centered_separator_style)); ?>
            }
		<?php } ?>

		<?php
		/******** BLOG: CATEGORY & TITLE FIRST (CENTERED) Text Box ********/
		if(isset($mkd_options['blog_category_title_first_centered_enable_text_box']) && $mkd_options['blog_category_title_first_centered_enable_text_box'] == 'yes') {
			$blog_box_style = array();
			?>
            .blog_holder.blog_category_title_first_centered article .audio_image,
            .blog_holder.blog_category_title_first_centered article:not(.format-audio) .post_image{
            margin-bottom: 0;
            }
			<?php
			if(isset($mkd_options['blog_category_title_first_centered_box_background_color']) && $mkd_options['blog_category_title_first_centered_box_background_color'] !== '') {
				$blog_box_style[] = 'background-color: '.$mkd_options['blog_category_title_first_centered_box_background_color'];
			}

			if(isset($mkd_options['blog_category_title_first_centered_box_border_color']) && $mkd_options['blog_category_title_first_centered_box_border_color'] !== '') {
				$blog_box_style[] = 'border: 1px solid';
				$blog_box_style[] = 'border-color: '.$mkd_options['blog_category_title_first_centered_box_border_color'];
			}

			if(isset($mkd_options['blog_category_title_first_centered_box_padding']) && $mkd_options['blog_category_title_first_centered_box_padding'] !== '') {
				$blog_box_style[] = 'padding: '.$mkd_options['blog_category_title_first_centered_box_padding'];
			}

			if(is_array($blog_box_style) && count($blog_box_style)) { ?>
                .blog_holder.blog_category_title_first_centered article:not(.format-link):not(.format-quote) .post_text .post_text_inner{
				<?php echo esc_attr(implode(';', $blog_box_style)); ?>
                }
			<?php }} ?>

		<?php
		/******** BLOG: CATEGORY & TITLE FIRST (CENTERED) Quote/Link Text Box ********/
		if(isset($mkd_options['blog_category_title_first_centered_ql_background_color']) &&($mkd_options['blog_category_title_first_centered_ql_background_color'])!==""){ ?>
            .blog_holder.blog_category_title_first_centered article.format-link .post_text .post_text_inner,
            .blog_holder.blog_category_title_first_centered article.format-quote .post_text .post_text_inner{
            background-color: <?php echo esc_attr($mkd_options['blog_category_title_first_centered_ql_background_color']);  ?>;
            }
			<?php  $blog_category_title_first_centered_ql_background_color = mikado_one_mikado_hex2rgb($mkd_options['blog_category_title_first_centered_ql_background_color']); ?>

            .blog_holder.blog_category_title_first_centered article.format-link .post_text.link_image .post_text_inner,
            .blog_holder.blog_category_title_first_centered article.format-quote .post_text.quote_image .post_text_inner{
			<?php if (!empty($mkd_options['blog_category_title_first_centered_ql_background_color'])) { ?>  background-color: rgba(<?php echo esc_attr($blog_category_title_first_centered_ql_background_color[0]); ?>,<?php echo esc_attr($blog_category_title_first_centered_ql_background_color[1]); ?>,<?php echo esc_attr($blog_category_title_first_centered_ql_background_color[2]); ?>,0.85); <?php } ?>
            }

		<?php } ?>

		<?php if(isset($mkd_options['blog_category_title_first_centered_ql_hover_background_color']) && !empty($mkd_options['blog_category_title_first_centered_ql_hover_background_color'])){ ?>
            .blog_holder.blog_category_title_first_centered article.format-link .post_text .post_text_inner:hover,
            .blog_holder.blog_category_title_first_centered article.format-quote .post_text .post_text_inner:hover{
            background-color: <?php echo esc_attr($mkd_options['blog_category_title_first_centered_ql_hover_background_color']);  ?>;
            }
			<?php  $blog_category_title_first_centered_ql_hover_background_color = mikado_one_mikado_hex2rgb($mkd_options['blog_category_title_first_centered_ql_hover_background_color']); ?>

            .blog_holder.blog_category_title_first_centered article.format-link .post_text.link_image .post_text_inner:hover,
            .blog_holder.blog_category_title_first_centered article.format-quote .post_text.quote_image .post_text_inner:hover{
			<?php if (!empty($mkd_options['blog_category_title_first_centered_ql_hover_background_color'])) { ?>  background-color: rgba(<?php echo esc_attr($blog_category_title_first_centered_ql_hover_background_color[0]); ?>,<?php echo esc_attr($blog_category_title_first_centered_ql_hover_background_color[1]); ?>,<?php echo esc_attr($blog_category_title_first_centered_ql_hover_background_color[2]); ?>,0.6); <?php } ?>
            }

		<?php } ?>

		<?php
		/**************** BLOG CATEGORY TITLE FIRST CENTERED: Spacing  ****************/
		if(isset($mkd_options['blog_category_title_first_centered_category_margin_bottom']) && $mkd_options['blog_category_title_first_centered_category_margin_bottom'] !== '') { ?>
            .blog_holder.blog_category_title_first_centered article:not(.format-link):not(.format-quote) .post_category{
            margin-bottom : <?php echo esc_attr($mkd_options['blog_category_title_first_centered_category_margin_bottom']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_category_title_first_centered_title_margin_bottom']) && $mkd_options['blog_category_title_first_centered_title_margin_bottom'] !== '') { ?>
            .blog_holder.blog_category_title_first_centered article h2{
            padding-bottom : <?php echo esc_attr($mkd_options['blog_category_title_first_centered_title_margin_bottom']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_category_title_first_centered_image_margin_bottom']) && $mkd_options['blog_category_title_first_centered_image_margin_bottom'] !== '') { ?>
            .blog_holder.blog_category_title_first_centered article:not(.format-audio) .post_image,
            .blog_holder.blog_category_title_first_centered article .audio_image{
            margin-bottom : <?php echo esc_attr($mkd_options['blog_category_title_first_centered_image_margin_bottom']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_category_title_first_centered_post_info_margin_top']) && $mkd_options['blog_category_title_first_centered_post_info_margin_top'] !== '') { ?>
            .blog_holder.blog_category_title_first_centered article:not(.format-link):not(.format-quote) .post_text .post_text_inner .post_info{
            margin-top : <?php echo esc_attr($mkd_options['blog_category_title_first_centered_post_info_margin_top']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_category_title_first_centered_article_margin_bottom']) && $mkd_options['blog_category_title_first_centered_article_margin_bottom'] !== '') { ?>
            .blog_holder.blog_category_title_first_centered:not(.blog_single) article{
            margin-bottom : <?php echo esc_attr($mkd_options['blog_category_title_first_centered_article_margin_bottom']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_category_title_first_centered_ql_quote_author_margin_top']) && $mkd_options['blog_category_title_first_centered_ql_quote_author_margin_top'] !== '') { ?>
            .blog_holder.blog_category_title_first_centered article.format-quote .post_text_inner .quote_author{
            margin-top : <?php echo esc_attr($mkd_options['blog_category_title_first_centered_ql_quote_author_margin_top']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_category_title_first_centered_ql_icon_margin_top']) && $mkd_options['blog_category_title_first_centered_ql_icon_margin_top'] !== '') { ?>
            .blog_holder.blog_category_title_first_centered article.format-link .post_text .post_text_inner .post_info_link_mark,
            .blog_holder.blog_category_title_first_centered article.format-quote .post_text .post_text_inner .post_info_quote_mark{
            margin-top : <?php echo esc_attr($mkd_options['blog_category_title_first_centered_ql_icon_margin_top']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_category_title_first_centered_ql_post_info_margin_top']) && $mkd_options['blog_category_title_first_centered_ql_post_info_margin_top'] !== '') { ?>
            .blog_holder.blog_category_title_first_centered article.format-quote .post_text .post_text_inner .post_info,
            .blog_holder.blog_category_title_first_centered article.format-link .post_text .post_text_inner .post_info{
            margin-top : <?php echo esc_attr($mkd_options['blog_category_title_first_centered_ql_post_info_margin_top']).'px';?>
            }
		<?php } ?>

		<?php
		/**************** BLOG CATEGORY TITLE & FIRST (CENTERED): Title Style ****************/
		$blog_category_title_first_centered_title_style = array();

		if(isset($mkd_options['blog_category_title_first_centered_title_google_fonts']) && $mkd_options['blog_category_title_first_centered_title_google_fonts'] !== '-1') {
			$blog_category_title_first_centered_title_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_category_title_first_centered_title_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_category_title_first_centered_title_fontsize']) && $mkd_options['blog_category_title_first_centered_title_fontsize'] !== '') {
			$blog_category_title_first_centered_title_style[] = 'font-size: '.intval($mkd_options['blog_category_title_first_centered_title_fontsize']).'px';
		}

		if(isset($mkd_options['blog_category_title_first_centered_title_lineheight']) && $mkd_options['blog_category_title_first_centered_title_lineheight'] !== '') {
			$blog_category_title_first_centered_title_style[] = 'line-height: '.intval($mkd_options['blog_category_title_first_centered_title_lineheight']).'px';
		}

		if(isset($mkd_options['blog_category_title_first_centered_title_letterspacing']) && $mkd_options['blog_category_title_first_centered_title_letterspacing'] !== '') {
			$blog_category_title_first_centered_title_style[] = 'letter-spacing: '.intval($mkd_options['blog_category_title_first_centered_title_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_category_title_first_centered_title_fontweight']) && $mkd_options['blog_category_title_first_centered_title_fontweight'] !== '') {
			$blog_category_title_first_centered_title_style[] = 'font-weight: '.intval($mkd_options['blog_category_title_first_centered_title_fontweight']);
		}

		if(isset($mkd_options['blog_category_title_first_centered_title_fontstyle']) && $mkd_options['blog_category_title_first_centered_title_fontstyle'] !== '') {
			$blog_category_title_first_centered_title_style[] = 'font-style: '.$mkd_options['blog_category_title_first_centered_title_fontstyle'];
		}

		if(isset($mkd_options['blog_category_title_first_centered_title_texttransform']) && $mkd_options['blog_category_title_first_centered_title_texttransform'] !== '') {
			$blog_category_title_first_centered_title_style[] = 'text-transform: '.$mkd_options['blog_category_title_first_centered_title_texttransform'];
		}

		if(is_array($blog_category_title_first_centered_title_style) && count($blog_category_title_first_centered_title_style)) { ?>
            .blog_holder.blog_category_title_first_centered article:not(.format-quote):not(.format-link) h2{
			<?php echo esc_attr(implode(';', $blog_category_title_first_centered_title_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_category_title_first_centered_title_color']) && !empty($mkd_options['blog_category_title_first_centered_title_color'])){ ?>
            .blog_holder.blog_category_title_first_centered article:not(.format-quote):not(.format-link) h2 a,
            .blog_holder.blog_category_title_first_centered.blog_single article:not(.format-quote):not(.format-link) h2{
            color: <?php echo esc_attr($mkd_options['blog_category_title_first_centered_title_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_category_title_first_centered_title_hover_color']) && !empty($mkd_options['blog_category_title_first_centered_title_hover_color'])){ ?>
            .blog_holder.blog_category_title_first_centered article:not(.format-quote):not(.format-link) h2 a:hover,
            .blog_holder.blog_category_title_first_centered.blog_single article:not(.format-quote):not(.format-link) h2:hover{
            color: <?php echo esc_attr($mkd_options['blog_category_title_first_centered_title_hover_color']);  ?>;
            }
		<?php } ?>

		<?php

		$blog_category_title_first_centered_category_style = array();

		if(isset($mkd_options['blog_category_title_first_centered_category_google_fonts']) && $mkd_options['blog_category_title_first_centered_category_google_fonts'] !== '-1') {
			$blog_category_title_first_centered_category_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_category_title_first_centered_category_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_category_title_first_centered_category_fontsize']) && $mkd_options['blog_category_title_first_centered_category_fontsize'] !== '') {
			$blog_category_title_first_centered_category_style[] = 'font-size: '.intval($mkd_options['blog_category_title_first_centered_category_fontsize']).'px';
		}

		if(isset($mkd_options['blog_category_title_first_centered_category_lineheight']) && $mkd_options['blog_category_title_first_centered_category_lineheight'] !== '') {
			$blog_category_title_first_centered_category_style[] = 'line-height: '.intval($mkd_options['blog_category_title_first_centered_category_lineheight']).'px';
		}

		if(isset($mkd_options['blog_category_title_first_centered_category_letterspacing']) && $mkd_options['blog_category_title_first_centered_category_letterspacing'] !== '') {
			$blog_category_title_first_centered_category_style[] = 'letter-spacing: '.intval($mkd_options['blog_category_title_first_centered_category_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_category_title_first_centered_category_fontweight']) && $mkd_options['blog_category_title_first_centered_category_fontweight'] !== '') {
			$blog_category_title_first_centered_category_style[] = 'font-weight: '.intval($mkd_options['blog_category_title_first_centered_category_fontweight']);
		}

		if(isset($mkd_options['blog_category_title_first_centered_category_fontstyle']) && $mkd_options['blog_category_title_first_centered_category_fontstyle'] !== '') {
			$blog_category_title_first_centered_category_style[] = 'font-style: '.$mkd_options['blog_category_title_first_centered_category_fontstyle'];
		}

		if(isset($mkd_options['blog_category_title_first_centered_category_texttransform']) && $mkd_options['blog_category_title_first_centered_category_texttransform'] !== '') {
			$blog_category_title_first_centered_category_style[] = 'text-transform: '.$mkd_options['blog_category_title_first_centered_category_texttransform'];
		}

		if(isset($mkd_options['blog_category_title_first_centered_category_color']) && $mkd_options['blog_category_title_first_centered_category_color'] !== '') {
			$blog_category_title_first_centered_category_style[] = 'color: '.$mkd_options['blog_category_title_first_centered_category_color'];
		}

		if(is_array($blog_category_title_first_centered_category_style) && count($blog_category_title_first_centered_category_style)) { ?>
            .blog_holder.blog_category_title_first_centered article:not(.format-quote):not(.format-link) .post_category a
            {
			<?php echo esc_attr(implode(';', $blog_category_title_first_centered_category_style)); ?>
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_category_title_first_centered_category_hover_color']) && !empty($mkd_options['blog_category_title_first_centered_category_hover_color'])){ ?>
            .blog_holder.blog_category_title_first_centered article:not(.format-quote):not(.format-link) .post_category a:hover{
            color: <?php echo esc_attr($mkd_options['blog_category_title_first_centered_category_hover_color']);  ?>;

            }
		<?php } ?>
		<?php
		/**************** BLOG CATEGORY TITLE & FIRST (CENTERED): Qoute/Link Title Style ****************/
		$blog_category_title_first_centered_ql_title_style = array();

		if(isset($mkd_options['blog_category_title_first_centered_ql_title_fontfamily']) && $mkd_options['blog_category_title_first_centered_ql_title_fontfamily'] !== '-1') {
			$blog_category_title_first_centered_ql_title_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_category_title_first_centered_ql_title_fontfamily']).', sans-serif';
		}

		if(isset($mkd_options['blog_category_title_first_centered_ql_title_fontsize']) && $mkd_options['blog_category_title_first_centered_ql_title_fontsize'] !== '') {
			$blog_category_title_first_centered_ql_title_style[] = 'font-size: '.intval($mkd_options['blog_category_title_first_centered_ql_title_fontsize']).'px';
		}

		if(isset($mkd_options['blog_category_title_first_centered_ql_title_lineheight']) && $mkd_options['blog_category_title_first_centered_ql_title_lineheight'] !== '') {
			$blog_category_title_first_centered_ql_title_style[] = 'line-height: '.intval($mkd_options['blog_category_title_first_centered_ql_title_lineheight']).'px';
		}

		if(isset($mkd_options['blog_category_title_first_centered_ql_title_letterspacing']) && $mkd_options['blog_category_title_first_centered_ql_title_letterspacing'] !== '') {
			$blog_category_title_first_centered_ql_title_style[] = 'letter-spacing: '.intval($mkd_options['blog_category_title_first_centered_ql_title_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_category_title_first_centered_ql_title_fontweight']) && $mkd_options['blog_category_title_first_centered_ql_title_fontweight'] !== '') {
			$blog_category_title_first_centered_ql_title_style[] = 'font-weight: '.intval($mkd_options['blog_category_title_first_centered_ql_title_fontweight']);
		}

		if(isset($mkd_options['blog_category_title_first_centered_ql_title_fontstyle']) && $mkd_options['blog_category_title_first_centered_ql_title_fontstyle'] !== '') {
			$blog_category_title_first_centered_ql_title_style[] = 'font-style: '.$mkd_options['blog_category_title_first_centered_ql_title_fontstyle'];
		}

		if(isset($mkd_options['blog_category_title_first_centered_ql_title_texttransform']) && $mkd_options['blog_category_title_first_centered_ql_title_texttransform'] !== '') {
			$blog_category_title_first_centered_ql_title_style[] = 'text-transform: '.$mkd_options['blog_category_title_first_centered_ql_title_texttransform'];
		}

		if(is_array($blog_category_title_first_centered_ql_title_style) && count($blog_category_title_first_centered_ql_title_style)) { ?>
            .blog_holder.blog_category_title_first_centered article.format-quote .post_text .post_title h3,
            .blog_holder.blog_category_title_first_centered article.format-link .post_text .post_title h3{
			<?php echo esc_attr(implode(';', $blog_category_title_first_centered_ql_title_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_category_title_first_centered_ql_title_color']) && !empty($mkd_options['blog_category_title_first_centered_ql_title_color'])){ ?>
            .blog_holder.blog_category_title_first_centered article.format-quote .post_text .post_title h3 a,
            .blog_holder.blog_category_title_first_centered article.format-link .post_text .post_title h3 a,
            .blog_holder.blog_category_title_first_centered article.format-quote .post_text .post_title h3,
            .blog_holder.blog_category_title_first_centered article.format-link .post_text .post_title h3
            {
            color: <?php echo esc_attr($mkd_options['blog_category_title_first_centered_ql_title_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_category_title_first_centered_ql_title_hover_color']) && !empty($mkd_options['blog_category_title_first_centered_ql_title_hover_color'])){ ?>
            .blog_holder.blog_category_title_first_centered article.format-quote .post_text .post_text_inner:hover .post_title h3 a,
            .blog_holder.blog_category_title_first_centered article.format-link .post_text .post_text_inner:hover .post_title h3 a,
            .blog_holder.blog_category_title_first_centered article.format-quote .post_text .post_text_inner:hover .post_title h3,
            .blog_holder.blog_category_title_first_centered article.format-link .post_text .post_text_inner:hover .post_title h3
            {
            color: <?php echo esc_attr($mkd_options['blog_category_title_first_centered_ql_title_hover_color']);  ?>;

            }
		<?php } ?>
		<?php
		/**************** BLOG CATEGORY TITLE & FIRST (CENTERED): Qoute Author Style ****************/
		$blog_category_title_first_centered_ql_author_style = array();

		if(isset($mkd_options['blog_category_title_first_centered_ql_author_fontfamily']) && $mkd_options['blog_category_title_first_centered_ql_author_fontfamily'] !== '-1') {
			$blog_category_title_first_centered_ql_author_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_category_title_first_centered_ql_author_fontfamily']).', sans-serif';
		}

		if(isset($mkd_options['blog_category_title_first_centered_ql_author_fontsize']) && $mkd_options['blog_category_title_first_centered_ql_author_fontsize'] !== '') {
			$blog_category_title_first_centered_ql_author_style[] = 'font-size: '.intval($mkd_options['blog_category_title_first_centered_ql_author_fontsize']).'px';
		}

		if(isset($mkd_options['blog_category_title_first_centered_ql_author_lineheight']) && $mkd_options['blog_category_title_first_centered_ql_author_lineheight'] !== '') {
			$blog_category_title_first_centered_ql_author_style[] = 'line-height: '.intval($mkd_options['blog_category_title_first_centered_ql_author_lineheight']).'px';
		}

		if(isset($mkd_options['blog_category_title_first_centered_ql_author_letterspacing']) && $mkd_options['blog_category_title_first_centered_ql_author_letterspacing'] !== '') {
			$blog_category_title_first_centered_ql_author_style[] = 'letter-spacing: '.intval($mkd_options['blog_category_title_first_centered_ql_author_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_category_title_first_centered_ql_author_fontweight']) && $mkd_options['blog_category_title_first_centered_ql_author_fontweight'] !== '') {
			$blog_category_title_first_centered_ql_author_style[] = 'font-weight: '.intval($mkd_options['blog_category_title_first_centered_ql_author_fontweight']);
		}

		if(isset($mkd_options['blog_category_title_first_centered_ql_author_fontstyle']) && $mkd_options['blog_category_title_first_centered_ql_author_fontstyle'] !== '') {
			$blog_category_title_first_centered_ql_author_style[] = 'font-style: '.$mkd_options['blog_category_title_first_centered_ql_author_fontstyle'];
		}

		if(isset($mkd_options['blog_category_title_first_centered_ql_author_texttransform']) && $mkd_options['blog_category_title_first_centered_ql_author_texttransform'] !== '') {
			$blog_category_title_first_centered_ql_author_style[] = 'text-transform: '.$mkd_options['blog_category_title_first_centered_ql_author_texttransform'];
		}

		if(is_array($blog_category_title_first_centered_ql_author_style) && count($blog_category_title_first_centered_ql_author_style)) { ?>
            .blog_holder.blog_category_title_first_centered article.format-quote .post_text .quote_author{
			<?php echo esc_attr(implode(';', $blog_category_title_first_centered_ql_author_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_category_title_first_centered_ql_author_color']) && !empty($mkd_options['blog_category_title_first_centered_ql_author_color'])){ ?>
            .blog_holder.blog_category_title_first_centered article.format-quote .post_text .post_text_inner .quote_author{
            color: <?php echo esc_attr($mkd_options['blog_category_title_first_centered_ql_author_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_category_title_first_centered_ql_author_hover_color']) && !empty($mkd_options['blog_category_title_first_centered_ql_author_hover_color'])){ ?>

            .blog_holder.blog_category_title_first_centered article.format-quote .post_text .post_text_inner:hover .quote_author{
            color: <?php echo esc_attr($mkd_options['blog_category_title_first_centered_ql_author_hover_color']);  ?>;

            }
		<?php } ?>
		<?php
		/**************** BLOG CATEGORY TITLE & FIRST (CENTERED): Info Style ****************/
		$blog_category_title_first_centered_info_style = array();

		if(isset($mkd_options['blog_category_title_first_centered_info_google_fonts']) && $mkd_options['blog_category_title_first_centered_info_google_fonts'] !== '-1') {
			$blog_category_title_first_centered_info_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_category_title_first_centered_info_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_category_title_first_centered_info_fontsize']) && $mkd_options['blog_category_title_first_centered_info_fontsize'] !== '') {
			$blog_category_title_first_centered_info_style[] = 'font-size: '.intval($mkd_options['blog_category_title_first_centered_info_fontsize']).'px';
		}

		if(isset($mkd_options['blog_category_title_first_centered_info_lineheight']) && $mkd_options['blog_category_title_first_centered_info_lineheight'] !== '') {
			$blog_category_title_first_centered_info_style[] = 'line-height: '.intval($mkd_options['blog_category_title_first_centered_info_lineheight']).'px';
		}

		if(isset($mkd_options['blog_category_title_first_centered_info_letterspacing']) && $mkd_options['blog_category_title_first_centered_info_letterspacing'] !== '') {
			$blog_category_title_first_centered_info_style[] = 'letter-spacing: '.intval($mkd_options['blog_category_title_first_centered_info_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_category_title_first_centered_info_fontweight']) && $mkd_options['blog_category_title_first_centered_info_fontweight'] !== '') {
			$blog_category_title_first_centered_info_style[] = 'font-weight: '.intval($mkd_options['blog_category_title_first_centered_info_fontweight']);
		}

		if(isset($mkd_options['blog_category_title_first_centered_info_fontstyle']) && $mkd_options['blog_category_title_first_centered_info_fontstyle'] !== '') {
			$blog_category_title_first_centered_info_style[] = 'font-style: '.$mkd_options['blog_category_title_first_centered_info_fontstyle'];
		}

		if(isset($mkd_options['blog_category_title_first_centered_info_texttransform']) && $mkd_options['blog_category_title_first_centered_info_texttransform'] !== '') {
			$blog_category_title_first_centered_info_style[] = 'text-transform: '.$mkd_options['blog_category_title_first_centered_info_texttransform'];
		}
		if(is_array($blog_category_title_first_centered_info_style) && count($blog_category_title_first_centered_info_style)) { ?>

            .blog_holder.blog_category_title_first_centered article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info div{
			<?php echo esc_attr(implode(';', $blog_category_title_first_centered_info_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_category_title_first_centered_info_color']) && !empty($mkd_options['blog_category_title_first_centered_info_color'])){ ?>
            .blog_holder.blog_category_title_first_centered article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info
            {
            color: <?php echo esc_attr($mkd_options['blog_category_title_first_centered_info_color']);  ?>;
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_category_title_first_centered_info_link_color']) && !empty($mkd_options['blog_category_title_first_centered_info_link_color'])){ ?>
            .blog_holder.blog_category_title_first_centered article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info div a
            {
            color: <?php echo esc_attr($mkd_options['blog_category_title_first_centered_info_link_color']);  ?>;
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_category_title_first_centered_info_hover_color']) && !empty($mkd_options['blog_category_title_first_centered_info_hover_color'])){ ?>
            .blog_holder.blog_category_title_first_centered article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info div a:hover
            {
            color: <?php echo esc_attr($mkd_options['blog_category_title_first_centered_info_hover_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_category_title_first_centered_info_border_color']) && !empty($mkd_options['blog_category_title_first_centered_info_border_color'])){ ?>
            .blog_holder.blog_category_title_first_centered article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info
            {
            border-color: <?php echo esc_attr($mkd_options['blog_category_title_first_centered_info_border_color']);  ?>;
            }
		<?php } ?>
		<?php
		/****************  BLOG CATEGORY TITLE & FIRST (CENTERED): Quote/Link TExt Style *********************/
		$blog_category_title_first_centered_ql_info_style = array();

		if(isset($mkd_options['blog_category_title_first_centered_ql_info_google_fonts']) && $mkd_options['blog_category_title_first_centered_ql_info_google_fonts'] !== '-1') {
			$blog_category_title_first_centered_ql_info_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_category_title_first_centered_ql_info_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_category_title_first_centered_ql_info_fontsize']) && $mkd_options['blog_category_title_first_centered_ql_info_fontsize'] !== '') {
			$blog_category_title_first_centered_ql_info_style[] = 'font-size: '.intval($mkd_options['blog_category_title_first_centered_ql_info_fontsize']).'px';
		}

		if(isset($mkd_options['blog_category_title_first_centered_ql_info_lineheight']) && $mkd_options['blog_category_title_first_centered_ql_info_lineheight'] !== '') {
			$blog_category_title_first_centered_ql_info_style[] = 'line-height: '.intval($mkd_options['blog_category_title_first_centered_ql_info_lineheight']).'px';
		}

		if(isset($mkd_options['blog_category_title_first_centered_ql_info_letterspacing']) && $mkd_options['blog_category_title_first_centered_ql_info_letterspacing'] !== '') {
			$blog_category_title_first_centered_ql_info_style[] = 'letter-spacing: '.intval($mkd_options['blog_category_title_first_centered_ql_info_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_category_title_first_centered_ql_info_fontweight']) && $mkd_options['blog_category_title_first_centered_ql_info_fontweight'] !== '') {
			$blog_category_title_first_centered_ql_info_style[] = 'font-weight: '.intval($mkd_options['blog_category_title_first_centered_ql_info_fontweight']);
		}

		if(isset($mkd_options['blog_category_title_first_centered_ql_info_fontstyle']) && $mkd_options['blog_category_title_first_centered_ql_info_fontstyle'] !== '') {
			$blog_category_title_first_centered_ql_info_style[] = 'font-style: '.$mkd_options['blog_category_title_first_centered_ql_info_fontstyle'];
		}

		if(isset($mkd_options['blog_category_title_first_centered_ql_info_texttransform']) && $mkd_options['blog_category_title_first_centered_ql_info_texttransform'] !== '') {
			$blog_category_title_first_centered_ql_info_style[] = 'text-transform: '.$mkd_options['blog_category_title_first_centered_ql_info_texttransform'];
		}
		if(is_array($blog_category_title_first_centered_ql_info_style) && count($blog_category_title_first_centered_ql_info_style)) { ?>
            .blog_holder.blog_category_title_first_centered article.format-quote .post_text .post_text_inner .post_info,
            .blog_holder.blog_category_title_first_centered article.format-link .post_text .post_text_inner .post_info{
			<?php echo esc_attr(implode(';', $blog_category_title_first_centered_ql_info_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_category_title_first_centered_ql_info_color']) && !empty($mkd_options['blog_category_title_first_centered_ql_info_color'])){ ?>
            .blog_holder.blog_category_title_first_centered article.format-quote .post_text .post_text_inner .post_info,
            .blog_holder.blog_category_title_first_centered article.format-link .post_text .post_text_inner .post_info{
            color: <?php echo esc_attr($mkd_options['blog_category_title_first_centered_ql_info_color']);  ?>;
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_category_title_first_centered_ql_info_link_color']) && !empty($mkd_options['blog_category_title_first_centered_ql_info_link_color'])){ ?>
            .blog_holder.blog_category_title_first_centered article.format-quote .post_text .post_text_inner .post_info div a,
            .blog_holder.blog_category_title_first_centered article.format-link .post_text .post_text_inner .post_info div a{
            color: <?php echo esc_attr($mkd_options['blog_category_title_first_centered_ql_info_link_color']);  ?>;
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_category_title_first_centered_ql_info_hover_color']) && !empty($mkd_options['blog_category_title_first_centered_ql_info_hover_color'])){ ?>
            .blog_holder.blog_category_title_first_centered article.format-quote .post_text .post_text_inner:hover .post_info,
            .blog_holder.blog_category_title_first_centered article.format-link .post_text .post_text_inner:hover .post_info,
            .blog_holder.blog_category_title_first_centered article.format-quote .post_text .post_text_inner:hover .post_info div a,
            .blog_holder.blog_category_title_first_centered article.format-link .post_text .post_text_inner:hover .post_info div a,
            .blog_holder.blog_category_title_first_centered article.format-quote .post_text .post_text_inner:hover .post_info div a i,
            .blog_holder.blog_category_title_first_centered article.format-link .post_text .post_text_inner:hover .post_info div a i{
            color: <?php echo esc_attr($mkd_options['blog_category_title_first_centered_ql_info_hover_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_category_title_first_centered_ql_mark_color']) && !empty($mkd_options['blog_category_title_first_centered_ql_mark_color'])){ ?>
            .blog_holder.blog_category_title_first_centered article.format-quote .post_text .post_text_inner .post_info_quote_mark .quote_mark,
            .blog_holder.blog_category_title_first_centered article.format-link .post_text .post_text_inner .post_info_link_mark .link_mark{
            color: <?php echo esc_attr($mkd_options['blog_category_title_first_centered_ql_mark_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_category_title_first_centered_ql_mark_hover_color']) && !empty($mkd_options['blog_category_title_first_centered_ql_mark_hover_color'])){ ?>
            .blog_holder.blog_category_title_first_centered article.format-quote .post_text .post_text_inner:hover .post_info_quote_mark .quote_mark,
            .blog_holder.blog_category_title_first_centered article.format-link .post_text .post_text_inner:hover .post_info_link_mark .link_mark{
            color: <?php echo esc_attr($mkd_options['blog_category_title_first_centered_ql_mark_hover_color']);  ?>;
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_category_title_first_centered_ql_info_border_color']) && !empty($mkd_options['blog_category_title_first_centered_ql_info_border_color'])){ ?>
            .blog_holder.blog_category_title_first_centered article.format-quote .post_text .post_text_inner .post_info,
            .blog_holder.blog_category_title_first_centered article.format-link .post_text .post_text_inner .post_info{
            border-color: <?php echo esc_attr($mkd_options['blog_category_title_first_centered_ql_info_border_color']);  ?>;
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_category_title_first_centered_ql_info_border_hover_color']) && !empty($mkd_options['blog_category_title_first_centered_ql_info_border_hover_color'])){ ?>
            .blog_holder.blog_category_title_first_centered article.format-quote .post_text .post_text_inner:hover .post_info,
            .blog_holder.blog_category_title_first_centered article.format-link .post_text .post_text_inner:hover .post_info{
            border-color: <?php echo esc_attr($mkd_options['blog_category_title_first_centered_ql_info_border_hover_color']);  ?>;
            }
		<?php } ?>

		<?php
		/******** BLOG: POST INFO VERTICAL CONTENT Share options ********/
		if(isset($mkd_options['blog_post_info_vertical_content_show_share']) && $mkd_options['blog_post_info_vertical_content_show_share'] == 'yes') {

			if(isset($mkd_options['blog_post_info_vertical_content_share_icon_color']) && $mkd_options['blog_post_info_vertical_content_share_icon_color'] !== '') {?>
                .blog_holder.blog_post_info_vertical_content .social_share_dropdown ul li a,
                .blog_holder.blog_post_info_vertical_content .social_share_dropdown ul li .social_network_icon{
                color:  <?php echo esc_attr($mkd_options['blog_post_info_vertical_content_share_icon_color']); ?> ;
                }
			<?php } ?>
			<?php if(isset($mkd_options['blog_post_info_vertical_content_share_background_color']) && $mkd_options['blog_post_info_vertical_content_share_background_color'] !== '') {?>
                .blog_holder.blog_post_info_vertical_content .social_share_dropdown ul li a{
                background-color:  <?php echo esc_attr($mkd_options['blog_post_info_vertical_content_share_background_color']); ?> ;
                }
			<?php } ?>
			<?php if(isset($mkd_options['blog_post_info_vertical_content_share_icon_hover_color']) && $mkd_options['blog_post_info_vertical_content_share_icon_hover_color'] !== '') {?>
                .blog_holder.blog_post_info_vertical_content .social_share_dropdown ul li:hover,
                .blog_holder.blog_post_info_vertical_content .social_share_dropdown ul li:hover a span.social_network_icon{
                color:  <?php echo esc_attr($mkd_options['blog_post_info_vertical_content_share_icon_hover_color']); ?> !important;
                }
			<?php } ?>
		<?php } ?>

		<?php
		/******** BLOG: POST INFO VERTICAL - CONTENT Text Box ********/
		if(isset($mkd_options['blog_post_info_vertical_content_enable_text_box']) && $mkd_options['blog_post_info_vertical_content_enable_text_box'] == 'yes') {
			$blog_box_style = array();
			?>
            .blog_holder.blog_post_info_vertical_content article .audio_image,
            .blog_holder.blog_post_info_vertical_content article:not(.format-audio) .post_image{
            margin-bottom: 0;
            }
			<?php
			if(isset($mkd_options['blog_post_info_vertical_content_box_background_color']) && $mkd_options['blog_post_info_vertical_content_box_background_color'] !== '') {
				$blog_box_style[] = 'background-color: '.$mkd_options['blog_post_info_vertical_content_box_background_color'];
			}

			if(isset($mkd_options['blog_post_info_vertical_content_box_border_color']) && $mkd_options['blog_post_info_vertical_content_box_border_color'] !== '') {
				$blog_box_style[] = 'border: 1px solid';
				$blog_box_style[] = 'border-color: '.$mkd_options['blog_post_info_vertical_content_box_border_color'];
			}

			if(isset($mkd_options['blog_post_info_vertical_content_box_padding']) && $mkd_options['blog_post_info_vertical_content_box_padding'] !== '') {
				$blog_box_style[] = 'padding: '.$mkd_options['blog_post_info_vertical_content_box_padding'];
			}

			if(is_array($blog_box_style) && count($blog_box_style)) { ?>
                .blog_holder.blog_post_info_vertical_content article:not(.format-link):not(.format-quote) .post_text .post_text_inner{
				<?php echo esc_attr(implode(';', $blog_box_style)); ?>
                }
			<?php }}
		?>

		<?php
		/******** BLOG: POST INFO VERTICAL - CONTENT Quote/Link Text Box ********/
		if(isset($mkd_options['blog_post_info_vertical_content_ql_background_color']) &&($mkd_options['blog_post_info_vertical_content_ql_background_color'])!==""){ ?>
            .blog_holder.blog_post_info_vertical_content article.format-link .post_text .post_text_inner,
            .blog_holder.blog_post_info_vertical_content article.format-quote .post_text .post_text_inner{
            background-color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_content_ql_background_color']);  ?>;
            }
			<?php  $blog_post_info_vertical_content_ql_background_color = mikado_one_mikado_hex2rgb($mkd_options['blog_post_info_vertical_content_ql_background_color']); ?>

            .blog_holder.blog_post_info_vertical_content article.format-link .post_text.link_image .post_text_inner,
            .blog_holder.blog_post_info_vertical_content article.format-quote .post_text.quote_image .post_text_inner{
			<?php if (!empty($mkd_options['blog_post_info_vertical_content_ql_background_color'])) { ?>  background-color: rgba(<?php echo esc_attr($blog_post_info_vertical_content_ql_background_color[0]); ?>,<?php echo esc_attr($blog_post_info_vertical_content_ql_background_color[1]); ?>,<?php echo esc_attr($blog_post_info_vertical_content_ql_background_color[2]); ?>,0.85); <?php } ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_post_info_vertical_content_ql_hover_background_color']) && !empty($mkd_options['blog_post_info_vertical_content_ql_hover_background_color'])){ ?>
            .blog_holder.blog_post_info_vertical_content article.format-link .post_text .post_text_inner:hover,
            .blog_holder.blog_post_info_vertical_content article.format-quote .post_text .post_text_inner:hover{
            background-color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_content_ql_hover_background_color']);  ?>;
            }
			<?php  $blog_post_info_vertical_content_ql_hover_background_color = mikado_one_mikado_hex2rgb($mkd_options['blog_post_info_vertical_content_ql_hover_background_color']); ?>

            .blog_holder.blog_post_info_vertical_content article.format-link .post_text.link_image .post_text_inner:hover,
            .blog_holder.blog_post_info_vertical_content article.format-quote .post_text.quote_image .post_text_inner:hover{
			<?php if (!empty($mkd_options['blog_post_info_vertical_content_ql_hover_background_color'])) { ?>  background-color: rgba(<?php echo esc_attr($blog_post_info_vertical_content_ql_hover_background_color[0]); ?>,<?php echo esc_attr($blog_post_info_vertical_content_ql_hover_background_color[1]); ?>,<?php echo esc_attr($blog_post_info_vertical_content_ql_hover_background_color[2]); ?>,0.6); <?php } ?>
            }

		<?php } ?>

		<?php
		/**************** BLOG POST INFO VERTICAL CONTENT: Spacing  ****************/
		if(isset($mkd_options['blog_post_info_vertical_content_image_margin_bottom']) && $mkd_options['blog_post_info_vertical_content_image_margin_bottom'] !== '') { ?>
            .blog_holder.blog_post_info_vertical_content article:not(.format-audio) .post_image,
            .blog_holder.blog_post_info_vertical_content article .audio_image{
            margin-bottom : <?php echo esc_attr($mkd_options['blog_post_info_vertical_content_image_margin_bottom']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_post_info_vertical_content_title_margin_bottom']) && $mkd_options['blog_post_info_vertical_content_title_margin_bottom'] !== '') { ?>
            .blog_holder.blog_post_info_vertical_content article h2{
            padding-bottom : <?php echo esc_attr($mkd_options['blog_post_info_vertical_content_title_margin_bottom']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_post_info_vertical_content_post_info_margin_bottom']) && $mkd_options['blog_post_info_vertical_content_post_info_margin_bottom'] !== '') { ?>
            .blog_holder.blog_post_info_vertical_content article:not(.format-quote):not(.format-link) .post_info{
            margin-bottom : <?php echo esc_attr($mkd_options['blog_post_info_vertical_content_post_info_margin_bottom']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_post_info_vertical_content_article_margin_bottom']) && $mkd_options['blog_post_info_vertical_content_article_margin_bottom'] !== '') { ?>
            .blog_holder.blog_post_info_vertical_content:not(.blog_single) article{
            margin-bottom : <?php echo esc_attr($mkd_options['blog_post_info_vertical_content_article_margin_bottom']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_post_info_vertical_content_ql_quote_author_margin_top']) && $mkd_options['blog_post_info_vertical_content_ql_quote_author_margin_top'] !== '') { ?>
            .blog_holder.blog_post_info_vertical_content article.format-quote .post_text_inner .quote_author{
            margin-top : <?php echo esc_attr($mkd_options['blog_post_info_vertical_content_ql_quote_author_margin_top']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_post_info_vertical_content_ql_post_info_margin_top']) && $mkd_options['blog_post_info_vertical_content_ql_post_info_margin_top'] !== '') { ?>
            .blog_holder.blog_post_info_vertical_content article.format-link .post_info,
            .blog_holder.blog_post_info_vertical_content article.format-quote .post_info{
            margin-top : <?php echo esc_attr($mkd_options['blog_post_info_vertical_content_ql_post_info_margin_top']).'px';?>
            }
		<?php } ?>

		<?php
		/**************** BLOG POST INFO VERTICAL CONTENT: Title Style ****************/
		$blog_post_info_vertical_content_title_style = array();

		if(isset($mkd_options['blog_post_info_vertical_content_title_google_fonts']) && $mkd_options['blog_post_info_vertical_content_title_google_fonts'] !== '-1') {
			$blog_post_info_vertical_content_title_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_post_info_vertical_content_title_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_post_info_vertical_content_title_fontsize']) && $mkd_options['blog_post_info_vertical_content_title_fontsize'] !== '') {
			$blog_post_info_vertical_content_title_style[] = 'font-size: '.intval($mkd_options['blog_post_info_vertical_content_title_fontsize']).'px';
		}

		if(isset($mkd_options['blog_post_info_vertical_content_title_lineheight']) && $mkd_options['blog_post_info_vertical_content_title_lineheight'] !== '') {
			$blog_post_info_vertical_content_title_style[] = 'line-height: '.intval($mkd_options['blog_post_info_vertical_content_title_lineheight']).'px';
		}

		if(isset($mkd_options['blog_post_info_vertical_content_title_letterspacing']) && $mkd_options['blog_post_info_vertical_content_title_letterspacing'] !== '') {
			$blog_post_info_vertical_content_title_style[] = 'letter-spacing: '.intval($mkd_options['blog_post_info_vertical_content_title_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_post_info_vertical_content_title_fontweight']) && $mkd_options['blog_post_info_vertical_content_title_fontweight'] !== '') {
			$blog_post_info_vertical_content_title_style[] = 'font-weight: '.intval($mkd_options['blog_post_info_vertical_content_title_fontweight']);
		}

		if(isset($mkd_options['blog_post_info_vertical_content_title_fontstyle']) && $mkd_options['blog_post_info_vertical_content_title_fontstyle'] !== '') {
			$blog_post_info_vertical_content_title_style[] = 'font-style: '.$mkd_options['blog_post_info_vertical_content_title_fontstyle'];
		}

		if(isset($mkd_options['blog_post_info_vertical_content_title_texttransform']) && $mkd_options['blog_post_info_vertical_content_title_texttransform'] !== '') {
			$blog_post_info_vertical_content_title_style[] = 'text-transform: '.$mkd_options['blog_post_info_vertical_content_title_texttransform'];
		}

		if(is_array($blog_post_info_vertical_content_title_style) && count($blog_post_info_vertical_content_title_style)) { ?>
            .blog_holder.blog_post_info_vertical_content article:not(.format-quote):not(.format-link) h2{
			<?php echo esc_attr(implode(';', $blog_post_info_vertical_content_title_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_post_info_vertical_content_title_color']) && !empty($mkd_options['blog_post_info_vertical_content_title_color'])){ ?>
            .blog_holder.blog_post_info_vertical_content article:not(.format-quote):not(.format-link) h2 a,
            .blog_holder.blog_post_info_vertical_content.blog_single article:not(.format-quote):not(.format-link) h2{
            color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_content_title_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_post_info_vertical_content_title_hover_color']) && !empty($mkd_options['blog_post_info_vertical_content_title_hover_color'])){ ?>
            .blog_holder.blog_post_info_vertical_content article:not(.format-quote):not(.format-link) h2 a:hover,
            .blog_holder.blog_post_info_vertical_content.blog_single article:not(.format-quote):not(.format-link) h2:hover{
            color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_content_title_hover_color']);  ?>;
            }
		<?php } ?>

		<?php
		/**************** BLOG POST INFO VERTICAL CONTENT: Qoute/Link Title Style ****************/
		$blog_post_info_vertical_content_ql_title_style = array();

		if(isset($mkd_options['blog_post_info_vertical_content_ql_title_google_fonts']) && $mkd_options['blog_post_info_vertical_content_ql_title_google_fonts'] !== '-1') {
			$blog_post_info_vertical_content_ql_title_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_post_info_vertical_content_ql_title_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_post_info_vertical_content_ql_title_fontsize']) && $mkd_options['blog_post_info_vertical_content_ql_title_fontsize'] !== '') {
			$blog_post_info_vertical_content_ql_title_style[] = 'font-size: '.intval($mkd_options['blog_post_info_vertical_content_ql_title_fontsize']).'px';
		}

		if(isset($mkd_options['blog_post_info_vertical_content_ql_title_lineheight']) && $mkd_options['blog_post_info_vertical_content_ql_title_lineheight'] !== '') {
			$blog_post_info_vertical_content_ql_title_style[] = 'line-height: '.intval($mkd_options['blog_post_info_vertical_content_ql_title_lineheight']).'px';
		}

		if(isset($mkd_options['blog_post_info_vertical_content_ql_title_letterspacing']) && $mkd_options['blog_post_info_vertical_content_ql_title_letterspacing'] !== '') {
			$blog_post_info_vertical_content_ql_title_style[] = 'letter-spacing: '.intval($mkd_options['blog_post_info_vertical_content_ql_title_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_post_info_vertical_content_ql_title_fontweight']) && $mkd_options['blog_post_info_vertical_content_ql_title_fontweight'] !== '') {
			$blog_post_info_vertical_content_ql_title_style[] = 'font-weight: '.intval($mkd_options['blog_post_info_vertical_content_ql_title_fontweight']);
		}

		if(isset($mkd_options['blog_post_info_vertical_content_ql_title_fontstyle']) && $mkd_options['blog_post_info_vertical_content_ql_title_fontstyle'] !== '') {
			$blog_post_info_vertical_content_ql_title_style[] = 'font-style: '.$mkd_options['blog_post_info_vertical_content_ql_title_fontstyle'];
		}

		if(isset($mkd_options['blog_post_info_vertical_content_ql_title_texttransform']) && $mkd_options['blog_post_info_vertical_content_ql_title_texttransform'] !== '') {
			$blog_post_info_vertical_content_ql_title_style[] = 'text-transform: '.$mkd_options['blog_post_info_vertical_content_ql_title_texttransform'];
		}

		if(is_array($blog_post_info_vertical_content_ql_title_style) && count($blog_post_info_vertical_content_ql_title_style)) { ?>
            .blog_holder.blog_post_info_vertical_content article.format-quote .post_text .post_title h3,
            .blog_holder.blog_post_info_vertical_content article.format-link .post_text .post_title h3{
			<?php echo esc_attr(implode(';', $blog_post_info_vertical_content_ql_title_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_post_info_vertical_content_ql_title_color']) && !empty($mkd_options['blog_post_info_vertical_content_ql_title_color'])){ ?>
            .blog_holder.blog_post_info_vertical_content article.format-quote .post_text .post_title h3 a,
            .blog_holder.blog_post_info_vertical_content article.format-link .post_text .post_title h3 a,
            .blog_holder.blog_post_info_vertical_content article.format-quote .post_text .post_title h3,
            .blog_holder.blog_post_info_vertical_content article.format-link .post_text .post_title h3
            {
            color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_content_ql_title_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_post_info_vertical_content_ql_title_hover_color']) && !empty($mkd_options['blog_post_info_vertical_content_ql_title_hover_color'])){ ?>
            .blog_holder.blog_post_info_vertical_content article.format-quote .post_text .post_text_inner:hover .post_title h3 a,
            .blog_holder.blog_post_info_vertical_content article.format-link .post_text .post_text_inner:hover .post_title h3 a,
            .blog_holder.blog_post_info_vertical_content article.format-quote .post_text .post_text_inner:hover .post_title h3,
            .blog_holder.blog_post_info_vertical_content article.format-link .post_text .post_text_inner:hover .post_title h3
            {
            color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_content_ql_title_hover_color']);  ?>;
            }
		<?php } ?>
		<?php
		/**************** BLOG POST INFO VERTICAL CONTENT: Qoute Author Style ****************/
		$blog_post_info_vertical_content_ql_author_style = array();

		if(isset($mkd_options['blog_post_info_vertical_content_ql_author_google_fonts']) && $mkd_options['blog_post_info_vertical_content_ql_author_google_fonts'] !== '-1') {
			$blog_post_info_vertical_content_ql_author_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_post_info_vertical_content_ql_author_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_post_info_vertical_content_ql_author_fontsize']) && $mkd_options['blog_post_info_vertical_content_ql_author_fontsize'] !== '') {
			$blog_post_info_vertical_content_ql_author_style[] = 'font-size: '.intval($mkd_options['blog_post_info_vertical_content_ql_author_fontsize']).'px';
		}

		if(isset($mkd_options['blog_post_info_vertical_content_ql_author_lineheight']) && $mkd_options['blog_post_info_vertical_content_ql_author_lineheight'] !== '') {
			$blog_post_info_vertical_content_ql_author_style[] = 'line-height: '.intval($mkd_options['blog_post_info_vertical_content_ql_author_lineheight']).'px';
		}

		if(isset($mkd_options['blog_post_info_vertical_content_ql_author_letterspacing']) && $mkd_options['blog_post_info_vertical_content_ql_author_letterspacing'] !== '') {
			$blog_post_info_vertical_content_ql_author_style[] = 'letter-spacing: '.intval($mkd_options['blog_post_info_vertical_content_ql_author_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_post_info_vertical_content_ql_author_fontweight']) && $mkd_options['blog_post_info_vertical_content_ql_author_fontweight'] !== '') {
			$blog_post_info_vertical_content_ql_author_style[] = 'font-weight: '.intval($mkd_options['blog_post_info_vertical_content_ql_author_fontweight']);
		}

		if(isset($mkd_options['blog_post_info_vertical_content_ql_author_fontstyle']) && $mkd_options['blog_post_info_vertical_content_ql_author_fontstyle'] !== '') {
			$blog_post_info_vertical_content_ql_author_style[] = 'font-style: '.$mkd_options['blog_post_info_vertical_content_ql_author_fontstyle'];
		}

		if(isset($mkd_options['blog_post_info_vertical_content_ql_author_texttransform']) && $mkd_options['blog_post_info_vertical_content_ql_author_texttransform'] !== '') {
			$blog_post_info_vertical_content_ql_author_style[] = 'text-transform: '.$mkd_options['blog_post_info_vertical_content_ql_author_texttransform'];
		}

		if(is_array($blog_post_info_vertical_content_ql_author_style) && count($blog_post_info_vertical_content_ql_author_style)) { ?>
            .blog_holder.blog_post_info_vertical_content article.format-quote .post_text .quote_author{
			<?php echo esc_attr(implode(';', $blog_post_info_vertical_content_ql_author_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_post_info_vertical_content_ql_author_color']) && !empty($mkd_options['blog_post_info_vertical_content_ql_author_color'])){ ?>
            .blog_holder.blog_post_info_vertical_content article.format-quote .post_text .quote_author{
            color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_content_ql_author_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_post_info_vertical_content_ql_author_hover_color']) && !empty($mkd_options['blog_post_info_vertical_content_ql_author_hover_color'])){ ?>
            .blog_holder.blog_post_info_vertical_content article.format-quote .post_text .post_text_inner:hover .quote_author{
            color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_content_ql_author_hover_color']);  ?>;
            }
		<?php } ?>
		<?php
		/**************** BLOG POST INFO VERTICAL CONTENT: Info Style ****************/
		$blog_post_info_vertical_content_info_style = array();

		if(isset($mkd_options['blog_post_info_vertical_content_info_google_fonts']) && $mkd_options['blog_post_info_vertical_content_info_google_fonts'] !== '-1') {
			$blog_post_info_vertical_content_info_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_post_info_vertical_content_info_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_post_info_vertical_content_info_fontsize']) && $mkd_options['blog_post_info_vertical_content_info_fontsize'] !== '') {
			$blog_post_info_vertical_content_info_style[] = 'font-size: '.intval($mkd_options['blog_post_info_vertical_content_info_fontsize']).'px';
		}

		if(isset($mkd_options['blog_post_info_vertical_content_info_lineheight']) && $mkd_options['blog_post_info_vertical_content_info_lineheight'] !== '') {
			$blog_post_info_vertical_content_info_style[] = 'line-height: '.intval($mkd_options['blog_post_info_vertical_content_info_lineheight']).'px';
		}

		if(isset($mkd_options['blog_post_info_vertical_content_info_letterspacing']) && $mkd_options['blog_post_info_vertical_content_info_letterspacing'] !== '') {
			$blog_post_info_vertical_content_info_style[] = 'letter-spacing: '.intval($mkd_options['blog_post_info_vertical_content_info_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_post_info_vertical_content_info_fontweight']) && $mkd_options['blog_post_info_vertical_content_info_fontweight'] !== '') {
			$blog_post_info_vertical_content_info_style[] = 'font-weight: '.intval($mkd_options['blog_post_info_vertical_content_info_fontweight']);
		}

		if(isset($mkd_options['blog_post_info_vertical_content_info_fontstyle']) && $mkd_options['blog_post_info_vertical_content_info_fontstyle'] !== '') {
			$blog_post_info_vertical_content_info_style[] = 'font-style: '.$mkd_options['blog_post_info_vertical_content_info_fontstyle'];
		}

		if(isset($mkd_options['blog_post_info_vertical_content_info_texttransform']) && $mkd_options['blog_post_info_vertical_content_info_texttransform'] !== '') {
			$blog_post_info_vertical_content_info_style[] = 'text-transform: '.$mkd_options['blog_post_info_vertical_content_info_texttransform'];
		}
		if(is_array($blog_post_info_vertical_content_info_style) && count($blog_post_info_vertical_content_info_style)) { ?>

            .blog_holder.blog_post_info_vertical_content article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info div{
			<?php echo esc_attr(implode(';', $blog_post_info_vertical_content_info_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_post_info_vertical_content_info_color']) && !empty($mkd_options['blog_post_info_vertical_content_info_color'])){ ?>
            .blog_holder.blog_post_info_vertical_content article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info div
            {
            color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_content_info_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_post_info_vertical_content_info_link_color']) && !empty($mkd_options['blog_post_info_vertical_content_info_link_color'])){ ?>
            .blog_holder.blog_post_info_vertical_content article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info div a
            {
            color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_content_info_link_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_post_info_vertical_content_info_hover_color']) && !empty($mkd_options['blog_post_info_vertical_content_info_hover_color'])){ ?>
            .blog_holder.blog_post_info_vertical_content article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info div a:hover{
            color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_content_info_hover_color']);  ?>;
            }
		<?php } ?>


		<?php
		/****************  BLOG POST INFO VERTICAL CONTENT: Quote/Link TExt Style *********************/
		$blog_post_info_vertical_content_ql_info_style = array();

		if(isset($mkd_options['blog_post_info_vertical_content_ql_info_google_fonts']) && $mkd_options['blog_post_info_vertical_content_ql_info_google_fonts'] !== '-1') {
			$blog_post_info_vertical_content_ql_info_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_post_info_vertical_content_ql_info_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_post_info_vertical_content_ql_info_fontsize']) && $mkd_options['blog_post_info_vertical_content_ql_info_fontsize'] !== '') {
			$blog_post_info_vertical_content_ql_info_style[] = 'font-size: '.intval($mkd_options['blog_post_info_vertical_content_ql_info_fontsize']).'px';
		}

		if(isset($mkd_options['blog_post_info_vertical_content_ql_info_lineheight']) && $mkd_options['blog_post_info_vertical_content_ql_info_lineheight'] !== '') {
			$blog_post_info_vertical_content_ql_info_style[] = 'line-height: '.intval($mkd_options['blog_post_info_vertical_content_ql_info_lineheight']).'px';
		}

		if(isset($mkd_options['blog_post_info_vertical_content_ql_info_letterspacing']) && $mkd_options['blog_post_info_vertical_content_ql_info_letterspacing'] !== '') {
			$blog_post_info_vertical_content_ql_info_style[] = 'letter-spacing: '.intval($mkd_options['blog_post_info_vertical_content_ql_info_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_post_info_vertical_content_ql_info_fontweight']) && $mkd_options['blog_post_info_vertical_content_ql_info_fontweight'] !== '') {
			$blog_post_info_vertical_content_ql_info_style[] = 'font-weight: '.intval($mkd_options['blog_post_info_vertical_content_ql_info_fontweight']);
		}

		if(isset($mkd_options['blog_post_info_vertical_content_ql_info_fontstyle']) && $mkd_options['blog_post_info_vertical_content_ql_info_fontstyle'] !== '') {
			$blog_post_info_vertical_content_ql_info_style[] = 'font-style: '.$mkd_options['blog_post_info_vertical_content_ql_info_fontstyle'];
		}

		if(isset($mkd_options['blog_post_info_vertical_content_ql_info_texttransform']) && $mkd_options['blog_post_info_vertical_content_ql_info_texttransform'] !== '') {
			$blog_post_info_vertical_content_ql_info_style[] = 'text-transform: '.$mkd_options['blog_post_info_vertical_content_ql_info_texttransform'];
		}
		if(is_array($blog_post_info_vertical_content_ql_info_style) && count($blog_post_info_vertical_content_ql_info_style)) { ?>
            .blog_holder.blog_post_info_vertical_content article.format-quote .post_text .post_text_inner .post_info,
            .blog_holder.blog_post_info_vertical_content article.format-link .post_text .post_text_inner .post_info{
			<?php echo esc_attr(implode(';', $blog_post_info_vertical_content_ql_info_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_post_info_vertical_content_ql_info_color']) && !empty($mkd_options['blog_post_info_vertical_content_ql_info_color'])){ ?>
            .blog_holder.blog_post_info_vertical_content article.format-quote .post_text .post_text_inner .post_info,
            .blog_holder.blog_post_info_vertical_content article.format-link .post_text .post_text_inner .post_info{
            color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_content_ql_info_color']);  ?>;
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_post_info_vertical_content_ql_info_link_color']) && !empty($mkd_options['blog_post_info_vertical_content_ql_info_link_color'])){ ?>
            .blog_holder.blog_post_info_vertical_content article.format-quote .post_text .post_text_inner .post_info a,
            .blog_holder.blog_post_info_vertical_content article.format-link .post_text .post_text_inner .post_info a{
            color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_content_ql_info_link_color']);  ?>;
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_post_info_vertical_content_ql_info_hover_color']) && !empty($mkd_options['blog_post_info_vertical_content_ql_info_hover_color'])){ ?>
            .blog_holder.blog_post_info_vertical_content article.format-quote .post_text .post_text_inner:hover .post_info,
            .blog_holder.blog_post_info_vertical_content article.format-link .post_text .post_text_inner:hover .post_info,
            .blog_holder.blog_post_info_vertical_content article.format-quote .post_text .post_text_inner:hover .post_info div a,
            .blog_holder.blog_post_info_vertical_content article.format-link .post_text .post_text_inner:hover .post_info div a{
            color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_content_ql_info_hover_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_post_info_vertical_content_ql_mark_color']) && !empty($mkd_options['blog_post_info_vertical_content_ql_mark_color'])){ ?>
            .blog_holder.blog_post_info_vertical_content article.format-quote .post_text .post_text_inner .post_info_quote_mark .quote_mark,
            .blog_holder.blog_post_info_vertical_content article.format-link .post_text .post_text_inner .post_info_link_mark .link_mark{
            color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_content_ql_mark_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_post_info_vertical_content_ql_mark_hover_color']) && !empty($mkd_options['blog_post_info_vertical_content_ql_mark_hover_color'])){ ?>
            .blog_holder.blog_post_info_vertical_content article.format-quote .post_text .post_text_inner:hover .post_info .post_info_quote_mark .quote_mark,
            .blog_holder.blog_post_info_vertical_content article.format-link .post_text .post_text_inner:hover .post_info .post_info_link_mark .link_mark{
            color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_content_ql_mark_hover_color']);  ?>;
            }
		<?php } ?>

		<?php
		/******** BLOG: POST INFO VERTICAL - POST INFO DATE Box ********/
		$blog_date_box_style = array();
		if(isset($mkd_options['blog_post_info_vertical_content_date_box_background_color']) && $mkd_options['blog_post_info_vertical_content_date_box_background_color'] !== '') {
			$blog_date_box_style[] = 'background-color: '.$mkd_options['blog_post_info_vertical_content_date_box_background_color'];
		}
		if(isset($mkd_options['blog_post_info_vertical_content_date_box_color']) && $mkd_options['blog_post_info_vertical_content_date_box_color'] !== '') {
			$blog_date_box_style[] = 'color: '.$mkd_options['blog_post_info_vertical_content_date_box_color'];
		}
		if(is_array($blog_date_box_style) && count($blog_date_box_style)) { ?>
            .blog_holder.blog_post_info_vertical_content article .post_icon_date{
			<?php echo esc_attr(implode(';', $blog_date_box_style)); ?>
            }
		<?php }
		?>

		<?php
		/******************* BLOG: POST INFO VERTICAL CONTENT - POST INFO LIKE BOX ***************/
		if(isset($mkd_options['blog_post_info_vertical_content_like_box_background_color']) && ($mkd_options['blog_post_info_vertical_content_like_box_background_color'] != '')){ ?>
            .blog_holder.blog_post_info_vertical_content article .post_icon_like{
            background-color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_content_like_box_background_color']);  ?> ;
            }
		<?php } ?>
		<?php
		if(isset($mkd_options['blog_post_info_vertical_content_like_box_color']) && ($mkd_options['blog_post_info_vertical_content_like_box_color'] != '')){ ?>
            .blog_holder.blog_post_info_vertical_content article .post_icon_like .blog_like a{
            color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_content_like_box_color']);  ?> ;
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_post_info_vertical_content_like_box_hover_color']) && ($mkd_options['blog_post_info_vertical_content_like_box_hover_color'] != '')){ ?>
            .blog_holder.blog_post_info_vertical_content article .post_icon_like .blog_like a:hover{
            color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_content_like_box_hover_color']);  ?> ;
            }
		<?php } ?>
		<?php
		/******************* BLOG: POST INFO VERTICAL CONTENT - POST INFO SHARE BOX ***************/
		if(isset($mkd_options['blog_post_info_vertical_content_share_box_background_color']) && ($mkd_options['blog_post_info_vertical_content_share_box_background_color'] != '')){ ?>
            .blog_holder.blog_post_info_vertical_content article .post_icon_share{
            background-color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_content_share_box_background_color']);  ?> ;
            }
		<?php } ?>
		<?php
		if(isset($mkd_options['blog_post_info_vertical_content_share_box_color']) && ($mkd_options['blog_post_info_vertical_content_share_box_color'] != '')){ ?>
            .blog_holder.blog_post_info_vertical_content article .post_icon_share .blog_share .social_share_holder a{
            color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_content_share_box_color']);  ?> ;
            }
		<?php } ?>
		<?php
		if(isset($mkd_options['blog_post_info_vertical_content_share_box_hover_color']) && ($mkd_options['blog_post_info_vertical_content_share_box_hover_color'] != '')){ ?>
            .blog_holder.blog_post_info_vertical_content article .post_icon_share .blog_share .social_share_holder a:hover{
            color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_content_share_box_hover_color']);  ?> ;
            }
		<?php } ?>
		<?php
		/******** BLOG: IMAGE WITH ICON (CENTERED) Share options ********/
		if(isset($mkd_options['blog_image_with_icon_centered_show_share']) && $mkd_options['blog_image_with_icon_centered_show_share'] == 'yes') {

			if(isset($mkd_options['blog_image_with_icon_centered_share_icon_color']) && $mkd_options['blog_image_with_icon_centered_share_icon_color'] !== '') {?>
                .blog_holder.blog_image_with_icon_centered .post_text .post_text_inner span a.share_link,
                .blog_holder.blog_image_with_icon_centered .post_text .post_text_inner span a.share_link span,
                .blog_holder.blog_image_with_icon_centered article.format-link .post_text.link_image .post_text_inner:hover .post_info .social_share_dropdown ul li span.social_network_icon{
                color:  <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_share_icon_color']); ?> ;
                }
			<?php } ?>
			<?php if(isset($mkd_options['blog_image_with_icon_centered_share_background_color']) && $mkd_options['blog_image_with_icon_centered_share_background_color'] !== '') {?>
                .blog_holder.blog_image_with_icon_centered .social_share_dropdown ul li a{
                background-color:  <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_share_background_color']); ?> ;
                }
			<?php } ?>
			<?php if(isset($mkd_options['blog_image_with_icon_centered_share_icon_hover_color']) && $mkd_options['blog_image_with_icon_centered_share_icon_hover_color'] !== '') {?>
                .blog_holder.blog_image_with_icon_centered .social_share_dropdown ul li:hover,
                .blog_holder.blog_image_with_icon_centered .social_share_dropdown ul li:hover a span.social_network_icon{
                color:  <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_share_icon_hover_color']); ?> !important;
                }
			<?php } ?>
		<?php } ?>
		<?php
		/******** BLOG: IMAGE WITH ICON (CENTERED)  Separator ********/
		$blog_image_with_icon_centered_separator_style = array();
		if(isset($mkd_options['blog_image_with_icon_centered_separator_border_color']) && $mkd_options['blog_image_with_icon_centered_separator_border_color'] !== '') {
			$blog_image_with_icon_centered_separator_style[] = 'border-color: '.$mkd_options['blog_image_with_icon_centered_separator_border_color'];
		}
		if(isset($mkd_options['blog_image_with_icon_centered_separator_width']) && $mkd_options['blog_image_with_icon_centered_separator_width'] !== '') {
			$blog_image_with_icon_centered_separator_style[] = 'width: '.intval($mkd_options['blog_image_with_icon_centered_separator_width']).'px';
		}
		if(isset($mkd_options['blog_image_with_icon_centered_separator_thickness']) && $mkd_options['blog_image_with_icon_centered_separator_thickness'] !== '') {
			$blog_image_with_icon_centered_separator_style[] = 'border-width: '.intval($mkd_options['blog_image_with_icon_centered_separator_thickness']).'px';
		}

		if(is_array($blog_image_with_icon_centered_separator_style) && count($blog_image_with_icon_centered_separator_style)) { ?>
            .blog_holder.blog_image_with_icon_centered article .post_text .post_text_inner .separator.small{
			<?php echo esc_attr(implode(';', $blog_image_with_icon_centered_separator_style)); ?>
            }
		<?php } ?>

		<?php
		/******** BLOG: IMAGE WITH ICON (CENTERED) Text Box ********/
		if(isset($mkd_options['blog_image_with_icon_centered_enable_text_box']) && $mkd_options['blog_image_with_icon_centered_enable_text_box'] == 'yes') {
			$blog_box_style = array();
			?>
            .blog_holder.blog_image_with_icon_centered article:not(.format-link):not(.format-quote) .post_content_holder .mkd_icon.circle,
            .blog_holder.blog_image_with_icon_centered article .post_content_holder .audio_image,
            .blog_holder.blog_image_with_icon_centered article.format-video .post_image{
            margin-bottom: 0;
            }
			<?php
			if(isset($mkd_options['blog_image_with_icon_centered_box_background_color']) && $mkd_options['blog_image_with_icon_centered_box_background_color'] !== '') {
				$blog_box_style[] = 'background-color: '.$mkd_options['blog_image_with_icon_centered_box_background_color'];
			}

			if(isset($mkd_options['blog_image_with_icon_centered_box_border_color']) && $mkd_options['blog_image_with_icon_centered_box_border_color'] !== '') {
				$blog_box_style[] = 'border: 1px solid';
				$blog_box_style[] = 'border-color: '.$mkd_options['blog_image_with_icon_centered_box_border_color'];
			}

			if(isset($mkd_options['blog_image_with_icon_centered_box_padding']) && $mkd_options['blog_image_with_icon_centered_box_padding'] !== '') {
				$blog_box_style[] = 'padding: '.$mkd_options['blog_image_with_icon_centered_box_padding'];
			}

			if(is_array($blog_box_style) && count($blog_box_style)) { ?>
                .blog_holder.blog_image_with_icon_centered article:not(.format-link):not(.format-quote) .post_text .post_text_inner{
				<?php echo esc_attr(implode(';', $blog_box_style)); ?>
                }
			<?php }} ?>

		<?php
		/******** BLOG: IMAGE WITH ICON (CENTRERED) Quote/Link Text Box ********/
		if(isset($mkd_options['blog_image_with_icon_centered_ql_background_color']) &&($mkd_options['blog_image_with_icon_centered_ql_background_color'])!==""){ ?>
            .blog_holder.blog_image_with_icon_centered article.format-link .post_text .post_text_inner,
            .blog_holder.blog_image_with_icon_centered article.format-quote .post_text .post_text_inner{
            background-color: <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_ql_background_color']);  ?>;
            }
			<?php  $blog_image_with_icon_centered_ql_background_color = mikado_one_mikado_hex2rgb($mkd_options['blog_image_with_icon_centered_ql_background_color']); ?>

            .blog_holder.blog_image_with_icon_centered article.format-link .post_text.link_image .post_text_inner,
            .blog_holder.blog_image_with_icon_centered article.format-quote .post_text.quote_image .post_text_inner{
			<?php if (!empty($mkd_options['blog_image_with_icon_centered_ql_background_color'])) { ?>  background-color: rgba(<?php echo esc_attr($blog_image_with_icon_centered_ql_background_color[0]); ?>,<?php echo esc_attr($blog_image_with_icon_centered_ql_background_color[1]); ?>,<?php echo esc_attr($blog_image_with_icon_centered_ql_background_color[2]); ?>,0.85); <?php } ?>
            }

		<?php } ?>

		<?php if(isset($mkd_options['blog_image_with_icon_centered_ql_hover_background_color']) && !empty($mkd_options['blog_image_with_icon_centered_ql_hover_background_color'])){ ?>
            .blog_holder.blog_image_with_icon_centered article.format-link .post_text .post_text_inner:hover,
            .blog_holder.blog_image_with_icon_centered article.format-quote .post_text .post_text_inner:hover{
            background-color: <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_ql_hover_background_color']);  ?>;
            }
			<?php  $blog_image_with_icon_centered_ql_hover_background_color = mikado_one_mikado_hex2rgb($mkd_options['blog_image_with_icon_centered_ql_hover_background_color']); ?>

            .blog_holder.blog_image_with_icon_centered article.format-link .post_text.link_image .post_text_inner:hover,
            .blog_holder.blog_image_with_icon_centered article.format-quote .post_text.quote_image .post_text_inner:hover{
			<?php if (!empty($mkd_options['blog_image_with_icon_centered_ql_hover_background_color'])) { ?>  background-color: rgba(<?php echo esc_attr($blog_image_with_icon_centered_ql_hover_background_color[0]); ?>,<?php echo esc_attr($blog_image_with_icon_centered_ql_hover_background_color[1]); ?>,<?php echo esc_attr($blog_image_with_icon_centered_ql_hover_background_color[2]); ?>,0.6); <?php } ?>
            }

		<?php } ?>

		<?php
		/******************* BLOG: IMAGE WITH ICON (CENTRERED) Border/Icon Post Color  ***************/
		if(isset($mkd_options['blog_image_with_icon_centered_ql_border_icon_color_standard']) && ($mkd_options['blog_image_with_icon_centered_ql_border_icon_color_standard'] != '')){ ?>
            .blog_holder.blog_image_with_icon_centered article.format-standard .post_content_holder .mkd_icon.circle .mkd_font_elegant_holder_icon.circle
            {
            background-color: <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_ql_border_icon_color_standard']);  ?> ;
            }
            .blog_holder.blog_image_with_icon_centered article.format-standard .post_image{
            border-color: <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_ql_border_icon_color_standard']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_image_with_icon_centered_ql_border_icon_color_gallery']) && ($mkd_options['blog_image_with_icon_centered_ql_border_icon_color_gallery'] != '')){ ?>
            .blog_holder.blog_image_with_icon_centered article.format-gallery .post_content_holder .mkd_icon.circle .mkd_font_elegant_holder_icon.circle
            {
            background-color: <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_ql_border_icon_color_gallery']);  ?> ;
            }
            .blog_holder.blog_image_with_icon_centered article.format-gallery .post_image img{
            border-color: <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_ql_border_icon_color_gallery']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_image_with_icon_centered_ql_border_icon_color_quote']) && !empty($mkd_options['blog_image_with_icon_centered_ql_border_icon_color_quote'])){ ?>
            .blog_holder.blog_image_with_icon_centered article.format-quote .post_content_holder .post_text .post_text_inner .mkd_icon.circle .mkd_font_elegant_holder_icon.circle    {
            background-color: <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_ql_border_icon_color_quote']);  ?> ;
            }
            .blog_holder.blog_image_with_icon_centered article.format-quote .post_content_holder .post_text .post_text_inner
            {
            border-color: <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_ql_border_icon_color_quote']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_image_with_icon_centered_ql_border_icon_color_link']) && !empty($mkd_options['blog_image_with_icon_centered_ql_border_icon_color_link'])){ ?>
            .blog_holder.blog_image_with_icon_centered article.format-link .post_content_holder .mkd_icon.circle .mkd_font_elegant_holder_icon.circle
            {
            background-color: <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_ql_border_icon_color_link']);  ?> !important;
            }
            .blog_holder.blog_image_with_icon_centered article.format-link .post_content_holder .post_text .post_text_inner
            {
            border-color: <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_ql_border_icon_color_link']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_image_with_icon_centered_ql_border_icon_color_audio']) && !empty($mkd_options['blog_image_with_icon_centered_ql_border_icon_color_audio'])){ ?>
            .blog_holder.blog_image_with_icon_centered article.format-audio .post_content_holder .mkd_icon.circle .mkd_font_elegant_holder_icon.circle
            {
            background-color: <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_ql_border_icon_color_audio']);  ?> !important;
            }
            .blog_holder.blog_image_with_icon_centered article.format-audio .post_image{
            border-color: <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_ql_border_icon_color_audio']);  ?>;
            }
		<?php } ?>

		<?php
		/**************** BLOG IMAGE WITH ICON CENTERED: Spacing  ****************/
		if(isset($mkd_options['blog_image_with_icon_centered_image_margin_bottom']) && $mkd_options['blog_image_with_icon_centered_image_margin_bottom'] !== '') { ?>
            .blog_holder.blog_image_with_icon_centered article:not(.format-link):not(.format-quote) .post_content_holder .mkd_icon.circle,
            .blog_holder.blog_image_with_icon_centered article .post_content_holder .audio_image,
            .blog_holder.blog_image_with_icon_centered article.format-video .post_image{
            margin-bottom : <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_image_margin_bottom']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_image_with_icon_centered_category_margin_bottom']) && $mkd_options['blog_image_with_icon_centered_category_margin_bottom'] !== '') { ?>
            .blog_holder.blog_image_with_icon_centered article:not(.format-link):not(.format-quote) .post_content_holder .post_text .post_category{
            margin-bottom : <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_category_margin_bottom']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_image_with_icon_centered_title_margin_bottom']) && $mkd_options['blog_image_with_icon_centered_title_margin_bottom'] !== '') { ?>
            .blog_holder.blog_image_with_icon_centered article .post_content_holder .post_text h2{
            margin-bottom : <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_title_margin_bottom']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_image_with_icon_centered_post_info_margin_top']) && $mkd_options['blog_image_with_icon_centered_post_info_margin_top'] !== '') { ?>
            .blog_holder.blog_image_with_icon_centered article:not(.format-link):not(.format-quote) .post_info{
            margin-top : <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_post_info_margin_top']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_image_with_icon_centered_separator_margin_top']) && $mkd_options['blog_image_with_icon_centered_separator_margin_top'] !== '') { ?>
            .blog_holder.blog_image_with_icon_centered article .post_text .post_text_inner .separator.small{
            margin-top : <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_separator_margin_top']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_image_with_icon_centered_separator_margin_bottom']) && $mkd_options['blog_image_with_icon_centered_separator_margin_bottom'] !== '') { ?>
            .blog_holder.blog_image_with_icon_centered article .post_text .post_text_inner .separator.small{
            margin-bottom : <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_separator_margin_bottom']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_image_with_icon_centered_article_margin_bottom']) && $mkd_options['blog_image_with_icon_centered_article_margin_bottom'] !== '') { ?>
            .blog_holder.blog_image_with_icon_centered:not(.blog_single) article{
            margin-bottom : <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_article_margin_bottom']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_image_with_icon_centered_ql_category_margin_bottom']) && $mkd_options['blog_image_with_icon_centered_ql_category_margin_bottom'] !== '') { ?>
            .blog_holder.blog_image_with_icon_centered article.format-quote .post_text_inner .post_category,
            .blog_holder.blog_image_with_icon_centered article.format-link .post_text_inner .post_category{
            margin-bottom : <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_ql_category_margin_bottom']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_image_with_icon_centered_ql_quote_author_margin_top']) && $mkd_options['blog_image_with_icon_centered_ql_quote_author_margin_top'] !== '') { ?>
            .blog_holder.blog_image_with_icon_centered article.format-quote .post_text_inner .quote_author{
            margin-top : <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_ql_quote_author_margin_top']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_image_with_icon_centered_ql_post_info_margin_top']) && $mkd_options['blog_image_with_icon_centered_ql_post_info_margin_top'] !== '') { ?>
            .blog_holder.blog_image_with_icon_centered article.format-link .post_info,
            .blog_holder.blog_image_with_icon_centered article.format-quote .post_info{
            margin-top : <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_ql_post_info_margin_top']).'px';?>
            }
		<?php } ?>


		<?php
		/**************** BLOG IMAGE WITH ICON (CENTRERED): Title Style ****************/
		$blog_image_with_icon_centered_title_style = array();

		if(isset($mkd_options['blog_image_with_icon_centered_title_google_fonts']) && $mkd_options['blog_image_with_icon_centered_title_google_fonts'] !== '-1') {
			$blog_image_with_icon_centered_title_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_image_with_icon_centered_title_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_image_with_icon_centered_title_fontsize']) && $mkd_options['blog_image_with_icon_centered_title_fontsize'] !== '') {
			$blog_image_with_icon_centered_title_style[] = 'font-size: '.intval($mkd_options['blog_image_with_icon_centered_title_fontsize']).'px';
		}

		if(isset($mkd_options['blog_image_with_icon_centered_title_lineheight']) && $mkd_options['blog_image_with_icon_centered_title_lineheight'] !== '') {
			$blog_image_with_icon_centered_title_style[] = 'line-height: '.intval($mkd_options['blog_image_with_icon_centered_title_lineheight']).'px';
		}

		if(isset($mkd_options['blog_image_with_icon_centered_title_letterspacing']) && $mkd_options['blog_image_with_icon_centered_title_letterspacing'] !== '') {
			$blog_image_with_icon_centered_title_style[] = 'letter-spacing: '.intval($mkd_options['blog_image_with_icon_centered_title_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_image_with_icon_centered_title_fontweight']) && $mkd_options['blog_image_with_icon_centered_title_fontweight'] !== '') {
			$blog_image_with_icon_centered_title_style[] = 'font-weight: '.intval($mkd_options['blog_image_with_icon_centered_title_fontweight']);
		}

		if(isset($mkd_options['blog_image_with_icon_centered_title_fontstyle']) && $mkd_options['blog_image_with_icon_centered_title_fontstyle'] !== '') {
			$blog_image_with_icon_centered_title_style[] = 'font-style: '.$mkd_options['blog_image_with_icon_centered_title_fontstyle'];
		}

		if(isset($mkd_options['blog_image_with_icon_centered_title_texttransform']) && $mkd_options['blog_image_with_icon_centered_title_texttransform'] !== '') {
			$blog_image_with_icon_centered_title_style[] = 'text-transform: '.$mkd_options['blog_image_with_icon_centered_title_texttransform'];
		}

		if(is_array($blog_image_with_icon_centered_title_style) && count($blog_image_with_icon_centered_title_style)) { ?>
            .blog_holder.blog_image_with_icon_centered article:not(.format-quote):not(.format-link) h2{
			<?php echo esc_attr(implode(';', $blog_image_with_icon_centered_title_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_image_with_icon_centered_title_color']) && !empty($mkd_options['blog_image_with_icon_centered_title_color'])){ ?>
            .blog_holder.blog_image_with_icon_centered article:not(.format-quote):not(.format-link) h2 a,
            .blog_holder.blog_image_with_icon_centered.blog_single article:not(.format-quote):not(.format-link) h2{
            color: <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_title_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_image_with_icon_centered_title_hover_color']) && !empty($mkd_options['blog_image_with_icon_centered_title_hover_color'])){ ?>
            .blog_holder.blog_image_with_icon_centered article:not(.format-quote):not(.format-link)  h2 a:hover,
            .blog_holder.blog_image_with_icon_centered article:not(.format-quote):not(.format-link) h2:hover{
            color: <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_title_hover_color']);  ?>;
            }
		<?php } ?>
		<?php
		/**************** BLOG POST INFO VERTICAL (CENTRERED): Category Style ****************/
		$blog_image_with_icon_centered_category_style = array();

		if(isset($mkd_options['blog_image_with_icon_centered_category_google_fonts']) && $mkd_options['blog_image_with_icon_centered_category_google_fonts'] !== '-1') {
			$blog_image_with_icon_centered_category_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_image_with_icon_centered_category_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_image_with_icon_centered_category_fontsize']) && $mkd_options['blog_image_with_icon_centered_category_fontsize'] !== '') {
			$blog_image_with_icon_centered_category_style[] = 'font-size: '.intval($mkd_options['blog_image_with_icon_centered_category_fontsize']).'px';
		}

		if(isset($mkd_options['blog_image_with_icon_centered_category_lineheight']) && $mkd_options['blog_image_with_icon_centered_category_lineheight'] !== '') {
			$blog_image_with_icon_centered_category_style[] = 'line-height: '.$mkd_options['blog_image_with_icon_centered_category_lineheight'].'px';
		}

		if(isset($mkd_options['blog_image_with_icon_centered_category_letterspacing']) && $mkd_options['blog_image_with_icon_centered_category_letterspacing'] !== '') {
			$blog_image_with_icon_centered_category_style[] = 'letter-spacing: '.intval($mkd_options['blog_image_with_icon_centered_category_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_image_with_icon_centered_category_fontweight']) && $mkd_options['blog_image_with_icon_centered_category_fontweight'] !== '') {
			$blog_image_with_icon_centered_category_style[] = 'font-weight: '.intval($mkd_options['blog_image_with_icon_centered_category_fontweight']);
		}

		if(isset($mkd_options['blog_image_with_icon_centered_category_fontstyle']) && $mkd_options['blog_image_with_icon_centered_category_fontstyle'] !== '') {
			$blog_image_with_icon_centered_category_style[] = 'font-style: '.$mkd_options['blog_image_with_icon_centered_category_fontstyle'];
		}

		if(isset($mkd_options['blog_image_with_icon_centered_category_texttransform']) && $mkd_options['blog_image_with_icon_centered_category_texttransform'] !== '') {
			$blog_image_with_icon_centered_category_style[] = 'text-transform: '.$mkd_options['blog_image_with_icon_centered_category_texttransform'];
		}

		if(is_array($blog_image_with_icon_centered_category_style) && count($blog_image_with_icon_centered_category_style)) { ?>
            .blog_holder.blog_image_with_icon_centered article:not(.format-quote):not(.format-link) .post_content_holder .post_text .post_category a
            {
			<?php echo esc_attr(implode(';', $blog_image_with_icon_centered_category_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_image_with_icon_centered_category_color']) && !empty($mkd_options['blog_image_with_icon_centered_category_color'])){ ?>
            .blog_holder.blog_image_with_icon_centered article:not(.format-quote):not(.format-link) .post_content_holder .post_text .post_category a{
            color: <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_category_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_image_with_icon_centered_category_hover_color']) && !empty($mkd_options['blog_image_with_icon_centered_category_hover_color'])){ ?>
            .blog_holder.blog_image_with_icon_centered article:not(.format-quote):not(.format-link) .post_content_holder .post_text .post_category a:hover{
            color: <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_category_hover_color']);  ?>;
            }
		<?php } ?>
		<?php
		/**************** BLOG: IMAGE WITH ICON (CENTRERED): Qoute/Link Title Style ****************/
		$blog_image_with_icon_centered_ql_title_style = array();

		if(isset($mkd_options['blog_image_with_icon_centered_ql_title_google_fonts']) && $mkd_options['blog_image_with_icon_centered_ql_title_google_fonts'] !== '-1') {
			$blog_image_with_icon_centered_ql_title_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_image_with_icon_centered_ql_title_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_image_with_icon_centered_ql_title_fontsize']) && $mkd_options['blog_image_with_icon_centered_ql_title_fontsize'] !== '') {
			$blog_image_with_icon_centered_ql_title_style[] = 'font-size: '.intval($mkd_options['blog_image_with_icon_centered_ql_title_fontsize']).'px';
		}

		if(isset($mkd_options['blog_image_with_icon_centered_ql_title_lineheight']) && $mkd_options['blog_image_with_icon_centered_ql_title_lineheight'] !== '') {
			$blog_image_with_icon_centered_ql_title_style[] = 'line-height: '.$mkd_options['blog_image_with_icon_centered_ql_title_lineheight'].'px';
		}

		if(isset($mkd_options['blog_image_with_icon_centered_ql_title_letterspacing']) && $mkd_options['blog_image_with_icon_centered_ql_title_letterspacing'] !== '') {
			$blog_image_with_icon_centered_ql_title_style[] = 'letter-spacing: '.$mkd_options['blog_image_with_icon_centered_ql_title_letterspacing'].'px';
		}

		if(isset($mkd_options['blog_image_with_icon_centered_ql_title_fontweight']) && $mkd_options['blog_image_with_icon_centered_ql_title_fontweight'] !== '') {
			$blog_image_with_icon_centered_ql_title_style[] = 'font-weight: '.intval($mkd_options['blog_image_with_icon_centered_ql_title_fontweight']);
		}

		if(isset($mkd_options['blog_image_with_icon_centered_ql_title_fontstyle']) && $mkd_options['blog_image_with_icon_centered_ql_title_fontstyle'] !== '') {
			$blog_image_with_icon_centered_ql_title_style[] = 'font-style: '.$mkd_options['blog_image_with_icon_centered_ql_title_fontstyle'];
		}

		if(isset($mkd_options['blog_image_with_icon_centered_ql_title_texttransform']) && $mkd_options['blog_image_with_icon_centered_ql_title_texttransform'] !== '') {
			$blog_image_with_icon_centered_ql_title_style[] = 'text-transform: '.$mkd_options['blog_image_with_icon_centered_ql_title_texttransform'];
		}

		if(is_array($blog_image_with_icon_centered_ql_title_style) && count($blog_image_with_icon_centered_ql_title_style)) { ?>
            .blog_holder.blog_image_with_icon_centered article.format-quote .post_text .post_title h3,
            .blog_holder.blog_image_with_icon_centered article.format-link .post_text .post_title h3{
			<?php echo esc_attr(implode(';', $blog_image_with_icon_centered_ql_title_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_image_with_icon_centered_ql_title_color']) && !empty($mkd_options['blog_image_with_icon_centered_ql_title_color'])){ ?>
            .blog_holder.blog_image_with_icon_centered article.format-quote .post_text .post_title h3 a,
            .blog_holder.blog_image_with_icon_centered article.format-link .post_text .post_title h3 a,
            .blog_holder.blog_image_with_icon_centered article.format-quote .post_text .post_title h3,
            .blog_holder.blog_image_with_icon_centered article.format-link .post_text .post_title h3
            {
            color: <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_ql_title_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_image_with_icon_centered_ql_title_hover_color']) && !empty($mkd_options['blog_image_with_icon_centered_ql_title_hover_color'])){ ?>
            .blog_holder.blog_image_with_icon_centered article.format-quote .post_text .post_text_inner:hover .post_title h3 a,
            .blog_holder.blog_image_with_icon_centered article.format-link .post_text .post_text_inner:hover .post_title h3 a,
            .blog_holder.blog_image_with_icon_centered article.format-quote .post_text .post_text_inner:hover .post_title h3,
            .blog_holder.blog_image_with_icon_centered article.format-link .post_text .post_text_inner:hover .post_title h3
            {
            color: <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_ql_title_hover_color']);  ?>;
            }
		<?php } ?>
		<?php
		/**************** BLOG: IMAGE WITH ICON (CENTRERED): Quote Author Style ****************/
		$blog_image_with_icon_centered_ql_author_style = array();

		if(isset($mkd_options['blog_image_with_icon_centered_ql_author_google_fonts']) && $mkd_options['blog_image_with_icon_centered_ql_author_google_fonts'] !== '-1') {
			$blog_image_with_icon_centered_ql_author_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_image_with_icon_centered_ql_author_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_image_with_icon_centered_ql_author_fontsize']) && $mkd_options['blog_image_with_icon_centered_ql_author_fontsize'] !== '') {
			$blog_image_with_icon_centered_ql_author_style[] = 'font-size: '.intval($mkd_options['blog_image_with_icon_centered_ql_author_fontsize']).'px';
		}

		if(isset($mkd_options['blog_image_with_icon_centered_ql_author_lineheight']) && $mkd_options['blog_image_with_icon_centered_ql_author_lineheight'] !== '') {
			$blog_image_with_icon_centered_ql_author_style[] = 'line-height: '.intval($mkd_options['blog_image_with_icon_centered_ql_author_lineheight']).'px';
		}

		if(isset($mkd_options['blog_image_with_icon_centered_ql_author_letterspacing']) && $mkd_options['blog_image_with_icon_centered_ql_author_letterspacing'] !== '') {
			$blog_image_with_icon_centered_ql_author_style[] = 'letter-spacing: '.intval($mkd_options['blog_image_with_icon_centered_ql_author_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_image_with_icon_centered_ql_author_fontweight']) && $mkd_options['blog_image_with_icon_centered_ql_author_fontweight'] !== '') {
			$blog_image_with_icon_centered_ql_author_style[] = 'font-weight: '.intval($mkd_options['blog_image_with_icon_centered_ql_author_fontweight']);
		}

		if(isset($mkd_options['blog_image_with_icon_centered_ql_author_fontstyle']) && $mkd_options['blog_image_with_icon_centered_ql_author_fontstyle'] !== '') {
			$blog_image_with_icon_centered_ql_author_style[] = 'font-style: '.$mkd_options['blog_image_with_icon_centered_ql_author_fontstyle'];
		}

		if(isset($mkd_options['blog_image_with_icon_centered_ql_author_texttransform']) && $mkd_options['blog_image_with_icon_centered_ql_author_texttransform'] !== '') {
			$blog_image_with_icon_centered_ql_author_style[] = 'text-transform: '.$mkd_options['blog_image_with_icon_centered_ql_author_texttransform'];
		}

		if(is_array($blog_image_with_icon_centered_ql_author_style) && count($blog_image_with_icon_centered_ql_author_style)) { ?>
            .blog_holder.blog_image_with_icon_centered article.format-quote .post_text .quote_author{
			<?php echo esc_attr(implode(';', $blog_image_with_icon_centered_ql_author_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_image_with_icon_centered_ql_author_color']) && !empty($mkd_options['blog_image_with_icon_centered_ql_author_color'])){ ?>
            .blog_holder.blog_image_with_icon_centered article.format-quote .post_text .post_text_inner .quote_author{
            color: <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_ql_author_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_image_with_icon_centered_ql_author_hover_color']) && !empty($mkd_options['blog_image_with_icon_centered_ql_author_hover_color'])){ ?>
            .blog_holder.blog_image_with_icon_centered article.format-quote .post_text .post_text_inner:hover .quote_author{
            color: <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_ql_author_hover_color']);  ?>;
            }
		<?php } ?>
		<?php
		/**************** BLOG: IMAGE WITH ICON (CENTRERED): Info Style ****************/
		$blog_image_with_icon_centered_info_style = array();

		if(isset($mkd_options['blog_image_with_icon_centered_info_google_fonts']) && $mkd_options['blog_image_with_icon_centered_info_google_fonts'] !== '-1') {
			$blog_image_with_icon_centered_info_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_image_with_icon_centered_info_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_image_with_icon_centered_info_fontsize']) && $mkd_options['blog_image_with_icon_centered_info_fontsize'] !== '') {
			$blog_image_with_icon_centered_info_style[] = 'font-size: '.intval($mkd_options['blog_image_with_icon_centered_info_fontsize']).'px';
		}

		if(isset($mkd_options['blog_image_with_icon_centered_info_lineheight']) && $mkd_options['blog_image_with_icon_centered_info_lineheight'] !== '') {
			$blog_image_with_icon_centered_info_style[] = 'line-height: '.intval($mkd_options['blog_image_with_icon_centered_info_lineheight']).'px';
		}

		if(isset($mkd_options['blog_image_with_icon_centered_info_letterspacing']) && $mkd_options['blog_image_with_icon_centered_info_letterspacing'] !== '') {
			$blog_image_with_icon_centered_info_style[] = 'letter-spacing: '.intval($mkd_options['blog_image_with_icon_centered_info_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_image_with_icon_centered_info_fontweight']) && $mkd_options['blog_image_with_icon_centered_info_fontweight'] !== '') {
			$blog_image_with_icon_centered_info_style[] = 'font-weight: '.intval($mkd_options['blog_image_with_icon_centered_info_fontweight']);
		}

		if(isset($mkd_options['blog_image_with_icon_centered_info_fontstyle']) && $mkd_options['blog_image_with_icon_centered_info_fontstyle'] !== '') {
			$blog_image_with_icon_centered_info_style[] = 'font-style: '.$mkd_options['blog_image_with_icon_centered_info_fontstyle'];
		}

		if(isset($mkd_options['blog_image_with_icon_centered_info_texttransform']) && $mkd_options['blog_image_with_icon_centered_info_texttransform'] !== '') {
			$blog_image_with_icon_centered_info_style[] = 'text-transform: '.$mkd_options['blog_image_with_icon_centered_info_texttransform'];
		}
		if(is_array($blog_image_with_icon_centered_info_style) && count($blog_image_with_icon_centered_info_style)) { ?>

            .blog_holder.blog_image_with_icon_centered article:not(.format-link):not(.format-quote) .post_text .post_text_inner .post_info{
			<?php echo esc_attr(implode(';', $blog_image_with_icon_centered_info_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_image_with_icon_centered_info_color']) && !empty($mkd_options['blog_image_with_icon_centered_info_color'])){ ?>
            .blog_holder.blog_image_with_icon_centered article:not(.format-link):not(.format-quote) .post_text .post_text_inner .post_info{
            color: <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_info_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_image_with_icon_centered_info_link_color']) && !empty($mkd_options['blog_image_with_icon_centered_info_link_color'])){ ?>
            .blog_holder.blog_image_with_icon_centered article:not(.format-link):not(.format-quote) .post_text .post_text_inner .post_info a
            {
            color: <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_info_link_color']);  ?>;
            }
		<?php } ?>



		<?php if(isset($mkd_options['blog_image_with_icon_centered_info_hover_color']) && !empty($mkd_options['blog_image_with_icon_centered_info_hover_color'])){ ?>
            .blog_holder.blog_image_with_icon_centered article:not(.format-link):not(.format-quote) .post_text .post_text_inner .post_info a:hover{
            color: <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_info_hover_color']);  ?>;
            }
		<?php } ?>


		<?php
		/****************  BLOG: IMAGE WITH ICON (CENTRERED): Quote/Link TExt Style *********************/
		$blog_image_with_icon_centered_ql_info_style = array();

		if(isset($mkd_options['blog_image_with_icon_centered_ql_info_google_fonts']) && $mkd_options['blog_image_with_icon_centered_ql_info_google_fonts'] !== '-1') {
			$blog_image_with_icon_centered_ql_info_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_image_with_icon_centered_ql_info_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_image_with_icon_centered_ql_info_fontsize']) && $mkd_options['blog_image_with_icon_centered_ql_info_fontsize'] !== '') {
			$blog_image_with_icon_centered_ql_info_style[] = 'font-size: '.intval($mkd_options['blog_image_with_icon_centered_ql_info_fontsize']).'px';
		}

		if(isset($mkd_options['blog_image_with_icon_centered_ql_info_lineheight']) && $mkd_options['blog_image_with_icon_centered_ql_info_lineheight'] !== '') {
			$blog_image_with_icon_centered_ql_info_style[] = 'line-height: '.intval($mkd_options['blog_image_with_icon_centered_ql_info_lineheight']).'px';
		}

		if(isset($mkd_options['blog_image_with_icon_centered_ql_info_letterspacing']) && $mkd_options['blog_image_with_icon_centered_ql_info_letterspacing'] !== '') {
			$blog_image_with_icon_centered_ql_info_style[] = 'letter-spacing: '.intval($mkd_options['blog_image_with_icon_centered_ql_info_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_image_with_icon_centered_ql_info_fontweight']) && $mkd_options['blog_image_with_icon_centered_ql_info_fontweight'] !== '') {
			$blog_image_with_icon_centered_ql_info_style[] = 'font-weight: '.intval($mkd_options['blog_image_with_icon_centered_ql_info_fontweight']);
		}

		if(isset($mkd_options['blog_image_with_icon_centered_ql_info_fontstyle']) && $mkd_options['blog_image_with_icon_centered_ql_info_fontstyle'] !== '') {
			$blog_image_with_icon_centered_ql_info_style[] = 'font-style: '.$mkd_options['blog_image_with_icon_centered_ql_info_fontstyle'];
		}

		if(isset($mkd_options['blog_image_with_icon_centered_ql_info_texttransform']) && $mkd_options['blog_image_with_icon_centered_ql_info_texttransform'] !== '') {
			$blog_image_with_icon_centered_ql_info_style[] = 'text-transform: '.$mkd_options['blog_image_with_icon_centered_ql_info_texttransform'];
		}
		if(is_array($blog_image_with_icon_centered_ql_info_style) && count($blog_image_with_icon_centered_ql_info_style)) { ?>
            .blog_holder.blog_image_with_icon_centered article.format-quote .post_text .post_text_inner .post_info,
            .blog_holder.blog_image_with_icon_centered article.format-link .post_text .post_text_inner .post_info{
			<?php echo esc_attr(implode(';', $blog_image_with_icon_centered_ql_info_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_image_with_icon_centered_ql_info_color']) && !empty($mkd_options['blog_image_with_icon_centered_ql_info_color'])){ ?>
            .blog_holder.blog_image_with_icon_centered article.format-quote .post_text .post_text_inner .post_info,
            .blog_holder.blog_image_with_icon_centered article.format-link .post_text .post_text_inner .post_info{
            color: <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_ql_info_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_image_with_icon_centered_ql_info_link_color']) && !empty($mkd_options['blog_image_with_icon_centered_ql_info_link_color'])){ ?>
            .blog_holder.blog_image_with_icon_centered article.format-quote .post_text .post_text_inner .post_info div a,
            .blog_holder.blog_image_with_icon_centered article.format-link .post_text .post_text_inner .post_info div a{
            color: <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_ql_info_link_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_image_with_icon_centered_ql_info_hover_color']) && !empty($mkd_options['blog_image_with_icon_centered_ql_info_hover_color'])){ ?>
            .blog_holder.blog_image_with_icon_centered article.format-quote .post_text .post_text_inner:hover .post_info div,
            .blog_holder.blog_image_with_icon_centered article.format-link .post_text .post_text_inner:hover .post_info div,
            .blog_holder.blog_image_with_icon_centered article.format-quote .post_text .post_text_inner:hover .post_info div a,
            .blog_holder.blog_image_with_icon_centered article.format-link .post_text .post_text_inner:hover .post_info div a{
            color: <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_ql_info_hover_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_image_with_icon_centered_ql_mark_color']) && !empty($mkd_options['blog_image_with_icon_centered_ql_mark_color'])){ ?>
            .blog_holder.blog_image_with_icon_centered article.format-quote .post_text .post_text_inner .post_info_quote_mark .quote_mark,
            .blog_holder.blog_image_with_icon_centered article.format-link .post_text .post_text_inner .post_info_link_mark .link_mark{
            color: <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_ql_mark_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_image_with_icon_centered_ql_mark_hover_color']) && !empty($mkd_options['blog_image_with_icon_centered_ql_mark_hover_color'])){ ?>
            .blog_holder.blog_image_with_icon_centered article.format-quote .post_text .post_text_inner:hover .post_info .post_info_quote_mark .quote_mark,
            .blog_holder.blog_image_with_icon_centered article.format-link .post_text .post_text_inner:hover .post_info .post_info_link_mark .link_mark{
            color: <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_ql_mark_hover_color']);  ?>;
            }
		<?php } ?>

		<?php
		/**************** BLOG POST INFO VERTICAL (CENTRERED): Category Style ****************/
		$blog_image_with_icon_centered_ql_category_style = array();

		if(isset($mkd_options['blog_image_with_icon_centered_ql_category_google_fonts']) && $mkd_options['blog_image_with_icon_centered_ql_category_google_fonts'] !== '-1') {
			$blog_image_with_icon_centered_ql_category_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_image_with_icon_centered_ql_category_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_image_with_icon_centered_ql_category_fontsize']) && $mkd_options['blog_image_with_icon_centered_ql_category_fontsize'] !== '') {
			$blog_image_with_icon_centered_ql_category_style[] = 'font-size: '.intval($mkd_options['blog_image_with_icon_centered_ql_category_fontsize']).'px';
		}

		if(isset($mkd_options['blog_image_with_icon_centered_ql_category_lineheight']) && $mkd_options['blog_image_with_icon_centered_ql_category_lineheight'] !== '') {
			$blog_image_with_icon_centered_ql_category_style[] = 'line-height: '.intval($mkd_options['blog_image_with_icon_centered_ql_category_lineheight']).'px';
		}

		if(isset($mkd_options['blog_image_with_icon_centered_ql_category_letterspacing']) && $mkd_options['blog_image_with_icon_centered_ql_category_letterspacing'] !== '') {
			$blog_image_with_icon_centered_ql_category_style[] = 'letter-spacing: '.intval($mkd_options['blog_image_with_icon_centered_ql_category_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_image_with_icon_centered_ql_category_fontweight']) && $mkd_options['blog_image_with_icon_centered_ql_category_fontweight'] !== '') {
			$blog_image_with_icon_centered_ql_category_style[] = 'font-weight: '.intval($mkd_options['blog_image_with_icon_centered_ql_category_fontweight']);
		}

		if(isset($mkd_options['blog_image_with_icon_centered_ql_category_fontstyle']) && $mkd_options['blog_image_with_icon_centered_ql_category_fontstyle'] !== '') {
			$blog_image_with_icon_centered_ql_category_style[] = 'font-style: '.$mkd_options['blog_image_with_icon_centered_ql_category_fontstyle'];
		}

		if(isset($mkd_options['blog_image_with_icon_centered_ql_category_texttransform']) && $mkd_options['blog_image_with_icon_centered_ql_category_texttransform'] !== '') {
			$blog_image_with_icon_centered_ql_category_style[] = 'text-transform: '.$mkd_options['blog_image_with_icon_centered_ql_category_texttransform'];
		}

		if(is_array($blog_image_with_icon_centered_ql_category_style) && count($blog_image_with_icon_centered_ql_category_style)) { ?>
            .blog_holder.blog_image_with_icon_centered article.format-quote .post_text .post_text_inner .post_category a,
            .blog_holder.blog_image_with_icon_centered article.format-link .post_text .post_text_inner .post_category a
            {
			<?php echo esc_attr(implode(';', $blog_image_with_icon_centered_ql_category_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_image_with_icon_centered_ql_category_color']) && !empty($mkd_options['blog_image_with_icon_centered_ql_category_color'])){ ?>
            .blog_holder.blog_image_with_icon_centered article.format-quote .post_text .post_text_inner .post_category a,
            .blog_holder.blog_image_with_icon_centered article.format-link .post_text .post_text_inner .post_category a{
            color: <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_ql_category_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_image_with_icon_centered_ql_category_hover_color']) && !empty($mkd_options['blog_image_with_icon_centered_ql_category_hover_color'])){ ?>
            .blog_holder.blog_image_with_icon_centered article.format-quote .post_text .post_text_inner:hover .post_category a,
            .blog_holder.blog_image_with_icon_centered article.format-link .post_text .post_text_inner:hover .post_category a{
            color: <?php echo esc_attr($mkd_options['blog_image_with_icon_centered_ql_category_hover_color']);  ?>;
            }
		<?php } ?>
		<?php
		/******** BLOG: TITLE & DATE FIRST Share options ********/
		if(isset($mkd_options['blog_title_date_first_show_share']) && $mkd_options['blog_title_date_first_show_share'] == 'yes') {

			if(isset($mkd_options['blog_title_date_first_share_icon_color']) && $mkd_options['blog_title_date_first_share_icon_color'] !== '') {?>
                .blog_holder.blog_title_date_first .post_text .post_text_inner span.share a.share_link,
                .blog_holder.blog_title_date_first .post_text .post_text_inner span.share a.share_link span,
                .blog_holder.blog_title_date_first article.format-link .post_text.link_image .post_text_inner:hover .post_info .social_share_dropdown ul li span.social_network_icon{
                color:  <?php echo esc_attr($mkd_options['blog_title_date_first_share_icon_color']); ?> ;
                }
			<?php } ?>
			<?php if(isset($mkd_options['blog_title_date_first_share_background_color']) && $mkd_options['blog_title_date_first_share_background_color'] !== '') {?>
                .blog_holder.blog_title_date_first .social_share_dropdown ul li a{
                background-color:  <?php echo esc_attr($mkd_options['blog_title_date_first_share_background_color']); ?> ;
                }
			<?php } ?>
			<?php if(isset($mkd_options['blog_title_date_first_share_icon_hover_color']) && $mkd_options['blog_title_date_first_share_icon_hover_color'] !== '') {?>
                .blog_holder.blog_title_date_first .social_share_dropdown ul li:hover,
                .blog_holder.blog_title_date_first .social_share_dropdown ul li:hover a span.social_network_icon{
                color:  <?php echo esc_attr($mkd_options['blog_title_date_first_share_icon_hover_color']); ?> !important;
                }
			<?php } ?>
		<?php } ?>

		<?php
		/******** BLOG: TITLE & DATE FIRST Separator ********/
		$blog_title_date_first_separator_style = array();
		if(isset($mkd_options['blog_title_date_first_separator_color']) && $mkd_options['blog_title_date_first_separator_color'] !== '') {
			$blog_title_date_first_separator_style[] = 'border-color: '.$mkd_options['blog_title_date_first_separator_color'];
		}
		if(isset($mkd_options['blog_title_date_first_separator_width']) && $mkd_options['blog_title_date_first_separator_width'] !== '') {
			$blog_title_date_first_separator_style[] = 'width: '.intval($mkd_options['blog_title_date_first_separator_width']).'px';
		}
		if(isset($mkd_options['blog_title_date_first_separator_thickness']) && $mkd_options['blog_title_date_first_separator_thickness'] !== '') {
			$blog_title_date_first_separator_style[] = 'border-width: '.intval($mkd_options['blog_title_date_first_separator_thickness']).'px';
		}

		if(is_array($blog_title_date_first_separator_style) && count($blog_title_date_first_separator_style)) { ?>
            .blog_holder.blog_title_date_first .post_text .separator.small{
			<?php echo esc_attr(implode(';', $blog_title_date_first_separator_style)); ?>
            }
		<?php } ?>

		<?php
		/******** BLOG: TITLE & DATE FIRST: Text Box ********/
		if(isset($mkd_options['blog_title_date_first_enable_text_box']) && $mkd_options['blog_title_date_first_enable_text_box'] == 'yes') {
			$blog_box_style = array();
			?>
            .blog_holder.blog_title_date_first article .audio_image,
            .blog_holder.blog_title_date_first article:not(.format-audio) .post_image{
            margin-bottom: 0;
            }
			<?php
			if(isset($mkd_options['blog_title_date_first_box_background_color']) && $mkd_options['blog_title_date_first_box_background_color'] !== '') {
				$blog_box_style[] = 'background-color: '.$mkd_options['blog_title_date_first_box_background_color'];
			}

			if(isset($mkd_options['blog_title_date_first_box_border_color']) && $mkd_options['blog_title_date_first_box_border_color'] !== '') {
				$blog_box_style[] = 'border: 1px solid';
				$blog_box_style[] = 'border-color: '.$mkd_options['blog_title_date_first_box_border_color'];
			}

			if(isset($mkd_options['blog_title_date_first_box_padding']) && $mkd_options['blog_title_date_first_box_padding'] !== '') {
				$blog_box_style[] = 'padding: '.$mkd_options['blog_title_date_first_box_padding'];
			}

			if(is_array($blog_box_style) && count($blog_box_style)) { ?>
                .blog_holder.blog_title_date_first article:not(.format-link):not(.format-quote) .post_text .post_text_inner{
				<?php echo esc_attr(implode(';', $blog_box_style)); ?>
                }
			<?php }} ?>

		<?php
		/******** BLOG: TITLE & DATE FIRST Quote/Link Text Box ********/
		if(isset($mkd_options['blog_title_date_first_ql_background_color']) &&($mkd_options['blog_title_date_first_ql_background_color'])!==""){ ?>
            .blog_holder.blog_title_date_first article.format-link .post_text .post_text_inner,
            .blog_holder.blog_title_date_first article.format-quote .post_text .post_text_inner{
            background-color: <?php echo esc_attr($mkd_options['blog_title_date_first_ql_background_color']);  ?>;
            }
			<?php  $blog_title_date_first_ql_background_color = mikado_one_mikado_hex2rgb($mkd_options['blog_title_date_first_ql_background_color']); ?>

            .blog_holder.blog_title_date_first article.format-link .post_text.link_image .post_text_inner,
            .blog_holder.blog_title_date_first article.format-quote .post_text.quote_image .post_text_inner{
			<?php if (!empty($mkd_options['blog_title_date_first_ql_background_color'])) { ?>  background-color: rgba(<?php echo esc_attr($blog_title_date_first_ql_background_color[0]); ?>,<?php echo esc_attr($blog_title_date_first_ql_background_color[1]); ?>,<?php echo esc_attr($blog_title_date_first_ql_background_color[2]); ?>,0.85); <?php } ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_title_date_first_ql_hover_background_color']) && !empty($mkd_options['blog_title_date_first_ql_hover_background_color'])){ ?>
            .blog_holder.blog_title_date_first article.format-link .post_text .post_text_inner:hover,
            .blog_holder.blog_title_date_first article.format-quote .post_text .post_text_inner:hover{
            background-color: <?php echo esc_attr($mkd_options['blog_title_date_first_ql_hover_background_color']);  ?>;
            }
			<?php  $blog_title_date_first_ql_hover_background_color = mikado_one_mikado_hex2rgb($mkd_options['blog_title_date_first_ql_hover_background_color']); ?>

            .blog_holder.blog_title_date_first article.format-link .post_text.link_image .post_text_inner:hover,
            .blog_holder.blog_title_date_first article.format-quote .post_text.quote_image .post_text_inner:hover{
			<?php if (!empty($mkd_options['blog_title_date_first_ql_hover_background_color'])) { ?>  background-color: rgba(<?php echo esc_attr($blog_title_date_first_ql_hover_background_color[0]); ?>,<?php echo esc_attr($blog_title_date_first_ql_hover_background_color[1]); ?>,<?php echo esc_attr($blog_title_date_first_ql_hover_background_color[2]); ?>,0.6); <?php } ?>
            }

		<?php } ?>

		<?php
		/**************** BLOG TITLE AND DATE: Spacing  ****************/
		if(isset($mkd_options['blog_title_date_first_title_margin_bottom']) && $mkd_options['blog_title_date_first_title_margin_bottom'] !== '') { ?>
            .blog_holder.blog_title_date_first article h2{
            padding-bottom : <?php echo esc_attr($mkd_options['blog_title_date_first_title_margin_bottom']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_title_date_first_date_margin_bottom']) && $mkd_options['blog_title_date_first_date_margin_bottom'] !== '') { ?>
            .blog_holder.blog_title_date_first article .post_info_date{
            margin-bottom : <?php echo esc_attr($mkd_options['blog_title_date_first_date_margin_bottom']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_title_date_first_image_margin_bottom']) && $mkd_options['blog_title_date_first_image_margin_bottom'] !== '') { ?>
            .blog_holder.blog_title_date_first article:not(.format-audio) .post_image,
            .blog_holder.blog_title_date_first article .audio_image{
            margin-bottom : <?php echo esc_attr($mkd_options['blog_title_date_first_image_margin_bottom']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_title_date_first_post_info_margin_top']) && $mkd_options['blog_title_date_first_post_info_margin_top'] !== '') { ?>
            .blog_holder.blog_title_date_first article:not(.format-link):not(.format-quote) .post_info{
            margin-top : <?php echo esc_attr($mkd_options['blog_title_date_first_post_info_margin_top']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_title_date_first_separator_margin_top']) && $mkd_options['blog_title_date_first_separator_margin_top'] !== '') { ?>
            .blog_holder.blog_title_date_first .post_text .separator.small{
            margin-top : <?php echo esc_attr($mkd_options['blog_title_date_first_separator_margin_top']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_title_date_first_article_margin_bottom']) && $mkd_options['blog_title_date_first_article_margin_bottom'] !== '') { ?>
            .blog_holder.blog_title_date_first:not(.blog_single) article{
            margin-bottom : <?php echo esc_attr($mkd_options['blog_title_date_first_article_margin_bottom']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_title_date_first_ql_quote_author_margin_top']) && $mkd_options['blog_title_date_first_ql_quote_author_margin_top'] !== '') { ?>
            .blog_holder.blog_title_date_first article.format-quote .post_text_inner .quote_author{
            margin-top : <?php echo esc_attr($mkd_options['blog_title_date_first_ql_quote_author_margin_top']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_title_date_first_ql_post_info_margin_top']) && $mkd_options['blog_title_date_first_ql_post_info_margin_top'] !== '') { ?>
            .blog_holder.blog_title_date_first article.format-link .post_info,
            .blog_holder.blog_title_date_first article.format-quote .post_info{
            margin-top : <?php echo esc_attr($mkd_options['blog_title_date_first_ql_post_info_margin_top']).'px';?>
            }
		<?php } ?>

		<?php
		/**************** BLOG TITLE & DATE FIRST: Title Style ****************/
		$blog_title_date_first_title_style = array();

		if(isset($mkd_options['blog_title_date_first_title_google_fonts']) && $mkd_options['blog_title_date_first_title_google_fonts'] !== '-1') {
			$blog_title_date_first_title_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_title_date_first_title_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_title_date_first_title_fontsize']) && $mkd_options['blog_title_date_first_title_fontsize'] !== '') {
			$blog_title_date_first_title_style[] = 'font-size: '.intval($mkd_options['blog_title_date_first_title_fontsize']).'px';
		}

		if(isset($mkd_options['blog_title_date_first_title_lineheight']) && $mkd_options['blog_title_date_first_title_lineheight'] !== '') {
			$blog_title_date_first_title_style[] = 'line-height: '.intval($mkd_options['blog_title_date_first_title_lineheight']).'px';
		}

		if(isset($mkd_options['blog_title_date_first_title_letterspacing']) && $mkd_options['blog_title_date_first_title_letterspacing'] !== '') {
			$blog_title_date_first_title_style[] = 'letter-spacing: '.intval($mkd_options['blog_title_date_first_title_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_title_date_first_title_fontweight']) && $mkd_options['blog_title_date_first_title_fontweight'] !== '') {
			$blog_title_date_first_title_style[] = 'font-weight: '.intval($mkd_options['blog_title_date_first_title_fontweight']);
		}

		if(isset($mkd_options['blog_title_date_first_title_fontstyle']) && $mkd_options['blog_title_date_first_title_fontstyle'] !== '') {
			$blog_title_date_first_title_style[] = 'font-style: '.$mkd_options['blog_title_date_first_title_fontstyle'];
		}

		if(isset($mkd_options['blog_title_date_first_title_texttransform']) && $mkd_options['blog_title_date_first_title_texttransform'] !== '') {
			$blog_title_date_first_title_style[] = 'text-transform: '.$mkd_options['blog_title_date_first_title_texttransform'];
		}

		if(is_array($blog_title_date_first_title_style) && count($blog_title_date_first_title_style)) { ?>
            .blog_holder.blog_title_date_first article:not(.format-quote):not(.format-link) h2{
			<?php echo esc_attr(implode(';', $blog_title_date_first_title_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_title_date_first_title_color']) && !empty($mkd_options['blog_title_date_first_title_color'])){ ?>
            .blog_holder.blog_title_date_first article:not(.format-quote):not(.format-link) h2 a,
            .blog_holder.blog_title_date_first.blog_single article:not(.format-quote):not(.format-link) h2{
            color: <?php echo esc_attr($mkd_options['blog_title_date_first_title_color']);  ?>;

            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_title_date_first_title_hover_color']) && !empty($mkd_options['blog_title_date_first_title_hover_color'])){ ?>
            .blog_holder.blog_title_date_first article:not(.format-quote):not(.format-link) h2 a:hover,
            .blog_holder.blog_title_date_first.blog_single article:not(.format-quote):not(.format-link) h2:hover{
            color: <?php echo esc_attr($mkd_options['blog_title_date_first_title_hover_color']);  ?>;
            }
		<?php } ?>
		<?php
		/**************** BLOG TITLE & DATE FIRST: Date Style ****************/
		$blog_title_date_first_date_style = array();

		if(isset($mkd_options['blog_title_date_first_date_google_fonts']) && $mkd_options['blog_title_date_first_date_google_fonts'] !== '-1') {
			$blog_title_date_first_date_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_title_date_first_date_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_title_date_first_date_fontsize']) && $mkd_options['blog_title_date_first_date_fontsize'] !== '') {
			$blog_title_date_first_date_style[] = 'font-size: '.intval($mkd_options['blog_title_date_first_date_fontsize']).'px';
		}

		if(isset($mkd_options['blog_title_date_first_date_lineheight']) && $mkd_options['blog_title_date_first_date_lineheight'] !== '') {
			$blog_title_date_first_date_style[] = 'line-height: '.intval($mkd_options['blog_title_date_first_date_lineheight']).'px';
		}

		if(isset($mkd_options['blog_title_date_first_date_letterspacing']) && $mkd_options['blog_title_date_first_date_letterspacing'] !== '') {
			$blog_title_date_first_date_style[] = 'letter-spacing: '.intval($mkd_options['blog_title_date_first_date_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_title_date_first_date_fontweight']) && $mkd_options['blog_title_date_first_date_fontweight'] !== '') {
			$blog_title_date_first_date_style[] = 'font-weight: '.intval($mkd_options['blog_title_date_first_date_fontweight']);
		}

		if(isset($mkd_options['blog_title_date_first_date_fontstyle']) && $mkd_options['blog_title_date_first_date_fontstyle'] !== '') {
			$blog_title_date_first_date_style[] = 'font-style: '.$mkd_options['blog_title_date_first_date_fontstyle'];
		}

		if(isset($mkd_options['blog_title_date_first_date_texttransform']) && $mkd_options['blog_title_date_first_date_texttransform'] !== '') {
			$blog_title_date_first_date_style[] = 'text-transform: '.$mkd_options['blog_title_date_first_date_texttransform'];
		}

		if(is_array($blog_title_date_first_date_style) && count($blog_title_date_first_date_style)) { ?>
            .blog_holder.blog_title_date_first article:not(.format-quote):not(.format-link) .post_info_date{
			<?php echo esc_attr(implode(';', $blog_title_date_first_date_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_title_date_first_date_color']) && !empty($mkd_options['blog_title_date_first_date_color'])){ ?>
            .blog_holder.blog_title_date_first article:not(.format-quote):not(.format-link) .post_info_date{
            color: <?php echo esc_attr($mkd_options['blog_title_date_first_date_color']);  ?>;

            }
		<?php } ?>

		<?php
		/**************** BLOG TITLE & DATE FIRST: Qoute/Link Title Style ****************/
		$blog_title_date_first_ql_title_style = array();

		if(isset($mkd_options['blog_title_date_first_ql_title_google_fonts']) && $mkd_options['blog_title_date_first_ql_title_google_fonts'] !== '-1') {
			$blog_title_date_first_ql_title_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_title_date_first_ql_title_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_title_date_first_ql_title_fontsize']) && $mkd_options['blog_title_date_first_ql_title_fontsize'] !== '') {
			$blog_title_date_first_ql_title_style[] = 'font-size: '.intval($mkd_options['blog_title_date_first_ql_title_fontsize']).'px';
		}

		if(isset($mkd_options['blog_title_date_first_ql_title_lineheight']) && $mkd_options['blog_title_date_first_ql_title_lineheight'] !== '') {
			$blog_title_date_first_ql_title_style[] = 'line-height: '.intval($mkd_options['blog_title_date_first_ql_title_lineheight']).'px';
		}

		if(isset($mkd_options['blog_title_date_first_ql_title_letterspacing']) && $mkd_options['blog_title_date_first_ql_title_letterspacing'] !== '') {
			$blog_title_date_first_ql_title_style[] = 'letter-spacing: '.intval($mkd_options['blog_title_date_first_ql_title_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_title_date_first_ql_title_fontweight']) && $mkd_options['blog_title_date_first_ql_title_fontweight'] !== '') {
			$blog_title_date_first_ql_title_style[] = 'font-weight: '.intval($mkd_options['blog_title_date_first_ql_title_fontweight']);
		}

		if(isset($mkd_options['blog_title_date_first_ql_title_fontstyle']) && $mkd_options['blog_title_date_first_ql_title_fontstyle'] !== '') {
			$blog_title_date_first_ql_title_style[] = 'font-style: '.$mkd_options['blog_title_date_first_ql_title_fontstyle'];
		}

		if(isset($mkd_options['blog_title_date_first_ql_title_texttransform']) && $mkd_options['blog_title_date_first_ql_title_texttransform'] !== '') {
			$blog_title_date_first_ql_title_style[] = 'text-transform: '.$mkd_options['blog_title_date_first_ql_title_texttransform'];
		}

		if(is_array($blog_title_date_first_ql_title_style) && count($blog_title_date_first_ql_title_style)) { ?>
            .blog_holder.blog_title_date_first article.format-quote .post_text .post_title h3,
            .blog_holder.blog_title_date_first article.format-link .post_text .post_title h3
            {
			<?php echo esc_attr(implode(';', $blog_title_date_first_ql_title_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_title_date_first_ql_title_color']) && !empty($mkd_options['blog_title_date_first_ql_title_color'])){ ?>
            .blog_holder.blog_title_date_first article.format-quote .post_text .post_title h3 a,
            .blog_holder.blog_title_date_first article.format-link .post_text .post_title h3 a,
            .blog_holder.blog_title_date_first article.format-quote .post_text .post_title h3,
            .blog_holder.blog_title_date_first article.format-link .post_text .post_title h3
            {
            color: <?php echo esc_attr($mkd_options['blog_title_date_first_ql_title_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_title_date_first_ql_title_hover_color']) && !empty($mkd_options['blog_title_date_first_ql_title_hover_color'])){ ?>
            .blog_holder.blog_title_date_first article.format-quote .post_text .post_text_inner:hover .post_title h3 a,
            .blog_holder.blog_title_date_first article.format-link .post_text .post_text_inner:hover .post_title h3 a,
            .blog_holder.blog_title_date_first article.format-quote .post_text .post_text_inner:hover .post_title h3,
            .blog_holder.blog_title_date_first article.format-link .post_text .post_text_inner:hover .post_title h3{
            color: <?php echo esc_attr($mkd_options['blog_title_date_first_ql_title_hover_color']);  ?>;
            }
		<?php } ?>
		<?php
		/**************** BLOG TITLE & DATE FIRST: Qoute  Author Style ****************/
		$blog_title_date_first_ql_author_style = array();

		if(isset($mkd_options['blog_title_date_first_ql_author_google_fonts']) && $mkd_options['blog_title_date_first_ql_author_google_fonts'] !== '-1') {
			$blog_title_date_first_ql_author_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_title_date_first_ql_author_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_title_date_first_ql_author_fontsize']) && $mkd_options['blog_title_date_first_ql_author_fontsize'] !== '') {
			$blog_title_date_first_ql_author_style[] = 'font-size: '.intval($mkd_options['blog_title_date_first_ql_author_fontsize']).'px';
		}

		if(isset($mkd_options['blog_title_date_first_ql_author_lineheight']) && $mkd_options['blog_title_date_first_ql_author_lineheight'] !== '') {
			$blog_title_date_first_ql_author_style[] = 'line-height: '.intval($mkd_options['blog_title_date_first_ql_author_lineheight']).'px';
		}

		if(isset($mkd_options['blog_title_date_first_ql_author_letterspacing']) && $mkd_options['blog_title_date_first_ql_author_letterspacing'] !== '') {
			$blog_title_date_first_ql_author_style[] = 'letter-spacing: '.intval($mkd_options['blog_title_date_first_ql_author_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_title_date_first_ql_author_fontweight']) && $mkd_options['blog_title_date_first_ql_author_fontweight'] !== '') {
			$blog_title_date_first_ql_author_style[] = 'font-weight: '.intval($mkd_options['blog_title_date_first_ql_author_fontweight']);
		}

		if(isset($mkd_options['blog_title_date_first_ql_author_fontstyle']) && $mkd_options['blog_title_date_first_ql_author_fontstyle'] !== '') {
			$blog_title_date_first_ql_author_style[] = 'font-style: '.$mkd_options['blog_title_date_first_ql_author_fontstyle'];
		}

		if(isset($mkd_options['blog_title_date_first_ql_author_texttransform']) && $mkd_options['blog_title_date_first_ql_author_texttransform'] !== '') {
			$blog_title_date_first_ql_author_style[] = 'text-transform: '.$mkd_options['blog_title_date_first_ql_author_texttransform'];
		}

		if(is_array($blog_title_date_first_ql_author_style) && count($blog_title_date_first_ql_author_style)) { ?>
            .blog_holder.blog_title_date_first article.format-quote .post_text .quote_author{
			<?php echo esc_attr(implode(';', $blog_title_date_first_ql_author_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_title_date_first_ql_author_color']) && !empty($mkd_options['blog_title_date_first_ql_author_color'])){ ?>

            .blog_holder.blog_title_date_first article.format-quote .post_text .post_text_inner .quote_author{
            color: <?php echo esc_attr($mkd_options['blog_title_date_first_ql_author_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_title_date_first_ql_author_hover_color']) && !empty($mkd_options['blog_title_date_first_ql_author_hover_color'])){ ?>
            .blog_holder.blog_title_date_first article.format-quote .post_text .post_text_inner:hover .quote_author{
            color: <?php echo esc_attr($mkd_options['blog_title_date_first_ql_author_hover_color']);  ?>;
            }
		<?php } ?>
		<?php
		/**************** BLOG TITLE & DATE FIRST: Info Style ****************/
		$blog_title_date_first_info_style = array();

		if(isset($mkd_options['blog_title_date_first_info_google_fonts']) && $mkd_options['blog_title_date_first_info_google_fonts'] !== '-1') {
			$blog_title_date_first_info_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_title_date_first_info_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_title_date_first_info_fontsize']) && $mkd_options['blog_title_date_first_info_fontsize'] !== '') {
			$blog_title_date_first_info_style[] = 'font-size: '.intval($mkd_options['blog_title_date_first_info_fontsize']).'px';
		}

		if(isset($mkd_options['blog_title_date_first_info_lineheight']) && $mkd_options['blog_title_date_first_info_lineheight'] !== '') {
			$blog_title_date_first_info_style[] = 'line-height: '.intval($mkd_options['blog_title_date_first_info_lineheight']).'px';
		}

		if(isset($mkd_options['blog_title_date_first_info_letterspacing']) && $mkd_options['blog_title_date_first_info_letterspacing'] !== '') {
			$blog_title_date_first_info_style[] = 'letter-spacing: '.intval($mkd_options['blog_title_date_first_info_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_title_date_first_info_fontweight']) && $mkd_options['blog_title_date_first_info_fontweight'] !== '') {
			$blog_title_date_first_info_style[] = 'font-weight: '.intval($mkd_options['blog_title_date_first_info_fontweight']);
		}

		if(isset($mkd_options['blog_title_date_first_info_fontstyle']) && $mkd_options['blog_title_date_first_info_fontstyle'] !== '') {
			$blog_title_date_first_info_style[] = 'font-style: '.$mkd_options['blog_title_date_first_info_fontstyle'];
		}

		if(isset($mkd_options['blog_title_date_first_info_texttransform']) && $mkd_options['blog_title_date_first_info_texttransform'] !== '') {
			$blog_title_date_first_info_style[] = 'text-transform: '.$mkd_options['blog_title_date_first_info_texttransform'];
		}
		if(is_array($blog_title_date_first_info_style) && count($blog_title_date_first_info_style)) { ?>

            .blog_holder.blog_title_date_first article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info div{
			<?php echo esc_attr(implode(';', $blog_title_date_first_info_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_title_date_first_info_color']) && !empty($mkd_options['blog_title_date_first_info_color'])){ ?>
            .blog_holder.blog_title_date_first article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info {
            color: <?php echo esc_attr($mkd_options['blog_title_date_first_info_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_title_date_first_info_link_color']) && !empty($mkd_options['blog_title_date_first_info_link_color'])){ ?>
            .blog_holder.blog_title_date_first article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info div a
            {
            color: <?php echo esc_attr($mkd_options['blog_title_date_first_info_link_color']);  ?>;
            }
		<?php } ?>


		<?php if(isset($mkd_options['blog_title_date_first_info_hover_color']) && !empty($mkd_options['blog_title_date_first_info_hover_color'])){ ?>
            .blog_holder.blog_title_date_first article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info div a:hover{
            color: <?php echo esc_attr($mkd_options['blog_title_date_first_info_hover_color']);  ?>;
            }

		<?php } ?>


		<?php
		/****************  BLOG: TITLE & DATE FIRST: Quote/Link Post Info Style *********************/
		$blog_title_date_first_ql_info_style = array();

		if(isset($mkd_options['blog_title_date_first_ql_info_google_fonts']) && $mkd_options['blog_title_date_first_ql_info_google_fonts'] !== '-1') {
			$blog_title_date_first_ql_info_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_title_date_first_ql_info_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_title_date_first_ql_info_fontsize']) && $mkd_options['blog_title_date_first_ql_info_fontsize'] !== '') {
			$blog_title_date_first_ql_info_style[] = 'font-size: '.intval($mkd_options['blog_title_date_first_ql_info_fontsize']).'px';
		}

		if(isset($mkd_options['blog_title_date_first_ql_info_lineheight']) && $mkd_options['blog_title_date_first_ql_info_lineheight'] !== '') {
			$blog_title_date_first_ql_info_style[] = 'line-height: '.intval($mkd_options['blog_title_date_first_ql_info_lineheight']).'px';
		}

		if(isset($mkd_options['blog_title_date_first_ql_info_letterspacing']) && $mkd_options['blog_title_date_first_ql_info_letterspacing'] !== '') {
			$blog_title_date_first_ql_info_style[] = 'letter-spacing: '.intval($mkd_options['blog_title_date_first_ql_info_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_title_date_first_ql_info_fontweight']) && $mkd_options['blog_title_date_first_ql_info_fontweight'] !== '') {
			$blog_title_date_first_ql_info_style[] = 'font-weight: '.intval($mkd_options['blog_title_date_first_ql_info_fontweight']);
		}

		if(isset($mkd_options['blog_title_date_first_ql_info_fontstyle']) && $mkd_options['blog_title_date_first_ql_info_fontstyle'] !== '') {
			$blog_title_date_first_ql_info_style[] = 'font-style: '.$mkd_options['blog_title_date_first_ql_info_fontstyle'];
		}

		if(isset($mkd_options['blog_title_date_first_ql_info_texttransform']) && $mkd_options['blog_title_date_first_ql_info_texttransform'] !== '') {
			$blog_title_date_first_ql_info_style[] = 'text-transform: '.$mkd_options['blog_title_date_first_ql_info_texttransform'];
		}
		if(is_array($blog_title_date_first_ql_info_style) && count($blog_title_date_first_ql_info_style)) { ?>
            .blog_holder.blog_title_date_first article.format-quote .post_text .post_text_inner .post_info div,
            .blog_holder.blog_title_date_first article.format-link .post_text .post_text_inner .post_info div{
			<?php echo esc_attr(implode(';', $blog_title_date_first_ql_info_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_title_date_first_ql_info_color']) && !empty($mkd_options['blog_title_date_first_ql_info_color'])){ ?>
            .blog_holder.blog_title_date_first article.format-quote .post_text .post_text_inner .post_info,
            .blog_holder.blog_title_date_first article.format-link .post_text .post_text_inner .post_info{
            color: <?php echo esc_attr($mkd_options['blog_title_date_first_ql_info_color']);  ?>;
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_title_date_first_ql_info_link_color']) && !empty($mkd_options['blog_title_date_first_ql_info_link_color'])){ ?>
            .blog_holder.blog_title_date_first article.format-quote .post_text .post_text_inner .post_info a,
            .blog_holder.blog_title_date_first article.format-link .post_text .post_text_inner .post_info a{
            color: <?php echo esc_attr($mkd_options['blog_title_date_first_ql_info_link_color']);  ?>;
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_title_date_first_ql_info_hover_color']) && !empty($mkd_options['blog_title_date_first_ql_info_hover_color'])){ ?>
            .blog_holder.blog_title_date_first article.format-quote .post_text .post_text_inner:hover .post_info,
            .blog_holder.blog_title_date_first article.format-link .post_text .post_text_inner:hover .post_info,
            .blog_holder.blog_title_date_first article.format-quote .post_text .post_text_inner:hover .post_info a,
            .blog_holder.blog_title_date_first article.format-link .post_text .post_text_inner:hover .post_info a{
            color: <?php echo esc_attr($mkd_options['blog_title_date_first_ql_info_hover_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_title_date_first_ql_mark_color']) && !empty($mkd_options['blog_title_date_first_ql_mark_color'])){ ?>
            .blog_holder.blog_title_date_first article.format-quote .post_text .post_text_inner .post_info_quote_mark .quote_mark,
            .blog_holder.blog_title_date_first article.format-link .post_text .post_text_inner .post_info_link_mark .link_mark{
            color: <?php echo esc_attr($mkd_options['blog_title_date_first_ql_mark_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_title_date_first_ql_mark_hover_color']) && !empty($mkd_options['blog_title_date_first_ql_mark_hover_color'])){ ?>
            .blog_holder.blog_title_date_first article.format-quote .post_text .post_text_inner:hover .post_info_quote_mark .quote_mark,
            .blog_holder.blog_title_date_first article.format-link .post_text .post_text_inner:hover .post_info_link_mark .link_mark{
            color: <?php echo esc_attr($mkd_options['blog_title_date_first_ql_mark_hover_color']);  ?>;
            }
		<?php } ?>


		<?php
		/******** BLOG: TITLE & AUTHOR (CENTERED) Share options ********/
		if(isset($mkd_options['blog_title_author_centered_show_share']) && $mkd_options['blog_title_author_centered_show_share'] == 'yes') {

			if(isset($mkd_options['blog_title_author_centered_share_icon_color']) && $mkd_options['blog_title_author_centered_share_icon_color'] !== '') {?>
                .blog_holder.blog_title_author_centered .post_text .post_text_inner span.share a.share_link,
                .blog_holder.blog_title_author_centered .post_text .post_text_inner span.share a.share_link span,
                .blog_holder.blog_title_author_centered article.format-link .post_text.link_image .post_text_inner:hover .post_info .social_share_dropdown ul li span.social_network_icon{
                color:  <?php echo esc_attr($mkd_options['blog_title_author_centered_share_icon_color']); ?> !important;
                }
			<?php } ?>
			<?php if(isset($mkd_options['blog_title_author_centered_share_background_color']) && $mkd_options['blog_title_author_centered_share_background_color'] !== '') {?>
                .blog_holder.blog_title_author_centered .social_share_dropdown ul li a{
                background-color:  <?php echo esc_attr($mkd_options['blog_title_author_centered_share_background_color']); ?> ;
                }
			<?php } ?>
			<?php if(isset($mkd_options['blog_title_author_centered_share_icon_hover_color']) && $mkd_options['blog_title_author_centered_share_icon_hover_color'] !== '') {?>
                .blog_holder.blog_title_author_centered .social_share_dropdown ul li:hover,
                .blog_holder.blog_title_author_centered .social_share_dropdown ul li:hover a span.social_network_icon{
                color:  <?php echo esc_attr($mkd_options['blog_title_author_centered_share_icon_hover_color']); ?> !important;
                }
			<?php } ?>
		<?php } ?>
		<?php
		/******** BLOG: TITLE & AUTHOR (CENTERED) Separator ********/
		$blog_title_author_centered_separator_style = array();
		if(isset($mkd_options['blog_title_author_centered_separator_color']) && $mkd_options['blog_title_author_centered_separator_color'] !== '') {
			$blog_title_author_centered_separator_style[] = 'border-color: '.$mkd_options['blog_title_author_centered_separator_color'];
		}
		if(isset($mkd_options['blog_title_author_centered_separator_width']) && $mkd_options['blog_title_author_centered_separator_width'] !== '') {
			$blog_title_author_centered_separator_style[] = 'width: '.intval($mkd_options['blog_title_author_centered_separator_width']).'px';
		}
		if(isset($mkd_options['blog_title_author_centered_separator_thickness']) && $mkd_options['blog_title_author_centered_separator_thickness'] !== '') {
			$blog_title_author_centered_separator_style[] = 'border-width: '.intval($mkd_options['blog_title_author_centered_separator_thickness']).'px';
		}

		if(is_array($blog_title_author_centered_separator_style) && count($blog_title_author_centered_separator_style)) { ?>
            .blog_holder.blog_title_author_centered .post_text .post_text_inner .separator.small{
			<?php echo esc_attr(implode(';', $blog_title_author_centered_separator_style)); ?>
            }
		<?php } ?>

		<?php
		/******** BLOG: TITLE & AUTHOR (CENTERED) Text Box ********/
		if(isset($mkd_options['blog_title_author_centered_enable_text_box']) && $mkd_options['blog_title_author_centered_enable_text_box'] == 'yes') {
			$blog_box_style = array();
			?>
            .blog_holder.blog_title_author_centered article .audio_image,
            .blog_holder.blog_title_author_centered article:not(.format-audio) .post_image{
            margin-bottom: 0;
            }
			<?php
			if(isset($mkd_options['blog_title_author_centered_box_background_color']) && $mkd_options['blog_title_author_centered_box_background_color'] !== '') {
				$blog_box_style[] = 'background-color: '.$mkd_options['blog_title_author_centered_box_background_color'];
			}

			if(isset($mkd_options['blog_title_author_centered_box_border_color']) && $mkd_options['blog_title_author_centered_box_border_color'] !== '') {
				$blog_box_style[] = 'border: 1px solid';
				$blog_box_style[] = 'border-color: '.$mkd_options['blog_title_author_centered_box_border_color'];
			}

			if(isset($mkd_options['blog_title_author_centered_box_padding']) && $mkd_options['blog_title_author_centered_box_padding'] !== '') {
				$blog_box_style[] = 'padding: '.$mkd_options['blog_title_author_centered_box_padding'];
			}

			if(is_array($blog_box_style) && count($blog_box_style)) { ?>
                .blog_holder.blog_title_author_centered article:not(.format-link):not(.format-quote) .post_text .post_text_inner{
				<?php echo esc_attr(implode(';', $blog_box_style)); ?>
                }
			<?php }} ?>

		<?php
		/******** BLOG: TITLE & AUTHOR (CENTERED) Quote/Link Text Box ********/
		if(isset($mkd_options['blog_title_author_centered_ql_background_color']) &&($mkd_options['blog_title_author_centered_ql_background_color'])!==""){ ?>
            .blog_holder.blog_title_author_centered article.format-link .post_text .post_text_inner,
            .blog_holder.blog_title_author_centered article.format-quote .post_text .post_text_inner{
            background-color: <?php echo esc_attr($mkd_options['blog_title_author_centered_ql_background_color']);  ?>;
            }
			<?php  $blog_title_author_centered_ql_background_color = mikado_one_mikado_hex2rgb($mkd_options['blog_title_author_centered_ql_background_color']); ?>

            .blog_holder.blog_title_author_centered article.format-link .post_text.link_image .post_text_inner,
            .blog_holder.blog_title_author_centered article.format-quote .post_text.quote_image .post_text_inner{
			<?php if (!empty($mkd_options['blog_title_author_centered_ql_background_color'])) { ?>  background-color: rgba(<?php echo esc_attr($blog_title_author_centered_ql_background_color[0]); ?>,<?php echo esc_attr($blog_title_author_centered_ql_background_color[1]); ?>,<?php echo esc_attr($blog_title_author_centered_ql_background_color[2]); ?>,0.85); <?php } ?>
            }

		<?php } ?>

		<?php if(isset($mkd_options['blog_title_author_centered_ql_hover_background_color']) && !empty($mkd_options['blog_title_author_centered_ql_hover_background_color'])){ ?>
            .blog_holder.blog_title_author_centered article.format-link .post_text .post_text_inner:hover,
            .blog_holder.blog_title_author_centered article.format-quote .post_text .post_text_inner:hover{
            background-color: <?php echo esc_attr($mkd_options['blog_title_author_centered_ql_hover_background_color']);  ?>;
            }
			<?php  $blog_title_author_centered_ql_hover_background_color = mikado_one_mikado_hex2rgb($mkd_options['blog_title_author_centered_ql_hover_background_color']); ?>

            .blog_holder.blog_title_author_centered article.format-link .post_text.link_image .post_text_inner:hover,
            .blog_holder.blog_title_author_centered article.format-quote .post_text.quote_image .post_text_inner:hover{
			<?php if (!empty($mkd_options['blog_title_author_centered_ql_hover_background_color'])) { ?>  background-color: rgba(<?php echo esc_attr($blog_title_author_centered_ql_hover_background_color[0]); ?>,<?php echo esc_attr($blog_title_author_centered_ql_hover_background_color[1]); ?>,<?php echo esc_attr($blog_title_author_centered_ql_hover_background_color[2]); ?>,0.6); <?php } ?>
            }

		<?php } ?>

		<?php
		/**************** BLOG TITLE AUHTOR CENTERED: Spacing  ****************/
		if(isset($mkd_options['blog_title_author_centered_image_margin_bottom']) && $mkd_options['blog_title_author_centered_image_margin_bottom'] !== '') { ?>
            .blog_holder.blog_title_author_centered article:not(.format-audio) .post_image,
            .blog_holder.blog_title_author_centered article .audio_image{
            margin-bottom : <?php echo esc_attr($mkd_options['blog_title_author_centered_image_margin_bottom']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_title_author_centered_title_margin_bottom']) && $mkd_options['blog_title_author_centered_title_margin_bottom'] !== '') { ?>
            .blog_holder.blog_title_author_centered article .post_text h2{
            padding-bottom : <?php echo esc_attr($mkd_options['blog_title_author_centered_title_margin_bottom']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_title_author_centered_author_margin_top']) && $mkd_options['blog_title_author_centered_author_margin_top'] !== '') { ?>
            .blog_holder.blog_title_author_centered article .post_author{
            margin-top : <?php echo esc_attr($mkd_options['blog_title_author_centered_author_margin_top']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_title_author_centered_author_margin_bottom']) && $mkd_options['blog_title_author_centered_author_margin_bottom'] !== '') { ?>
            .blog_holder.blog_title_author_centered article .post_author{
            margin-bottom : <?php echo esc_attr($mkd_options['blog_title_author_centered_author_margin_bottom']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_title_author_centered_post_info_margin_top']) && $mkd_options['blog_title_author_centered_post_info_margin_top'] !== '') { ?>
            .blog_holder.blog_title_author_centered article:not(.format-link):not(.format-quote) .post_info{
            margin-top : <?php echo esc_attr($mkd_options['blog_title_author_centered_post_info_margin_top']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_title_author_centered_article_margin_bottom']) && $mkd_options['blog_title_author_centered_article_margin_bottom'] !== '') { ?>
            .blog_holder.blog_title_author_centered:not(.blog_single) article{
            margin-bottom : <?php echo esc_attr($mkd_options['blog_title_author_centered_article_margin_bottom']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_title_author_centered_ql_quote_author_margin_top']) && $mkd_options['blog_title_author_centered_ql_quote_author_margin_top'] !== '') { ?>
            .blog_holder.blog_title_author_centered article.format-quote .post_text_inner .quote_author{
            margin-top : <?php echo esc_attr($mkd_options['blog_title_author_centered_ql_quote_author_margin_top']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_title_author_centered_ql_icon_margin_top']) && $mkd_options['blog_title_author_centered_ql_icon_margin_top'] !== '') { ?>
            .blog_holder.blog_title_author_centered article.format-quote .post_info_quote_mark,
            .blog_holder.blog_title_author_centered article.format-link .post_info_link_mark{
            margin-top : <?php echo esc_attr($mkd_options['blog_title_author_centered_ql_icon_margin_top']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_title_author_centered_ql_post_info_margin_top']) && $mkd_options['blog_title_author_centered_ql_post_info_margin_top'] !== '') { ?>
            .blog_holder.blog_title_author_centered article.format-link .post_info,
            .blog_holder.blog_title_author_centered article.format-quote .post_info{
            margin-top : <?php echo esc_attr($mkd_options['blog_title_author_centered_ql_post_info_margin_top']).'px';?>
            }
		<?php } ?>

		<?php
		/**************** BLOG TITLE & AUTHOR (CENTERED): Title Style ****************/
		$blog_title_author_centered_title_style = array();

		if(isset($mkd_options['blog_title_author_centered_title_google_fonts']) && $mkd_options['blog_title_author_centered_title_google_fonts'] !== '-1') {
			$blog_title_author_centered_title_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_title_author_centered_title_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_title_author_centered_title_fontsize']) && $mkd_options['blog_title_author_centered_title_fontsize'] !== '') {
			$blog_title_author_centered_title_style[] = 'font-size: '.intval($mkd_options['blog_title_author_centered_title_fontsize']).'px';
		}

		if(isset($mkd_options['blog_title_author_centered_title_lineheight']) && $mkd_options['blog_title_author_centered_title_lineheight'] !== '') {
			$blog_title_author_centered_title_style[] = 'line-height: '.intval($mkd_options['blog_title_author_centered_title_lineheight']).'px';
		}

		if(isset($mkd_options['blog_title_author_centered_title_letterspacing']) && $mkd_options['blog_title_author_centered_title_letterspacing'] !== '') {
			$blog_title_author_centered_title_style[] = 'letter-spacing: '.intval($mkd_options['blog_title_author_centered_title_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_title_author_centered_title_fontweight']) && $mkd_options['blog_title_author_centered_title_fontweight'] !== '') {
			$blog_title_author_centered_title_style[] = 'font-weight: '.intval($mkd_options['blog_title_author_centered_title_fontweight']);
		}

		if(isset($mkd_options['blog_title_author_centered_title_fontstyle']) && $mkd_options['blog_title_author_centered_title_fontstyle'] !== '') {
			$blog_title_author_centered_title_style[] = 'font-style: '.$mkd_options['blog_title_author_centered_title_fontstyle'];
		}

		if(isset($mkd_options['blog_title_author_centered_title_texttransform']) && $mkd_options['blog_title_author_centered_title_texttransform'] !== '') {
			$blog_title_author_centered_title_style[] = 'text-transform: '.$mkd_options['blog_title_author_centered_title_texttransform'];
		}

		if(is_array($blog_title_author_centered_title_style) && count($blog_title_author_centered_title_style)) { ?>
            .blog_holder.blog_title_author_centered article:not(.format-quote):not(.format-link) h2{
			<?php echo esc_attr(implode(';', $blog_title_author_centered_title_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_title_author_centered_title_color']) && !empty($mkd_options['blog_title_author_centered_title_color'])){ ?>
            .blog_holder.blog_title_author_centered article:not(.format-quote):not(.format-link) h2 a,
            .blog_holder.blog_title_author_centered.blog_single article:not(.format-quote):not(.format-link) h2{
            color: <?php echo esc_attr($mkd_options['blog_title_author_centered_title_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_title_author_centered_title_hover_color']) && !empty($mkd_options['blog_title_author_centered_title_hover_color'])){ ?>
            .blog_holder.blog_title_author_centered article:not(.format-quote):not(.format-link) h2 a:hover,
            .blog_holder.blog_title_author_centered.blog_single article:not(.format-quote):not(.format-link) h2:hover{
            color: <?php echo esc_attr($mkd_options['blog_title_author_centered_title_hover_color']);  ?>;
            }
		<?php } ?>
		<?php
		/**************** BLOG TITLE & AUTHOR (CENTERED): Date Style ****************/
		$blog_title_author_centered_author_style = array();

		if(isset($mkd_options['blog_title_author_centered_author_google_fonts']) && $mkd_options['blog_title_author_centered_author_google_fonts'] !== '-1') {
			$blog_title_author_centered_author_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_title_author_centered_author_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_title_author_centered_author_fontsize']) && $mkd_options['blog_title_author_centered_author_fontsize'] !== '') {
			$blog_title_author_centered_author_style[] = 'font-size: '.intval($mkd_options['blog_title_author_centered_author_fontsize']).'px';
		}

		if(isset($mkd_options['blog_title_author_centered_author_lineheight']) && $mkd_options['blog_title_author_centered_author_lineheight'] !== '') {
			$blog_title_author_centered_author_style[] = 'line-height: '.$mkd_options['blog_title_author_centered_author_lineheight'].'px';
		}

		if(isset($mkd_options['blog_title_author_centered_author_letterspacing']) && $mkd_options['blog_title_author_centered_author_letterspacing'] !== '') {
			$blog_title_author_centered_author_style[] = 'letter-spacing: '.intval($mkd_options['blog_title_author_centered_author_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_title_author_centered_author_fontweight']) && $mkd_options['blog_title_author_centered_author_fontweight'] !== '') {
			$blog_title_author_centered_author_style[] = 'font-weight: '.intval($mkd_options['blog_title_author_centered_author_fontweight']);
		}

		if(isset($mkd_options['blog_title_author_centered_author_fontstyle']) && $mkd_options['blog_title_author_centered_author_fontstyle'] !== '') {
			$blog_title_author_centered_author_style[] = 'font-style: '.$mkd_options['blog_title_author_centered_author_fontstyle'];
		}

		if(isset($mkd_options['blog_title_author_centered_author_texttransform']) && $mkd_options['blog_title_author_centered_author_texttransform'] !== '') {
			$blog_title_author_centered_author_style[] = 'text-transform: '.$mkd_options['blog_title_author_centered_author_texttransform'];
		}

		if(is_array($blog_title_author_centered_author_style) && count($blog_title_author_centered_author_style)) { ?>
            .blog_holder.blog_title_author_centered article:not(.format-quote):not(.format-link) .post_author{
			<?php echo esc_attr(implode(';', $blog_title_author_centered_author_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_title_author_centered_author_color']) && !empty($mkd_options['blog_title_author_centered_author_color'])){ ?>
            .blog_holder.blog_title_author_centered article:not(.format-quote):not(.format-link) .post_author{
            color: <?php echo esc_attr($mkd_options['blog_title_author_centered_author_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_title_author_centered_author_link_color']) && !empty($mkd_options['blog_title_author_centered_author_link_color'])){ ?>
            .blog_holder.blog_title_author_centered article:not(.format-quote):not(.format-link) .post_author a{
            color: <?php echo esc_attr($mkd_options['blog_title_author_centered_author_link_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_title_author_centered_author_hover_color']) && !empty($mkd_options['blog_title_author_centered_author_hover_color'])){ ?>
            .blog_holder.blog_title_author_centered article:not(.format-quote):not(.format-link) .post_author a:hover{
            color: <?php echo esc_attr($mkd_options['blog_title_author_centered_author_hover_color']);  ?>;
            }
		<?php } ?>
		<?php
		/**************** BLOG TITLE & AUTHOR (CENTERED) Qoute/Link Title Style ****************/
		$blog_title_author_centered_ql_title_style = array();

		if(isset($mkd_options['blog_title_author_centered_ql_title_google_fonts']) && $mkd_options['blog_title_author_centered_ql_title_google_fonts'] !== '-1') {
			$blog_title_author_centered_ql_title_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_title_author_centered_ql_title_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_title_author_centered_ql_title_fontsize']) && $mkd_options['blog_title_author_centered_ql_title_fontsize'] !== '') {
			$blog_title_author_centered_ql_title_style[] = 'font-size: '.intval($mkd_options['blog_title_author_centered_ql_title_fontsize']).'px';
		}

		if(isset($mkd_options['blog_title_author_centered_ql_title_lineheight']) && $mkd_options['blog_title_author_centered_ql_title_lineheight'] !== '') {
			$blog_title_author_centered_ql_title_style[] = 'line-height: '.intval($mkd_options['blog_title_author_centered_ql_title_lineheight']).'px';
		}

		if(isset($mkd_options['blog_title_author_centered_ql_title_letterspacing']) && $mkd_options['blog_title_author_centered_ql_title_letterspacing'] !== '') {
			$blog_title_author_centered_ql_title_style[] = 'letter-spacing: '.intval($mkd_options['blog_title_author_centered_ql_title_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_title_author_centered_ql_title_fontweight']) && $mkd_options['blog_title_author_centered_ql_title_fontweight'] !== '') {
			$blog_title_author_centered_ql_title_style[] = 'font-weight: '.intval($mkd_options['blog_title_author_centered_ql_title_fontweight']);
		}

		if(isset($mkd_options['blog_title_author_centered_ql_title_fontstyle']) && $mkd_options['blog_title_author_centered_ql_title_fontstyle'] !== '') {
			$blog_title_author_centered_ql_title_style[] = 'font-style: '.$mkd_options['blog_title_author_centered_ql_title_fontstyle'];
		}

		if(isset($mkd_options['blog_title_author_centered_ql_title_texttransform']) && $mkd_options['blog_title_author_centered_ql_title_texttransform'] !== '') {
			$blog_title_author_centered_ql_title_style[] = 'text-transform: '.$mkd_options['blog_title_author_centered_ql_title_texttransform'];
		}

		if(is_array($blog_title_author_centered_ql_title_style) && count($blog_title_author_centered_ql_title_style)) { ?>
            .blog_holder.blog_title_author_centered article.format-quote .post_text .post_title h3,
            .blog_holder.blog_title_author_centered article.format-link .post_text .post_title h3
            {
			<?php echo esc_attr(implode(';', $blog_title_author_centered_ql_title_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_title_author_centered_ql_title_color']) && !empty($mkd_options['blog_title_author_centered_ql_title_color'])){ ?>
            .blog_holder.blog_title_author_centered article.format-quote .post_text .post_title h3 a,
            .blog_holder.blog_title_author_centered article.format-link .post_text .post_title h3 a,
            .blog_holder.blog_title_author_centered article.format-quote .post_text .post_title h3,
            .blog_holder.blog_title_author_centered article.format-link .post_text .post_title h3
            {
            color: <?php echo esc_attr($mkd_options['blog_title_author_centered_ql_title_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_title_author_centered_ql_title_hover_color']) && !empty($mkd_options['blog_title_author_centered_ql_title_hover_color'])){ ?>
            .blog_holder.blog_title_author_centered article.format-quote .post_text .post_text_inner:hover .post_title h3 a,
            .blog_holder.blog_title_author_centered article.format-link .post_text .post_text_inner:hover .post_title h3 a,
            .blog_holder.blog_title_author_centered article.format-quote .post_text .post_text_inner:hover .post_title h3,
            .blog_holder.blog_title_author_centered article.format-link .post_text .post_text_inner:hover .post_title h3
            {
            color: <?php echo esc_attr($mkd_options['blog_title_author_centered_ql_title_hover_color']);  ?>;
            }
		<?php } ?>
		<?php
		/**************** BLOG TITLE & AUTHOR (CENTERED) Qoute/Link Author Style ****************/
		$blog_title_author_centered_ql_author_style = array();

		if(isset($mkd_options['blog_title_author_centered_ql_author_google_fonts']) && $mkd_options['blog_title_author_centered_ql_author_google_fonts'] !== '-1') {
			$blog_title_author_centered_ql_author_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_title_author_centered_ql_author_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_title_author_centered_ql_author_fontsize']) && $mkd_options['blog_title_author_centered_ql_author_fontsize'] !== '') {
			$blog_title_author_centered_ql_author_style[] = 'font-size: '.intval($mkd_options['blog_title_author_centered_ql_author_fontsize']).'px';
		}

		if(isset($mkd_options['blog_title_author_centered_ql_author_lineheight']) && $mkd_options['blog_title_author_centered_ql_author_lineheight'] !== '') {
			$blog_title_author_centered_ql_author_style[] = 'line-height: '.intval($mkd_options['blog_title_author_centered_ql_author_lineheight']).'px';
		}

		if(isset($mkd_options['blog_title_author_centered_ql_author_letterspacing']) && $mkd_options['blog_title_author_centered_ql_author_letterspacing'] !== '') {
			$blog_title_author_centered_ql_author_style[] = 'letter-spacing: '.intval($mkd_options['blog_title_author_centered_ql_author_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_title_author_centered_ql_author_fontweight']) && $mkd_options['blog_title_author_centered_ql_author_fontweight'] !== '') {
			$blog_title_author_centered_ql_author_style[] = 'font-weight: '.intval($mkd_options['blog_title_author_centered_ql_author_fontweight']);
		}

		if(isset($mkd_options['blog_title_author_centered_ql_author_fontstyle']) && $mkd_options['blog_title_author_centered_ql_author_fontstyle'] !== '') {
			$blog_title_author_centered_ql_author_style[] = 'font-style: '.$mkd_options['blog_title_author_centered_ql_author_fontstyle'];
		}

		if(isset($mkd_options['blog_title_author_centered_ql_author_texttransform']) && $mkd_options['blog_title_author_centered_ql_author_texttransform'] !== '') {
			$blog_title_author_centered_ql_author_style[] = 'text-transform: '.$mkd_options['blog_title_author_centered_ql_author_texttransform'];
		}

		if(is_array($blog_title_author_centered_ql_author_style) && count($blog_title_author_centered_ql_author_style)) { ?>
            .blog_holder.blog_title_author_centered article.format-quote .post_text .quote_author
            {
			<?php echo esc_attr(implode(';', $blog_title_author_centered_ql_author_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_title_author_centered_ql_author_color']) && !empty($mkd_options['blog_title_author_centered_ql_author_color'])){ ?>
            .blog_holder.blog_title_author_centered article.format-quote .post_text .quote_author{
            color: <?php echo esc_attr($mkd_options['blog_title_author_centered_ql_author_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_title_author_centered_ql_author_hover_color']) && !empty($mkd_options['blog_title_author_centered_ql_author_hover_color'])){ ?>
            .blog_holder.blog_title_author_centered article.format-quote .post_text .post_text_inner:hover .quote_author{
            color: <?php echo esc_attr($mkd_options['blog_title_author_centered_ql_author_hover_color']);  ?>;
            }
		<?php } ?>
		<?php
		/**************** BLOG TITLE & AUTHOR (CENTERED) Info Style ****************/
		$blog_title_author_centered_info_style = array();

		if(isset($mkd_options['blog_title_author_centered_info_google_fonts']) && $mkd_options['blog_title_author_centered_info_google_fonts'] !== '-1') {
			$blog_title_author_centered_info_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_title_author_centered_info_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_title_author_centered_info_fontsize']) && $mkd_options['blog_title_author_centered_info_fontsize'] !== '') {
			$blog_title_author_centered_info_style[] = 'font-size: '.intval($mkd_options['blog_title_author_centered_info_fontsize']).'px';
		}

		if(isset($mkd_options['blog_title_author_centered_info_lineheight']) && $mkd_options['blog_title_author_centered_info_lineheight'] !== '') {
			$blog_title_author_centered_info_style[] = 'line-height: '.intval($mkd_options['blog_title_author_centered_info_lineheight']).'px';
		}

		if(isset($mkd_options['blog_title_author_centered_info_letterspacing']) && $mkd_options['blog_title_author_centered_info_letterspacing'] !== '') {
			$blog_title_author_centered_info_style[] = 'letter-spacing: '.intval($mkd_options['blog_title_author_centered_info_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_title_author_centered_info_fontweight']) && $mkd_options['blog_title_author_centered_info_fontweight'] !== '') {
			$blog_title_author_centered_info_style[] = 'font-weight: '.intval($mkd_options['blog_title_author_centered_info_fontweight']);
		}

		if(isset($mkd_options['blog_title_author_centered_info_fontstyle']) && $mkd_options['blog_title_author_centered_info_fontstyle'] !== '') {
			$blog_title_author_centered_info_style[] = 'font-style: '.$mkd_options['blog_title_author_centered_info_fontstyle'];
		}

		if(isset($mkd_options['blog_title_author_centered_info_texttransform']) && $mkd_options['blog_title_author_centered_info_texttransform'] !== '') {
			$blog_title_author_centered_info_style[] = 'text-transform: '.$mkd_options['blog_title_author_centered_info_texttransform'];
		}
		if(is_array($blog_title_author_centered_info_style) && count($blog_title_author_centered_info_style)) { ?>

            .blog_holder.blog_title_author_centered article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info{
			<?php echo esc_attr(implode(';', $blog_title_author_centered_info_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_title_author_centered_info_color']) && !empty($mkd_options['blog_title_author_centered_info_color'])){ ?>
            .blog_holder.blog_title_author_centered article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info{
            color: <?php echo esc_attr($mkd_options['blog_title_author_centered_info_color']);  ?>;
            }
		<?php } ?>


		<?php if(isset($mkd_options['blog_title_author_centered_info_link_color']) && !empty($mkd_options['blog_title_author_centered_info_link_color'])){ ?>
            .blog_holder.blog_title_author_centered article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info a
            {
            color: <?php echo esc_attr($mkd_options['blog_title_author_centered_info_link_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_title_author_centered_info_hover_color']) && !empty($mkd_options['blog_title_author_centered_info_hover_color'])){ ?>
            .blog_holder.blog_title_author_centered article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info a:hover {
            color: <?php echo esc_attr($mkd_options['blog_title_author_centered_info_hover_color']);  ?>;
            }
		<?php } ?>


		<?php
		/****************  BLOG TITLE & AUTHOR (CENTERED) Quote/Link Post Info Style *********************/
		$blog_title_author_centered_ql_info_style = array();

		if(isset($mkd_options['blog_title_author_centered_ql_info_google_fonts']) && $mkd_options['blog_title_author_centered_ql_info_google_fonts'] !== '-1') {
			$blog_title_author_centered_ql_info_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_title_author_centered_ql_info_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_title_author_centered_ql_info_fontsize']) && $mkd_options['blog_title_author_centered_ql_info_fontsize'] !== '') {
			$blog_title_author_centered_ql_info_style[] = 'font-size: '.intval($mkd_options['blog_title_author_centered_ql_info_fontsize']).'px';
		}

		if(isset($mkd_options['blog_title_author_centered_ql_info_lineheight']) && $mkd_options['blog_title_author_centered_ql_info_lineheight'] !== '') {
			$blog_title_author_centered_ql_info_style[] = 'line-height: '.intval($mkd_options['blog_title_author_centered_ql_info_lineheight']).'px';
		}

		if(isset($mkd_options['blog_title_author_centered_ql_info_letterspacing']) && $mkd_options['blog_title_author_centered_ql_info_letterspacing'] !== '') {
			$blog_title_author_centered_ql_info_style[] = 'letter-spacing: '.intval($mkd_options['blog_title_author_centered_ql_info_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_title_author_centered_ql_info_fontweight']) && $mkd_options['blog_title_author_centered_ql_info_fontweight'] !== '') {
			$blog_title_author_centered_ql_info_style[] = 'font-weight: '.intval($mkd_options['blog_title_author_centered_ql_info_fontweight']);
		}

		if(isset($mkd_options['blog_title_author_centered_ql_info_fontstyle']) && $mkd_options['blog_title_author_centered_ql_info_fontstyle'] !== '') {
			$blog_title_author_centered_ql_info_style[] = 'font-style: '.$mkd_options['blog_title_author_centered_ql_info_fontstyle'];
		}

		if(isset($mkd_options['blog_title_author_centered_ql_info_texttransform']) && $mkd_options['blog_title_author_centered_ql_info_texttransform'] !== '') {
			$blog_title_author_centered_ql_info_style[] = 'text-transform: '.$mkd_options['blog_title_author_centered_ql_info_texttransform'];
		}
		if(is_array($blog_title_author_centered_ql_info_style) && count($blog_title_author_centered_ql_info_style)) { ?>
            .blog_holder.blog_title_author_centered article.format-quote .post_text .post_text_inner .post_info div,
            .blog_holder.blog_title_author_centered article.format-link .post_text .post_text_inner .post_info div{
			<?php echo esc_attr(implode(';', $blog_title_author_centered_ql_info_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_title_author_centered_ql_info_color']) && !empty($mkd_options['blog_title_author_centered_ql_info_color'])){ ?>
            .blog_holder.blog_title_author_centered article.format-quote .post_text .post_text_inner .post_info div,
            .blog_holder.blog_title_author_centered article.format-link .post_text .post_text_inner .post_info div,
            .blog_holder.blog_title_author_centered article.format-quote .post_text .post_text_inner .post_info div a,
            .blog_holder.blog_title_author_centered article.format-link .post_text .post_text_inner .post_info div a{
            color: <?php echo esc_attr($mkd_options['blog_title_author_centered_ql_info_color']);  ?>;
            }
            .blog_holder.blog_title_author_centered article .post_text_inner .post_info{
            border-color: <?php echo esc_attr($mkd_options['blog_title_author_centered_ql_info_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_title_author_centered_ql_info_hover_color']) && !empty($mkd_options['blog_title_author_centered_ql_info_hover_color'])){ ?>
            .blog_holder.blog_title_author_centered article.format-quote .post_text .post_text_inner:hover .post_info div,
            .blog_holder.blog_title_author_centered article.format-link .post_text .post_text_inner:hover .post_info div,
            .blog_holder.blog_title_author_centered article.format-quote .post_text .post_text_inner:hover .post_info div a,
            .blog_holder.blog_title_author_centered article.format-link .post_text .post_text_inner:hover .post_info div a,
            .blog_holder.blog_title_author_centered article.format-quote .post_text .post_text_inner:hover .post_info div a i,
            .blog_holder.blog_title_author_centered article.format-link .post_text .post_text_inner:hover .post_info div a i{
            color: <?php echo esc_attr($mkd_options['blog_title_author_centered_ql_info_hover_color']);  ?>;
            }
            .blog_holder.blog_title_author_centered article .post_text_inner:hover .post_info{
            border-color: <?php echo esc_attr($mkd_options['blog_title_author_centered_ql_info_hover_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_title_author_centered_ql_mark_color']) && !empty($mkd_options['blog_title_author_centered_ql_mark_color'])){ ?>
            .blog_holder.blog_title_author_centered article.format-quote .post_text .post_text_inner .post_info_quote_mark .quote_mark,
            .blog_holder.blog_title_author_centered article.format-link .post_text .post_text_inner .post_info_link_mark .link_mark{
            color: <?php echo esc_attr($mkd_options['blog_title_author_centered_ql_mark_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_title_author_centered_ql_mark_hover_color']) && !empty($mkd_options['blog_title_author_centered_ql_mark_hover_color'])){ ?>
            .blog_holder.blog_title_author_centered article.format-quote .post_text .post_text_inner:hover .post_info_quote_mark .quote_mark,
            .blog_holder.blog_title_author_centered article.format-link .post_text .post_text_inner:hover .post_info_link_mark .link_mark{
            color: <?php echo esc_attr($mkd_options['blog_title_author_centered_ql_mark_hover_color']);  ?>;
            }
		<?php } ?>


		<?php
		/******** BLOG: POST INFO VERTICAL - IMAGE Share options ********/
		if(isset($mkd_options['blog_post_info_vertical_image_show_share']) && $mkd_options['blog_post_info_vertical_image_show_share'] == 'yes') {

			if(isset($mkd_options['blog_post_info_vertical_image_share_icon_color']) && $mkd_options['blog_post_info_vertical_image_share_icon_color'] !== '') {?>
                .blog_holder.blog_post_info_vertical_image .column_left .post_left_icons span .social_share_dropdown ul li a span.social_network_icon{
                color:  <?php echo esc_attr($mkd_options['blog_post_info_vertical_image_share_icon_color']); ?> ;
                }
			<?php } ?>
			<?php if(isset($mkd_options['blog_post_info_vertical_image_share_background_color']) && $mkd_options['blog_post_info_vertical_image_share_background_color'] !== '') {?>
                .blog_holder.blog_post_info_vertical_image .column_left .post_left_icons span .social_share_dropdown ul li a{
                background-color:  <?php echo esc_attr($mkd_options['blog_post_info_vertical_image_share_background_color']); ?> ;
                }
			<?php } ?>
			<?php if(isset($mkd_options['blog_post_info_vertical_image_share_icon_hover_color']) && $mkd_options['blog_post_info_vertical_image_share_icon_hover_color'] !== '') {?>
                .blog_holder.blog_post_info_vertical_image .social_share_dropdown ul li:hover,
                .blog_holder.blog_post_info_vertical_image .social_share_dropdown ul li:hover a span.social_network_icon{
                color:  <?php echo esc_attr($mkd_options['blog_post_info_vertical_image_share_icon_hover_color']); ?> !important;
                }
			<?php } ?>
		<?php } ?>
		<?php
		/******** BLOG: POST INFO VERTICAL IMAGE Post Info DATE & LIKE COLOR ********/
		if(isset($mkd_options['blog_post_info_vertical_image_date_like_share_color']) && $mkd_options['blog_post_info_vertical_image_date_like_share_color'] !== ''){ ?>
            .blog_holder.blog_post_info_vertical_image .column_left .post_left_icons span,
            .blog_holder.blog_post_info_vertical_image .column_left .post_left_icons span i{
            color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_image_date_like_share_color']);  ?>;
            }
            .blog_holder.blog_post_info_vertical_image .column_left .post_left_icons span.date_separator{
            border-color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_image_date_like_share_color']);  ?>;
            }
		<?php } ?>

		<?php
		/******** BLOG: POST INFO VERTICAL IMAGE Text Box ********/
		if(isset($mkd_options['blog_post_info_vertical_image_enable_text_box']) && $mkd_options['blog_post_info_vertical_image_enable_text_box'] == 'yes') {
			$blog_box_style = array();
			?>
            .blog_holder.blog_post_info_vertical_image article:not(.format-link):not(.format-quote):not(.format-audio) .post_image,
            .blog_holder.blog_post_info_vertical_image article .audio_image{
            margin-bottom: 0;
            }
			<?php
			if(isset($mkd_options['blog_post_info_vertical_image_box_background_color']) && $mkd_options['blog_post_info_vertical_image_box_background_color'] !== '') {
				$blog_box_style[] = 'background-color: '.$mkd_options['blog_post_info_vertical_image_box_background_color'];
			}

			if(isset($mkd_options['blog_post_info_vertical_image_box_border_color']) && $mkd_options['blog_post_info_vertical_image_box_border_color'] !== '') {
				$blog_box_style[] = 'border: 1px solid';
				$blog_box_style[] = 'border-color: '.$mkd_options['blog_post_info_vertical_image_box_border_color'];
			}

			if(isset($mkd_options['blog_post_info_vertical_image_box_padding']) && $mkd_options['blog_post_info_vertical_image_box_padding'] !== '') {
				$blog_box_style[] = 'padding: '.$mkd_options['blog_post_info_vertical_image_box_padding'];
			}

			if(is_array($blog_box_style) && count($blog_box_style)) { ?>
                .blog_holder.blog_post_info_vertical_image article:not(.format-link):not(.format-quote) .post_text .post_text_inner{
				<?php echo esc_attr(implode(';', $blog_box_style)); ?>
                }
			<?php }} ?>

		<?php
		/******** BLOG: POST INFO VERTICAL IMAGE Quote/Link Text Box ********/
		if(isset($mkd_options['blog_post_info_vertical_image_ql_background_color']) &&($mkd_options['blog_post_info_vertical_image_ql_background_color'])!==""){ ?>
            .blog_holder.blog_post_info_vertical_image article.format-link .post_text .post_text_inner,
            .blog_holder.blog_post_info_vertical_image article.format-quote .post_text .post_text_inner{
            background-color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_image_ql_background_color']);  ?>;
            }
			<?php  $blog_post_info_vertical_image_ql_background_color = mikado_one_mikado_hex2rgb($mkd_options['blog_post_info_vertical_image_ql_background_color']); ?>

            .blog_holder.blog_post_info_vertical_image article.format-link .post_text.link_image .post_text_inner,
            .blog_holder.blog_post_info_vertical_image article.format-quote .post_text.quote_image .post_text_inner{
			<?php if (!empty($mkd_options['blog_post_info_vertical_image_ql_background_color'])) { ?>  background-color: rgba(<?php echo esc_attr($blog_post_info_vertical_image_ql_background_color[0]); ?>,<?php echo esc_attr($blog_post_info_vertical_image_ql_background_color[1]); ?>,<?php echo esc_attr($blog_post_info_vertical_image_ql_background_color[2]); ?>,0.85); <?php } ?>
            }

		<?php } ?>

		<?php if(isset($mkd_options['blog_post_info_vertical_image_ql_hover_background_color']) && !empty($mkd_options['blog_post_info_vertical_image_ql_hover_background_color'])){ ?>
            .blog_holder.blog_post_info_vertical_image article.format-link .post_text .post_text_inner:hover,
            .blog_holder.blog_post_info_vertical_image article.format-quote .post_text .post_text_inner:hover{
            background-color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_image_ql_hover_background_color']);  ?>;
            }
			<?php  $blog_post_info_vertical_image_ql_hover_background_color = mikado_one_mikado_hex2rgb($mkd_options['blog_post_info_vertical_image_ql_hover_background_color']); ?>

            .blog_holder.blog_post_info_vertical_image article.format-link .post_text.link_image .post_text_inner:hover,
            .blog_holder.blog_post_info_vertical_image article.format-quote .post_text.quote_image .post_text_inner:hover{
			<?php if (!empty($mkd_options['blog_post_info_vertical_image_ql_hover_background_color'])) { ?>  background-color: rgba(<?php echo esc_attr($blog_post_info_vertical_image_ql_hover_background_color[0]); ?>,<?php echo esc_attr($blog_post_info_vertical_image_ql_hover_background_color[1]); ?>,<?php echo esc_attr($blog_post_info_vertical_image_ql_hover_background_color[2]); ?>,0.6); <?php } ?>
            }

		<?php } ?>

		<?php
		/**************** BLOG POST INFO VERTICAL IMAGE: Spacing  ****************/
		if(isset($mkd_options['blog_post_info_vertical_image_image_margin_bottom']) && $mkd_options['blog_post_info_vertical_image_image_margin_bottom'] !== '') { ?>
            .blog_holder.blog_post_info_vertical_image article:not(.format-link):not(.format-quote):not(.format-audio) .post_image,
            .blog_holder.blog_post_info_vertical_image article .audio_image{
            margin-bottom : <?php echo esc_attr($mkd_options['blog_post_info_vertical_image_image_margin_bottom']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_post_info_vertical_image_title_margin_bottom']) && $mkd_options['blog_post_info_vertical_image_title_margin_bottom'] !== '') { ?>
            .blog_holder.blog_post_info_vertical_image article h2{
            padding-bottom : <?php echo esc_attr($mkd_options['blog_post_info_vertical_image_title_margin_bottom']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_post_info_vertical_image_post_info_margin_top']) && $mkd_options['blog_post_info_vertical_image_post_info_margin_top'] !== '') { ?>
            .blog_holder.blog_post_info_vertical_image article:not(.format-quote):not(.format-link) .post_info{
            margin-top : <?php echo esc_attr($mkd_options['blog_post_info_vertical_image_post_info_margin_top']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_post_info_vertical_image_article_margin_bottom']) && $mkd_options['blog_post_info_vertical_image_article_margin_bottom'] !== '') { ?>
            .blog_holder.blog_post_info_vertical_image:not(.blog_single) article{
            margin-bottom : <?php echo esc_attr($mkd_options['blog_post_info_vertical_image_article_margin_bottom']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_post_info_vertical_image_ql_quote_author_margin_top']) && $mkd_options['blog_post_info_vertical_image_ql_quote_author_margin_top'] !== '') { ?>
            .blog_holder.blog_post_info_vertical_image article.format-quote .post_text_inner .quote_author{
            margin-top : <?php echo esc_attr($mkd_options['blog_post_info_vertical_image_ql_quote_author_margin_top']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_post_info_vertical_image_ql_post_info_margin_top']) && $mkd_options['blog_post_info_vertical_image_ql_post_info_margin_top'] !== '') { ?>
            .blog_holder.blog_post_info_vertical_image article.format-link .post_info,
            .blog_holder.blog_post_info_vertical_image article.format-quote .post_info{
            margin-top : <?php echo esc_attr($mkd_options['blog_post_info_vertical_image_ql_post_info_margin_top']).'px';?>
            }
		<?php } ?>


		<?php
		/**************** BLOG POST INFO VERTICAL IMAGE: Title Style ****************/
		$blog_post_info_vertical_image_title_style = array();

		if(isset($mkd_options['blog_post_info_vertical_image_title_google_fonts']) && $mkd_options['blog_post_info_vertical_image_title_google_fonts'] !== '-1') {
			$blog_post_info_vertical_image_title_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_post_info_vertical_image_title_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_post_info_vertical_image_title_fontsize']) && $mkd_options['blog_post_info_vertical_image_title_fontsize'] !== '') {
			$blog_post_info_vertical_image_title_style[] = 'font-size: '.intval($mkd_options['blog_post_info_vertical_image_title_fontsize']).'px';
		}

		if(isset($mkd_options['blog_post_info_vertical_image_title_lineheight']) && $mkd_options['blog_post_info_vertical_image_title_lineheight'] !== '') {
			$blog_post_info_vertical_image_title_style[] = 'line-height: '.intval($mkd_options['blog_post_info_vertical_image_title_lineheight']).'px';
		}

		if(isset($mkd_options['blog_post_info_vertical_image_title_letterspacing']) && $mkd_options['blog_post_info_vertical_image_title_letterspacing'] !== '') {
			$blog_post_info_vertical_image_title_style[] = 'letter-spacing: '.intval($mkd_options['blog_post_info_vertical_image_title_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_post_info_vertical_image_title_fontweight']) && $mkd_options['blog_post_info_vertical_image_title_fontweight'] !== '') {
			$blog_post_info_vertical_image_title_style[] = 'font-weight: '.intval($mkd_options['blog_post_info_vertical_image_title_fontweight']);
		}

		if(isset($mkd_options['blog_post_info_vertical_image_title_fontstyle']) && $mkd_options['blog_post_info_vertical_image_title_fontstyle'] !== '') {
			$blog_post_info_vertical_image_title_style[] = 'font-style: '.$mkd_options['blog_post_info_vertical_image_title_fontstyle'];
		}

		if(isset($mkd_options['blog_post_info_vertical_image_title_texttransform']) && $mkd_options['blog_post_info_vertical_image_title_texttransform'] !== '') {
			$blog_post_info_vertical_image_title_style[] = 'text-transform: '.$mkd_options['blog_post_info_vertical_image_title_texttransform'];
		}

		if(is_array($blog_post_info_vertical_image_title_style) && count($blog_post_info_vertical_image_title_style)) { ?>
            .blog_holder.blog_post_info_vertical_image article:not(.format-quote):not(.format-link) h2{
			<?php echo esc_attr(implode(';', $blog_post_info_vertical_image_title_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_post_info_vertical_image_title_color']) && !empty($mkd_options['blog_post_info_vertical_image_title_color'])){ ?>
            .blog_holder.blog_post_info_vertical_image article:not(.format-quote):not(.format-link) h2 a,
            .blog_holder.blog_post_info_vertical_image.blog_single article:not(.format-quote):not(.format-link) h2{
            color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_image_title_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_post_info_vertical_image_title_hover_color']) && !empty($mkd_options['blog_post_info_vertical_image_title_hover_color'])){ ?>
            .blog_holder.blog_post_info_vertical_image article:not(.format-quote):not(.format-link) h2 a:hover,
            .blog_holder.blog_post_info_vertical_image.blog_single article:not(.format-quote):not(.format-link) h2:hover{
            color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_image_title_hover_color']);  ?>;
            }
		<?php } ?>

		<?php
		/**************** BLOG POST INFO VERTICAL IMAGE: Qoute/Link Title Style ****************/
		$blog_post_info_vertical_image_ql_title_style = array();

		if(isset($mkd_options['blog_post_info_vertical_image_ql_title_google_fonts']) && $mkd_options['blog_post_info_vertical_image_ql_title_google_fonts'] !== '-1') {
			$blog_post_info_vertical_image_ql_title_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_post_info_vertical_image_ql_title_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_post_info_vertical_image_ql_title_fontsize']) && $mkd_options['blog_post_info_vertical_image_ql_title_fontsize'] !== '') {
			$blog_post_info_vertical_image_ql_title_style[] = 'font-size: '.intval($mkd_options['blog_post_info_vertical_image_ql_title_fontsize']).'px';
		}

		if(isset($mkd_options['blog_post_info_vertical_image_ql_title_lineheight']) && $mkd_options['blog_post_info_vertical_image_ql_title_lineheight'] !== '') {
			$blog_post_info_vertical_image_ql_title_style[] = 'line-height: '.intval($mkd_options['blog_post_info_vertical_image_ql_title_lineheight']).'px';
		}

		if(isset($mkd_options['blog_post_info_vertical_image_ql_title_letterspacing']) && $mkd_options['blog_post_info_vertical_image_ql_title_letterspacing'] !== '') {
			$blog_post_info_vertical_image_ql_title_style[] = 'letter-spacing: '.intval($mkd_options['blog_post_info_vertical_image_ql_title_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_post_info_vertical_image_ql_title_fontweight']) && $mkd_options['blog_post_info_vertical_image_ql_title_fontweight'] !== '') {
			$blog_post_info_vertical_image_ql_title_style[] = 'font-weight: '.intval($mkd_options['blog_post_info_vertical_image_ql_title_fontweight']);
		}

		if(isset($mkd_options['blog_post_info_vertical_image_ql_title_fontstyle']) && $mkd_options['blog_post_info_vertical_image_ql_title_fontstyle'] !== '') {
			$blog_post_info_vertical_image_ql_title_style[] = 'font-style: '.$mkd_options['blog_post_info_vertical_image_ql_title_fontstyle'];
		}

		if(isset($mkd_options['blog_post_info_vertical_image_ql_title_texttransform']) && $mkd_options['blog_post_info_vertical_image_ql_title_texttransform'] !== '') {
			$blog_post_info_vertical_image_ql_title_style[] = 'text-transform: '.$mkd_options['blog_post_info_vertical_image_ql_title_texttransform'];
		}

		if(is_array($blog_post_info_vertical_image_ql_title_style) && count($blog_post_info_vertical_image_ql_title_style)) { ?>
            .blog_holder.blog_post_info_vertical_image article.format-quote .post_text .post_title h3,
            .blog_holder.blog_post_info_vertical_image article.format-link .post_text .post_title h3{
			<?php echo esc_attr(implode(';', $blog_post_info_vertical_image_ql_title_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_post_info_vertical_image_ql_title_color']) && !empty($mkd_options['blog_post_info_vertical_image_ql_title_color'])){ ?>
            .blog_holder.blog_post_info_vertical_image article.format-quote .post_text .post_title h3 a,
            .blog_holder.blog_post_info_vertical_image article.format-link .post_text .post_title h3 a,
            .blog_holder.blog_post_info_vertical_image article.format-quote .post_text .post_title h3,
            .blog_holder.blog_post_info_vertical_image article.format-link .post_text .post_title h3
            {
            color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_image_ql_title_color']);  ?>;

            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_post_info_vertical_image_ql_title_hover_color']) && !empty($mkd_options['blog_post_info_vertical_image_ql_title_hover_color'])){ ?>
            .blog_holder.blog_post_info_vertical_image article.format-quote .post_text .post_text_inner:hover .post_title h3 a,
            .blog_holder.blog_post_info_vertical_image article.format-link .post_text .post_text_inner:hover .post_title h3 a,
            .blog_holder.blog_post_info_vertical_image article.format-quote .post_text .post_text_inner:hover .post_title h3,
            .blog_holder.blog_post_info_vertical_image article.format-link .post_text .post_text_inner:hover .post_title h3
            {
            color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_image_ql_title_hover_color']);  ?>;

            }
		<?php } ?>
		<?php
		/**************** BLOG POST INFO VERTICAL IMAGE: Qoute Author Style ****************/
		$blog_post_info_vertical_image_ql_author_style = array();

		if(isset($mkd_options['blog_post_info_vertical_image_ql_author_google_fonts']) && $mkd_options['blog_post_info_vertical_image_ql_author_google_fonts'] !== '-1') {
			$blog_post_info_vertical_image_ql_author_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_post_info_vertical_image_ql_author_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_post_info_vertical_image_ql_author_fontsize']) && $mkd_options['blog_post_info_vertical_image_ql_author_fontsize'] !== '') {
			$blog_post_info_vertical_image_ql_author_style[] = 'font-size: '.intval($mkd_options['blog_post_info_vertical_image_ql_author_fontsize']).'px';
		}

		if(isset($mkd_options['blog_post_info_vertical_image_ql_author_lineheight']) && $mkd_options['blog_post_info_vertical_image_ql_author_lineheight'] !== '') {
			$blog_post_info_vertical_image_ql_author_style[] = 'line-height: '.intval($mkd_options['blog_post_info_vertical_image_ql_author_lineheight']).'px';
		}

		if(isset($mkd_options['blog_post_info_vertical_image_ql_author_letterspacing']) && $mkd_options['blog_post_info_vertical_image_ql_author_letterspacing'] !== '') {
			$blog_post_info_vertical_image_ql_author_style[] = 'letter-spacing: '.intval($mkd_options['blog_post_info_vertical_image_ql_author_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_post_info_vertical_image_ql_author_fontweight']) && $mkd_options['blog_post_info_vertical_image_ql_author_fontweight'] !== '') {
			$blog_post_info_vertical_image_ql_author_style[] = 'font-weight: '.intval($mkd_options['blog_post_info_vertical_image_ql_author_fontweight']);
		}

		if(isset($mkd_options['blog_post_info_vertical_image_ql_author_fontstyle']) && $mkd_options['blog_post_info_vertical_image_ql_author_fontstyle'] !== '') {
			$blog_post_info_vertical_image_ql_author_style[] = 'font-style: '.$mkd_options['blog_post_info_vertical_image_ql_author_fontstyle'];
		}

		if(isset($mkd_options['blog_post_info_vertical_image_ql_author_texttransform']) && $mkd_options['blog_post_info_vertical_image_ql_author_texttransform'] !== '') {
			$blog_post_info_vertical_image_ql_author_style[] = 'text-transform: '.$mkd_options['blog_post_info_vertical_image_ql_author_texttransform'];
		}

		if(is_array($blog_post_info_vertical_image_ql_author_style) && count($blog_post_info_vertical_image_ql_author_style)) { ?>
            .blog_holder.blog_post_info_vertical_image article.format-quote .post_text .quote_author{
			<?php echo esc_attr(implode(';', $blog_post_info_vertical_image_ql_author_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_post_info_vertical_image_ql_author_color']) && !empty($mkd_options['blog_post_info_vertical_image_ql_author_color'])){ ?>
            .blog_holder.blog_post_info_vertical_image article.format-quote .post_text .quote_author{
            color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_image_ql_author_color']);  ?>;

            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_post_info_vertical_image_ql_author_hover_color']) && !empty($mkd_options['blog_post_info_vertical_image_ql_author_hover_color'])){ ?>
            .blog_holder.blog_post_info_vertical_image article.format-quote .post_text .post_text_inner:hover .quote_author{
            color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_image_ql_author_hover_color']);  ?>;
            }
		<?php } ?>
		<?php
		/**************** BLOG POST INFO VERTICAL IMAGE: Info Style ****************/
		$blog_post_info_vertical_image_info_style = array();

		if(isset($mkd_options['blog_post_info_vertical_image_info_google_fonts']) && $mkd_options['blog_post_info_vertical_image_info_google_fonts'] !== '-1') {
			$blog_post_info_vertical_image_info_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_post_info_vertical_image_info_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_post_info_vertical_image_info_fontsize']) && $mkd_options['blog_post_info_vertical_image_info_fontsize'] !== '') {
			$blog_post_info_vertical_image_info_style[] = 'font-size: '.intval($mkd_options['blog_post_info_vertical_image_info_fontsize']).'px';
		}

		if(isset($mkd_options['blog_post_info_vertical_image_info_lineheight']) && $mkd_options['blog_post_info_vertical_image_info_lineheight'] !== '') {
			$blog_post_info_vertical_image_info_style[] = 'line-height: '.intval($mkd_options['blog_post_info_vertical_image_info_lineheight']).'px';
		}

		if(isset($mkd_options['blog_post_info_vertical_image_info_letterspacing']) && $mkd_options['blog_post_info_vertical_image_info_letterspacing'] !== '') {
			$blog_post_info_vertical_image_info_style[] = 'letter-spacing: '.intval($mkd_options['blog_post_info_vertical_image_info_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_post_info_vertical_image_info_fontweight']) && $mkd_options['blog_post_info_vertical_image_info_fontweight'] !== '') {
			$blog_post_info_vertical_image_info_style[] = 'font-weight: '.intval($mkd_options['blog_post_info_vertical_image_info_fontweight']);
		}

		if(isset($mkd_options['blog_post_info_vertical_image_info_fontstyle']) && $mkd_options['blog_post_info_vertical_image_info_fontstyle'] !== '') {
			$blog_post_info_vertical_image_info_style[] = 'font-style: '.$mkd_options['blog_post_info_vertical_image_info_fontstyle'];
		}

		if(isset($mkd_options['blog_post_info_vertical_image_info_texttransform']) && $mkd_options['blog_post_info_vertical_image_info_texttransform'] !== '') {
			$blog_post_info_vertical_image_info_style[] = 'text-transform: '.$mkd_options['blog_post_info_vertical_image_info_texttransform'];
		}
		if(is_array($blog_post_info_vertical_image_info_style) && count($blog_post_info_vertical_image_info_style)) { ?>

            .blog_holder.blog_post_info_vertical_image article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info div{
			<?php echo esc_attr(implode(';', $blog_post_info_vertical_image_info_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_post_info_vertical_image_info_color']) && !empty($mkd_options['blog_post_info_vertical_image_info_color'])){ ?>
            .blog_holder.blog_post_info_vertical_image article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info div{
            color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_image_info_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_post_info_vertical_image_info_link_color']) && !empty($mkd_options['blog_post_info_vertical_image_info_link_color'])){ ?>
            .blog_holder.blog_post_info_vertical_image article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info div a{
            color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_image_info_link_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_post_info_vertical_image_info_hover_color']) && !empty($mkd_options['blog_post_info_vertical_image_info_hover_color'])){ ?>
            .blog_holder.blog_post_info_vertical_image article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info div a:hover,
            .blog_holder.blog_post_info_vertical_image article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info div a:hover i{
            color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_image_info_hover_color']);  ?>;
            }
		<?php } ?>


		<?php
		/****************  BLOG POST INFO VERTICAL IMAGE: Quote/Link Post Info Style *********************/
		$blog_post_info_vertical_image_ql_info_style = array();

		if(isset($mkd_options['blog_post_info_vertical_image_ql_info_google_fonts']) && $mkd_options['blog_post_info_vertical_image_ql_info_google_fonts'] !== '-1') {
			$blog_post_info_vertical_image_ql_info_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_post_info_vertical_image_ql_info_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_post_info_vertical_image_ql_info_fontsize']) && $mkd_options['blog_post_info_vertical_image_ql_info_fontsize'] !== '') {
			$blog_post_info_vertical_image_ql_info_style[] = 'font-size: '.intval($mkd_options['blog_post_info_vertical_image_ql_info_fontsize']).'px';
		}

		if(isset($mkd_options['blog_post_info_vertical_image_ql_info_lineheight']) && $mkd_options['blog_post_info_vertical_image_ql_info_lineheight'] !== '') {
			$blog_post_info_vertical_image_ql_info_style[] = 'line-height: '.intval($mkd_options['blog_post_info_vertical_image_ql_info_lineheight']).'px';
		}

		if(isset($mkd_options['blog_post_info_vertical_image_ql_info_letterspacing']) && $mkd_options['blog_post_info_vertical_image_ql_info_letterspacing'] !== '') {
			$blog_post_info_vertical_image_ql_info_style[] = 'letter-spacing: '.intval($mkd_options['blog_post_info_vertical_image_ql_info_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_post_info_vertical_image_ql_info_fontweight']) && $mkd_options['blog_post_info_vertical_image_ql_info_fontweight'] !== '') {
			$blog_post_info_vertical_image_ql_info_style[] = 'font-weight: '.intval($mkd_options['blog_post_info_vertical_image_ql_info_fontweight']);
		}

		if(isset($mkd_options['blog_post_info_vertical_image_ql_info_fontstyle']) && $mkd_options['blog_post_info_vertical_image_ql_info_fontstyle'] !== '') {
			$blog_post_info_vertical_image_ql_info_style[] = 'font-style: '.$mkd_options['blog_post_info_vertical_image_ql_info_fontstyle'];
		}

		if(isset($mkd_options['blog_post_info_vertical_image_ql_info_texttransform']) && $mkd_options['blog_post_info_vertical_image_ql_info_texttransform'] !== '') {
			$blog_post_info_vertical_image_ql_info_style[] = 'text-transform: '.$mkd_options['blog_post_info_vertical_image_ql_info_texttransform'];
		}
		if(is_array($blog_post_info_vertical_image_ql_info_style) && count($blog_post_info_vertical_image_ql_info_style)) { ?>
            .blog_holder.blog_post_info_vertical_image article.format-quote .post_text .post_text_inner .post_info div,
            .blog_holder.blog_post_info_vertical_image article.format-link .post_text .post_text_inner .post_info div{
			<?php echo esc_attr(implode(';', $blog_post_info_vertical_image_ql_info_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_post_info_vertical_image_ql_info_color']) && !empty($mkd_options['blog_post_info_vertical_image_ql_info_color'])){ ?>
            .blog_holder.blog_post_info_vertical_image article.format-quote .post_text .post_text_inner .post_info,
            .blog_holder.blog_post_info_vertical_image article.format-link .post_text .post_text_inner .post_info{
            color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_image_ql_info_color']);  ?>;
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_post_info_vertical_image_ql_info_link_color']) && !empty($mkd_options['blog_post_info_vertical_image_ql_info_link_color'])){ ?>
            .blog_holder.blog_post_info_vertical_image article.format-quote .post_text .post_text_inner .post_info div a,
            .blog_holder.blog_post_info_vertical_image article.format-link .post_text .post_text_inner .post_info div a{
            color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_image_ql_info_link_color']);  ?>;
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_post_info_vertical_image_ql_info_hover_color']) && !empty($mkd_options['blog_post_info_vertical_image_ql_info_hover_color'])){ ?>
            .blog_holder.blog_post_info_vertical_image article.format-quote .post_text .post_text_inner:hover .post_info div,
            .blog_holder.blog_post_info_vertical_image article.format-link .post_text .post_text_inner:hover .post_info div,
            .blog_holder.blog_post_info_vertical_image article.format-quote .post_text .post_text_inner:hover .post_info div a,
            .blog_holder.blog_post_info_vertical_image article.format-link .post_text .post_text_inner:hover .post_info div a{
            color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_image_ql_info_hover_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_post_info_vertical_image_ql_mark_color']) && !empty($mkd_options['blog_post_info_vertical_image_ql_mark_color'])){ ?>
            .blog_holder.blog_post_info_vertical_image article.format-quote .post_text .post_text_inner .post_info_quote_mark .quote_mark,
            .blog_holder.blog_post_info_vertical_image article.format-link .post_text .post_text_inner .post_info_link_mark .link_mark{
            color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_image_ql_mark_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_post_info_vertical_image_ql_mark_hover_color']) && !empty($mkd_options['blog_post_info_vertical_image_ql_mark_hover_color'])){ ?>
            .blog_holder.blog_post_info_vertical_image article.format-quote .post_text .post_text_inner:hover .post_info_quote_mark .quote_mark,
            .blog_holder.blog_post_info_vertical_image article.format-link .post_text .post_text_inner:hover .post_info_link_mark .link_mark{
            color: <?php echo esc_attr($mkd_options['blog_post_info_vertical_image_ql_mark_hover_color']);  ?>;
            }
		<?php } ?>



		<?php
		/******** BLOG: MASONRY Share options ********/
		if(isset($mkd_options['blog_masonry_show_share']) && $mkd_options['blog_masonry_show_share'] == 'yes') {

			if(isset($mkd_options['blog_masonry_share_icon_color']) && $mkd_options['blog_masonry_share_icon_color'] !== '') {?>
                .blog_holder.masonry article .post_text .post_text_inner .post_info .blog_share .social_share_dropdown ul li a span.social_network_icon,
                .blog_holder.masonry article.format-link .post_text.link_image .post_text_inner:hover .post_info .social_share_dropdown ul li a span.social_network_icon{
                color:  <?php echo esc_attr($mkd_options['blog_masonry_share_icon_color']); ?> ;
                }
			<?php } ?>
			<?php if(isset($mkd_options['blog_masonry_share_background_color']) && $mkd_options['blog_masonry_share_background_color'] !== '') {?>
                .blog_holder.masonry article .post_text .post_text_inner .post_info .blog_share .social_share_dropdown ul li a{
                background-color:  <?php echo esc_attr($mkd_options['blog_masonry_share_background_color']); ?> ;
                }
			<?php } ?>
			<?php if(isset($mkd_options['blog_masonry_share_icon_hover_color']) && $mkd_options['blog_masonry_share_icon_hover_color'] !== '') {?>
                .blog_holder.masonry .social_share_dropdown ul li:hover,
                .blog_holder.masonry .social_share_dropdown ul li:hover a span.social_network_icon{
                color:  <?php echo esc_attr($mkd_options['blog_masonry_share_icon_hover_color']); ?> !important;
                }
			<?php } ?>
		<?php } ?>


		<?php
		/******** BLOG: MASONRY Alignment ********/
		if(isset($mkd_options['blog_masonry_post_alignment']) && $mkd_options['blog_masonry_post_alignment'] !== '') {?>
            .blog_holder.masonry .post_text .post_text_inner,
            .blog_holder.masonry_full_width .post_text .post_text_inner{
            text-align: <?php echo esc_attr($mkd_options['blog_masonry_post_alignment']); ?>
            }
		<?php } ?>

		<?php
		/******** BLOG: MASONRY Text Box ********/
		if(isset($mkd_options['blog_masonry_enable_text_box']) && $mkd_options['blog_masonry_enable_text_box'] == 'yes') {
			$blog_box_style = array();
			?>
            .blog_holder.masonry article .audio_image,
            .blog_holder.masonry article:not(.format-audio) .post_image,
            .blog_holder.masonry_full_width article .audio_image,
            .blog_holder.masonry_full_width article:not(.format-audio) .post_image{
            margin-bottom: 0;
            }
			<?php
			if(isset($mkd_options['blog_masonry_box_background_color']) && $mkd_options['blog_masonry_box_background_color'] !== '') {
				$blog_box_style[] = 'background-color: '.$mkd_options['blog_masonry_box_background_color'];
			}

			if(isset($mkd_options['blog_masonry_box_border_color']) && $mkd_options['blog_masonry_box_border_color'] !== '') {
				$blog_box_style[] = 'border: 1px solid';
				$blog_box_style[] = 'border-color: '.$mkd_options['blog_masonry_box_border_color'];
			}

			if(isset($mkd_options['blog_masonry_box_padding']) && $mkd_options['blog_masonry_box_padding'] !== '') {
				$blog_box_style[] = 'padding: '.$mkd_options['blog_masonry_box_padding'];
			}

			if(is_array($blog_box_style) && count($blog_box_style)) { ?>
                .blog_holder.masonry article:not(.format-link):not(.format-quote) .post_text .post_text_inner,
                .blog_holder.masonry_full_width article:not(.format-link):not(.format-quote) .post_text .post_text_inner{
				<?php echo esc_attr(implode(';', $blog_box_style)); ?>
                }
			<?php }} ?>


		<?php
		/******** BLOG: MASONRY Post Info Box ********/
		if(isset($mkd_options['blog_masonry_enable_top_bottom_border_box']) && $mkd_options['blog_masonry_enable_top_bottom_border_box'] == 'yes') {
			$blog_top_bottom_border_box_style = array();

			if(isset($mkd_options['blog_masonry_top_border_box']) && $mkd_options['blog_masonry_top_border_box'] == 'no') {
				$blog_top_bottom_border_box_style[] = 'border-top: none';
			}

			if(isset($mkd_options['blog_masonry_bottom_border_box']) && $mkd_options['blog_masonry_bottom_border_box'] == 'no') {
				$blog_top_bottom_border_box_style[] = 'border-bottom: none';
			}

			if(isset($mkd_options['blog_masonry_top_botom_border_padding']) && $mkd_options['blog_masonry_top_botom_border_padding'] !== '') {
				$blog_top_bottom_border_box_style[] = 'padding: '.$mkd_options['blog_masonry_top_botom_border_padding'];
			}

			if(is_array($blog_top_bottom_border_box_style) && count($blog_top_bottom_border_box_style)) { ?>
                .blog_holder.masonry article .post_text .post_text_inner .post_info,
                .blog_holder.masonry_full_width article .post_text .post_text_inner .post_info{
				<?php echo esc_attr(implode(';', $blog_top_bottom_border_box_style)); ?>
                }
			<?php }}

        elseif (isset($mkd_options['blog_masonry_enable_top_bottom_border_box']) && $mkd_options['blog_masonry_enable_top_bottom_border_box'] == 'no'){
			$blog_top_bottom_border_box_style = array();
			$blog_top_bottom_border_box_style[] = 'border-top: none';
			$blog_top_bottom_border_box_style[] = 'border-bottom: none';
			?>
            .blog_holder.masonry article .post_text .post_text_inner .post_info,
            .blog_holder.masonry_full_width article .post_text .post_text_inner .post_info{
			<?php echo esc_attr(implode(';', $blog_top_bottom_border_box_style)); ?>
            }
		<?php } ?>

		<?php
		/******** BLOG: MASONRY Quote/Link Text Box ********/
		if(isset($mkd_options['blog_masonry_ql_background_color']) &&($mkd_options['blog_masonry_ql_background_color'])!==""){ ?>
            .blog_holder.masonry article.format-link .post_text .post_text_inner,
            .blog_holder.masonry_full_width article.format-link .post_text .post_text_inner,
            .blog_holder.masonry article.format-quote .post_text .post_text_inner,
            .blog_holder.masonry_full_width article.format-quote .post_text .post_text_inner{
            background-color: <?php echo esc_attr($mkd_options['blog_masonry_ql_background_color']);  ?>;
            }
			<?php  $blog_masonry_ql_background_color = mikado_one_mikado_hex2rgb($mkd_options['blog_masonry_ql_background_color']); ?>

            .blog_holder.masonry article.format-link .post_text.link_image .post_text_inner,
            .blog_holder.masonry_full_width article.format-link .post_text.link_image .post_text_inner,
            .blog_holder.masonry article.format-quote .post_text.quote_image .post_text_inner,
            .blog_holder.masonry_full_width article.format-quote .post_text.quote_image .post_text_inner{
			<?php if (!empty($mkd_options['blog_masonry_ql_background_color'])) { ?>  background-color: rgba(<?php echo esc_attr($blog_masonry_ql_background_color[0]); ?>,<?php echo esc_attr($blog_masonry_ql_background_color[1]); ?>,<?php echo esc_attr($blog_masonry_ql_background_color[2]); ?>,0.85); <?php } ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_masonry_ql_hover_background_color']) && !empty($mkd_options['blog_masonry_ql_hover_background_color'])){ ?>
            .blog_holder.masonry article.format-link .post_text .post_text_inner:hover,
            .blog_holder.masonry article.format-quote .post_text .post_text_inner:hover,
            .blog_holder.masonry_full_width article.format-link .post_text .post_text_inner:hover,
            .blog_holder.masonry_full_width article.format-quote .post_text .post_text_inner:hover{
            background-color: <?php echo esc_attr($mkd_options['blog_masonry_ql_hover_background_color']);  ?>;
            }
			<?php  $blog_masonry_ql_hover_background_color = mikado_one_mikado_hex2rgb($mkd_options['blog_masonry_ql_hover_background_color']); ?>

            .blog_holder.masonry article.format-link .post_text.link_image .post_text_inner:hover,
            .blog_holder.masonry article.format-quote .post_text.quote_image .post_text_inner:hover,
            .blog_holder.masonry_full_width article.format-link .post_text.link_image .post_text_inner:hover,
            .blog_holder.masonry_full_width article.format-quote .post_text.quote_image .post_text_inner:hover{
			<?php if (!empty($mkd_options['blog_masonry_ql_hover_background_color'])) { ?>  background-color: rgba(<?php echo esc_attr($blog_masonry_ql_hover_background_color[0]); ?>,<?php echo esc_attr($blog_masonry_ql_hover_background_color[1]); ?>,<?php echo esc_attr($blog_masonry_ql_hover_background_color[2]); ?>,0.6); <?php } ?>
            }

		<?php } ?>

		<?php
		/**************** BLOG MASONRY: Spacing  ****************/
		if(isset($mkd_options['blog_masonry_image_margin_bottom']) && $mkd_options['blog_masonry_image_margin_bottom'] !== '') { ?>
            .blog_holder.masonry article:not(.format-audio) .post_image,
            .blog_holder.masonry article .audio_image,
            .blog_holder.masonry_full_width article:not(.format-audio) .post_image,
            .blog_holder.masonry_full_width article .audio_image{
            margin-bottom : <?php echo esc_attr($mkd_options['blog_masonry_image_margin_bottom']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_masonry_title_margin_bottom']) && $mkd_options['blog_masonry_title_margin_bottom'] !== '') { ?>
            .blog_holder.masonry article .post_text h4,
            .blog_holder.masonry_full_width article .post_text h4{
            margin-bottom : <?php echo esc_attr($mkd_options['blog_masonry_title_margin_bottom']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_masonry_post_info_margin_top']) && $mkd_options['blog_masonry_post_info_margin_top'] !== '') { ?>
            .blog_holder.masonry article:not(.format-link):not(.format-quote) .post_info,
            .blog_holder.masonry_full_width article:not(.format-link):not(.format-quote) .post_info{
            margin-top : <?php echo esc_attr($mkd_options['blog_masonry_post_info_margin_top']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_masonry_article_margin_bottom']) && $mkd_options['blog_masonry_article_margin_bottom'] !== '') { ?>
            .blog_holder.masonry:not(.blog_single) article,
            .blog_holder.masonry_full_width:not(.blog_single) article{
            margin-bottom : <?php echo esc_attr($mkd_options['blog_masonry_article_margin_bottom']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_masonry_ql_quote_author_margin_top']) && $mkd_options['blog_masonry_ql_quote_author_margin_top'] !== '') { ?>
            .blog_holder.masonry article.format-quote .post_text_inner .quote_author,
            .blog_holder.masonry_full_width article.format-quote .post_text_inner .quote_author{
            padding-top : <?php echo esc_attr($mkd_options['blog_masonry_ql_quote_author_margin_top']).'px';?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_masonry_ql_post_info_margin_top']) && $mkd_options['blog_masonry_ql_post_info_margin_top'] !== '') { ?>
            .blog_holder.masonry article.format-link .post_info,
            .blog_holder.masonry_full_width article.format-link .post_info,
            .blog_holder.masonry article.format-quote .post_info,
            .blog_holder.masonry_full_width article.format-quote .post_info{
            margin-top : <?php echo esc_attr($mkd_options['blog_masonry_ql_post_info_margin_top']).'px';?>
            }
		<?php } ?>

		<?php
		/**************** BLOG MASONRY: Title Style ****************/
		$blog_masonry_title_style = array();

		if(isset($mkd_options['blog_masonry_title_google_fonts']) && $mkd_options['blog_masonry_title_google_fonts'] !== '-1') {
			$blog_masonry_title_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_masonry_title_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_masonry_title_fontsize']) && $mkd_options['blog_masonry_title_fontsize'] !== '') {
			$blog_masonry_title_style[] = 'font-size: '.intval($mkd_options['blog_masonry_title_fontsize']).'px';
		}

		if(isset($mkd_options['blog_masonry_title_lineheight']) && $mkd_options['blog_masonry_title_lineheight'] !== '') {
			$blog_masonry_title_style[] = 'line-height: '.intval($mkd_options['blog_masonry_title_lineheight']).'px';
		}

		if(isset($mkd_options['blog_masonry_title_letterspacing']) && $mkd_options['blog_masonry_title_letterspacing'] !== '') {
			$blog_masonry_title_style[] = 'letter-spacing: '.intval($mkd_options['blog_masonry_title_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_masonry_title_fontweight']) && $mkd_options['blog_masonry_title_fontweight'] !== '') {
			$blog_masonry_title_style[] = 'font-weight: '.intval($mkd_options['blog_masonry_title_fontweight']);
		}

		if(isset($mkd_options['blog_masonry_title_fontstyle']) && $mkd_options['blog_masonry_title_fontstyle'] !== '') {
			$blog_masonry_title_style[] = 'font-style: '.$mkd_options['blog_masonry_title_fontstyle'];
		}

		if(isset($mkd_options['blog_masonry_title_texttransform']) && $mkd_options['blog_masonry_title_texttransform'] !== '') {
			$blog_masonry_title_style[] = 'text-transform: '.$mkd_options['blog_masonry_title_texttransform'];
		}

		if(is_array($blog_masonry_title_style) && count($blog_masonry_title_style)) { ?>
            .blog_holder.masonry article:not(.format-quote):not(.format-link) h4,
            .blog_holder.masonry_full_width article:not(.format-quote):not(.format-link) h4{
			<?php echo esc_attr(implode(';', $blog_masonry_title_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_masonry_title_color']) && !empty($mkd_options['blog_masonry_title_color'])){ ?>
            .blog_holder.masonry article:not(.format-quote):not(.format-link) h4 a,
            .blog_holder.masonry_full_width article:not(.format-quote):not(.format-link) h4 a,
            .blog_holder.masonry article:not(.format-quote):not(.format-link) h4,
            .blog_holder.masonry_full_width article:not(.format-quote):not(.format-link) h4{
            color: <?php echo esc_attr($mkd_options['blog_masonry_title_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_masonry_title_hover_color']) && !empty($mkd_options['blog_masonry_title_hover_color'])){ ?>
            .blog_holder.masonry article:not(.format-quote):not(.format-link) h4 a:hover,
            .blog_holder.masonry_full_width article:not(.format-quote):not(.format-link) h4 a:hover{
            color: <?php echo esc_attr($mkd_options['blog_masonry_title_hover_color']);  ?>;
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_masonry_title_date_color']) && !empty($mkd_options['blog_masonry_title_date_color'])){ ?>
            .blog_holder.masonry article:not(.format-quote):not(.format-link) h4 .date,
            .blog_holder.masonry_full_width article:not(.format-quote):not(.format-link) h4 .date{
            color: <?php echo esc_attr($mkd_options['blog_masonry_title_date_color']);  ?>;
            }
		<?php } ?>
		<?php
		/**************** BLOG MASONRY: Qoute/Link Title Style ****************/
		$blog_masonry_ql_title_style = array();

		if(isset($mkd_options['blog_masonry_ql_title_google_fonts']) && $mkd_options['blog_masonry_ql_title_google_fonts'] !== '-1') {
			$blog_masonry_ql_title_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_masonry_ql_title_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_masonry_ql_title_fontsize']) && $mkd_options['blog_masonry_ql_title_fontsize'] !== '') {
			$blog_masonry_ql_title_style[] = 'font-size: '.intval($mkd_options['blog_masonry_ql_title_fontsize']).'px';
		}

		if(isset($mkd_options['blog_masonry_ql_title_lineheight']) && $mkd_options['blog_masonry_ql_title_lineheight'] !== '') {
			$blog_masonry_ql_title_style[] = 'line-height: '.intval($mkd_options['blog_masonry_ql_title_lineheight']).'px';
		}

		if(isset($mkd_options['blog_masonry_ql_title_letterspacing']) && $mkd_options['blog_masonry_ql_title_letterspacing'] !== '') {
			$blog_masonry_ql_title_style[] = 'letter-spacing: '.intval($mkd_options['blog_masonry_ql_title_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_masonry_ql_title_fontweight']) && $mkd_options['blog_masonry_ql_title_fontweight'] !== '') {
			$blog_masonry_ql_title_style[] = 'font-weight: '.intval($mkd_options['blog_masonry_ql_title_fontweight']);
		}

		if(isset($mkd_options['blog_masonry_ql_title_fontstyle']) && $mkd_options['blog_masonry_ql_title_fontstyle'] !== '') {
			$blog_masonry_ql_title_style[] = 'font-style: '.$mkd_options['blog_masonry_ql_title_fontstyle'];
		}

		if(isset($mkd_options['blog_masonry_ql_title_texttransform']) && $mkd_options['blog_masonry_ql_title_texttransform'] !== '') {
			$blog_masonry_ql_title_style[] = 'text-transform: '.$mkd_options['blog_masonry_ql_title_texttransform'];
		}

		if(is_array($blog_masonry_ql_title_style) && count($blog_masonry_ql_title_style)) { ?>
            .blog_holder.masonry article.format-quote .post_text .post_title h3,
            .blog_holder.masonry article.format-link .post_text .post_title h3,
            .blog_holder.masonry article.format-quote .post_text .quote_author,
            .blog_holder.masonry_full_width article.format-quote .post_text .post_title h3,
            .blog_holder.masonry_full_width article.format-link .post_text .post_title h3,
            .blog_holder.masonry_full_width article.format-quote .post_text .quote_author{
			<?php echo esc_attr(implode(';', $blog_masonry_ql_title_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_masonry_ql_title_color']) && !empty($mkd_options['blog_masonry_ql_title_color'])){ ?>
            .blog_holder.masonry article.format-quote .post_text .post_title h3 a,
            .blog_holder.masonry article.format-quote .post_text .post_title h3,
            .blog_holder.masonry article.format-link .post_text .post_title h3 a,
            .blog_holder.masonry_full_width article.format-quote .post_text .post_title h3 a,
            .blog_holder.masonry_full_width article.format-quote .post_text .post_title h3,
            .blog_holder.masonry_full_width article.format-link .post_text .post_title h3 a{
            color: <?php echo esc_attr($mkd_options['blog_masonry_ql_title_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_masonry_ql_title_hover_color']) && !empty($mkd_options['blog_masonry_ql_title_hover_color'])){ ?>
            .blog_holder.masonry article.format-quote .post_text .post_text_inner:hover .post_title h3 a,
            .blog_holder.masonry article.format-quote .post_text .post_text_inner:hover .post_title h3,
            .blog_holder.masonry article.format-link .post_text .post_text_inner:hover .post_title h3 a,
            .blog_holder.masonry_full_width article.format-quote .post_text .post_text_inner:hover .post_title h3 a,
            .blog_holder.masonry_full_width article.format-quote .post_text .post_text_inner:hover .post_title h3,
            .blog_holder.masonry_full_width article.format-link .post_text .post_text_inner:hover .post_title h3 a{
            color: <?php echo esc_attr($mkd_options['blog_masonry_ql_title_hover_color']);  ?>;
            }
		<?php } ?>
		<?php
		/**************** BLOG MASONRY: Qoute/Link Author Style ****************/
		$blog_masonry_ql_author_style = array();

		if(isset($mkd_options['blog_masonry_ql_author_google_fonts']) && $mkd_options['blog_masonry_ql_author_google_fonts'] !== '-1') {
			$blog_masonry_ql_author_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_masonry_ql_author_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_masonry_ql_author_fontsize']) && $mkd_options['blog_masonry_ql_author_fontsize'] !== '') {
			$blog_masonry_ql_author_style[] = 'font-size: '.intval($mkd_options['blog_masonry_ql_author_fontsize']).'px';
		}

		if(isset($mkd_options['blog_masonry_ql_author_lineheight']) && $mkd_options['blog_masonry_ql_author_lineheight'] !== '') {
			$blog_masonry_ql_author_style[] = 'line-height: '.intval($mkd_options['blog_masonry_ql_author_lineheight']).'px';
		}

		if(isset($mkd_options['blog_masonry_ql_author_letterspacing']) && $mkd_options['blog_masonry_ql_author_letterspacing'] !== '') {
			$blog_masonry_ql_author_style[] = 'letter-spacing: '.intval($mkd_options['blog_masonry_ql_author_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_masonry_ql_author_fontweight']) && $mkd_options['blog_masonry_ql_author_fontweight'] !== '') {
			$blog_masonry_ql_author_style[] = 'font-weight: '.intval($mkd_options['blog_masonry_ql_author_fontweight']);
		}

		if(isset($mkd_options['blog_masonry_ql_author_fontstyle']) && $mkd_options['blog_masonry_ql_author_fontstyle'] !== '') {
			$blog_masonry_ql_author_style[] = 'font-style: '.$mkd_options['blog_masonry_ql_author_fontstyle'];
		}

		if(isset($mkd_options['blog_masonry_ql_author_texttransform']) && $mkd_options['blog_masonry_ql_author_texttransform'] !== '') {
			$blog_masonry_ql_author_style[] = 'text-transform: '.$mkd_options['blog_masonry_ql_author_texttransform'];
		}

		if(is_array($blog_masonry_ql_author_style) && count($blog_masonry_ql_author_style)) { ?>
            .blog_holder.masonry article.format-quote .post_text .quote_author,
            .blog_holder.masonry_full_width article.format-quote .post_text .quote_author{
			<?php echo esc_attr(implode(';', $blog_masonry_ql_author_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_masonry_ql_author_color']) && !empty($mkd_options['blog_masonry_ql_author_color'])){ ?>
            .blog_holder.masonry article.format-quote .post_text .quote_author,
            .blog_holder.masonry_full_width article.format-quote .post_text .quote_author{
            color: <?php echo esc_attr($mkd_options['blog_masonry_ql_author_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_masonry_ql_author_hover_color']) && !empty($mkd_options['blog_masonry_ql_author_hover_color'])){ ?>
            .blog_holder.masonry article.format-quote .post_text .post_text_inner:hover .quote_author,
            .blog_holder.masonry_full_width article.format-quote .post_text .post_text_inner:hover .quote_author{
            color: <?php echo esc_attr($mkd_options['blog_masonry_ql_author_hover_color']);  ?>;
            }
		<?php } ?>

		<?php
		/**************** BLOG MASONRY: Info Style ****************/
		$blog_masonry_info_style = array();

		if(isset($mkd_options['blog_masonry_info_google_fonts']) && $mkd_options['blog_masonry_info_google_fonts'] !== '-1') {
			$blog_masonry_info_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_masonry_info_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_masonry_info_fontsize']) && $mkd_options['blog_masonry_info_fontsize'] !== '') {
			$blog_masonry_info_style[] = 'font-size: '.intval($mkd_options['blog_masonry_info_fontsize']).'px';
		}

		if(isset($mkd_options['blog_masonry_info_lineheight']) && $mkd_options['blog_masonry_info_lineheight'] !== '') {
			$blog_masonry_info_style[] = 'line-height: '.intval($mkd_options['blog_masonry_info_lineheight']).'px';
		}

		if(isset($mkd_options['blog_masonry_info_letterspacing']) && $mkd_options['blog_masonry_info_letterspacing'] !== '') {
			$blog_masonry_info_style[] = 'letter-spacing: '.intval($mkd_options['blog_masonry_info_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_masonry_info_fontweight']) && $mkd_options['blog_masonry_info_fontweight'] !== '') {
			$blog_masonry_info_style[] = 'font-weight: '.intval($mkd_options['blog_masonry_info_fontweight']);
		}

		if(isset($mkd_options['blog_masonry_info_fontstyle']) && $mkd_options['blog_masonry_info_fontstyle'] !== '') {
			$blog_masonry_info_style[] = 'font-style: '.$mkd_options['blog_masonry_info_fontstyle'];
		}

		if(isset($mkd_options['blog_masonry_info_texttransform']) && $mkd_options['blog_masonry_info_texttransform'] !== '') {
			$blog_masonry_info_style[] = 'text-transform: '.$mkd_options['blog_masonry_info_texttransform'];
		}

		if(is_array($blog_masonry_info_style) && count($blog_masonry_info_style)) { ?>

            .blog_holder.masonry article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info div,
            .blog_holder.masonry_full_width article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info div{
			<?php echo esc_attr(implode(';', $blog_masonry_info_style)); ?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['blog_masonry_info_margin']) && $mkd_options['blog_masonry_info_margin'] !== '') {?>
            .blog_holder.masonry article .post_text .post_text_inner .post_info,
            .blog_holder.masonry_full_width article .post_text .post_text_inner .post_info{
            margin: <?php echo esc_attr($mkd_options['blog_masonry_info_margin']); ?>;
            }
		<?php } ?>
		<?php
		if(isset($mkd_options['blog_masonry_info_border_color']) && $mkd_options['blog_masonry_info_border_color'] !== '') {?>
            .blog_holder.masonry article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info,
            .blog_holder.masonry_full_width article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info{
            border-color: <?php echo esc_attr($mkd_options['blog_masonry_info_border_color']);  ?>;
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_masonry_info_color']) && !empty($mkd_options['blog_masonry_info_color'])){ ?>
            .blog_holder.masonry article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info,
            .blog_holder.masonry_full_width article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info{
            color: <?php echo esc_attr($mkd_options['blog_masonry_info_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_masonry_info_link_color']) && !empty($mkd_options['blog_masonry_info_link_color'])){ ?>
            .blog_holder.masonry article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info div a,
            .blog_holder.masonry_full_width article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info div a
            {
            color: <?php echo esc_attr($mkd_options['blog_masonry_info_link_color']);  ?>;
            }
		<?php } ?>


		<?php if(isset($mkd_options['blog_masonry_info_hover_color']) && !empty($mkd_options['blog_masonry_info_hover_color'])){ ?>
            .blog_holder.masonry article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info div a:hover,
            .blog_holder.masonry_full_width article:not(.format-quote):not(.format-link) .post_text .post_text_inner .post_info div a:hover{
            color: <?php echo esc_attr($mkd_options['blog_masonry_info_hover_color']);  ?>;
            }

		<?php } ?>


		<?php
		/****************  BLOG MASONRY: Quote/Link Post Info Style *********************/
		$blog_masonry_ql_info_style = array();

		if(isset($mkd_options['blog_masonry_ql_info_google_fonts']) && $mkd_options['blog_masonry_ql_info_google_fonts'] !== '-1') {
			$blog_masonry_ql_info_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_masonry_ql_info_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['blog_masonry_ql_info_fontsize']) && $mkd_options['blog_masonry_ql_info_fontsize'] !== '') {
			$blog_masonry_ql_info_style[] = 'font-size: '.intval($mkd_options['blog_masonry_ql_info_fontsize']).'px';
		}

		if(isset($mkd_options['blog_masonry_ql_info_lineheight']) && $mkd_options['blog_masonry_ql_info_lineheight'] !== '') {
			$blog_masonry_ql_info_style[] = 'line-height: '.intval($mkd_options['blog_masonry_ql_info_lineheight']).'px';
		}

		if(isset($mkd_options['blog_masonry_ql_info_letterspacing']) && $mkd_options['blog_masonry_ql_info_letterspacing'] !== '') {
			$blog_masonry_ql_info_style[] = 'letter-spacing: '.intval($mkd_options['blog_masonry_ql_info_letterspacing']).'px';
		}

		if(isset($mkd_options['blog_masonry_ql_info_fontweight']) && $mkd_options['blog_masonry_ql_info_fontweight'] !== '') {
			$blog_masonry_ql_info_style[] = 'font-weight: '.intval($mkd_options['blog_masonry_ql_info_fontweight']);
		}

		if(isset($mkd_options['blog_masonry_ql_info_fontstyle']) && $mkd_options['blog_masonry_ql_info_fontstyle'] !== '') {
			$blog_masonry_ql_info_style[] = 'font-style: '.$mkd_options['blog_masonry_ql_info_fontstyle'];
		}

		if(isset($mkd_options['blog_masonry_ql_info_texttransform']) && $mkd_options['blog_masonry_ql_info_texttransform'] !== '') {
			$blog_masonry_ql_info_style[] = 'text-transform: '.$mkd_options['blog_masonry_ql_info_texttransform'];
		}
		if(is_array($blog_masonry_ql_info_style) && count($blog_masonry_ql_info_style)) { ?>
            .blog_holder.masonry article.format-quote .post_text .post_text_inner .post_info ,
            .blog_holder.masonry article.format-link .post_text .post_text_inner .post_info ,
            .blog_holder.masonry_full_width article.format-quote .post_text .post_text_inner .post_info ,
            .blog_holder.masonry_full_width article.format-link .post_text .post_text_inner .post_info {
			<?php echo esc_attr(implode(';', $blog_masonry_ql_info_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_masonry_ql_info_color']) && !empty($mkd_options['blog_masonry_ql_info_color'])){ ?>
            .blog_holder.masonry article.format-quote .post_text .post_text_inner .post_info,
            .blog_holder.masonry article.format-link .post_text .post_text_inner .post_info,
            .blog_holder.masonry_full_width article.format-quote .post_text .post_text_inner .post_info,
            .blog_holder.masonry_full_width article.format-link .post_text .post_text_inner .post_info{
            color: <?php echo esc_attr($mkd_options['blog_masonry_ql_info_color']);  ?>;
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_masonry_ql_info_link_color']) && !empty($mkd_options['blog_masonry_ql_info_link_color'])){ ?>
            .blog_holder.masonry article.format-quote .post_text .post_text_inner .post_info a,
            .blog_holder.masonry article.format-link .post_text .post_text_inner .post_info a,
            .blog_holder.masonry_full_width article.format-quote .post_text .post_text_inner .post_info a,
            .blog_holder.masonry_full_width article.format-link .post_text .post_text_inner .post_info a{
            color: <?php echo esc_attr($mkd_options['blog_masonry_ql_info_link_color']);  ?>;
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_masonry_ql_info_hover_color']) && !empty($mkd_options['blog_masonry_ql_info_hover_color'])){ ?>
            .blog_holder.masonry article.format-quote .post_text .post_text_inner:hover .post_info,
            .blog_holder.masonry article.format-link .post_text .post_text_inner:hover .post_info,
            .blog_holder.masonry article.format-quote .post_text .post_text_inner:hover .post_info div a,
            .blog_holder.masonry article.format-link .post_text .post_text_inner:hover .post_info div a,
            .blog_holder.masonry_full_width article.format-quote .post_text .post_text_inner:hover .post_info,
            .blog_holder.masonry_full_width article.format-link .post_text .post_text_inner:hover .post_info,
            .blog_holder.masonry_full_width article.format-quote .post_text .post_text_inner:hover .post_info div a,
            .blog_holder.masonry_full_width article.format-link .post_text .post_text_inner:hover .post_info div a
            {
            color: <?php echo esc_attr($mkd_options['blog_masonry_ql_info_hover_color']);  ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_masonry_ql_mark_color']) && !empty($mkd_options['blog_masonry_ql_mark_color'])){ ?>
            .blog_holder.masonry article.format-quote .post_text .post_text_inner .quote_mark,
            .blog_holder.masonry article.format-link .post_text .post_text_inner .link_mark,
            .blog_holder.masonry_full_width article.format-quote .post_text .post_text_inner .quote_mark,
            .blog_holder.masonry_full_width article.format-link .post_text .post_text_inner .link_mark{
            color: <?php echo esc_attr($mkd_options['blog_masonry_ql_mark_color']);  ?>;
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_masonry_ql_mark_background_color']) && !empty($mkd_options['blog_masonry_ql_mark_background_color'])){ ?>
            .blog_holder.masonry article.format-quote .post_text .post_text_inner .quote_mark,
            .blog_holder.masonry article.format-link .post_text .post_text_inner .link_mark,
            .blog_holder.masonry_full_width article.format-quote .post_text .post_text_inner .quote_mark,
            .blog_holder.masonry_full_width article.format-link .post_text .post_text_inner .link_mark,
            {
            background-color: <?php echo esc_attr($mkd_options['blog_masonry_ql_mark_background_color']);  ?>;
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_masonry_ql_mark_hover_color']) && !empty($mkd_options['blog_masonry_ql_mark_hover_color'])){ ?>
            .blog_holder.masonry article.format-quote .post_text .post_text_inner:hover .quote_mark,
            .blog_holder.masonry article.format-link .post_text .post_text_inner:hover .link_mark,
            .blog_holder.masonry_full_width article.format-quote .post_text .post_text_inner:hover .quote_mark,
            .blog_holder.masonry_full_width article.format-link .post_text .post_text_inner:hover .link_mark{
            color: <?php echo esc_attr($mkd_options['blog_masonry_ql_mark_hover_color']);  ?>;
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_masonry_ql_info_border_color']) && !empty($mkd_options['blog_masonry_ql_info_border_color'])){ ?>
            .blog_holder.masonry article.format-quote .post_text .post_info,
            .blog_holder.masonry article.format-link .post_text .post_info,
            .blog_holder.masonry_full_width article.format-quote .post_text .post_text_inner .post_info,
            .blog_holder.masonry_full_width article.format-link .post_text .post_text_inner .post_info{
            border-color: <?php echo esc_attr($mkd_options['blog_masonry_ql_info_border_color']);  ?>;
            }
		<?php } ?>
		<?php if(isset($mkd_options['blog_masonry_ql_info_border_hover_color']) && !empty($mkd_options['blog_masonry_ql_info_border_hover_color'])){ ?>
            .blog_holder.masonry article.format-quote .post_text .post_text_inner:hover .post_info,
            .blog_holder.masonry article.format-link .post_text .post_text_inner:hover .post_info,
            .blog_holder.masonry_full_width article.format-quote .post_text .post_text_inner:hover .post_info,
            .blog_holder.masonry_full_width article.format-link .post_text .post_text_inner:hover .post_info{
            border-color: <?php echo esc_attr($mkd_options['blog_masonry_ql_info_border_hover_color']);  ?>;
            }
		<?php } ?>



		<?php

		$blog_masonry_author_style = array();

		if(isset($mkd_options['blog_masonry_author_font_family']) && $mkd_options['blog_masonry_author_font_family'] !== '-1') {
			$blog_masonry_author_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['blog_masonry_author_font_family']).', sans-serif';
		}

		if(isset($mkd_options['blog_masonry_author_font_size']) && $mkd_options['blog_masonry_author_font_size'] !== '') {
			$blog_masonry_author_style[] = 'font-size: '.intval($mkd_options['blog_masonry_author_font_size']).'px';
		}

		if(isset($mkd_options['blog_masonry_author_line_height']) && $mkd_options['blog_masonry_author_line_height'] !== '') {
			$blog_masonry_author_style[] = 'line-height: '.intval($mkd_options['blog_masonry_author_line_height']).'px';
		}

		if(isset($mkd_options['blog_masonry_author_letter_spacing']) && $mkd_options['blog_masonry_author_letter_spacing'] !== '') {
			$blog_masonry_author_style[] = 'letter-spacing: '.intval($mkd_options['blog_masonry_author_letter_spacing']).'px';
		}

		if(isset($mkd_options['blog_masonry_author_font_weight']) && $mkd_options['blog_masonry_author_font_weight'] !== '') {
			$blog_masonry_author_style[] = 'font-weight: '.intval($mkd_options['blog_masonry_author_font_weight']);
		}

		if(isset($mkd_options['blog_masonry_author_font_style']) && $mkd_options['blog_masonry_author_font_style'] !== '') {
			$blog_masonry_author_style[] = 'font-style: '.$mkd_options['blog_masonry_author_font_style'];
		}

		if(isset($mkd_options['blog_masonry_author_text_transform']) && $mkd_options['blog_masonry_author_text_transform'] !== '') {
			$blog_masonry_author_style[] = 'text-transform: '.$mkd_options['blog_masonry_author_text_transform'];
		}

		if(isset($mkd_options['blog_masonry_author_color']) && $mkd_options['blog_masonry_author_color'] !== '') {
			$blog_masonry_author_style[] = 'color: '.$mkd_options['blog_masonry_author_color'];
		}

		if(is_array($blog_masonry_author_style) && count($blog_masonry_author_style)) { ?>
            .blog_holder.masonry .post_author,
            .blog_holder.masonry .post_author a,
            .blog_holder.masonry_full_width .post_author,
            .blog_holder.masonry_full_width .post_author a,
            .latest_post_holder .post_author, .latest_post_holder a.post_author_link{
			<?php echo esc_attr(implode(';', $blog_masonry_author_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['blog_masonry_author_hover_color']) && !empty($mkd_options['blog_masonry_author_hover_color'])){ ?>
            .blog_holder.masonry .post_author:hover,
            .blog_holder.masonry .post_author a:hover,
            .blog_holder.masonry_full_width .post_author:hover,
            .blog_holder.masonry_full_width .post_author a:hover,
            .latest_post_holder .post_author a.post_author_link:hover{
            color: <?php echo esc_attr($mkd_options['blog_masonry_author_hover_color']);  ?>;
            }
		<?php } ?>

		<?php
		$contact_form_heading_style = array();

		if(isset($mkd_options['contact_form_heading_google_fonts']) && $mkd_options['contact_form_heading_google_fonts'] !== '-1') {
			$contact_form_heading_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['contact_form_heading_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['contact_form_heading_fontsize']) && $mkd_options['contact_form_heading_fontsize'] !== '') {
			$contact_form_heading_style[] = 'font-size: '.intval($mkd_options['contact_form_heading_fontsize']).'px';
		}

		if(isset($mkd_options['contact_form_heading_lineheight']) && $mkd_options['contact_form_heading_lineheight'] !== '') {
			$contact_form_heading_style[] = 'line-height: '.intval($mkd_options['contact_form_heading_lineheight']).'px';
		}

		if(isset($mkd_options['contact_form_heading_letter_spacing']) && $mkd_options['contact_form_heading_letter_spacing'] !== '') {
			$contact_form_heading_style[] = 'letter-spacing: '.intval($mkd_options['contact_form_heading_letter_spacing']).'px';
		}

		if(isset($mkd_options['contact_form_heading_fontweight']) && $mkd_options['contact_form_heading_fontweight'] !== '') {
			$contact_form_heading_style[] = 'font-weight: '.intval($mkd_options['contact_form_heading_fontweight']);
		}

		if(isset($mkd_options['contact_form_heading_fontstyle']) && $mkd_options['contact_form_heading_fontstyle'] !== '') {
			$contact_form_heading_style[] = 'font-style: '.$mkd_options['contact_form_heading_fontstyle'];
		}

		if(isset($mkd_options['contact_form_heading_texttransform']) && $mkd_options['contact_form_heading_texttransform'] !== '') {
			$contact_form_heading_style[] = 'text-transform: '.$mkd_options['contact_form_heading_texttransform'];
		}

		if(isset($mkd_options['contact_form_heading_color']) && $mkd_options['contact_form_heading_color'] !== '') {
			$contact_form_heading_style[] = 'color: '.$mkd_options['contact_form_heading_color'];
		}

		if(is_array($contact_form_heading_style) && count($contact_form_heading_style)) { ?>
            .contact_form h5{
			<?php echo esc_attr(implode(';', $contact_form_heading_style)); ?>
            }
		<?php } ?>

		<?php
		$contact_form_section_title_style = array();

		if(isset($mkd_options['contact_form_section_title_google_fonts']) && $mkd_options['contact_form_section_title_google_fonts'] !== '-1') {
			$contact_form_section_title_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['contact_form_section_title_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['contact_form_section_title_fontsize']) && $mkd_options['contact_form_section_title_fontsize'] !== '') {
			$contact_form_section_title_style[] = 'font-size: '.intval($mkd_options['contact_form_section_title_fontsize']).'px';
		}

		if(isset($mkd_options['contact_form_section_title_lineheight']) && $mkd_options['contact_form_section_title_lineheight'] !== '') {
			$contact_form_section_title_style[] = 'line-height: '.intval($mkd_options['contact_form_section_title_lineheight']).'px';
		}

		if(isset($mkd_options['contact_form_section_title_letter_spacing']) && $mkd_options['contact_form_section_title_letter_spacing'] !== '') {
			$contact_form_section_title_style[] = 'letter-spacing: '.intval($mkd_options['contact_form_section_title_letter_spacing']).'px';
		}

		if(isset($mkd_options['contact_form_section_title_fontweight']) && $mkd_options['contact_form_section_title_fontweight'] !== '') {
			$contact_form_section_title_style[] = 'font-weight: '.intval($mkd_options['contact_form_section_title_fontweight']);
		}

		if(isset($mkd_options['contact_form_section_title_fontstyle']) && $mkd_options['contact_form_section_title_fontstyle'] !== '') {
			$contact_form_section_title_style[] = 'font-style: '.$mkd_options['contact_form_section_title_fontstyle'];
		}

		if(isset($mkd_options['contact_form_section_title_texttransform']) && $mkd_options['contact_form_section_title_texttransform'] !== '') {
			$contact_form_section_title_style[] = 'text-transform: '.$mkd_options['contact_form_section_title_texttransform'];
		}

		if(isset($mkd_options['contact_form_section_title_color']) && $mkd_options['contact_form_section_title_color'] !== '') {
			$contact_form_section_title_style[] = 'color: '.$mkd_options['contact_form_section_title_color'];
		}

		if(is_array($contact_form_section_title_style) && count($contact_form_section_title_style)) { ?>
            .contact_section h2{
			<?php echo esc_attr(implode(';', $contact_form_section_title_style)); ?>
            }
		<?php } ?>

		<?php
		$contact_form_section_subtitle_style = array();

		if(isset($mkd_options['contact_form_section_subtitle_google_fonts']) && $mkd_options['contact_form_section_subtitle_google_fonts'] !== '-1') {
			$contact_form_section_subtitle_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['contact_form_section_subtitle_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['contact_form_section_subtitle_fontsize']) && $mkd_options['contact_form_section_subtitle_fontsize'] !== '') {
			$contact_form_section_subtitle_style[] = 'font-size: '.intval($mkd_options['contact_form_section_subtitle_fontsize']).'px';
		}

		if(isset($mkd_options['contact_form_section_subtitle_lineheight']) && $mkd_options['contact_form_section_subtitle_lineheight'] !== '') {
			$contact_form_section_subtitle_style[] = 'line-height: '.intval($mkd_options['contact_form_section_subtitle_lineheight']).'px';
		}

		if(isset($mkd_options['contact_form_section_subtitle_letter_spacing']) && $mkd_options['contact_form_section_subtitle_letter_spacing'] !== '') {
			$contact_form_section_subtitle_style[] = 'letter-spacing: '.intval($mkd_options['contact_form_section_subtitle_letter_spacing']).'px';
		}

		if(isset($mkd_options['contact_form_section_subtitle_fontweight']) && $mkd_options['contact_form_section_subtitle_fontweight'] !== '') {
			$contact_form_section_subtitle_style[] = 'font-weight: '.intval($mkd_options['contact_form_section_subtitle_font_weight']);
		}

		if(isset($mkd_options['contact_form_section_subtitle_fontstyle']) && $mkd_options['contact_form_section_subtitle_fontstyle'] !== '') {
			$contact_form_section_subtitle_style[] = 'font-style: '.$mkd_options['contact_form_section_subtitle_font_style'];
		}

		if(isset($mkd_options['contact_form_section_subtitle_texttransform']) && $mkd_options['contact_form_section_subtitle_texttransform'] !== '') {
			$contact_form_section_subtitle_style[] = 'text-transform: '.$mkd_options['contact_form_section_subtitle_text_transform'];
		}

		if(isset($mkd_options['contact_form_section_subtitle_color']) && $mkd_options['contact_form_section_subtitle_color'] !== '') {
			$contact_form_section_subtitle_style[] = 'color: '.$mkd_options['contact_form_section_subtitle_color'];
		}

		if(is_array($contact_form_section_subtitle_style) && count($contact_form_section_subtitle_style)) { ?>
            .contact_section h4{
			<?php echo esc_attr(implode(';', $contact_form_section_subtitle_style)); ?>
            }
		<?php } ?>

		<?php if (!empty($mkd_options['service_table_background_color'])) { ?>
            .service_table_inner{
			<?php if (!empty($mkd_options['service_table_background_color'])) { ?> background-color: <?php echo esc_attr($mkd_options['service_table_background_color']);  ?>; <?php } ?>
            }
		<?php } ?>

		<?php if (!empty($mkd_options['service_table_separator_color']) || (isset($mkd_options['service_table_separator_thickness']) && $mkd_options['service_table_separator_thickness'] !== '')) { ?>
            .service_table_inner li{
			<?php if (!empty($mkd_options['service_table_separator_color'])) { ?>  border-color: <?php echo esc_attr($mkd_options['service_table_separator_color']);  ?>; <?php } ?>
			<?php if(isset($mkd_options['service_table_separator_thickness']) && $mkd_options['service_table_separator_thickness'] !== ''){?> border-width: <?php echo esc_attr($mkd_options['service_table_separator_thickness']); ?>px; <?php } ?>
            }
		<?php } ?>

		<?php if (!empty($mkd_options['service_table_title_background_color']) || !empty($mkd_options['service_table_title_separator_color']) || (isset($mkd_options['service_table_title_separator_thickness']) && $mkd_options['service_table_title_separator_thickness'] !== '')) { ?>
            .service_table_inner li.service_table_title_holder{
			<?php if (!empty($mkd_options['service_table_title_separator_color'])) { ?>  border-color: <?php echo esc_attr($mkd_options['service_table_title_separator_color']);  ?>; <?php } ?>
			<?php if (isset($mkd_options['service_table_title_separator_thickness']) && $mkd_options['service_table_title_separator_thickness'] !== ''){ ?> border-width: <?php echo esc_attr($mkd_options['service_table_title_separator_thickness']); ?>px; <?php }?>
			<?php if (!empty($mkd_options['service_table_title_background_color'])) { ?> background-color: <?php echo esc_attr($mkd_options['service_table_title_background_color']);  ?>; <?php } ?>
            }
		<?php } ?>

		<?php if (!empty($mkd_options['service_table_title_separator_color']) ||  (isset($mkd_options['service_table_title_separator_thickness']) && $mkd_options['service_table_title_separator_thickness'] !== '')) { ?>
            .service_table_inner li.service_table_title_holder .title_separator{
			<?php if (!empty($mkd_options['service_table_title_separator_color'])) { ?>  background-color: <?php echo esc_attr($mkd_options['service_table_title_separator_color']);  ?>; <?php } ?>
			<?php if(isset($mkd_options['service_table_title_separator_thickness']) && $mkd_options['service_table_title_separator_thickness'] !== ''){?> height: <?php echo esc_attr($mkd_options['service_table_title_separator_thickness']); ?>px; <?php }?>
            }
		<?php } ?>


		<?php
		$service_tables_active_text_styles = array();

		if(isset($mkd_options['service_tables_active_text_font_family']) && $mkd_options['service_tables_active_text_font_family'] !== '-1') {
			$service_tables_active_text_styles[] = 'font-family: '.str_replace('+', ' ', $mkd_options['service_tables_active_text_font_family']).', sans-serif';
		}

		if(isset($mkd_options['service_tables_active_text_font_size']) && $mkd_options['service_tables_active_text_font_size'] !== '') {
			$service_tables_active_text_styles[] = 'font-size: '.intval($mkd_options['service_tables_active_text_font_size']).'px';
		}

		if(isset($mkd_options['service_tables_active_text_line_height']) && $mkd_options['service_tables_active_text_line_height'] !== '') {
			$service_tables_active_text_styles[] = 'line-height: '.intval($mkd_options['service_tables_active_text_line_height']).'px';
		}

		if(isset($mkd_options['service_tables_active_text_letter_spacing']) && $mkd_options['service_tables_active_text_letter_spacing'] !== '') {
			$service_tables_active_text_styles[] = 'letter-spacing: '.intval($mkd_options['service_tables_active_text_letter_spacing']).'px';
		}

		if(isset($mkd_options['service_tables_active_text_font_weight']) && $mkd_options['service_tables_active_text_font_weight'] !== '') {
			$service_tables_active_text_styles[] = 'font-weight: '.intval($mkd_options['service_tables_active_text_font_weight']);
		}

		if(isset($mkd_options['service_tables_active_text_font_style']) && $mkd_options['service_tables_active_text_font_style'] !== '') {
			$service_tables_active_text_styles[] = 'font-style: '.$mkd_options['service_tables_active_text_font_style'];
		}

		if(isset($mkd_options['service_tables_active_text_text_transform']) && $mkd_options['service_tables_active_text_text_transform'] !== '') {
			$service_tables_active_text_styles[] = 'text-transform: '.$mkd_options['service_tables_active_text_text_transform'];
		}

		if(isset($mkd_options['service_tables_active_text_color']) && $mkd_options['service_tables_active_text_color'] !== '') {
			$service_tables_active_text_styles[] = 'color: '.$mkd_options['service_tables_active_text_color'];
		}

		if(is_array($service_tables_active_text_styles) && count($service_tables_active_text_styles)) { ?>
            .service_table_holder.active .active_text{
			<?php echo esc_attr(implode(';', $service_tables_active_text_styles)); ?>
            }
		<?php } ?>




		<?php
		$service_tables_title_styles = array();

		if(isset($mkd_options['service_tables_title_font_family']) && $mkd_options['service_tables_title_font_family'] !== '-1') {
			$service_tables_title_styles[] = 'font-family: '.str_replace('+', ' ', $mkd_options['service_tables_title_font_family']).', sans-serif';
		}

		if(isset($mkd_options['service_tables_title_font_size']) && $mkd_options['service_tables_title_font_size'] !== '') {
			$service_tables_title_styles[] = 'font-size: '.intval($mkd_options['service_tables_title_font_size']).'px';
		}

		if(isset($mkd_options['service_tables_title_line_height']) && $mkd_options['service_tables_title_line_height'] !== '') {
			$service_tables_title_styles[] = 'line-height: '.intval($mkd_options['service_tables_title_line_height']).'px';
		}

		if(isset($mkd_options['service_tables_title_letter_spacing']) && $mkd_options['service_tables_title_letter_spacing'] !== '') {
			$service_tables_title_styles[] = 'letter-spacing: '.intval($mkd_options['service_tables_title_letter_spacing']).'px';
		}

		if(isset($mkd_options['service_tables_title_font_weight']) && $mkd_options['service_tables_title_font_weight'] !== '') {
			$service_tables_title_styles[] = 'font-weight: '.intval($mkd_options['service_tables_title_font_weight']);
		}

		if(isset($mkd_options['service_tables_title_font_style']) && $mkd_options['service_tables_title_font_style'] !== '') {
			$service_tables_title_styles[] = 'font-style: '.$mkd_options['service_tables_title_font_style'];
		}

		if(isset($mkd_options['service_tables_title_text_transform']) && $mkd_options['service_tables_title_text_transform'] !== '') {
			$service_tables_title_styles[] = 'text-transform: '.$mkd_options['service_tables_title_text_transform'];
		}

		if(isset($mkd_options['service_tables_title_color']) && $mkd_options['service_tables_title_color'] !== '') {
			$service_tables_title_styles[] = 'color: '.$mkd_options['service_tables_title_color'];
		}

		if(is_array($service_tables_title_styles) && count($service_tables_title_styles)) { ?>
            .service_table_title_holder .service_title{
			<?php echo esc_attr(implode(';', $service_tables_title_styles)); ?>
            }
		<?php } ?>



		<?php
		$service_tables_content_styles = array();

		if(isset($mkd_options['service_tables_content_font_family']) && $mkd_options['service_tables_content_font_family'] !== '-1') {
			$service_tables_content_styles[] = 'font-family: '.str_replace('+', ' ', $mkd_options['service_tables_content_font_family']).', sans-serif';
		}

		if(isset($mkd_options['service_tables_content_font_size']) && $mkd_options['service_tables_content_font_size'] !== '') {
			$service_tables_content_styles[] = 'font-size: '.intval($mkd_options['service_tables_content_font_size']).'px';
		}

		if(isset($mkd_options['service_tables_content_line_height']) && $mkd_options['service_tables_content_line_height'] !== '') {
			$service_tables_content_styles[] = 'line-height: '.intval($mkd_options['service_tables_content_line_height']).'px';
		}

		if(isset($mkd_options['service_tables_content_letter_spacing']) && $mkd_options['service_tables_content_letter_spacing'] !== '') {
			$service_tables_content_styles[] = 'letter-spacing: '.intval($mkd_options['service_tables_content_letter_spacing']).'px';
		}

		if(isset($mkd_options['service_tables_content_font_weight']) && $mkd_options['service_tables_content_font_weight'] !== '') {
			$service_tables_content_styles[] = 'font-weight: '.intval($mkd_options['service_tables_content_font_weight']);
		}

		if(isset($mkd_options['service_tables_content_font_style']) && $mkd_options['service_tables_content_font_style'] !== '') {
			$service_tables_content_styles[] = 'font-style: '.$mkd_options['service_tables_content_font_style'];
		}

		if(isset($mkd_options['service_tables_content_text_transform']) && $mkd_options['service_tables_content_text_transform'] !== '') {
			$service_tables_content_styles[] = 'text-transform: '.$mkd_options['service_tables_content_text_transform'];
		}

		if(isset($mkd_options['service_tables_content_color']) && $mkd_options['service_tables_content_color'] !== '') {
			$service_tables_content_styles[] = 'color: '.$mkd_options['service_tables_content_color'];
		}

		if(is_array($service_tables_content_styles) && count($service_tables_content_styles)) { ?>
            .service_table_holder .service_table_content{
			<?php echo esc_attr(implode(';', $service_tables_content_styles)); ?>
            }
		<?php } ?>


		<?php if (!empty($mkd_options['pricing_table_background_color'])) { ?>
            .price_table_inner ul li.pricing_table_content{
			<?php if (!empty($mkd_options['pricing_table_background_color'])) { ?> background-color: <?php echo esc_attr($mkd_options['pricing_table_background_color']);  ?>; <?php } ?>
            }
		<?php } ?>

		<?php if (!empty($mkd_options['pricing_table_separator_color']) || (isset($mkd_options['pricing_table_separator_thickness']) && $mkd_options['pricing_table_separator_thickness'] !== '')) { ?>
            .price_table_inner ul li.pricing_table_content ul li{
			<?php if (!empty($mkd_options['pricing_table_separator_color'])) { ?>  border-color: <?php echo esc_attr($mkd_options['pricing_table_separator_color']);  ?>; <?php } ?>
			<?php if(isset($mkd_options['pricing_table_separator_thickness']) && $mkd_options['pricing_table_separator_thickness'] !== ''){?> border-width: <?php echo esc_attr($mkd_options['pricing_table_separator_thickness']); ?>px; <?php } ?>
            }
		<?php } ?>

		<?php if (!empty($mkd_options['pricing_table_title_background_color']) || !empty($mkd_options['pricing_table_title_separator_color']) || (isset($mkd_options['pricing_table_title_separator_thickness']) && $mkd_options['pricing_table_title_separator_thickness'] !== '')) { ?>
            .price_table_inner ul li.table_title{
			<?php if (!empty($mkd_options['pricing_table_title_separator_color'])) { ?>  border-color: <?php echo esc_attr($mkd_options['pricing_table_title_separator_color']);  ?>; <?php } ?>
			<?php if (isset($mkd_options['pricing_table_title_separator_thickness']) && $mkd_options['pricing_table_title_separator_thickness'] !== ''){ ?> border-width: <?php echo esc_attr($mkd_options['pricing_table_title_separator_thickness']); ?>px; <?php }?>
			<?php if (!empty($mkd_options['pricing_table_title_background_color'])) { ?> background-color: <?php echo esc_attr($mkd_options['pricing_table_title_background_color']);  ?>; <?php } ?>
            }
		<?php } ?>

		<?php if (!empty($mkd_options['pricing_table_title_separator_color']) ||  (isset($mkd_options['pricing_table_title_separator_thickness']) && $mkd_options['pricing_table_title_separator_thickness'] !== '')) { ?>
            .price_table_inner ul li.table_title .title_separator{
			<?php if (!empty($mkd_options['pricing_table_title_separator_color'])) { ?>  background-color: <?php echo esc_attr($mkd_options['pricing_table_title_separator_color']);  ?>; <?php } ?>
			<?php if(isset($mkd_options['pricing_table_title_separator_thickness']) && $mkd_options['pricing_table_title_separator_thickness'] !== ''){?> height: <?php echo esc_attr($mkd_options['pricing_table_title_separator_thickness']); ?>px; <?php }?>
            }
		<?php } ?>

		<?php if (!empty($mkd_options['pricing_table_price_background_color']) || !empty($mkd_options['pricing_table_price_separator_color']) || (isset($mkd_options['pricing_table_price_separator_thickness']) && $mkd_options['pricing_table_price_separator_thickness'] !== '')) { ?>
            .price_table_inner ul li.prices{
			<?php if (!empty($mkd_options['pricing_table_price_background_color'])) { ?> background-color: <?php echo esc_attr($mkd_options['pricing_table_price_background_color']);  ?>; <?php } ?>
			<?php if(!empty($mkd_options['pricing_table_price_separator_color'])){?> border-color: <?php echo esc_attr($mkd_options['pricing_table_price_separator_color']);  ?>;<?php }?>
			<?php if(isset($mkd_options['pricing_table_price_separator_thickness']) && $mkd_options['pricing_table_price_separator_thickness'] !== ''){?>  border-width: <?php echo esc_attr($mkd_options['pricing_table_price_separator_thickness']); ?>px; <?php }?>
            }
		<?php } ?>

		<?php
		$pricing_tables_active_text_styles = array();

		if(isset($mkd_options['pricing_tables_active_text_font_family']) && $mkd_options['pricing_tables_active_text_font_family'] !== '-1') {
			$pricing_tables_active_text_styles[] = 'font-family: '.str_replace('+', ' ', $mkd_options['pricing_tables_active_text_font_family']).', sans-serif';
		}

		if(isset($mkd_options['pricing_tables_active_text_font_size']) && $mkd_options['pricing_tables_active_text_font_size'] !== '') {
			$pricing_tables_active_text_styles[] = 'font-size: '.intval($mkd_options['pricing_tables_active_text_font_size']).'px';
		}

		if(isset($mkd_options['pricing_tables_active_text_line_height']) && $mkd_options['pricing_tables_active_text_line_height'] !== '') {
			$pricing_tables_active_text_styles[] = 'line-height: '.intval($mkd_options['pricing_tables_active_text_line_height']).'px';
		}

		if(isset($mkd_options['pricing_tables_active_text_letter_spacing']) && $mkd_options['pricing_tables_active_text_letter_spacing'] !== '') {
			$pricing_tables_active_text_styles[] = 'letter-spacing: '.intval($mkd_options['pricing_tables_active_text_letter_spacing']).'px';
		}

		if(isset($mkd_options['pricing_tables_active_text_font_weight']) && $mkd_options['pricing_tables_active_text_font_weight'] !== '') {
			$pricing_tables_active_text_styles[] = 'font-weight: '.intval($mkd_options['pricing_tables_active_text_font_weight']);
		}

		if(isset($mkd_options['pricing_tables_active_text_font_style']) && $mkd_options['pricing_tables_active_text_font_style'] !== '') {
			$pricing_tables_active_text_styles[] = 'font-style: '.$mkd_options['pricing_tables_active_text_font_style'];
		}

		if(isset($mkd_options['pricing_tables_active_text_text_transform']) && $mkd_options['pricing_tables_active_text_text_transform'] !== '') {
			$pricing_tables_active_text_styles[] = 'text-transform: '.$mkd_options['pricing_tables_active_text_text_transform'];
		}

		if(isset($mkd_options['pricing_tables_active_text_color']) && $mkd_options['pricing_tables_active_text_color'] !== '') {
			$pricing_tables_active_text_styles[] = 'color: '.$mkd_options['pricing_tables_active_text_color'];
		}

		if(is_array($pricing_tables_active_text_styles) && count($pricing_tables_active_text_styles)) { ?>
            .mkd_price_table.active .active_text span span{
			<?php echo esc_attr(implode(';', $pricing_tables_active_text_styles)); ?>
            }
		<?php } ?>

		<?php
		$pricing_tables_title_styles = array();

		if(isset($mkd_options['pricing_tables_title_font_family']) && $mkd_options['pricing_tables_title_font_family'] !== '-1') {
			$pricing_tables_title_styles[] = 'font-family: '.str_replace('+', ' ', $mkd_options['pricing_tables_title_font_family']).', sans-serif';
		}

		if(isset($mkd_options['pricing_tables_title_font_size']) && $mkd_options['pricing_tables_title_font_size'] !== '') {
			$pricing_tables_title_styles[] = 'font-size: '.intval($mkd_options['pricing_tables_title_font_size']).'px';
		}

		if(isset($mkd_options['pricing_tables_title_line_height']) && $mkd_options['pricing_tables_title_line_height'] !== '') {
			$pricing_tables_title_styles[] = 'line-height: '.intval($mkd_options['pricing_tables_title_line_height']).'px';
		}

		if(isset($mkd_options['pricing_tables_title_letter_spacing']) && $mkd_options['pricing_tables_title_letter_spacing'] !== '') {
			$pricing_tables_title_styles[] = 'letter-spacing: '.intval($mkd_options['pricing_tables_title_letter_spacing']).'px';
		}

		if(isset($mkd_options['pricing_tables_title_font_weight']) && $mkd_options['pricing_tables_title_font_weight'] !== '') {
			$pricing_tables_title_styles[] = 'font-weight: '.intval($mkd_options['pricing_tables_title_font_weight']);
		}

		if(isset($mkd_options['pricing_tables_title_font_style']) && $mkd_options['pricing_tables_title_font_style'] !== '') {
			$pricing_tables_title_styles[] = 'font-style: '.intval($mkd_options['pricing_tables_title_font_style']);
		}

		if(isset($mkd_options['pricing_tables_title_text_transform']) && $mkd_options['pricing_tables_title_text_transform'] !== '') {
			$pricing_tables_title_styles[] = 'text-transform: '.$mkd_options['pricing_tables_title_text_transform'];
		}

		if(isset($mkd_options['pricing_tables_title_color']) && $mkd_options['pricing_tables_title_color'] !== '') {
			$pricing_tables_title_styles[] = 'color: '.$mkd_options['pricing_tables_title_color'];
		}

		if(is_array($pricing_tables_title_styles) && count($pricing_tables_title_styles)) { ?>
            .price_table_inner ul li.table_title .title_content{
			<?php echo esc_attr(implode(';', $pricing_tables_title_styles)); ?>
            }
		<?php } ?>

		<?php
		$pricing_tables_period_styles = array();

		if(isset($mkd_options['pricing_tables_period_font_family']) && $mkd_options['pricing_tables_period_font_family'] !== '-1') {
			$pricing_tables_period_styles[] = 'font-family: '.str_replace('+', ' ', $mkd_options['pricing_tables_period_font_family']).', sans-serif';
		}

		if(isset($mkd_options['pricing_tables_period_font_size']) && $mkd_options['pricing_tables_period_font_size'] !== '') {
			$pricing_tables_period_styles[] = 'font-size: '.intval($mkd_options['pricing_tables_period_font_size']).'px';
		}

		if(isset($mkd_options['pricing_tables_period_line_height']) && $mkd_options['pricing_tables_period_line_height'] !== '') {
			$pricing_tables_period_styles[] = 'line-height: '.intval($mkd_options['pricing_tables_period_line_height']).'px';
		}

		if(isset($mkd_options['pricing_tables_period_letter_spacing']) && $mkd_options['pricing_tables_period_letter_spacing'] !== '') {
			$pricing_tables_period_styles[] = 'letter-spacing: '.intval($mkd_options['pricing_tables_period_letter_spacing']).'px';
		}

		if(isset($mkd_options['pricing_tables_period_font_weight']) && $mkd_options['pricing_tables_period_font_weight'] !== '') {
			$pricing_tables_period_styles[] = 'font-weight: '.intval($mkd_options['pricing_tables_period_font_weight']);
		}

		if(isset($mkd_options['pricing_tables_period_font_style']) && $mkd_options['pricing_tables_period_font_style'] !== '') {
			$pricing_tables_period_styles[] = 'font-style: '.$mkd_options['pricing_tables_period_font_style'];
		}

		if(isset($mkd_options['pricing_tables_period_text_transform']) && $mkd_options['pricing_tables_period_text_transform'] !== '') {
			$pricing_tables_period_styles[] = 'text-transform: '.$mkd_options['pricing_tables_period_text_transform'];
		}

		if(isset($mkd_options['pricing_tables_period_color']) && $mkd_options['pricing_tables_period_color'] !== '') {
			$pricing_tables_period_styles[] = 'color: '.$mkd_options['pricing_tables_period_color'];
		}

		if(is_array($pricing_tables_period_styles) && count($pricing_tables_period_styles)) { ?>
            .price_in_table .mark{
			<?php echo esc_attr(implode(';', $pricing_tables_period_styles)); ?>
            }
		<?php } ?>

		<?php
		$pricing_tables_price_styles = array();

		if(isset($mkd_options['pricing_tables_price_font_family']) && $mkd_options['pricing_tables_price_font_family'] !== '-1') {
			$pricing_tables_price_styles[] = 'font-family: '.str_replace('+', ' ', $mkd_options['pricing_tables_price_font_family']).', sans-serif';
		}

		if(isset($mkd_options['pricing_tables_price_font_size']) && $mkd_options['pricing_tables_price_font_size'] !== '') {
			$pricing_tables_price_styles[] = 'font-size: '.intval($mkd_options['pricing_tables_price_font_size']).'px';
		}

		if(isset($mkd_options['pricing_tables_price_line_height']) && $mkd_options['pricing_tables_price_line_height'] !== '') {
			$pricing_tables_price_styles[] = 'line-height: '.intval($mkd_options['pricing_tables_price_line_height']).'px';
		}

		if(isset($mkd_options['pricing_tables_price_letter_spacing']) && $mkd_options['pricing_tables_price_letter_spacing'] !== '') {
			$pricing_tables_price_styles[] = 'letter-spacing: '.intval($mkd_options['pricing_tables_price_letter_spacing']).'px';
		}

		if(isset($mkd_options['pricing_tables_price_font_weight']) && $mkd_options['pricing_tables_price_font_weight'] !== '') {
			$pricing_tables_price_styles[] = 'font-weight: '.intval($mkd_options['pricing_tables_price_font_weight']);
		}

		if(isset($mkd_options['pricing_tables_price_font_style']) && $mkd_options['pricing_tables_price_font_style'] !== '') {
			$pricing_tables_price_styles[] = 'font-style: '.$mkd_options['pricing_tables_price_font_style'];
		}

		if(isset($mkd_options['pricing_tables_price_text_transform']) && $mkd_options['pricing_tables_price_text_transform'] !== '') {
			$pricing_tables_price_styles[] = 'text-transform: '.$mkd_options['pricing_tables_price_text_transform'];
		}

		if(isset($mkd_options['pricing_tables_price_color']) && $mkd_options['pricing_tables_price_color'] !== '') {
			$pricing_tables_price_styles[] = 'color: '.$mkd_options['pricing_tables_price_color'];
		}

		if(is_array($pricing_tables_price_styles) && count($pricing_tables_price_styles)) { ?>
            .price_in_table .price{
			<?php echo esc_attr(implode(';', $pricing_tables_price_styles)); ?>
            }
		<?php } ?>

		<?php
		$pricing_tables_currency_styles = array();

		if(isset($mkd_options['pricing_tables_currency_font_family']) && $mkd_options['pricing_tables_currency_font_family'] !== '-1') {
			$pricing_tables_currency_styles[] = 'font-family: '.str_replace('+', ' ', $mkd_options['pricing_tables_currency_font_family']).', sans-serif';
		}

		if(isset($mkd_options['pricing_tables_currency_font_size']) && $mkd_options['pricing_tables_currency_font_size'] !== '') {
			$pricing_tables_currency_styles[] = 'font-size: '.intval($mkd_options['pricing_tables_currency_font_size']).'px';
		}

		if(isset($mkd_options['pricing_tables_currency_line_height']) && $mkd_options['pricing_tables_currency_line_height'] !== '') {
			$pricing_tables_currency_styles[] = 'line-height: '.intval($mkd_options['pricing_tables_currency_line_height']).'px';
		}

		if(isset($mkd_options['pricing_tables_currency_letter_spacing']) && $mkd_options['pricing_tables_currency_letter_spacing'] !== '') {
			$pricing_tables_currency_styles[] = 'letter-spacing: '.intval($mkd_options['pricing_tables_currency_letter_spacing']).'px';
		}

		if(isset($mkd_options['pricing_tables_currency_font_weight']) && $mkd_options['pricing_tables_currency_font_weight'] !== '') {
			$pricing_tables_currency_styles[] = 'font-weight: '.intval($mkd_options['pricing_tables_currency_font_weight']);
		}

		if(isset($mkd_options['pricing_tables_currency_font_style']) && $mkd_options['pricing_tables_currency_font_style'] !== '') {
			$pricing_tables_currency_styles[] = 'font-style: '.$mkd_options['pricing_tables_currency_font_style'];
		}

		if(isset($mkd_options['pricing_tables_currency_text_transform']) && $mkd_options['pricing_tables_currency_text_transform'] !== '') {
			$pricing_tables_currency_styles[] = 'text-transform: '.$mkd_options['pricing_tables_currency_text_transform'];
		}

		if(isset($mkd_options['pricing_tables_currency_color']) && $mkd_options['pricing_tables_currency_color'] !== '') {
			$pricing_tables_currency_styles[] = 'color: '.$mkd_options['pricing_tables_currency_color'];
		}

		if(is_array($pricing_tables_currency_styles) && count($pricing_tables_currency_styles)) { ?>
            .price_in_table .value{
			<?php echo esc_attr(implode(';', $pricing_tables_currency_styles)); ?>
            }
		<?php } ?>

		<?php
		$pricing_tables_button_styles = array();

		if(isset($mkd_options['pricing_tables_button_font_family']) && $mkd_options['pricing_tables_button_font_family'] !== '-1') {
			$pricing_tables_button_styles[] = 'font-family: '.str_replace('+', ' ', $mkd_options['pricing_tables_button_font_family']).', sans-serif';
		}

		if(isset($mkd_options['pricing_tables_button_font_size']) && $mkd_options['pricing_tables_button_font_size'] !== '') {
			$pricing_tables_button_styles[] = 'font-size: '.intval($mkd_options['pricing_tables_button_font_size']).'px';
		}

		if(isset($mkd_options['pricing_tables_button_line_height']) && $mkd_options['pricing_tables_button_line_height'] !== '') {
			$pricing_tables_button_styles[] = 'line-height: '.intval($mkd_options['pricing_tables_button_line_height']).'px';
		}

		if(isset($mkd_options['pricing_tables_button_letter_spacing']) && $mkd_options['pricing_tables_button_letter_spacing'] !== '') {
			$pricing_tables_button_styles[] = 'letter-spacing: '.intval($mkd_options['pricing_tables_button_letter_spacing']).'px';
		}

		if(isset($mkd_options['pricing_tables_button_font_weight']) && $mkd_options['pricing_tables_button_font_weight'] !== '') {
			$pricing_tables_button_styles[] = 'font-weight: '.intval($mkd_options['pricing_tables_button_font_weight']);
		}

		if(isset($mkd_options['pricing_tables_button_font_style']) && $mkd_options['pricing_tables_button_font_style'] !== '') {
			$pricing_tables_button_styles[] = 'font-style: '.$mkd_options['pricing_tables_button_font_style'];
		}

		if(isset($mkd_options['pricing_tables_button_text_transform']) && $mkd_options['pricing_tables_button_text_transform'] !== '') {
			$pricing_tables_button_styles[] = 'text-transform: '.$mkd_options['pricing_tables_button_text_transform'];
		}

		if(isset($mkd_options['pricing_tables_button_color']) && $mkd_options['pricing_tables_button_color'] !== '') {
			$pricing_tables_button_styles[] = 'color: '.$mkd_options['pricing_tables_button_color'];
		}
		if(isset($mkd_options['pricing_tables_button_backgroundcolor']) && $mkd_options['pricing_tables_button_backgroundcolor'] !== '') {
			$pricing_tables_button_styles[] = 'background-color: '.$mkd_options['pricing_tables_button_backgroundcolor'];
		}
		if(isset($mkd_options['pricing_tables_button_border_color']) && $mkd_options['pricing_tables_button_border_color'] !== '') {
			$pricing_tables_button_styles[] = 'border-color: '.$mkd_options['pricing_tables_button_border_color'];
			$pricing_tables_button_styles[] = 'border-style: solid';
			$pricing_tables_button_styles[] = 'border-width: 1px;';
		}

		if(isset($mkd_options['pricing_tables_button_border_radius']) && $mkd_options['pricing_tables_button_border_radius'] !== '') {
			$pricing_tables_button_styles[] = 'border-radius: '.intval($mkd_options['pricing_tables_button_border_radius']).'px';
		}

		if(is_array($pricing_tables_button_styles) && count($pricing_tables_button_styles)) { ?>
            .price_table_inner .price_button a{
			<?php echo esc_attr(implode(';', $pricing_tables_button_styles)); ?>
            }
		<?php } ?>


		<?php
		$pricing_tables_button_hover_styles = array();


		if(isset($mkd_options['pricing_tables_button_hovercolor']) && $mkd_options['pricing_tables_button_hovercolor'] !== '') {
			$pricing_tables_button_hover_styles[] = 'color: '.$mkd_options['pricing_tables_button_hovercolor'];
		}

		if(isset($mkd_options['pricing_tables_button_backgroundcolor_hover']) && $mkd_options['pricing_tables_button_backgroundcolor_hover'] !== '') {
			$pricing_tables_button_hover_styles[] = 'background-color: '.$mkd_options['pricing_tables_button_backgroundcolor_hover'];
		}

		if(isset($mkd_options['pricing_tables_button_border_hover_color']) && $mkd_options['pricing_tables_button_border_hover_color'] !== '') {
			$pricing_tables_button_hover_styles[] = 'border-color: '.$mkd_options['pricing_tables_button_border_hover_color'];
		}

		if(is_array($pricing_tables_button_hover_styles) && count($pricing_tables_button_hover_styles)) { ?>
            .price_table_inner .price_button a:hover{
			<?php echo esc_attr(implode(';', $pricing_tables_button_hover_styles)); ?>
            }
		<?php } ?>




		<?php
		$pricing_tables_content_styles = array();

		if(isset($mkd_options['pricing_tables_content_font_family']) && $mkd_options['pricing_tables_content_font_family'] !== '-1') {
			$pricing_tables_content_styles[] = 'font-family: '.str_replace('+', ' ', $mkd_options['pricing_tables_content_font_family']).', sans-serif';
		}

		if(isset($mkd_options['pricing_tables_content_font_size']) && $mkd_options['pricing_tables_content_font_size'] !== '') {
			$pricing_tables_content_styles[] = 'font-size: '.intval($mkd_options['pricing_tables_content_font_size']).'px';
		}

		if(isset($mkd_options['pricing_tables_content_line_height']) && $mkd_options['pricing_tables_content_line_height'] !== '') {
			$pricing_tables_content_styles[] = 'line-height: '.intval($mkd_options['pricing_tables_content_line_height']).'px';
		}

		if(isset($mkd_options['pricing_tables_content_letter_spacing']) && $mkd_options['pricing_tables_content_letter_spacing'] !== '') {
			$pricing_tables_content_styles[] = 'letter-spacing: '.intval($mkd_options['pricing_tables_content_letter_spacing']).'px';
		}

		if(isset($mkd_options['pricing_tables_content_font_weight']) && $mkd_options['pricing_tables_content_font_weight'] !== '') {
			$pricing_tables_content_styles[] = 'font-weight: '.intval($mkd_options['pricing_tables_content_font_weight']);
		}

		if(isset($mkd_options['pricing_tables_content_font_style']) && $mkd_options['pricing_tables_content_font_style'] !== '') {
			$pricing_tables_content_styles[] = 'font-style: '.$mkd_options['pricing_tables_content_font_style'];
		}

		if(isset($mkd_options['pricing_tables_content_text_transform']) && $mkd_options['pricing_tables_content_text_transform'] !== '') {
			$pricing_tables_content_styles[] = 'text-transform: '.$mkd_options['pricing_tables_content_text_transform'];
		}

		if(isset($mkd_options['pricing_tables_content_color']) && $mkd_options['pricing_tables_content_color'] !== '') {
			$pricing_tables_content_styles[] = 'color: '.$mkd_options['pricing_tables_content_color'];
		}

		if(is_array($pricing_tables_content_styles) && count($pricing_tables_content_styles)) { ?>
            .price_table_inner ul li.pricing_table_content{
			<?php echo esc_attr(implode(';', $pricing_tables_content_styles)); ?>
            }
		<?php } ?>

		<?php if (!empty($mkd_options['separator_thickness']) || !empty($mkd_options['separator_topmargin']) || !empty($mkd_options['separator_bottommargin']) || !empty($mkd_options['separator_color']) || !empty($mkd_options['separator_type'])) { ?>
            .separator.normal, .separator.with_icon{
			<?php if (!empty($mkd_options['separator_thickness'])) { ?>    border-bottom-width: <?php echo esc_attr($mkd_options['separator_thickness']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['separator_topmargin'])) { ?>    margin-top: <?php echo esc_attr($mkd_options['separator_topmargin']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['separator_bottommargin'])) { ?> margin-bottom: <?php echo esc_attr($mkd_options['separator_bottommargin']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['separator_color'])) { ?>    border-color: <?php echo esc_attr($mkd_options['separator_color']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['separator_type'])) { ?> border-style: <?php echo esc_attr($mkd_options['separator_type']);  ?>; <?php } ?>
            }

		<?php } ?>
		<?php if (!empty($mkd_options['separator_small_thickness']) || !empty($mkd_options['separator_small_topmargin']) || !empty($mkd_options['separator_small_bottommargin']) || !empty($mkd_options['separator_small_color'])  || !empty($mkd_options['separator_small_width'])  || !empty($mkd_options['separator_small_type'])) { ?>
            .separator.small,
            .wpb_column>.wpb_wrapper .separator.small
            {
			<?php if (!empty($mkd_options['separator_small_thickness'])) { ?>  border-bottom-width: <?php echo esc_attr($mkd_options['separator_small_thickness']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['separator_small_topmargin'])) { ?>  margin-top: <?php echo esc_attr($mkd_options['separator_small_topmargin']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['separator_small_bottommargin'])) { ?>   margin-bottom: <?php echo esc_attr($mkd_options['separator_small_bottommargin']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['separator_small_color'])) { ?>  border-color: <?php echo esc_attr($mkd_options['separator_small_color']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['separator_small_width'])) { ?>  width: <?php echo esc_attr($mkd_options['separator_small_width']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['separator_small_type'])) { ?>   border-style: <?php echo esc_attr($mkd_options['separator_small_type']);  ?>; <?php } ?>
            }
		<?php } ?>

		<?php
		$separators_with_text_text_styles = array();

		if(isset($mkd_options['separators_with_text_text_google_fonts']) && $mkd_options['separators_with_text_text_google_fonts'] !== '-1') {
			$separators_with_text_text_styles[] = 'font-family: '.str_replace('+', ' ', $mkd_options['separators_with_text_text_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['separators_with_text_text_fontsize']) && $mkd_options['separators_with_text_text_fontsize'] !== '') {
			$separators_with_text_text_styles[] = 'font-size: '.intval($mkd_options['separators_with_text_text_fontsize']).'px';
		}

		if(isset($mkd_options['separators_with_text_text_lineheight']) && $mkd_options['separators_with_text_text_lineheight'] !== '') {
			$separators_with_text_text_styles[] = 'line-height: '.intval($mkd_options['separators_with_text_text_lineheight']).'px';
		}

		if(isset($mkd_options['separators_with_text_text_letterspacing']) && $mkd_options['separators_with_text_text_letterspacing'] !== '') {
			$separators_with_text_text_styles[] = 'letter-spacing: '.intval($mkd_options['separators_with_text_text_letterspacing']).'px';
		}

		if(isset($mkd_options['separators_with_text_text_fontweight']) && $mkd_options['separators_with_text_text_fontweight'] !== '') {
			$separators_with_text_text_styles[] = 'font-weight: '.intval($mkd_options['separators_with_text_text_fontweight']);
		}

		if(isset($mkd_options['separators_with_text_text_fontstyle']) && $mkd_options['separators_with_text_text_fontstyle'] !== '') {
			$separators_with_text_text_styles[] = 'font-style: '.$mkd_options['separators_with_text_text_fontstyle'];
		}

		if(isset($mkd_options['separators_with_text_text_texttransform']) && $mkd_options['separators_with_text_text_texttransform'] !== '') {
			$separators_with_text_text_styles[] = 'text-transform: '.$mkd_options['separators_with_text_text_texttransform'];
		}

		if(isset($mkd_options['separators_with_text_text_color']) && $mkd_options['separators_with_text_text_color'] !== '') {
			$separators_with_text_text_styles[] = 'color: '.$mkd_options['separators_with_text_text_color'];
		}

		if(is_array($separators_with_text_text_styles) && count($separators_with_text_text_styles)) { ?>
            .vc_text_separator.full .separator_content
            {
			<?php echo esc_attr(implode(';', $separators_with_text_text_styles)); ?>
            }
		<?php } ?>
		<?php
		if(isset($mkd_options['separators_with_text_text_hover_color']) && $mkd_options['separators_with_text_text_hover_color'] !== '') { ?>
            .vc_text_separator.full .separator_content span:hover{
            color: <?php echo esc_attr($mkd_options['separators_with_text_text_hover_color']); ?>
            }
		<?php } ?>
		<?php if (!empty($mkd_options['message_backgroundcolor'])) { ?>
            .mkd_message{
			<?php if (!empty($mkd_options['message_backgroundcolor'])) { ?>background-color: <?php echo esc_attr($mkd_options['message_backgroundcolor']);  ?><?php } ?>;
            }
		<?php } ?>
		<?php if (!empty($mkd_options['message_title_color']) || !empty($mkd_options['message_title_fontsize']) || !empty($mkd_options['message_title_lineheight']) || !empty($mkd_options['message_title_fontstyle']) || !empty($mkd_options['message_title_fontweight']) || $mkd_options['message_title_google_fonts'] != "-1") { ?>
            .mkd_message .message_text .message_text_inner{
			<?php if (!empty($mkd_options['message_title_color'])) { ?>    color: <?php echo esc_attr($mkd_options['message_title_color']);  ?>; <?php } ?>
			<?php if($mkd_options['message_title_google_fonts'] != "-1"){ ?>
                font-family: '<?php echo esc_attr(str_replace('+', ' ', $mkd_options['message_title_google_fonts'])); ?>', sans-serif;
			<?php } ?>
			<?php if (!empty($mkd_options['message_title_fontsize'])) { ?> font-size: <?php echo esc_attr($mkd_options['message_title_fontsize']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['message_title_lineheight'])) { ?>   line-height: <?php echo esc_attr($mkd_options['message_title_lineheight']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['message_title_fontstyle'])) { ?>    font-style: <?php echo esc_attr($mkd_options['message_title_fontstyle']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['message_title_fontweight'])) { ?>   font-weight: <?php echo esc_attr($mkd_options['message_title_fontweight']); ?>; <?php } ?>
            }
		<?php } ?>
		<?php if (!empty($mkd_options['message_icon_fontsize']) && !empty($mkd_options['message_icon_color'])) { ?>
            .mkd_message.with_icon .mkd_message_icon_inner > i,
            .mkd_message.with_icon .mkd_message_icon_inner > .mkd_font_elegant_icon {
			<?php if (!empty($mkd_options['message_icon_color'])) { ?> color:  <?php echo esc_attr($mkd_options['message_icon_color']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['message_icon_fontsize'])) { ?> font-size: <?php echo esc_attr($mkd_options['message_icon_fontsize']);  ?>px; <?php } ?>
            }
		<?php } ?>

		<?php
		$pagination_styles = array();
		$pagination_number_styles = array();

		if(isset($mkd_options['pagination_font_family']) && $mkd_options['pagination_font_family'] !== '-1') {
			$pagination_number_styles[] = 'font-family: '.str_replace('+', ' ', $mkd_options['pagination_font_family']).', sans-serif';
		}

		if(isset($mkd_options['pagination_font_size']) && $mkd_options['pagination_font_size'] !== '') {
			$pagination_styles[] = 'font-size: '.intval($mkd_options['pagination_font_size']).'px';
		}

		if(isset($mkd_options['pagination_line_height']) && $mkd_options['pagination_line_height'] !== '') {
			$pagination_styles[] = 'line-height: '.intval($mkd_options['pagination_line_height']).'px';
		}

		if(isset($mkd_options['pagination_letter_spacing']) && $mkd_options['pagination_letter_spacing'] !== '') {
			$pagination_number_styles[] = 'letter-spacing: '.intval($mkd_options['pagination_letter_spacing']).'px';
		}

		if(isset($mkd_options['pagination_font_weight']) && $mkd_options['pagination_font_weight'] !== '') {
			$pagination_styles[] = 'font-weight: '.intval($mkd_options['pagination_font_weight']);
		}

		if(isset($mkd_options['pagination_font_style']) && $mkd_options['pagination_font_style'] !== '') {
			$pagination_number_styles[] = 'font-style: '.$mkd_options['pagination_font_style'];
		}

		if(isset($mkd_options['pagination_text_transform']) && $mkd_options['pagination_text_transform'] !== '') {
			$pagination_number_styles[] = 'text-transform: '.$mkd_options['pagination_text_transform'];
		}

		if(isset($mkd_options['pagination_color']) && $mkd_options['pagination_color'] !== '') {
			$pagination_styles[] = 'color: '.$mkd_options['pagination_color'];
		}

		if(is_array($pagination_styles) && count($pagination_styles)) { ?>
            .pagination ul li > span, .comment_pager .page-numbers, .pagination ul li > a, .pagination ul li.active span, .pagination ul li > a.inactive, .single_links_pages span,
            .woocommerce-pagination ul.page-numbers li>a, .woocommerce-pagination ul.page-numbers li>span, .woocommerce-pagination ul.page-numbers li span.current, .woocommerce-pagination ul.page-numbers li a{
			<?php echo esc_attr(implode(';', $pagination_styles)); ?>
            }
		<?php }

		if(is_array($pagination_number_styles) && count($pagination_number_styles)) { ?>
            .pagination ul li.active span, .comment_pager .page-numbers, .pagination ul li > a.inactive, .single_links_pages span, .woocommerce-pagination ul.page-numbers li span.current, .woocommerce-pagination ul.page-numbers li a{
			<?php echo esc_attr(implode(';', $pagination_number_styles)); ?>
            }
		<?php } ?>


		<?php if(!empty($mkd_options['pagination_hover_color'])) { ?>
            .pagination ul li a:hover, .pagination ul li.active span, .woocommerce-pagination ul.page-numbers li span.current, .woocommerce-pagination ul.page-numbers li a:hover, .single_links_pages > span, .single_links_pages a:hover span{
            color: <?php echo esc_attr($mkd_options['pagination_hover_color']); ?>;
            }
		<?php } ?>

		<?php
		$Portfolio_pagination_styles = array();

		if(isset($mkd_options['portfolio_pagination_font_size']) && $mkd_options['portfolio_pagination_font_size'] !== '') {
			$Portfolio_pagination_styles[] = 'font-size: '.intval($mkd_options['portfolio_pagination_font_size']).'px';
		}

		if(isset($mkd_options['portfolio_pagination_color']) && $mkd_options['portfolio_pagination_color'] !== '') {
			$Portfolio_pagination_styles[] = 'color: '.$mkd_options['portfolio_pagination_color'];
		}

		if(is_array($Portfolio_pagination_styles) && count($Portfolio_pagination_styles)) { ?>
            .portfolio_navigation a{
			<?php echo esc_attr(implode(';', $Portfolio_pagination_styles)); ?>
            }
		<?php } ?>

		<?php if(!empty($mkd_options['portfolio_pagination_hover_color'])) { ?>
            .portfolio_navigation a:hover{
            color: <?php echo esc_attr($mkd_options['portfolio_pagination_hover_color']); ?>;
            }
		<?php } ?>

		<?php if (!empty($mkd_options['icon_color']) || !empty($mkd_options['icon_background_color']) || !empty($mkd_options['icon_border_color']) || (isset($mkd_options['icon_border_width']) && ($mkd_options['icon_border_width']) != "")) { ?>
            .mkd_icon_shortcode.circle i, .mkd_icon_shortcode.square i, .mkd_icon_shortcode.circle span,.mkd_icon_shortcode.square span{
			<?php if (!empty($mkd_options['icon_color'])) { ?> color: <?php echo esc_attr($mkd_options['icon_color']); ?>; <?php } ?>
            }

			<?php

			if(isset($mkd_options['icon_border_width']) && ($mkd_options['icon_border_width']) != "") {
				$icon_border_width = $mkd_options['icon_border_width']."px";
			}
			else{
				$icon_border_width = "1px";
			}
			?>

            .mkd_icon_shortcode.mkd_icon_shade.circle,.mkd_icon_shortcode.mkd_icon_shade.square{
			<?php if (!empty($mkd_options['icon_background_color'])) { ?> background-color: <?php echo esc_attr($mkd_options['icon_background_color']); ?>; <?php } ?>
			<?php if ((!empty($mkd_options['icon_border_color'])) || (!empty($mkd_options['icon_border_width']))) { ?> border-style: solid; <?php } ?>
			<?php if (!empty($mkd_options['icon_border_color'])) { ?> border-color: <?php echo esc_attr($mkd_options['icon_border_color']); ?>; <?php } ?>
            border-width: <?php echo esc_attr($icon_border_width); ?>!important;
            }
		<?php } ?>

		<?php if (!empty($mkd_options['icon_hover_color']) || !empty($mkd_options['icon_hover_background_color']) || !empty($mkd_options['icon_hover_border_color'])) { ?>
            .mkd_icon_shortcode.circle:hover i, .mkd_icon_shortcode.square:hover i, .mkd_icon_shortcode.circle:hover span, .mkd_icon_shortcode.square:hover span{
			<?php if (!empty($mkd_options['icon_hover_color'])) { ?> color: <?php echo esc_attr($mkd_options['icon_hover_color']); ?> !important; <?php } ?>

            }

			<?php
			if(isset($mkd_options['icon_border_width']) && ($mkd_options['icon_border_width']) != "") {
				$icon_border_width = $mkd_options['icon_border_width']."px";
			}
			else{
				$icon_border_width = "1px";
			}
			?>

            .mkd_icon_shortcode.circle:hover, .mkd_icon_shortcode.square:hover{
			<?php if (!empty($mkd_options['icon_hover_background_color'])) { ?> background-color: <?php echo esc_attr($mkd_options['icon_hover_background_color']); ?>!important; <?php } ?>
			<?php if ((!empty($mkd_options['icon_hover_border_color'])) || (!empty($mkd_options['icon_border_width']))) { ?> border-style: solid; <?php } ?>
			<?php if (!empty($mkd_options['icon_hover_border_color'])) { ?> border-color: <?php echo esc_attr($mkd_options['icon_hover_border_color']); ?>!important; <?php } ?>
            border-width: <?php echo esc_attr($icon_border_width); ?>!important;
            }
		<?php } ?>

		<?php if(!empty($mkd_options['icon_color_normal'])) { ?>
            .mkd_icon_shortcode.normal i, .mkd_icon_shortcode.normal span{
            color: <?php echo esc_attr($mkd_options['icon_color_normal']); ?>;
            }
		<?php } ?>

		<?php if(!empty($mkd_options['icon_hover_color_normal'])) { ?>
            .mkd_icon_shortcode.normal:hover i, .mkd_icon_shortcode.normal:hover span{
            color: <?php echo esc_attr($mkd_options['icon_hover_color_normal']); ?>!important;
            }
		<?php } ?>

		<?php // icon with text start ?>


		<?php if (!empty($mkd_options['icon_with_text_icon_color']) || !empty($mkd_options['icon_background_color']) || !empty($mkd_options['icon_with_text_icon_border_color']) || !empty($mkd_options['icon_with_text_icon_border_width'])) { ?>

            .mkd_icon_with_title.circle .mkd_font_elegant_holder.circle,
            .mkd_icon_with_title.square .mkd_font_elegant_holder.square,
            .box_holder_icon_inner .mkd_font_elegant_holder.circle,
            .box_holder_icon_inner .mkd_font_elegant_holder.square,
            .box_holder_icon_inner .fa-stack,
            .mkd_icon_with_title.square .icon_holder .fa-stack,
            .box_holder_icon_inner .mkd_font_elegant_holder.circle,
            .box_holder_icon_inner .mkd_font_elegant_holder.square{
			<?php if (!empty($mkd_options['icon_with_text_icon_color'])) { ?> color: <?php echo esc_attr($mkd_options['icon_with_text_icon_color']); ?>; <?php } ?>
            }

			<?php
			if(isset($mkd_options['icon_with_text_icon_border_width']) && ($mkd_options['icon_with_text_icon_border_width']) != "") {
				$icon_with_text_icon_border_width = $mkd_options['icon_with_text_icon_border_width']."px";
			}
			else{
				$icon_with_text_icon_border_width = "1px";
			}
			?>

            .box_holder_icon_inner .icon_holder_inner .mkd_font_elegant_holder.circle,
            .box_holder_icon_inner .icon_holder_inner .mkd_font_elegant_holder.square,
            .mkd_icon_with_title.circle .icon_holder_inner .mkd_font_elegant_holder.circle,
            .mkd_icon_with_title.square .icon_holder_inner .mkd_font_elegant_holder.square,
            .mkd_icon_with_title.circle .icon_holder .fa-stack,
            .mkd_icon_with_title.square .icon_holder .fa-stack{
			<?php if (!empty($mkd_options['icon_with_text_icon_background_color'])) { ?> background-color: <?php echo esc_attr($mkd_options['icon_with_text_icon_background_color']); ?>; <?php } ?>
			<?php if ((!empty($mkd_options['icon_with_text_icon_border_color'])) || (!empty($mkd_options['icon_with_text_icon_border_width']))) { ?> border-style: solid; <?php } ?>
			<?php if (!empty($mkd_options['icon_with_text_icon_border_color'])) { ?> border-color: <?php echo esc_attr($mkd_options['icon_with_text_icon_border_color']); ?>; <?php } ?>
            border-width: <?php echo esc_attr($icon_with_text_icon_border_width); ?>!important;
            }
		<?php } ?>

		<?php if (!empty($mkd_options['icon_with_text_icon_hover_color']) || !empty($mkd_options['icon_with_text_icon_hover_background_color']) || !empty($mkd_options['icon_with_text_icon_hover_border_color'])) { ?>
            .mkd_icon_with_title .icon_holder:hover .icon_text_icon, .box_holder_icon_inner .icon_holder_inner:hover .icon_text_icon{
			<?php if (!empty($mkd_options['icon_with_text_icon_hover_color'])) { ?> color: <?php echo esc_attr($mkd_options['icon_with_text_icon_hover_color']); ?> !important; <?php } ?>

            }

			<?php
			if(isset($mkd_options['icon_with_text_icon_border_width']) && ($mkd_options['icon_with_text_icon_border_width']) != "") {
				$icon_with_text_icon_border_width = $mkd_options['icon_with_text_icon_border_width']."px";
			}
			else{
				$icon_with_text_icon_border_width = "1px";
			}
			?>

            .box_holder_icon_inner .icon_holder_inner:hover .mkd_font_elegant_holder.circle,
            .box_holder_icon_inner .icon_holder_inner:hover .mkd_font_elegant_holder.square,
            .mkd_icon_with_title.circle .icon_holder_inner:hover .mkd_font_elegant_holder.circle,
            .mkd_icon_with_title.square .icon_holder_inner:hover .mkd_font_elegant_holder.square,
            .mkd_icon_with_title.circle .icon_holder:hover .fa-stack,
            .mkd_icon_with_title.square .icon_holder:hover .fa-stack{
			<?php if (!empty($mkd_options['icon_with_text_icon_hover_background_color'])) { ?> background-color: <?php echo esc_attr($mkd_options['icon_with_text_icon_hover_background_color']); ?>!important; <?php } ?>
			<?php if ((!empty($mkd_options['icon_with_text_icon_hover_border_color'])) || (!empty($mkd_options['icon_with_text_icon_border_width']))) { ?> border-style: solid; <?php } ?>
			<?php if (!empty($mkd_options['icon_with_text_icon_hover_border_color'])) { ?> border-color: <?php echo esc_attr($mkd_options['icon_with_text_icon_hover_border_color']); ?>!important; <?php } ?>
            border-width: <?php echo esc_attr($icon_with_text_icon_border_width); ?>!important;
            }
		<?php } ?>

		<?php if(!empty($mkd_options['icon_with_text_icon_color_normal'])) { ?>
            .mkd_icon_with_title.normal_icon .icon_holder .icon_text_icon, .box_holder_icon_inner.normal_icon .icon_holder_inner .icon_text_icon{
            color: <?php echo esc_attr($mkd_options['icon_with_text_icon_color_normal']); ?>;
            }
		<?php } ?>


		<?php if(!empty($mkd_options['icon_with_text_icon_hover_color_normal'])) { ?>
            .mkd_icon_with_title.normal_icon .icon_holder:hover .icon_text_icon, .box_holder_icon_inner.normal_icon .icon_holder_inner:hover .icon_text_icon{
            color: <?php echo esc_attr($mkd_options['icon_with_text_icon_hover_color_normal']); ?> !important;
            }
		<?php } ?>



		<?php // icon with text end ?>


		<?php if (!empty($mkd_options['social_icon_color']) || !empty($mkd_options['social_icon_background_color']) || !empty($mkd_options['social_icon_border_color'])) { ?>
            .mkd_social_icon_holder .fa-stack{
			<?php if (!empty($mkd_options['social_icon_color'])) { ?> color: <?php echo esc_attr($mkd_options['social_icon_color']); ?>; <?php } ?>
			<?php if (!empty($mkd_options['social_icon_background_color'])) { ?> background-color: <?php echo esc_attr($mkd_options['social_icon_background_color']); ?>; <?php } ?>
			<?php if (!empty($mkd_options['social_icon_border_color'])) { ?> border: 1px solid <?php echo esc_attr($mkd_options['social_icon_border_color']); ?>; <?php } ?>
            }
		<?php } ?>

		<?php if (!empty($mkd_options['social_icon_hover_color']) || !empty($mkd_options['social_icon_hover_background_color']) || !empty($mkd_options['social_icon_hover_border_color'])) { ?>
            .mkd_social_icon_holder:hover .fa-stack{
			<?php if (!empty($mkd_options['social_icon_hover_color'])) { ?> color: <?php echo esc_attr($mkd_options['social_icon_hover_color']); ?> !important; <?php } ?>
			<?php if (!empty($mkd_options['social_icon_hover_background_color'])) { ?> background-color: <?php echo esc_attr($mkd_options['social_icon_hover_background_color']); ?> !important; <?php } ?>
			<?php if (!empty($mkd_options['social_icon_hover_border_color'])) { ?> border: 1px solid <?php echo esc_attr($mkd_options['social_icon_hover_border_color']); ?> !important; <?php } ?>
            }
		<?php } ?>

		<?php if(!empty($mkd_options['social_color'])) { ?>
            .mkd_social_icon_holder.normal_social .simple_social,
            .mkd_social_icon_holder.normal_social.with_link .simple_social{
            color: <?php echo esc_attr($mkd_options['social_color']); ?>;
            }
		<?php } ?>

		<?php if(!empty($mkd_options['social_hover_color'])) { ?>
            .mkd_social_icon_holder.normal_social:hover .simple_social{
            color: <?php echo esc_attr($mkd_options['social_hover_color']); ?> !important;
            }
		<?php } ?>

		<?php

		/* ==========================================================================
   Buttons custom styles
   ========================================================================== */
		//generate button styles
		$default_btn_styles         = '';
		$default_btn_hover_styles   = '';

		$small_btn_styles           = '';

		$large_btn_styles           = '';

		$extra_large_btn_styles     = '';

		$white_btn_styles           = '';
		$white_btn_hover_styles     = '';

		$mid_transparent_btn_styles           = '';
		$mid_transparent_btn_hover_styles     = '';

		$top_bottom_border_btn_styles          = '';
		$top_bottom_border_btn_hover_styles     = '';


		//generate default button styles
		if(isset($mkd_options['button_title_color']) && $mkd_options['button_title_color'] !== '') {
			$default_btn_styles .= 'color: '.esc_attr($mkd_options['button_title_color']).';';
		}

		if(isset($mkd_options['button_title_fontsize']) && $mkd_options['button_title_fontsize'] !== '') {
			$default_btn_styles .= 'font-size: '.esc_attr($mkd_options['button_title_fontsize']).'px;';
		}

		if(isset($mkd_options['button_title_lineheight']) && $mkd_options['button_title_lineheight'] !== '') {
			$default_btn_styles .= 'line-height: '.esc_attr($mkd_options['button_title_lineheight']).'px;';
			$default_btn_styles .= 'height: '.esc_attr($mkd_options['button_title_lineheight']).'px;';
		}

		if(isset($mkd_options['button_title_fontstyle']) && $mkd_options['button_title_fontstyle'] !== '') {
			$default_btn_styles .= 'font-style: '.esc_attr($mkd_options['button_title_fontstyle']).';';
		}

		if(isset($mkd_options['button_title_fontweight']) && $mkd_options['button_title_fontweight'] !== '') {
			$default_btn_styles .= 'font-weight: '.esc_attr($mkd_options['button_title_fontweight']).';';
		}

		if(isset($mkd_options['button_title_google_fonts']) && $mkd_options['button_title_google_fonts'] !== '-1') {
			$default_btn_styles .= 'font-family: '.esc_attr(str_replace('+', ' ', $mkd_options['button_title_google_fonts'])).';';
		}

		if(isset($mkd_options['button_title_letter_spacing']) && $mkd_options['button_title_letter_spacing'] !== '') {
			$default_btn_styles .= 'letter-spacing: '.esc_attr($mkd_options['button_title_letter_spacing']).'px;';
		}

		if(isset($mkd_options['button_title_texttransform']) && $mkd_options['button_title_texttransform'] !== '') {
			$default_btn_styles .= 'text-transform: '.esc_attr($mkd_options['button_title_texttransform']).';';
		}

		if(isset($mkd_options['button_border_color']) && $mkd_options['button_border_color'] !== '') {
			$default_btn_styles .= 'border-color: '.esc_attr($mkd_options['button_border_color']).';';
		}

		if(isset($mkd_options['button_border_width']) && $mkd_options['button_border_width'] !== '') {
			$default_btn_styles .= 'border-width: '.esc_attr($mkd_options['button_border_width']).'px;';
		}

		if(isset($mkd_options['button_border_radius']) && $mkd_options['button_border_radius'] !== '') {
			$default_btn_styles .= 'border-radius: '.esc_attr($mkd_options['button_border_radius']).'px;';
			$default_btn_styles .= '-moz-border-radius: '.esc_attr($mkd_options['button_border_radius']).'px;';
			$default_btn_styles .= '-webkit-border-radius: '.esc_attr($mkd_options['button_border_radius']).'px;';
		}

		if(isset($mkd_options['button_backgroundcolor']) && $mkd_options['button_backgroundcolor'] !== '') {
			$default_btn_styles .= 'background-color: '.esc_attr($mkd_options['button_backgroundcolor']).';';
		}

		if(isset($mkd_options['button_padding']) && $mkd_options['button_padding'] !== '') {
			$default_btn_styles .= 'padding-left: '.esc_attr($mkd_options['button_padding']).'px;';
			$default_btn_styles .= 'padding-right: '.esc_attr($mkd_options['button_padding']).'px;';
		}

		//print default button styles
		if($default_btn_styles !== '') {
			?>
            .qbutton,
            .qbutton.medium,
            #submit_comment,
            .load_more a,
            .blog_load_more_button a,
            .blog_holder article .post_text a.more-link span,
            .post-password-form input[type='submit']{
			<?php echo esc_attr($default_btn_styles); /* this php variable is escaped for security output on line 8121-8174 */?>
            }
			<?php
		}

		//generate default button hover styles
		if(isset($mkd_options['button_title_hovercolor']) && $mkd_options['button_title_hovercolor'] !== '') {
			$default_btn_hover_styles .= 'color: '.$mkd_options['button_title_hovercolor'].';';
		}

		if(isset($mkd_options['button_backgroundcolor_hover']) && $mkd_options['button_backgroundcolor_hover'] !== '') {
			$default_btn_hover_styles .= 'background-color: '.$mkd_options['button_backgroundcolor_hover'].';';
		}

		if(isset($mkd_options['button_border_hover_color']) && $mkd_options['button_border_hover_color'] !== '') {
			$default_btn_hover_styles .= 'border-color: '.$mkd_options['button_border_hover_color'].';';
		}

		//print default button hover styles
		if($default_btn_hover_styles !== '') {
			?>
            .qbutton:hover,
            .qbutton:not(.white):hover,
            .qbutton.medium:hover,
            #submit_comment:hover,
            .load_more a:hover,
            .blog_load_more_button a:hover,
            .blog_holder article .post_text a.more-link:hover span,
            .post-password-form input[type='submit']:hover {
			<?php echo esc_attr($default_btn_hover_styles); ?>
            }
			<?php
		}

		//generate small button styles
		if(isset($mkd_options['small_button_fontsize']) && $mkd_options['small_button_fontsize'] !== '') {
			$small_btn_styles .= 'font-size: '.intval($mkd_options['small_button_fontsize']).'px;';
		}

		if(isset($mkd_options['small_button_lineheight']) && $mkd_options['small_button_lineheight'] !== '') {
			$small_btn_styles .= 'line-height: '.intval($mkd_options['small_button_lineheight']).'px;';
			$small_btn_styles .= 'height: '.intval($mkd_options['small_button_lineheight']).'px;';
		}

		if(isset($mkd_options['small_button_fontweight']) && $mkd_options['small_button_fontweight'] !== '') {
			$small_btn_styles .= 'font-weight: '.intval($mkd_options['small_button_fontweight']).';';
		}

		if(isset($mkd_options['small_button_padding']) && $mkd_options['small_button_padding'] !== '') {
			$small_btn_styles .= 'padding-left: '.intval($mkd_options['small_button_padding']).'px;';
			$small_btn_styles .= 'padding-right: '.intval($mkd_options['small_button_padding']).'px;';
		}

		if(isset($mkd_options['small_button_border_radius']) && $mkd_options['small_button_border_radius'] !== '') {
			$small_btn_styles .= '-webkit-border-radius: '.intval($mkd_options['small_button_border_radius']).'px;';
			$small_btn_styles .= '-moz-border-radius: '.intval($mkd_options['small_button_border_radius']).'px;';
			$small_btn_styles .= 'border-radius: '.intval($mkd_options['small_button_border_radius']).'px;';
		}

		//print small button styles
		if($small_btn_styles !== '') {
			?>
            .qbutton.small,
            .blog_holder article .post_text a.more-link span{
			<?php echo esc_attr($small_btn_styles); ?>
            }
			<?php
		}

		//generate large button styles
		if(isset($mkd_options['large_button_fontsize']) && $mkd_options['large_button_fontsize'] !== '') {
			$large_btn_styles .= 'font-size: '.intval($mkd_options['large_button_fontsize']).'px;';
		}

		if(isset($mkd_options['large_button_lineheight']) && $mkd_options['large_button_lineheight'] !== '') {
			$large_btn_styles .= 'line-height: '.intval($mkd_options['large_button_lineheight']).'px;';
			$large_btn_styles .= 'height: '.intval($mkd_options['large_button_lineheight']).'px;';
		}

		if(isset($mkd_options['large_button_fontweight']) && $mkd_options['large_button_fontweight'] !== '') {
			$large_btn_styles .= 'font-weight: '.intval($mkd_options['large_button_fontweight']).';';
		}

		if(isset($mkd_options['large_button_padding']) && $mkd_options['large_button_padding'] !== '') {
			$large_btn_styles .= 'padding-left: '.intval($mkd_options['large_button_padding']).'px;';
			$large_btn_styles .= 'padding-right: '.intval($mkd_options['large_button_padding']).'px;';
		}

		if(isset($mkd_options['large_button_border_radius']) && $mkd_options['large_button_border_radius'] !== '') {
			$large_btn_styles .= '-webkit-border-radius: '.intval($mkd_options['large_button_border_radius']).'px;';
			$large_btn_styles .= '-moz-border-radius: '.intval($mkd_options['large_button_border_radius']).'px;';
			$large_btn_styles .= 'border-radius: '.intval($mkd_options['large_button_border_radius']).'px;';
		}

		//print large button styles
		if($large_btn_styles !== '') {
			?>
            .qbutton.large {
			<?php echo esc_attr($large_btn_styles); ?>
            }
			<?php
		}

		//generate extra large button styles
		if(isset($mkd_options['big_large_button_fontsize']) && $mkd_options['big_large_button_fontsize'] !== '') {
			$extra_large_btn_styles .= 'font-size: '.intval($mkd_options['big_large_button_fontsize']).'px;';
		}

		if(isset($mkd_options['big_large_button_lineheight']) && $mkd_options['big_large_button_lineheight'] !== '') {
			$extra_large_btn_styles .= 'line-height: '.intval($mkd_options['big_large_button_lineheight']).'px;';
			$extra_large_btn_styles .= 'height: '.intval($mkd_options['big_large_button_lineheight']).'px;';
		}

		if(isset($mkd_options['big_large_button_fontweight']) && $mkd_options['big_large_button_fontweight'] !== '') {
			$extra_large_btn_styles .= 'font-weight: '.intval($mkd_options['big_large_button_fontweight']).';';
		}

		if(isset($mkd_options['big_large_button_padding']) && $mkd_options['big_large_button_padding'] !== '') {
			$extra_large_btn_styles .= 'padding-left: '.intval($mkd_options['big_large_button_padding']).'px;';
			$extra_large_btn_styles .= 'padding-right: '.intval($mkd_options['big_large_button_padding']).'px;';
		}

		if(isset($mkd_options['big_large_button_border_radius']) && $mkd_options['big_large_button_border_radius'] !== '') {
			$extra_large_btn_styles .= '-webkit-border-radius: '.intval($mkd_options['big_large_button_border_radius']).'px;';
			$extra_large_btn_styles .= '-moz-border-radius: '.intval($mkd_options['big_large_button_border_radius']).'px;';
			$extra_large_btn_styles .= 'border-radius: '.intval($mkd_options['big_large_button_border_radius']).'px;';
		}

		//print extra large button styles
		if($extra_large_btn_styles !== '') {
			?>
            .qbutton.big_large,
            .qbutton.big_large_full_width,
            .wpb_row .qbutton.big_large_full_width {
			<?php echo esc_attr($extra_large_btn_styles); ?>
            }
			<?php
		}

		//generate white button styles
		if(isset($mkd_options['button_white_border_color']) && $mkd_options['button_white_border_color'] !== '') {
			$white_btn_styles .= 'border-color: '.$mkd_options['button_white_border_color'].';';
		}

		if(isset($mkd_options['button_white_text_color']) && $mkd_options['button_white_text_color'] !== '') {
			$white_btn_styles .= 'color: '.$mkd_options['button_white_text_color'].';';
		}

		if(isset($mkd_options['button_white_background_color']) && $mkd_options['button_white_background_color'] !== '') {
			$white_btn_styles .= 'background-color: '.$mkd_options['button_white_background_color'].';';
		}

		//print white button styles
		if($white_btn_styles !== '') {
			?>
            .qbutton.white {
			<?php echo esc_attr($white_btn_styles); ?>
            }
			<?php
		}

		//generate white button hover styles
		if(isset($mkd_options['button_white_border_color_hover']) && $mkd_options['button_white_border_color_hover'] !== '') {
			$white_btn_hover_styles .= 'border-color: '.$mkd_options['button_white_border_color_hover'].';';
		}

		if(isset($mkd_options['button_white_text_color_hover']) && $mkd_options['button_white_text_color_hover'] !== '') {
			$white_btn_hover_styles .= 'color: '.$mkd_options['button_white_text_color_hover'].';';
		}

		if(isset($mkd_options['button_white_background_color_hover']) && $mkd_options['button_white_background_color_hover'] !== '') {
			$white_btn_hover_styles .= 'background-color: '.$mkd_options['button_white_background_color_hover'].';';
		}

		if($white_btn_hover_styles !== '') {
			?>
            .qbutton.white:hover {
			<?php echo esc_attr($white_btn_hover_styles); ?>
            }
			<?php
		}
		//generate mid_transparent button styles
		if(isset($mkd_options['button_mid_transparent_border_width']) && $mkd_options['button_mid_transparent_border_width'] !== '') {
			$mid_transparent_btn_styles .= 'border-width: '.intval($mkd_options['button_mid_transparent_border_width']).'px;';

		}
		if(isset($mkd_options['button_mid_transparent_border_color']) && $mkd_options['button_mid_transparent_border_color'] !== '') {
			$mid_transparent_border_color = mikado_one_mikado_hex2rgb($mkd_options['button_mid_transparent_border_color']);
			$mid_transparent_btn_styles .= 'border-color: rgba('.$mid_transparent_border_color[0].','.$mid_transparent_border_color[1].','.$mid_transparent_border_color[2].',0.2);';
		}

		if(isset($mkd_options['button_mid_transparent_text_color']) && $mkd_options['button_mid_transparent_text_color'] !== '') {
			$mid_transparent_text_color = mikado_one_mikado_hex2rgb($mkd_options['button_mid_transparent_text_color']);
			$mid_transparent_btn_styles .= 'color: rgba('.$mid_transparent_text_color[0].','.$mid_transparent_text_color[1].','.$mid_transparent_text_color[2].',0.3);';
		}

		if(isset($mkd_options['button_mid_transparent_background_color']) && $mkd_options['button_mid_transparent_background_color'] !== '') {
			$mid_transparent_bg_color = mikado_one_mikado_hex2rgb($mkd_options['button_mid_transparent_background_color']);
			$mid_transparent_btn_styles .= 'background-color:rgba('.$mid_transparent_bg_color[0].','.$mid_transparent_bg_color[1].','.$mid_transparent_bg_color[2].',0.3);';
		}

		//print mid-transparent button styles
		if($mid_transparent_btn_styles !== '') {
			?>
            .qbutton.mid_transparent {
			<?php echo esc_attr($mid_transparent_btn_styles); ?>
            }
			<?php
		}

		//generate mid_transparent button hover styles
		if(isset($mkd_options['button_mid_transparent_border_color_hover']) && $mkd_options['button_mid_transparent_border_color_hover'] !== '') {
			$mid_transparent_hover_border_color = mikado_one_mikado_hex2rgb($mkd_options['button_mid_transparent_border_color_hover']);
			$mid_transparent_btn_hover_styles .= 'border-color: rgba('.$mid_transparent_hover_border_color[0].','.$mid_transparent_hover_border_color[1].','.$mid_transparent_hover_border_color[2].',0.2);';
		}

		if(isset($mkd_options['button_mid_transparent_text_color_hover']) && $mkd_options['button_mid_transparent_text_color_hover'] !== '') {
			$mid_transparent_hover_text_color = mikado_one_mikado_hex2rgb($mkd_options['button_mid_transparent_text_color_hover']);
			$mid_transparent_btn_hover_styles .= 'color: rgba('.$mid_transparent_hover_text_color[0].','.$mid_transparent_hover_text_color[1].','.$mid_transparent_hover_text_color[2].',0.3);';
		}

		if(isset($mkd_options['button_mid_transparent_background_color_hover']) && $mkd_options['button_mid_transparent_background_color_hover'] !== '') {
			$mid_transparent_hover_bg_color = mikado_one_mikado_hex2rgb($mkd_options['button_mid_transparent_background_color_hover']);
			$mid_transparent_btn_hover_styles .= 'background-color:rgba('.$mid_transparent_hover_bg_color[0].','.$mid_transparent_hover_bg_color[1].','.$mid_transparent_hover_bg_color[2].',0.3);';
		}

		if($mid_transparent_btn_hover_styles !== '') {
			?>
            .qbutton.mid_transparent:hover {
			<?php echo esc_attr($mid_transparent_btn_hover_styles); ?>
            }
			<?php
		}

		//generate top_bottom_border button styles
		if(isset($mkd_options['button_top_bottom_border_border_width']) && $mkd_options['button_top_bottom_border_border_width'] !== '') {
			$top_bottom_border_btn_styles .= 'border-width: '.intval($mkd_options['button_top_bottom_border_border_width']).'px;';

		}
		if(isset($mkd_options['button_top_bottom_border_border_color']) && $mkd_options['button_top_bottom_border_border_color'] !== '') {
			$top_bottom_border_btn_styles .= 'border-color: '.$mkd_options['button_top_bottom_border_border_color'].';';
		}

		if(isset($mkd_options['button_top_bottom_border_text_color']) && $mkd_options['button_top_bottom_border_text_color'] !== '') {
			$top_bottom_border_btn_styles .= 'color: '.$mkd_options['button_top_bottom_border_text_color'].';';
		}

		if(isset($mkd_options['button_top_bottom_border_background_color']) && $mkd_options['button_top_bottom_border_background_color'] !== '') {
			$top_bottom_border_btn_styles .= 'background-color: '.$mkd_options['button_top_bottom_border_background_color'].';';
		}

		//print top_bottom_border button styles
		if($top_bottom_border_btn_styles !== '') {
			?>
            .qbutton.top_and_bottom_border {
			<?php echo esc_attr($top_bottom_border_btn_styles); ?>
            }
			<?php
		}

		//generate top_bottom_border button hover styles
		if(isset($mkd_options['button_top_bottom_border_border_color_hover']) && $mkd_options['button_top_bottom_border_border_color_hover'] !== '') {
			$top_bottom_border_btn_hover_styles .= 'border-color: '.$mkd_options['button_top_bottom_border_border_color_hover'].';';
		}

		if(isset($mkd_options['button_top_bottom_border_text_color_hover']) && $mkd_options['button_top_bottom_border_text_color_hover'] !== '') {
			$top_bottom_border_btn_hover_styles .= 'color: '.$mkd_options['button_top_bottom_border_text_color_hover'].';';
		}

		if(isset($mkd_options['button_top_bottom_border_background_color_hover']) && $mkd_options['button_top_bottom_border_background_color_hover'] !== '') {
			$top_bottom_border_btn_hover_styles .= 'background-color: '.$mkd_options['button_top_bottom_border_background_color_hover'].';';
		}

		if($top_bottom_border_btn_hover_styles !== '') {
			?>
            .qbutton.top_and_bottom_border:hover {
			<?php echo esc_attr($top_bottom_border_btn_hover_styles); ?>
            }
			<?php
		}
		/* ==========================================================================
   End of button custom styles
   ========================================================================== */
		/* ==========================================================================
   Back to top styles
   ========================================================================== */

		?>
		<?php

		$mkd_back_to_top_button_styles = '';
		// default values
		$default_btp_height = 46;
		$default_btp_border = 1;

		$mkd_back_to_top_styles = '';

		if(isset($mkd_options['back_to_top_arrow_size']) && ($mkd_options['back_to_top_arrow_size'] !== '')) {
			$mkd_back_to_top_styles .= 'font-size: '.intval($mkd_options['back_to_top_arrow_size']).'px;';
		}

		if(isset($mkd_options['back_to_top_arrow_color']) && !empty($mkd_options['back_to_top_arrow_color'])) {
			$mkd_back_to_top_styles .= 'color: '.$mkd_options['back_to_top_arrow_color'].';';
		}

		if(isset($mkd_options['back_to_top_height']) && ($mkd_options['back_to_top_height'] !== '')) {
			$mkd_back_to_top_styles .= 'height: '.intval($mkd_options['back_to_top_height']).'px;';
			$default_btp_height = $mkd_options['back_to_top_height'];
		}

		if(isset($mkd_options['back_to_top_width']) && ($mkd_options['back_to_top_width'] !== '')) {
			$mkd_back_to_top_styles .= 'width: '.intval($mkd_options['back_to_top_width']).'px;';
		}

		if(isset($mkd_options['back_to_top_border_radius']) && ($mkd_options['back_to_top_border_radius'] !== '')) {
			$mkd_back_to_top_styles .= 'border-radius: '.intval($mkd_options['back_to_top_border_radius']).'px;';
		}

		if(isset($mkd_options['back_to_top_background_color']) && !empty($mkd_options['back_to_top_background_color'])) {
			if(isset($mkd_options['back_to_top_background_transparency']) && ($mkd_options['back_to_top_background_transparency'] !== '')) {
				$back_to_top_background_color_rgb = mikado_one_mikado_hex2rgb($mkd_options['back_to_top_background_color']);
				$mkd_back_to_top_styles .= 'background-color: rgba('.$back_to_top_background_color_rgb[0].','.$back_to_top_background_color_rgb[1].','.$back_to_top_background_color_rgb[2].','.$mkd_options['back_to_top_background_transparency'].');';

			}
			else{
				$mkd_back_to_top_styles .= 'background-color: '.$mkd_options['back_to_top_background_color'].';';
			}

		}
		if(isset($mkd_options['back_to_top_border_width']) && ($mkd_options['back_to_top_border_width'] !== '')) {
			$mkd_back_to_top_styles .= 'border-width: '.intval($mkd_options['back_to_top_border_width']).'px;';
			$default_btp_border = $mkd_options['back_to_top_border_width'];
		}

		if((isset($mkd_options['back_to_top_border_width']) && ($mkd_options['back_to_top_border_width'] !== ''))
		   ||(isset($mkd_options['back_to_top_height']) && ($mkd_options['back_to_top_height'] !== ''))) {
			$mkd_back_to_top_styles .= 'line-height: '.($default_btp_height - 2*$default_btp_border).'px;';

		}

		if(isset($mkd_options['back_to_top_border_color']) && !empty($mkd_options['back_to_top_border_color'])) {
			if(isset($mkd_options['back_to_top_border_transparency']) && ($mkd_options['back_to_top_border_transparency'] !== '')) {
				$back_to_top_border_color_rgb = mikado_one_mikado_hex2rgb($mkd_options['back_to_top_border_color']);
				$mkd_back_to_top_styles .= 'border-color: rgba('.$back_to_top_border_color_rgb[0].','.$back_to_top_border_color_rgb[1].','.$back_to_top_border_color_rgb[2].','.$mkd_options['back_to_top_border_transparency'].');';

			}
			else{
				$mkd_back_to_top_styles .= 'border-color: '.$mkd_options['back_to_top_border_color'].';';
			}
		}

		if($mkd_back_to_top_styles !== '') {
			?>
            #back_to_top > span{
			<?php echo esc_attr($mkd_back_to_top_styles); ?>
            }
			<?php
		} ?>

		<?php
		if((isset($mkd_options['back_to_top_width']) && ($mkd_options['back_to_top_width'] !== ''))
		   ||(isset($mkd_options['back_to_top_height']) && ($mkd_options['back_to_top_height'] !== ''))
		   ||(isset($mkd_options['back_to_top_button_margin_bottom']) && ($mkd_options['back_to_top_button_margin_bottom'] !== ''))) {  ?>
            #back_to_top {
			<?php   if(isset($mkd_options['back_to_top_width']) && ($mkd_options['back_to_top_width'] !== '')) {
				echo esc_attr('width: '.intval($mkd_options['back_to_top_width']).'px;');
			}
			if(isset($mkd_options['back_to_top_height']) && ($mkd_options['back_to_top_height'] !== '')) {
				echo esc_attr('height: '.intval($mkd_options['back_to_top_height']).'px;');
			}
			if(isset($mkd_options['back_to_top_button_margin_bottom']) && ($mkd_options['back_to_top_button_margin_bottom'] !== '')) {
				echo esc_attr('bottom: '.intval($mkd_options['back_to_top_button_margin_bottom']).'px;');
			}
			?>
            }
		<?php } ?>

		<?php
		$mkd_back_to_top_hover_styles = '';

		if(isset($mkd_options['back_to_top_arrow_hover_color']) && !empty($mkd_options['back_to_top_arrow_hover_color'])) {
			$mkd_back_to_top_hover_styles .= 'color: '.$mkd_options['back_to_top_arrow_hover_color'].';';
		}

		if(isset($mkd_options['back_to_top_background_hover_color']) && !empty($mkd_options['back_to_top_background_hover_color'])) {
			$mkd_back_to_top_hover_styles .= 'background-color: '.$mkd_options['back_to_top_background_hover_color'].';';
		}

		if(isset($mkd_options['back_to_top_border_hover_color']) && !empty($mkd_options['back_to_top_border_hover_color'])) {
			$mkd_back_to_top_hover_styles .= 'border-color: '.$mkd_options['back_to_top_border_hover_color'].';';
		}

		if($mkd_back_to_top_hover_styles !== '') {
			?>
            #back_to_top:hover > span{
			<?php echo esc_attr($mkd_back_to_top_hover_styles); ?>
            }
			<?php
		}
		?>


		<?php
		$back_to_top_text_styles = '';
		if(isset($mkd_options['back_to_top_type']) && ($mkd_options['back_to_top_type'] == 'text')){
			if(isset($mkd_options['back_to_top_text']) && ($mkd_options['back_to_top_text'] !== '')){
				$back_to_top_text_styles .= 'font-family: Open Sans, sans-serif;';
			}

			if(isset($mkd_options['back_to_top_text_color']) && !empty($mkd_options['back_to_top_text_color'])) {
				$back_to_top_text_styles .= 'color: '.esc_attr($mkd_options['back_to_top_text_color']).';';
			}

			if(isset($mkd_options['back_to_top_text_fontsize']) && ($mkd_options['back_to_top_text_fontsize'] !== '')){
				$back_to_top_text_styles .= 'font-size: '.esc_attr($mkd_options['back_to_top_text_fontsize']).'px;';
			}
			if(isset($mkd_options['back_to_top_text_letterspacing']) && ($mkd_options['back_to_top_text_letterspacing'] !== '')){
				$back_to_top_text_styles .= 'letter-spacing: '.esc_attr($mkd_options['back_to_top_text_letterspacing']).'px;';
			}
			if(isset($mkd_options['back_to_top_text_fontfamily']) && $mkd_options['back_to_top_text_fontfamily'] !== '-1') {
				$back_to_top_text_styles .= 'font-family: '.esc_attr(str_replace('+', ' ', $mkd_options['back_to_top_text_fontfamily'])).', sans-serif;';
			}
			if(isset($mkd_options['back_to_top_text_texttransform']) && ($mkd_options['back_to_top_text_texttransform'] !== '')){
				$back_to_top_text_styles .= 'text-transform: '.esc_attr($mkd_options['back_to_top_text_texttransform']).';';
			}
			if(isset($mkd_options['back_to_top_text_fontstyle']) && ($mkd_options['back_to_top_text_fontstyle'] !== '')){
				$back_to_top_text_styles .= 'font-style: '.esc_attr($mkd_options['back_to_top_text_fontstyle']).';';
			}
			if(isset($mkd_options['back_to_top_text_fontweight']) && ($mkd_options['back_to_top_text_fontweight'] !== '')){
				$back_to_top_text_styles .= 'font-weight: '.esc_attr($mkd_options['back_to_top_text_fontweight']).';';
			}
			if(isset($mkd_options['back_to_top_text_lineheight']) && ($mkd_options['back_to_top_text_lineheight'] !== '')){
				$back_to_top_text_styles .= 'line-height: '.esc_attr($mkd_options['back_to_top_text_lineheight']).'px;';
			}
			if($back_to_top_text_styles !== '') {
				?>
                #back_to_top > span .arrow_carrot-up:before{
				<?php echo esc_attr($back_to_top_text_styles); ?>

				<?php if(isset($mkd_options['back_to_top_text']) && ($mkd_options['back_to_top_text'] !== '')) {
					echo 'content: "'.esc_attr($mkd_options['back_to_top_text']).'";';
				} ?>
                display: block;
                }
				<?php
			}
			?>

			<?php
			if(isset($mkd_options['back_to_top_text_hover_color']) && ($mkd_options['back_to_top_text_hover_color'] !== '')){?>
                #back_to_top > span:hover .arrow_carrot-up:before{
                color: <?php echo esc_attr($mkd_options['back_to_top_text_hover_color']); ?>;
                }
				<?php
			}
		}

		/* ==========================================================================
End of Back to top styles
========================================================================== */
		?>

		<?php
		/* ==========================================================================
    CONTENT MENU styles
    ========================================================================== */
		$content_menu_icon_styles = '';

		if(isset($mkd_options['content_menu_icon_color']) && $mkd_options['content_menu_icon_color'] !== ''){
			$content_menu_icon_styles .= 'color: '.$mkd_options['content_menu_icon_color'].';';
		}
		if(isset($mkd_options['content_menu_icon_size']) && $mkd_options['content_menu_icon_size'] !== ''){
			$content_menu_icon_styles .= 'font-size: '.intval($mkd_options['content_menu_icon_size']).'px;';
		}
		if($content_menu_icon_styles !== '') {?>
            nav.content_menu ul li i{
			<?php echo esc_attr($content_menu_icon_styles); ?>
            }
		<?php } ?>

		<?php
		$content_menu_icon_hover_styles = '';

		if(isset($mkd_options['content_menu_icon_hover_color']) && $mkd_options['content_menu_icon_hover_color'] !== ''){
			$content_menu_icon_hover_styles .= 'color: '.$mkd_options['content_menu_icon_hover_color'].';';
		}
		if($content_menu_icon_hover_styles !== '') {?>
            nav.content_menu ul li:hover i{
			<?php echo esc_attr($content_menu_icon_hover_styles); ?>
            }
		<?php } ?>

		<?php
		$content_menu_text_styles = '';

		if(isset($mkd_options['content_menu_text_color']) && $mkd_options['content_menu_text_color'] !== ''){
			$content_menu_text_styles .= 'color: '.$mkd_options['content_menu_text_color'].';';
		}
		if(isset($mkd_options['content_menu_text_fontsize']) && $mkd_options['content_menu_text_fontsize'] !== ''){
			$content_menu_text_styles .= 'font-size: '.intval($mkd_options['content_menu_text_fontsize']).'px;';
		}
		if(isset($mkd_options['content_menu_text_lineheight']) && $mkd_options['content_menu_text_lineheight'] !== ''){
			$content_menu_text_styles .= 'line-height: '.intval($mkd_options['content_menu_text_lineheight']).'px;';
		}
		if(isset($mkd_options['content_menu_text_texttransform']) && $mkd_options['content_menu_text_texttransform'] !== ''){
			$content_menu_text_styles .= 'text-transform: '.$mkd_options['content_menu_text_texttransform'].';';
		}
		if(isset($mkd_options['content_menu_text_fontstyle']) && $mkd_options['content_menu_text_fontstyle'] !== ''){
			$content_menu_text_styles .= 'font-style: '.$mkd_options['content_menu_text_fontstyle'].';';
		}
		if(isset($mkd_options['content_menu_text_fontweight']) && $mkd_options['content_menu_text_fontweight'] !== ''){
			$content_menu_text_styles .= 'font-weight: '.intval($mkd_options['content_menu_text_fontweight']).';';
		}
		if(isset($mkd_options['content_menu_text_letterspacing']) && $mkd_options['content_menu_text_letterspacing'] !== ''){
			$content_menu_text_styles .= 'letter-spacing: '.intval($mkd_options['content_menu_text_letterspacing']).'px;';
		}
		if(isset($mkd_options['content_menu_text_google_fonts']) && $mkd_options['content_menu_text_google_fonts'] !== '-1') {
			$content_menu_text_styles .= 'font-family: '.str_replace('+', ' ', $mkd_options['content_menu_text_google_fonts']).', sans-serif';
		}

		if($content_menu_text_styles !== '') {?>
            nav.content_menu ul li a span,
            nav.content_menu .nav_select_menu ul li a{
			<?php echo esc_attr($content_menu_text_styles); ?>
            }
		<?php } ?>

		<?php
		$content_menu_text_hover_styles = '';

		if(isset($mkd_options['content_menu_text_hover_color']) && $mkd_options['content_menu_text_hover_color'] !== ''){
			$content_menu_text_hover_styles .= 'color: '.$mkd_options['content_menu_text_hover_color'].';';
		}
		if($content_menu_text_hover_styles !== '') {?>
            nav.content_menu ul li:hover a span,
            nav.content_menu .nav_select_menu ul li:hover a{
			<?php echo esc_attr($content_menu_text_hover_styles); ?>
            }
		<?php }
		/* ==========================================================================
END OF CONTENT MENU styles
========================================================================== */
		?>


		<?php
		$mkd_navigation_styles = '';
		$temp_rgb_color = '';
		$temp_transparency_arrow = '';
		$temp_transparency = '';
		$temp_transparency_border = '';
		$mkd_navigation_color_important = '';
		$mkd_navigation_line_height_important = '';
		$mkd_navigation_border_color_important = '';
		$mkd_navigation_border_width_important = '';
		$mkd_navigation_border_style_important = '';
		if(isset($mkd_options['navigation_button_width']) && ($mkd_options['navigation_button_width'] !== '')) {
			$mkd_navigation_styles .= 'width: '.intval($mkd_options['navigation_button_width']).'px;';
		}
		if(isset($mkd_options['navigation_button_height']) && ($mkd_options['navigation_button_height'] !== '')) {
			$mkd_navigation_styles .= 'height: '.intval($mkd_options['navigation_button_height']).'px;';
			$mkd_navigation_styles .= 'margin-top: -'.intval($mkd_options['navigation_button_height']/2).'px;';
			$mkd_navigation_styles .= 'line-height: '.intval($mkd_options['navigation_button_height']).'px;';
			$mkd_navigation_line_height_important .= 'line-height: '.intval($mkd_options['navigation_button_height']).'px!important;';
		}
		if(isset($mkd_options['navigation_arrow_size']) && ($mkd_options['navigation_arrow_size'] !== '')) {
			$mkd_navigation_styles .= 'font-size: '.intval($mkd_options['navigation_arrow_size']).'px;';
		}
		if(isset($mkd_options['navigation_arrow_color']) && !empty($mkd_options['navigation_arrow_color'])) {
			$temp_rgb_color = mikado_one_mikado_hex2rgb($mkd_options['navigation_arrow_color']);
			if(isset($mkd_options['navigation_arrow_transparency']) && ($mkd_options['navigation_arrow_transparency']!== '')) {
				$temp_transparency_arrow = $mkd_options['navigation_arrow_transparency'];
			}
			else{
				$temp_transparency_arrow = 1;
			}
			$mkd_navigation_styles .= 'color: rgba('.$temp_rgb_color[0].','.$temp_rgb_color[1].','.$temp_rgb_color[2].','.$temp_transparency_arrow.');';
			$mkd_navigation_color_important = 'color: rgba('.$temp_rgb_color[0].','.$temp_rgb_color[1].','.$temp_rgb_color[2].','.$temp_transparency_arrow.')!important;';
		}

		if(isset($mkd_options['navigation_background_color']) && !empty($mkd_options['navigation_background_color'])) {
			$temp_rgb_color = mikado_one_mikado_hex2rgb($mkd_options['navigation_background_color']);
			if(isset($mkd_options['navigation_background_transparency']) && ($mkd_options['navigation_background_transparency']!== '')) {
				$temp_transparency = $mkd_options['navigation_background_transparency'];
			}
			else{
				$temp_transparency = 1;
			}
			$mkd_navigation_styles .= 'background-color: rgba('.$temp_rgb_color[0].','.$temp_rgb_color[1].','.$temp_rgb_color[2].','.$temp_transparency.');';

		}

		if(isset($mkd_options['navigation_background_transparency']) && ($mkd_options['navigation_background_transparency'] == 0)) {
			?>
            .carousel-control.light .prev_nav,
            .carousel-control.light .next_nav{
            color:#fff;
            }
            .carousel-control.dark .prev_nav,
            .carousel-control.dark .next_nav{
            color:#000;
            }
		<?php } ?>

		<?php if(isset($mkd_options['navigation_border_color']) && !empty($mkd_options['navigation_border_color'])) {
			$temp_rgb_color = mikado_one_mikado_hex2rgb($mkd_options['navigation_border_color']);
			if(isset($mkd_options['navigation_border_transparency']) && ($mkd_options['navigation_border_transparency']!== '')) {
				$temp_transparency_border = $mkd_options['navigation_border_transparency'];
			}
			else{
				$temp_transparency_border = 1;
			}
			$mkd_navigation_styles .= 'border-color: rgba('.$temp_rgb_color[0].','.$temp_rgb_color[1].','.$temp_rgb_color[2].','.$temp_transparency_border.'); ';
			$mkd_navigation_border_color_important .= 'border-color: rgba('.$temp_rgb_color[0].','.$temp_rgb_color[1].','.$temp_rgb_color[2].','.$temp_transparency_border.')!important; ';
		}

		if(isset($mkd_options['navigation_border_width']) && ($mkd_options['navigation_border_width'] !== '')) {
			$mkd_navigation_styles .= 'border-width:'.intval($mkd_options['navigation_border_width']).'px; ';
			$mkd_navigation_styles .= 'border-style:solid;';
			$mkd_navigation_border_width_important .= 'border-width:'.intval($mkd_options['navigation_border_width']).'px!important; ';
			$mkd_navigation_border_style_important .= 'border-style:solid !important;';
		}

		if(isset($mkd_options['navigation_border_radius']) && ($mkd_options['navigation_border_radius'] !== '')) {
			$mkd_navigation_styles .= 'border-radius:'.intval($mkd_options['navigation_border_radius']).'px;';
		}


		if($mkd_navigation_styles !== '') {
			?>
            .mkd_image_gallery_no_space .controls a.prev-slide,
            .mkd_image_gallery_no_space .controls a.next-slide,
            .mkd_carousels .caroufredsel-direction-nav .caroufredsel-navigation-item,
            .flex-direction-nav a, .caroufredsel-direction-nav a,
            body div.pp_default a.pp_next,
            body div.pp_default a.pp_previous,
            .ls-nav-prev,
            .ls-nav-next,
            .carousel-control .prev_nav,
            .carousel-control .next_nav{
			<?php echo esc_attr($mkd_navigation_styles); ?>
            }

			<?php
			if($mkd_navigation_color_important != ''){ ?>
                body div.pp_default a.pp_next:after,
                body div.pp_default a.pp_previous:after{
				<?php echo esc_attr($mkd_navigation_color_important); ?>
                }
			<?php } ?>

			<?php
			if($mkd_navigation_line_height_important != '' || $mkd_navigation_border_color_important != '' || $mkd_navigation_border_width_important != '' || $mkd_navigation_border_style_important != ''){ ?>
                .ls-nav-prev,
                .ls-nav-next{
				<?php
				if($mkd_navigation_line_height_important != ''){echo esc_attr($mkd_navigation_line_height_important);}
				if($mkd_navigation_border_color_important != ''){echo esc_attr($mkd_navigation_border_color_important);}
				if($mkd_navigation_border_width_important != ''){echo esc_attr($mkd_navigation_border_width_important);}
				if($mkd_navigation_border_style_important != ''){echo esc_attr($mkd_navigation_border_style_important);}
				?>
                }
				<?php
			}
			?>

			<?php if((isset($mkd_options['navigation_button_width']) && ($mkd_options['navigation_button_width'] !== '')) || (isset($mkd_options['navigation_button_height']) && ($mkd_options['navigation_button_height'] !== ''))) {

				if(isset($mkd_options['navigation_border_width']) && ($mkd_options['navigation_border_width'] !== '')) {
					$border_width_add = $mkd_options['navigation_border_width'];
				}else{
					$border_width_add = 1; // 1 is default border width
				}

				?>

                .vertical_menu_enabled.vertical_menu_transparency .carousel-control.left,
                .vertical_menu_enabled.vertical_menu_transparency .carousel-control.right,
                .navigation_bottom_right .carousel-control.left,
                .navigation_bottom_right .carousel-control.right,
                .navigation_bottom_left .carousel-control.left,
                .navigation_bottom_left .carousel-control.right{
				<?php if($mkd_options['navigation_button_width'] !== ''){ ?>
                    width: <?php echo esc_attr($mkd_options['navigation_button_width']) + $border_width_add*2; // ?>px;
				<?php } ?>
				<?php if($mkd_options['navigation_button_height'] !== ''){ ?>
                    height: <?php echo esc_attr($mkd_options['navigation_button_height']) + $border_width_add*2; ?>px;
				<?php } ?>
                }
				<?php
			}
			?>

			<?php if($mkd_options['navigation_button_width'] !== ''){ ?>
                .navigation_bottom_right.content_next_to_arrows .carousel-inner .slider_content,
                .navigation_bottom_left.content_next_to_arrows .carousel-inner .slider_content{
                right: <?php echo esc_attr($mkd_options['navigation_button_width'])*2 + 160 + $border_width_add*4; //160 = 100 from edge + 20 between arrows + 10 on the right from arrows + 30 cotnent from arrows, $border_width_add*4 because of two arrows ?>px !important;
                }

                .navigation_bottom_left.content_next_to_arrows .carousel-inner .slider_content{
                left: <?php echo esc_attr($mkd_options['navigation_button_width'])*2 + 160 + $border_width_add*4; //160 = 100 from edge + 20 between arrows  + 10 on the right from arrows + 30 cotnent from arrows, $border_width_add*4 because of two arrows ?>px !important;
                }
			<?php } ?>

			<?php if($mkd_options['navigation_button_height'] !== ''){ ?>
                .vertical_menu_enabled .carousel-control .prev_nav,
                .vertical_menu_enabled .carousel-control .next_nav{
                margin-top: -<?php echo esc_attr($mkd_options['navigation_button_width'])/2; ?>px !important;
                }
			<?php } ?>


			<?php
		}
		?>


		<?php
		$mkd_navigation_hover_styles = '';
		$temp_hover_transparency = '';
		$mkd_navigation_hover_border_color_important = '';
		$mkd_navigation_hover_color_important = '';
		if(isset($mkd_options['navigation_arrow_hover_color']) && !empty($mkd_options['navigation_arrow_hover_color'])) {
			$temp_rgb_color = mikado_one_mikado_hex2rgb($mkd_options['navigation_arrow_hover_color']);
			if(isset($mkd_options['navigation_arrow_hover_transparency']) && ($mkd_options['navigation_arrow_hover_transparency']!== '')) {
				$temp_hover_transparency = $mkd_options['navigation_arrow_hover_transparency'];
			}
			else {$temp_hover_transparency = 1;}
			$mkd_navigation_hover_styles .= 'color: rgba('.$temp_rgb_color[0].','.$temp_rgb_color[1].','.$temp_rgb_color[2].','.$temp_hover_transparency.');';
			$mkd_navigation_hover_color_important = 'color: rgba('.$temp_rgb_color[0].','.$temp_rgb_color[1].','.$temp_rgb_color[2].','.$temp_hover_transparency.')!important;';
		}
		$temp_hover_transparency = '';
		if(isset($mkd_options['navigation_background_hover_color']) && !empty($mkd_options['navigation_background_hover_color'])) {

			$temp_rgb_color = mikado_one_mikado_hex2rgb($mkd_options['navigation_background_hover_color']);
			if(isset($mkd_options['navigation_background_hover_transparency']) && ($mkd_options['navigation_background_hover_transparency']!== '')) {
				$temp_hover_transparency = $mkd_options['navigation_background_hover_transparency'];
			}
			else {$temp_hover_transparency = 1;}
			$mkd_navigation_hover_styles .= 'background-color: rgba('.$temp_rgb_color[0].','.$temp_rgb_color[1].','.$temp_rgb_color[2].','.$temp_hover_transparency.');';
		}
		$temp_hover_transparency = '';
		if(isset($mkd_options['navigation_border_hover_color']) && !empty($mkd_options['navigation_border_hover_color'])) {
			$temp_rgb_color = mikado_one_mikado_hex2rgb($mkd_options['navigation_border_hover_color']);
			if(isset($mkd_options['navigation_border_hover_transparency']) && ($mkd_options['navigation_border_hover_transparency']!== '')) {
				$temp_hover_transparency = $mkd_options['navigation_border_hover_transparency'];
			}
			else {$temp_hover_transparency = 1;}
			$mkd_navigation_hover_styles .= 'border-color: rgba('.$temp_rgb_color[0].','.$temp_rgb_color[1].','.$temp_rgb_color[2].','.$temp_hover_transparency.')';
			$mkd_navigation_hover_border_color_important .= 'border-color: rgba('.$temp_rgb_color[0].','.$temp_rgb_color[1].','.$temp_rgb_color[2].','.$temp_hover_transparency.') !important;';
		}
		if($mkd_navigation_hover_styles !== '') {
			?>
            .mkd_image_gallery_no_space .controls a.prev-slide:hover,
            .mkd_image_gallery_no_space .controls a.next-slide:hover,
            .mkd_carousels .caroufredsel-direction-nav .caroufredsel-navigation-item:hover,
            .flexslider:hover .flex-direction-nav a:hover,
            .portfolio_slider:hover .caroufredsel-direction-nav a:hover,
            .blog_slider:hover .caroufredsel-direction-nav a:hover,
            body div.pp_default a.pp_next:hover, body div.pp_default a.pp_previous:hover,
            .ls-nav-prev:hover,
            .ls-nav-next:hover,
            .carousel-control .prev_nav:hover,
            .carousel-control .next_nav:hover

            {
			<?php echo esc_attr($mkd_navigation_hover_styles); ?>
            }

			<?php
			if($mkd_navigation_hover_color_important != ''){ ?>
                body div.pp_default a.pp_next:hover:after,
                body div.pp_default a.pp_previous:hover:after{
				<?php echo esc_attr($mkd_navigation_hover_color_important); ?>
                }
			<?php } ?>

			<?php
			if($mkd_navigation_hover_border_color_important != ''){ ?>
                .ls-nav-prev:hover,
                .ls-nav-next:hover{
				<?php echo esc_attr($mkd_navigation_hover_border_color_important); ?>
                }
			<?php } ?>

			<?php
		}
		?>

		<?php

		$fs_navigation_styles = '';

		if(isset($mkd_options['fs_navigation_arrow_size']) && !empty($mkd_options['fs_navigation_arrow_size'])) {
			$fs_navigation_styles .= 'font-size: '.intval($mkd_options['fs_navigation_arrow_size']).'px;';
		}

		if(isset($mkd_options['fs_navigation_arrow_color']) && !empty($mkd_options['fs_navigation_arrow_color'])) {
			$fs_navigation_styles .= 'color: '.$mkd_options['fs_navigation_arrow_color'].';';
		}

		if($fs_navigation_styles !== '') { ?>
            .full_screen_navigation_inner a{
			<?php echo esc_attr($fs_navigation_styles); ?>
            }
		<?php } ?>

		<?php
		$fs_navigation_hover_styles = '';

		if(isset($mkd_options['fs_navigation_arrow_hover_color']) && !empty($mkd_options['fs_navigation_arrow_hover_color'])) {
			$fs_navigation_hover_styles .= 'color: '.$mkd_options['fs_navigation_arrow_hover_color'].';';
		}

		if($fs_navigation_hover_styles !== '') { ?>
            .full_screen_navigation_inner a:hover{
			<?php echo esc_attr($fs_navigation_hover_styles); ?>
            }
		<?php } ?>

		<?php

		$tags_styles = array();
		$tags_hover_styles = array();

		if(isset($mkd_options['tags_font_family']) && $mkd_options['tags_font_family'] !== '-1') {
			$tags_styles[] = 'font-family: '.str_replace('+', ' ', $mkd_options['tags_font_family']).', sans-serif';
		}

		if(isset($mkd_options['tags_font_size']) && $mkd_options['tags_font_size'] !== '') {
			$tags_styles[] = 'font-size: '.intval($mkd_options['tags_font_size']).'px !important';
		}

		if(isset($mkd_options['tags_line_height']) && $mkd_options['tags_line_height'] !== '') {
			$tags_styles[] = 'line-height: '.intval($mkd_options['tags_line_height']).'px';
		}

		if(isset($mkd_options['tags_letter_spacing']) && $mkd_options['tags_letter_spacing'] !== '') {
			$tags_styles[] = 'letter-spacing: '.intval($mkd_options['tags_letter_spacing']).'px';
		}

		if(isset($mkd_options['tags_font_weight']) && $mkd_options['tags_font_weight'] !== '') {
			$tags_styles[] = 'font-weight: '.intval($mkd_options['tags_font_weight']);
		}

		if(isset($mkd_options['tags_font_style']) && $mkd_options['tags_font_style'] !== '') {
			$tags_styles[] = 'font-style: '.$mkd_options['tags_font_style'];
		}

		if(isset($mkd_options['tags_text_transform']) && $mkd_options['tags_text_transform'] !== '') {
			$tags_styles[] = 'text-transform: '.$mkd_options['tags_text_transform'];
		}

		if(isset($mkd_options['tags_color']) && $mkd_options['tags_color'] !== '') {
			$tags_styles[] = 'color: '.$mkd_options['tags_color'];
		}

		if(isset($mkd_options['tags_background_color']) && $mkd_options['tags_background_color'] !== '') {
			$tags_styles[] = 'background-color: '.$mkd_options['tags_background_color'];
		}
		if(isset($mkd_options['tags_border_radius']) && $mkd_options['tags_border_radius'] !== '') {
			$tags_styles[] = 'border-radius: '.intval($mkd_options['tags_border_radius']).'px';
		}
		if(isset($mkd_options['tags_border_color']) && $mkd_options['tags_border_color'] !== '') {
			$tags_styles[] = 'border-color: '.$mkd_options['tags_border_color'];
		}
		if(isset($mkd_options['tags_border_width']) && $mkd_options['tags_border_width'] !== '') {
			$tags_styles[] = 'border-width: '.intval($mkd_options['tags_border_width']).'px';
		}
		if(is_array($tags_styles) && count($tags_styles)) { ?>
            .single_tags a,
            aside.sidebar .widget .tagcloud a,
            .widget .tagcloud a,
            aside.sidebar .widget:not(.woocommerce) .tagcloud a{
			<?php echo esc_attr(implode(';', $tags_styles)); ?>
            }
		<?php }

		if(isset($mkd_options['tags_hover_color']) && $mkd_options['tags_hover_color'] !== '') {
			$tags_hover_styles[] = 'color: '.$mkd_options['tags_hover_color'];
		}
		if(isset($mkd_options['tags_border_hover_color']) && $mkd_options['tags_border_hover_color'] !== '') {
			$tags_hover_styles[] = 'border-color: '.$mkd_options['tags_border_hover_color'];
		}
		if(isset($mkd_options['tags_background_hover_color']) && $mkd_options['tags_background_hover_color'] !== '') {
			$tags_hover_styles[] = 'background-color: '.$mkd_options['tags_background_hover_color'];
		}

		if(is_array($tags_hover_styles) && count($tags_hover_styles)) { ?>
            .single_tags a:hover,
            aside.sidebar .widget.widget_tag_cloud .tagcloud a:hover,
            .widget .tagcloud a:hover{
			<?php echo esc_attr(implode(';', $tags_hover_styles)); ?>
            }
		<?php } ?>

		<?php

		$team_styles = array();

		if(isset($mkd_options['team_font_family']) && $mkd_options['team_font_family'] !== '-1') {
			$team_styles[] = 'font-family: '.str_replace('+', ' ', $mkd_options['team_font_family']).', sans-serif';
		}

		if(isset($mkd_options['team_font_size']) && $mkd_options['team_font_size'] !== '') {
			$team_styles[] = 'font-size: '.intval($mkd_options['team_font_size']).'px !important';
		}

		if(isset($mkd_options['team_line_height']) && $mkd_options['team_line_height'] !== '') {
			$team_styles[] = 'line-height: '.intval($mkd_options['team_line_height']).'px';
		}

		if(isset($mkd_options['team_letter_spacing']) && $mkd_options['team_letter_spacing'] !== '') {
			$team_styles[] = 'letter-spacing: '.intval($mkd_options['team_letter_spacing']).'px';
		}

		if(isset($mkd_options['team_font_weight']) && $mkd_options['team_font_weight'] !== '') {
			$team_styles[] = 'font-weight: '.intval($mkd_options['team_font_weight']);
		}

		if(isset($mkd_options['team_font_style']) && $mkd_options['team_font_style'] !== '') {
			$team_styles[] = 'font-style: '.$mkd_options['team_font_style'];
		}

		if(isset($mkd_options['team_text_transform']) && $mkd_options['team_text_transform'] !== '') {
			$team_styles[] = 'text-transform: '.$mkd_options['team_text_transform'];
		}

		if(isset($mkd_options['team_color']) && $mkd_options['team_color'] !== '') {
			$team_styles[] = 'color: '.$mkd_options['team_color'];
		}

		if(is_array($team_styles) && count($team_styles)) { ?>
            .mkd_team .mkd_team_name{
			<?php  echo esc_attr(implode(';', $team_styles)); ?>
            }

		<?php } ?>

		<?php if(isset($mkd_options['team_hover_color']) && $mkd_options['team_hover_color'] !== '') { ?>
            .mkd_team .mkd_team_social_holder{
            background-color: <?php echo esc_attr($mkd_options['team_hover_color']); ?>;
            }
		<?php } ?>

		<?php if (!empty($mkd_options['team_icon_color']) || !empty($mkd_options['team_icon_background_color']) || !empty($mkd_options['team_icon_border_color'])) { ?>
            .mkd_team_social_holder .mkd_social_icon_holder .fa-stack i,
            .mkd_team_social_holder .mkd_social_icon_holder .fa-stack span,
            .mkd_team .mkd_social_icon_holder.normal_social .simple_social,
            .mkd_team .mkd_social_icon_holder.normal_social.with_link .simple_social{
			<?php if (!empty($mkd_options['team_icon_color'])) { ?> color: <?php echo esc_attr($mkd_options['team_icon_color']); ?>; <?php } ?>
            }

            .mkd_team_social_holder .mkd_social_icon_holder .fa-stack{
			<?php if (!empty($mkd_options['team_icon_background_color'])) { ?> background-color: <?php echo esc_attr($mkd_options['team_icon_background_color']); ?>; <?php } ?>
			<?php if (!empty($mkd_options['team_icon_border_color'])) { ?> border: 1px solid <?php echo esc_attr($mkd_options['team_icon_border_color']); ?>; <?php } ?>
            }
		<?php } ?>

		<?php if (!empty($mkd_options['team_icon_hover_color']) || !empty($mkd_options['team_icon_hover_background_color']) || !empty($mkd_options['team_icon_hover_border_color'])) { ?>
            .mkd_team_social_holder .mkd_social_icon_holder:hover .fa-stack i,
            .mkd_team_social_holder .mkd_social_icon_holder:hover .fa-stack span,
            .mkd_team .mkd_social_icon_holder.normal_social:hover .simple_social,
            .mkd_team .mkd_social_icon_holder.normal_social.with_link:hover .simple_social{
			<?php if (!empty($mkd_options['team_icon_hover_color'])) { ?> color: <?php echo esc_attr($mkd_options['team_icon_hover_color']); ?> !important; <?php } ?>
            }
            .mkd_team_social_holder .mkd_social_icon_holder:hover .fa-stack{
			<?php if (!empty($mkd_options['team_icon_hover_background_color'])) { ?> background-color: <?php echo esc_attr($mkd_options['team_icon_hover_background_color']); ?> !important; <?php } ?>
			<?php if (!empty($mkd_options['team_icon_hover_border_color'])) { ?> border: 1px solid <?php echo esc_attr($mkd_options['team_icon_hover_border_color']); ?> !important; <?php } ?>
            }
		<?php } ?>


		<?php
		$testimonials_title_styles = array();

		if(isset($mkd_options['testimonials_title_font_family']) && $mkd_options['testimonials_title_font_family'] !== '-1') {
			$testimonials_title_styles[] = 'font-family: '.str_replace('+', ' ', $mkd_options['testimonials_title_font_family']).', sans-serif !important';
		}

		if(isset($mkd_options['testimonials_title_font_size']) && $mkd_options['testimonials_title_font_size'] !== '') {
			$testimonials_title_styles[] = 'font-size: '.intval($mkd_options['testimonials_title_font_size']).'px';
		}

		if(isset($mkd_options['testimonials_title_line_height']) && $mkd_options['testimonials_title_line_height'] !== '') {
			$testimonials_title_styles[] = 'line-height: '.intval($mkd_options['testimonials_title_line_height']).'px';
		}

		if(isset($mkd_options['testimonials_title_letter_spacing']) && $mkd_options['testimonials_title_letter_spacing'] !== '') {
			$testimonials_title_styles[] = 'letter-spacing: '.intval($mkd_options['testimonials_title_letter_spacing']).'px';
		}

		if(isset($mkd_options['testimonials_title_font_weight']) && $mkd_options['testimonials_title_font_weight'] !== '') {
			$testimonials_title_styles[] = 'font-weight: '.intval($mkd_options['testimonials_title_font_weight']);
		}

		if(isset($mkd_options['testimonials_title_font_style']) && $mkd_options['testimonials_title_font_style'] !== '') {
			$testimonials_title_styles[] = 'font-style: '.$mkd_options['testimonials_title_font_style'];
		}

		if(isset($mkd_options['testimonials_title_text_transform']) && $mkd_options['testimonials_title_text_transform'] !== '') {
			$testimonials_title_styles[] = 'text-transform: '.$mkd_options['testimonials_title_text_transform'];
		}

		if(isset($mkd_options['testimonials_title_color']) && $mkd_options['testimonials_title_color'] !== '') {
			$testimonials_title_styles[] = 'color: '.$mkd_options['testimonials_title_color'];
		}

		if(is_array($testimonials_title_styles) && count($testimonials_title_styles)) { ?>
            .testimonials .testimonial_text_inner .testimonial_title{
			<?php echo esc_attr(implode(';', $testimonials_title_styles)); ?>
            }
		<?php } ?>


		<?php
		$testimonials_text_styles = array();

		if(isset($mkd_options['testimonials_text_font_family']) && $mkd_options['testimonials_text_font_family'] !== '-1') {
			$testimonials_text_styles[] = 'font-family: '.str_replace('+', ' ', $mkd_options['testimonials_text_font_family']).', sans-serif !important';
		}

		if(isset($mkd_options['testimonials_text_font_size']) && $mkd_options['testimonials_text_font_size'] !== '') {
			$testimonials_text_styles[] = 'font-size: '.intval($mkd_options['testimonials_text_font_size']).'px';
		}

		if(isset($mkd_options['testimonials_text_line_height']) && $mkd_options['testimonials_text_line_height'] !== '') {
			$testimonials_text_styles[] = 'line-height: '.intval($mkd_options['testimonials_text_line_height']).'px';
		}

		if(isset($mkd_options['testimonials_text_letter_spacing']) && $mkd_options['testimonials_text_letter_spacing'] !== '') {
			$testimonials_text_styles[] = 'letter-spacing: '.intval($mkd_options['testimonials_text_letter_spacing']).'px';
		}

		if(isset($mkd_options['testimonials_text_font_weight']) && $mkd_options['testimonials_text_font_weight'] !== '') {
			$testimonials_text_styles[] = 'font-weight: '.intval($mkd_options['testimonials_text_font_weight']);
		}

		if(isset($mkd_options['testimonials_text_font_style']) && $mkd_options['testimonials_text_font_style'] !== '') {
			$testimonials_text_styles[] = 'font-style: '.$mkd_options['testimonials_text_font_style'];
		}

		if(isset($mkd_options['testimonials_text_text_transform']) && $mkd_options['testimonials_text_text_transform'] !== '') {
			$testimonials_text_styles[] = 'text-transform: '.$mkd_options['testimonials_text_text_transform'];
		}

		if(isset($mkd_options['testimonials_text_color']) && $mkd_options['testimonials_text_color'] !== '') {
			$testimonials_text_styles[] = 'color: '.$mkd_options['testimonials_text_color'];
		}

		if(is_array($testimonials_text_styles) && count($testimonials_text_styles)) { ?>
            .testimonials .testimonial_text_inner .testimonial_text{
			<?php echo esc_attr(implode(';', $testimonials_text_styles)); ?>
            }
		<?php } ?>

		<?php
		$testimonials_author_styles = array();

		if(isset($mkd_options['testimonials_author_font_family']) && $mkd_options['testimonials_author_font_family'] !== '-1') {
			$testimonials_author_styles[] = 'font-family: '.str_replace('+', ' ', $mkd_options['testimonials_author_font_family']).', sans-serif';
		}

		if(isset($mkd_options['testimonials_author_font_size']) && $mkd_options['testimonials_author_font_size'] !== '') {
			$testimonials_author_styles[] = 'font-size: '.intval($mkd_options['testimonials_author_font_size']).'px';
		}

		if(isset($mkd_options['testimonials_author_line_height']) && $mkd_options['testimonials_author_line_height'] !== '') {
			$testimonials_author_styles[] = 'line-height: '.intval($mkd_options['testimonials_author_line_height']).'px';
		}

		if(isset($mkd_options['testimonials_author_letter_spacing']) && $mkd_options['testimonials_author_letter_spacing'] !== '') {
			$testimonials_author_styles[] = 'letter-spacing: '.intval($mkd_options['testimonials_author_letter_spacing']).'px';
		}

		if(isset($mkd_options['testimonials_author_font_weight']) && $mkd_options['testimonials_author_font_weight'] !== '') {
			$testimonials_author_styles[] = 'font-weight: '.intval($mkd_options['testimonials_author_font_weight']);
		}

		if(isset($mkd_options['testimonials_author_font_style']) && $mkd_options['testimonials_author_font_style'] !== '') {
			$testimonials_author_styles[] = 'font-style: '.$mkd_options['testimonials_author_font_style'];
		}

		if(isset($mkd_options['testimonials_author_text_transform']) && $mkd_options['testimonials_author_text_transform'] !== '') {
			$testimonials_author_styles[] = 'text-transform: '.$mkd_options['testimonials_author_text_transform'];
		}

		if(isset($mkd_options['testimonials_author_color']) && $mkd_options['testimonials_author_color'] !== '') {
			$testimonials_author_styles[] = 'color: '.$mkd_options['testimonials_author_color'];
		}

		if(is_array($testimonials_author_styles) && count($testimonials_author_styles)) { ?>
            .testimonials .testimonial_text_inner p.testimonial_author{
			<?php echo esc_attr(implode(';', $testimonials_author_styles)); ?>
            }
		<?php } ?>

		<?php
		$testimonials_navigation_button_style = array();
		if(isset($mkd_options['testimonials_navigation_width']) && $mkd_options['testimonials_navigation_width'] !== '') {
			$testimonials_navigation_button_style[] = 'width: '.intval($mkd_options['testimonials_navigation_width']).'px';
		}

		if(isset($mkd_options['testimonials_navigation_height']) && $mkd_options['testimonials_navigation_height'] !== '') {
			$testimonials_navigation_button_style[] = 'height: '.intval($mkd_options['testimonials_navigation_height']).'px';
		}

		if(is_array($testimonials_navigation_button_style) && count($testimonials_navigation_button_style)) { ?>
            .testimonials_holder .flex-control-paging li a{
			<?php echo esc_attr(implode(';', $testimonials_navigation_button_style)); ?>
            }
		<?php } ?>


		<?php
		$temp_transparency = '';
		$temp_rgb_color = '';
		$color_with_transparency = '';

		if ((isset($mkd_options['testimonials_navigation_active_color']) && !empty($mkd_options['testimonials_navigation_active_color'])) ) {
			$temp_rgb_color = mikado_one_mikado_hex2rgb($mkd_options['testimonials_navigation_active_color']);
			if (isset($mkd_options['testimonials_navigation_active_color_transparency']) && $mkd_options['testimonials_navigation_active_color_transparency']!=="") {
				$temp_transparency = $mkd_options['testimonials_navigation_active_color_transparency'];
			}
			else{ $temp_transparency = 1;}
			$color_with_transparency = 'rgba('.$temp_rgb_color[0].','.$temp_rgb_color[1].','.$temp_rgb_color[2].','.$temp_transparency.');'; ?>

            .testimonials_holder .flex-control-paging li a.flex-active,
            .testimonials_holder.light .flex-control-paging li a.flex-active{
            background-color: <?php echo esc_attr($color_with_transparency); ?>;
            }
		<?php } ?>

		<?php if (((isset($mkd_options['testimonials_navigation_border_radius']) && $mkd_options['testimonials_navigation_border_radius'] !== '')) || ((isset($mkd_options['testimonials_navigation_border_width']) && $mkd_options['testimonials_navigation_border_width'] !== ''))) { ?>
            .testimonials_holder .flex-control-paging li a{
            border-radius: <?php echo esc_attr($mkd_options['testimonials_navigation_border_radius']);  ?>px;
            border-width: <?php echo esc_attr($mkd_options['testimonials_navigation_border_width']);  ?>px;
            }
		<?php } ?>

		<?php
		$temp_transparency = '';
		$temp_rgb_color = '';
		$color_with_transparency = '';

		if ((isset($mkd_options['testimonials_navigation_color']) && !empty($mkd_options['testimonials_navigation_color'])) ) {
			$temp_rgb_color = mikado_one_mikado_hex2rgb($mkd_options['testimonials_navigation_color']);
			if (isset($mkd_options['testimonials_navigation_color_transparency']) && $mkd_options['testimonials_navigation_color_transparency']!=="") {
				$temp_transparency = $mkd_options['testimonials_navigation_color_transparency'];
			}
			else{ $temp_transparency = 1;}
			$color_with_transparency = 'rgba('.$temp_rgb_color[0].','.$temp_rgb_color[1].','.$temp_rgb_color[2].','.$temp_transparency.');'; ?>

            .testimonials_holder .flex-control-paging li a{
            background-color: <?php echo esc_attr($color_with_transparency); ?>;
            }
		<?php } ?>
		<?php
		$temp_transparency = '';
		$temp_rgb_color = '';
		$color_with_transparency = '';
		if ((isset($mkd_options['testimonials_navigation_border_color']) && !empty($mkd_options['testimonials_navigation_border_color'])) ) {
			$temp_rgb_color = mikado_one_mikado_hex2rgb($mkd_options['testimonials_navigation_border_color']);
			if (isset($mkd_options['testimonials_navigation_border_transparency']) && $mkd_options['testimonials_navigation_border_transparency']!=="") {
				$temp_transparency = $mkd_options['testimonials_navigation_border_transparency'];
			}
			else{ $temp_transparency = 1;}
			$color_with_transparency = 'rgba('.$temp_rgb_color[0].','.$temp_rgb_color[1].','.$temp_rgb_color[2].','.$temp_transparency.');'; ?>

            .testimonials_holder .flex-control-paging li a{
            border-color: <?php echo esc_attr($color_with_transparency); ?>;
            }
		<?php } ?>


		<?php
		$testimonials_arrows_color = '';
		$testimonials_arrows_border_color = '';

		if ((isset($mkd_options['testimonials_arrows_color']) && !empty($mkd_options['testimonials_arrows_color']))  || ((isset($mkd_options['testimonials_arrows_border_radius']) && $mkd_options['testimonials_arrows_border_radius'] !== '')) || ((isset($mkd_options['testimonials_arrows_border_width']) && $mkd_options['testimonials_arrows_border_width'] !== '')) || ((isset($mkd_options['testimonials_arrows_border_color']) && $mkd_options['testimonials_arrows_border_color'] !== ''))) {
			$temp_transparency = '';
			$temp_rgb_color = '';
			if ((isset($mkd_options['testimonials_arrows_color']) && !empty($mkd_options['testimonials_arrows_color']))) {
				$temp_rgb_color = mikado_one_mikado_hex2rgb($mkd_options['testimonials_arrows_color']);
				if(isset($mkd_options['testimonials_arrows_color_transparency']) && ($mkd_options['testimonials_arrows_color_transparency']!== '')) {
					$temp_transparency = $mkd_options['testimonials_arrows_color_transparency'];
				}
				else{
					$temp_transparency = 1;
				}
				$testimonials_arrows_color = 'rgba('.$temp_rgb_color[0].','.$temp_rgb_color[1].','.$temp_rgb_color[2].','.$temp_transparency.');';
			}
			$temp_transparency = '';
			$temp_rgb_color = '';
			if ((isset($mkd_options['testimonials_arrows_border_color']) && !empty($mkd_options['testimonials_arrows_border_color']))) {
				$temp_rgb_color = mikado_one_mikado_hex2rgb($mkd_options['testimonials_arrows_border_color']);
				if(isset($mkd_options['testimonials_arrows_border_transparency']) && ($mkd_options['testimonials_arrows_border_transparency']!== '')) {
					$temp_transparency = $mkd_options['testimonials_arrows_border_transparency'];
				}
				else{
					$temp_transparency = 1;
				}
				$testimonials_arrows_border_color = 'rgba('.$temp_rgb_color[0].','.$temp_rgb_color[1].','.$temp_rgb_color[2].','.$temp_transparency.');';
			} ?>

            .testimonials_holder .flex-direction-nav a{
            background-color: <?php echo esc_attr($testimonials_arrows_color); ?>;
            border-radius: <?php echo esc_attr($mkd_options['testimonials_arrows_border_radius']);  ?>px;
            border-width: <?php echo esc_attr($mkd_options['testimonials_arrows_border_width']);  ?>px;
            border-color: <?php echo esc_attr($testimonials_arrows_border_color);  ?>;
            }
		<?php } ?>

		<?php
		$temp_transparency = '';
		$temp_rgb_color = '';
		$color_with_transparency = '';
		if(isset($mkd_options['testimonials_arrows_border_hover_color']) && $mkd_options['testimonials_arrows_border_hover_color']!=='') {
			$temp_rgb_color = mikado_one_mikado_hex2rgb($mkd_options['testimonials_arrows_border_hover_color']);

			if(isset($mkd_options['testimonials_arrows_border_hover_transparency']) && ($mkd_options['testimonials_arrows_border_hover_transparency']!== '')) {
				$temp_transparency = $mkd_options['testimonials_arrows_border_hover_transparency'];
			}
			else{
				$temp_transparency = 1;
			}
			$color_with_transparency = 'rgba('.$temp_rgb_color[0].','.$temp_rgb_color[1].','.$temp_rgb_color[2].','.$temp_transparency.');';
			?>
            .testimonials_holder .flex-direction-nav a:hover{
            border-color: <?php echo esc_attr($color_with_transparency);  ?>;
            }
		<?php } ?>

		<?php

		$temp_transparency = '';
		$temp_rgb_color = '';
		$color_with_transparency = '';
		if ((isset($mkd_options['testimonials_arrows_icon_color']) && !empty($mkd_options['testimonials_arrows_icon_color']))) {
			$temp_rgb_color = mikado_one_mikado_hex2rgb($mkd_options['testimonials_arrows_icon_color']);
			if(isset($mkd_options['testimonials_arrows_transparency']) && ($mkd_options['testimonials_arrows_transparency']!== '')) {
				$temp_transparency = $mkd_options['testimonials_arrows_transparency'];
			}
			else{
				$temp_transparency = 1;
			}
			$color_with_transparency = 'rgba('.$temp_rgb_color[0].','.$temp_rgb_color[1].','.$temp_rgb_color[2].','.$temp_transparency.');'; ?>
            .testimonials_holder .flex-direction-nav a span:before{
            color: <?php echo esc_attr($color_with_transparency); ?>;
            }
		<?php } ?>

		<?php if ((isset($mkd_options['testimonials_arrows_size']) && ($mkd_options['testimonials_arrows_size'])!=='')) { ?>
            .testimonials_holder .flex-direction-nav a span:before{
            font-size: <?php echo esc_attr($mkd_options['testimonials_arrows_size']); ?>px;
            }
		<?php } ?>

		<?php
		$temp_transparency = '';
		$temp_rgb_color = '';
		$hover_color_with_transparency = '';
		if ((isset($mkd_options['testimonials_arrows_icon_hover_color']) && !empty($mkd_options['testimonials_arrows_icon_hover_color']))) {
			$temp_rgb_color = mikado_one_mikado_hex2rgb($mkd_options['testimonials_arrows_icon_hover_color']);
			if(isset($mkd_options['testimonials_arrows_hover_transparency']) && ($mkd_options['testimonials_arrows_hover_transparency']!== '')) {
				$temp_transparency = $mkd_options['testimonials_arrows_hover_transparency'];
			}
			else{
				$temp_transparency = 1;
			}
			$hover_color_with_transparency = 'rgba('.$temp_rgb_color[0].','.$temp_rgb_color[1].','.$temp_rgb_color[2].','.$temp_transparency.');'; ?>

            .testimonials_holder .flex-direction-nav a:hover span:before{
            color: <?php echo esc_attr($hover_color_with_transparency); ?>;
            }
		<?php } ?>

		<?php
		$temp_transparency = '';
		$temp_rgb_color = '';
		$hover_color_with_transparency = '';
		if ((isset($mkd_options['testimonials_arrows_active_color']) && !empty($mkd_options['testimonials_arrows_active_color'])) ) {

			$temp_rgb_color = mikado_one_mikado_hex2rgb($mkd_options['testimonials_arrows_active_color']);
			if(isset($mkd_options['testimonials_arrows_active_color_transparency']) && ($mkd_options['testimonials_arrows_active_color_transparency']!== '')) {
				$temp_transparency = $mkd_options['testimonials_arrows_active_color_transparency'];
			}
			else{
				$temp_transparency = 1;
			}
			$hover_color_with_transparency = 'rgba('.$temp_rgb_color[0].','.$temp_rgb_color[1].','.$temp_rgb_color[2].','.$temp_transparency.');'; ?>
            .testimonials_holder .flex-direction-nav a:hover{
            background-color: <?php echo esc_attr($hover_color_with_transparency); ?>;
            }
		<?php } ?>


		<?php
		$testimonials_arrow_button_style = array();
		$testimonials_arrow_margin ='';

		if(isset($mkd_options['testimonials_arrows_button_width']) && $mkd_options['testimonials_arrows_button_width'] !== '') {
			$testimonials_arrow_button_style[] = 'width: '.intval($mkd_options['testimonials_arrows_button_width']).'px';
		}

		if(isset($mkd_options['testimonials_arrows_button_height']) && $mkd_options['testimonials_arrows_button_height'] !== '') {
			$testimonials_arrow_button_style[] = 'height: '.intval($mkd_options['testimonials_arrows_button_height']).'px';
			$testimonials_arrow_button_style[] = 'line-height: '.intval($mkd_options['testimonials_arrows_button_height']).'px';
			$testimonials_arrow_margin = $mkd_options['testimonials_arrows_button_height']/2;
			$testimonials_arrow_margin = 'margin: -'.$testimonials_arrow_margin.'px 0 0 0';
		}

		if(is_array($testimonials_arrow_button_style) && count($testimonials_arrow_button_style)) { ?>
            .testimonials_holder .flex-direction-nav a,
            .testimonials_holder .flex-direction-nav a span,
            .testimonials_holder .flex-direction-nav a span:before{
			<?php echo esc_attr(implode(';', $testimonials_arrow_button_style)); ?>
            }
            .testimonials_holder .flex-direction-nav a{
			<?php echo esc_attr($testimonials_arrow_margin); ?>
            }
		<?php } ?>

		<?php if (!empty($mkd_options['counter_color']) || !empty($mkd_options['counters_fontweight']) || !empty($mkd_options['counters_font_size']) || (isset($mkd_options['counters_font_family']) && $mkd_options['counters_font_family'] != '-1')) { ?>
            .mkd_counter_holder span.counter{
			<?php if (!empty($mkd_options['counter_color'])) { ?>  color: <?php echo esc_attr($mkd_options['counter_color']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['counters_fontweight'])) { ?>    font-weight: <?php echo esc_attr($mkd_options['counters_fontweight']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['counters_font_size'])) { ?> font-size: <?php echo esc_attr($mkd_options['counters_font_size']);  ?>px; <?php } ?>
			<?php if ((isset($mkd_options['counters_font_family']) && $mkd_options['counters_font_family'] != '-1')) { ?>
				<?php $font = str_replace('+', ' ', $mkd_options['counters_font_family']); ?>
                font-family: '<?php echo esc_attr($font); ?>', sans-serif;
			<?php } ?>
            }
		<?php } ?>
		<?php if (!empty($mkd_options['counter_text_color']) || !empty($mkd_options['counters_text_fontweight']) || !empty($mkd_options['counters_text_texttransform']) || $mkd_options['counters_text_letterspacing'] !== '' || !empty($mkd_options['counters_text_font_size'])) { ?>
            .mkd_counter_holder p.counter_text{
			<?php if (!empty($mkd_options['counter_text_color'])) { ?> color: <?php echo esc_attr($mkd_options['counter_text_color']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['counters_text_fontweight'])) { ?>   font-weight: <?php echo esc_attr($mkd_options['counters_text_fontweight']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['counters_text_texttransform'])) { ?>    text-transform: <?php echo esc_attr($mkd_options['counters_text_texttransform']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['counters_text_letterspacing'])) { ?>    letter-spacing: <?php echo esc_attr($mkd_options['counters_text_letterspacing']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['counters_text_font_size'])) { ?>    font-size: <?php echo esc_attr($mkd_options['counters_text_font_size']);  ?>px; line-height: 1.25em; <?php } ?>
            }
		<?php } ?>
		<?php if (!empty($mkd_options['counter_separator_color'])) { ?>
            .wpb_column>.wpb_wrapper .mkd_counter_holder .separator{
			<?php if (!empty($mkd_options['counter_separator_color'])) { ?>    border-color: <?php echo esc_attr($mkd_options['counter_separator_color']);  ?>; <?php } ?>
            }
		<?php } ?>

		<?php
		$counters_title_styles = array();

		if(isset($mkd_options['counters_title_font_family']) && $mkd_options['counters_title_font_family'] !== '-1') {
			$counters_title_styles[] = 'font-family: '.str_replace('+', ' ', $mkd_options['counters_title_font_family']).', sans-serif';
		}

		if(isset($mkd_options['counters_title_font_size']) && $mkd_options['counters_title_font_size'] !== '') {
			$counters_title_styles[] = 'font-size: '.intval($mkd_options['counters_title_font_size']).'px';
		}

		if(isset($mkd_options['counters_title_line_height']) && $mkd_options['counters_title_line_height'] !== '') {
			$counters_title_styles[] = 'line-height: '.intval($mkd_options['counters_title_line_height']).'px';
		}

		if(isset($mkd_options['counters_title_letter_spacing']) && $mkd_options['counters_title_letter_spacing'] !== '') {
			$counters_title_styles[] = 'letter-spacing: '.intval($mkd_options['counters_title_letter_spacing']).'px';
		}

		if(isset($mkd_options['counters_title_font_weight']) && $mkd_options['counters_title_font_weight'] !== '') {
			$counters_title_styles[] = 'font-weight: '.intval($mkd_options['counters_title_font_weight']);
		}

		if(isset($mkd_options['counters_title_font_style']) && $mkd_options['counters_title_font_style'] !== '') {
			$counters_title_styles[] = 'font-style: '.$mkd_options['counters_title_font_style'];
		}

		if(isset($mkd_options['counters_title_text_transform']) && $mkd_options['counters_title_text_transform'] !== '') {
			$counters_title_styles[] = 'text-transform: '.$mkd_options['counters_title_text_transform'];
		}

		if(isset($mkd_options['counters_title_color']) && $mkd_options['counters_title_color'] !== '') {
			$counters_title_styles[] = 'color: '.$mkd_options['counters_title_color'];
		}

		if(is_array($counters_title_styles) && count($counters_title_styles)) { ?>
            .mkd_counter_holder .counter_title{
			<?php echo esc_attr(implode(';', $counters_title_styles)); ?>
            }
		<?php } ?>

		<?php
		$progress_bar_horizontal_title_style = array();

		if(isset($mkd_options['progress_bar_horizontal_font_family']) && $mkd_options['progress_bar_horizontal_font_family'] !== '-1') {
			$progress_bar_horizontal_title_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['progress_bar_horizontal_font_family']).', sans-serif';
		}

		if(isset($mkd_options['progress_bar_horizontal_font_size']) && $mkd_options['progress_bar_horizontal_font_size'] !== '') {
			$progress_bar_horizontal_title_style[] = 'font-size: '.intval($mkd_options['progress_bar_horizontal_font_size']).'px';
		}

		if(isset($mkd_options['progress_bar_horizontal_line_height']) && $mkd_options['progress_bar_horizontal_line_height'] !== '') {
			$progress_bar_horizontal_title_style[] = 'line-height: '.intval($mkd_options['progress_bar_horizontal_line_height']).'px';
		}

		if(isset($mkd_options['progress_bar_horizontal_letter_spacing']) && $mkd_options['progress_bar_horizontal_letter_spacing'] !== '') {
			$progress_bar_horizontal_title_style[] = 'letter-spacing: '.intval($mkd_options['progress_bar_horizontal_letter_spacing']).'px';
		}

		if(isset($mkd_options['progress_bar_horizontal_font_weight']) && $mkd_options['progress_bar_horizontal_font_weight'] !== '') {
			$progress_bar_horizontal_title_style[] = 'font-weight: '.intval($mkd_options['progress_bar_horizontal_font_weight']);
		}

		if(isset($mkd_options['progress_bar_horizontal_font_style']) && $mkd_options['progress_bar_horizontal_font_style'] !== '') {
			$progress_bar_horizontal_title_style[] = 'font-style: '.$mkd_options['progress_bar_horizontal_font_style'];
		}

		if(isset($mkd_options['progress_bar_horizontal_text_transform']) && $mkd_options['progress_bar_horizontal_text_transform'] !== '') {
			$progress_bar_horizontal_title_style[] = 'text-transform: '.$mkd_options['progress_bar_horizontal_text_transform'];
		}

		if(isset($mkd_options['progress_bar_horizontal_color']) && $mkd_options['progress_bar_horizontal_color'] !== '') {
			$progress_bar_horizontal_title_style[] = 'color: '.$mkd_options['progress_bar_horizontal_color'];
		}

		if(is_array($progress_bar_horizontal_title_style) && count($progress_bar_horizontal_title_style)) { ?>
            .mkd_progress_bar .progress_title{
			<?php echo esc_attr(implode(';', $progress_bar_horizontal_title_style)); ?>
            }
		<?php } ?>


		<?php
		$progress_bar_horizontal_percentage_percentage_style = array();

		if(isset($mkd_options['progress_bar_horizontal_percentage_font_family']) && $mkd_options['progress_bar_horizontal_percentage_font_family'] !== '-1') {
			$progress_bar_horizontal_percentage_percentage_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['progress_bar_horizontal_percentage_font_family']).', sans-serif';
		}

		if(isset($mkd_options['progress_bar_horizontal_percentage_font_size']) && $mkd_options['progress_bar_horizontal_percentage_font_size'] !== '') {
			$progress_bar_horizontal_percentage_percentage_style[] = 'font-size: '.intval($mkd_options['progress_bar_horizontal_percentage_font_size']).'px';
		}

		if(isset($mkd_options['progress_bar_horizontal_percentage_line_height']) && $mkd_options['progress_bar_horizontal_percentage_line_height'] !== '') {
			$progress_bar_horizontal_percentage_percentage_style[] = 'line-height: '.intval($mkd_options['progress_bar_horizontal_percentage_line_height']).'px';
			$progress_bar_horizontal_percentage_percentage_style[] = 'height: '.intval($mkd_options['progress_bar_horizontal_percentage_line_height']).'px';
		}

		if(isset($mkd_options['progress_bar_horizontal_percentage_letter_spacing']) && $mkd_options['progress_bar_horizontal_percentage_letter_spacing'] !== '') {
			$progress_bar_horizontal_percentage_percentage_style[] = 'letter-spacing: '.intval($mkd_options['progress_bar_horizontal_percentage_letter_spacing']).'px';
		}

		if(isset($mkd_options['progress_bar_horizontal_percentage_font_weight']) && $mkd_options['progress_bar_horizontal_percentage_font_weight'] !== '') {
			$progress_bar_horizontal_percentage_percentage_style[] = 'font-weight: '.intval($mkd_options['progress_bar_horizontal_percentage_font_weight']);
		}

		if(isset($mkd_options['progress_bar_horizontal_percentage_font_style']) && $mkd_options['progress_bar_horizontal_percentage_font_style'] !== '') {
			$progress_bar_horizontal_percentage_percentage_style[] = 'font-style: '.intval($mkd_options['progress_bar_horizontal_percentage_font_style']);
		}

		if(isset($mkd_options['progress_bar_horizontal_percentage_text_transform']) && $mkd_options['progress_bar_horizontal_percentage_text_transform'] !== '') {
			$progress_bar_horizontal_percentage_percentage_style[] = 'text-transform: '.$mkd_options['progress_bar_horizontal_percentage_text_transform'];
		}

		if(isset($mkd_options['progress_bar_horizontal_percentage_color']) && $mkd_options['progress_bar_horizontal_percentage_color'] !== '') {
			$progress_bar_horizontal_percentage_percentage_style[] = 'color: '.$mkd_options['progress_bar_horizontal_percentage_color'];
		}

		if(is_array($progress_bar_horizontal_percentage_percentage_style) && count($progress_bar_horizontal_percentage_percentage_style)) { ?>
            .mkd_progress_bar .progress_number_wrapper.static .progress_number{
			<?php echo esc_attr(implode(';', $progress_bar_horizontal_percentage_percentage_style)); ?>
            }
		<?php } ?>



		<?php if (!empty($mkd_options['pie_charts_fontsize']) || !empty($mkd_options['pie_charts_fontweight'])) { ?>
            .mkd_pie_chart_holder .tocounter{
			<?php if (!empty($mkd_options['pie_charts_fontsize'])) { ?>    font-size: <?php echo esc_attr($mkd_options['pie_charts_fontsize']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['pie_charts_fontweight'])) { ?>  font-weight: <?php echo esc_attr($mkd_options['pie_charts_fontweight']);  ?>; <?php } ?>
            }
		<?php } ?>

		<?php if (!empty($mkd_options['tabs_text_size']) || !empty($mkd_options['tabs_fontweight']) || !empty($mkd_options['tab_text_text_transform']) || (isset($mkd_options['tabs_nav_font_family']) && $mkd_options['tabs_nav_font_family'] != '-1') || !empty($mkd_options['tab_text_color']) || !empty($mkd_options['tab_background_color'])) { ?>
            .mkd_tabs .tabs-nav li a,
            .mkd_tabs.boxed .tabs-nav li a{
			<?php if (!empty($mkd_options['tabs_text_size'])) { ?>font-size: <?php echo esc_attr($mkd_options['tabs_text_size']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['tabs_fontweight'])) { ?>font-weight: <?php echo esc_attr($mkd_options['tabs_fontweight']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['tab_text_text_transform'])) { ?>text-transform: <?php echo esc_attr($mkd_options['tab_text_text_transform']);  ?>; <?php } ?>
			<?php if($mkd_options['tabs_nav_font_family'] != "-1"){ ?>
                font-family: '<?php echo esc_attr(str_replace('+', ' ', $mkd_options['tabs_nav_font_family'])); ?>', sans-serif;
			<?php } ?>
			<?php if (!empty($mkd_options['tab_text_color'])) { ?>color: <?php echo esc_attr($mkd_options['tab_text_color']);  ?>; <?php } ?>
            }
		<?php } ?>

		<?php if (!empty($mkd_options['tab_background_color'])) { ?>
            .mkd_tabs.boxed .tabs-nav li a{
			<?php if (!empty($mkd_options['tab_background_color'])) { ?>background-color: <?php echo esc_attr($mkd_options['tab_background_color']);  ?>; <?php } ?>
            }
		<?php } ?>

		<?php if (!empty($mkd_options['tab_active_text_color'])) { ?>
            .mkd_tabs .tabs-nav li.active a,
            .mkd_tabs .tabs-nav li a:hover,
            .mkd_tabs.boxed .tabs-nav li.active a,
            .mkd_tabs.boxed .tabs-nav li a:hover{
			<?php if (!empty($mkd_options['tab_active_text_color'])) { ?>color: <?php echo esc_attr($mkd_options['tab_active_text_color']);  ?>; <?php } ?>
            }
		<?php } ?>

		<?php if (!empty($mkd_options['tab_active_background_color'])) { ?>
            .mkd_tabs.boxed .tabs-nav li.active a,
            .mkd_tabs.boxed .tabs-nav li a:hover{
			<?php if (!empty($mkd_options['tab_active_background_color'])) { ?>background-color: <?php echo esc_attr($mkd_options['tab_active_background_color']);  ?>; <?php } ?>
            }
		<?php } ?>

		<?php if ( !empty($mkd_options['tabs_content_text_size']) || !empty($mkd_options['tabs_content_background_color'])) { ?>
            .mkd_tabs .tabs-container{
			<?php if (!empty($mkd_options['tabs_content_text_size'])) { ?>font-size: <?php echo esc_attr($mkd_options['tabs_content_text_size']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['tabs_content_background_color'])) { ?>background-color: <?php echo esc_attr($mkd_options['tabs_content_background_color']);  ?>; <?php } ?>
            }
		<?php } ?>

		<?php if ((isset($mkd_options['tabs_icon_size']) && $mkd_options['tabs_icon_size'] != '') || !empty($mkd_options['tab_icon_color'])) { ?>
            .mkd_tabs.icon .tabs-nav li a{
			<?php if (isset($mkd_options['tabs_icon_size']) && $mkd_options['tabs_icon_size'] != '') { ?>font-size: <?php echo esc_attr($mkd_options['tabs_icon_size']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['tab_icon_color'])) { ?>color: <?php echo esc_attr($mkd_options['tab_icon_color']);  ?>; <?php } ?>
            }
		<?php } ?>

		<?php if (!empty($mkd_options['tab_icon_hover_color'])) { ?>
            .mkd_tabs.icon .tabs-nav li.active a, .mkd_tabs.icon .tabs-nav li a:hover{
            color: <?php echo esc_attr($mkd_options['tab_icon_hover_color']);  ?>;
            }
		<?php } ?>

		<?php if ((isset($mkd_options['tabs_icon_shape_border_thickness']) && $mkd_options['tabs_icon_shape_border_thickness'] != '') || !empty($mkd_options['tabs_icon_shape_border_color']) || (isset($mkd_options['tabs_icon_shape_border_width']) && $mkd_options['tabs_icon_shape_border_width'] != '-1')) { ?>

			<?php if (!empty($mkd_options['tabs_icon_shape_border_color']) || (isset($mkd_options['tabs_icon_shape_border_thickness']) && $mkd_options['tabs_icon_shape_border_thickness'] != '')){?>
                .mkd_tabs.icon .tabs-nav li{
				<?php if (isset($mkd_options['tabs_icon_shape_border_thickness']) && $mkd_options['tabs_icon_shape_border_thickness'] != ''){?>border-width: <?php echo esc_attr($mkd_options['tabs_icon_shape_border_thickness']);?>px; <?php }?>
				<?php if (!empty($mkd_options['tabs_icon_shape_border_color'])){ ?> border-color: <?php echo esc_attr($mkd_options['tabs_icon_shape_border_color']);?>; <?php }?>
                }
			<?php } ?>

			<?php if ((isset($mkd_options['tabs_icon_shape_border_width']) && $mkd_options['tabs_icon_shape_border_width'] != '') || (isset($mkd_options['tabs_icon_shape_border_thickness']) && $mkd_options['tabs_icon_shape_border_thickness'] != '') || !empty($mkd_options['tabs_icon_shape_border_color'])){?>
                .mkd_tabs.icon .tabs-nav li:first-child:before,
                .mkd_tabs.icon .tabs-nav li:first-child:after,
                .mkd_tabs.icon .tabs-nav li:last-child:before,
                .mkd_tabs.icon .tabs-nav li:last-child:after{
				<?php if (isset($mkd_options['tabs_icon_shape_border_thickness']) && $mkd_options['tabs_icon_shape_border_thickness'] != ''){?>border-width: <?php echo esc_attr($mkd_options['tabs_icon_shape_border_thickness']);?>px; <?php }?>
				<?php if (!empty($mkd_options['tabs_icon_shape_border_color'])){ ?> border-color: <?php echo esc_attr($mkd_options['tabs_icon_shape_border_color']);?>; <?php }?>
				<?php if (isset($mkd_options['tabs_icon_shape_border_width']) && $mkd_options['tabs_icon_shape_border_width'] != ''){?>height: <?php echo esc_attr($mkd_options['tabs_icon_shape_border_width']);?>px; <?php }?>
                }
			<?php } ?>

			<?php if ((isset($mkd_options['tabs_icon_shape_border_width']) && $mkd_options['tabs_icon_shape_border_width'] != '')){?>
                .mkd_tabs.icon .tabs-nav li:first-child:before,
                .mkd_tabs.icon .tabs-nav li:first-child:after{
                top: -<?php echo esc_attr($mkd_options['tabs_icon_shape_border_width']);?>px;
                }

                .mkd_tabs.icon .tabs-nav li:last-child:before,
                .mkd_tabs.icon .tabs-nav li:last-child:after{
                bottom: -<?php echo esc_attr($mkd_options['tabs_icon_shape_border_width']);?>px;
                }
			<?php } ?>

			<?php if ((isset($mkd_options['tabs_icon_shape_border_thickness']) && $mkd_options['tabs_icon_shape_border_thickness'] != '')){?>
                .mkd_tabs.icon .tabs-nav li:first-child:before,
                .mkd_tabs.icon .tabs-nav li:last-child:before{
                left: -<?php echo esc_attr($mkd_options['tabs_icon_shape_border_thickness']);?>px;
                }

                .mkd_tabs.icon .tabs-nav li:first-child:after,
                .mkd_tabs.icon .tabs-nav li:last-child:after{
                right: -<?php echo esc_attr($mkd_options['tabs_icon_shape_border_thickness']);?>px;
                }
			<?php } ?>


            /* left and right border
            a elements are used for left and right top margin
            tabs-nav are used for left and right bottom margin on last li element
            */

			<?php if ((isset($mkd_options['tabs_icon_shape_border_width']) && $mkd_options['tabs_icon_shape_border_width'] != '') || (isset($mkd_options['tabs_icon_shape_border_thickness']) && $mkd_options['tabs_icon_shape_border_thickness'] != '') || !empty($mkd_options['tabs_icon_shape_border_color'])){?>
                .mkd_tabs.icon .tabs-nav li a:before,
                .mkd_tabs.icon .tabs-nav li a:after,
                .mkd_tabs.icon .tabs-nav li:last-child a .icon_frame:before,
                .mkd_tabs.icon .tabs-nav li:last-child a .icon_frame:after{
				<?php if (isset($mkd_options['tabs_icon_shape_border_thickness']) && $mkd_options['tabs_icon_shape_border_thickness'] != ''){?>border-width: <?php echo esc_attr($mkd_options['tabs_icon_shape_border_thickness']);?>px; <?php }?>
				<?php if (!empty($mkd_options['tabs_icon_shape_border_color'])){ ?> border-color: <?php echo esc_attr($mkd_options['tabs_icon_shape_border_color']);?>; <?php }?>
				<?php if (isset($mkd_options['tabs_icon_shape_border_width']) && $mkd_options['tabs_icon_shape_border_width'] != ''){?>width: <?php echo esc_attr($mkd_options['tabs_icon_shape_border_width']);?>px; <?php }?>
                }
			<?php } ?>

			<?php if ((isset($mkd_options['tabs_icon_shape_border_thickness']) && $mkd_options['tabs_icon_shape_border_thickness'] != '')){?>
                .mkd_tabs.icon .tabs-nav li a:before,
                .mkd_tabs.icon .tabs-nav li a:after{
                top: -<?php echo esc_attr($mkd_options['tabs_icon_shape_border_thickness']);?>px;
                }
			<?php } ?>

			<?php if ((isset($mkd_options['tabs_icon_shape_border_thickness']) && $mkd_options['tabs_icon_shape_border_thickness'] != '')){?>
                .mkd_tabs.icon .tabs-nav li:last-child a .icon_frame:before,
                .mkd_tabs.icon .tabs-nav li:last-child a .icon_frame:after{
                bottom: -<?php echo esc_attr($mkd_options['tabs_icon_shape_border_thickness']);?>px;
                }
			<?php } ?>

			<?php if ((isset($mkd_options['tabs_icon_shape_border_width']) && $mkd_options['tabs_icon_shape_border_width'] != '')){?>
                .mkd_tabs.icon .tabs-nav li a:before,
                .mkd_tabs.icon .tabs-nav li:last-child a .icon_frame:before{
                left: -<?php echo esc_attr($mkd_options['tabs_icon_shape_border_width']);?>px;
                }

                .mkd_tabs.icon .tabs-nav li a:after,
                .mkd_tabs.icon .tabs-nav li:last-child a .icon_frame:after{
                right: -<?php echo esc_attr($mkd_options['tabs_icon_shape_border_width']);?>px;
                }
			<?php } ?>

		<?php } ?>


		<?php if (!empty($mkd_options['footer_border_columns_color'])) { ?>
            footer.footer_border_columns .footer_top .mkd_column{
            border-color:<?php echo esc_attr($mkd_options['footer_border_columns_color']); ?>;
            }
		<?php } ?>

		<?php if (!empty($mkd_options['footer_top_background_color'])) { ?>
            .footer_top_holder{
            background-color:<?php echo esc_attr($mkd_options['footer_top_background_color']); ?>;
            }
		<?php } ?>

		<?php if (isset($mkd_options['footer_image_background']) && $mkd_options['footer_image_background'] != ""){ ?>
            .footer_top_holder{
            background-image:url(<?php echo esc_url($mkd_options['footer_image_background']); ?>);
            }
		<?php } ?>

		<?php if ((isset($mkd_options['footer_top_padding']) && $mkd_options['footer_top_padding'] !== '') || (isset($mkd_options['footer_bottom_padding']) && $mkd_options['footer_bottom_padding'] !== '')) { ?>
            .footer_top, .footer_top.footer_top_full{
			<?php if (isset($mkd_options['footer_top_padding']) && $mkd_options['footer_top_padding'] !== ''){ ?>padding-top: <?php echo esc_attr($mkd_options['footer_top_padding']); ?>px; <?php } ?>
			<?php if (isset($mkd_options['footer_bottom_padding']) && $mkd_options['footer_bottom_padding'] !== ''){ ?>padding-bottom: <?php echo esc_attr($mkd_options['footer_bottom_padding']); ?>px; <?php } ?>
            }
		<?php } ?>
		<?php if ((isset($mkd_options['footer_left_padding']) && $mkd_options['footer_left_padding'] !== '') || (isset($mkd_options['footer_right_padding']) && $mkd_options['footer_right_padding'] !== '')) { ?>
            @media only screen and (min-width: 600px){
            .footer_top, .footer_top.footer_top_full{
			<?php if (isset($mkd_options['footer_left_padding']) && $mkd_options['footer_left_padding'] !== ''){ ?>padding-left: <?php echo esc_attr($mkd_options['footer_left_padding']); ?>px; <?php } ?>
			<?php if (isset($mkd_options['footer_right_padding']) && $mkd_options['footer_right_padding'] !== ''){ ?>padding-right: <?php echo esc_attr($mkd_options['footer_right_padding']); ?>px; <?php } ?>
            }
            }
		<?php } ?>
		<?php if (isset($mkd_options['footer_top_columns_alignment']) && $mkd_options['footer_top_columns_alignment'] !== '') { ?>
            @media only screen and (min-width: 600px){
            .footer_top, .mkd_column{
            text-align:  <?php echo esc_attr($mkd_options['footer_top_columns_alignment']);  ?>
            }
            }
		<?php } ?>

		<?php
		$footer_top_text_style = array();

		if(isset($mkd_options['footer_top_text_font_family']) && $mkd_options['footer_top_text_font_family'] !== '-1') {
			$footer_top_text_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['footer_top_text_font_family']).', sans-serif';
		}

		if(isset($mkd_options['footer_top_text_font_size']) && $mkd_options['footer_top_text_font_size'] !== '') {
			$footer_top_text_style[] = 'font-size: '.intval($mkd_options['footer_top_text_font_size']).'px';
		}

		if(isset($mkd_options['footer_top_text_line_height']) && $mkd_options['footer_top_text_line_height'] !== '') {
			$footer_top_text_style[] = 'line-height: '.intval($mkd_options['footer_top_text_line_height']).'px';
		}

		if(isset($mkd_options['footer_top_text_letter_spacing']) && $mkd_options['footer_top_text_letter_spacing'] !== '') {
			$footer_top_text_style[] = 'letter-spacing: '.intval($mkd_options['footer_top_text_letter_spacing']).'px';
		}

		if(isset($mkd_options['footer_top_text_font_weight']) && $mkd_options['footer_top_text_font_weight'] !== '') {
			$footer_top_text_style[] = 'font-weight: '.intval($mkd_options['footer_top_text_font_weight']);
		}

		if(isset($mkd_options['footer_top_text_font_style']) && $mkd_options['footer_top_text_font_style'] !== '') {
			$footer_top_text_style[] = 'font-style: '.$mkd_options['footer_top_text_font_style'];
		}

		if(isset($mkd_options['footer_top_text_text_transform']) && $mkd_options['footer_top_text_text_transform'] !== '') {
			$footer_top_text_style[] = 'text-transform: '.$mkd_options['footer_top_text_text_transform'];
		}

		if(isset($mkd_options['footer_top_text_color']) && $mkd_options['footer_top_text_color'] !== '') {
			$footer_top_text_style[] = 'color: '.$mkd_options['footer_top_text_color'];
		}

		if(is_array($footer_top_text_style) && count($footer_top_text_style)) { ?>
            .footer_top,
            .footer_top p,
            .footer_top span:not(.mkd_social_icon_holder):not(.fa-stack):not(.social_icon):not(.mkd_icon_shortcode),
            .footer_top li,
            .footer_top .textwidget,
            .footer_top .widget_recent_entries>ul>li>span,
            footer .widget_calendar {
			<?php echo esc_attr(implode(';', $footer_top_text_style)); ?>
            }
		<?php } ?>

		<?php
		$footer_top_link_style = array();

		if(isset($mkd_options['footer_top_link_font_family']) && $mkd_options['footer_top_link_font_family'] !== '-1') {
			$footer_top_link_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['footer_top_link_font_family']).', sans-serif';
		}

		if(isset($mkd_options['footer_top_link_font_size']) && $mkd_options['footer_top_link_font_size'] !== '') {
			$footer_top_link_style[] = 'font-size: '.intval($mkd_options['footer_top_link_font_size']).'px';
		}

		if(isset($mkd_options['footer_top_link_line_height']) && $mkd_options['footer_top_link_line_height'] !== '') {
			$footer_top_link_style[] = 'line-height: '.intval($mkd_options['footer_top_link_line_height']).'px';
		}

		if(isset($mkd_options['footer_top_link_letter_spacing']) && $mkd_options['footer_top_link_letter_spacing'] !== '') {
			$footer_top_link_style[] = 'letter-spacing: '.intval($mkd_options['footer_top_link_letter_spacing']).'px';
		}

		if(isset($mkd_options['footer_top_link_font_weight']) && $mkd_options['footer_top_link_font_weight'] !== '') {
			$footer_top_link_style[] = 'font-weight: '.intval($mkd_options['footer_top_link_font_weight']);
		}

		if(isset($mkd_options['footer_top_link_font_style']) && $mkd_options['footer_top_link_font_style'] !== '') {
			$footer_top_link_style[] = 'font-style: '.$mkd_options['footer_top_link_font_style'];
		}

		if(isset($mkd_options['footer_top_link_text_transform']) && $mkd_options['footer_top_link_text_transform'] !== '') {
			$footer_top_link_style[] = 'text-transform: '.$mkd_options['footer_top_link_text_transform'];
		}

		if(isset($mkd_options['footer_top_link_color']) && $mkd_options['footer_top_link_color'] !== '') {
			$footer_top_link_style[] = 'color: '.$mkd_options['footer_top_link_color'];
		}

		if(is_array($footer_top_link_style) && count($footer_top_link_style)) { ?>
            .footer_top a{
			<?php echo esc_attr(implode(';', $footer_top_link_style)); ?>
            }
		<?php } ?>

		<?php if (isset($mkd_options['footer_top_link_hover_color']) && !empty($mkd_options['footer_top_link_hover_color'])) { ?>
            .footer_top a:hover{
            color: <?php echo esc_attr($mkd_options['footer_top_link_hover_color']); ?>;
            }
		<?php } ?>

		<?php if (!empty($mkd_options['footer_bottom_background_color'])) { ?>
            .footer_bottom_holder{
            background-color:<?php echo esc_attr($mkd_options['footer_bottom_background_color']); ?>;
            }
            .footer_top_holder svg.oblique-section polygon{
            fill:<?php echo esc_attr($mkd_options['footer_bottom_background_color']); ?>;
            }
		<?php } ?>

		<?php if (isset($mkd_options['footer_bottom_image_background']) && $mkd_options['footer_bottom_image_background'] != ""){ ?>
            .footer_bottom_holder{
            background-image:url(<?php echo esc_url($mkd_options['footer_bottom_image_background']); ?>);
            }
		<?php } ?>

		<?php if ((isset($mkd_options['footer_bottom_top_padding']) && $mkd_options['footer_bottom_top_padding'] !== '') || (isset($mkd_options['footer_bottom_bottom_padding']) && $mkd_options['footer_bottom_bottom_padding'] !== '')) { ?>
            .footer_bottom_holder_inner{
			<?php if (isset($mkd_options['footer_bottom_top_padding']) && $mkd_options['footer_bottom_top_padding'] !== ''){ ?>padding-top: <?php echo esc_attr($mkd_options['footer_bottom_top_padding']); ?>px; <?php } ?>
			<?php if (isset($mkd_options['footer_bottom_bottom_padding']) && $mkd_options['footer_bottom_bottom_padding'] !== ''){ ?>padding-bottom: <?php echo esc_attr($mkd_options['footer_bottom_bottom_padding']); ?>px; <?php } ?>
            }
		<?php } ?>
		<?php if ((isset($mkd_options['footer_bottom_left_padding']) && $mkd_options['footer_bottom_left_padding'] !== '') || (isset($mkd_options['footer_bottom_right_padding']) && $mkd_options['footer_bottom_right_padding'] !== '')) { ?>
            @media only screen and (min-width: 600px){
            .footer_bottom_holder_inner{
			<?php if (isset($mkd_options['footer_bottom_left_padding']) && $mkd_options['footer_bottom_left_padding'] !== ''){ ?>padding-left: <?php echo esc_attr($mkd_options['footer_bottom_left_padding']); ?>px; <?php } ?>
			<?php if (isset($mkd_options['footer_bottom_right_padding']) && $mkd_options['footer_bottom_right_padding'] !== ''){ ?>padding-right: <?php echo esc_attr($mkd_options['footer_bottom_right_padding']); ?>px; <?php } ?>
            }
            }
		<?php } ?>

		<?php
		$footer_bottom_text_style = array();

		if(isset($mkd_options['footer_bottom_text_font_family']) && $mkd_options['footer_bottom_text_font_family'] !== '-1') {
			$footer_bottom_text_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['footer_bottom_text_font_family']).', sans-serif';
		}

		if(isset($mkd_options['footer_bottom_text_font_size']) && $mkd_options['footer_bottom_text_font_size'] !== '') {
			$footer_bottom_text_style[] = 'font-size: '.intval($mkd_options['footer_bottom_text_font_size']).'px';
		}

		if(isset($mkd_options['footer_bottom_text_line_height']) && $mkd_options['footer_bottom_text_line_height'] !== '') {
			$footer_bottom_text_style[] = 'line-height: '.intval($mkd_options['footer_bottom_text_line_height']).'px';
		}

		if(isset($mkd_options['footer_bottom_text_letter_spacing']) && $mkd_options['footer_bottom_text_letter_spacing'] !== '') {
			$footer_bottom_text_style[] = 'letter-spacing: '.intval($mkd_options['footer_bottom_text_letter_spacing']).'px';
		}

		if(isset($mkd_options['footer_bottom_text_font_weight']) && $mkd_options['footer_bottom_text_font_weight'] !== '') {
			$footer_bottom_text_style[] = 'font-weight: '.intval($mkd_options['footer_bottom_text_font_weight']);
		}

		if(isset($mkd_options['footer_bottom_text_font_style']) && $mkd_options['footer_bottom_text_font_style'] !== '') {
			$footer_bottom_text_style[] = 'font-style: '.$mkd_options['footer_bottom_text_font_style'];
		}

		if(isset($mkd_options['footer_bottom_text_text_transform']) && $mkd_options['footer_bottom_text_text_transform'] !== '') {
			$footer_bottom_text_style[] = 'text-transform: '.$mkd_options['footer_bottom_text_text_transform'];
		}

		if(isset($mkd_options['footer_bottom_text_color']) && $mkd_options['footer_bottom_text_color'] !== '') {
			$footer_bottom_text_style[] = 'color: '.$mkd_options['footer_bottom_text_color'];
		}

		if(is_array($footer_bottom_text_style) && count($footer_bottom_text_style)) { ?>

            .footer_bottom_holder_inner,
            .footer_bottom_holder_inner ul li a,
            .footer_bottom_holder_inner p,
            .footer_bottom_holder_inner span,
            .footer_bottom span:not(.mkd_social_icon_holder):not(.fa-stack):not(.social_icon){
			<?php echo esc_attr(implode(';', $footer_bottom_text_style)); ?>
            }
		<?php } ?>

		<?php
		$footer_bottom_link_style = array();

		if(isset($mkd_options['footer_bottom_link_font_family']) && $mkd_options['footer_bottom_link_font_family'] !== '-1') {
			$footer_bottom_link_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['footer_bottom_link_font_family']).', sans-serif';
		}

		if(isset($mkd_options['footer_bottom_link_font_size']) && $mkd_options['footer_bottom_link_font_size'] !== '') {
			$footer_bottom_link_style[] = 'font-size: '.intval($mkd_options['footer_bottom_link_font_size']).'px';
		}

		if(isset($mkd_options['footer_bottom_link_line_height']) && $mkd_options['footer_bottom_link_line_height'] !== '') {
			$footer_bottom_link_style[] = 'line-height: '.intval($mkd_options['footer_bottom_link_line_height']).'px';
		}

		if(isset($mkd_options['footer_bottom_link_letter_spacing']) && $mkd_options['footer_bottom_link_letter_spacing'] !== '') {
			$footer_bottom_link_style[] = 'letter-spacing: '.intval($mkd_options['footer_bottom_link_letter_spacing']).'px';
		}

		if(isset($mkd_options['footer_bottom_link_font_weight']) && $mkd_options['footer_bottom_link_font_weight'] !== '') {
			$footer_bottom_link_style[] = 'font-weight: '.intval($mkd_options['footer_bottom_link_font_weight']);
		}

		if(isset($mkd_options['footer_bottom_link_font_style']) && $mkd_options['footer_bottom_link_font_style'] !== '') {
			$footer_bottom_link_style[] = 'font-style: '.$mkd_options['footer_bottom_link_font_style'];
		}

		if(isset($mkd_options['footer_bottom_link_text_transform']) && $mkd_options['footer_bottom_link_text_transform'] !== '') {
			$footer_bottom_link_style[] = 'text-transform: '.$mkd_options['footer_bottom_link_text_transform'];
		}

		if(isset($mkd_options['footer_bottom_link_color']) && $mkd_options['footer_bottom_link_color'] !== '') {
			$footer_bottom_link_style[] = 'color: '.$mkd_options['footer_bottom_link_color'];
		}

		if(is_array($footer_bottom_link_style) && count($footer_bottom_link_style)) { ?>
            .footer_bottom_holder_inner a,
            .footer_bottom_holder_inner ul li a{
			<?php echo esc_attr(implode(';', $footer_bottom_link_style)); ?>
            }
		<?php } ?>

		<?php if (isset($mkd_options['footer_bottom_link_hover_color']) && !empty($mkd_options['footer_bottom_link_hover_color'])) { ?>
            .footer_bottom_holder_inner a:hover,
            .footer_bottom_holder_inner ul li a:hover{
            color:<?php echo esc_attr($mkd_options['footer_bottom_link_hover_color']);  ?>; !important;
            }
		<?php } ?>

		<?php
		$footer_title_styles = array();

		if(isset($mkd_options['footer_title_font_family']) && $mkd_options['footer_title_font_family'] !== '-1') {
			$footer_title_styles[] = 'font-family: '.str_replace('+', ' ', $mkd_options['footer_title_font_family']).', sans-serif';
		}

		if(isset($mkd_options['footer_title_font_size']) && $mkd_options['footer_title_font_size'] !== '') {
			$footer_title_styles[] = 'font-size: '.intval($mkd_options['footer_title_font_size']).'px';
		}

		if(isset($mkd_options['footer_title_line_height']) && $mkd_options['footer_title_line_height'] !== '') {
			$footer_title_styles[] = 'line-height: '.intval($mkd_options['footer_title_line_height']).'px';
		}

		if(isset($mkd_options['footer_title_letter_spacing']) && $mkd_options['footer_title_letter_spacing'] !== '') {
			$footer_title_styles[] = 'letter-spacing: '.intval($mkd_options['footer_title_letter_spacing']).'px';
		}

		if(isset($mkd_options['footer_title_font_weight']) && $mkd_options['footer_title_font_weight'] !== '') {
			$footer_title_styles[] = 'font-weight: '.intval($mkd_options['footer_title_font_weight']);
		}

		if(isset($mkd_options['footer_title_font_style']) && $mkd_options['footer_title_font_style'] !== '') {
			$footer_title_styles[] = 'font-style: '.$mkd_options['footer_title_font_style'];
		}

		if(isset($mkd_options['footer_title_text_transform']) && $mkd_options['footer_title_text_transform'] !== '') {
			$footer_title_styles[] = 'text-transform: '.$mkd_options['footer_title_text_transform'];
		}

		if(isset($mkd_options['footer_title_color']) && $mkd_options['footer_title_color'] !== '') {
			$footer_title_styles[] = 'color: '.$mkd_options['footer_title_color'];
		}

		if(is_array($footer_title_styles) && count($footer_title_styles)) { ?>
            .footer_top .widget h4 {
			<?php echo esc_attr(implode(';', $footer_title_styles)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['footer_bottom_height']) && $mkd_options['footer_bottom_height'] !== '') { ?>
            .footer_bottom_holder { height: <?php echo esc_attr($mkd_options['footer_bottom_height']); ?>px; }
		<?php } ?>

		<?php if (!empty($mkd_options['content_bottom_background_color'])) { ?>
            .content_bottom{
            background-color:<?php echo esc_attr($mkd_options['content_bottom_background_color']);  ?>;
            }
		<?php } ?>

		<?php if (isset($mkd_options['sidebar_title_background']) && !empty($mkd_options['sidebar_title_background'])) { ?>
            aside.sidebar .widget h4{
            background-color:<?php echo esc_attr($mkd_options['sidebar_title_background']);  ?>;
            }
		<?php } ?>

		<?php if (isset($mkd_options['sidebar_title_border_color']) && !empty($mkd_options['sidebar_title_border_color'])) { ?>
            aside.sidebar .widget h4{
            border: 1px solid <?php echo esc_attr($mkd_options['sidebar_title_border_color']);  ?>;
            }
		<?php } ?>
		<?php
		$sidebar_styles = array();

		if(isset($mkd_options['sidebar_background_color']) && $mkd_options['sidebar_background_color'] !== '') {
			$sidebar_styles[] = 'background-color:  '.$mkd_options['sidebar_background_color'];
		}

		if(isset($mkd_options['sidebar_alignment']) && $mkd_options['sidebar_alignment'] !== '') {
			$sidebar_styles[] = 'text-align: '.$mkd_options['sidebar_alignment'];
		}

		if(is_array($sidebar_styles) && count($sidebar_styles)) { ?>
            aside.sidebar{
			<?php echo esc_attr(implode(';', $sidebar_styles)); ?>
            }
		<?php } ?>
		<?php
		$widget_styles = array();

		if(isset($mkd_options['widget_background_color']) && $mkd_options['widget_background_color'] !== '') {
			$widget_styles[] = 'background-color:  '.$mkd_options['widget_background_color'];
		}

		if(isset($mkd_options['widget_border_color']) && $mkd_options['widget_border_color'] !== '') {
			$widget_styles[] = 'border: 1px solid '.$mkd_options['widget_border_color'];
		}

		if(isset($mkd_options['widget_padding_top']) && $mkd_options['widget_padding_top'] !== '') {
			$widget_styles[] = 'padding-top:'.intval($mkd_options['widget_padding_top']).'px';
		}

		if(isset($mkd_options['widget_padding_right']) && $mkd_options['widget_padding_right'] !== '') {
			$widget_styles[] = 'padding-right:'.intval($mkd_options['widget_padding_right']).'px';
		}

		if(isset($mkd_options['widget_padding_bottom']) && $mkd_options['widget_padding_bottom'] !== '') {
			$widget_styles[] = 'padding-bottom:'.intval($mkd_options['widget_padding_bottom']).'px';
		}

		if(isset($mkd_options['widget_padding_left']) && $mkd_options['widget_padding_left'] !== '') {
			$widget_styles[] = 'padding-left:'.intval($mkd_options['widget_padding_left']).'px';
		}


		if(is_array($widget_styles) && count($widget_styles)) { ?>
            aside.sidebar .widget{
			<?php echo esc_attr(implode(';', $widget_styles)); ?>
            }
		<?php } ?>
		<?php
		$sidebar_title_styles = array();

		if(isset($mkd_options['sidebar_title_font_family']) && $mkd_options['sidebar_title_font_family'] !== '-1') {
			$sidebar_title_styles[] = 'font-family: '.str_replace('+', ' ', $mkd_options['sidebar_title_font_family']).', sans-serif';
		}

		if(isset($mkd_options['sidebar_title_font_size']) && $mkd_options['sidebar_title_font_size'] !== '') {
			$sidebar_title_styles[] = 'font-size: '.intval($mkd_options['sidebar_title_font_size']).'px';
		}

		if(isset($mkd_options['sidebar_title_line_height']) && $mkd_options['sidebar_title_line_height'] !== '') {
			$sidebar_title_styles[] = 'line-height: '.intval($mkd_options['sidebar_title_line_height']).'px';
		}

		if(isset($mkd_options['sidebar_title_letter_spacing']) && $mkd_options['sidebar_title_letter_spacing'] !== '') {
			$sidebar_title_styles[] = 'letter-spacing: '.intval($mkd_options['sidebar_title_letter_spacing']).'px';
		}

		if(isset($mkd_options['sidebar_title_font_weight']) && $mkd_options['sidebar_title_font_weight'] !== '') {
			$sidebar_title_styles[] = 'font-weight: '.intval($mkd_options['sidebar_title_font_weight']);
		}

		if(isset($mkd_options['sidebar_title_font_style']) && $mkd_options['sidebar_title_font_style'] !== '') {
			$sidebar_title_styles[] = 'font-style: '.$mkd_options['sidebar_title_font_style'];
		}

		if(isset($mkd_options['sidebar_title_text_transform']) && $mkd_options['sidebar_title_text_transform'] !== '') {
			$sidebar_title_styles[] = 'text-transform: '.$mkd_options['sidebar_title_text_transform'];
		}

		if(isset($mkd_options['sidebar_title_color']) && $mkd_options['sidebar_title_color'] !== '') {
			$sidebar_title_styles[] = 'color: '.$mkd_options['sidebar_title_color'];
		}

		if(is_array($sidebar_title_styles) && count($sidebar_title_styles)) { ?>
            aside.sidebar .widget h4,
            .woocommerce aside.sidebar .widget h4{
			<?php echo esc_attr(implode(';', $sidebar_title_styles)); ?>
            }
		<?php } ?>

		<?php
		$sidebar_link_styles = array();

		if(isset($mkd_options['sidebar_link_font_family']) && $mkd_options['sidebar_link_font_family'] !== '-1') {
			$sidebar_link_styles[] = 'font-family: '.str_replace('+', ' ', $mkd_options['sidebar_link_font_family']).', sans-serif';
		}

		if(isset($mkd_options['sidebar_link_font_size']) && $mkd_options['sidebar_link_font_size'] !== '') {
			$sidebar_link_styles[] = 'font-size: '.intval($mkd_options['sidebar_link_font_size']).'px';
		}

		if(isset($mkd_options['sidebar_link_line_height']) && $mkd_options['sidebar_link_line_height'] !== '') {
			$sidebar_link_styles[] = 'line-height: '.intval($mkd_options['sidebar_link_line_height']).'px';
		}

		if(isset($mkd_options['sidebar_link_letter_spacing']) && $mkd_options['sidebar_link_letter_spacing'] !== '') {
			$sidebar_link_styles[] = 'letter-spacing: '.intval($mkd_options['sidebar_link_letter_spacing']).'px';
		}

		if(isset($mkd_options['sidebar_link_font_weight']) && $mkd_options['sidebar_link_font_weight'] !== '') {
			$sidebar_link_styles[] = 'font-weight: '.intval($mkd_options['sidebar_link_font_weight']);
		}

		if(isset($mkd_options['sidebar_link_font_style']) && $mkd_options['sidebar_link_font_style'] !== '') {
			$sidebar_link_styles[] = 'font-style: '.$mkd_options['sidebar_link_font_style'];
		}

		if(isset($mkd_options['sidebar_link_text_transform']) && $mkd_options['sidebar_link_text_transform'] !== '') {
			$sidebar_link_styles[] = 'text-transform: '.$mkd_options['sidebar_link_text_transform'];
		}

		if(isset($mkd_options['sidebar_link_color']) && $mkd_options['sidebar_link_color'] !== '') {
			$sidebar_link_styles[] = 'color: '.$mkd_options['sidebar_link_color'];
		}

		if(is_array($sidebar_link_styles) && count($sidebar_link_styles)) { ?>
            aside.sidebar .widget:not(.woocommerce) a,
            .woocommerce aside.sidebar .woocommerce.widget ul.product-categories a,
            .woocommerce-page aside.sidebar .woocommerce.widget ul.product-categories a,
            .woocommerce aside.sidebar .woocommerce.widget ul.product-categories ul.children li a,
            aside ul.product-categories ul.children li a,
            .woocommerce-page aside.sidebar .woocommerce.widget ul.product-categories ul.children li a,
            aside.sidebar .widget.woocommerce ul.product-categories li a{
			<?php echo esc_attr(implode(';', $sidebar_link_styles)); ?>
            }
		<?php } ?>

		<?php if (isset($mkd_options['sidebar_link_hover_color']) && !empty($mkd_options['sidebar_link_hover_color'])) { ?>
            aside.sidebar .widget:not(.wooocommerce) a:hover,
            .woocommerce aside.sidebar .woocommerce.widget ul.product-categories ul.children li a:hover,
            aside ul.product-categories ul.children li a:hover, .woocommerce-page aside.sidebar .woocommerce.widget ul.product-categories ul.children li a:hover,
            .woocommerce aside.sidebar .woocommerce.widget ul.product-categories a:hover,
            aside ul.product-categories a:hover, .woocommerce-page aside.sidebar .woocommerce.widget ul.product-categories li a:hover,
            aside.sidebar .widget.woocommerce ul.product-categories li a:hover{
            color:<?php echo esc_attr($mkd_options['sidebar_link_hover_color']);  ?>;
            }
		<?php } ?>

		<?php if (isset($mkd_options['side_area_background_color']) && !empty($mkd_options['side_area_background_color'])) { ?>
            .side_menu{
            background-color:<?php echo esc_attr($mkd_options['side_area_background_color']);  ?>;
            }
		<?php } ?>


		<?php if (isset($mkd_options['side_area_close_icon']) && ($mkd_options['side_area_close_icon']=="dark")) { ?>
            .side_menu a.close_side_menu{
            background-image:url('img/close_side_menu_dark.png');
            }
		<?php } ?>

		<?php if(isset($mkd_options['side_area_type']) && ($mkd_options['side_area_type'] == 'side_menu_slide_from_right')){?>

			<?php if (isset($mkd_options['side_area_width']) && ($mkd_options['side_area_width'] !== '') && ($mkd_options['side_area_width'] >=30)) { ?>
                .side_menu_slide_from_right .side_menu{
                right:-<?php echo esc_attr($mkd_options['side_area_width']).'%';  ?>;
                width:<?php echo esc_attr($mkd_options['side_area_width']) .'%';  ?>;
                }
			<?php } ?>

			<?php if (isset($mkd_options['side_area_content_overlay_color']) && !empty($mkd_options['side_area_content_overlay_color'])) { ?>
                .side_menu_slide_from_right .wrapper .cover{
                background-color:<?php echo esc_attr($mkd_options['side_area_content_overlay_color']);  ?>;
                }
			<?php } ?>

			<?php if (isset($mkd_options['side_area_content_overlay_opacity']) && ($mkd_options['side_area_content_overlay_opacity'] !== '')) { ?>
                .side_menu_slide_from_right.right_side_menu_opened .wrapper .cover{
                opacity:<?php echo esc_attr($mkd_options['side_area_content_overlay_opacity']);  ?>;
                }
			<?php } ?>

		<?php } ?>


		<?php if (isset($mkd_options['side_area_aligment']) && ($mkd_options['side_area_aligment']=='left')) { ?>
            .side_menu_slide_from_right .side_menu,
            body.side_menu_slide_with_content .side_menu{
            text-align: left;
            }
		<?php } ?>
		<?php if (isset($mkd_options['side_area_aligment']) && ($mkd_options['side_area_aligment']=='right')) { ?>
            .side_menu_slide_from_right .side_menu,
            body.side_menu_slide_with_content .side_menu{
            text-align: right;
            }
		<?php } ?>
		<?php if (isset($mkd_options['side_area_aligment']) && ($mkd_options['side_area_aligment']=='center')) { ?>
            .side_menu_slide_from_right .side_menu,
            body.side_menu_slide_with_content .side_menu{
            text-align: center;
            }
		<?php } ?>


		<?php
		$side_area_text_styles = array();

		if(isset($mkd_options['side_area_text_google_fonts']) && $mkd_options['side_area_text_google_fonts'] !== '-1') {
			$side_area_text_styles[] = 'font-family: '.str_replace('+', ' ', $mkd_options['side_area_text_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['side_area_text_fontsize']) && $mkd_options['side_area_text_fontsize'] !== '') {
			$side_area_text_styles[] = 'font-size: '.intval($mkd_options['side_area_text_fontsize']).'px';
		}

		if(isset($mkd_options['side_area_text_lineheight']) && $mkd_options['side_area_text_lineheight'] !== '') {
			$side_area_text_styles[] = 'line-height: '.intval($mkd_options['side_area_text_lineheight']).'px';
		}

		if(isset($mkd_options['side_area_text_letterspacing']) && $mkd_options['side_area_text_letterspacing'] !== '') {
			$side_area_text_styles[] = 'letter-spacing: '.intval($mkd_options['side_area_text_letterspacing']).'px';
		}

		if(isset($mkd_options['side_area_text_fontweight']) && $mkd_options['side_area_text_fontweight'] !== '') {
			$side_area_text_styles[] = 'font-weight: '.intval($mkd_options['side_area_text_fontweight']);
		}

		if(isset($mkd_options['side_area_text_fontstyle']) && $mkd_options['side_area_text_fontstyle'] !== '') {
			$side_area_text_styles[] = 'font-style: '.$mkd_options['side_area_text_fontstyle'];
		}

		if(isset($mkd_options['side_area_text_texttransform']) && $mkd_options['side_area_text_texttransform'] !== '') {
			$side_area_text_styles[] = 'text-transform: '.$mkd_options['side_area_text_texttransform'];
		}

		if(isset($mkd_options['side_area_text_color']) && $mkd_options['side_area_text_color'] !== '') {
			$side_area_text_styles[] = 'color: '.$mkd_options['side_area_text_color'];
		}

		if(is_array($side_area_text_styles) && count($side_area_text_styles)) { ?>
            .side_menu .widget,
            .side_menu .widget.widget_search form,
            .side_menu .widget.widget_search form input[type="text"],
            .side_menu .widget.widget_search form input[type="submit"],
            .side_menu .widget h6,
            .side_menu .widget h6 a,
            .side_menu .widget p,
            .side_menu .widget li a,
            .side_menu .widget.widget_rss li a.rsswidget,
            .side_menu #wp-calendar caption,
            .side_menu .widget li,
            .side_menu_title h3,
            .side_menu .widget.widget_archive select,
            .side_menu .widget.widget_categories select,
            .side_menu .widget.widget_text select,
            .side_menu .widget.widget_search form input[type="submit"],
            .side_menu #wp-calendar th,
            .side_menu #wp-calendar td,
            .side_menu .mkd_social_icon_holder i.simple_social{
			<?php echo esc_attr(implode(';', $side_area_text_styles)); ?>
            }
		<?php } ?>








		<?php
		$side_area_title_styles = array();

		if(isset($mkd_options['side_area_title_google_fonts']) && $mkd_options['side_area_title_google_fonts'] !== '-1') {
			$side_area_title_styles[] = 'font-family: '.str_replace('+', ' ', $mkd_options['side_area_title_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['side_area_title_fontsize']) && $mkd_options['side_area_title_fontsize'] !== '') {
			$side_area_title_styles[] = 'font-size: '.intval($mkd_options['side_area_title_fontsize']).'px';
		}

		if(isset($mkd_options['side_area_title_lineheight']) && $mkd_options['side_area_title_lineheight'] !== '') {
			$side_area_title_styles[] = 'line-height: '.intval($mkd_options['side_area_title_lineheight']).'px';
		}

		if(isset($mkd_options['side_area_title_letterspacing']) && $mkd_options['side_area_title_letterspacing'] !== '') {
			$side_area_title_styles[] = 'letter-spacing: '.intval($mkd_options['side_area_title_letterspacing']).'px';
		}

		if(isset($mkd_options['side_area_title_fontweight']) && $mkd_options['side_area_title_fontweight'] !== '') {
			$side_area_title_styles[] = 'font-weight: '.intval($mkd_options['side_area_title_fontweight']);
		}

		if(isset($mkd_options['side_area_title_fontstyle']) && $mkd_options['side_area_title_fontstyle'] !== '') {
			$side_area_title_styles[] = 'font-style: '.$mkd_options['side_area_title_fontstyle'];
		}

		if(isset($mkd_options['side_area_title_texttransform']) && $mkd_options['side_area_title_texttransform'] !== '') {
			$side_area_title_styles[] = 'text-transform: '.$mkd_options['side_area_title_texttransform'];
		}

		if(isset($mkd_options['side_area_title_color']) && $mkd_options['side_area_title_color'] !== '') {
			$side_area_title_styles[] = 'color: '.$mkd_options['side_area_title_color'];
		}

		if(is_array($side_area_title_styles) && count($side_area_title_styles)) { ?>
            .side_menu h4, .side_menu h5 { <?php echo esc_attr(implode(';', $side_area_title_styles)); ?> }
		<?php } ?>

		<?php
		$side_area_title_styles = array();

		if(isset($mkd_options['sidearea_link_font_family']) && $mkd_options['sidearea_link_font_family'] !== '-1') {
			$side_area_title_styles[] = 'font-family: '.str_replace('+', ' ', $mkd_options['sidearea_link_font_family']).', sans-serif';
		}

		if(isset($mkd_options['sidearea_link_font_size']) && $mkd_options['sidearea_link_font_size'] !== '') {
			$side_area_title_styles[] = 'font-size: '.intval($mkd_options['sidearea_link_font_size']).'px';
		}

		if(isset($mkd_options['sidearea_link_line_height']) && $mkd_options['sidearea_link_line_height'] !== '') {
			$side_area_title_styles[] = 'line-height: '.intval($mkd_options['sidearea_link_line_height']).'px';
		}

		if(isset($mkd_options['sidearea_link_letter_spacing']) && $mkd_options['sidearea_link_letter_spacing'] !== '') {
			$side_area_title_styles[] = 'letter-spacing: '.intval($mkd_options['sidearea_link_letter_spacing']).'px';
		}

		if(isset($mkd_options['sidearea_link_font_weight']) && $mkd_options['sidearea_link_font_weight'] !== '') {
			$side_area_title_styles[] = 'font-weight: '.intval($mkd_options['sidearea_link_font_weight']);
		}

		if(isset($mkd_options['sidearea_link_font_style']) && $mkd_options['sidearea_link_font_style'] !== '') {
			$side_area_title_styles[] = 'font-style: '.$mkd_options['sidearea_link_font_style'];
		}

		if(isset($mkd_options['sidearea_link_text_transform']) && $mkd_options['sidearea_link_text_transform'] !== '') {
			$side_area_title_styles[] = 'text-transform: '.$mkd_options['sidearea_link_text_transform'];
		}

		if(isset($mkd_options['sidearea_link_color']) && $mkd_options['sidearea_link_color'] !== '') {
			$side_area_title_styles[] = 'color: '.$mkd_options['sidearea_link_color'];
		}

		if(is_array($side_area_title_styles) && count($side_area_title_styles)) { ?>
            .side_menu .widget li a, .side_menu .widget a { <?php echo esc_attr(implode(';', $side_area_title_styles)); ?> }
		<?php } ?>

		<?php if(isset($mkd_options['sidearea_link_hover_color']) && !empty($mkd_options['sidearea_link_hover_color'])){ ?>
            .side_menu .widget a:hover, .side_menu .widget li:hover, .side_menu .widget li:hover>a{
            color: <?php echo esc_attr($mkd_options['sidearea_link_hover_color']);  ?>;
            }
		<?php } ?>


		<?php
		$separator_blog_style = array();
		if(isset($mkd_options['separator_blog_width']) && $mkd_options['separator_blog_width'] !== '') {
			$separator_blog_style[] = 'width: '.intval($mkd_options['separator_blog_width']).'px'.';';
		}
		if(isset($mkd_options['separator_blog_border_color']) && $mkd_options['separator_blog_border_color'] !== '') {
			$separator_blog_style[] = 'border-color: '.$mkd_options['separator_blog_border_color'];
		}
		if(isset($mkd_options['separator_blog_border_width']) && $mkd_options['separator_blog_border_width'] !== '') {
			$separator_blog_style[] = 'border-width: '.intval($mkd_options['separator_blog_border_width']).'px'.';';
		}
		if(is_array($separator_blog_style) && count($separator_blog_style)) { ?>
            .blog_holder.blog_title_author_centered .post_text .post_text_inner .separator.post_separator,
            .blog_holder.blog_title_date_first .post_text .separator.post_separator,
            .blog_holder.blog_category_title_first_centered .post_category .separator,
            .blog_holder.blog_image_with_icon_centered article .post_text .post_text_inner .separator.post_separator,
            .blog_holder.blog_title_author_centered article.format-link .post_text .post_text_inner .separator.post_separator,
            .blog_holder.blog_title_author_centered article.format-quote .post_text .post_text_inner .separator.post_separator
            {
			<?php echo esc_attr(implode(';', $separator_blog_style)); ?>
            }
		<?php } ?>

		<?php if (isset($mkd_options['qs_slider_height_mobile']) && !empty($mkd_options['qs_slider_height_mobile'])) { ?>
            @media only screen and (max-width: 480px){
            .mkd_slider .carousel, .mkd_slider_preloader, .carousel-inner>.item{
            height: <?php echo esc_attr($mkd_options['qs_slider_height_mobile']); ?>px !important;
            }
            }
		<?php } ?>

		<?php
		//generate Select Slider navigation styles
		$qs_navigation_control_styles    = '';

		if(isset($mkd_options['qs_navigation_control_color']) && $mkd_options['qs_navigation_control_color'] != '') {
			$qs_navigation_control_styles .= 'background-color: '.$mkd_options['qs_navigation_control_color'].';';
		}

		if(isset($mkd_options['qs_navigation_control_size']) && $mkd_options['qs_navigation_control_size'] != '') {
			$qs_navigation_control_styles .= 'width: '.intval($mkd_options['qs_navigation_control_size']).'px;';
			$qs_navigation_control_styles .= 'height: '.intval($mkd_options['qs_navigation_control_size']).'px;';
		}

		if(isset($mkd_options['qs_navigation_control_border_radius']) && $mkd_options['qs_navigation_control_border_radius'] != '') {
			$qs_navigation_control_styles .= 'border-radius: '.intval($mkd_options['qs_navigation_control_border_radius']).'px;';
		}

		if($qs_navigation_control_styles != "") { ?>
            .carousel-indicators li{
			<?php echo esc_attr($qs_navigation_control_styles); ?>
            }
		<?php } ?>

		<?php
		//generate header buttons styles
		$header_buttons_styles          = '';
		$header_buttons_hover_styles    = '';
		if(isset($mkd_options['header_buttons_color']) && $mkd_options['header_buttons_color']) {
			$header_buttons_styles .= 'color: '.$mkd_options['header_buttons_color'].';';
		}

		if(isset($mkd_options['header_buttons_hover_color']) && $mkd_options['header_buttons_hover_color'] != '') {
			$header_buttons_hover_styles .= 'color: '.$mkd_options['header_buttons_hover_color'].'!important;';
		}

		if($header_buttons_styles != ""){ ?>
            .side_menu_button > a,
            .mobile_menu_button span{ <?php echo esc_attr($header_buttons_styles); ?> }

            .popup_menu .line,
            .popup_menu .line:after, .popup_menu .line:before,
            .popup_menu.opened .line:after, .popup_menu.opened .line:before{
            background-color: <?php echo esc_attr($mkd_options['header_buttons_color']); ?>;
            }
		<?php }

		if($header_buttons_hover_styles != "") { ?>
            .side_menu_button > a:hover,
            .mobile_menu_button span:hover,
            .popup_menu:hover .line,
            .popup_menu:hover .line:after,
            .popup_menu:hover .line:before,
            .light:not(.sticky):not(.scrolled) .side_menu_button > a:hover,
            .dark:not(.sticky):not(.scrolled) .side_menu_button > a:hover{
			<?php echo esc_attr($header_buttons_hover_styles); ?>
            }

            .popup_menu:hover .line,
            .popup_menu:hover .line:after,
            .popup_menu:hover .line:before,
            .popup_menu.opened:hover .line:after,
            .popup_menu.opened:hover .line:before{
            background-color: <?php echo esc_attr($mkd_options['header_buttons_hover_color']); ?> ;
            }
		<?php } ?>


		<?php if(isset($mkd_options['header_buttons_font_size']) && $mkd_options['header_buttons_font_size'] !== ''){ ?>
            .side_menu_button > a:not(.popup_menu),
            .mobile_menu_button span{
            font-size: <?php echo esc_attr($mkd_options['header_buttons_font_size']); ?>px;
            }
		<?php } ?>


		<?php if(isset($mkd_options['header_buttons_fullscreen_button_background']) && $mkd_options['header_buttons_fullscreen_button_background'] !== ''){ ?>
            .side_menu_button .popup_menu{
            -webkit-backface-visibility: hidden;
            display: inline-block;
            }
            .side_menu_button .popup_menu.normal{
            padding:10px 15px;
            }
            .side_menu_button .popup_menu.medium{
            padding:10px 13px;
            }
            .side_menu_button .popup_menu.large{
            padding:15px;
            }
            .side_menu_button .popup_menu:not(.opened){
            background-color: <?php echo esc_attr($mkd_options['header_buttons_fullscreen_button_background']); ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['header_buttons_fullscreen_button_background_hover']) && $mkd_options['header_buttons_fullscreen_button_background_hover'] !== ''){ ?>
            .side_menu_button .popup_menu.normal:not(.opened):hover,
            .side_menu_button .popup_menu.medium:not(.opened):hover,
            .side_menu_button .popup_menu.large:not(.opened):hover{
            background-color: <?php echo esc_attr($mkd_options['header_buttons_fullscreen_button_background_hover']); ?>;
            }
		<?php } ?>


		<?php if(isset($mkd_options['mobile_button_color']) && $mkd_options['mobile_button_color'] !== ''){ ?>
            @media only screen and (max-width: 1000px){
            .mobile_menu_button span,
            .side_menu_button > a,
            .mobile_menu_button span{
            color: <?php echo esc_attr($mkd_options['mobile_button_color']); ?>;
            }

            .popup_menu .line,
            .popup_menu .line:after,
            .popup_menu .line:before{
            background-color: <?php echo esc_attr($mkd_options['mobile_button_color']); ?>;
            }
            }
		<?php } ?>

		<?php if(isset($mkd_options['mobile_button_color_hover']) && $mkd_options['mobile_button_color_hover'] !== ''){ ?>
            @media only screen and (max-width: 1000px){
            .mobile_menu_button span:hover,
            .side_menu_button > a:hover,
            .mobile_menu_button span:hover{
            color: <?php echo esc_attr($mkd_options['mobile_button_color_hover']); ?>;
            }
            .popup_menu:hover .line,
            .popup_menu:hover .line:after,
            .popup_menu:hover .line:before{
            background-color: <?php echo esc_attr($mkd_options['mobile_button_color_hover']); ?>;
            }
            }
		<?php } ?>


		<?php if((!empty($mkd_options['vertical_area']) && $mkd_options['vertical_area']=='yes' && !empty($mkd_options['enable_vertical_menu_separators']) && $mkd_options['enable_vertical_menu_separators']=='yes')){ ?>
            nav.vertical_menu > ul > li > a:after{
            display:block;
			<?php if (isset($mkd_options['vertical_menu_separators_color']) && !empty($mkd_options['vertical_menu_separators_color'])) { ?> background-color: <?php echo esc_attr($mkd_options['vertical_menu_separators_color']); ?>;  <?php } ?>
			<?php if (isset($mkd_options['vertical_menu_separators_width']) && $mkd_options['vertical_menu_separators_width'] !== '') { ?>  width: <?php echo esc_attr($mkd_options['vertical_menu_separators_width']); ?>px; <?php } ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['enable_vertical_menu_separators']) && $mkd_options['enable_vertical_menu_separators'] == 'yes' && isset($mkd_options['full_width_vertical_menu_items']) && $mkd_options['full_width_vertical_menu_items'] == 'yes' && isset($mkd_options['enable_vertical_menutop_bottom_separators']) && $mkd_options['enable_vertical_menutop_bottom_separators'] == 'yes'){ ?>
            nav.vertical_menu > ul > li:last-child > a:after{
            content: '';
            }

            nav.vertical_menu > ul > li:first-child > a{
            border-top-width:1px;
            border-top-style:solid;
            border-top-color:#279eff;
            }

			<?php if(isset($mkd_options['vertical_menu_separators_color']) && $mkd_options['vertical_menu_separators_color'] !== ''){ ?>
                nav.vertical_menu > ul > li:first-child > a{
                border-top-color:<?php echo esc_attr($mkd_options['vertical_menu_separators_color']); ?>;
                }

			<?php } ?>


		<?php } ?>


		<?php if(isset($mkd_options['full_width_vertical_menu_items']) && $mkd_options['full_width_vertical_menu_items'] == 'yes'){ ?>


			<?php
			$paddings='';
			if(isset($mkd_options['vertical_area_padding']) && $mkd_options['vertical_area_padding'] !== ''){
				$paddings = ($mkd_options['vertical_area_padding']);
				$padding = explode(" ", $paddings);
				$num_padd = count($padding);
			} ?>


            nav.vertical_menu > ul > li > a:after{
            width: 100%;
            }

            body:not(.vertical_menu_hidden) nav.vertical_menu ul li a,
            body.vertical_menu_hidden .vertical_menu_area.active nav.vertical_menu ul li a{
			<?php if(isset($mkd_options['vertical_area_padding']) && $mkd_options['vertical_area_padding'] == ''){ ?>

                margin-left: -40px;
                margin-right: -40px;
                padding-left: 40px;
                padding-right: 40px;

			<?php } else { ?>

				<?php if($num_padd==1){ ?>
                    margin-left: -<?php echo esc_attr($padding[0]);?>;
                    margin-right: -<?php echo esc_attr($padding[0]);?>;
                    padding-left: <?php echo esc_attr($padding[0]);?>;
                    padding-right: <?php echo esc_attr($padding[0]);?>;
				<?php } ?>

				<?php if($num_padd==2){ ?>
                    margin-left: -<?php echo esc_attr($padding[1]);?>;
                    margin-right: -<?php echo esc_attr($padding[1]);?>;
                    padding-left: <?php echo esc_attr($padding[1]);?>;
                    padding-right: <?php echo esc_attr($padding[1]);?>;
				<?php } ?>

				<?php if($num_padd==3){ ?>
                    margin-left: -<?php echo esc_attr($padding[1]);?>;
                    margin-right: -<?php echo esc_attr($padding[1]);?>;
                    padding-left: <?php echo esc_attr($padding[1]);?>;
                    padding-right: <?php echo esc_attr($padding[1]);?>;
				<?php } ?>

				<?php if($num_padd==4){ ?>
                    margin-left: -<?php echo esc_attr($padding[3]);?>;
                    margin-right: -<?php echo esc_attr($padding[1]);?>;
                    padding-left: <?php echo esc_attr($padding[3]);?>;
                    padding-right: <?php echo esc_attr($padding[1]);?>;
				<?php } ?>

			<?php } ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['enable_vertical_menu_items_background']) && ($mkd_options['enable_vertical_menu_items_background'])=='yes'){ ?>

			<?php if(isset($mkd_options['vertical_menu_items_background_color']) && !empty($mkd_options['vertical_menu_items_background_color'])){ ?>
                nav.vertical_menu>ul>li>a{
                background-color: <?php echo esc_attr($mkd_options['vertical_menu_items_background_color']); ?>;
                }
			<?php } ?>
			<?php if(isset($mkd_options['vertical_menu_items_hover_background_color']) && !empty($mkd_options['vertical_menu_items_hover_background_color'])){ ?>
                nav.vertical_menu>ul>li>a:hover,
                nav.vertical_menu>ul>li.active>a:hover{
                background-color: <?php echo esc_attr($mkd_options['vertical_menu_items_hover_background_color']); ?>;
                }
			<?php } ?>
			<?php if(isset($mkd_options['vertical_menu_items_active_background_color']) && !empty($mkd_options['vertical_menu_items_active_background_color'])){ ?>
                nav.vertical_menu>ul>li.active>a{
                background-color: <?php echo esc_attr($mkd_options['vertical_menu_items_active_background_color']); ?>;
                }
			<?php } ?>

		<?php } ?>



		<?php if(isset($mkd_options['enable_vertical_menu_item_left_border']) && $mkd_options['enable_vertical_menu_item_left_border'] == 'yes'){ ?>

			<?php if (isset($mkd_options['vertical_menu_item_left_border_width']) && !empty($mkd_options['vertical_menu_item_left_border_width'])) { ?>
                nav.vertical_menu>ul>li>a:before{
                width: <?php echo esc_attr($mkd_options['vertical_menu_item_left_border_width']); ?>px;
                }
			<?php } ?>


			<?php if (isset($mkd_options['vertical_menu_item_left_border_color']) && !empty($mkd_options['vertical_menu_item_left_border_color'])) { ?>
                nav.vertical_menu>ul>li>a:before{
                background-color: <?php echo esc_attr($mkd_options['vertical_menu_item_left_border_color']); ?>;
                opacity:1;
                }
			<?php } ?>

			<?php if (isset($mkd_options['vertical_menu_item_left_border_hover_color']) && !empty($mkd_options['vertical_menu_item_left_border_hover_color'])) { ?>
                nav.vertical_menu>ul>li>a:hover:before,
                nav.vertical_menu>ul>li.active>a:hover:before{
                background-color: <?php echo esc_attr($mkd_options['vertical_menu_item_left_border_hover_color']); ?>;
                opacity:1;
                }
			<?php } ?>

			<?php if (isset($mkd_options['vertical_menu_item_left_border_active_color']) && !empty($mkd_options['vertical_menu_item_left_border_active_color'])) { ?>
                nav.vertical_menu>ul>li.active>a:before{
                background-color: <?php echo esc_attr($mkd_options['vertical_menu_item_left_border_active_color']); ?>;
                opacity:1;
                }
			<?php } ?>

		<?php } ?>


		<?php if(!empty($mkd_options['vertical_area_alignment']) && $mkd_options['vertical_menu_separators_width'] !== ''){ ?>
			<?php $margin_left= $mkd_options['vertical_menu_separators_width']/2; ?>

            nav.vertical_menu > ul > li > a:after{
			<?php if($mkd_options['vertical_area_alignment'] == 'left'){ ?>
                left:0px;

			<?php } elseif($mkd_options['vertical_area_alignment'] == 'center'){ ?>
                left:50%;
                margin-left: -<?php echo esc_attr($margin_left); ?>px;

			<?php } elseif($mkd_options['vertical_area_alignment'] == 'right'){ ?>
                left:auto;
                right: 0px;

			<?php } ?>
            }
		<?php } elseif (!empty($mkd_options['vertical_area_alignment']) && $mkd_options['vertical_menu_separators_width'] == ''){  ?>

            nav.vertical_menu > ul > li > a:after{
			<?php if($mkd_options['vertical_area_alignment'] == 'left'){ ?>
                left:0px;

			<?php } elseif($mkd_options['vertical_area_alignment'] == 'center'){ ?>
                left:50%;
                margin-left: -22px;

			<?php } elseif($mkd_options['vertical_area_alignment'] == 'right'){ ?>
                left:auto;
                right: 0px;

			<?php } ?>
            }
		<?php } ?>

		<?php if(!empty($mkd_options['vertical_area_hidden_button_color']) && $mkd_options['vertical_area_hidden_button_color'] !== ''){ ?>
            .vertical_menu_hidden_button_line,
            .vertical_menu_hidden_button_line:after,.vertical_menu_hidden_button_line:before{
            background-color: <?php echo esc_attr($mkd_options['vertical_area_hidden_button_color']); ?>;
            }
		<?php } ?>

		<?php if(!empty($mkd_options['vertical_area_background'])){ ?>
            aside.vertical_menu_area,
            .vertical_menu.vertical_menu_side ul li div.second,
            .vertical_menu.vertical_menu_side ul li div.second ul,
            .vertical_menu.vertical_menu_side ul li div.second ul li ul,
            .vertical_menu.vertical_menu_side ul li div.second ul li a{
            background-color: <?php echo esc_attr($mkd_options['vertical_area_background']); ?>;
            }
		<?php } ?>

		<?php if(!empty($mkd_options['vertical_area_padding']) && $mkd_options['vertical_area_padding'] !== ''){ ?>
            aside.vertical_menu_area{
            padding: <?php echo esc_attr($mkd_options['vertical_area_padding']); ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['vertical_area_navigation_top_margin']) && $mkd_options['vertical_area_navigation_top_margin'] !== ''){ ?>
            nav.vertical_menu{
            margin-top: <?php echo esc_attr($mkd_options['vertical_area_navigation_top_margin']); ?>px;
            }
		<?php } ?>

		<?php if(!empty($mkd_options['vertical_area_alignment']) && $mkd_options['vertical_area_alignment'] !== ''){ ?>
            .vertical_logo_wrapper,
            nav.vertical_menu,
            aside.vertical_menu_area .vertical_menu_area_widget_holder{
            text-align: <?php echo esc_attr($mkd_options['vertical_area_alignment']); ?>;
            }
		<?php } ?>

		<?php if(!empty($mkd_options['vertical_area_text_color'])){ ?>
            aside .vertical_menu_area_widget_holder,
            aside .vertical_menu_area_widget_holder p,
            aside .vertical_menu_area_widget_holder span{
            color: <?php echo esc_attr($mkd_options['vertical_area_text_color']); ?>;
            }
		<?php } ?>


		<?php if (!empty($mkd_options['vertical_menu_color']) || !empty($mkd_options['vertical_menu_fontsize']) || !empty($mkd_options['vertical_menu_lineheight']) || !empty($mkd_options['vertical_menu_fontstyle']) || !empty($mkd_options['vertical_menu_fontweight']) || !empty($mkd_options['vertical_menu_texttransform']) || (isset($mkd_options['vertical_menu_letterspacing']) && $mkd_options['vertical_menu_letterspacing'] !== '') || $mkd_options['vertical_menu_google_fonts'] != "-1") { ?>
            nav.vertical_menu > ul > li > a,
            .vertical_menu.vertical_menu_side ul li a{
			<?php if (!empty($mkd_options['vertical_menu_color'])) { ?> color: <?php echo esc_attr($mkd_options['vertical_menu_color']);  ?>; <?php } ?>
			<?php if($mkd_options['vertical_menu_google_fonts'] != "-1"){ ?>
                font-family: '<?php echo esc_attr(str_replace('+', ' ', $mkd_options['vertical_menu_google_fonts'])); ?>', sans-serif;
			<?php } ?>
			<?php if (!empty($mkd_options['vertical_menu_fontsize'])) { ?> font-size: <?php echo esc_attr($mkd_options['vertical_menu_fontsize']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['vertical_menu_lineheight'])) { ?> line-height: <?php echo esc_attr($mkd_options['vertical_menu_lineheight']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['vertical_menu_fontstyle'])) { ?> font-style: <?php echo esc_attr($mkd_options['vertical_menu_fontstyle']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['vertical_menu_fontweight'])) { ?> font-weight: <?php echo esc_attr($mkd_options['vertical_menu_fontweight']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['vertical_menu_texttransform'])) { ?> text-transform: <?php echo esc_attr($mkd_options['vertical_menu_texttransform']);  ?>; <?php } ?>
			<?php if ($mkd_options['vertical_menu_letterspacing'] !== '') { ?> letter-spacing: <?php echo esc_attr($mkd_options['vertical_menu_letterspacing']);  ?>px; <?php } ?>
            }
		<?php } ?>


		<?php if (!empty($mkd_options['vertical_menu_hovercolor'])) { ?>
            nav.vertical_menu > ul > li.active:hover > a,
            nav.vertical_menu > ul > li:hover > a,
            .vertical_menu.vertical_menu_side ul li:hover > a,
            .vertical_menu.vertical_menu_side ul li.active:hover > a{
            color: <?php echo esc_attr($mkd_options['vertical_menu_hovercolor']);  ?>;
            }
		<?php } ?>

		<?php if (!empty($mkd_options['vertical_menu_activecolor'])) { ?>
            nav.vertical_menu > ul > li.active > a,
            .vertical_menu.vertical_menu_side ul li.active > a{
            color: <?php echo esc_attr($mkd_options['vertical_menu_activecolor']);  ?>;
            }
		<?php } ?>

		<?php if (!empty($mkd_options['vertical_transparent_menu_color']) || !empty($mkd_options['vertical_transparent_menu_fontsize']) || !empty($mkd_options['vertical_transparent_menu_lineheight']) || !empty($mkd_options['vertical_transparent_menu_fontstyle']) || !empty($mkd_options['vertical_transparent_menu_fontweight']) || !empty($mkd_options['vertical_transparent_menu_texttransform']) || (isset($mkd_options['vertical_transparent_menu_letterspacing']) && $mkd_options['vertical_transparent_menu_letterspacing'] !== '') || $mkd_options['vertical_transparent_menu_google_fonts'] != "-1") { ?>
            .vertical_menu_enabled.vertical_menu_transparency_on:not(.vertical_menu_hidden)  nav.vertical_menu > ul > li > a,
            .vertical_menu_enabled.vertical_menu_transparency_on:not(.vertical_menu_hidden)  .vertical_menu.vertical_menu_side ul li a{
			<?php if (!empty($mkd_options['vertical_transparent_menu_color'])) { ?> color: <?php echo esc_attr($mkd_options['vertical_transparent_menu_color']);  ?>; <?php } ?>
			<?php if($mkd_options['vertical_transparent_menu_google_fonts'] != "-1"){ ?>
                font-family: '<?php echo esc_attr(str_replace('+', ' ', $mkd_options['vertical_transparent_menu_google_fonts'])); ?>', sans-serif;
			<?php } ?>
			<?php if (!empty($mkd_options['vertical_transparent_menu_fontsize'])) { ?> font-size: <?php echo esc_attr($mkd_options['vertical_transparent_menu_fontsize']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['vertical_transparent_menu_lineheight'])) { ?> line-height: <?php echo esc_attr($mkd_options['vertical_transparent_menu_lineheight']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['vertical_transparent_menu_fontstyle'])) { ?> font-style: <?php echo esc_attr($mkd_options['vertical_transparent_menu_fontstyle']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['vertical_transparent_menu_fontweight'])) { ?> font-weight: <?php echo esc_attr($mkd_options['vertical_transparent_menu_fontweight']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['vertical_transparent_menu_texttransform'])) { ?> text-transform: <?php echo esc_attr($mkd_options['vertical_transparent_menu_texttransform']);  ?>; <?php } ?>
			<?php if ($mkd_options['vertical_transparent_menu_letterspacing'] !== '') { ?> letter-spacing: <?php echo esc_attr($mkd_options['vertical_transparent_menu_letterspacing']);  ?>px; <?php } ?>
            }
		<?php } ?>


		<?php if (!empty($mkd_options['vertical_transparent_menu_hovercolor'])) { ?>
            .vertical_menu_enabled.vertical_menu_transparency_on:not(.vertical_menu_hidden)  nav.vertical_menu > ul > li.active:hover > a,
            .vertical_menu_enabled.vertical_menu_transparency_on:not(.vertical_menu_hidden)  nav.vertical_menu > ul > li:hover > a,
            .vertical_menu_enabled.vertical_menu_transparency_on:not(.vertical_menu_hidden)  .vertical_menu.vertical_menu_side ul li:hover > a,
            .vertical_menu_enabled.vertical_menu_transparency_on:not(.vertical_menu_hidden)  .vertical_menu.vertical_menu_side ul li.active:hover > a{
            color: <?php echo esc_attr($mkd_options['vertical_transparent_menu_hovercolor']);  ?>;
            }
		<?php } ?>

		<?php if (!empty($mkd_options['vertical_transparent_menu_activecolor'])) { ?>
            .vertical_menu_enabled.vertical_menu_transparency_on:not(.vertical_menu_hidden)  nav.vertical_menu > ul > li.active > a,
            .vertical_menu_enabled.vertical_menu_transparency_on:not(.vertical_menu_hidden)  .vertical_menu.vertical_menu_side ul li.active > a{
            color: <?php echo esc_attr($mkd_options['vertical_transparent_menu_activecolor']);  ?>;
            }
		<?php } ?>




		<?php if(!empty($mkd_options['vertical_dropdown_color']) || !empty($mkd_options['vertical_dropdown_fontsize']) || !empty($mkd_options['vertical_dropdown_lineheight']) || !empty($mkd_options['vertical_dropdown_fontstyle']) || !empty($mkd_options['vertical_dropdown_fontweight']) || !empty($mkd_options['vertical_dropdown_texttransform']) || (isset($mkd_options['vertical_dropdown_letterspacing']) && $mkd_options['vertical_dropdown_letterspacing'] !== '') || $mkd_options['vertical_dropdown_google_fonts'] != "-1"){ ?>
            .vertical_menu .second .inner > ul > li > a,
            .vertical_menu .wide .second .inner > ul > li > a{
			<?php if (!empty($mkd_options['vertical_dropdown_color'])) { ?> color: <?php echo esc_attr($mkd_options['vertical_dropdown_color']); ?>; <?php } ?>
			<?php if($mkd_options['vertical_dropdown_google_fonts'] != "-1"){ ?>
                font-family: '<?php echo esc_attr(str_replace('+', ' ', $mkd_options['vertical_dropdown_google_fonts'])); ?>', sans-serif !important;
			<?php } ?>
			<?php if (!empty($mkd_options['vertical_dropdown_fontsize'])) { ?> font-size: <?php echo esc_attr($mkd_options['vertical_dropdown_fontsize']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['vertical_dropdown_lineheight'])) { ?> line-height: <?php echo esc_attr($mkd_options['vertical_dropdown_lineheight']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['vertical_dropdown_fontstyle'])) { ?> font-style: <?php echo esc_attr($mkd_options['vertical_dropdown_fontstyle']);  ?>;  <?php } ?>
			<?php if (!empty($mkd_options['vertical_dropdown_fontweight'])) { ?>font-weight: <?php echo esc_attr($mkd_options['vertical_dropdown_fontweight']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['vertical_dropdown_texttransform'])) { ?> text-transform: <?php echo esc_attr($mkd_options['vertical_dropdown_texttransform']);  ?>; <?php } ?>
			<?php if ($mkd_options['vertical_dropdown_letterspacing'] !== '') { ?> letter-spacing: <?php echo esc_attr($mkd_options['vertical_dropdown_letterspacing']);  ?>px; <?php } ?>
            }
		<?php } ?>

		<?php if (!empty($mkd_options['vertical_dropdown_hovercolor'])) { ?>
            .vertical_menu .second .inner > ul > li > a:hover{
            color: <?php echo esc_attr($mkd_options['vertical_dropdown_hovercolor']);  ?> !important;
            }
		<?php } ?>



		<?php if(!empty($mkd_options['vertical_transparent_dropdown_color']) || !empty($mkd_options['vertical_transparent_dropdown_fontsize']) || !empty($mkd_options['vertical_transparent_dropdown_lineheight']) || !empty($mkd_options['vertical_transparent_dropdown_fontstyle']) || !empty($mkd_options['vertical_transparent_dropdown_fontweight']) || !empty($mkd_options['vertical_transparent_dropdown_texttransform']) || (isset($mkd_options['vertical_transparent_dropdown_letterspacing']) && $mkd_options['vertical_transparent_dropdown_letterspacing'] !== '') || $mkd_options['vertical_transparent_dropdown_google_fonts'] != "-1"){ ?>
            .vertical_menu_enabled.vertical_menu_transparency_on:not(.vertical_menu_hidden)  .vertical_menu .second .inner > ul > li > a,
            .vertical_menu_enabled.vertical_menu_transparency_on:not(.vertical_menu_hidden)  .vertical_menu .wide .second .inner > ul > li > a{
			<?php if (!empty($mkd_options['vertical_transparent_dropdown_color'])) { ?> color: <?php echo esc_attr($mkd_options['vertical_transparent_dropdown_color']); ?>; <?php } ?>
			<?php if($mkd_options['vertical_transparent_dropdown_google_fonts'] != "-1"){ ?>
                font-family: '<?php echo esc_attr(str_replace('+', ' ', $mkd_options['vertical_transparent_dropdown_google_fonts'])); ?>', sans-serif !important;
			<?php } ?>
			<?php if (!empty($mkd_options['vertical_transparent_dropdown_fontsize'])) { ?> font-size: <?php echo esc_attr($mkd_options['vertical_transparent_dropdown_fontsize']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['vertical_transparent_dropdown_lineheight'])) { ?> line-height: <?php echo esc_attr($mkd_options['vertical_transparent_dropdown_lineheight']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['vertical_transparent_dropdown_fontstyle'])) { ?> font-style: <?php echo esc_attr($mkd_options['vertical_transparent_dropdown_fontstyle']);  ?>;  <?php } ?>
			<?php if (!empty($mkd_options['vertical_transparent_dropdown_fontweight'])) { ?>font-weight: <?php echo esc_attr($mkd_options['vertical_transparent_dropdown_fontweight']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['vertical_transparent_dropdown_texttransform'])) { ?> text-transform: <?php echo esc_attr($mkd_options['vertical_transparent_dropdown_texttransform']);  ?>; <?php } ?>
			<?php if ($mkd_options['vertical_transparent_dropdown_letterspacing'] !== '') { ?> letter-spacing: <?php echo esc_attr($mkd_options['vertical_transparent_dropdown_letterspacing']);  ?>px; <?php } ?>
            }
		<?php } ?>

		<?php if (!empty($mkd_options['vertical_transparent_dropdown_hovercolor'])) { ?>
            .vertical_menu_enabled.vertical_menu_transparency_on:not(.vertical_menu_hidden)  .vertical_menu .second .inner > ul > li > a:hover{
            color: <?php echo esc_attr($mkd_options['vertical_transparent_dropdown_hovercolor']);  ?> !important;
            }
		<?php } ?>



		<?php if(!empty($mkd_options['vertical_dropdown_color_thirdlvl']) || !empty($mkd_options['vertical_dropdown_fontsize_thirdlvl']) || !empty($mkd_options['vertical_dropdown_lineheight_thirdlvl']) || !empty($mkd_options['vertical_dropdown_fontstyle_thirdlvl']) || !empty($mkd_options['vertical_dropdown_fontweight_thirdlvl']) || !empty($mkd_options['vertical_dropdown_texttransform_thirdlvl']) || (isset($mkd_options['vertical_dropdown_letterspacing_thirdlvl']) && $mkd_options['vertical_dropdown_letterspacing_thirdlvl'] !== '') || $mkd_options['vertical_dropdown_google_fonts_thirdlvl'] != "-1"){ ?>
            .vertical_menu .second .inner ul li.sub ul li a{
			<?php if (!empty($mkd_options['vertical_dropdown_color_thirdlvl'])) { ?> color: <?php echo esc_attr($mkd_options['vertical_dropdown_color_thirdlvl']);  ?>;  <?php } ?>
			<?php if($mkd_options['vertical_dropdown_google_fonts_thirdlvl'] != "-1"){ ?>
                font-family: '<?php echo esc_attr(str_replace('+', ' ', $mkd_options['vertical_dropdown_google_fonts_thirdlvl'])); ?>', sans-serif;
			<?php } ?>
			<?php if (!empty($mkd_options['vertical_dropdown_fontsize_thirdlvl'])) { ?> font-size: <?php echo esc_attr($mkd_options['vertical_dropdown_fontsize_thirdlvl']);  ?>px;  <?php } ?>
			<?php if (!empty($mkd_options['vertical_dropdown_lineheight_thirdlvl'])) { ?> line-height: <?php echo esc_attr($mkd_options['vertical_dropdown_lineheight_thirdlvl']);  ?>px;  <?php } ?>
			<?php if (!empty($mkd_options['vertical_dropdown_fontstyle_thirdlvl'])) { ?> font-style: <?php echo esc_attr($mkd_options['vertical_dropdown_fontstyle_thirdlvl']);  ?>;   <?php } ?>
			<?php if (!empty($mkd_options['vertical_dropdown_fontweight_thirdlvl'])) { ?> font-weight: <?php echo esc_attr($mkd_options['vertical_dropdown_fontweight_thirdlvl']);  ?>;  <?php } ?>
			<?php if (!empty($mkd_options['vertical_dropdown_texttransform_thirdlvl'])) { ?> text-transform: <?php echo esc_attr($mkd_options['vertical_dropdown_texttransform_thirdlvl']);  ?>; <?php } ?>
			<?php if ($mkd_options['vertical_dropdown_letterspacing_thirdlvl'] !== '') { ?> letter-spacing: <?php echo esc_attr($mkd_options['vertical_dropdown_letterspacing_thirdlvl']);  ?>px; <?php } ?>
            }
		<?php } ?>

		<?php if (!empty($mkd_options['vertical_dropdown_hovercolor_thirdlvl'])) { ?>
            .vertical_menu .second .inner ul li.sub ul li a:hover{
            color: <?php echo esc_attr($mkd_options['vertical_dropdown_hovercolor_thirdlvl']);  ?> !important;
            }
		<?php } ?>


		<?php if(!empty($mkd_options['vertical_transparent_dropdown_color_thirdlvl']) || !empty($mkd_options['vertical_transparent_dropdown_fontsize_thirdlvl']) || !empty($mkd_options['vertical_transparent_dropdown_lineheight_thirdlvl']) || !empty($mkd_options['vertical_transparent_dropdown_fontstyle_thirdlvl']) || !empty($mkd_options['vertical_transparent_dropdown_fontweight_thirdlvl']) || !empty($mkd_options['vertical_transparent_dropdown_texttransform_thirdlvl']) || (isset($mkd_options['vertical_transparent_dropdown_letterspacing_thirdlvl']) && $mkd_options['vertical_transparent_dropdown_letterspacing_thirdlvl'] !== '') || $mkd_options['vertical_transparent_dropdown_google_fonts_thirdlvl'] != "-1"){ ?>
            .vertical_menu_enabled.vertical_menu_transparency_on:not(.vertical_menu_hidden)  .vertical_menu .second .inner ul li.sub ul li a{
			<?php if (!empty($mkd_options['vertical_transparent_dropdown_color_thirdlvl'])) { ?> color: <?php echo esc_attr($mkd_options['vertical_transparent_dropdown_color_thirdlvl']);  ?>;  <?php } ?>
			<?php if($mkd_options['vertical_transparent_dropdown_google_fonts_thirdlvl'] != "-1"){ ?>
                font-family: '<?php echo esc_attr(str_replace('+', ' ', $mkd_options['vertical_transparent_dropdown_google_fonts_thirdlvl'])); ?>', sans-serif;
			<?php } ?>
			<?php if (!empty($mkd_options['vertical_transparent_dropdown_fontsize_thirdlvl'])) { ?> font-size: <?php echo esc_attr($mkd_options['vertical_transparent_dropdown_fontsize_thirdlvl']);  ?>px;  <?php } ?>
			<?php if (!empty($mkd_options['vertical_transparent_dropdown_lineheight_thirdlvl'])) { ?> line-height: <?php echo esc_attr($mkd_options['vertical_transparent_dropdown_lineheight_thirdlvl']);  ?>px;  <?php } ?>
			<?php if (!empty($mkd_options['vertical_transparent_dropdown_fontstyle_thirdlvl'])) { ?> font-style: <?php echo esc_attr($mkd_options['vertical_transparent_dropdown_fontstyle_thirdlvl']);  ?>;   <?php } ?>
			<?php if (!empty($mkd_options['vertical_transparent_dropdown_fontweight_thirdlvl'])) { ?> font-weight: <?php echo esc_attr($mkd_options['vertical_transparent_dropdown_fontweight_thirdlvl']);  ?>;  <?php } ?>
			<?php if (!empty($mkd_options['vertical_transparent_dropdown_texttransform_thirdlvl'])) { ?> text-transform: <?php echo esc_attr($mkd_options['vertical_transparent_dropdown_texttransform_thirdlvl']);  ?>; <?php } ?>
			<?php if ($mkd_options['vertical_transparent_dropdown_letterspacing_thirdlvl'] !== '') { ?> letter-spacing: <?php echo esc_attr($mkd_options['vertical_transparent_dropdown_letterspacing_thirdlvl']);  ?>px; <?php } ?>
            }
		<?php } ?>

		<?php if (!empty($mkd_options['vertical_transparent_dropdown_hovercolor_thirdlvl'])) { ?>
            .vertical_menu_enabled.vertical_menu_transparency_on:not(.vertical_menu_hidden)  .vertical_menu .second .inner ul li.sub ul li a:hover{
            color: <?php echo esc_attr($mkd_options['vertical_transparent_dropdown_hovercolor_thirdlvl']);  ?> !important;
            }
		<?php } ?>




		<?php if ((isset($mkd_options['popup_menu_color']) && !empty($mkd_options['popup_menu_color'])) ||
		          (isset($mkd_options['popup_menu_google_fonts']) && $mkd_options['popup_menu_google_fonts'] != "-1") ||
		          (isset($mkd_options['popup_menu_fontsize']) && !empty($mkd_options['popup_menu_fontsize'])) ||
		          (isset($mkd_options['popup_menu_lineheight']) && !empty($mkd_options['popup_menu_lineheight'])) ||
		          (isset($mkd_options['popup_menu_fontstyle']) && !empty($mkd_options['popup_menu_fontstyle'])) ||
		          (isset($mkd_options['popup_menu_fontweight']) && !empty($mkd_options['popup_menu_fontweight'])) ||
		          (isset($mkd_options['popup_menu_texttransform']) && !empty($mkd_options['popup_menu_texttransform'])) ||
		          (isset($mkd_options['popup_menu_letterspacing']) && $mkd_options['popup_menu_letterspacing'] !== '')) { ?>

            nav.popup_menu > ul > li > a,
            nav.popup_menu > ul > li > h6{
			<?php if (!empty($mkd_options['popup_menu_color'])) { ?> color: <?php echo esc_attr($mkd_options['popup_menu_color']);  ?>; <?php } ?>
			<?php if($mkd_options['popup_menu_google_fonts'] != "-1"){ ?>
                font-family: '<?php echo esc_attr(str_replace('+', ' ', $mkd_options['popup_menu_google_fonts'])); ?>', sans-serif;
			<?php } ?>
			<?php if (!empty($mkd_options['popup_menu_fontsize'])) { ?> font-size: <?php echo esc_attr($mkd_options['popup_menu_fontsize']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['popup_menu_lineheight'])) { ?> line-height: <?php echo esc_attr($mkd_options['popup_menu_lineheight']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['popup_menu_fontstyle'])) { ?> font-style: <?php echo esc_attr($mkd_options['popup_menu_fontstyle']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['popup_menu_fontweight'])) { ?> font-weight: <?php echo esc_attr($mkd_options['popup_menu_fontweight']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['popup_menu_texttransform'])) { ?> text-transform: <?php echo esc_attr($mkd_options['popup_menu_texttransform']);  ?>; <?php } ?>
			<?php if ($mkd_options['popup_menu_letterspacing'] !== '') { ?> letter-spacing: <?php echo esc_attr($mkd_options['popup_menu_letterspacing']);  ?>px; <?php } ?>
            }
		<?php } ?>

		<?php if (isset($mkd_options['popup_menu_color']) && !empty($mkd_options['popup_menu_color'])) { ?>
            .popup_menu.opened .line:after,
            .popup_menu.opened .line:before{
            background-color: <?php echo esc_attr($mkd_options['popup_menu_color']);  ?>;
            }

		<?php } ?>

		<?php if ((isset($mkd_options['popup_menu_hover_color']) && !empty($mkd_options['popup_menu_hover_color'])) || (isset($mkd_options['popup_menu_hover_background_color']) && !empty($mkd_options['popup_menu_hover_background_color']))) { ?>
            nav.popup_menu > ul > li > a:hover,
            nav.popup_menu > ul > li > h6:hover{
			<?php if (!empty($mkd_options['popup_menu_hover_color'])) { ?>  color: <?php echo esc_attr($mkd_options['popup_menu_hover_color']);  ?>;<?php } ?>
			<?php if (!empty($mkd_options['popup_menu_hover_background_color'])) { ?> background-color: <?php echo esc_attr($mkd_options['popup_menu_hover_background_color']);  ?>; <?php } ?>
            }

		<?php } ?>

		<?php if ((isset($mkd_options['popup_menu_color_2nd']) && !empty($mkd_options['popup_menu_color_2nd'])) ||
		          (isset($mkd_options['popup_menu_google_fonts_2nd']) && $mkd_options['popup_menu_google_fonts_2nd'] != "-1") ||
		          (isset($mkd_options['popup_menu_fontsize_2nd']) && !empty($mkd_options['popup_menu_fontsize_2nd'])) ||
		          (isset($mkd_options['popup_menu_lineheight_2nd']) && !empty($mkd_options['popup_menu_lineheight_2nd'])) ||
		          (isset($mkd_options['popup_menu_fontstyle_2nd']) && !empty($mkd_options['popup_menu_fontstyle_2nd'])) ||
		          (isset($mkd_options['popup_menu_fontweight_2nd']) && !empty($mkd_options['popup_menu_fontweight_2nd'])) ||
		          (isset($mkd_options['popup_menu_texttransform_2nd']) && !empty($mkd_options['popup_menu_texttransform_2nd'])) ||
		          (isset($mkd_options['popup_menu_letterspacing_2nd']) && $mkd_options['popup_menu_letterspacing_2nd'] !== '')) { ?>

            nav.popup_menu ul li ul li a,
            nav.popup_menu ul li ul li h6{
			<?php if (!empty($mkd_options['popup_menu_color_2nd'])) { ?> color: <?php echo esc_attr($mkd_options['popup_menu_color_2nd']);  ?>; <?php } ?>
			<?php if($mkd_options['popup_menu_google_fonts_2nd'] != "-1"){ ?>
                font-family: '<?php echo esc_attr(str_replace('+', ' ', $mkd_options['popup_menu_google_fonts_2nd'])); ?>', sans-serif;
			<?php } ?>
			<?php if (!empty($mkd_options['popup_menu_fontsize_2nd'])) { ?> font-size: <?php echo esc_attr($mkd_options['popup_menu_fontsize_2nd']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['popup_menu_lineheight_2nd'])) { ?> line-height: <?php echo esc_attr($mkd_options['popup_menu_lineheight_2nd']);  ?>px; <?php } ?>
			<?php if (!empty($mkd_options['popup_menu_fontstyle_2nd'])) { ?> font-style: <?php echo esc_attr($mkd_options['popup_menu_fontstyle_2nd']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['popup_menu_fontweight_2nd'])) { ?> font-weight: <?php echo esc_attr($mkd_options['popup_menu_fontweight_2nd']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['popup_menu_texttransform_2nd'])) { ?> text-transform: <?php echo esc_attr($mkd_options['popup_menu_texttransform_2nd']);  ?>; <?php } ?>
			<?php if ($mkd_options['popup_menu_letterspacing_2nd'] !== '') { ?> letter-spacing: <?php echo esc_attr($mkd_options['popup_menu_letterspacing_2nd']);  ?>px; <?php } ?>
            }
		<?php } ?>

		<?php if ((isset($mkd_options['popup_menu_hover_color_2nd']) && !empty($mkd_options['popup_menu_hover_color_2nd'])) || (isset($mkd_options['popup_menu_hover_background_color_2nd']) && !empty($mkd_options['popup_menu_hover_background_color_2nd']))) { ?>
            nav.popup_menu ul li ul li a:hover,
            nav.popup_menu ul li ul li h6:hover{
			<?php if (!empty($mkd_options['popup_menu_hover_color_2nd'])) { ?>  color: <?php echo esc_attr($mkd_options['popup_menu_hover_color_2nd']);  ?>;<?php } ?>
			<?php if (!empty($mkd_options['popup_menu_hover_background_color_2nd'])) { ?> background-color: <?php echo esc_attr($mkd_options['popup_menu_hover_background_color_2nd']);  ?>; <?php } ?>
            }

		<?php } ?>

		<?php
		$popup_menu_3rd_style = array();

		if(isset($mkd_options['popup_menu_3rd_font_family']) && $mkd_options['popup_menu_3rd_font_family'] !== '-1') {
			$popup_menu_3rd_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['popup_menu_3rd_font_family']).', sans-serif';
		}

		if(isset($mkd_options['popup_menu_3rd_font_size']) && $mkd_options['popup_menu_3rd_font_size'] !== '') {
			$popup_menu_3rd_style[] = 'font-size: '.intval($mkd_options['popup_menu_3rd_font_size']).'px';
		}

		if(isset($mkd_options['popup_menu_3rd_line_height']) && $mkd_options['popup_menu_3rd_line_height'] !== '') {
			$popup_menu_3rd_style[] = 'line-height: '.intval($mkd_options['popup_menu_3rd_line_height']).'px';
		}

		if(isset($mkd_options['popup_menu_3rd_letter_spacing']) && $mkd_options['popup_menu_3rd_letter_spacing'] !== '') {
			$popup_menu_3rd_style[] = 'letter-spacing: '.intval($mkd_options['popup_menu_3rd_letter_spacing']).'px';
		}

		if(isset($mkd_options['popup_menu_3rd_font_weight']) && $mkd_options['popup_menu_3rd_font_weight'] !== '') {
			$popup_menu_3rd_style[] = 'font-weight: '.intval($mkd_options['popup_menu_3rd_font_weight']);
		}

		if(isset($mkd_options['popup_menu_3rd_font_style']) && $mkd_options['popup_menu_3rd_font_style'] !== '') {
			$popup_menu_3rd_style[] = 'font-style: '.$mkd_options['popup_menu_3rd_font_style'];
		}

		if(isset($mkd_options['popup_menu_3rd_text_transform']) && $mkd_options['popup_menu_3rd_text_transform'] !== '') {
			$popup_menu_3rd_style[] = 'text-transform: '.$mkd_options['popup_menu_3rd_text_transform'];
		}

		if(isset($mkd_options['popup_menu_3rd_color']) && $mkd_options['popup_menu_3rd_color'] !== '') {
			$popup_menu_3rd_style[] = 'color: '.$mkd_options['popup_menu_3rd_color'];
		}

		if(is_array($popup_menu_3rd_style) && count($popup_menu_3rd_style)) { ?>
            nav.popup_menu ul li ul li ul li a{
			<?php echo esc_attr(implode(';', $popup_menu_3rd_style)); ?>
            }
		<?php } ?>

		<?php if ((isset($mkd_options['popup_menu_3rd_hover_color']) && !empty($mkd_options['popup_menu_3rd_hover_color'])) || (isset($mkd_options['popup_menu_3rd_hover_background_color']) && !empty($mkd_options['popup_menu_3rd_hover_background_color']))) { ?>
            nav.popup_menu ul li ul li ul li a:hover{
			<?php if (!empty($mkd_options['popup_menu_3rd_hover_color'])) { ?>  color: <?php echo esc_attr($mkd_options['popup_menu_3rd_hover_color']);  ?>;<?php } ?>
			<?php if (!empty($mkd_options['popup_menu_3rd_hover_background_color'])) { ?> background-color: <?php echo esc_attr($mkd_options['popup_menu_3rd_hover_background_color']);  ?>; <?php } ?>
            }
		<?php } ?>

		<?php if(!empty($mkd_options['popup_menu_background_color']) || !empty($mkd_options['pattern_image_popup'])) { ?>
			<?php $popup_menu_background_color = mikado_one_mikado_hex2rgb($mkd_options['popup_menu_background_color']); ?>

            .popup_menu_holder{
			<?php if (!empty($mkd_options['popup_menu_background_color'])) { ?>  background-color: rgba(<?php echo esc_attr($popup_menu_background_color[0]); ?>,<?php echo esc_attr($popup_menu_background_color[1]); ?>,<?php echo esc_attr($popup_menu_background_color[2]); ?>,0.9); <?php } ?>
			<?php if (!empty($mkd_options['pattern_image_popup'])) { ?> background-image:url('<?php echo esc_attr($mkd_options['pattern_image_popup']); ?>');  <?php } ?>
            }
		<?php } ?>

		<?php if (isset($mkd_options['portfolio_list_box_background_color']) && !empty($mkd_options['portfolio_list_box_background_color'])) { ?>
            .projects_holder article .portfolio_description{
            background-color: <?php echo esc_attr($mkd_options['portfolio_list_box_background_color']); ?>;
            }
		<?php } ?>

		<?php if (isset($mkd_options['portfolio_disable_text_box']) && $mkd_options['portfolio_disable_text_box'] == "yes") { ?>
            .projects_holder article .portfolio_description{
            background-color: transparent;
            }

            .projects_holder.standard article .portfolio_description,
            .projects_holder.standard_no_space article .portfolio_description {
            padding-left: 0;
            padding-right: 0;
            }

            .masonry_with_space .projects_holder article .portfolio_description {
            padding: 35px 0 43px;
            }
		<?php } ?>

		<?php if (isset($mkd_options['portfolio_shader_color']) && !empty($mkd_options['portfolio_shader_color'])) { ?>
			<?php if(isset($mkd_options['portfolio_shader_transparency']) && $mkd_options['portfolio_shader_transparency'] != ""){
				$portfolio_shader_transparency = $mkd_options['portfolio_shader_transparency'];
			} else {
				$portfolio_shader_transparency = 1;
			}
			$shader_bg_color = mikado_one_mikado_hex2rgb($mkd_options['portfolio_shader_color']);
			?>

            .projects_holder article .item_holder.gradient_hover .portfolio_shader,
            .projects_masonry_holder article .item_holder.gradient_hover .portfolio_shader,
            .portfolio_slider li.item .item_holder.gradient_hover .portfolio_shader{
            background: -webkit-linear-gradient(top, rgba(<?php echo esc_attr($shader_bg_color[0]); ?>,<?php echo esc_attr($shader_bg_color[1]); ?>,<?php echo esc_attr($shader_bg_color[2]); ?>,0) 10%, rgba(<?php echo esc_attr($shader_bg_color[0]); ?>,<?php echo esc_attr($shader_bg_color[1]); ?>,<?php echo esc_attr($shader_bg_color[2]); ?>,0.9) 100%);
            background: linear-gradient(to bottom, rgba(<?php echo esc_attr($shader_bg_color[0]); ?>,<?php echo esc_attr($shader_bg_color[1]); ?>,<?php echo esc_attr($shader_bg_color[2]); ?>,0) 10%, rgba(<?php echo esc_attr($shader_bg_color[0]); ?>,<?php echo esc_attr($shader_bg_color[1]); ?>,<?php echo esc_attr($shader_bg_color[2]); ?>,0.9) 100%);
            }

            .portfolio_main_holder .item_holder.subtle_vertical_hover .portfolio_shader,
            .portfolio_main_holder .item_holder.image_subtle_rotate_zoom_hover .portfolio_shader,
            .portfolio_main_holder .item_holder.image_text_zoom_hover .portfolio_shader,
            .portfolio_main_holder .item_holder.opposite_corners_hover .portfolio_shader,
            .portfolio_main_holder .item_holder.slide_from_left_hover .portfolio_shader,
            .portfolio_main_holder .item_holder.prominent_plain_hover .portfolio_shader,
            .portfolio_main_holder .item_holder.cursor_change_hover .portfolio_shader,
            .portfolio_main_holder .item_holder.slide_up_hover .portfolio_shader{
            background-color: rgba(<?php echo esc_attr($shader_bg_color[0]); ?>,<?php echo esc_attr($shader_bg_color[1]); ?>,<?php echo esc_attr($shader_bg_color[2]); ?>,<?php echo esc_attr($portfolio_shader_transparency); ?>);
            }

            .portfolio_main_holder .item_holder.prominent_blur_hover.blur .portfolio_shader{
            background-color: rgba(<?php echo esc_attr($shader_bg_color[0]); ?>,<?php echo esc_attr($shader_bg_color[1]); ?>,<?php echo esc_attr($shader_bg_color[2]); ?>,0.7);
            }
		<?php } ?>

		<?php
		if (isset($mkd_options['portfolio_box']) && $mkd_options['portfolio_box'] == 'no') { ?>
            .portfolio_single.big-slider .portfolio_container, .portfolio_single.big-images .portfolio_container, .portfolio_single.gallery .portfolio_container{
            background-color: transparent;
			<?php if (isset($mkd_options['portfolio_box_top_padding']) && $mkd_options['portfolio_box_top_padding'] !== '') { ?>
                padding-top: <?php echo esc_attr($mkd_options['portfolio_box_top_padding']);?>px;  <?php } ?>
            padding-left:0;
            padding-right:0;
            }
            @media only screen and (min-width: 1100px){
            .portfolio_single.big-slider .two_columns_75_25 > .column2,
            .portfolio_single.big-images .two_columns_75_25 > .column2,
            .portfolio_single.gallery .two_columns_75_25 > .column2{
            float:right;
            width:auto;
            }
            }

		<?php }
		else{
			if(isset($mkd_options['portfolio_box_background_color']) && !empty($mkd_options['portfolio_box_background_color'])) { ?>
                .portfolio_single.big-slider .portfolio_container, .portfolio_single.big-images .portfolio_container, .portfolio_single.gallery .portfolio_container{
                background-color: <?php echo esc_attr($mkd_options['portfolio_box_background_color']);?>;
                }
			<?php }
			if (isset($mkd_options['portfolio_box_lr_padding']) && $mkd_options['portfolio_box_lr_padding'] !== '') { ?>
                .portfolio_single.big-slider .portfolio_container, .portfolio_single.big-images .portfolio_container, .portfolio_single.gallery .portfolio_container{
                padding: <?php echo esc_attr($mkd_options['portfolio_box_lr_padding']);?>;
                }
			<?php }

		}?>

		<?php
		$portfolio_single_big_title_style = array();

		if(isset($mkd_options['portfolio_single_big_title_font_family']) && $mkd_options['portfolio_single_big_title_font_family'] !== '-1') {
			$portfolio_single_big_title_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['portfolio_single_big_title_font_family']).', sans-serif';
		}

		if(isset($mkd_options['portfolio_single_big_title_font_size']) && $mkd_options['portfolio_single_big_title_font_size'] !== '') {
			$portfolio_single_big_title_style[] = 'font-size: '.intval($mkd_options['portfolio_single_big_title_font_size']).'px';
		}

		if(isset($mkd_options['portfolio_single_big_title_line_height']) && $mkd_options['portfolio_single_big_title_line_height'] !== '') {
			$portfolio_single_big_title_style[] = 'line-height: '.intval($mkd_options['portfolio_single_big_title_line_height']).'px';
		}

		if(isset($mkd_options['portfolio_single_big_title_letter_spacing']) && $mkd_options['portfolio_single_big_title_letter_spacing'] !== '') {
			$portfolio_single_big_title_style[] = 'letter-spacing: '.intval($mkd_options['portfolio_single_big_title_letter_spacing']).'px';
		}

		if(isset($mkd_options['portfolio_single_big_title_font_weight']) && $mkd_options['portfolio_single_big_title_font_weight'] !== '') {
			$portfolio_single_big_title_style[] = 'font-weight: '.intval($mkd_options['portfolio_single_big_title_font_weight']);
		}

		if(isset($mkd_options['portfolio_single_big_title_font_style']) && $mkd_options['portfolio_single_big_title_font_style'] !== '') {
			$portfolio_single_big_title_style[] = 'font-style: '.$mkd_options['portfolio_single_big_title_font_style'];
		}

		if(isset($mkd_options['portfolio_single_big_title_text_transform']) && $mkd_options['portfolio_single_big_title_text_transform'] !== '') {
			$portfolio_single_big_title_style[] = 'text-transform: '.$mkd_options['portfolio_single_big_title_text_transform'];
		}

		if(isset($mkd_options['portfolio_single_big_title_color']) && $mkd_options['portfolio_single_big_title_color'] !== '') {
			$portfolio_single_big_title_style[] = 'color: '.$mkd_options['portfolio_single_big_title_color'];
		}

		if(is_array($portfolio_single_big_title_style) && count($portfolio_single_big_title_style)) { ?>
            .portfolio_single.big-slider h2.portfolio_single_text_title,
            .portfolio_single.big-images h2.portfolio_single_text_title,
            .portfolio_single.gallery h2.portfolio_single_text_title{
			<?php echo esc_attr(implode(';', $portfolio_single_big_title_style)); ?>
            }
		<?php } ?>

		<?php
		$portfolio_single_small_title_style = array();

		if(isset($mkd_options['portfolio_single_small_title_font_family']) && $mkd_options['portfolio_single_small_title_font_family'] !== '-1') {
			$portfolio_single_small_title_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['portfolio_single_small_title_font_family']).', sans-serif';
		}

		if(isset($mkd_options['portfolio_single_small_title_font_size']) && $mkd_options['portfolio_single_small_title_font_size'] !== '') {
			$portfolio_single_small_title_style[] = 'font-size: '.intval($mkd_options['portfolio_single_small_title_font_size']).'px';
		}

		if(isset($mkd_options['portfolio_single_small_title_line_height']) && $mkd_options['portfolio_single_small_title_line_height'] !== '') {
			$portfolio_single_small_title_style[] = 'line-height: '.intval($mkd_options['portfolio_single_small_title_line_height']).'px';
		}

		if(isset($mkd_options['portfolio_single_small_title_letter_spacing']) && $mkd_options['portfolio_single_small_title_letter_spacing'] !== '') {
			$portfolio_single_small_title_style[] = 'letter-spacing: '.intval($mkd_options['portfolio_single_small_title_letter_spacing']).'px';
		}

		if(isset($mkd_options['portfolio_single_small_title_font_weight']) && $mkd_options['portfolio_single_small_title_font_weight'] !== '') {
			$portfolio_single_small_title_style[] = 'font-weight: '.intval($mkd_options['portfolio_single_small_title_font_weight']);
		}

		if(isset($mkd_options['portfolio_single_small_title_font_style']) && $mkd_options['portfolio_single_small_title_font_style'] !== '') {
			$portfolio_single_small_title_style[] = 'font-style: '.$mkd_options['portfolio_single_small_title_font_style'];
		}

		if(isset($mkd_options['portfolio_single_small_title_text_transform']) && $mkd_options['portfolio_single_small_title_text_transform'] !== '') {
			$portfolio_single_small_title_style[] = 'text-transform: '.$mkd_options['portfolio_single_small_title_text_transform'];
		}

		if(isset($mkd_options['portfolio_single_small_title_color']) && $mkd_options['portfolio_single_small_title_color'] !== '') {
			$portfolio_single_small_title_style[] = 'color: '.$mkd_options['portfolio_single_small_title_color'];
		}

		if(is_array($portfolio_single_small_title_style) && count($portfolio_single_small_title_style)) { ?>
            .portfolio_single.small-slider .portfolio_detail > h3.info_section_title,
            .portfolio_single.small-images .portfolio_detail > h3.info_section_title{
			<?php echo esc_attr(implode(';', $portfolio_single_small_title_style)); ?>
            }
		<?php } ?>

		<?php
		$portfolio_single_meta_title_style = array();

		if(isset($mkd_options['portfolio_single_meta_title_font_family']) && $mkd_options['portfolio_single_meta_title_font_family'] !== '-1') {
			$portfolio_single_meta_title_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['portfolio_single_meta_title_font_family']).', sans-serif';
		}

		if(isset($mkd_options['portfolio_single_meta_title_font_size']) && $mkd_options['portfolio_single_meta_title_font_size'] !== '') {
			$portfolio_single_meta_title_style[] = 'font-size: '.intval($mkd_options['portfolio_single_meta_title_font_size']).'px';
		}

		if(isset($mkd_options['portfolio_single_meta_title_font_size']) && $mkd_options['portfolio_single_meta_title_font_size'] !== '') {
			$portfolio_single_meta_title_style[] = 'line-height: '.intval($mkd_options['portfolio_single_meta_title_font_size']).'px';
		}

		if(isset($mkd_options['portfolio_single_meta_title_letter_spacing']) && $mkd_options['portfolio_single_meta_title_letter_spacing'] !== '') {
			$portfolio_single_meta_title_style[] = 'letter-spacing: '.intval($mkd_options['portfolio_single_meta_title_letter_spacing']).'px';
		}

		if(isset($mkd_options['portfolio_single_meta_title_font_weight']) && $mkd_options['portfolio_single_meta_title_font_weight'] !== '') {
			$portfolio_single_meta_title_style[] = 'font-weight: '.intval($mkd_options['portfolio_single_meta_title_font_weight']);
		}

		if(isset($mkd_options['portfolio_single_meta_title_font_style']) && $mkd_options['portfolio_single_meta_title_font_style'] !== '') {
			$portfolio_single_meta_title_style[] = 'font-style: '.$mkd_options['portfolio_single_meta_title_font_style'];
		}

		if(isset($mkd_options['portfolio_single_meta_title_text_transform']) && $mkd_options['portfolio_single_meta_title_text_transform'] !== '') {
			$portfolio_single_meta_title_style[] = 'text-transform: '.$mkd_options['portfolio_single_meta_title_text_transform'];
		}

		if(isset($mkd_options['portfolio_single_meta_title_color']) && $mkd_options['portfolio_single_meta_title_color'] !== '') {
			$portfolio_single_meta_title_style[] = 'color: '.$mkd_options['portfolio_single_meta_title_color'];
		}

		if(is_array($portfolio_single_meta_title_style) && count($portfolio_single_meta_title_style)) { ?>
            .portfolio_detail .info .info_section_title{
			<?php echo esc_attr(implode(';', $portfolio_single_meta_title_style)); ?>
            }
		<?php } ?>

		<?php
		//generate top header styles
		$top_header_font_styles         = '';
		$top_header_font_hover_styles   = '';
		$top_header_border_styles       = '';
		if(isset($mkd_options['top_header_text_color']) && $mkd_options['top_header_text_color'] !== '') {
			$top_header_font_styles .= 'color: '.esc_attr($mkd_options['top_header_text_color']).' !important ;';
		}

		if(isset($mkd_options['top_header_text_hover_color']) && $mkd_options['top_header_text_hover_color'] !== '') {
			$top_header_font_hover_styles .= 'color: '.esc_attr($mkd_options['top_header_text_hover_color']).' !important ;';
		}

		if(isset($mkd_options['top_header_text_font_family']) && $mkd_options['top_header_text_font_family'] !== '-1') {
			$top_header_font_styles .= 'font-family: '.esc_attr(str_replace('+', ' ', $mkd_options['top_header_text_font_family'])).';';
		}

		if(isset($mkd_options['top_header_text_font_size']) && $mkd_options['top_header_text_font_size'] !== '') {
			$top_header_font_styles .= 'font-size: '.esc_attr($mkd_options['top_header_text_font_size']).'px;';
		}

		if(isset($mkd_options['top_header_text_font_style']) && $mkd_options['top_header_text_font_style'] !== '') {
			$top_header_font_styles .= 'font-style: '.esc_attr($mkd_options['top_header_text_font_style']).';';
		}

		if(isset($mkd_options['top_header_text_font_weight']) && $mkd_options['top_header_text_font_weight'] !== '') {
			$top_header_font_styles .= 'font-weight: '.esc_attr($mkd_options['top_header_text_font_weight']).';';
		}

		if(isset($mkd_options['top_header_text_letter_spacing']) && $mkd_options['top_header_text_letter_spacing'] !== '') {
			$top_header_font_styles .= 'letter-spacing: '.esc_attr($mkd_options['top_header_text_letter_spacing']).'px;';
		}

		if(isset($mkd_options['top_header_border_color']) && $mkd_options['top_header_border_color'] !== '') {
			$top_header_border_styles .= 'border-bottom: 1px solid '.esc_attr($mkd_options['top_header_border_color']).';';
		}

		if(isset($mkd_options['top_header_border_weight']) && $mkd_options['top_header_border_weight'] !== '') {
			$top_header_border_styles .= 'border-width: '.esc_attr($mkd_options['top_header_border_weight']).'px;';
		}

		if($top_header_font_styles !== '') {
			?>
            .header_top .mkd_social_icon_holder i.simple_social,
            .header_top .header-widget,
            .header_top .textwidget,
            .header_top .header-widget.widget_nav_menu ul.menu>li>a,
            .header_top .header-widget p,
            .header_top .header-widget a:not(.qbutton),
            .header_top .header-widget span {
			<?php echo esc_attr($top_header_font_styles); ?>
            }

			<?php
		}

		if($top_header_font_hover_styles !== '') {
			?>
            .header_top .mkd_social_icon_holder i.simple_social:hover,
            .header_top .header-widget:hover,
            .header_top .header-widget.widget_nav_menu ul.menu>li>a:hover,
            .header_top .header-widget p:hover,
            .header_top .header-widget a:hover,
            .header_top .header-widget span:hover {
			<?php echo esc_attr($top_header_font_hover_styles); ?>
            }

			<?php
		}

		if($top_header_border_styles !== '') {
			?>
            .header_top {
			<?php echo esc_attr($top_header_border_styles); ?>
            }

			<?php
		}
		?>

		<?php
		if(isset($mkd_options['top_header_text_line_height']) && $mkd_options['top_header_text_line_height'] !== '') {

			if($mkd_options['top_header_text_line_height'] < 35){ ?>
                .header_top .mkd_social_icon_holder i.simple_social,
                .header_top .header-widget,
                .header_top .textwidget,
                .header_top .header-widget.widget_nav_menu ul.menu>li>a,
                .header_top .header-widget p,
                .header_top .header-widget a:not(.qbutton),
                .header_top .header-widget span{
                line-height: <?php echo esc_attr($mkd_options['top_header_text_line_height']); ?>px !important;
                height: <?php echo esc_attr($mkd_options['top_header_text_line_height']); ?>px !important;
                }
			<?php } else { ?>
                .header_top .mkd_social_icon_holder i.simple_social,
                .header_top .header-widget,
                .header_top .textwidget,
                .header_top .header-widget.widget_nav_menu ul.menu>li>a,
                .header_top .header-widget p,
                .header_top .header-widget a:not(.qbutton),
                .header_top .header-widget span{
                line-height: 35px !important;
                height: 35px !important;
                }
			<?php } } ?>



		<?php if(isset($mkd_options['top_header_text_hover_color']) && $mkd_options['top_header_text_hover_color'] !== '') { ?>
            .header_top #lang_sel > ul > li:hover > a,
            .header_top #lang_sel_click > ul > li:hover > a{
            color: <?php echo esc_attr($mkd_options['top_header_text_hover_color']); ?> !important;
            }
		<?php } ?>

		<?php if(isset($mkd_options['top_header_text_color']) && $mkd_options['top_header_text_color'] !== '') { ?>
            .header_top #lang_sel > ul > li > a,
            .header_top #lang_sel_click > ul > li > a{
            color: <?php echo esc_attr($mkd_options['top_header_text_color']); ?> !important;
            }
		<?php } ?>

		<?php if (isset($mkd_options['portfolio_filter_margin_bottom']) && $mkd_options['portfolio_filter_margin_bottom'] !== '') { ?>
            .filter_outer.filter_portfolio{
            margin-bottom: <?php echo esc_attr($mkd_options['portfolio_filter_margin_bottom']); ?>px !important;
            }
		<?php } ?>

		<?php
		//generate categories filter title styles
		$portfolio_filter_title_font_styles = '';
		if(isset($mkd_options['portfolio_filter_title_color']) && $mkd_options['portfolio_filter_title_color'] !== '') {
			$portfolio_filter_title_font_styles .= 'color: '.esc_attr($mkd_options['portfolio_filter_title_color']).';';
		}

		if(isset($mkd_options['portfolio_filter_title_font_family']) && $mkd_options['portfolio_filter_title_font_family'] !== '-1') {
			$portfolio_filter_title_font_styles .= 'font-family: '.esc_attr(str_replace('+', ' ', $mkd_options['portfolio_filter_title_font_family'])).';';
		}

		if(isset($mkd_options['portfolio_filter_title_font_size']) && $mkd_options['portfolio_filter_title_font_size'] !== '') {
			$portfolio_filter_title_font_styles .= 'font-size: '.esc_attr($mkd_options['portfolio_filter_title_font_size']).'px;';
		}

		if(isset($mkd_options['portfolio_filter_title_line_height']) && $mkd_options['portfolio_filter_title_line_height'] !== '') {
			$portfolio_filter_title_font_styles .= 'line-height: '.esc_attr($mkd_options['portfolio_filter_title_line_height']).'px;';
		}

		if(isset($mkd_options['portfolio_filter_title_font_style']) && $mkd_options['portfolio_filter_title_font_style'] !== '') {
			$portfolio_filter_title_font_styles .= 'font-style: '.esc_attr($mkd_options['portfolio_filter_title_font_style']).';';
		}

		if(isset($mkd_options['portfolio_filter_title_font_weight']) && $mkd_options['portfolio_filter_title_font_weight'] !== '') {
			$portfolio_filter_title_font_styles .= 'font-weight: '.esc_attr($mkd_options['portfolio_filter_title_font_weight']).';';
		}

		if(isset($mkd_options['portfolio_filter_title_letter_spacing']) && $mkd_options['portfolio_filter_title_letter_spacing'] !== '') {
			$portfolio_filter_title_font_styles .= 'letter-spacing: '.esc_attr($mkd_options['portfolio_filter_title_letter_spacing']).'px;';
		}

		if(isset($mkd_options['portfolio_filter_title_text_transform']) && $mkd_options['portfolio_filter_title_text_transform'] !== '') {
			$portfolio_filter_title_font_styles .= 'text-transform: '.esc_attr($mkd_options['portfolio_filter_title_text_transform']).';';
		}

		if($portfolio_filter_title_font_styles !== '') {
			?>
            .filter_portfolio .filter_holder ul li.filter_title span{
			<?php echo esc_attr($portfolio_filter_title_font_styles); ?>
            }
		<?php } ?>



		<?php
		//generate categories filter styles
		$portfolio_filter_font_styles = '';
		$portfolio_filter_font_hover_styles = '';
		if(isset($mkd_options['portfolio_filter_color']) && $mkd_options['portfolio_filter_color'] !== '') {
			$portfolio_filter_font_styles .= 'color: '.esc_attr($mkd_options['portfolio_filter_color']).';';
		}

		if(isset($mkd_options['portfolio_filter_hovercolor']) && $mkd_options['portfolio_filter_hovercolor'] !== '') {
			$portfolio_filter_font_hover_styles .= 'color: '.esc_attr($mkd_options['portfolio_filter_hovercolor']).' !important;';
		}

		if(isset($mkd_options['portfolio_filter_font_family']) && $mkd_options['portfolio_filter_font_family'] !== '-1') {
			$portfolio_filter_font_styles .= 'font-family: '.esc_attr(str_replace('+', ' ', $mkd_options['portfolio_filter_font_family'])).';';
		}

		if(isset($mkd_options['portfolio_filter_font_size']) && $mkd_options['portfolio_filter_font_size'] !== '') {
			$portfolio_filter_font_styles .= 'font-size: '.esc_attr($mkd_options['portfolio_filter_font_size']).'px;';
		}

		if(isset($mkd_options['portfolio_filter_line_height']) && $mkd_options['portfolio_filter_line_height'] !== '') {
			$portfolio_filter_font_styles .= 'line-height: '.esc_attr($mkd_options['portfolio_filter_line_height']).'px;';
		}

		if(isset($mkd_options['portfolio_filter_font_style']) && $mkd_options['portfolio_filter_font_style'] !== '') {
			$portfolio_filter_font_styles .= 'font-style: '.esc_attr($mkd_options['portfolio_filter_font_style']).';';
		}

		if(isset($mkd_options['portfolio_filter_font_weight']) && $mkd_options['portfolio_filter_font_weight'] !== '') {
			$portfolio_filter_font_styles .= 'font-weight: '.esc_attr($mkd_options['portfolio_filter_font_weight']).';';
		}

		if(isset($mkd_options['portfolio_filter_letter_spacing']) && $mkd_options['portfolio_filter_letter_spacing'] !== '') {
			$portfolio_filter_font_styles .= 'letter-spacing: '.esc_attr($mkd_options['portfolio_filter_letter_spacing']).'px;';
		}

		if(isset($mkd_options['portfolio_filter_text_transform']) && $mkd_options['portfolio_filter_text_transform'] !== '') {
			$portfolio_filter_font_styles .= 'text-transform: '.esc_attr($mkd_options['portfolio_filter_text_transform']).';';
		}

		if($portfolio_filter_font_styles !== '') {
			?>
            .filter_portfolio .filter_holder ul li:not(.filter_title) span{
			<?php echo esc_attr($portfolio_filter_font_styles); ?>
            }
			<?php
			if($mkd_options['portfolio_filter_color'] !== ''){
				?>
                .filter_holder ul li span:after{
                color: <?php echo esc_attr($mkd_options['portfolio_filter_color']); ?>;
                }
				<?php
			}
		}
		if($portfolio_filter_font_hover_styles !== '') {
			?>
            .filter_portfolio .filter_holder ul li.current span,
            .filter_portfolio .filter_holder ul li:not(.filter_title):hover span{
			<?php echo esc_attr($portfolio_filter_font_hover_styles); ?>
            }

			<?php
		}
		?>

		<?php
		$portfolio_list_filter_styles = '';
		if(isset($mkd_options['portfolio_list_filter_height']) && $mkd_options['portfolio_list_filter_height'] !== '') {
			$portfolio_list_filter_styles .= 'height: '.intval($mkd_options['portfolio_list_filter_height']).'px;';
		}

		if(isset($mkd_options['portfolio_list_filter_background_color']) && $mkd_options['portfolio_list_filter_background_color'] !== '') {
			$portfolio_list_filter_styles .= 'background-color: '.$mkd_options['portfolio_list_filter_background_color'].';';
		}

		if($portfolio_list_filter_styles !== '') {
			?>
            .filter_portfolio.filter_outer{
			<?php echo esc_attr($portfolio_list_filter_styles); ?>
            }
			<?php
		}
		?>

		<?php
		//generate BLOG MASONRY categories filter title styles
		$blog_masonry_filter_title_font_styles = '';
		if(isset($mkd_options['blog_masonry_filter_title_color']) && $mkd_options['blog_masonry_filter_title_color'] !== '') {
			$blog_masonry_filter_title_font_styles .= 'color: '.esc_attr($mkd_options['blog_masonry_filter_title_color']).';';
		}

		if(isset($mkd_options['blog_masonry_filter_title_font_family']) && $mkd_options['blog_masonry_filter_title_font_family'] !== '-1') {
			$blog_masonry_filter_title_font_styles .= 'font-family: '.esc_attr(str_replace('+', ' ', $mkd_options['blog_masonry_filter_title_font_family'])).';';
		}

		if(isset($mkd_options['blog_masonry_filter_title_font_size']) && $mkd_options['blog_masonry_filter_title_font_size'] !== '') {
			$blog_masonry_filter_title_font_styles .= 'font-size: '.esc_attr($mkd_options['blog_masonry_filter_title_font_size']).'px;';
		}

		if(isset($mkd_options['blog_masonry_filter_title_line_height']) && $mkd_options['blog_masonry_filter_title_line_height'] !== '') {
			$blog_masonry_filter_title_font_styles .= 'line-height: '.esc_attr($mkd_options['blog_masonry_filter_title_line_height']).'px;';
		}

		if(isset($mkd_options['blog_masonry_filter_title_font_style']) && $mkd_options['blog_masonry_filter_title_font_style'] !== '') {
			$blog_masonry_filter_title_font_styles .= 'font-style: '.esc_attr($mkd_options['blog_masonry_filter_title_font_style']).';';
		}

		if(isset($mkd_options['blog_masonry_filter_title_font_weight']) && $mkd_options['blog_masonry_filter_title_font_weight'] !== '') {
			$blog_masonry_filter_title_font_styles .= 'font-weight: '.esc_attr($mkd_options['blog_masonry_filter_title_font_weight']).';';
		}

		if(isset($mkd_options['blog_masonry_filter_title_letter_spacing']) && $mkd_options['blog_masonry_filter_title_letter_spacing'] !== '') {
			$blog_masonry_filter_title_font_styles .= 'letter-spacing: '.esc_attr($mkd_options['blog_masonry_filter_title_letter_spacing']).'px;';
		}

		if(isset($mkd_options['blog_masonry_filter_title_text_transform']) && $mkd_options['blog_masonry_filter_title_text_transform'] !== '') {
			$blog_masonry_filter_title_font_styles .= 'text-transform: '.esc_attr($mkd_options['blog_masonry_filter_title_text_transform']).';';
		}

		if($blog_masonry_filter_title_font_styles !== '') {
			?>
            .filter_blog .filter_holder ul li.filter_title span{
			<?php echo esc_attr($blog_masonry_filter_title_font_styles); ?>
            }
		<?php } ?>

		<?php
		//generate BLOG MASONRY filter styles
		$blog_masonry_filter_font_styles = '';
		$blog_masonry_filter_font_hover_styles = '';
		if(isset($mkd_options['blog_masonry_filter_color']) && $mkd_options['blog_masonry_filter_color'] !== '') {
			$blog_masonry_filter_font_styles .= 'color: '.esc_attr($mkd_options['blog_masonry_filter_color']).';';
		}

		if(isset($mkd_options['blog_masonry_filter_hovercolor']) && $mkd_options['blog_masonry_filter_hovercolor'] !== '') {
			$blog_masonry_filter_font_hover_styles .= 'color: '.intval($mkd_options['blog_masonry_filter_hovercolor']).' !important;';
		}

		if(isset($mkd_options['blog_masonry_filter_font_family']) && $mkd_options['blog_masonry_filter_font_family'] !== '-1') {
			$blog_masonry_filter_font_styles .= 'font-family: '.esc_attr(str_replace('+', ' ', $mkd_options['blog_masonry_filter_font_family'])).';';
		}

		if(isset($mkd_options['blog_masonry_filter_font_size']) && $mkd_options['blog_masonry_filter_font_size'] !== '') {
			$blog_masonry_filter_font_styles .= 'font-size: '.esc_attr($mkd_options['blog_masonry_filter_font_size']).'px;';
		}

		if(isset($mkd_options['blog_masonry_filter_line_height']) && $mkd_options['blog_masonry_filter_line_height'] !== '') {
			$blog_masonry_filter_font_styles .= 'line-height: '.esc_attr($mkd_options['blog_masonry_filter_line_height']).'px;';
		}

		if(isset($mkd_options['blog_masonry_filter_font_style']) && $mkd_options['blog_masonry_filter_font_style'] !== '') {
			$blog_masonry_filter_font_styles .= 'font-style: '.esc_attr($mkd_options['blog_masonry_filter_font_style']).';';
		}

		if(isset($mkd_options['blog_masonry_filter_font_weight']) && $mkd_options['blog_masonry_filter_font_weight'] !== '') {
			$blog_masonry_filter_font_styles .= 'font-weight: '.esc_attr($mkd_options['blog_masonry_filter_font_weight']).';';
		}

		if(isset($mkd_options['blog_masonry_filter_letter_spacing']) && $mkd_options['blog_masonry_filter_letter_spacing'] !== '') {
			$blog_masonry_filter_font_styles .= 'letter-spacing: '.esc_attr($mkd_options['blog_masonry_filter_letter_spacing']).'px;';
		}

		if(isset($mkd_options['blog_masonry_filter_text_transform']) && $mkd_options['blog_masonry_filter_text_transform'] !== '') {
			$blog_masonry_filter_font_styles .= 'text-transform: '.esc_attr($mkd_options['blog_masonry_filter_text_transform']).';';
		}

		if($blog_masonry_filter_font_styles !== '') {
			?>
            .filter_blog .filter_holder ul li:not(.filter_title) span{
			<?php echo esc_attr($blog_masonry_filter_font_styles); ?>
            }
			<?php
			if($mkd_options['blog_masonry_filter_color'] !== ''){
				?>
                .filter_holder ul li span:after{
                color: <?php echo esc_attr($mkd_options['blog_masonry_filter_color']); ?>;
                }
				<?php
			}
		}
		if($blog_masonry_filter_font_hover_styles !== '') {
			?>
            .filter_blog .filter_holder ul li.current span,
            .filter_blog .filter_holder ul li:not(.filter_title):hover span{
			<?php echo esc_attr($blog_masonry_filter_font_hover_styles); ?>
            }

			<?php
		}
		?>

		<?php
		$blog_masonry_filter_styles = '';
		if(isset($mkd_options['blog_masonry_filter_height']) && $mkd_options['blog_masonry_filter_height'] !== '') {
			$blog_masonry_filter_styles .= 'height: '.intval($mkd_options['blog_masonry_filter_height']).'px;';
			$blog_masonry_filter_styles .= 'line-height: '.intval($mkd_options['blog_masonry_filter_height']).'px;';
		}

		if(isset($mkd_options['blog_masonry_filter_background_color']) && $mkd_options['blog_masonry_filter_background_color'] !== '') {
			$blog_masonry_filter_styles .= 'background-color: '.$mkd_options['blog_masonry_filter_background_color'].';';
		}

		if(isset($mkd_options['blog_masonry_filter_margin_bottom']) && $mkd_options['blog_masonry_filter_margin_bottom'] !== '') {
			$blog_masonry_filter_styles .= 'margin-bottom: '.intval($mkd_options['blog_masonry_filter_margin_bottom']).'px;';
		}
		if(isset($mkd_options['blog_masonry_filter_alignment']) && $mkd_options['blog_masonry_filter_alignment'] !== '') {
			$blog_masonry_filter_styles .= 'text-align: '.$mkd_options['blog_masonry_filter_alignment'].';';
		}
		if($blog_masonry_filter_styles !== '') {
			?>
            .filter_outer.filter_blog {
			<?php echo esc_attr($blog_masonry_filter_styles); ?>
            }
			<?php
		}
		?>


		<?php
		//generate title on portfolio standard and pinterest lists styles
		$portfolio_title_standard_list_font_styles = '';
		if(isset($mkd_options['portfolio_title_standard_list_color']) && $mkd_options['portfolio_title_standard_list_color'] !== '') {
			$portfolio_title_standard_list_font_styles .= 'color: '.esc_attr($mkd_options['portfolio_title_standard_list_color']).';';
		}

		if(isset($mkd_options['portfolio_title_standard_list_font_family']) && $mkd_options['portfolio_title_standard_list_font_family'] !== '-1') {
			$portfolio_title_standard_list_font_styles .= 'font-family: '.esc_attr(str_replace('+', ' ', $mkd_options['portfolio_title_standard_list_font_family'])).';';
		}

		if(isset($mkd_options['portfolio_title_standard_list_font_size']) && $mkd_options['portfolio_title_standard_list_font_size'] !== '') {
			$portfolio_title_standard_list_font_styles .= 'font-size: '.esc_attr($mkd_options['portfolio_title_standard_list_font_size']).'px;';
		}

		if(isset($mkd_options['portfolio_title_standard_list_line_height']) && $mkd_options['portfolio_title_standard_list_line_height'] !== '') {
			$portfolio_title_standard_list_font_styles .= 'line-height: '.esc_attr($mkd_options['portfolio_title_standard_list_line_height']).'px;';
		}

		if(isset($mkd_options['portfolio_title_standard_list_font_style']) && $mkd_options['portfolio_title_standard_list_font_style'] !== '') {
			$portfolio_title_standard_list_font_styles .= 'font-style: '.esc_attr($mkd_options['portfolio_title_standard_list_font_style']).';';
		}

		if(isset($mkd_options['portfolio_title_standard_list_font_weight']) && $mkd_options['portfolio_title_standard_list_font_weight'] !== '') {
			$portfolio_title_standard_list_font_styles .= 'font-weight: '.esc_attr($mkd_options['portfolio_title_standard_list_font_weight']).';';
		}

		if(isset($mkd_options['portfolio_title_standard_list_letter_spacing']) && $mkd_options['portfolio_title_standard_list_letter_spacing'] !== '') {
			$portfolio_title_standard_list_font_styles .= 'letter-spacing: '.esc_attr($mkd_options['portfolio_title_standard_list_letter_spacing']).'px;';
		}

		if(isset($mkd_options['portfolio_title_standard_list_text_transform']) && $mkd_options['portfolio_title_standard_list_text_transform'] !== '') {
			$portfolio_title_standard_list_font_styles .= 'text-transform: '.esc_attr($mkd_options['portfolio_title_standard_list_text_transform']).';';
		}

		if($portfolio_title_standard_list_font_styles !== '') {
			?>
            .projects_holder.standard article .portfolio_title,
            .projects_holder.standard article .portfolio_title a,
            .projects_holder.standard_no_space article .portfolio_title,
            .projects_holder.standard_no_space article .portfolio_title a{
			<?php echo esc_attr($portfolio_title_standard_list_font_styles); ?>
            }
			<?php
		}

		$portfolio_title_standard_list_hover_styles = '';
		if(isset($mkd_options['portfolio_title_standard_list_hover_color']) && $mkd_options['portfolio_title_standard_list_hover_color'] !== '') {
			$portfolio_title_standard_list_hover_styles .= 'color: '.$mkd_options['portfolio_title_standard_list_hover_color'].';';
		}

		if($portfolio_title_standard_list_hover_styles !== '') {
			?>
            .projects_holder.standard article .portfolio_title a:hover,
            .projects_holder.standard_no_space article .portfolio_title a:hover{
			<?php echo esc_attr($portfolio_title_standard_list_hover_styles); ?>
            }
			<?php
		}
		?>

		<?php
		//generate categories on portfolio standard and pinterest lists styles
		$portfolio_category_standard_list_font_styles = '';
		if(isset($mkd_options['portfolio_category_standard_list_color']) && $mkd_options['portfolio_category_standard_list_color'] !== '') {
			$portfolio_category_standard_list_font_styles .= 'color: '.esc_attr($mkd_options['portfolio_category_standard_list_color']).';';
		}

		if(isset($mkd_options['portfolio_category_standard_list_font_family']) && $mkd_options['portfolio_category_standard_list_font_family'] !== '-1') {
			$portfolio_category_standard_list_font_styles .= 'font-family: '.esc_attr(str_replace('+', ' ', $mkd_options['portfolio_category_standard_list_font_family'])).';';
		}

		if(isset($mkd_options['portfolio_category_standard_list_font_size']) && $mkd_options['portfolio_category_standard_list_font_size'] !== '') {
			$portfolio_category_standard_list_font_styles .= 'font-size: '.esc_attr($mkd_options['portfolio_category_standard_list_font_size']).'px;';
		}

		if(isset($mkd_options['portfolio_category_standard_list_line_height']) && $mkd_options['portfolio_category_standard_list_line_height'] !== '') {
			$portfolio_category_standard_list_font_styles .= 'line-height: '.esc_attr($mkd_options['portfolio_category_standard_list_line_height']).'px;';
		}

		if(isset($mkd_options['portfolio_category_standard_list_font_style']) && $mkd_options['portfolio_category_standard_list_font_style'] !== '') {
			$portfolio_category_standard_list_font_styles .= 'font-style: '.esc_attr($mkd_options['portfolio_category_standard_list_font_style']).';';
		}

		if(isset($mkd_options['portfolio_category_standard_list_font_weight']) && $mkd_options['portfolio_category_standard_list_font_weight'] !== '') {
			$portfolio_category_standard_list_font_styles .= 'font-weight: '.esc_attr($mkd_options['portfolio_category_standard_list_font_weight']).';';
		}

		if(isset($mkd_options['portfolio_category_standard_list_letter_spacing']) && $mkd_options['portfolio_category_standard_list_letter_spacing'] !== '') {
			$portfolio_category_standard_list_font_styles .= 'letter-spacing: '.esc_attr($mkd_options['portfolio_category_standard_list_letter_spacing']).'px;';
		}

		if(isset($mkd_options['portfolio_category_standard_list_text_transform']) && $mkd_options['portfolio_category_standard_list_text_transform'] !== '') {
			$portfolio_category_standard_list_font_styles .= 'text-transform: '.esc_attr($mkd_options['portfolio_category_standard_list_text_transform']).';';
		}

		if($portfolio_category_standard_list_font_styles !== '') {
			?>
            .projects_holder.standard article .project_category,
            .projects_holder.standard_no_space article .project_category{
			<?php echo esc_attr($portfolio_category_standard_list_font_styles); ?>
            }
			<?php
		}
		?>

		<?php
		//generate title on portfolio stext on hover image and text before hover lists styles
		$portfolio_title_hover_box_list_font_styles = '';
		if(isset($mkd_options['portfolio_title_hover_box_list_color']) && $mkd_options['portfolio_title_hover_box_list_color'] !== '') {
			$portfolio_title_hover_box_list_font_styles .= 'color: '.esc_attr($mkd_options['portfolio_title_hover_box_list_color']).';';
		}

		if(isset($mkd_options['portfolio_title_hover_box_list_font_family']) && $mkd_options['portfolio_title_hover_box_list_font_family'] !== '-1') {
			$portfolio_title_hover_box_list_font_styles .= 'font-family: '.esc_attr(str_replace('+', ' ', $mkd_options['portfolio_title_hover_box_list_font_family'])).';';
		}

		if(isset($mkd_options['portfolio_title_hover_box_list_font_size']) && $mkd_options['portfolio_title_hover_box_list_font_size'] !== '') {
			$portfolio_title_hover_box_list_font_styles .= 'font-size: '.esc_attr($mkd_options['portfolio_title_hover_box_list_font_size']).'px;';
		}

		if(isset($mkd_options['portfolio_title_hover_box_list_line_height']) && $mkd_options['portfolio_title_hover_box_list_line_height'] !== '') {
			$portfolio_title_hover_box_list_font_styles .= 'line-height: '.esc_attr($mkd_options['portfolio_title_hover_box_list_line_height']).'px;';
		}

		if(isset($mkd_options['portfolio_title_hover_box_list_font_style']) && $mkd_options['portfolio_title_hover_box_list_font_style'] !== '') {
			$portfolio_title_hover_box_list_font_styles .= 'font-style: '.esc_attr($mkd_options['portfolio_title_hover_box_list_font_style']).';';
		}

		if(isset($mkd_options['portfolio_title_hover_box_list_font_weight']) && $mkd_options['portfolio_title_hover_box_list_font_weight'] !== '') {
			$portfolio_title_hover_box_list_font_styles .= 'font-weight: '.esc_attr($mkd_options['portfolio_title_hover_box_list_font_weight']).';';
		}

		if(isset($mkd_options['portfolio_title_hover_box_list_letter_spacing']) && $mkd_options['portfolio_title_hover_box_list_letter_spacing'] !== '') {
			$portfolio_title_hover_box_list_font_styles .= 'letter-spacing: '.esc_attr($mkd_options['portfolio_title_hover_box_list_letter_spacing']).'px;';
		}

		if(isset($mkd_options['portfolio_title_hover_box_list_text_transform']) && $mkd_options['portfolio_title_hover_box_list_text_transform'] !== '') {
			$portfolio_title_hover_box_list_font_styles .= 'text-transform: '.esc_attr($mkd_options['portfolio_title_hover_box_list_text_transform']).';';
		}

		if($portfolio_title_hover_box_list_font_styles !== '') {
			?>
            .projects_holder.hover_text article .item_holder .portfolio_title,
            .projects_holder.hover_text article .item_holder .portfolio_title a,
            .projects_holder.hover_text.no_space article .item_holder .portfolio_title,
            .projects_holder.hover_text.no_space article .item_holder .portfolio_title a{
			<?php echo esc_attr($portfolio_title_hover_box_list_font_styles); ?>
            }
			<?php
		}

		$portfolio_title_hover_box_list_hover_styles = '';
		if(isset($mkd_options['portfolio_title_hover_box_list_hover_color']) && $mkd_options['portfolio_title_hover_box_list_hover_color'] !== '') {
			$portfolio_title_hover_box_list_hover_styles .= 'color: '.$mkd_options['portfolio_title_hover_box_list_hover_color'].';';
		}

		if($portfolio_title_hover_box_list_hover_styles !== '') {
			?>
            .portfolio_main_holder.projects_holder.hover_text article .portfolio_title:hover a,
            .portfolio_main_holder.projects_holder.hover_text.no_space article .portfolio_title:hover a{
			<?php echo esc_attr($portfolio_title_hover_box_list_hover_styles); ?>
            }
			<?php
		}
		?>

		<?php
		//generate categories on text on hover image and text before hover lists styles
		$portfolio_category_hover_box_list_font_styles = '';
		if(isset($mkd_options['portfolio_category_hover_box_list_color']) && $mkd_options['portfolio_category_hover_box_list_color'] !== '') {
			$portfolio_category_hover_box_list_font_styles .= 'color: '.esc_attr($mkd_options['portfolio_category_hover_box_list_color']).';';
		}

		if(isset($mkd_options['portfolio_category_hover_box_list_font_family']) && $mkd_options['portfolio_category_hover_box_list_font_family'] !== '-1') {
			$portfolio_category_hover_box_list_font_styles .= 'font-family: '.esc_attr(str_replace('+', ' ', $mkd_options['portfolio_category_hover_box_list_font_family'])).';';
		}

		if(isset($mkd_options['portfolio_category_hover_box_list_font_size']) && $mkd_options['portfolio_category_hover_box_list_font_size'] !== '') {
			$portfolio_category_hover_box_list_font_styles .= 'font-size: '.esc_attr($mkd_options['portfolio_category_hover_box_list_font_size']).'px;';
		}

		if(isset($mkd_options['portfolio_category_hover_box_list_line_height']) && $mkd_options['portfolio_category_hover_box_list_line_height'] !== '') {
			$portfolio_category_hover_box_list_font_styles .= 'line-height: '.esc_attr($mkd_options['portfolio_category_hover_box_list_line_height']).'px;';
		}

		if(isset($mkd_options['portfolio_category_hover_box_list_font_style']) && $mkd_options['portfolio_category_hover_box_list_font_style'] !== '') {
			$portfolio_category_hover_box_list_font_styles .= 'font-style: '.esc_attr($mkd_options['portfolio_category_hover_box_list_font_style']).';';
		}

		if(isset($mkd_options['portfolio_category_hover_box_list_font_weight']) && $mkd_options['portfolio_category_hover_box_list_font_weight'] !== '') {
			$portfolio_category_hover_box_list_font_styles .= 'font-weight: '.esc_attr($mkd_options['portfolio_category_hover_box_list_font_weight']).';';
		}

		if(isset($mkd_options['portfolio_category_hover_box_list_letter_spacing']) && $mkd_options['portfolio_category_hover_box_list_letter_spacing'] !== '') {
			$portfolio_category_hover_box_list_font_styles .= 'letter-spacing: '.esc_attr($mkd_options['portfolio_category_hover_box_list_letter_spacing']).'px;';
		}

		if(isset($mkd_options['portfolio_category_hover_box_list_text_transform']) && $mkd_options['portfolio_category_hover_box_list_text_transform'] !== '') {
			$portfolio_category_hover_box_list_font_styles .= 'text-transform: '.esc_attr($mkd_options['portfolio_category_hover_box_list_text_transform']).';';
		}

		if($portfolio_category_hover_box_list_font_styles !== '') {
			?>
            .portfolio_main_holder.projects_holder.hover_text article .project_category,
            .portfolio_main_holder.projects_holder.hover_text.no_space article .project_category,
            .portfolio_main_holder.projects_holder article:hover .item_holder.image_subtle_rotate_zoom_hover .project_category,
            .portfolio_main_holder.projects_holder article:hover .item_holder.subtle_vertical_hover .project_category,
            .portfolio_main_holder.projects_holder article:hover .item_holder.slide_up_hover .project_category{
			<?php echo esc_attr($portfolio_category_hover_box_list_font_styles); ?>
            }
			<?php
		}
		?>

		<?php
		//generate title on portfolio gallery and masonry lists styles
		$portfolio_title_list_font_styles = '';
		if(isset($mkd_options['portfolio_title_list_color']) && $mkd_options['portfolio_title_list_color'] !== '') {
			$portfolio_title_list_font_styles .= 'color: '.esc_attr($mkd_options['portfolio_title_list_color']).';';
		}

		if(isset($mkd_options['portfolio_title_list_font_family']) && $mkd_options['portfolio_title_list_font_family'] !== '-1') {
			$portfolio_title_list_font_styles .= 'font-family: '.esc_attr(str_replace('+', ' ', $mkd_options['portfolio_title_list_font_family'])).';';
		}

		if(isset($mkd_options['portfolio_title_list_font_size']) && $mkd_options['portfolio_title_list_font_size'] !== '') {
			$portfolio_title_list_font_styles .= 'font-size: '.esc_attr($mkd_options['portfolio_title_list_font_size']).'px;';
		}

		if(isset($mkd_options['portfolio_title_list_line_height']) && $mkd_options['portfolio_title_list_line_height'] !== '') {
			$portfolio_title_list_font_styles .= 'line-height: '.esc_attr($mkd_options['portfolio_title_list_line_height']).'px;';
		}

		if(isset($mkd_options['portfolio_title_list_font_style']) && $mkd_options['portfolio_title_list_font_style'] !== '') {
			$portfolio_title_list_font_styles .= 'font-style: '.esc_attr($mkd_options['portfolio_title_list_font_style']).';';
		}

		if(isset($mkd_options['portfolio_title_list_font_weight']) && $mkd_options['portfolio_title_list_font_weight'] !== '') {
			$portfolio_title_list_font_styles .= 'font-weight: '.esc_attr($mkd_options['portfolio_title_list_font_weight']).';';
		}

		if(isset($mkd_options['portfolio_title_list_letter_spacing']) && $mkd_options['portfolio_title_list_letter_spacing'] !== '') {
			$portfolio_title_list_font_styles .= 'letter-spacing: '.esc_attr($mkd_options['portfolio_title_list_letter_spacing']).'px;';
		}

		if(isset($mkd_options['portfolio_title_list_text_transform']) && $mkd_options['portfolio_title_list_text_transform'] !== '') {
			$portfolio_title_list_font_styles .= 'text-transform: '.esc_attr($mkd_options['portfolio_title_list_text_transform']).';';
		}

		if($portfolio_title_list_font_styles !== '') {
			?>
            .portfolio_main_holder.projects_masonry_holder article .item_holder .portfolio_title a,
            .portfolio_main_holder .portfolio_slides li.item .item_holder .portfolio_title a,
            .portfolio_main_holder.projects_masonry_holder article .item_holder .portfolio_title,
            .portfolio_main_holder .portfolio_slides li.item .item_holder .portfolio_title{
			<?php echo esc_attr($portfolio_title_list_font_styles); ?>
            }
			<?php
		}
		?>

		<?php
		$portfolio_title_list_hover_styles = '';
		if(isset($mkd_options['portfolio_title_list_hover_color']) && $mkd_options['portfolio_title_list_hover_color'] !== '') {
			$portfolio_title_list_hover_styles .= 'color: '.$mkd_options['portfolio_title_list_hover_color'].';';
		}

		if($portfolio_title_list_hover_styles !== '') {
			?>
            .portfolio_main_holder.portfolio_slider_holder li.item .item_holder .portfolio_title a:hover,
            .portfolio_main_holder.projects_masonry_holder article .item_holder .portfolio_title a:hover{
			<?php echo esc_attr($portfolio_title_list_hover_styles); ?>
            }
			<?php
		}
		?>

		<?php
		//generate categories on portfolio gallery and masonry lists styles
		$portfolio_category_list_font_styles = '';
		if(isset($mkd_options['portfolio_category_list_color']) && $mkd_options['portfolio_category_list_color'] !== '') {
			$portfolio_category_list_font_styles .= 'color: '.esc_attr($mkd_options['portfolio_category_list_color']).';';
		}

		if(isset($mkd_options['portfolio_category_list_font_family']) && $mkd_options['portfolio_category_list_font_family'] !== '-1') {
			$portfolio_category_list_font_styles .= 'font-family: '.esc_attr(str_replace('+', ' ', $mkd_options['portfolio_category_list_font_family'])).';';
		}

		if(isset($mkd_options['portfolio_category_list_font_size']) && $mkd_options['portfolio_category_list_font_size'] !== '') {
			$portfolio_category_list_font_styles .= 'font-size: '.esc_attr($mkd_options['portfolio_category_list_font_size']).'px;';
		}

		if(isset($mkd_options['portfolio_category_list_line_height']) && $mkd_options['portfolio_category_list_line_height'] !== '') {
			$portfolio_category_list_font_styles .= 'line-height: '.esc_attr($mkd_options['portfolio_category_list_line_height']).'px;';
		}

		if(isset($mkd_options['portfolio_category_list_font_style']) && $mkd_options['portfolio_category_list_font_style'] !== '') {
			$portfolio_category_list_font_styles .= 'font-style: '.esc_attr($mkd_options['portfolio_category_list_font_style']).';';
		}

		if(isset($mkd_options['portfolio_category_list_font_weight']) && $mkd_options['portfolio_category_list_font_weight'] !== '') {
			$portfolio_category_list_font_styles .= 'font-weight: '.esc_attr($mkd_options['portfolio_category_list_font_weight']).';';
		}

		if(isset($mkd_options['portfolio_category_list_letter_spacing']) && $mkd_options['portfolio_category_list_letter_spacing'] !== '') {
			$portfolio_category_list_font_styles .= 'letter-spacing: '.esc_attr($mkd_options['portfolio_category_list_letter_spacing']).'px;';
		}

		if(isset($mkd_options['portfolio_category_list_text_transform']) && $mkd_options['portfolio_category_list_text_transform'] !== '') {
			$portfolio_category_list_font_styles .= 'text-transform: '.esc_attr($mkd_options['portfolio_category_list_text_transform']).';';
		}

		if($portfolio_category_list_font_styles !== '') {
			?>
            .portfolio_main_holder.projects_masonry_holder .item_holder .project_category,
            .portfolio_main_holder .portfolio_slides .item_holder .project_category,
            .portfolio_main_holder.projects_masonry_holder article:hover .item_holder .project_category,
            .portfolio_main_holder .portfolio_slider li.item:hover .item_holder .project_category{
			<?php echo esc_attr($portfolio_category_list_font_styles); ?>
            }
			<?php
		}
		?>

		<?php if (!empty($mkd_options['portfolio_list_icons_color']) || !empty($mkd_options['portfolio_list_icons_background_color']) || !empty($mkd_options['portfolio_list_icons_border_color']) || (isset($mkd_options['portfolio_list_icons_border_width']) && $mkd_options['portfolio_list_icons_border_width'] !== '') || (isset($mkd_options['portfolio_list_icons_border_radius']) && $mkd_options['portfolio_list_icons_border_radius'] !== '')) { ?>
            .portfolio_main_holder .icons_holder a{
			<?php if (!empty($mkd_options['portfolio_list_icons_color'])) { ?> color: <?php echo esc_attr($mkd_options['portfolio_list_icons_color']); ?>!important; <?php } ?>
			<?php if (!empty($mkd_options['portfolio_list_icons_background_color'])) { ?> background-color: <?php echo esc_attr($mkd_options['portfolio_list_icons_background_color']); ?>!important; <?php } ?>
			<?php if (!empty($mkd_options['portfolio_list_icons_border_color'])) { ?> border-color: <?php echo esc_attr($mkd_options['portfolio_list_icons_border_color']); ?>!important; <?php } ?>
			<?php if (empty($mkd_options['portfolio_list_icons_border_color']) && !empty($mkd_options['portfolio_list_icons_border_hover_color'])) { ?> border-color: <?php echo esc_attr($mkd_options['portfolio_list_icons_background_color']); ?>!important; <?php } ?>
			<?php if(isset($mkd_options['portfolio_list_icons_border_radius']) && $mkd_options['portfolio_list_icons_border_radius'] !== '') { ?> border-radius: <?php echo esc_attr($mkd_options['portfolio_list_icons_border_radius']).'px!important;'; ?>; <?php } ?>
			<?php if(isset($mkd_options['portfolio_list_icons_border_width']) && $mkd_options['portfolio_list_icons_border_width'] !== '') { ?> border-width: <?php echo esc_attr($mkd_options['portfolio_list_icons_border_width']).'px!important;'; ?>; border-style:solid !important; <?php } ?>
            }
		<?php } ?>

		<?php if (!empty($mkd_options['portfolio_list_icons_hover_color']) || !empty($mkd_options['portfolio_list_icons_background_hover_color']) || !empty($mkd_options['portfolio_list_icons_border_hover_color'])) { ?>
            .portfolio_main_holder .icons_holder a:hover{
			<?php if (!empty($mkd_options['portfolio_list_icons_hover_color'])) { ?> color: <?php echo esc_attr($mkd_options['portfolio_list_icons_hover_color']); ?>!important; <?php } ?>
			<?php if (!empty($mkd_options['portfolio_list_icons_background_hover_color'])) { ?> background-color: <?php echo esc_attr($mkd_options['portfolio_list_icons_background_hover_color']); ?>!important; <?php } ?>
			<?php if (!empty($mkd_options['portfolio_list_icons_border_hover_color'])) { ?> border-color: <?php echo esc_attr($mkd_options['portfolio_list_icons_border_hover_color']); ?>!important; <?php } ?>
            }
		<?php } ?>

		<?php

		$expandable_section_style       = array();
		$expandable_label_style         = array();
		$expandable_label_hover_style   = array();

		if(isset($mkd_options['expandable_background_color']) && $mkd_options['expandable_background_color'] !== '') {
			$expandable_section_style[] = 'background-color: '.$mkd_options['expandable_background_color'];
		}

		if(isset($mkd_options['expandable_label_color']) && $mkd_options['expandable_label_color'] !== '') {
			$expandable_label_style[] = 'color: '.$mkd_options['expandable_label_color'];
		}

		if(isset($mkd_options['expandable_label_font_family']) && $mkd_options['expandable_label_font_family'] !== '-1') {
			$expandable_label_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['expandable_label_font_family']).', sans-serif';
		}

		if(isset($mkd_options['expandable_label_font_size']) && $mkd_options['expandable_label_font_size'] !== '') {
			$expandable_label_style[] = 'font-size: '.intval($mkd_options['expandable_label_font_size']).'px';
		}

		if(isset($mkd_options['expandable_label_letter_spacing']) && $mkd_options['expandable_label_letter_spacing'] !== '') {
			$expandable_label_style[] = 'letter-spacing: '.intval($mkd_options['expandable_label_letter_spacing']).'px';
		}

		if(isset($mkd_options['expandable_label_font_weight']) && $mkd_options['expandable_label_font_weight'] !== '') {
			$expandable_label_style[] = 'font-weight: '.intval($mkd_options['expandable_label_font_weight']);
		}

		if(isset($mkd_options['expandable_label_text_transform']) && $mkd_options['expandable_label_text_transform'] !== '') {
			$expandable_label_style[] = 'text-transform: '.$mkd_options['expandable_label_text_transform'];
		}

		if(isset($mkd_options['expandable_label_hover_color']) && $mkd_options['expandable_label_hover_color'] !== '') {
			$expandable_label_hover_style[] = 'color: '.$mkd_options['expandable_label_hover_color'];
		}

		if(is_array($expandable_section_style) && count($expandable_section_style)) { ?>
            .more_facts_holder {
			<?php echo esc_attr(implode(';', $expandable_section_style)); ?>
            }

		<?php }

		if(is_array($expandable_label_style) && count($expandable_label_style)) { ?>
            .more_facts_button, .more_facts_button{
			<?php echo esc_attr(implode(';', $expandable_label_style)); ?>
            }
		<?php }

		if(is_array($expandable_label_hover_style) && count($expandable_label_hover_style)) { ?>
            more_facts_button:hover, .more_facts_button:hover {
			<?php echo esc_attr(implode(';', $expandable_label_hover_style)); ?>
            }
		<?php } ?>

		<?php
		//Contact Form 7 Custom Styles - start
		if(mikado_one_mikado_contact_form_7_installed()){


			$cf7_custom_style_1_elements_styles = '';
			$cf7_custom_style_1_color_placeholder = '';
			if(isset($mkd_options['cf7_custom_style_1_element_background_color']) && $mkd_options['cf7_custom_style_1_element_background_color'] !== '') {
				if(isset($mkd_options['cf7_custom_style_1_element_background_transparency']) && $mkd_options['cf7_custom_style_1_element_background_transparency'] !== ''){
					$cf7_custom_style_1_element_background_color = mikado_one_mikado_hex2rgb($mkd_options['cf7_custom_style_1_element_background_color']);
					$cf7_custom_style_1_elements_styles .= 'background-color: rgba('. esc_attr($cf7_custom_style_1_element_background_color[0]) . ',' . esc_attr($cf7_custom_style_1_element_background_color[1]) . ',' . esc_attr($cf7_custom_style_1_element_background_color[2]) . ',' . esc_attr($mkd_options['cf7_custom_style_1_element_background_transparency']) .');';
				} else {
					$cf7_custom_style_1_elements_styles .= 'background-color: '.esc_attr($mkd_options['cf7_custom_style_1_element_background_color']).';';
				}
			}

			if(isset($mkd_options['cf7_custom_style_1_element_border_color']) && $mkd_options['cf7_custom_style_1_element_border_color'] !== '') {
				if(isset($mkd_options['cf7_custom_style_1_border_transparency']) && $mkd_options['cf7_custom_style_1_border_transparency'] !== ''){
					$cf7_custom_style_1_element_border_color = mikado_one_mikado_hex2rgb($mkd_options['cf7_custom_style_1_element_border_color']);
					$cf7_custom_style_1_elements_styles .= 'border-color: rgba('. esc_attr($cf7_custom_style_1_element_border_color[0]) . ',' . esc_attr($cf7_custom_style_1_element_border_color[1]) . ',' . esc_attr($cf7_custom_style_1_element_border_color[2]) . ',' . esc_attr($mkd_options['cf7_custom_style_1_border_transparency']) .');';
				} else {
					$cf7_custom_style_1_elements_styles .= 'border-color: '.esc_attr($mkd_options['cf7_custom_style_1_element_border_color']).';';
				}
			}

			if(isset($mkd_options['cf7_custom_style_1_element_border_width']) && $mkd_options['cf7_custom_style_1_element_border_width'] !== '') {
				$cf7_custom_style_1_elements_styles .= 'border-width: '.esc_attr($mkd_options['cf7_custom_style_1_element_border_width']).'px;';
				$cf7_custom_style_1_elements_styles .= 'border-style:solid;';
				$cf7_custom_style_1_elements_styles .= 'transform: translateZ(0);';
			}

			if(isset($mkd_options['cf7_custom_style_1_element_border_radius']) && $mkd_options['cf7_custom_style_1_element_border_radius'] !== '') {
				$cf7_custom_style_1_elements_styles .= 'border-radius: '.esc_attr($mkd_options['cf7_custom_style_1_element_border_radius']).'px;';
			}

			if(isset($mkd_options['cf7_custom_style_1_element_border_bottom']) && $mkd_options['cf7_custom_style_1_element_border_bottom'] == 'yes') {
				$cf7_custom_style_1_elements_styles .= 'border-left: none; border-right:none; border-top: none;';
			}

			if(isset($mkd_options['cf7_custom_style_1_element_font_color']) && $mkd_options['cf7_custom_style_1_element_font_color'] !== '') {
				$cf7_custom_style_1_elements_styles .= 'color: '.esc_attr($mkd_options['cf7_custom_style_1_element_font_color']).';';
				$cf7_custom_style_1_color_placeholder .= 'color: '.esc_attr($mkd_options['cf7_custom_style_1_element_font_color']).';';
				$cf7_custom_style_1_color_placeholder .= 'opacity:1;';
			}

			if(isset($mkd_options['cf7_custom_style_1_element_font_family']) && $mkd_options['cf7_custom_style_1_element_font_family'] !== '-1') {
				$cf7_custom_style_1_elements_styles .= 'font-family: '.esc_attr(str_replace('+', ' ', $mkd_options['cf7_custom_style_1_element_font_family'])).';';
			}

			if(isset($mkd_options['cf7_custom_style_1_element_font_size']) && $mkd_options['cf7_custom_style_1_element_font_size'] !== '') {
				$cf7_custom_style_1_elements_styles .= 'font-size: '.esc_attr($mkd_options['cf7_custom_style_1_element_font_size']).'px;';
			}
			if(isset($mkd_options['cf7_custom_style_1_element_line_height']) && $mkd_options['cf7_custom_style_1_element_line_height'] !== '') {
				$cf7_custom_style_1_elements_styles .= 'line-height: '.esc_attr($mkd_options['cf7_custom_style_1_element_line_height']).'px;';
			}
			if(isset($mkd_options['cf7_custom_style_1_element_font_style']) && $mkd_options['cf7_custom_style_1_element_font_style'] !== '') {
				$cf7_custom_style_1_elements_styles .= 'font-style: '.esc_attr($mkd_options['cf7_custom_style_1_element_font_style']).';';
			}

			if(isset($mkd_options['cf7_custom_style_1_element_font_weight']) && $mkd_options['cf7_custom_style_1_element_font_weight'] !== '') {
				$cf7_custom_style_1_elements_styles .= 'font-weight: '.esc_attr($mkd_options['cf7_custom_style_1_element_font_weight']).';';
			}

			if(isset($mkd_options['cf7_custom_style_1_element_letter_spacing']) && $mkd_options['cf7_custom_style_1_element_letter_spacing'] !== '') {
				$cf7_custom_style_1_elements_styles .= 'letter-spacing: '.esc_attr($mkd_options['cf7_custom_style_1_element_letter_spacing']).'px;';
			}

			if(isset($mkd_options['cf7_custom_style_1_element_text_transform']) && $mkd_options['cf7_custom_style_1_element_text_transform'] !== '') {
				$cf7_custom_style_1_elements_styles .= 'text-transform: '.esc_attr($mkd_options['cf7_custom_style_1_element_text_transform']).';';
			}

			if(isset($mkd_options['cf7_custom_style_1_element_padding_top']) && $mkd_options['cf7_custom_style_1_element_padding_top'] !== '') {
				$cf7_custom_style_1_elements_styles .= 'padding-top: '.esc_attr($mkd_options['cf7_custom_style_1_element_padding_top']).'px;';
			}

			if(isset($mkd_options['cf7_custom_style_1_element_padding_right']) && $mkd_options['cf7_custom_style_1_element_padding_right'] !== '') {
				$cf7_custom_style_1_elements_styles .= 'padding-right: '.esc_attr($mkd_options['cf7_custom_style_1_element_padding_right']).'px;';
			}
			if(isset($mkd_options['cf7_custom_style_1_element_padding_bottom']) && $mkd_options['cf7_custom_style_1_element_padding_bottom'] !== '') {
				$cf7_custom_style_1_elements_styles .= 'padding-bottom: '.esc_attr($mkd_options['cf7_custom_style_1_element_padding_bottom']).'px;';
			}
			if(isset($mkd_options['cf7_custom_style_1_element_padding_left']) && $mkd_options['cf7_custom_style_1_element_padding_left'] !== '') {
				$cf7_custom_style_1_elements_styles .= 'padding-left: '.esc_attr($mkd_options['cf7_custom_style_1_element_padding_left']).'px;';
			}
			if(isset($mkd_options['cf7_custom_style_1_element_margin_top']) && $mkd_options['cf7_custom_style_1_element_margin_top'] !== '') {
				$cf7_custom_style_1_elements_styles .= 'margin-top: '.esc_attr($mkd_options['cf7_custom_style_1_element_margin_top']).'px;';
			}
			if(isset($mkd_options['cf7_custom_style_1_element_margin_bottom']) && $mkd_options['cf7_custom_style_1_element_margin_bottom'] !== '') {
				$cf7_custom_style_1_elements_styles .= 'margin-bottom: '.esc_attr($mkd_options['cf7_custom_style_1_element_margin_bottom']).'px;';
				?>.cf7_custom_style_1 span.wpcf7-not-valid-tip{
                top: -<?php echo esc_attr($mkd_options['cf7_custom_style_1_element_margin_bottom']).'px;'; ?>;
                }<?php
			}

			$cf7_custom_style_1_elements_focus_styles = '';
			$cf7_custom_style_1_focus_color_placeholder = '';

			if(isset($mkd_options['cf7_custom_style_1_element_font_focus_color']) && $mkd_options['cf7_custom_style_1_element_font_focus_color'] !== '') {
				$cf7_custom_style_1_elements_focus_styles .= 'color: '.$mkd_options['cf7_custom_style_1_element_font_focus_color'].';';
				$cf7_custom_style_1_focus_color_placeholder .= 'color: '.$mkd_options['cf7_custom_style_1_element_font_focus_color'].';';
			}

			if(isset($mkd_options['cf7_custom_style_1_element_focus_background_color']) && $mkd_options['cf7_custom_style_1_element_focus_background_color'] !== '') {
				if(isset($mkd_options['cf7_custom_style_1_button_focus_background_transparency']) && $mkd_options['cf7_custom_style_1_button_focus_background_transparency'] !== ''){
					$cf7_custom_style_1_element_focus_background_color = mikado_one_mikado_hex2rgb($mkd_options['cf7_custom_style_1_element_focus_background_color']);
					$cf7_custom_style_1_elements_focus_styles .= 'background-color: rgba('. $cf7_custom_style_1_element_focus_background_color[0] . ',' . $cf7_custom_style_1_element_focus_background_color[1] . ',' . $cf7_custom_style_1_element_focus_background_color[2] . ',' . $mkd_options['cf7_custom_style_1_button_focus_background_transparency'] .');';
				} else {
					$cf7_custom_style_1_elements_focus_styles .= 'background-color: '.$mkd_options['cf7_custom_style_1_element_focus_background_color'].';';
				}
			}

			if(isset($mkd_options['cf7_custom_style_1_element_focus_border_color']) && $mkd_options['cf7_custom_style_1_element_focus_border_color'] !== '') {
				if(isset($mkd_options['cf7_custom_style_1_button_focus_border_transparency']) && $mkd_options['cf7_custom_style_1_button_focus_border_transparency'] !== ''){
					$cf7_custom_style_1_element_focus_border_color = mikado_one_mikado_hex2rgb($mkd_options['cf7_custom_style_1_element_focus_border_color']);
					$cf7_custom_style_1_elements_focus_styles .= 'border-color: rgba('. $cf7_custom_style_1_element_focus_border_color[0] . ',' . $cf7_custom_style_1_element_focus_border_color[1] . ',' . $cf7_custom_style_1_element_focus_border_color[2] . ',' . $mkd_options['cf7_custom_style_1_button_focus_border_transparency'] .');';

				} else {
					$cf7_custom_style_1_elements_focus_styles .= 'border-color: '.$mkd_options['cf7_custom_style_1_element_focus_border_color'].';';
				}
			}


			$cf7_custom_style_1_button_styles = '';
			if(isset($mkd_options['cf7_custom_style_1_button_background_color']) && $mkd_options['cf7_custom_style_1_button_background_color'] !== '') {
				if(isset($mkd_options['cf7_custom_style_1_button_background_transparency']) && $mkd_options['cf7_custom_style_1_button_background_transparency'] !== ''){
					$cf7_custom_style_1_button_background_color = mikado_one_mikado_hex2rgb($mkd_options['cf7_custom_style_1_button_background_color']);
					$cf7_custom_style_1_button_styles .= 'background-color: rgba('. esc_attr($cf7_custom_style_1_button_background_color[0]) . ',' . esc_attr($cf7_custom_style_1_button_background_color[1]) . ',' . esc_attr($cf7_custom_style_1_button_background_color[2]) . ',' . esc_attr($mkd_options['cf7_custom_style_1_button_background_transparency']) .');';
				} else {
					$cf7_custom_style_1_button_styles .= 'background-color: '.esc_attr($mkd_options['cf7_custom_style_1_button_background_color']).';';
				}
			}

			if(isset($mkd_options['cf7_custom_style_1_button_border_color']) && $mkd_options['cf7_custom_style_1_button_border_color'] !== '') {
				if(isset($mkd_options['cf7_custom_style_1_button_border_transparency']) && $mkd_options['cf7_custom_style_1_button_border_transparency'] !== ''){
					$cf7_custom_style_1_button_border_color = mikado_one_mikado_hex2rgb($mkd_options['cf7_custom_style_1_button_border_color']);
					$cf7_custom_style_1_button_styles .= 'border-color: rgba('. esc_attr($cf7_custom_style_1_button_border_color[0]) . ',' . esc_attr($cf7_custom_style_1_button_border_color[1]) . ',' . esc_attr($cf7_custom_style_1_button_border_color[2]) . ',' . esc_attr($mkd_options['cf7_custom_style_1_button_border_transparency']) .');';

				} else {
					$cf7_custom_style_1_button_styles .= 'border-color: '.esc_attr($mkd_options['cf7_custom_style_1_button_border_color']).';';
				}
			}

			if(isset($mkd_options['cf7_custom_style_1_button_border_width']) && $mkd_options['cf7_custom_style_1_button_border_width'] !== '') {
				$cf7_custom_style_1_button_styles .= 'border-width: '.esc_attr($mkd_options['cf7_custom_style_1_button_border_width']).'px;';
			}

			if(isset($mkd_options['cf7_custom_style_1_button_border_radius']) && $mkd_options['cf7_custom_style_1_button_border_radius'] !== '') {
				$cf7_custom_style_1_button_styles .= 'border-radius: '.esc_attr($mkd_options['cf7_custom_style_1_button_border_radius']).'px;';
			}

			if(isset($mkd_options['cf7_custom_style_1_button_font_color']) && $mkd_options['cf7_custom_style_1_button_font_color'] !== '') {
				$cf7_custom_style_1_button_styles .= 'color: '.esc_attr($mkd_options['cf7_custom_style_1_button_font_color']).';';
			}

			if(isset($mkd_options['cf7_custom_style_1_button_font_family']) && $mkd_options['cf7_custom_style_1_button_font_family'] !== '-1') {
				$cf7_custom_style_1_button_styles .= 'font-family: '.esc_attr(str_replace('+', ' ', $mkd_options['cf7_custom_style_1_button_font_family'])).';';
			}

			if(isset($mkd_options['cf7_custom_style_1_button_font_size']) && $mkd_options['cf7_custom_style_1_button_font_size'] !== '') {
				$cf7_custom_style_1_button_styles .= 'font-size: '.esc_attr($mkd_options['cf7_custom_style_1_button_font_size']).'px;';
			}

			if(isset($mkd_options['cf7_custom_style_1_button_font_style']) && $mkd_options['cf7_custom_style_1_button_font_style'] !== '') {
				$cf7_custom_style_1_button_styles .= 'font-style: '.esc_attr($mkd_options['cf7_custom_style_1_button_font_style']).';';
			}

			if(isset($mkd_options['cf7_custom_style_1_button_font_weight']) && $mkd_options['cf7_custom_style_1_button_font_weight'] !== '') {
				$cf7_custom_style_1_button_styles .= 'font-weight: '.esc_attr($mkd_options['cf7_custom_style_1_button_font_weight']).';';
			}

			if(isset($mkd_options['cf7_custom_style_1_button_letter_spacing']) && $mkd_options['cf7_custom_style_1_button_letter_spacing'] !== '') {
				$cf7_custom_style_1_button_styles .= 'letter-spacing: '.esc_attr($mkd_options['cf7_custom_style_1_button_letter_spacing']).'px;';
			}

			if(isset($mkd_options['cf7_custom_style_1_button_text_transform']) && $mkd_options['cf7_custom_style_1_button_text_transform'] !== '') {
				$cf7_custom_style_1_button_styles .= 'text-transform: '.esc_attr($mkd_options['cf7_custom_style_1_button_text_transform']).';';
			}

			if(isset($mkd_options['cf7_custom_style_1_button_height']) && $mkd_options['cf7_custom_style_1_button_height'] !== '') {
				$cf7_custom_style_1_button_styles .= 'height: '.esc_attr($mkd_options['cf7_custom_style_1_button_height']).'px;';
				$cf7_custom_style_1_button_styles .= 'line-height: '.esc_attr($mkd_options['cf7_custom_style_1_button_height']).'px;';
			}

			if(isset($mkd_options['cf7_custom_style_1_button_padding']) && $mkd_options['cf7_custom_style_1_button_padding'] !== '') {
				$cf7_custom_style_1_button_styles .= 'padding-left: '.esc_attr($mkd_options['cf7_custom_style_1_button_padding']).'px;';
				$cf7_custom_style_1_button_styles .= 'padding-right: '.esc_attr($mkd_options['cf7_custom_style_1_button_padding']).'px;';
			}

			$cf7_custom_style_1_button_hover_styles = '';

			if(isset($mkd_options['cf7_custom_style_1_button_font_hover_color']) && $mkd_options['cf7_custom_style_1_button_font_hover_color'] !== '') {
				$cf7_custom_style_1_button_hover_styles .= 'color: '.$mkd_options['cf7_custom_style_1_button_font_hover_color'].';';
			}

			if(isset($mkd_options['cf7_custom_style_1_button_hover_background_color']) && $mkd_options['cf7_custom_style_1_button_hover_background_color'] !== '') {
				if(isset($mkd_options['cf7_custom_style_1_button_hover_background_transparency']) && $mkd_options['cf7_custom_style_1_button_hover_background_transparency'] !== ''){
					$cf7_custom_style_1_button_hover_background_color = mikado_one_mikado_hex2rgb($mkd_options['cf7_custom_style_1_button_hover_background_color']);
					$cf7_custom_style_1_button_hover_styles .= 'background-color: rgba('. $cf7_custom_style_1_button_hover_background_color[0] . ',' . $cf7_custom_style_1_button_hover_background_color[1] . ',' . $cf7_custom_style_1_button_hover_background_color[2] . ',' . $mkd_options['cf7_custom_style_1_button_hover_background_transparency'] .');';
				} else {
					$cf7_custom_style_1_button_hover_styles .= 'background-color: '.$mkd_options['cf7_custom_style_1_button_hover_background_color'].';';
				}
			}

			if(isset($mkd_options['cf7_custom_style_1_button_hover_border_color']) && $mkd_options['cf7_custom_style_1_button_hover_border_color'] !== '') {
				if(isset($mkd_options['cf7_custom_style_1_button_hover_border_transparency']) && $mkd_options['cf7_custom_style_1_button_hover_border_transparency'] !== ''){
					$cf7_custom_style_1_button_hover_border_color = mikado_one_mikado_hex2rgb($mkd_options['cf7_custom_style_1_button_hover_border_color']);
					$cf7_custom_style_1_button_hover_styles .= 'border-color: rgba('. $cf7_custom_style_1_button_hover_border_color[0] . ',' . $cf7_custom_style_1_button_hover_border_color[1] . ',' . $cf7_custom_style_1_button_hover_border_color[2] . ',' . $mkd_options['cf7_custom_style_1_button_hover_border_transparency'] .');';

				} else {
					$cf7_custom_style_1_button_hover_styles .= 'border-color: '.$mkd_options['cf7_custom_style_1_button_hover_border_color'].';';
				}
			}

			$cf7_custom_style_2_elements_styles = '';
			$cf7_custom_style_2_color_placeholder = '';
			if(isset($mkd_options['cf7_custom_style_2_element_background_color']) && $mkd_options['cf7_custom_style_2_element_background_color'] !== '') {
				if(isset($mkd_options['cf7_custom_style_2_element_background_transparency']) && $mkd_options['cf7_custom_style_2_element_background_transparency'] !== ''){
					$cf7_custom_style_2_element_background_color = mikado_one_mikado_hex2rgb($mkd_options['cf7_custom_style_2_element_background_color']);
					$cf7_custom_style_2_elements_styles .= 'background-color: rgba('. esc_attr($cf7_custom_style_2_element_background_color[0]) . ',' . esc_attr($cf7_custom_style_2_element_background_color[1]) . ',' . esc_attr($cf7_custom_style_2_element_background_color[2]) . ',' . esc_attr($mkd_options['cf7_custom_style_2_element_background_transparency']) .');';
				} else {
					$cf7_custom_style_2_elements_styles .= 'background-color: '.esc_attr($mkd_options['cf7_custom_style_2_element_background_color']).';';
				}
			}

			if(isset($mkd_options['cf7_custom_style_2_element_border_color']) && $mkd_options['cf7_custom_style_2_element_border_color'] !== '') {
				if(isset($mkd_options['cf7_custom_style_2_border_transparency']) && $mkd_options['cf7_custom_style_2_border_transparency'] !== ''){
					$cf7_custom_style_2_element_border_color = mikado_one_mikado_hex2rgb($mkd_options['cf7_custom_style_2_element_border_color']);
					$cf7_custom_style_2_elements_styles .= 'border-color: rgba('. esc_attr($cf7_custom_style_2_element_border_color[0]) . ',' . esc_attr($cf7_custom_style_2_element_border_color[1]) . ',' . esc_attr($cf7_custom_style_2_element_border_color[2]) . ',' . esc_attr($mkd_options['cf7_custom_style_2_border_transparency']) .');';

				} else {
					$cf7_custom_style_2_elements_styles .= 'border-color: '.esc_attr($mkd_options['cf7_custom_style_2_element_border_color']).';';
				}
			}

			if(isset($mkd_options['cf7_custom_style_2_element_border_width']) && $mkd_options['cf7_custom_style_2_element_border_width'] !== '') {
				$cf7_custom_style_2_elements_styles .= 'border-width: '.esc_attr($mkd_options['cf7_custom_style_2_element_border_width']).'px;';
				$cf7_custom_style_2_elements_styles .= 'border-style:solid;';
				$cf7_custom_style_2_elements_styles .= 'transform: translateZ(0);';
			}

			if(isset($mkd_options['cf7_custom_style_2_element_border_radius']) && $mkd_options['cf7_custom_style_2_element_border_radius'] !== '') {
				$cf7_custom_style_2_elements_styles .= 'border-radius: '.esc_attr($mkd_options['cf7_custom_style_2_element_border_radius']).'px;';
			}

			if(isset($mkd_options['cf7_custom_style_2_element_border_bottom']) && $mkd_options['cf7_custom_style_2_element_border_bottom'] == 'yes') {
				$cf7_custom_style_2_elements_styles .= 'border-left: none; border-right:none; border-top: none;';
			}

			if(isset($mkd_options['cf7_custom_style_2_element_font_color']) && $mkd_options['cf7_custom_style_2_element_font_color'] !== '') {
				$cf7_custom_style_2_elements_styles .= 'color: '.esc_attr($mkd_options['cf7_custom_style_2_element_font_color']).';';
				$cf7_custom_style_2_color_placeholder .= 'color: '.esc_attr($mkd_options['cf7_custom_style_2_element_font_color']).';';
				$cf7_custom_style_2_color_placeholder .= 'opacity:1;';
			}

			if(isset($mkd_options['cf7_custom_style_2_element_font_family']) && $mkd_options['cf7_custom_style_2_element_font_family'] !== '-1') {
				$cf7_custom_style_2_elements_styles .= 'font-family: '.esc_attr(str_replace('+', ' ', $mkd_options['cf7_custom_style_2_element_font_family'])).';';
			}

			if(isset($mkd_options['cf7_custom_style_2_element_font_size']) && $mkd_options['cf7_custom_style_2_element_font_size'] !== '') {
				$cf7_custom_style_2_elements_styles .= 'font-size: '.esc_attr($mkd_options['cf7_custom_style_2_element_font_size']).'px;';
			}

			if(isset($mkd_options['cf7_custom_style_2_element_line_height']) && $mkd_options['cf7_custom_style_2_element_line_height'] !== '') {
				$cf7_custom_style_2_elements_styles .= 'line-height: '.esc_attr($mkd_options['cf7_custom_style_2_element_line_height']).'px;';
			}

			if(isset($mkd_options['cf7_custom_style_2_element_font_style']) && $mkd_options['cf7_custom_style_2_element_font_style'] !== '') {
				$cf7_custom_style_2_elements_styles .= 'font-style: '.esc_attr($mkd_options['cf7_custom_style_2_element_font_style']).';';
			}

			if(isset($mkd_options['cf7_custom_style_2_element_font_weight']) && $mkd_options['cf7_custom_style_2_element_font_weight'] !== '') {
				$cf7_custom_style_2_elements_styles .= 'font-weight: '.esc_attr($mkd_options['cf7_custom_style_2_element_font_weight']).';';
			}

			if(isset($mkd_options['cf7_custom_style_2_element_letter_spacing']) && $mkd_options['cf7_custom_style_2_element_letter_spacing'] !== '') {
				$cf7_custom_style_2_elements_styles .= 'letter-spacing: '.esc_attr($mkd_options['cf7_custom_style_2_element_letter_spacing']).'px;';
			}

			if(isset($mkd_options['cf7_custom_style_2_element_text_transform']) && $mkd_options['cf7_custom_style_2_element_text_transform'] !== '') {
				$cf7_custom_style_2_elements_styles .= 'text-transform: '.esc_attr($mkd_options['cf7_custom_style_2_element_text_transform']).';';
			}

			if(isset($mkd_options['cf7_custom_style_2_element_padding_top']) && $mkd_options['cf7_custom_style_2_element_padding_top'] !== '') {
				$cf7_custom_style_2_elements_styles .= 'padding-top: '.esc_attr($mkd_options['cf7_custom_style_2_element_padding_top']).'px;';
			}

			if(isset($mkd_options['cf7_custom_style_2_element_padding_right']) && $mkd_options['cf7_custom_style_2_element_padding_right'] !== '') {
				$cf7_custom_style_2_elements_styles .= 'padding-right: '.esc_attr($mkd_options['cf7_custom_style_2_element_padding_right']).'px;';
			}
			if(isset($mkd_options['cf7_custom_style_2_element_padding_bottom']) && $mkd_options['cf7_custom_style_2_element_padding_bottom'] !== '') {
				$cf7_custom_style_2_elements_styles .= 'padding-bottom: '.esc_attr($mkd_options['cf7_custom_style_2_element_padding_bottom']).'px;';
			}
			if(isset($mkd_options['cf7_custom_style_2_element_padding_left']) && $mkd_options['cf7_custom_style_2_element_padding_left'] !== '') {
				$cf7_custom_style_2_elements_styles .= 'padding-left: '.esc_attr($mkd_options['cf7_custom_style_2_element_padding_left']).'px;';
			}

			if(isset($mkd_options['cf7_custom_style_2_element_margin_top']) && $mkd_options['cf7_custom_style_2_element_margin_top'] !== '') {
				$cf7_custom_style_2_elements_styles .= 'margin-top: '.esc_attr($mkd_options['cf7_custom_style_2_element_margin_top']).'px;';
			}

			if(isset($mkd_options['cf7_custom_style_2_element_margin_bottom']) && $mkd_options['cf7_custom_style_2_element_margin_bottom'] !== '') {
				$cf7_custom_style_2_elements_styles .= 'margin-bottom: '.esc_attr($mkd_options['cf7_custom_style_2_element_margin_bottom']).'px;';
				?>.cf7_custom_style_2 span.wpcf7-not-valid-tip{
                top: -<?php echo esc_attr($mkd_options['cf7_custom_style_2_element_margin_bottom']).'px;'; ?>;
                }<?php
			}

			$cf7_custom_style_2_elements_focus_styles = '';
			$cf7_custom_style_2_focus_color_placeholder = '';

			if(isset($mkd_options['cf7_custom_style_2_element_font_focus_color']) && $mkd_options['cf7_custom_style_2_element_font_focus_color'] !== '') {
				$cf7_custom_style_2_elements_focus_styles .= 'color: '.$mkd_options['cf7_custom_style_2_element_font_focus_color'].';';
				$cf7_custom_style_2_focus_color_placeholder .= 'color: '.$mkd_options['cf7_custom_style_2_element_font_focus_color'].';';

			}

			if(isset($mkd_options['cf7_custom_style_2_element_focus_background_color']) && $mkd_options['cf7_custom_style_2_element_focus_background_color'] !== '') {
				if(isset($mkd_options['cf7_custom_style_2_element_focus_background_transparency']) && $mkd_options['cf7_custom_style_2_element_focus_background_transparency'] !== ''){
					$cf7_custom_style_2_element_focus_background_color = mikado_one_mikado_hex2rgb($mkd_options['cf7_custom_style_2_element_focus_background_color']);
					$cf7_custom_style_2_elements_focus_styles .= 'background-color: rgba('. $cf7_custom_style_2_element_focus_background_color[0] . ',' . $cf7_custom_style_2_element_focus_background_color[1] . ',' . $cf7_custom_style_2_element_focus_background_color[2] . ',' . $mkd_options['cf7_custom_style_2_element_focus_background_transparency'] .');';
				} else {
					$cf7_custom_style_2_elements_focus_styles .= 'background-color: '.$mkd_options['cf7_custom_style_2_element_focus_background_color'].';';
				}
			}

			if(isset($mkd_options['cf7_custom_style_2_element_focus_border_color']) && $mkd_options['cf7_custom_style_2_element_focus_border_color'] !== '') {
				if(isset($mkd_options['cf7_custom_style_2_button_border_transparency']) && $mkd_options['cf7_custom_style_2_button_border_transparency'] !== ''){
					$cf7_custom_style_2_element_focus_border_color = mikado_one_mikado_hex2rgb($mkd_options['cf7_custom_style_2_element_focus_border_color']);
					$cf7_custom_style_2_elements_focus_styles .= 'border-color: rgba('. $cf7_custom_style_2_element_focus_border_color[0] . ',' . $cf7_custom_style_2_element_focus_border_color[1] . ',' . $cf7_custom_style_2_element_focus_border_color[2] . ',' . $mkd_options['cf7_custom_style_2_button_border_transparency'] .');';

				} else {
					$cf7_custom_style_2_elements_focus_styles .= 'border-color: '.$mkd_options['cf7_custom_style_2_element_focus_border_color'].';';
				}
			}


			$cf7_custom_style_2_button_styles = '';
			if(isset($mkd_options['cf7_custom_style_2_button_background_color']) && $mkd_options['cf7_custom_style_2_button_background_color'] !== '') {
				if(isset($mkd_options['cf7_custom_style_2_button_background_transparency']) && $mkd_options['cf7_custom_style_2_button_background_transparency'] !== ''){
					$cf7_custom_style_2_button_background_color = mikado_one_mikado_hex2rgb($mkd_options['cf7_custom_style_2_button_background_color']);
					$cf7_custom_style_2_button_styles .= 'background-color: rgba('. esc_attr($cf7_custom_style_2_button_background_color[0]) . ',' . esc_attr($cf7_custom_style_2_button_background_color[1]) . ',' . esc_attr($cf7_custom_style_2_button_background_color[2]) . ',' . esc_attr($mkd_options['cf7_custom_style_2_button_background_transparency']) .');';
				} else {
					$cf7_custom_style_2_button_styles .= 'background-color: '.esc_attr($mkd_options['cf7_custom_style_2_button_background_color']).';';
				}
			}

			if(isset($mkd_options['cf7_custom_style_2_button_border_color']) && $mkd_options['cf7_custom_style_2_button_border_color'] !== '') {
				if(isset($mkd_options['cf7_custom_style_2_button_border_transparency']) && $mkd_options['cf7_custom_style_2_button_border_transparency'] !== ''){
					$cf7_custom_style_2_button_border_color = mikado_one_mikado_hex2rgb($mkd_options['cf7_custom_style_2_button_border_color']);
					$cf7_custom_style_2_button_styles .= 'border-color: rgba('. esc_attr($cf7_custom_style_2_button_border_color[0]) . ',' . esc_attr($cf7_custom_style_2_button_border_color[1]) . ',' . esc_attr($cf7_custom_style_2_button_border_color[2]) . ',' . esc_attr($mkd_options['cf7_custom_style_2_button_border_transparency']) .');';

				} else {
					$cf7_custom_style_2_button_styles .= 'border-color: '.esc_attr($mkd_options['cf7_custom_style_2_button_border_color']).';';
				}
			}

			if(isset($mkd_options['cf7_custom_style_2_button_border_width']) && $mkd_options['cf7_custom_style_2_button_border_width'] !== '') {
				$cf7_custom_style_2_button_styles .= 'border-width: '.esc_attr($mkd_options['cf7_custom_style_2_button_border_width']).'px;';
			}

			if(isset($mkd_options['cf7_custom_style_2_button_border_radius']) && $mkd_options['cf7_custom_style_2_button_border_radius'] !== '') {
				$cf7_custom_style_2_button_styles .= 'border-radius: '.esc_attr($mkd_options['cf7_custom_style_2_button_border_radius']).'px;';
			}

			if(isset($mkd_options['cf7_custom_style_2_button_font_color']) && $mkd_options['cf7_custom_style_2_button_font_color'] !== '') {
				$cf7_custom_style_2_button_styles .= 'color: '.esc_attr($mkd_options['cf7_custom_style_2_button_font_color']).';';
			}

			if(isset($mkd_options['cf7_custom_style_2_button_font_family']) && $mkd_options['cf7_custom_style_2_button_font_family'] !== '-1') {
				$cf7_custom_style_2_button_styles .= 'font-family: '.esc_attr(str_replace('+', ' ', $mkd_options['cf7_custom_style_2_button_font_family'])).';';
			}

			if(isset($mkd_options['cf7_custom_style_2_button_font_size']) && $mkd_options['cf7_custom_style_2_button_font_size'] !== '') {
				$cf7_custom_style_2_button_styles .= 'font-size: '.esc_attr($mkd_options['cf7_custom_style_2_button_font_size']).'px;';
			}

			if(isset($mkd_options['cf7_custom_style_2_button_font_style']) && $mkd_options['cf7_custom_style_2_button_font_style'] !== '') {
				$cf7_custom_style_2_button_styles .= 'font-style: '.esc_attr($mkd_options['cf7_custom_style_2_button_font_style']).';';
			}

			if(isset($mkd_options['cf7_custom_style_2_button_font_weight']) && $mkd_options['cf7_custom_style_2_button_font_weight'] !== '') {
				$cf7_custom_style_2_button_styles .= 'font-weight: '.esc_attr($mkd_options['cf7_custom_style_2_button_font_weight']).';';
			}

			if(isset($mkd_options['cf7_custom_style_2_button_letter_spacing']) && $mkd_options['cf7_custom_style_2_button_letter_spacing'] !== '') {
				$cf7_custom_style_2_button_styles .= 'letter-spacing: '.esc_attr($mkd_options['cf7_custom_style_2_button_letter_spacing']).'px;';
			}

			if(isset($mkd_options['cf7_custom_style_2_button_text_transform']) && $mkd_options['cf7_custom_style_2_button_text_transform'] !== '') {
				$cf7_custom_style_2_button_styles .= 'text-transform: '.esc_attr($mkd_options['cf7_custom_style_2_button_text_transform']).';';
			}

			if(isset($mkd_options['cf7_custom_style_2_button_height']) && $mkd_options['cf7_custom_style_2_button_height'] !== '') {
				$cf7_custom_style_2_button_styles .= 'height: '.esc_attr($mkd_options['cf7_custom_style_2_button_height']).'px;';
				$cf7_custom_style_2_button_styles .= 'line-height: '.esc_attr($mkd_options['cf7_custom_style_2_button_height']).'px;';
			}

			if(isset($mkd_options['cf7_custom_style_2_button_padding']) && $mkd_options['cf7_custom_style_2_button_padding'] !== '') {
				$cf7_custom_style_2_button_styles .= 'padding-left: '.esc_attr($mkd_options['cf7_custom_style_2_button_padding']).'px;';
				$cf7_custom_style_2_button_styles .= 'padding-right: '.esc_attr($mkd_options['cf7_custom_style_2_button_padding']).'px;';
			}

			$cf7_custom_style_2_button_hover_styles = '';

			if(isset($mkd_options['cf7_custom_style_2_button_font_hover_color']) && $mkd_options['cf7_custom_style_2_button_font_hover_color'] !== '') {
				$cf7_custom_style_2_button_hover_styles .= 'color: '.$mkd_options['cf7_custom_style_2_button_font_hover_color'].';';
			}

			if(isset($mkd_options['cf7_custom_style_2_button_hover_background_color']) && $mkd_options['cf7_custom_style_2_button_hover_background_color'] !== '') {
				if(isset($mkd_options['cf7_custom_style_2_button_hover_background_transparency']) && $mkd_options['cf7_custom_style_2_button_hover_background_transparency'] !== ''){
					$cf7_custom_style_2_button_hover_background_color = mikado_one_mikado_hex2rgb($mkd_options['cf7_custom_style_2_button_hover_background_color']);
					$cf7_custom_style_2_button_hover_styles .= 'background-color: rgba('. $cf7_custom_style_2_button_hover_background_color[0] . ',' . $cf7_custom_style_2_button_hover_background_color[1] . ',' . $cf7_custom_style_2_button_hover_background_color[2] . ',' . $mkd_options['cf7_custom_style_2_button_hover_background_transparency'] .');';
				} else {
					$cf7_custom_style_2_button_hover_styles .= 'background-color: '.$mkd_options['cf7_custom_style_2_button_hover_background_color'].';';
				}
			}

			if(isset($mkd_options['cf7_custom_style_2_button_hover_border_color']) && $mkd_options['cf7_custom_style_2_button_hover_border_color'] !== '') {
				if(isset($mkd_options['cf7_custom_style_2_button_border_transparency']) && $mkd_options['cf7_custom_style_2_button_border_transparency'] !== ''){
					$cf7_custom_style_2_button_hover_border_color = mikado_one_mikado_hex2rgb($mkd_options['cf7_custom_style_2_button_hover_border_color']);
					$cf7_custom_style_2_button_hover_styles .= 'border-color: rgba('. $cf7_custom_style_2_button_hover_border_color[0] . ',' . $cf7_custom_style_2_button_hover_border_color[1] . ',' . $cf7_custom_style_2_button_hover_border_color[2] . ',' . $mkd_options['cf7_custom_style_2_button_border_transparency'] .');';

				} else {
					$cf7_custom_style_2_button_hover_styles .= 'border-color: '.$mkd_options['cf7_custom_style_2_button_hover_border_color'].';';
				}
			}
			$cf7_custom_style_3_elements_styles = '';
			$cf7_custom_style_3_color_placeholder = '';
			if(isset($mkd_options['cf7_custom_style_3_element_background_color']) && $mkd_options['cf7_custom_style_3_element_background_color'] !== '') {
				if(isset($mkd_options['cf7_custom_style_3_element_background_transparency']) && $mkd_options['cf7_custom_style_3_element_background_transparency'] !== ''){
					$cf7_custom_style_3_element_background_color = mikado_one_mikado_hex2rgb($mkd_options['cf7_custom_style_3_element_background_color']);
					$cf7_custom_style_3_elements_styles .= 'background-color: rgba('. esc_attr($cf7_custom_style_3_element_background_color[0]) . ',' . esc_attr($cf7_custom_style_3_element_background_color[1]) . ',' . esc_attr($cf7_custom_style_3_element_background_color[2]) . ',' . esc_attr($mkd_options['cf7_custom_style_3_element_background_transparency']) .');';
				} else {
					$cf7_custom_style_3_elements_styles .= 'background-color: '.esc_attr($mkd_options['cf7_custom_style_3_element_background_color']).';';
				}
			}

			if(isset($mkd_options['cf7_custom_style_3_element_border_color']) && $mkd_options['cf7_custom_style_3_element_border_color'] !== '') {
				if(isset($mkd_options['cf7_custom_style_3_border_transparency']) && $mkd_options['cf7_custom_style_3_border_transparency'] !== ''){
					$cf7_custom_style_3_element_border_color = mikado_one_mikado_hex2rgb($mkd_options['cf7_custom_style_3_element_border_color']);
					$cf7_custom_style_3_elements_styles .= 'border-color: rgba('. esc_attr($cf7_custom_style_3_element_border_color[0]) . ',' . esc_attr($cf7_custom_style_3_element_border_color[1]) . ',' . esc_attr($cf7_custom_style_3_element_border_color[2]) . ',' . esc_attr($mkd_options['cf7_custom_style_3_border_transparency']) .');';

				} else {
					$cf7_custom_style_3_elements_styles .= 'border-color: '.esc_attr($mkd_options['cf7_custom_style_3_element_border_color']).';';
				}
			}

			if(isset($mkd_options['cf7_custom_style_3_element_border_width']) && $mkd_options['cf7_custom_style_3_element_border_width'] !== '') {
				$cf7_custom_style_3_elements_styles .= 'border-width: '.esc_attr($mkd_options['cf7_custom_style_3_element_border_width']).'px;';
				$cf7_custom_style_3_elements_styles .= 'border-style:solid;';
				$cf7_custom_style_3_elements_styles .= 'transform: translateZ(0);';
			}

			if(isset($mkd_options['cf7_custom_style_3_element_border_radius']) && $mkd_options['cf7_custom_style_3_element_border_radius'] !== '') {
				$cf7_custom_style_3_elements_styles .= 'border-radius: '.esc_attr($mkd_options['cf7_custom_style_3_element_border_radius']).'px;';
			}

			if(isset($mkd_options['cf7_custom_style_3_element_border_bottom']) && $mkd_options['cf7_custom_style_3_element_border_bottom'] == 'yes') {
				$cf7_custom_style_3_elements_styles .= 'border-left: none; border-right:none; border-top: none;';
			}

			if(isset($mkd_options['cf7_custom_style_3_element_font_color']) && $mkd_options['cf7_custom_style_3_element_font_color'] !== '') {
				$cf7_custom_style_3_elements_styles .= 'color: '.esc_attr($mkd_options['cf7_custom_style_3_element_font_color']).';';
				$cf7_custom_style_3_color_placeholder .= 'color: '.esc_attr($mkd_options['cf7_custom_style_3_element_font_color']).';';
				$cf7_custom_style_3_color_placeholder .= 'opacity:1;';
			}

			if(isset($mkd_options['cf7_custom_style_3_element_font_family']) && $mkd_options['cf7_custom_style_3_element_font_family'] !== '-1') {
				$cf7_custom_style_3_elements_styles .= 'font-family: '.esc_attr(str_replace('+', ' ', $mkd_options['cf7_custom_style_3_element_font_family'])).';';
			}

			if(isset($mkd_options['cf7_custom_style_3_element_font_size']) && $mkd_options['cf7_custom_style_3_element_font_size'] !== '') {
				$cf7_custom_style_3_elements_styles .= 'font-size: '.esc_attr($mkd_options['cf7_custom_style_3_element_font_size']).'px;';
			}

			if(isset($mkd_options['cf7_custom_style_3_element_line_height']) && $mkd_options['cf7_custom_style_3_element_line_height'] !== '') {
				$cf7_custom_style_3_elements_styles .= 'line-height: '.esc_attr($mkd_options['cf7_custom_style_3_element_line_height']).'px;';
			}

			if(isset($mkd_options['cf7_custom_style_3_element_font_style']) && $mkd_options['cf7_custom_style_3_element_font_style'] !== '') {
				$cf7_custom_style_3_elements_styles .= 'font-style: '.esc_attr($mkd_options['cf7_custom_style_3_element_font_style']).';';
			}

			if(isset($mkd_options['cf7_custom_style_3_element_font_weight']) && $mkd_options['cf7_custom_style_3_element_font_weight'] !== '') {
				$cf7_custom_style_3_elements_styles .= 'font-weight: '.esc_attr($mkd_options['cf7_custom_style_3_element_font_weight']).';';
			}

			if(isset($mkd_options['cf7_custom_style_3_element_letter_spacing']) && $mkd_options['cf7_custom_style_3_element_letter_spacing'] !== '') {
				$cf7_custom_style_3_elements_styles .= 'letter-spacing: '.esc_attr($mkd_options['cf7_custom_style_3_element_letter_spacing']).'px;';
			}

			if(isset($mkd_options['cf7_custom_style_3_element_text_transform']) && $mkd_options['cf7_custom_style_3_element_text_transform'] !== '') {
				$cf7_custom_style_3_elements_styles .= 'text-transform: '.esc_attr($mkd_options['cf7_custom_style_3_element_text_transform']).';';
			}

			if(isset($mkd_options['cf7_custom_style_3_element_padding_top']) && $mkd_options['cf7_custom_style_3_element_padding_top'] !== '') {
				$cf7_custom_style_3_elements_styles .= 'padding-top: '.esc_attr($mkd_options['cf7_custom_style_3_element_padding_top']).'px;';
			}

			if(isset($mkd_options['cf7_custom_style_3_element_padding_right']) && $mkd_options['cf7_custom_style_3_element_padding_right'] !== '') {
				$cf7_custom_style_3_elements_styles .= 'padding-right: '.esc_attr($mkd_options['cf7_custom_style_3_element_padding_right']).'px;';
			}
			if(isset($mkd_options['cf7_custom_style_3_element_padding_bottom']) && $mkd_options['cf7_custom_style_3_element_padding_bottom'] !== '') {
				$cf7_custom_style_3_elements_styles .= 'padding-bottom: '.esc_attr($mkd_options['cf7_custom_style_3_element_padding_bottom']).'px;';
			}
			if(isset($mkd_options['cf7_custom_style_3_element_padding_left']) && $mkd_options['cf7_custom_style_3_element_padding_left'] !== '') {
				$cf7_custom_style_3_elements_styles .= 'padding-left: '.esc_attr($mkd_options['cf7_custom_style_3_element_padding_left']).'px;';
			}

			if(isset($mkd_options['cf7_custom_style_3_element_margin_top']) && $mkd_options['cf7_custom_style_3_element_margin_top'] !== '') {
				$cf7_custom_style_3_elements_styles .= 'margin-top: '.esc_attr($mkd_options['cf7_custom_style_3_element_margin_top']).'px;';
			}

			if(isset($mkd_options['cf7_custom_style_3_element_margin_bottom']) && $mkd_options['cf7_custom_style_3_element_margin_bottom'] !== '') {
				$cf7_custom_style_3_elements_styles .= 'margin-bottom: '.esc_attr($mkd_options['cf7_custom_style_3_element_margin_bottom']).'px;';
				?>.cf7_custom_style_3 span.wpcf7-not-valid-tip{
                top: -<?php echo esc_attr($mkd_options['cf7_custom_style_3_element_margin_bottom']).'px;'; ?>;
                }<?php
			}

			$cf7_custom_style_3_elements_focus_styles = '';
			$cf7_custom_style_3_focus_color_placeholder = '';

			if(isset($mkd_options['cf7_custom_style_3_element_font_focus_color']) && $mkd_options['cf7_custom_style_3_element_font_focus_color'] !== '') {
				$cf7_custom_style_3_elements_focus_styles .= 'color: '.$mkd_options['cf7_custom_style_3_element_font_focus_color'].';';
				$cf7_custom_style_3_focus_color_placeholder .= 'color: '.$mkd_options['cf7_custom_style_3_element_font_focus_color'].';';
			}

			if(isset($mkd_options['cf7_custom_style_3_element_focus_background_color']) && $mkd_options['cf7_custom_style_3_element_focus_background_color'] !== '') {
				if(isset($mkd_options['cf7_custom_style_3_element_focus_background_transparency']) && $mkd_options['cf7_custom_style_3_element_focus_background_transparency'] !== ''){
					$cf7_custom_style_3_element_focus_background_color = mikado_one_mikado_hex2rgb($mkd_options['cf7_custom_style_3_element_focus_background_color']);
					$cf7_custom_style_3_elements_focus_styles .= 'background-color: rgba('. $cf7_custom_style_3_element_focus_background_color[0] . ',' . $cf7_custom_style_3_element_focus_background_color[1] . ',' . $cf7_custom_style_3_element_focus_background_color[2] . ',' . $mkd_options['cf7_custom_style_3_element_focus_background_transparency'] .');';
				} else {
					$cf7_custom_style_3_elements_focus_styles .= 'background-color: '.$mkd_options['cf7_custom_style_3_element_focus_background_color'].';';
				}
			}

			if(isset($mkd_options['cf7_custom_style_3_element_focus_border_color']) && $mkd_options['cf7_custom_style_3_element_focus_border_color'] !== '') {
				if(isset($mkd_options['cf7_custom_style_3_button_border_transparency']) && $mkd_options['cf7_custom_style_3_button_border_transparency'] !== ''){
					$cf7_custom_style_3_element_focus_border_color = mikado_one_mikado_hex2rgb($mkd_options['cf7_custom_style_3_element_focus_border_color']);
					$cf7_custom_style_3_elements_focus_styles .= 'border-color: rgba('. $cf7_custom_style_3_element_focus_border_color[0] . ',' . $cf7_custom_style_3_element_focus_border_color[1] . ',' . $cf7_custom_style_3_element_focus_border_color[2] . ',' . $mkd_options['cf7_custom_style_3_button_border_transparency'] .');';

				} else {
					$cf7_custom_style_3_elements_focus_styles .= 'border-color: '.$mkd_options['cf7_custom_style_3_element_focus_border_color'].';';
				}
			}


			$cf7_custom_style_3_button_styles = '';
			if(isset($mkd_options['cf7_custom_style_3_button_background_color']) && $mkd_options['cf7_custom_style_3_button_background_color'] !== '') {
				if(isset($mkd_options['cf7_custom_style_3_button_background_transparency']) && $mkd_options['cf7_custom_style_3_button_background_transparency'] !== ''){
					$cf7_custom_style_3_button_background_color = mikado_one_mikado_hex2rgb($mkd_options['cf7_custom_style_3_button_background_color']);
					$cf7_custom_style_3_button_styles .= 'background-color: rgba('. esc_attr($cf7_custom_style_3_button_background_color[0]) . ',' . esc_attr($cf7_custom_style_3_button_background_color[1]) . ',' . esc_attr($cf7_custom_style_3_button_background_color[2]) . ',' . esc_attr($mkd_options['cf7_custom_style_3_button_background_transparency']) .');';
				} else {
					$cf7_custom_style_3_button_styles .= 'background-color: '.esc_attr($mkd_options['cf7_custom_style_3_button_background_color']).';';
				}
			}

			if(isset($mkd_options['cf7_custom_style_3_button_border_color']) && $mkd_options['cf7_custom_style_3_button_border_color'] !== '') {
				if(isset($mkd_options['cf7_custom_style_3_button_border_transparency']) && $mkd_options['cf7_custom_style_3_button_border_transparency'] !== ''){
					$cf7_custom_style_3_button_border_color = mikado_one_mikado_hex2rgb($mkd_options['cf7_custom_style_3_button_border_color']);
					$cf7_custom_style_3_button_styles .= 'border-color: rgba('. esc_attr($cf7_custom_style_3_button_border_color[0]) . ',' . esc_attr($cf7_custom_style_3_button_border_color[1]) . ',' . esc_attr($cf7_custom_style_3_button_border_color[2]) . ',' . esc_attr($mkd_options['cf7_custom_style_3_button_border_transparency']) .');';

				} else {
					$cf7_custom_style_3_button_styles .= 'border-color: '.esc_attr($mkd_options['cf7_custom_style_3_button_border_color']).';';
				}
			}

			if(isset($mkd_options['cf7_custom_style_3_button_border_width']) && $mkd_options['cf7_custom_style_3_button_border_width'] !== '') {
				$cf7_custom_style_3_button_styles .= 'border-width: '.esc_attr($mkd_options['cf7_custom_style_3_button_border_width']).'px;';
			}

			if(isset($mkd_options['cf7_custom_style_3_button_border_radius']) && $mkd_options['cf7_custom_style_3_button_border_radius'] !== '') {
				$cf7_custom_style_3_button_styles .= 'border-radius: '.esc_attr($mkd_options['cf7_custom_style_3_button_border_radius']).'px;';
			}

			if(isset($mkd_options['cf7_custom_style_3_button_font_color']) && $mkd_options['cf7_custom_style_3_button_font_color'] !== '') {
				$cf7_custom_style_3_button_styles .= 'color: '.esc_attr($mkd_options['cf7_custom_style_3_button_font_color']).';';
			}

			if(isset($mkd_options['cf7_custom_style_3_button_font_family']) && $mkd_options['cf7_custom_style_3_button_font_family'] !== '-1') {
				$cf7_custom_style_3_button_styles .= 'font-family: '.esc_attr(str_replace('+', ' ', $mkd_options['cf7_custom_style_3_button_font_family'])).';';
			}

			if(isset($mkd_options['cf7_custom_style_3_button_font_size']) && $mkd_options['cf7_custom_style_3_button_font_size'] !== '') {
				$cf7_custom_style_3_button_styles .= 'font-size: '.esc_attr($mkd_options['cf7_custom_style_3_button_font_size']).'px;';
			}

			if(isset($mkd_options['cf7_custom_style_3_button_font_style']) && $mkd_options['cf7_custom_style_3_button_font_style'] !== '') {
				$cf7_custom_style_3_button_styles .= 'font-style: '.esc_attr($mkd_options['cf7_custom_style_3_button_font_style']).';';
			}

			if(isset($mkd_options['cf7_custom_style_3_button_font_weight']) && $mkd_options['cf7_custom_style_3_button_font_weight'] !== '') {
				$cf7_custom_style_3_button_styles .= 'font-weight: '.esc_attr($mkd_options['cf7_custom_style_3_button_font_weight']).';';
			}

			if(isset($mkd_options['cf7_custom_style_3_button_letter_spacing']) && $mkd_options['cf7_custom_style_3_button_letter_spacing'] !== '') {
				$cf7_custom_style_3_button_styles .= 'letter-spacing: '.esc_attr($mkd_options['cf7_custom_style_3_button_letter_spacing']).'px;';
			}

			if(isset($mkd_options['cf7_custom_style_3_button_text_transform']) && $mkd_options['cf7_custom_style_3_button_text_transform'] !== '') {
				$cf7_custom_style_3_button_styles .= 'text-transform: '.esc_attr($mkd_options['cf7_custom_style_3_button_text_transform']).';';
			}

			if(isset($mkd_options['cf7_custom_style_3_button_height']) && $mkd_options['cf7_custom_style_3_button_height'] !== '') {
				$cf7_custom_style_3_button_styles .= 'height: '.esc_attr($mkd_options['cf7_custom_style_3_button_height']).'px;';
				$cf7_custom_style_3_button_styles .= 'line-height: '.esc_attr($mkd_options['cf7_custom_style_3_button_height']).'px;';
			}

			if(isset($mkd_options['cf7_custom_style_3_button_padding']) && $mkd_options['cf7_custom_style_3_button_padding'] !== '') {
				$cf7_custom_style_3_button_styles .= 'padding-left: '.esc_attr($mkd_options['cf7_custom_style_3_button_padding']).'px;';
				$cf7_custom_style_3_button_styles .= 'padding-right: '.esc_attr($mkd_options['cf7_custom_style_3_button_padding']).'px;';
			}

			$cf7_custom_style_3_button_hover_styles = '';

			if(isset($mkd_options['cf7_custom_style_3_button_font_hover_color']) && $mkd_options['cf7_custom_style_3_button_font_hover_color'] !== '') {
				$cf7_custom_style_3_button_hover_styles .= 'color: '.$mkd_options['cf7_custom_style_3_button_font_hover_color'].';';
			}

			if(isset($mkd_options['cf7_custom_style_3_button_hover_background_color']) && $mkd_options['cf7_custom_style_3_button_hover_background_color'] !== '') {
				if(isset($mkd_options['cf7_custom_style_3_button_hover_border_transparency']) && $mkd_options['cf7_custom_style_3_button_hover_border_transparency'] !== ''){
					$cf7_custom_style_3_button_hover_background_color = mikado_one_mikado_hex2rgb($mkd_options['cf7_custom_style_3_button_hover_background_color']);
					$cf7_custom_style_3_button_hover_styles .= 'background-color: rgba('. $cf7_custom_style_3_button_hover_background_color[0] . ',' . $cf7_custom_style_3_button_hover_background_color[1] . ',' . $cf7_custom_style_3_button_hover_background_color[2] . ',' . $mkd_options['cf7_custom_style_3_button_hover_border_transparency'] .');';
				} else {
					$cf7_custom_style_3_button_hover_styles .= 'background-color: '.$mkd_options['cf7_custom_style_3_button_hover_background_color'].';';
				}
			}

			if(isset($mkd_options['cf7_custom_style_3_button_hover_border_color']) && $mkd_options['cf7_custom_style_3_button_hover_border_color'] !== '') {
				if(isset($mkd_options['cf7_custom_style_3_button_border_transparency']) && $mkd_options['cf7_custom_style_3_button_border_transparency'] !== ''){
					$cf7_custom_style_3_button_hover_border_color = mikado_one_mikado_hex2rgb($mkd_options['cf7_custom_style_3_button_hover_border_color']);
					$cf7_custom_style_3_button_hover_styles .= 'border-color: rgba('. $cf7_custom_style_3_button_hover_border_color[0] . ',' . $cf7_custom_style_3_button_hover_border_color[1] . ',' . $cf7_custom_style_3_button_hover_border_color[2] . ',' . $mkd_options['cf7_custom_style_3_button_border_transparency'] .');';

				} else {
					$cf7_custom_style_3_button_hover_styles .= 'border-color: '.$mkd_options['cf7_custom_style_3_button_hover_border_color'].';';
				}
			}

			$cf7_custom_style_1_validation_messages_style = "";
			if(isset($mkd_options['cf7_custom_style_1_error_validation_messages_color']) && $mkd_options['cf7_custom_style_1_error_validation_messages_color'] !== '') {
				$cf7_custom_style_1_validation_messages_style .= 'color: '.$mkd_options['cf7_custom_style_1_error_validation_messages_color'].';';
			}


			$cf7_custom_style_2_validation_messages_style = "";
			if(isset($mkd_options['cf7_custom_style_2_error_validation_messages_color']) && $mkd_options['cf7_custom_style_2_error_validation_messages_color'] !== '') {
				$cf7_custom_style_2_validation_messages_style .= 'color: '.$mkd_options['cf7_custom_style_2_error_validation_messages_color'].';';
			}

			$cf7_custom_style_3_validation_messages_style = "";
			if(isset($mkd_options['cf7_custom_style_3_error_validation_messages_color']) && $mkd_options['cf7_custom_style_3_error_validation_messages_color'] !== '') {
				$cf7_custom_style_3_validation_messages_style .= 'color: '.$mkd_options['cf7_custom_style_3_error_validation_messages_color'].';';
			}
			?>



			<?php if($cf7_custom_style_1_button_styles !== ""){ ?>
                .cf7_custom_style_1 input.wpcf7-form-control.wpcf7-submit,
                .cf7_custom_style_1 input.wpcf7-form-control.wpcf7-submit:not([disabled]) {
				<?php echo esc_attr($cf7_custom_style_1_button_styles); ?>
                }
			<?php } ?>

			<?php if($cf7_custom_style_1_button_hover_styles !== ""){ ?>
                .cf7_custom_style_1 input.wpcf7-form-control.wpcf7-submit:hover,
                .cf7_custom_style_1 input.wpcf7-form-control.wpcf7-submit:not([disabled]):hover {
				<?php echo esc_attr($cf7_custom_style_1_button_hover_styles); ?>
                }
			<?php } ?>

			<?php if($cf7_custom_style_1_elements_styles !== ""){ ?>
                .cf7_custom_style_1 input.wpcf7-form-control.wpcf7-text,
                .cf7_custom_style_1 input.wpcf7-form-control.wpcf7-number,
                .cf7_custom_style_1 input.wpcf7-form-control.wpcf7-date,
                .cf7_custom_style_1 textarea.wpcf7-form-control.wpcf7-textarea,
                .cf7_custom_style_1 select.wpcf7-form-control.wpcf7-select,
                .cf7_custom_style_1 input.wpcf7-form-control.wpcf7-quiz{
				<?php echo esc_attr($cf7_custom_style_1_elements_styles); ?>
                }
			<?php } ?>

			<?php if($cf7_custom_style_1_elements_focus_styles !== ""){ ?>
                .cf7_custom_style_1 input.wpcf7-form-control.wpcf7-text:focus,
                .cf7_custom_style_1 input.wpcf7-form-control.wpcf7-number:focus,
                .cf7_custom_style_1 input.wpcf7-form-control.wpcf7-date:focus,
                .cf7_custom_style_1 textarea.wpcf7-form-control.wpcf7-textarea:focus,
                .cf7_custom_style_1 select.wpcf7-form-control.wpcf7-select:focus,
                .cf7_custom_style_1 input.wpcf7-form-control.wpcf7-quiz:focus{
				<?php echo esc_attr($cf7_custom_style_1_elements_focus_styles); ?>
                }
			<?php } ?>


			<?php if($cf7_custom_style_1_validation_messages_style !== ""){ ?>
                .cf7_custom_style_1 span.wpcf7-not-valid-tip{
				<?php echo esc_attr($cf7_custom_style_1_validation_messages_style); ?>
                }
			<?php } ?>

			<?php if($cf7_custom_style_2_button_styles !== ""){ ?>
                .cf7_custom_style_2 input.wpcf7-form-control.wpcf7-submit,
                .cf7_custom_style_2 input.wpcf7-form-control.wpcf7-submit:not([disabled]) {
				<?php echo esc_attr($cf7_custom_style_2_button_styles); ?>
                }
			<?php } ?>

			<?php if($cf7_custom_style_2_button_hover_styles !== ""){ ?>
                .cf7_custom_style_2 input.wpcf7-form-control.wpcf7-submit:hover,
                .cf7_custom_style_2 input.wpcf7-form-control.wpcf7-submit:not([disabled]):hover {
				<?php echo esc_attr($cf7_custom_style_2_button_hover_styles); ?>
                }
			<?php } ?>

			<?php if($cf7_custom_style_2_elements_styles !== ""){ ?>
                .cf7_custom_style_2 input.wpcf7-form-control.wpcf7-text,
                .cf7_custom_style_2 input.wpcf7-form-control.wpcf7-number,
                .cf7_custom_style_2 input.wpcf7-form-control.wpcf7-date,
                .cf7_custom_style_2 textarea.wpcf7-form-control.wpcf7-textarea,
                .cf7_custom_style_2 select.wpcf7-form-control.wpcf7-select,
                .cf7_custom_style_2 input.wpcf7-form-control.wpcf7-quiz{
				<?php echo esc_attr($cf7_custom_style_2_elements_styles); ?>
                }
			<?php } ?>

			<?php if($cf7_custom_style_2_elements_focus_styles !== ""){ ?>
                .cf7_custom_style_2 input.wpcf7-form-control.wpcf7-text:focus,
                .cf7_custom_style_2 input.wpcf7-form-control.wpcf7-number:focus,
                .cf7_custom_style_2 input.wpcf7-form-control.wpcf7-date:focus,
                .cf7_custom_style_2 textarea.wpcf7-form-control.wpcf7-textarea:focus,
                .cf7_custom_style_2 select.wpcf7-form-control.wpcf7-select:focus,
                .cf7_custom_style_2 input.wpcf7-form-control.wpcf7-quiz:focus{
				<?php echo esc_attr($cf7_custom_style_2_elements_focus_styles); ?>
                }
			<?php } ?>
			<?php if($cf7_custom_style_2_validation_messages_style !== ""){ ?>
                .cf7_custom_style_2 span.wpcf7-not-valid-tip{
				<?php echo esc_attr($cf7_custom_style_2_validation_messages_style); ?>
                }
			<?php } ?>
			<?php if($cf7_custom_style_3_button_styles !== ""){ ?>
                .cf7_custom_style_3 input.wpcf7-form-control.wpcf7-submit,
                .cf7_custom_style_3 input.wpcf7-form-control.wpcf7-submit:not([disabled]) {
				<?php echo esc_attr($cf7_custom_style_3_button_styles); ?>
                }
			<?php } ?>

			<?php if($cf7_custom_style_3_button_hover_styles !== ""){ ?>
                .cf7_custom_style_3 input.wpcf7-form-control.wpcf7-submit:hover,
                .cf7_custom_style_3 input.wpcf7-form-control.wpcf7-submit:not([disabled]):hover {
				<?php echo esc_attr($cf7_custom_style_3_button_hover_styles); ?>
                }
			<?php } ?>

			<?php if($cf7_custom_style_3_elements_styles !== ""){ ?>
                .cf7_custom_style_3 input.wpcf7-form-control.wpcf7-text,
                .cf7_custom_style_3 input.wpcf7-form-control.wpcf7-number,
                .cf7_custom_style_3 input.wpcf7-form-control.wpcf7-date,
                .cf7_custom_style_3 textarea.wpcf7-form-control.wpcf7-textarea,
                .cf7_custom_style_3 select.wpcf7-form-control.wpcf7-select,
                .cf7_custom_style_3 input.wpcf7-form-control.wpcf7-quiz{
				<?php echo esc_attr($cf7_custom_style_3_elements_styles); ?>
                }
			<?php } ?>

			<?php if($cf7_custom_style_3_elements_focus_styles !== ""){ ?>
                .cf7_custom_style_3 input.wpcf7-form-control.wpcf7-text:focus,
                .cf7_custom_style_3 input.wpcf7-form-control.wpcf7-number:focus,
                .cf7_custom_style_3 input.wpcf7-form-control.wpcf7-date:focus,
                .cf7_custom_style_3 textarea.wpcf7-form-control.wpcf7-textarea:focus,
                .cf7_custom_style_3 select.wpcf7-form-control.wpcf7-select:focus,
                .cf7_custom_style_3 input.wpcf7-form-control.wpcf7-quiz:focus{
				<?php echo esc_attr($cf7_custom_style_3_elements_focus_styles); ?>
                }
			<?php } ?>
			<?php if($cf7_custom_style_3_validation_messages_style !== ""){ ?>
                .cf7_custom_style_3 span.wpcf7-not-valid-tip{
				<?php echo esc_attr($cf7_custom_style_3_validation_messages_style); ?>
                }
			<?php } ?>
			<?php if($cf7_custom_style_1_color_placeholder !== ""){ ?>
                .cf7_custom_style_1 ::-webkit-input-placeholder{
				<?php echo esc_attr($cf7_custom_style_1_color_placeholder); ?>
                }
			<?php } ?>
			<?php if($cf7_custom_style_1_color_placeholder !== ""){ ?>
                .cf7_custom_style_1 :-moz-placeholder{
				<?php echo esc_attr($cf7_custom_style_1_color_placeholder); ?>
                }
			<?php } ?>
			<?php if($cf7_custom_style_1_color_placeholder !== ""){ ?>
                .cf7_custom_style_1 ::-moz-placeholder{
				<?php echo esc_attr($cf7_custom_style_1_color_placeholder); ?>
                }
			<?php } ?>
			<?php if($cf7_custom_style_1_color_placeholder !== ""){ ?>
                .cf7_custom_style_1 :-ms-input-placeholde{
				<?php echo esc_attr($cf7_custom_style_1_color_placeholder); ?>
                }
			<?php } ?>
			<?php if($cf7_custom_style_2_color_placeholder !== ""){ ?>
                .cf7_custom_style_2 ::-webkit-input-placeholder{
				<?php echo esc_attr($cf7_custom_style_2_color_placeholder); ?>
                }
			<?php } ?>
			<?php if($cf7_custom_style_2_color_placeholder !== ""){ ?>
                .cf7_custom_style_2 :-moz-placeholder{
				<?php echo esc_attr($cf7_custom_style_2_color_placeholder); ?>
                }
			<?php } ?>
			<?php if($cf7_custom_style_2_color_placeholder !== ""){ ?>
                .cf7_custom_style_2 ::-moz-placeholder{
				<?php echo esc_attr($cf7_custom_style_2_color_placeholder); ?>
                }
			<?php } ?>
			<?php if($cf7_custom_style_2_color_placeholder !== ""){ ?>
                .cf7_custom_style_2 :-ms-input-placeholde{
				<?php echo esc_attr($cf7_custom_style_2_color_placeholder); ?>
                }
			<?php } ?>
			<?php if($cf7_custom_style_3_color_placeholder !== ""){ ?>
                .cf7_custom_style_3 ::-webkit-input-placeholder{
				<?php echo esc_attr($cf7_custom_style_3_color_placeholder); ?>
                }
			<?php } ?>
			<?php if($cf7_custom_style_3_color_placeholder !== ""){ ?>
                .cf7_custom_style_3 :-moz-placeholder{
				<?php echo esc_attr($cf7_custom_style_3_color_placeholder); ?>
                }
			<?php } ?>
			<?php if($cf7_custom_style_3_color_placeholder !== ""){ ?>
                .cf7_custom_style_3 ::-moz-placeholder{
				<?php echo esc_attr($cf7_custom_style_3_color_placeholder); ?>
                }
			<?php } ?>
			<?php if($cf7_custom_style_3_color_placeholder !== ""){ ?>
                .cf7_custom_style_3 :-ms-input-placeholde{
				<?php echo esc_attr($cf7_custom_style_3_color_placeholder); ?>
                }
			<?php } ?>
			<?php if($cf7_custom_style_1_focus_color_placeholder !== ""){ ?>
                .cf7_custom_style_1 input:focus::-webkit-input-placeholder,
                .cf7_custom_style_1 textarea:focus::-webkit-input-placeholder{
				<?php echo esc_attr($cf7_custom_style_1_focus_color_placeholder); ?>
                }
			<?php } ?>
			<?php if($cf7_custom_style_1_focus_color_placeholder !== ""){ ?>
                .cf7_custom_style_1 input:focus:-moz-placeholder,
                .cf7_custom_style_1 textarea:focus:-moz-placeholder{
				<?php echo esc_attr($cf7_custom_style_1_focus_color_placeholder); ?>
                }
			<?php } ?>
			<?php if($cf7_custom_style_1_focus_color_placeholder !== ""){ ?>
                .cf7_custom_style_1 input:focus::-moz-placeholder,
                .cf7_custom_style_1 textarea:focus::-moz-placeholder{
				<?php echo esc_attr($cf7_custom_style_1_focus_color_placeholder); ?>
                }
			<?php } ?>
			<?php if($cf7_custom_style_1_focus_color_placeholder !== ""){ ?>
                .cf7_custom_style_1 input:focus:-ms-input-placeholder,
                .cf7_custom_style_1 textarea:focus:-ms-input-placeholder{
				<?php echo esc_attr($cf7_custom_style_1_focus_color_placeholder); ?>
                }
			<?php } ?>
			<?php if($cf7_custom_style_2_focus_color_placeholder !== ""){ ?>
                .cf7_custom_style_2 input:focus::-webkit-input-placeholder,
                .cf7_custom_style_2 textarea:focus::-webkit-input-placeholder{
				<?php echo esc_attr($cf7_custom_style_2_focus_color_placeholder); ?>
                }
			<?php } ?>
			<?php if($cf7_custom_style_2_focus_color_placeholder !== ""){ ?>
                .cf7_custom_style_2 input:focus:-moz-placeholder,
                .cf7_custom_style_2 textarea:focus:-moz-placeholder{
				<?php echo esc_attr($cf7_custom_style_2_focus_color_placeholder); ?>
                }
			<?php } ?>
			<?php if($cf7_custom_style_2_focus_color_placeholder !== ""){ ?>
                .cf7_custom_style_2 input:focus::-moz-placeholder,
                .cf7_custom_style_2 textarea:focus::-moz-placeholder{
				<?php echo esc_attr($cf7_custom_style_2_focus_color_placeholder); ?>
                }
			<?php } ?>
			<?php if($cf7_custom_style_2_focus_color_placeholder !== ""){ ?>
                .cf7_custom_style_2 input:focus:-ms-input-placeholder,
                .cf7_custom_style_2 textarea:focus:-ms-input-placeholder{
				<?php echo esc_attr($cf7_custom_style_2_focus_color_placeholder); ?>
                }
			<?php } ?>
			<?php if($cf7_custom_style_3_focus_color_placeholder !== ""){ ?>
                .cf7_custom_style_3 input:focus::-webkit-input-placeholder,
                .cf7_custom_style_3 textarea:focus::-webkit-input-placeholder{
				<?php echo esc_attr($cf7_custom_style_3_focus_color_placeholder); ?>
                }
			<?php } ?>
			<?php if($cf7_custom_style_3_focus_color_placeholder !== ""){ ?>
                .cf7_custom_style_3 input:focus:-moz-placeholder,
                .cf7_custom_style_3 textarea:focus:-moz-placeholder{
				<?php echo esc_attr($cf7_custom_style_3_focus_color_placeholder); ?>
                }
			<?php } ?>
			<?php if($cf7_custom_style_3_focus_color_placeholder !== ""){ ?>
                .cf7_custom_style_3 input:focus::-moz-placeholder,
                .cf7_custom_style_3 textarea:focus::-moz-placeholder{
				<?php echo esc_attr($cf7_custom_style_3_focus_color_placeholder); ?>
                }
			<?php } ?>
			<?php if($cf7_custom_style_3_focus_color_placeholder !== ""){ ?>
                .cf7_custom_style_3 input:focus:-ms-input-placeholder,
                .cf7_custom_style_3 textarea:focus:-ms-input-placeholder{
				<?php echo esc_attr($cf7_custom_style_3_focus_color_placeholder); ?>
                }
			<?php } ?>
			<?php
		} //end custom style contact form 7
		?>

		<?php
		if(isset($mkd_options['cf7_custom_style_1_element_textarea_height']) && $mkd_options['cf7_custom_style_1_element_textarea_height'] !== '') {?>
            .cf7_custom_style_1 textarea.wpcf7-form-control.wpcf7-textarea{
            height: <?php echo esc_attr($mkd_options['cf7_custom_style_1_element_textarea_height']); ?>px;
            }
		<?php } ?>
		<?php
		if(isset($mkd_options['cf7_custom_style_2_element_textarea_height']) && $mkd_options['cf7_custom_style_2_element_textarea_height'] !== '') {?>
            .cf7_custom_style_2 textarea.wpcf7-form-control.wpcf7-textarea{
            height: <?php echo esc_attr($mkd_options['cf7_custom_style_2_element_textarea_height']); ?>px;
            }
		<?php } ?>
		<?php
		if(isset($mkd_options['cf7_custom_style_3_element_textarea_height']) && $mkd_options['cf7_custom_style_3_element_textarea_height'] !== '') {?>
            .cf7_custom_style_3 textarea.wpcf7-form-control.wpcf7-textarea{
            height: <?php echo esc_attr($mkd_options['cf7_custom_style_3_element_textarea_height']); ?>px;
            }
		<?php } ?>


		<?php
		/* ==========================================================================
   Social sidebar styles
   ========================================================================== */

		if(isset($mkd_options['social_sidebar_icon_space_size']) && $mkd_options['social_sidebar_icon_space_size'] !== '') { ?>
            #social_icons_widget .mkd_social_icon_holder{
            margin-bottom: <?php echo esc_attr($mkd_options['social_sidebar_icon_space_size']);?>px!important;
            }
		<?php }

		/* ==========================================================================
   End of social sidebar styles
   ========================================================================== */

		?>

		<?php
		$page_404_title_style = array();

		if(isset($mkd_options['404_title_font_family']) && $mkd_options['404_title_font_family'] !== '-1') {
			$page_404_title_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['404_title_font_family']).', sans-serif';
		}

		if(isset($mkd_options['404_title_font_size']) && $mkd_options['404_title_font_size'] !== '') {
			$page_404_title_style[] = 'font-size: '.intval($mkd_options['404_title_font_size']).'px';
		}

		if(isset($mkd_options['404_title_line_height']) && $mkd_options['404_title_line_height'] !== '') {
			$page_404_title_style[] = 'line-height: '.intval($mkd_options['404_title_line_height']).'px';
		}

		if(isset($mkd_options['404_title_letter_spacing']) && $mkd_options['404_title_letter_spacing'] !== '') {
			$page_404_title_style[] = 'letter-spacing: '.intval($mkd_options['404_title_letter_spacing']).'px';
		}

		if(isset($mkd_options['404_title_font_weight']) && $mkd_options['404_title_font_weight'] !== '') {
			$page_404_title_style[] = 'font-weight: '.intval($mkd_options['404_title_font_weight']);
		}

		if(isset($mkd_options['404_title_font_style']) && $mkd_options['404_title_font_style'] !== '') {
			$page_404_title_style[] = 'font-style: '.$mkd_options['404_title_font_style'];
		}

		if(isset($mkd_options['404_title_text_transform']) && $mkd_options['404_title_text_transform'] !== '') {
			$page_404_title_style[] = 'text-transform: '.$mkd_options['404_title_text_transform'];
		}

		if(isset($mkd_options['404_title_color']) && $mkd_options['404_title_color'] !== '') {
			$page_404_title_style[] = 'color: '.$mkd_options['404_title_color'];
		}

		if(is_array($page_404_title_style) && count($page_404_title_style)) { ?>
            .page_not_found h2{
			<?php echo esc_attr(implode(';', $page_404_title_style)); ?>
            }
		<?php } ?>

		<?php
		$page_404_text_style = array();

		if(isset($mkd_options['404_text_font_family']) && $mkd_options['404_text_font_family'] !== '-1') {
			$page_404_text_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['404_text_font_family']).', sans-serif';
		}

		if(isset($mkd_options['404_text_font_size']) && $mkd_options['404_text_font_size'] !== '') {
			$page_404_text_style[] = 'font-size: '.intval($mkd_options['404_text_font_size']).'px';
		}

		if(isset($mkd_options['404_text_line_height']) && $mkd_options['404_text_line_height'] !== '') {
			$page_404_text_style[] = 'line-height: '.intval($mkd_options['404_text_line_height']).'px';
		}

		if(isset($mkd_options['404_text_letter_spacing']) && $mkd_options['404_text_letter_spacing'] !== '') {
			$page_404_text_style[] = 'letter-spacing: '.intval($mkd_options['404_text_letter_spacing']).'px';
		}

		if(isset($mkd_options['404_text_font_weight']) && $mkd_options['404_text_font_weight'] !== '') {
			$page_404_text_style[] = 'font-weight: '.intval($mkd_options['404_text_font_weight']);
		}

		if(isset($mkd_options['404_text_font_style']) && $mkd_options['404_text_font_style'] !== '') {
			$page_404_text_style[] = 'font-style: '.$mkd_options['404_text_font_style'];
		}

		if(isset($mkd_options['404_text_text_transform']) && $mkd_options['404_text_text_transform'] !== '') {
			$page_404_text_style[] = 'text-transform: '.$mkd_options['404_text_text_transform'];
		}

		if(isset($mkd_options['404_text_color']) && $mkd_options['404_text_color'] !== '') {
			$page_404_text_style[] = 'color: '.$mkd_options['404_text_color'];
		}

		if(is_array($page_404_text_style) && count($page_404_text_style)) { ?>
            .page_not_found h4{
			<?php echo esc_attr(implode(';', $page_404_text_style)); ?>
            }
		<?php } ?>

		<?php
		if(is_admin_bar_showing()){
			?>

            @media only screen and (min-width: 1000px){
            header.sticky.sticky_animate,
            header.fixed{
            padding-top: 32px !important;
            }

            header.sticky .mkd_search_form, header.sticky .mkd_search_form_3,
            header.fixed .mkd_search_form, header.fixed .mkd_search_form_3{
            top: 32px;
            }

            .side_menu{
            top: 32px;
            }
            }

			<?php
		}
		?>

		<?php

		$social_sidebar_style = array();
		if(isset($mkd_options['social_sidebar_icon_position_top']) && $mkd_options['social_sidebar_icon_position_top'] !== '') {
			if((strstr($mkd_options['social_sidebar_icon_position_top'], 'px', true)) || (strstr($mkd_options['social_sidebar_icon_position_top'], '%', true))){
				$social_sidebar_style[] = 'top: '.intval($mkd_options['social_sidebar_icon_position_top']);
			}
			$social_sidebar_style[] = 'top: '.intval($mkd_options['social_sidebar_icon_position_top']).'px';
		}
		if(isset($mkd_options['social_sidebar_icon_position_right']) && $mkd_options['social_sidebar_icon_position_right'] !== '') {
			if((strstr($mkd_options['social_sidebar_icon_position_top'], 'px', true)) || (strstr($mkd_options['social_sidebar_icon_position_top'], '%', true))){
				$social_sidebar_style[] = 'right: '.intval($mkd_options['social_sidebar_icon_position_right']);
			}
			$social_sidebar_style[] = 'right: '.intval($mkd_options['social_sidebar_icon_position_right']).'px';
		}

		if(is_array($social_sidebar_style) && count($social_sidebar_style)) { ?>
            #social_icons_widget{
			<?php echo esc_attr(implode(';', $social_sidebar_style)); ?>
            }
		<?php } ?>

		<?php if(function_exists('is_woocommerce')) { ?>

            @media only screen and (min-width: 768px) {

			<?php //This is here because when css file is compressed  calc() doesn't work ?>
            .woocommerce-page  .  ul.products.type3  li.product,
            .woocommerce-page  ul.products.type3  li.product,
            .woocommerce.columns-2 ul.products.type3 li.product,
            .woocommerce ul.products.type3  li.product,
            .woocommerce-page ul.products.type3  li.product{
            width: 50%;
            width: -moz-calc(50% + 2px);
            width: -webkit-calc(50% + 2px);
            width: -o-calc(50% + 2px);
            width: calc(50% + 2px);
            }

            .woocommerce.columns-3 ul.products.type3 li.product{
            width: 33.33333%;
            width: -moz-calc(33.33333% + 2px);
            width: -webkit-calc(33.33333% + 2px);
            width: -o-calc(33.33333% + 2px);
            width: calc(33.33333% + 2px);
            }
            .woocommerce.columns-4 ul.products.type3 li.product,
            .woocommerce-page .related.products ul.products.type3 li.product{
            width: 25%;
            width: -moz-calc(25% + 2px);
            width: -webkit-calc(25% + 2px);
            width: -o-calc(25% + 2px);
            width: calc(25% + 2px);
            }
            .woocommerce.columns-5 ul.products.type3 li.product{
            width:20%;
            width: -moz-calc(20% + 2px);
            width: -webkit-calc(20% + 2px);
            width: -o-calc(20% + 2px);
            width: calc(20% + 2px);
            }
            }

            @media only screen and (min-width: 480px) and (max-width: 768px) {
            .woocommerce-page  .  ul.products.type3  li.product,
            .woocommerce-page  ul.products.type3  li.product,
            .woocommerce.columns-2 ul.products.type3 li.product,
            .woocommerce ul.products.type3  li.product,
            .woocommerce-page ul.products.type3  li.product,
            .woocommerce.columns-3 ul.products.type3 li.product,
            .woocommerce.columns-4 ul.products.type3 li.product,
            .woocommerce-page .related.products ul.products.type3 li.product,
            .woocommerce.columns-5 ul.products.type3 li.product{
            width: 50%;
            width: -moz-calc(50% + 2px);
            width: -webkit-calc(50% + 2px);
            width: -o-calc(50% + 2px);
            width: calc(50% + 2px);
            }

            }

		<?php } ?>


		<?php if (!empty($mkd_options['woo_input_background_color']) || !empty($mkd_options['woo_input_border_color']) || !empty($mkd_options['woo_input_text_color'])) { ?>
            .woocommerce input[type="text"],.woocommerce-page input[type="text"],
            .woocommerce input[type="email"],.woocommerce-page input[type="email"],
            .woocommerce textarea,.woocommerce-page textarea,.woocommerce input[type="password"],
            .woocommerce-page input[type="password"],
            .woocommerce-checkout .select2-container .select2-choice,
            .woocommerce-account .select2-container .select2-choice,
            .woocommerce .chosen-container.chosen-container-single .chosen-single,
            .woocommerce-page .chosen-container.chosen-container-single .chosen-single,
            .woocommerce-checkout .chosen-container.chosen-container-single .chosen-single,
            .woocommerce table.cart div.coupon .input-text,
            .woocommerce-page table.cart div.coupon .input-text,
            .woocommerce div.cart-collaterals .select2-container .select2-choice,
            .woocommerce-page div.cart-collaterals .select2-container .select2-choice{
			<?php if (!empty($mkd_options['woo_input_background_color'])) { ?>background-color: <?php echo esc_attr($mkd_options['woo_input_background_color']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['woo_input_border_color'])) { ?>border-color: <?php echo esc_attr($mkd_options['woo_input_border_color']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['woo_input_text_color'])) { ?>color:<?php echo esc_attr($mkd_options['woo_input_text_color']);  ?>; <?php } ?>
            }
		<?php } ?>

		<?php if(!empty($mkd_options['woo_input_border_width'])) { ?>
            .woocommerce input[type="text"],
            .woocommerce-page input[type="text"],
            .woocommerce input[type="email"],
            .woocommerce-page input[type="email"],
            .woocommerce textarea,
            .woocommerce-page textarea,
            .woocommerce input[type="password"],
            .woocommerce-page input[type="password"],
            .woocommerce table.cart div.coupon .input-text,
            .woocommerce-page table.cart div.coupon .input-text,
            .select2-container .select2-choice,
            .woocommerce-checkout .select2-container .select2-choice,
            .woocommerce-account .select2-container .select2-choice,
            .woocommerce .chosen-container.chosen-container-single .chosen-single,
            .woocommerce-page .chosen-container.chosen-container-single .chosen-single,
            .woocommerce-checkout .chosen-container.chosen-container-single .chosen-single,
            .woocommerce select#pa_color{
            border-width: <?php echo esc_attr($mkd_options['woo_input_border_width']); ?>px;
            }
		<?php } ?>


		<?php if(!empty($mkd_options['woo_input_focus_text_color']) || !empty($mkd_options['woo_input_focus_background_color']) || !empty($mkd_options['woo_input_focus_border_color'])) { ?>
            .woocommerce input[type="text"]:focus,.woocommerce-page input[type="text"]:focus,
            .woocommerce input[type="email"]:focus,.woocommerce-page input[type="email"]:focus,
            .woocommerce textarea:focus,.woocommerce-page textarea:focus,
            .woocommerce input[type="password"]:focus,.woocommerce-page input[type="password"]:focus,
            .woocommerce table.cart div.coupon .input-text:focus,.woocommerce-page table.cart div.coupon .input-text:focus,
            .woocommerce-checkout .select2-container .select2-choice:focus,
            .woocommerce-account .select2-container .select2-choice:focus{
			<?php if (!empty($mkd_options['woo_input_focus_text_color'])) { ?>color: <?php echo esc_attr($mkd_options['woo_input_focus_text_color']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['woo_input_focus_background_color'])) { ?>background-color: <?php echo esc_attr($mkd_options['woo_input_focus_background_color']);  ?>; <?php } ?>
			<?php if (!empty($mkd_options['woo_input_focus_border_color'])) { ?>border-color: <?php echo esc_attr($mkd_options['woo_input_focus_border_color']);  ?>; <?php } ?>
            }
		<?php } ?>


		<?php if (isset($mkd_options['woo_products_box_text_align']) && !empty($mkd_options['woo_products_box_text_align'])) { ?>
            .woocommerce-page ul.products li.product,
            .woocommerce ul.products li.product{
            text-align: <?php echo esc_attr($mkd_options['woo_products_box_text_align']); ?>;
            }
			<?php if (($mkd_options['woo_products_box_text_align'])!= "center") { ?>
                .woocommerce .product_info_box .separator.medium,
                .woocommerce ul.products li.product .price, .woocommerce-page ul.products li.product .price{
                float:  <?php echo esc_attr($mkd_options['woo_products_box_text_align']); ?>;
                }
			<?php }elseif (($mkd_options['woo_products_box_text_align']) == "center"){?>
                .woocommerce .product_info_box .separator.medium{
                float: none;
                margin-left: auto;
                margin-right: auto;
                }
			<?php }} ?>


		<?php
		$woo_products_category_style = array();

		if(isset($mkd_options['woo_products_category_font_family']) && $mkd_options['woo_products_category_font_family'] !== '-1') {
			$woo_products_category_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['woo_products_category_font_family']).', sans-serif';
		}

		if(isset($mkd_options['woo_products_category_font_size']) && $mkd_options['woo_products_category_font_size'] !== '') {
			$woo_products_category_style[] = 'font-size: '.intval($mkd_options['woo_products_category_font_size']).'px';
		}

		if(isset($mkd_options['woo_products_category_line_height']) && $mkd_options['woo_products_category_line_height'] !== '') {
			$woo_products_category_style[] = 'line-height: '.intval($mkd_options['woo_products_category_line_height']).'px';
		}

		if(isset($mkd_options['woo_products_category_letter_spacing']) && $mkd_options['woo_products_category_letter_spacing'] !== '') {
			$woo_products_category_style[] = 'letter-spacing: '.intval($mkd_options['woo_products_category_letter_spacing']).'px';
		}

		if(isset($mkd_options['woo_products_category_font_weight']) && $mkd_options['woo_products_category_font_weight'] !== '') {
			$woo_products_category_style[] = 'font-weight: '.intval($mkd_options['woo_products_category_font_weight']);
		}

		if(isset($mkd_options['woo_products_category_font_style']) && $mkd_options['woo_products_category_font_style'] !== '') {
			$woo_products_category_style[] = 'font-style: '.$mkd_options['woo_products_category_font_style'];
		}

		if(isset($mkd_options['woo_products_category_text_transform']) && $mkd_options['woo_products_category_text_transform'] !== '') {
			$woo_products_category_style[] = 'text-transform: '.$mkd_options['woo_products_category_text_transform'];
		}

		if(isset($mkd_options['woo_products_category_color']) && $mkd_options['woo_products_category_color'] !== '') {
			$woo_products_category_style[] = 'color: '.$mkd_options['woo_products_category_color'];
		}

		if(is_array($woo_products_category_style) && count($woo_products_category_style)) { ?>
            .woocommerce ul.products li.product span.product-categories a,
            .woocommerce-page ul.products li.product span.product-categories a{
			<?php echo esc_attr(implode(';', $woo_products_category_style)); ?>
            }
		<?php } ?>

		<?php if (isset($mkd_options['woo_products_category_hide_category']) && $mkd_options['woo_products_category_hide_category'] == "yes") { ?>
            .woocommerce ul.products li.product span.product-categories,
            .woocommerce-page ul.products li.product span.product-categories{
            display:none;
            }
            .woocommerce-page ul.products li.product .product_info_box,
            .woocommerce ul.products li.product .product_info_box{
            padding-top:18px;
            }
		<?php } ?>

		<?php if (isset($mkd_options['woo_products_title_separator_hide_title_separator']) && $mkd_options['woo_products_title_separator_hide_title_separator'] == "yes") { ?>
            .woocommerce .product_info_box .separator_holder{
            display:none;
            }
            .woocommerce ul.products li.product span.product-title{
            margin: 0 0 12px 0;
            }

		<?php } ?>

		<?php if (isset($mkd_options['woo_products_title_separator_hide_title_separator']) && $mkd_options['woo_products_title_separator_hide_title_separator'] == "no" && !empty($mkd_options['woo_products_title_separator_color'])) { ?>
            .woocommerce .product_info_box .separator_holder .separator.medium{
            border-color: <?php echo esc_attr($mkd_options['woo_products_title_separator_color']); ?>;
            }
		<?php } ?>




		<?php
		$woo_products_title_style = array();

		if(isset($mkd_options['woo_products_title_font_family']) && $mkd_options['woo_products_title_font_family'] !== '-1') {
			$woo_products_title_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['woo_products_title_font_family']).', sans-serif';
		}

		if(isset($mkd_options['woo_products_title_font_size']) && $mkd_options['woo_products_title_font_size'] !== '') {
			$woo_products_title_style[] = 'font-size: '.intval($mkd_options['woo_products_title_font_size']).'px';
		}

		if(isset($mkd_options['woo_products_title_line_height']) && $mkd_options['woo_products_title_line_height'] !== '') {
			$woo_products_title_style[] = 'line-height: '.intval($mkd_options['woo_products_title_line_height']).'px';
		}

		if(isset($mkd_options['woo_products_title_letter_spacing']) && $mkd_options['woo_products_title_letter_spacing'] !== '') {
			$woo_products_title_style[] = 'letter-spacing: '.intval($mkd_options['woo_products_title_letter_spacing']).'px';
		}

		if(isset($mkd_options['woo_products_title_font_weight']) && $mkd_options['woo_products_title_font_weight'] !== '') {
			$woo_products_title_style[] = 'font-weight: '.intval($mkd_options['woo_products_title_font_weight']);
		}

		if(isset($mkd_options['woo_products_title_font_style']) && $mkd_options['woo_products_title_font_style'] !== '') {
			$woo_products_title_style[] = 'font-style: '.intval($mkd_options['woo_products_title_font_style']);
		}

		if(isset($mkd_options['woo_products_title_text_transform']) && $mkd_options['woo_products_title_text_transform'] !== '') {
			$woo_products_title_style[] = 'text-transform: '.$mkd_options['woo_products_title_text_transform'];
		}

		if(isset($mkd_options['woo_products_title_color']) && $mkd_options['woo_products_title_color'] !== '') {
			$woo_products_title_style[] = 'color: '.$mkd_options['woo_products_title_color'];
		}

		if(is_array($woo_products_title_style) && count($woo_products_title_style)) { ?>
            .woocommerce ul.products li.product span.product-title,
            .woocommerce aside ul.product_list_widget li a,
            aside ul.product_list_widget li a{
			<?php echo esc_attr(implode(';', $woo_products_title_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['woo_products_title_hover_color']) && !empty($mkd_options['woo_products_title_hover_color'])) { ?>
            .woocommerce ul.products li.product span.product-title:hover,
            .woocommerce aside ul.product_list_widget li > a:hover,
            aside ul.product_list_widget li > a:hover{
            color: <?php echo esc_attr($mkd_options['woo_products_title_hover_color']); ?>;
            }
		<?php } ?>


		<?php if(isset($mkd_options['woo_products_add_to_cart_color']) && !empty($mkd_options['woo_products_add_to_cart_color'])) { ?>
            .woocommerce ul.products li.product .add-to-cart-button-inner2 a.button.add_to_cart_button,
            .woocommerce ul.products li.product .add-to-cart-button-inner2 a.added_to_cart{
            background-color: <?php echo esc_attr($mkd_options['woo_products_add_to_cart_color']); ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['woo_products_add_to_cart_hover_color']) && !empty($mkd_options['woo_products_add_to_cart_hover_color'])) { ?>
            .woocommerce ul.products li.product .add-to-cart-button-inner2 a.button.add_to_cart_button:hover,
            .woocommerce ul.products li.product .add-to-cart-button-inner2 a.added_to_cart:hover{
            background-color: <?php echo esc_attr($mkd_options['woo_products_add_to_cart_hover_color']); ?>;
            }
		<?php } ?>




		<?php
		$woo_products_price_style = array();

		if(isset($mkd_options['woo_products_price_font_family']) && $mkd_options['woo_products_price_font_family'] !== '-1') {
			$woo_products_price_style[] = 'font-family: '.esc_attr(str_replace('+', ' ', $mkd_options['woo_products_price_font_family'])).', sans-serif';
		}

		if(isset($mkd_options['woo_products_price_font_size']) && $mkd_options['woo_products_price_font_size'] !== '') {
			$woo_products_price_style[] = 'font-size: '.esc_attr($mkd_options['woo_products_price_font_size']).'px';
		}

		if(isset($mkd_options['woo_products_price_line_height']) && $mkd_options['woo_products_price_line_height'] !== '') {
			$woo_products_price_style[] = 'line-height: '.esc_attr($mkd_options['woo_products_price_line_height']).'px';
		}

		if(isset($mkd_options['woo_products_price_letter_spacing']) && $mkd_options['woo_products_price_letter_spacing'] !== '') {
			$woo_products_price_style[] = 'letter-spacing: '.esc_attr($mkd_options['woo_products_price_letter_spacing']).'px';
		}

		if(isset($mkd_options['woo_products_price_font_weight']) && $mkd_options['woo_products_price_font_weight'] !== '') {
			$woo_products_price_style[] = 'font-weight: '.esc_attr($mkd_options['woo_products_price_font_weight']);
		}

		if(isset($mkd_options['woo_products_price_font_style']) && $mkd_options['woo_products_price_font_style'] !== '') {
			$woo_products_price_style[] = 'font-style: '.esc_attr($mkd_options['woo_products_price_font_style']);
		}

		if(isset($mkd_options['woo_products_price_text_transform']) && $mkd_options['woo_products_price_text_transform'] !== '') {
			$woo_products_price_style[] = 'text-transform: '.esc_attr($mkd_options['woo_products_price_text_transform']);
		}

		if(isset($mkd_options['woo_products_price_color']) && $mkd_options['woo_products_price_color'] !== '') {
			$woo_products_price_style[] = 'color: '.esc_attr($mkd_options['woo_products_price_color']);
		}

		if(is_array($woo_products_price_style) && count($woo_products_price_style)) { ?>
            .woocommerce ul.products li.product .price,
            .woocommerce-page ul.products li.product .price,
            .woocommerce ul.products li.product del .amount, .woocommerce-page ul.products li.product del .amount,
            .woocommerce aside ul.product_list_widget li span.amount,
            aside ul.product_list_widget li span.amount{
			<?php echo esc_attr(implode(';', $woo_products_price_style)); ?>
            }
		<?php }

		if(isset($mkd_options['woo_products_price_old_color']) && !empty($mkd_options['woo_products_price_old_color'])) { ?>
            .woocommerce-page ul.products li.product del .amount,
            .woocommerce ul.products li.product del .amount,
            .woocommerce-page ul.products li.product del,
            .woocommerce ul.products li.product del,
            .woocommerce aside ul.product_list_widget li del span.amount,
            aside ul.product_list_widget li del span.amount{
            color: <?php echo esc_attr($mkd_options['woo_products_price_old_color']); ?>;
            }
		<?php } ?>

		<?php
		$woo_products_sale_style = array();

		if(isset($mkd_options['woo_products_sale_font_family']) && $mkd_options['woo_products_sale_font_family'] !== '-1') {
			$woo_products_sale_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['woo_products_sale_font_family']).', sans-serif';
		}

		if(isset($mkd_options['woo_products_sale_font_size']) && $mkd_options['woo_products_sale_font_size'] !== '') {
			$woo_products_sale_style[] = 'font-size: '.intval($mkd_options['woo_products_sale_font_size']).'px';
		}

		if(isset($mkd_options['woo_products_sale_line_height']) && $mkd_options['woo_products_sale_line_height'] !== '') {
			$woo_products_sale_style[] = 'line-height: '.intval($mkd_options['woo_products_sale_line_height']).'px';
		}

		if(isset($mkd_options['woo_products_sale_letter_spacing']) && $mkd_options['woo_products_sale_letter_spacing'] !== '') {
			$woo_products_sale_style[] = 'letter-spacing: '.intval($mkd_options['woo_products_sale_letter_spacing']).'px';
		}

		if(isset($mkd_options['woo_products_sale_font_weight']) && $mkd_options['woo_products_sale_font_weight'] !== '') {
			$woo_products_sale_style[] = 'font-weight: '.intval($mkd_options['woo_products_sale_font_weight']);
		}

		if(isset($mkd_options['woo_products_sale_font_style']) && $mkd_options['woo_products_sale_font_style'] !== '') {
			$woo_products_sale_style[] = 'font-style: '.$mkd_options['woo_products_sale_font_style'];
		}

		if(isset($mkd_options['woo_products_sale_text_transform']) && $mkd_options['woo_products_sale_text_transform'] !== '') {
			$woo_products_sale_style[] = 'text-transform: '.$mkd_options['woo_products_sale_text_transform'];
		}

		if(isset($mkd_options['woo_products_sale_color']) && $mkd_options['woo_products_sale_color'] !== '') {
			$woo_products_sale_style[] = 'color: '.$mkd_options['woo_products_sale_color'];
		}

		if(isset($mkd_options['woo_products_sale_background_color']) && $mkd_options['woo_products_sale_background_color'] !== '') {
			$woo_products_sale_style[] = 'background-color: '.$mkd_options['woo_products_sale_background_color'];
		}

		if(is_array($woo_products_sale_style) && count($woo_products_sale_style)) { ?>
            .woocommerce .product .onsale:not(.out-of-stock-button), .woocommerce .product .single-onsale{
			<?php echo esc_attr(implode(';', $woo_products_sale_style)); ?>
            }
		<?php } ?>

		<?php
		$woo_products_out_of_stock_style = array();

		if(isset($mkd_options['woo_products_out_of_stock_font_family']) && $mkd_options['woo_products_out_of_stock_font_family'] !== '-1') {
			$woo_products_out_of_stock_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['woo_products_out_of_stock_font_family']).', sans-serif';
		}

		if(isset($mkd_options['woo_products_out_of_stock_font_size']) && $mkd_options['woo_products_out_of_stock_font_size'] !== '') {
			$woo_products_out_of_stock_style[] = 'font-size: '.intval($mkd_options['woo_products_out_of_stock_font_size']).'px';
		}

		if(isset($mkd_options['woo_products_out_of_stock_line_height']) && $mkd_options['woo_products_out_of_stock_line_height'] !== '') {
			$woo_products_out_of_stock_style[] = 'line-height: '.intval($mkd_options['woo_products_out_of_stock_line_height']).'px';
		}

		if(isset($mkd_options['woo_products_out_of_stock_letter_spacing']) && $mkd_options['woo_products_out_of_stock_letter_spacing'] !== '') {
			$woo_products_out_of_stock_style[] = 'letter-spacing: '.intval($mkd_options['woo_products_out_of_stock_letter_spacing']).'px';
		}

		if(isset($mkd_options['woo_products_out_of_stock_font_weight']) && $mkd_options['woo_products_out_of_stock_font_weight'] !== '') {
			$woo_products_out_of_stock_style[] = 'font-weight: '.intval($mkd_options['woo_products_out_of_stock_font_weight']);
		}

		if(isset($mkd_options['woo_products_out_of_stock_font_style']) && $mkd_options['woo_products_out_of_stock_font_style'] !== '') {
			$woo_products_out_of_stock_style[] = 'font-style: '.$mkd_options['woo_products_out_of_stock_font_style'];
		}

		if(isset($mkd_options['woo_products_out_of_stock_text_transform']) && $mkd_options['woo_products_out_of_stock_text_transform'] !== '') {
			$woo_products_out_of_stock_style[] = 'text-transform: '.$mkd_options['woo_products_out_of_stock_text_transform'];
		}

		if(isset($mkd_options['woo_products_out_of_stock_color']) && $mkd_options['woo_products_out_of_stock_color'] !== '') {
			$woo_products_out_of_stock_style[] = 'color: '.$mkd_options['woo_products_out_of_stock_color'];
		}

		if(isset($mkd_options['woo_products_out_of_stock_background_color']) && $mkd_options['woo_products_out_of_stock_background_color'] !== '') {
			$woo_products_out_of_stock_style[] = 'background-color: '.$mkd_options['woo_products_out_of_stock_background_color'];
		}

		if(is_array($woo_products_out_of_stock_style) && count($woo_products_out_of_stock_style)) { ?>
            .woocommerce .product .onsale.out-of-stock-button{
			<?php echo esc_attr(implode(';', $woo_products_out_of_stock_style)); ?>
            }
		<?php } ?>

		<?php
		$woo_products_sorting_style = array();

		if(isset($mkd_options['woo_products_sorting_color']) && $mkd_options['woo_products_sorting_color'] !== '') {
			$woo_products_sorting_style[] = 'color: '.$mkd_options['woo_products_sorting_color'];
		}

		if(isset($mkd_options['woo_products_sorting_background_color']) && $mkd_options['woo_products_sorting_background_color'] !== '') {
			$woo_products_sorting_style[] = 'background-color: '.$mkd_options['woo_products_sorting_background_color'];
		}

		if(isset($mkd_options['woo_products_sorting_border_color']) && $mkd_options['woo_products_sorting_border_color'] !== '') {
			$woo_products_sorting_style[] = 'border-color: '.$mkd_options['woo_products_sorting_border_color'];
		}

		if(isset($mkd_options['woo_products_sorting_border_width']) && $mkd_options['woo_products_sorting_border_width'] !== '') {
			$woo_products_sorting_style[] = 'border-width: '.intval($mkd_options['woo_products_sorting_border_width']).'px';
		}

		if(is_array($woo_products_sorting_style) && count($woo_products_sorting_style)) { ?>
            body.archive.woocommerce-page .select2-container.orderby .select2-choice{
			<?php echo esc_attr(implode(';', $woo_products_sorting_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['woo_products_sorting_color']) && !empty($mkd_options['woo_products_sorting_color'])) { ?>
            body.archive.woocommerce-page .select2-drop{
            color: <?php echo esc_attr($mkd_options['woo_products_sorting_color']); ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['woo_products_sorting_dropdown_background_color']) && !empty($mkd_options['woo_products_sorting_dropdown_background_color'])) { ?>
            body.archive.woocommerce-page .select2-drop{
            background-color: <?php echo esc_attr($mkd_options['woo_products_sorting_dropdown_background_color']); ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['woo_products_sorting_hover_color']) && !empty($mkd_options['woo_products_sorting_hover_color'])) { ?>
            body.archive.woocommerce-page .select2-results li.select2-highlighted,
            body.archive.woocommerce-page .select2-container .select2-choice .select2-arrow:after{
            color: <?php echo esc_attr($mkd_options['woo_products_sorting_hover_color']); ?>;
            }
		<?php } ?>

		<?php
		$woo_products_sorting_result_style = array();

		if(isset($mkd_options['woo_products_sorting_result_font_family']) && $mkd_options['woo_products_sorting_result_font_family'] !== '-1') {
			$woo_products_sorting_result_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['woo_products_sorting_result_font_family']).', sans-serif';
		}

		if(isset($mkd_options['woo_products_sorting_result_font_size']) && $mkd_options['woo_products_sorting_result_font_size'] !== '') {
			$woo_products_sorting_result_style[] = 'font-size: '.intval($mkd_options['woo_products_sorting_result_font_size']).'px';
		}

		if(isset($mkd_options['woo_products_sorting_result_line_height']) && $mkd_options['woo_products_sorting_result_line_height'] !== '') {
			$woo_products_sorting_result_style[] = 'line-height: '.intval($mkd_options['woo_products_sorting_result_line_height']).'px';
		}

		if(isset($mkd_options['woo_products_sorting_result_letter_spacing']) && $mkd_options['woo_products_sorting_result_letter_spacing'] !== '') {
			$woo_products_sorting_result_style[] = 'letter-spacing: '.intval($mkd_options['woo_products_sorting_result_letter_spacing']).'px';
		}

		if(isset($mkd_options['woo_products_sorting_result_font_weight']) && $mkd_options['woo_products_sorting_result_font_weight'] !== '') {
			$woo_products_sorting_result_style[] = 'font-weight: '.intval($mkd_options['woo_products_sorting_result_font_weight']);
		}

		if(isset($mkd_options['woo_products_sorting_result_font_style']) && $mkd_options['woo_products_sorting_result_font_style'] !== '') {
			$woo_products_sorting_result_style[] = 'font-style: '.$mkd_options['woo_products_sorting_result_font_style'];
		}

		if(isset($mkd_options['woo_products_sorting_result_text_transform']) && $mkd_options['woo_products_sorting_result_text_transform'] !== '') {
			$woo_products_sorting_result_style[] = 'text-transform: '.$mkd_options['woo_products_sorting_result_text_transform'];
		}

		if(isset($mkd_options['woo_products_sorting_result_color']) && $mkd_options['woo_products_sorting_result_color'] !== '') {
			$woo_products_sorting_result_style[] = 'color: '.$mkd_options['woo_products_sorting_result_color'];
		}

		if(is_array($woo_products_sorting_result_style) && count($woo_products_sorting_result_style)) { ?>
            .woocommerce .woocommerce-result-count{
			<?php echo esc_attr(implode(';', $woo_products_sorting_result_style)); ?>
            }
		<?php } ?>

		<?php
		$woo_products_list_add_to_cart_style = array();
		$woo_products_list_add_to_cart_hover_style = array();

		if(isset($mkd_options['woo_products_list_add_to_cart_font_family']) && $mkd_options['woo_products_list_add_to_cart_font_family'] !== '-1') {
			$woo_products_list_add_to_cart_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['woo_products_list_add_to_cart_font_family']).', sans-serif';
		}

		if(isset($mkd_options['woo_products_list_add_to_cart_font_size']) && $mkd_options['woo_products_list_add_to_cart_font_size'] !== '') {
			$woo_products_list_add_to_cart_style[] = 'font-size: '.intval($mkd_options['woo_products_list_add_to_cart_font_size']).'px';
		}

		if(isset($mkd_options['woo_products_list_add_to_cart_line_height']) && $mkd_options['woo_products_list_add_to_cart_line_height'] !== '') {
			$woo_products_list_add_to_cart_style[] = 'line-height: '.intval($mkd_options['woo_products_list_add_to_cart_line_height']).'px';
		}

		if(isset($mkd_options['woo_products_list_add_to_cart_letter_spacing']) && $mkd_options['woo_products_list_add_to_cart_letter_spacing'] !== '') {
			$woo_products_list_add_to_cart_style[] = 'letter-spacing: '.intval($mkd_options['woo_products_list_add_to_cart_letter_spacing']).'px';
		}

		if(isset($mkd_options['woo_products_list_add_to_cart_font_weight']) && $mkd_options['woo_products_list_add_to_cart_font_weight'] !== '') {
			$woo_products_list_add_to_cart_style[] = 'font-weight: '.intval($mkd_options['woo_products_list_add_to_cart_font_weight']);
		}

		if(isset($mkd_options['woo_products_list_add_to_cart_font_style']) && $mkd_options['woo_products_list_add_to_cart_font_style'] !== '') {
			$woo_products_list_add_to_cart_style[] = 'font-style: '.$mkd_options['woo_products_list_add_to_cart_font_style'];
		}

		if(isset($mkd_options['woo_products_list_add_to_cart_text_transform']) && $mkd_options['woo_products_list_add_to_cart_text_transform'] !== '') {
			$woo_products_list_add_to_cart_style[] = 'text-transform: '.$mkd_options['woo_products_list_add_to_cart_text_transform'];
		}

		if(isset($mkd_options['woo_products_list_add_to_cart_color']) && !empty($mkd_options['woo_products_list_add_to_cart_color'])) {
			$woo_products_list_add_to_cart_style[] = 'color: '.$mkd_options['woo_products_list_add_to_cart_color'];
		}

		if(isset($mkd_options['woo_products_list_add_to_cart_background_color']) && !empty($mkd_options['woo_products_list_add_to_cart_background_color'])) {
			$woo_products_list_add_to_cart_style[] = 'background-color: '.$mkd_options['woo_products_list_add_to_cart_background_color'];
		}

		if(isset($mkd_options['woo_products_list_add_to_cart_border_width']) && $mkd_options['woo_products_list_add_to_cart_border_width'] !== '') {
			$woo_products_list_add_to_cart_style[] = 'border-width: '.intval($mkd_options['woo_products_list_add_to_cart_border_width']).'px';
			$woo_products_list_add_to_cart_style[] = 'border-style:solid';
		}

		if(isset($mkd_options['woo_products_list_add_to_cart_border_color']) && !empty($mkd_options['woo_products_list_add_to_cart_border_color'])) {
			$woo_products_list_add_to_cart_style[] = 'border-color: '.$mkd_options['woo_products_list_add_to_cart_border_color'];
		}

		if(isset($mkd_options['woo_products_list_add_to_cart_border_radius']) && $mkd_options['woo_products_list_add_to_cart_border_radius'] !== '') {
			$woo_products_list_add_to_cart_style[] = 'border-radius: '.intval($mkd_options['woo_products_list_add_to_cart_border_radius']).'px';
		}

		if(is_array($woo_products_list_add_to_cart_style) && count($woo_products_list_add_to_cart_style)) { ?>
            .woocommerce ul.products li.product .add-to-cart-button,
            .woocommerce ul.products li.product .added_to_cart,
            .woocommerce .widget_price_filter .button,
            .woocommerce-page .widget_price_filter .button,
            .woocommerce .widget_shopping_cart_content p.buttons a.button,
            .woocommerce .button,
            .woocommerce-page .button,
            .woocommerce button.button,
            .woocommerce-page button.button,
            .woocommerce-page input[type="submit"],
            .woocommerce input[type="submit"]{
			<?php echo esc_attr(implode(';', $woo_products_list_add_to_cart_style)); ?>
            }
		<?php }

		if(isset($mkd_options['woo_products_list_add_to_cart_hover_color']) && !empty($mkd_options['woo_products_list_add_to_cart_hover_color'])) {
			$woo_products_list_add_to_cart_hover_style[] = 'color: '.$mkd_options['woo_products_list_add_to_cart_hover_color'];
		}

		if(isset($mkd_options['woo_products_list_add_to_cart_background_hover_color']) && !empty($mkd_options['woo_products_list_add_to_cart_background_hover_color'])) {
			$woo_products_list_add_to_cart_hover_style[] = 'background-color: '.$mkd_options['woo_products_list_add_to_cart_background_hover_color'];
		}

		if(isset($mkd_options['woo_products_list_add_to_cart_border_hover_color']) && !empty($mkd_options['woo_products_list_add_to_cart_border_hover_color'])) {
			$woo_products_list_add_to_cart_hover_style[] = 'border-color: '.$mkd_options['woo_products_list_add_to_cart_border_hover_color'];
		}

		if(is_array($woo_products_list_add_to_cart_hover_style) && count($woo_products_list_add_to_cart_hover_style)) { ?>
            .woocommerce ul.products li.product a.add_to_cart_button:hover,
            .woocommerce-page ul.products li.product a.add_to_cart_button:hover,
            .woocommerce ul.products li.product .added_to_cart:hover,
            .woocommerce-page ul.products li.product .added_to_cart:hover,
            .woocommerce .widget_price_filter .button:hover,
            .woocommerce-page .widget_price_filter .button:hover,
            .woocommerce .widget_shopping_cart_content p.buttons a.button:hover,
            .woocommerce .button:hover,
            .woocommerce-page .button:hover,
            .woocommerce table.cart td.actions input[type="submit"]:hover,
            .woocommerce button.button:hover,
            .woocommerce-page button.button:hover,
            .woocommerce-page input[type="submit"]:hover,
            .woocommerce input[type="submit"]:hover{
			<?php echo esc_attr(implode(';', $woo_products_list_add_to_cart_hover_style)); ?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['woo_products_price_filter_background_color']) && !empty($mkd_options['woo_products_price_filter_background_color'])) { ?>
            .woocommerce .widget_price_filter .ui-slider-horizontal .ui-slider-range,
            .woocommerce-page .widget_price_filter .ui-slider-horizontal .ui-slider-range {
            background-color: <?php echo esc_attr($mkd_options['woo_products_price_filter_background_color']); ?>;
            }
		<?php } ?>

		<?php

		if(isset($mkd_options['woo_products_price_filter_background_active_color']) && !empty($mkd_options['woo_products_price_filter_background_active_color'])) { ?>
            .woocommerce .widget_price_filter .price_slider_wrapper .ui-widget-content,
            .woocommerce-page .widget_price_filter .price_slider_wrapper .ui-widget-content {
            background-color: <?php echo esc_attr($mkd_options['woo_products_price_filter_background_active_color']); ?>;
            }
		<?php } ?>

		<?php

		if(isset($mkd_options['woo_products_price_filter_arrows_color']) && !empty($mkd_options['woo_products_price_filter_arrows_color'])) { ?>
            .woocommerce .widget_price_filter .ui-slider .ui-slider-handle,
            .woocommerce-page .widget_price_filter .ui-slider .ui-slider-handle {
            background-color: <?php echo esc_attr($mkd_options['woo_products_price_filter_arrows_color']); ?>;
            }
		<?php } ?>

		<?php
		$woo_product_single_meta_title_style = array();

		if(isset($mkd_options['woo_product_single_meta_title_font_family']) && $mkd_options['woo_product_single_meta_title_font_family'] !== '-1') {
			$woo_product_single_meta_title_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['woo_product_single_meta_title_font_family']).', sans-serif';
		}

		if(isset($mkd_options['woo_product_single_meta_title_font_size']) && $mkd_options['woo_product_single_meta_title_font_size'] !== '') {
			$woo_product_single_meta_title_style[] = 'font-size: '.intval($mkd_options['woo_product_single_meta_title_font_size']).'px';
		}

		if(isset($mkd_options['woo_product_single_meta_title_line_height']) && $mkd_options['woo_product_single_meta_title_line_height'] !== '') {
			$woo_product_single_meta_title_style[] = 'line-height: '.intval($mkd_options['woo_product_single_meta_title_line_height']).'px';
		}

		if(isset($mkd_options['woo_product_single_meta_title_letter_spacing']) && $mkd_options['woo_product_single_meta_title_letter_spacing'] !== '') {
			$woo_product_single_meta_title_style[] = 'letter-spacing: '.intval($mkd_options['woo_product_single_meta_title_letter_spacing']).'px';
		}

		if(isset($mkd_options['woo_product_single_meta_title_font_weight']) && $mkd_options['woo_product_single_meta_title_font_weight'] !== '') {
			$woo_product_single_meta_title_style[] = 'font-weight: '.intval($mkd_options['woo_product_single_meta_title_font_weight']);
		}

		if(isset($mkd_options['woo_product_single_meta_title_font_style']) && $mkd_options['woo_product_single_meta_title_font_style'] !== '') {
			$woo_product_single_meta_title_style[] = 'font-style: '.$mkd_options['woo_product_single_meta_title_font_style'];
		}

		if(isset($mkd_options['woo_product_single_meta_title_text_transform']) && $mkd_options['woo_product_single_meta_title_text_transform'] !== '') {
			$woo_product_single_meta_title_style[] = 'text-transform: '.$mkd_options['woo_product_single_meta_title_text_transform'];
		}

		if(isset($mkd_options['woo_product_single_meta_title_color']) && $mkd_options['woo_product_single_meta_title_color'] !== '') {
			$woo_product_single_meta_title_style[] = 'color: '.$mkd_options['woo_product_single_meta_title_color'];
		}

		if(is_array($woo_product_single_meta_title_style) && count($woo_product_single_meta_title_style)) { ?>
            .woocommerce div.product div.product_meta > span,
            .woocommerce div.product div.product_meta > .social_share_list_holder > span{
			<?php echo esc_attr(implode(';', $woo_product_single_meta_title_style)); ?>
            }
		<?php } ?>

		<?php
		$woo_product_single_meta_info_style = array();

		if(isset($mkd_options['woo_product_single_meta_info_font_family']) && $mkd_options['woo_product_single_meta_info_font_family'] !== '-1') {
			$woo_product_single_meta_info_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['woo_product_single_meta_info_font_family']).', sans-serif';
		}

		if(isset($mkd_options['woo_product_single_meta_info_font_size']) && $mkd_options['woo_product_single_meta_info_font_size'] !== '') {
			$woo_product_single_meta_info_style[] = 'font-size: '.intval($mkd_options['woo_product_single_meta_info_font_size']).'px';
		}

		if(isset($mkd_options['woo_product_single_meta_info_line_height']) && $mkd_options['woo_product_single_meta_info_line_height'] !== '') {
			$woo_product_single_meta_info_style[] = 'line-height: '.intval($mkd_options['woo_product_single_meta_info_line_height']).'px';
		}

		if(isset($mkd_options['woo_product_single_meta_info_letter_spacing']) && $mkd_options['woo_product_single_meta_info_letter_spacing'] !== '') {
			$woo_product_single_meta_info_style[] = 'letter-spacing: '.intval($mkd_options['woo_product_single_meta_info_letter_spacing']).'px';
		}

		if(isset($mkd_options['woo_product_single_meta_info_font_weight']) && $mkd_options['woo_product_single_meta_info_font_weight'] !== '') {
			$woo_product_single_meta_info_style[] = 'font-weight: '.intval($mkd_options['woo_product_single_meta_info_font_weight']);
		}

		if(isset($mkd_options['woo_product_single_meta_info_font_style']) && $mkd_options['woo_product_single_meta_info_font_style'] !== '') {
			$woo_product_single_meta_info_style[] = 'font-style: '.$mkd_options['woo_product_single_meta_info_font_style'];
		}

		if(isset($mkd_options['woo_product_single_meta_info_text_transform']) && $mkd_options['woo_product_single_meta_info_text_transform'] !== '') {
			$woo_product_single_meta_info_style[] = 'text-transform: '.$mkd_options['woo_product_single_meta_info_text_transform'];
		}

		if(isset($mkd_options['woo_product_single_meta_info_color']) && $mkd_options['woo_product_single_meta_info_color'] !== '') {
			$woo_product_single_meta_info_style[] = 'color: '.$mkd_options['woo_product_single_meta_info_color'];
		}

		if(is_array($woo_product_single_meta_info_style) && count($woo_product_single_meta_info_style)) { ?>
            .woocommerce div.product div.product_meta > span span,
            .woocommerce div.product div.product_meta > span a{
			<?php echo esc_attr(implode(';', $woo_product_single_meta_info_style)); ?>
            }
		<?php } ?>


		<?php
		$woo_product_single_title_style = array();

		if(isset($mkd_options['woo_product_single_title_font_family']) && $mkd_options['woo_product_single_title_font_family'] !== '-1') {
			$woo_product_single_title_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['woo_product_single_title_font_family']).', sans-serif';
		}

		if(isset($mkd_options['woo_product_single_title_font_size']) && $mkd_options['woo_product_single_title_font_size'] !== '') {
			$woo_product_single_title_style[] = 'font-size: '.intval($mkd_options['woo_product_single_title_font_size']).'px';
		}

		if(isset($mkd_options['woo_product_single_title_line_height']) && $mkd_options['woo_product_single_title_line_height'] !== '') {
			$woo_product_single_title_style[] = 'line-height: '.intval($mkd_options['woo_product_single_title_line_height']).'px';
		}

		if(isset($mkd_options['woo_product_single_title_letter_spacing']) && $mkd_options['woo_product_single_title_letter_spacing'] !== '') {
			$woo_product_single_title_style[] = 'letter-spacing: '.intval($mkd_options['woo_product_single_title_letter_spacing']).'px';
		}

		if(isset($mkd_options['woo_product_single_title_font_weight']) && $mkd_options['woo_product_single_title_font_weight'] !== '') {
			$woo_product_single_title_style[] = 'font-weight: '.intval($mkd_options['woo_product_single_title_font_weight']);
		}

		if(isset($mkd_options['woo_product_single_title_font_style']) && $mkd_options['woo_product_single_title_font_style'] !== '') {
			$woo_product_single_title_style[] = 'font-style: '.$mkd_options['woo_product_single_title_font_style'];
		}

		if(isset($mkd_options['woo_product_single_title_text_transform']) && $mkd_options['woo_product_single_title_text_transform'] !== '') {
			$woo_product_single_title_style[] = 'text-transform: '.$mkd_options['woo_product_single_title_text_transform'];
		}

		if(isset($mkd_options['woo_product_single_title_color']) && $mkd_options['woo_product_single_title_color'] !== '') {
			$woo_product_single_title_style[] = 'color: '.$mkd_options['woo_product_single_title_color'];
		}

		if(is_array($woo_product_single_title_style) && count($woo_product_single_title_style)) { ?>
            .woocommerce .product h2.product_title{
			<?php echo esc_attr(implode(';', $woo_product_single_title_style)); ?>
            }
		<?php } ?>

		<?php if(isset($mkd_options['woo_product_single_title_hover_color']) && !empty($mkd_options['woo_product_single_title_hover_color'])) { ?>
            .woocommerce .product h2.product_title:hover{
            color: <?php echo esc_attr($mkd_options['woo_product_single_title_hover_color']); ?>;
            }
		<?php } ?>

		<?php
		$woo_products_single_add_to_cart_style = array();
		$woo_products_single_add_to_cart_hover_style = array();

		if(isset($mkd_options['woo_products_single_add_to_cart_font_family']) && $mkd_options['woo_products_single_add_to_cart_font_family'] !== '-1') {
			$woo_products_single_add_to_cart_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['woo_products_single_add_to_cart_font_family']).', sans-serif';
		}

		if(isset($mkd_options['woo_products_single_add_to_cart_font_size']) && $mkd_options['woo_products_single_add_to_cart_font_size'] !== '') {
			$woo_products_single_add_to_cart_style[] = 'font-size: '.intval($mkd_options['woo_products_single_add_to_cart_font_size']).'px';
		}

		if(isset($mkd_options['woo_products_single_add_to_cart_line_height']) && $mkd_options['woo_products_single_add_to_cart_line_height'] !== '') {
			$woo_products_single_add_to_cart_style[] = 'line-height: '.intval($mkd_options['woo_products_single_add_to_cart_line_height']).'px';
		}

		if(isset($mkd_options['woo_products_single_add_to_cart_letter_spacing']) && $mkd_options['woo_products_single_add_to_cart_letter_spacing'] !== '') {
			$woo_products_single_add_to_cart_style[] = 'letter-spacing: '.intval($mkd_options['woo_products_single_add_to_cart_letter_spacing']).'px';
		}

		if(isset($mkd_options['woo_products_single_add_to_cart_font_weight']) && $mkd_options['woo_products_single_add_to_cart_font_weight'] !== '') {
			$woo_products_single_add_to_cart_style[] = 'font-weight: '.intval($mkd_options['woo_products_single_add_to_cart_font_weight']);
		}

		if(isset($mkd_options['woo_products_single_add_to_cart_font_style']) && $mkd_options['woo_products_single_add_to_cart_font_style'] !== '') {
			$woo_products_single_add_to_cart_style[] = 'font-style: '.$mkd_options['woo_products_single_add_to_cart_font_style'];
		}

		if(isset($mkd_options['woo_products_single_add_to_cart_text_transform']) && $mkd_options['woo_products_single_add_to_cart_text_transform'] !== '') {
			$woo_products_single_add_to_cart_style[] = 'text-transform: '.$mkd_options['woo_products_single_add_to_cart_text_transform'];
		}

		if(isset($mkd_options['woo_products_single_add_to_cart_color']) && !empty($mkd_options['woo_products_single_add_to_cart_color'])) {
			$woo_products_single_add_to_cart_style[] = 'color: '.$mkd_options['woo_products_single_add_to_cart_color'];
		}

		if(isset($mkd_options['woo_products_single_add_to_cart_background_color']) && !empty($mkd_options['woo_products_single_add_to_cart_background_color'])) {
			$woo_products_single_add_to_cart_style[] = 'background-color: '.$mkd_options['woo_products_single_add_to_cart_background_color'];
		}

		if(isset($mkd_options['woo_products_single_add_to_cart_border_width']) && $mkd_options['woo_products_single_add_to_cart_border_width'] !== '') {
			$woo_products_single_add_to_cart_style[] = 'border-width: '.intval($mkd_options['woo_products_single_add_to_cart_border_width']).'px';
			$woo_products_single_add_to_cart_style[] = 'border-style:solid';
		}

		if(isset($mkd_options['woo_products_single_add_to_cart_border_color']) && !empty($mkd_options['woo_products_single_add_to_cart_border_color'])) {
			$woo_products_single_add_to_cart_style[] = 'border-color: '.$mkd_options['woo_products_single_add_to_cart_border_color'];
		}

		if(isset($mkd_options['woo_products_single_add_to_cart_border_radius']) && $mkd_options['woo_products_single_add_to_cart_border_radius'] !== '') {
			$woo_products_single_add_to_cart_style[] = 'border-radius: '.intval($mkd_options['woo_products_single_add_to_cart_border_radius']).'px';
		}

		if(is_array($woo_products_single_add_to_cart_style) && count($woo_products_single_add_to_cart_style)) { ?>
            .woocommerce.single-product button.single_add_to_cart_button{
			<?php echo esc_attr(implode(';', $woo_products_single_add_to_cart_style)); ?>
            }
		<?php }

		if(isset($mkd_options['woo_products_single_add_to_cart_hover_color']) && !empty($mkd_options['woo_products_single_add_to_cart_hover_color'])) {
			$woo_products_single_add_to_cart_hover_style[] = 'color: '.$mkd_options['woo_products_single_add_to_cart_hover_color'];
		}

		if(isset($mkd_options['woo_products_single_add_to_cart_background_hover_color']) && !empty($mkd_options['woo_products_single_add_to_cart_background_hover_color'])) {
			$woo_products_single_add_to_cart_hover_style[] = 'background-color: '.$mkd_options['woo_products_single_add_to_cart_background_hover_color'];
		}

		if(isset($mkd_options['woo_products_single_add_to_cart_border_hover_color']) && !empty($mkd_options['woo_products_single_add_to_cart_border_hover_color'])) {
			$woo_products_single_add_to_cart_hover_style[] = 'border-color: '.$mkd_options['woo_products_single_add_to_cart_border_hover_color'];
		}

		if(is_array($woo_products_single_add_to_cart_hover_style) && count($woo_products_single_add_to_cart_hover_style)) { ?>
            .woocommerce.single-product button.single_add_to_cart_button:hover{
			<?php echo esc_attr(implode(';', $woo_products_single_add_to_cart_hover_style)); ?>
            }
		<?php } ?>

		<?php
		$woo_product_single_price_style = array();

		if(isset($mkd_options['woo_product_single_price_font_family']) && $mkd_options['woo_product_single_price_font_family'] !== '-1') {
			$woo_product_single_price_style[] = 'font-family: '.esc_attr(str_replace('+', ' ', $mkd_options['woo_product_single_price_font_family'])).', sans-serif';
		}

		if(isset($mkd_options['woo_product_single_price_font_size']) && $mkd_options['woo_product_single_price_font_size'] !== '') {
			$woo_product_single_price_style[] = 'font-size: '.esc_attr($mkd_options['woo_product_single_price_font_size']).'px';
		}

		if(isset($mkd_options['woo_product_single_price_line_height']) && $mkd_options['woo_product_single_price_line_height'] !== '') {
			$woo_product_single_price_style[] = 'line-height: '.esc_attr($mkd_options['woo_product_single_price_line_height']).'px';
		}

		if(isset($mkd_options['woo_product_single_price_letter_spacing']) && $mkd_options['woo_product_single_price_letter_spacing'] !== '') {
			$woo_product_single_price_style[] = 'letter-spacing: '.esc_attr($mkd_options['woo_product_single_price_letter_spacing']).'px';
		}

		if(isset($mkd_options['woo_product_single_price_font_weight']) && $mkd_options['woo_product_single_price_font_weight'] !== '') {
			$woo_product_single_price_style[] = 'font-weight: '.esc_attr($mkd_options['woo_product_single_price_font_weight']);
		}

		if(isset($mkd_options['woo_product_single_price_font_style']) && $mkd_options['woo_product_single_price_font_style'] !== '') {
			$woo_product_single_price_style[] = 'font-style: '.esc_attr($mkd_options['woo_product_single_price_font_style']);
		}

		if(isset($mkd_options['woo_product_single_price_text_transform']) && $mkd_options['woo_product_single_price_text_transform'] !== '') {
			$woo_product_single_price_style[] = 'text-transform: '.esc_attr($mkd_options['woo_product_single_price_text_transform']);
		}

		if(isset($mkd_options['woo_product_single_price_color']) && $mkd_options['woo_product_single_price_color'] !== '') {
			$woo_product_single_price_style[] = 'color: '.esc_attr($mkd_options['woo_product_single_price_color']);
		}

		if(is_array($woo_product_single_price_style) && count($woo_product_single_price_style)) { ?>
            .woocommerce div.product .summary p.price del span.amount,
            .woocommerce div.product .summary p.price ins span.amount{
			<?php echo esc_attr(implode(';', $woo_product_single_price_style)); ?>
            }
		<?php }

		if(isset($mkd_options['woo_product_single_price_old_color']) && !empty($mkd_options['woo_product_single_price_old_color'])) { ?>
            .woocommerce div.product .summary p.price del,
            .woocommerce div.product .summary p.price del span.amount{
            color: <?php echo esc_attr($mkd_options['woo_product_single_price_old_color']); ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['woo_product_single_tabs_color']) && !empty($mkd_options['woo_product_single_tabs_color'])) { ?>
            .woocommerce .mkd_accordion_holder .ui-accordion-header.title-holder{
            background-color:  <?php echo esc_attr($mkd_options['woo_product_single_tabs_color']); ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['woo_product_single_tabs_hover_color']) && !empty($mkd_options['woo_product_single_tabs_hover_color'])) { ?>
            .woocommerce .mkd_accordion_holder .ui-accordion-header.title-holder:hover{
            background-color:  <?php echo esc_attr($mkd_options['woo_product_single_tabs_hover_color']); ?>;
            }
		<?php } ?>

		<?php if(isset($mkd_options['woo_product_single_tabs_text_hover_color']) && !empty($mkd_options['woo_product_single_tabs_text_hover_color'])) { ?>
            .woocommerce .mkd_accordion_holder .ui-accordion-header.title-holder:hover{
            color:  <?php echo esc_attr($mkd_options['woo_product_single_tabs_text_hover_color']); ?>;
            }
		<?php } ?>

		<?php
		$woo_product_single_tabs_style = array();

		if(isset($mkd_options['woo_product_single_tabs_font_family']) && $mkd_options['woo_product_single_tabs_font_family'] !== '-1') {
			$woo_product_single_tabs_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['woo_product_single_tabs_font_family']).', sans-serif';
		}

		if(isset($mkd_options['woo_product_single_tabs_font_size']) && $mkd_options['woo_product_single_tabs_font_size'] !== '') {
			$woo_product_single_tabs_style[] = 'font-size: '.intval($mkd_options['woo_product_single_tabs_font_size']).'px';
		}

		if(isset($mkd_options['woo_product_single_tabs_line_height']) && $mkd_options['woo_product_single_tabs_line_height'] !== '') {
			$woo_product_single_tabs_style[] = 'line-height: '.intval($mkd_options['woo_product_single_tabs_line_height']).'px';
		}

		if(isset($mkd_options['woo_product_single_tabs_letter_spacing']) && $mkd_options['woo_product_single_tabs_letter_spacing'] !== '') {
			$woo_product_single_tabs_style[] = 'letter-spacing: '.intval($mkd_options['woo_product_single_tabs_letter_spacing']).'px';
		}

		if(isset($mkd_options['woo_product_single_tabs_font_weight']) && $mkd_options['woo_product_single_tabs_font_weight'] !== '') {
			$woo_product_single_tabs_style[] = 'font-weight: '.intval($mkd_options['woo_product_single_tabs_font_weight']);
		}

		if(isset($mkd_options['woo_product_single_tabs_font_style']) && $mkd_options['woo_product_single_tabs_font_style'] !== '') {
			$woo_product_single_tabs_style[] = 'font-style: '.$mkd_options['woo_product_single_tabs_font_style'];
		}

		if(isset($mkd_options['woo_product_single_tabs_text_transform']) && $mkd_options['woo_product_single_tabs_text_transform'] !== '') {
			$woo_product_single_tabs_style[] = 'text-transform: '.$mkd_options['woo_product_single_tabs_text_transform'];
		}

		if(isset($mkd_options['woo_product_single_tabs_text_color']) && $mkd_options['woo_product_single_tabs_text_color'] !== '') {
			$woo_product_single_tabs_style[] = 'color: '.$mkd_options['woo_product_single_tabs_text_color'];
		}

		if(is_array($woo_product_single_tabs_style) && count($woo_product_single_tabs_style)) { ?>
            .woocommerce .mkd_accordion_holder .ui-accordion-header.title-holder{
			<?php echo esc_attr(implode(';', $woo_product_single_tabs_style)); ?>
            }
		<?php } ?>


		<?php
		$woo_product_single_related_style = array();

		if(isset($mkd_options['woo_product_single_related_font_family']) && $mkd_options['woo_product_single_related_font_family'] !== '-1') {
			$woo_product_single_related_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['woo_product_single_related_font_family']).', sans-serif';
		}

		if(isset($mkd_options['woo_product_single_related_font_size']) && $mkd_options['woo_product_single_related_font_size'] !== '') {
			$woo_product_single_related_style[] = 'font-size: '.intval($mkd_options['woo_product_single_related_font_size']).'px';
		}

		if(isset($mkd_options['woo_product_single_related_line_height']) && $mkd_options['woo_product_single_related_line_height'] !== '') {
			$woo_product_single_related_style[] = 'line-height: '.intval($mkd_options['woo_product_single_related_line_height']).'px';
		}

		if(isset($mkd_options['woo_product_single_related_letter_spacing']) && $mkd_options['woo_product_single_related_letter_spacing'] !== '') {
			$woo_product_single_related_style[] = 'letter-spacing: '.intval($mkd_options['woo_product_single_related_letter_spacing']).'px';
		}

		if(isset($mkd_options['woo_product_single_related_font_weight']) && $mkd_options['woo_product_single_related_font_weight'] !== '') {
			$woo_product_single_related_style[] = 'font-weight: '.intval($mkd_options['woo_product_single_related_font_weight']);
		}

		if(isset($mkd_options['woo_product_single_related_font_style']) && $mkd_options['woo_product_single_related_font_style'] !== '') {
			$woo_product_single_related_style[] = 'font-style: '.$mkd_options['woo_product_single_related_font_style'];
		}

		if(isset($mkd_options['woo_product_single_related_text_transform']) && $mkd_options['woo_product_single_related_text_transform'] !== '') {
			$woo_product_single_related_style[] = 'text-transform: '.$mkd_options['woo_product_single_related_text_transform'];
		}

		if(isset($mkd_options['woo_product_single_related_color']) && $mkd_options['woo_product_single_related_color'] !== '') {
			$woo_product_single_related_style[] = 'color: '.$mkd_options['woo_product_single_related_color'];
		}

		if(is_array($woo_product_single_related_style) && count($woo_product_single_related_style)) { ?>
            .woocommerce div.product div.upsells .related-products-title,
            .woocommerce div.product div.related .related-products-title{
			<?php echo esc_attr(implode(';', $woo_product_single_related_style)); ?>
            }
		<?php } ?>
		<?php
		$buddy_press_main_box_style= array();
		$buddy_press_main_box_item_style= array();

		if(isset($mkd_options['buddy_press_main_box_border_width']) && $mkd_options['buddy_press_main_box_border_width'] !== '') {
			$buddy_press_main_box_style[] = 'border-width: '.intval($mkd_options['buddy_press_main_box_border_width']).'px';
			$buddy_press_main_box_item_style[] = 'border-width: '.intval($mkd_options['buddy_press_main_box_border_width']).'px';
		}

		if(isset($mkd_options['buddy_press_main_box_border_color']) && $mkd_options['buddy_press_main_box_border_color'] !== '') {
			$buddy_press_main_box_style[] = 'border-color: '.$mkd_options['buddy_press_main_box_border_color'];
			$buddy_press_main_box_item_style[] = 'border-color: '.$mkd_options['buddy_press_main_box_border_color'];
		}

		if(isset($mkd_options['buddy_press_main_box_border_radius']) && $mkd_options['buddy_press_main_box_border_radius'] !== '') {
			$buddy_press_main_box_style[] = 'border-radius: '.intval($mkd_options['buddy_press_main_box_border_radius']).'px';
			$buddy_press_main_box_item_style[] = 'border-radius: '.intval($mkd_options['buddy_press_main_box_border_radius']).'px';?>
            #buddypress.buddypress-list-groups ul.item-list li .buddypress-title-item-holder{
            border-radius: <?php echo esc_attr($mkd_options['buddy_press_main_box_border_radius']).'px' ;?>
            }
			<?php
		}
		if(is_array($buddy_press_main_box_style) && count($buddy_press_main_box_style)) { ?>
            #buddypress div#item-header,
            #buddypress div#item-body,
            .buddypress.activity #buddypress form#whats-new-form,
            .buddypress.activity #buddypress .item-list-tabs.activity-type-tabs{
			<?php echo esc_attr(implode(';', $buddy_press_main_box_style)); ?>
            }
		<?php }

		if(is_array($buddy_press_main_box_item_style) && count($buddy_press_main_box_item_style)) { ?>
            #buddypress ul.item-list li{
			<?php echo esc_attr(implode(';', $buddy_press_main_box_item_style)); ?>
            }
		<?php }
		?>
		<?php
		$buddy_press_button_style = array();
		$buddy_press_button_hover_style = array();

		if(isset($mkd_options['buddy_press_button_title_google_fonts']) && $mkd_options['buddy_press_button_title_google_fonts'] !== '-1') {
			$buddy_press_button_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['buddy_press_button_title_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['buddy_press_button_title_fontsize']) && $mkd_options['buddy_press_button_title_fontsize'] !== '') {
			$buddy_press_button_style[] = 'font-size: '.intval($mkd_options['buddy_press_button_title_fontsize']).'px';
		}

		if(isset($mkd_options['buddy_press_button_title_lineheight']) && $mkd_options['buddy_press_button_title_lineheight'] !== '') {
			$buddy_press_button_style[] = 'line-height: '.intval($mkd_options['buddy_press_button_title_lineheight']).'px';
			$buddy_press_button_style[] = 'height: '.intval($mkd_options['buddy_press_button_title_lineheight']).'px';
		}

		if(isset($mkd_options['buddy_press_button_title_letter_spacing']) && $mkd_options['buddy_press_button_title_letter_spacing'] !== '') {
			$buddy_press_button_style[] = 'letter-spacing: '.intval($mkd_options['buddy_press_button_title_letter_spacing']).'px';
		}

		if(isset($mkd_options['buddy_press_button_title_fontweight']) && $mkd_options['buddy_press_button_title_fontweight'] !== '') {
			$buddy_press_button_style[] = 'font-weight: '.intval($mkd_options['buddy_press_button_title_fontweight']);
		}

		if(isset($mkd_options['buddy_press_button_title_fontstyle']) && $mkd_options['buddy_press_button_title_fontstyle'] !== '') {
			$buddy_press_button_style[] = 'font-style: '.$mkd_options['buddy_press_button_title_fontstyle'];
		}

		if(isset($mkd_options['buddy_press_button_title_texttransform']) && $mkd_options['buddy_press_button_title_texttransform'] !== '') {
			$buddy_press_button_style[] = 'text-transform: '.$mkd_options['buddy_press_button_title_texttransform'];
		}

		if(isset($mkd_options['buddy_press_button_title_color']) && $mkd_options['buddy_press_button_title_color'] !== '') {
			$buddy_press_button_style[] = 'color: '.$mkd_options['buddy_press_button_title_color'];?>
            #buddypress input[type=button],
            #buddypress input[type=reset],
            #buddypress input[type=submit]{
            color : <?php echo esc_attr($mkd_options['buddy_press_button_title_color']); ?> !important;
            }
			<?php
		}

		if(isset($mkd_options['buddy_press_button_backgroundcolor']) && $mkd_options['buddy_press_button_backgroundcolor'] !== '') {
			$buddy_press_button_style[] = 'background-color: '.$mkd_options['buddy_press_button_backgroundcolor'];?>
            #buddypress input[type=button],
            #buddypress input[type=reset],
            #buddypress input[type=submit]{
            background-color : <?php echo esc_attr($mkd_options['buddy_press_button_backgroundcolor']); ?> !important;
            }
			<?php
		}

		if(isset($mkd_options['buddy_press_button_border_color']) && $mkd_options['buddy_press_button_border_color'] !== '') {
			$buddy_press_button_style[] = 'border-color: '.$mkd_options['buddy_press_button_border_color'];?>
            #buddypress input[type=button],
            #buddypress input[type=reset],
            #buddypress input[type=submit]{
            border-color : <?php echo esc_attr($mkd_options['buddy_press_button_border_color']); ?> !important;
            }
			<?php
		}

		if(isset($mkd_options['buddy_press_button_border_width']) && $mkd_options['buddy_press_button_border_width'] !== '') {
			$buddy_press_button_style[] = 'border-width: '.intval($mkd_options['buddy_press_button_border_width']).'px';
		}

		if(isset($mkd_options['buddy_press_button_border_radius']) && $mkd_options['buddy_press_button_border_radius'] !== '') {
			$buddy_press_button_style[] = 'border-radius: '.intval($mkd_options['buddy_press_button_border_radius']).'px';
		}

		if(isset($mkd_options['buddy_press_button_padding']) && $mkd_options['buddy_press_button_padding'] !== '') {
			$buddy_press_button_style[] = 'padding-left: '.intval($mkd_options['buddy_press_button_padding']).'px';
			$buddy_press_button_style[] = 'padding-right: '.intval($mkd_options['buddy_press_button_padding']).'px';
		}

		if(is_array($buddy_press_button_style) && count($buddy_press_button_style)) { ?>
            #buddypress .comment-reply-link,
            #buddypress a.button,
            #buddypress button,
            #buddypress #item-body div.generic-button a,
            #buddypress .members.dir-list div.generic-button a,
            #buddypress ul.button-nav li a,
            #buddypress a.bp-title-button,
            #buddypress div.activity-meta a,
            #buddypress .activity-meta  a.bp-primary-action span{
			<?php echo esc_attr(implode(';', $buddy_press_button_style)) ; ?>
            }
		<?php } ?>
		<?php

		if(isset($mkd_options['buddy_press_button_border_width']) && $mkd_options['buddy_press_button_border_width'] !== '') {
			$buddy_press_button_hover_style[] = 'border-width: '.intval($mkd_options['buddy_press_button_border_width']).'px';
		}

		if(isset($mkd_options['buddy_press_button_title_hovercolor']) && $mkd_options['buddy_press_button_title_hovercolor'] !== '') {
			$buddy_press_button_hover_style[] = 'color: '.$mkd_options['buddy_press_button_title_hovercolor'];?>
            #buddypress input[type=button]:hover,
            #buddypress input[type=reset]:hover,
            #buddypress input[type=submit]:hover,
            #buddypress input[type=button]:focus,
            #buddypress input[type=reset]:focus,
            #buddypress input[type=submit]:focus{
            color : <?php echo esc_attr($mkd_options['buddy_press_button_title_hovercolor']); ?> !important;
            }
			<?php
		}
		if(isset($mkd_options['buddy_press_button_backgroundcolor_hover']) && $mkd_options['buddy_press_button_backgroundcolor_hover'] !== '') {
			$buddy_press_button_hover_style[] = 'background-color: '.$mkd_options['buddy_press_button_backgroundcolor_hover'];?>
            #buddypress input[type=button]:hover,
            #buddypress input[type=reset]:hover,
            #buddypress input[type=submit]:hover,
            #buddypress input[type=button]:focus,
            #buddypress input[type=reset]:focus,
            #buddypress input[type=submit]:focus{
            background-color : <?php echo esc_attr($mkd_options['buddy_press_button_backgroundcolor_hover' ]); ?> !important;
            }
			<?php
		}

		if(isset($mkd_options['buddy_press_button_border_hover_color']) && $mkd_options['buddy_press_button_border_hover_color'] !== '') {
			$buddy_press_button_hover_style[] = 'border-color: '.$mkd_options['buddy_press_button_border_hover_color'];?>
            #buddypress input[type=button]:hover,
            #buddypress input[type=reset]:hover,
            #buddypress input[type=submit]:hover,
            #buddypress input[type=button]:focus,
            #buddypress input[type=reset]:focus,
            #buddypress input[type=submit]:focus{
            border-color : <?php echo esc_attr($mkd_options['buddy_press_button_border_hover_color']); ?>!important;
            }
			<?php
		}

		if(is_array($buddy_press_button_hover_style) && count($buddy_press_button_hover_style)) { ?>
            #buddypress .comment-reply-link:hover,
            #buddypress a.button:hover,
            #buddypress button:hover,
            #buddypress #item-body div.generic-button a:hover,
            #buddypress .members.dir-list div.generic-button a:hover,
            #buddypress ul.button-nav li a:hover,
            #buddypress a.bp-title-button:hover,
            #buddypress div.activity-meta a:hover,
            #buddypress .activity-meta  a.bp-primary-action:hover span{
			<?php echo esc_attr(implode(';', $buddy_press_button_hover_style)) ; ?>
            }
		<?php } ?>
		<?php
		$buddy_press_header_button_style = array();
		$buddy_press_header_button_hover_style = array();

		if(isset($mkd_options['buddy_press_header_button_title_google_fonts']) && $mkd_options['buddy_press_header_button_title_google_fonts'] !== '-1') {
			$buddy_press_header_button_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['buddy_press_header_button_title_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['buddy_press_header_button_title_fontsize']) && $mkd_options['buddy_press_header_button_title_fontsize'] !== '') {
			$buddy_press_header_button_style[] = 'font-size: '.intval($mkd_options['buddy_press_header_button_title_fontsize']).'px';
		}

		if(isset($mkd_options['buddy_press_header_button_title_lineheight']) && $mkd_options['buddy_press_header_button_title_lineheight'] !== '') {
			$buddy_press_header_button_style[] = 'line-height: '.intval($mkd_options['buddy_press_header_button_title_lineheight']).'px';
			$buddy_press_header_button_style[] = 'height: '.intval($mkd_options['buddy_press_header_button_title_lineheight']).'px';
		}

		if(isset($mkd_options['buddy_press_header_button_title_letter_spacing']) && $mkd_options['buddy_press_header_button_title_letter_spacing'] !== '') {
			$buddy_press_header_button_style[] = 'letter-spacing: '.intval($mkd_options['buddy_press_header_button_title_letter_spacing']).'px';
		}

		if(isset($mkd_options['buddy_press_header_button_title_fontweight']) && $mkd_options['buddy_press_header_button_title_fontweight'] !== '') {
			$buddy_press_header_button_style[] = 'font-weight: '.intval($mkd_options['buddy_press_header_button_title_fontweight']);
		}

		if(isset($mkd_options['buddy_press_header_button_title_fontstyle']) && $mkd_options['buddy_press_header_button_title_fontstyle'] !== '') {
			$buddy_press_header_button_style[] = 'font-style: '.$mkd_options['buddy_press_header_button_title_fontstyle'];
		}

		if(isset($mkd_options['buddy_press_header_button_title_texttransform']) && $mkd_options['buddy_press_header_button_title_texttransform'] !== '') {
			$buddy_press_header_button_style[] = 'text-transform: '.$mkd_options['buddy_press_header_button_title_texttransform'];
		}

		if(isset($mkd_options['buddy_press_header_button_title_color']) && $mkd_options['buddy_press_header_button_title_color'] !== '') {
			$buddy_press_header_button_style[] = 'color: '.$mkd_options['buddy_press_header_button_title_color'];
		}

		if(isset($mkd_options['buddy_press_header_button_backgroundcolor']) && $mkd_options['buddy_press_header_button_backgroundcolor'] !== '') {
			$buddy_press_header_button_style[] = 'background-color: '.$mkd_options['buddy_press_header_button_backgroundcolor'];
		}

		if(isset($mkd_options['buddy_press_header_button_border_color']) && $mkd_options['buddy_press_header_button_border_color'] !== '') {
			$buddy_press_header_button_style[] = 'border-color: '.$mkd_options['buddy_press_header_button_border_color'];
		}

		if(isset($mkd_options['buddy_press_header_button_border_width']) && $mkd_options['buddy_press_header_button_border_width'] !== '') {
			$buddy_press_header_button_style[] = 'border-width: '.intval($mkd_options['buddy_press_header_button_border_width']).'px';
		}

		if(isset($mkd_options['buddy_press_header_button_border_radius']) && $mkd_options['buddy_press_header_button_border_radius'] !== '') {
			$buddy_press_header_button_style[] = 'border-radius: '.intval($mkd_options['buddy_press_header_button_border_radius']).'px';
		}

		if(isset($mkd_options['buddy_press_header_button_padding']) && $mkd_options['buddy_press_header_button_padding'] !== '') {
			$buddy_press_header_button_style[] = 'padding-left: '.intval($mkd_options['buddy_press_header_button_padding']).'px';
			$buddy_press_header_button_style[] = 'padding-right: '.intval($mkd_options['buddy_press_header_button_padding']).'px';
		}
		if(is_array($buddy_press_header_button_style) && count($buddy_press_header_button_style)) { ?>
            #buddypress #item-header div.generic-button a{
			<?php echo esc_attr(implode(';', $buddy_press_header_button_style)); ?>
            }
		<?php }

		if(isset($mkd_options['buddy_press_header_button_title_hovercolor']) && $mkd_options['buddy_press_header_button_title_hovercolor'] !== '') {
			$buddy_press_header_button_hover_style[] = 'color: '.$mkd_options['buddy_press_header_button_title_hovercolor'];
		}

		if(isset($mkd_options['buddy_press_header_button_backgroundcolor_hover']) && $mkd_options['buddy_press_header_button_backgroundcolor_hover'] !== '') {
			$buddy_press_header_button_hover_style[] = 'background-color: '.$mkd_options['buddy_press_header_button_backgroundcolor_hover'];
		}

		if(isset($mkd_options['buddy_press_header_button_border_hover_color']) && $mkd_options['buddy_press_header_button_border_hover_color'] !== '') {
			$buddy_press_header_button_hover_style[] = 'border-color: '.$mkd_options['buddy_press_header_button_border_hover_color'];
		}

		if(is_array($buddy_press_header_button_hover_style) && count($buddy_press_header_button_hover_style)) { ?>
            #buddypress #item-header div.generic-button a:hover{
			<?php echo esc_attr(implode(';', $buddy_press_header_button_hover_style)); ?>
            }
		<?php } ?>

		<?php
		$buddy_press_first_level_menu_style = array();
		$buddy_press_first_level_menu_hover_style = array();
		$buddy_press_first_level_menu_active_style = array();
		$buddy_press_first_level_menu_active_hover_style = array();

		if(isset($mkd_options['buddy_press_first_level_menu_title_google_fonts']) && $mkd_options['buddy_press_first_level_menu_title_google_fonts'] !== '-1') {
			$buddy_press_first_level_menu_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['buddy_press_first_level_menu_title_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['buddy_press_first_level_menu_title_fontsize']) && $mkd_options['buddy_press_first_level_menu_title_fontsize'] !== '') {
			$buddy_press_first_level_menu_style[] = 'font-size: '.intval($mkd_options['buddy_press_first_level_menu_title_fontsize']).'px';
		}

		if(isset($mkd_options['buddy_press_first_level_menu_title_lineheight']) && $mkd_options['buddy_press_first_level_menu_title_lineheight'] !== '') {
			$buddy_press_first_level_menu_style[] = 'line-height: '.intval($mkd_options['buddy_press_first_level_menu_title_lineheight']).'px';
			$buddy_press_first_level_menu_style[] = 'height: '.intval($mkd_options['buddy_press_first_level_menu_title_lineheight']).'px';
		}

		if(isset($mkd_options['buddy_press_first_level_menu_title_letter_spacing']) && $mkd_options['buddy_press_first_level_menu_title_letter_spacing'] !== '') {
			$buddy_press_first_level_menu_style[] = 'letter-spacing: '.intval($mkd_options['buddy_press_first_level_menu_title_letter_spacing']).'px';
		}

		if(isset($mkd_options['buddy_press_first_level_menu_title_fontweight']) && $mkd_options['buddy_press_first_level_menu_title_fontweight'] !== '') {
			$buddy_press_first_level_menu_style[] = 'font-weight: '.intval($mkd_options['buddy_press_first_level_menu_title_fontweight']);
		}

		if(isset($mkd_options['buddy_press_first_level_menu_title_fontstyle']) && $mkd_options['buddy_press_first_level_menu_title_fontstyle'] !== '') {
			$buddy_press_first_level_menu_style[] = 'font-style: '.$mkd_options['buddy_press_first_level_menu_title_fontstyle'];
		}

		if(isset($mkd_options['buddy_press_first_level_menu_title_texttransform']) && $mkd_options['buddy_press_first_level_menu_title_texttransform'] !== '') {
			$buddy_press_first_level_menu_style[] = 'text-transform: '.$mkd_options['buddy_press_first_level_menu_title_texttransform'];
		}

		if(isset($mkd_options['buddy_press_first_level_menu_title_color']) && $mkd_options['buddy_press_first_level_menu_title_color'] !== '') {
			$buddy_press_first_level_menu_style[] = 'color: '.$mkd_options['buddy_press_first_level_menu_title_color'];
		}

		if(isset($mkd_options['buddy_press_first_level_menu_backgroundcolor']) && $mkd_options['buddy_press_first_level_menu_backgroundcolor'] !== '') {
			$buddy_press_first_level_menu_style[] = 'background-color: '.$mkd_options['buddy_press_first_level_menu_backgroundcolor'];
		}

		if(isset($mkd_options['buddy_press_first_level_menu_border_color']) && $mkd_options['buddy_press_first_level_menu_border_color'] !== '') {
			$buddy_press_first_level_menu_style[] = 'border-color: '.$mkd_options['buddy_press_first_level_menu_border_color'];?>
            .mkd_tabs.buddypress-tabs .tabs-nav li:last-child a{
            border-right-color: <?php echo esc_attr($mkd_options['buddy_press_first_level_menu_border_color']) ;?>
            }
			<?php
		}

		if(isset($mkd_options['buddy_press_first_level_menu_border_width']) && $mkd_options['buddy_press_first_level_menu_border_width'] !== '') {
			$buddy_press_first_level_menu_style[] = 'border-width: '.intval($mkd_options['buddy_press_first_level_menu_border_width']).'px';?>
            #buddypress div#item-nav div.item-list-tabs ul li:not(:last-child) a:after,
            #buddypress div.item-list-tabs.activity-type-tabs ul li:not(:last-child) a:after,
            .mkd_tabs.buddypress-tabs .tabs-nav li:not(:last-child) a:after{
            width:<?php echo esc_attr($mkd_options['buddy_press_first_level_menu_border_width']).'px' ;?>
            }
            .mkd_tabs.buddypress-tabs .tabs-nav li:last-child a{
            border-right-width: <?php echo esc_attr($mkd_options['buddy_press_first_level_menu_border_width']).'px' ;?>
            }
			<?php
		}

		if(isset($mkd_options['buddy_press_first_level_menu_border_radius']) && $mkd_options['buddy_press_first_level_menu_border_radius'] !== '') {
			$buddy_press_first_level_menu_style[] = 'border-radius: '.intval($mkd_options['buddy_press_first_level_menu_border_radius']).'px';?>
            #buddypress div#item-nav div.item-list-tabs ul li:not(:last-child) a:after,
            #buddypress div.item-list-tabs.activity-type-tabs ul li:not(:last-child) a:after,
            .mkd_tabs.buddypress-tabs .tabs-nav li:not(:last-child) a:after{
            display:none;
            }
			<?php
		}

		if(isset($mkd_options['buddy_press_first_level_menu_padding']) && $mkd_options['buddy_press_first_level_menu_padding'] !== '') {
			$buddy_press_first_level_menu_style[] = 'padding-left: '.intval($mkd_options['buddy_press_first_level_menu_padding']).'px';
			$buddy_press_first_level_menu_style[] = 'padding-right: '.intval($mkd_options['buddy_press_first_level_menu_padding']).'px';
		}

		if(is_array($buddy_press_first_level_menu_style) && count($buddy_press_first_level_menu_style)) { ?>
            #buddypress div#item-nav div.item-list-tabs ul li a,
            .buddypress.activity #buddypress .item-list-tabs.activity-type-tabs a,
            .buddypress.activity #buddypress .item-list-tabs.activity-type-tabs li a,
            #buddypress #item-nav div.item-list-tabs ul li:last-child a,
            .buddypress.activity #buddypress .item-list-tabs.activity-type-tabs:last-child a,
            body.members #buddypress form div.item-list-tabs ul li a:not(.select2-choice),
            body.groups #buddypress form div.item-list-tabs ul li a:not(.select2-choice),
            .mkd_tabs.buddypress-tabs .tabs-nav li a{
			<?php echo esc_attr(implode(';', $buddy_press_first_level_menu_style)); ?>
            }
		<?php } ?>
		<?php

		if(isset($mkd_options['buddy_press_first_level_menu_title_hovercolor']) && $mkd_options['buddy_press_first_level_menu_title_hovercolor'] !== '') {
			$buddy_press_first_level_menu_hover_style[] = 'color: '.$mkd_options['buddy_press_first_level_menu_title_hovercolor'];
		}

		if(isset($mkd_options['buddy_press_first_level_menu_backgroundcolor_hover']) && $mkd_options['buddy_press_first_level_menu_backgroundcolor_hover'] !== '') {
			$buddy_press_first_level_menu_hover_style[] = 'background-color: '.$mkd_options['buddy_press_first_level_menu_backgroundcolor_hover'];
		}

		if(isset($mkd_options['buddy_press_first_level_menu_border_hover_color']) && $mkd_options['buddy_press_first_level_menu_border_hover_color'] !== '') {
			$buddy_press_first_level_menu_hover_style[] = 'border-color: '.$mkd_options['buddy_press_first_level_menu_border_hover_color'];?>
            #buddypress div#item-nav div.item-list-tabs ul li:not(:last-child) a:hover:after,
            #buddypress div.item-list-tabs.activity-type-tabs ul li:not(:last-child) a:hover:after,
            .mkd_tabs.buddypress-tabs .tabs-nav li:not(:last-child) a:hover:after{
            background-color:<?php echo esc_attr($mkd_options['buddy_press_first_level_menu_border_hover_color']) ; ?>
            }
			<?php
		}

		if(is_array($buddy_press_first_level_menu_hover_style) && count($buddy_press_first_level_menu_hover_style)) { ?>
            #buddypress div#item-nav div.item-list-tabs ul li a:hover,
            .buddypress.activity #buddypress .item-list-tabs.activity-type-tabs a:hover,
            .buddypress.activity #buddypress .item-list-tabs.activity-type-tabs li a:hover,
            body.members #buddypress form div.item-list-tabs ul li a:not(.select2-choice):hover,
            body.groups #buddypress form div.item-list-tabs ul li a:not(.select2-choice):hover,
            .mkd_tabs.buddypress-tabs .tabs-nav li a:hover{
			<?php echo esc_attr(implode(';', $buddy_press_first_level_menu_hover_style)); ?>
            }
		<?php } ?>

		<?php

		if(isset($mkd_options['buddy_press_first_level_menu_active_title_color']) && $mkd_options['buddy_press_first_level_menu_active_title_color'] !== '') {
			$buddy_press_first_level_menu_active_style[] = 'color: '.$mkd_options['buddy_press_first_level_menu_active_title_color'];
		}

		if(isset($mkd_options['buddy_press_first_level_menu_active_backgroundcolor']) && $mkd_options['buddy_press_first_level_menu_active_backgroundcolor'] !== '') {
			$buddy_press_first_level_menu_active_style[] = 'background-color: '.$mkd_options['buddy_press_first_level_menu_active_backgroundcolor'];
		}

		if(isset($mkd_options['buddy_press_first_level_menu_active_border_color']) && $mkd_options['buddy_press_first_level_menu_active_border_color'] !== '') {
			$buddy_press_first_level_menu_active_style[] = 'border-color: '.$mkd_options['buddy_press_first_level_menu_active_border_color'];?>
            #buddypress div#item-nav div.item-list-tabs ul li.current:not(:last-child) a:after,
            #buddypress div.item-list-tabs.activity-type-tabs ul li.selected:not(:last-child) a:after,
            .mkd_tabs.buddypress-tabs .tabs-nav li.active a:after{
            background-color:<?php echo esc_attr($mkd_options['buddy_press_first_level_menu_active_border_color']) ; ?>
            }
			<?php
		}

		if(is_array($buddy_press_first_level_menu_active_style) && count($buddy_press_first_level_menu_active_style)) { ?>
            #buddypress #item-nav div.item-list-tabs ul li.current a,
            #buddypress #item-nav div.item-list-tabs ul li.selected a,
            .buddypress.activity #buddypress .item-list-tabs.activity-type-tabs li.selected a,
            body.members #buddypress form div.item-list-tabs ul li.selected a:not(.select2-choice),
            body.groups #buddypress form div.item-list-tabs ul li.selected a:not(.select2-choice),
            .mkd_tabs.buddypress-tabs .tabs-nav li.active a{
			<?php echo esc_attr(implode(';', $buddy_press_first_level_menu_active_style)); ?>
            }
		<?php } ?>

		<?php

		if(isset($mkd_options['buddy_press_first_level_menu_active_title_hovercolor']) && $mkd_options['buddy_press_first_level_menu_active_title_hovercolor'] !== '') {
			$buddy_press_first_level_menu_active_hover_style[] = 'color: '.$mkd_options['buddy_press_first_level_menu_active_title_hovercolor'];
		}

		if(isset($mkd_options['buddy_press_first_level_menu_active_backgroundcolor_hover']) && $mkd_options['buddy_press_first_level_menu_active_backgroundcolor_hover'] !== '') {
			$buddy_press_first_level_menu_active_hover_style[] = 'background-color: '.$mkd_options['buddy_press_first_level_menu_active_backgroundcolor_hover'];
		}

		if(isset($mkd_options['buddy_press_first_level_menu_active_border_hover_color']) && $mkd_options['buddy_press_first_level_menu_active_border_hover_color'] !== '') {
			$buddy_press_first_level_menu_active_hover_style[] = 'border-color: '.$mkd_options['buddy_press_first_level_menu_active_border_hover_color'];?>
            #buddypress div#item-nav div.item-list-tabs ul li.current:not(:last-child) a:hover:after,
            #buddypress div.item-list-tabs.activity-type-tabs ul li.selected:not(:last-child) a:hover:after,
            .mkd_tabs.buddypress-tabs .tabs-nav li.active a:hover:after{
            background-color:<?php echo esc_attr($mkd_options['buddy_press_first_level_menu_active_border_hover_color']) ; ?>
            }
			<?php
		}

		if(is_array($buddy_press_first_level_menu_active_hover_style) && count($buddy_press_first_level_menu_active_hover_style)) { ?>
            #buddypress #item-nav div.item-list-tabs ul li.current a:hover,
            #buddypress #item-nav div.item-list-tabs ul li.selected a:hover,
            .buddypress.activity #buddypress .item-list-tabs.activity-type-tabs li.selected a:hover,
            body.members #buddypress form div.item-list-tabs ul li.selected a:not(.select2-choice):hover,
            body.groups #buddypress form div.item-list-tabs ul li.selected a:not(.select2-choice):hover,
            .mkd_tabs.buddypress-tabs .tabs-nav li.active a:hover{
			<?php echo esc_attr(implode(';', $buddy_press_first_level_menu_active_hover_style)); ?>
            }
		<?php } ?>

		<?php

		$buddy_press_first_level_menu_notification_count_style = array();

		if(isset($mkd_options['buddy_press_first_level_menu_notification_count_color']) && $mkd_options['buddy_press_first_level_menu_notification_count_color'] !== '') {
			$buddy_press_first_level_menu_notification_count_style[] = 'color: '.$mkd_options['buddy_press_first_level_menu_notification_count_color'];
		}

		if(isset($mkd_options['buddy_press_first_level_menu_notification_count_backgroundcolor']) && $mkd_options['buddy_press_first_level_menu_notification_count_backgroundcolor'] !== '') {
			$buddy_press_first_level_menu_notification_count_style[] = 'background-color: '.$mkd_options['buddy_press_first_level_menu_notification_count_backgroundcolor'];
		}

		if(isset($mkd_options['buddy_press_first_level_menu_notification_count_border_color']) && $mkd_options['buddy_press_first_level_menu_notification_count_border_color'] !== '') {
			$buddy_press_first_level_menu_notification_count_style[] = 'border-color: '.$mkd_options['buddy_press_first_level_menu_notification_count_border_color'];
		}

		if(is_array($buddy_press_first_level_menu_notification_count_style) && count($buddy_press_first_level_menu_notification_count_style)) { ?>
            #buddypress div.item-list-tabs ul li a span.count,
            .buddypress.activity #buddypress .item-list-tabs.activity-type-tabs ul li a:not(.select2-choice) span,
            .buddypress.groups #buddypress div.item-list-tabs ul li a:not(.select2-choice) span,
            .buddypress.members #buddypress div.item-list-tabs ul li a:not(.select2-choice) span{
			<?php echo esc_attr(implode(';', $buddy_press_first_level_menu_notification_count_style)); ?>
            }
		<?php } ?>

		<?php

		$buddy_press_first_level_menu_notification_count_hover_style = array();

		if(isset($mkd_options['buddy_press_first_level_menu_notification_count_hovercolor']) && $mkd_options['buddy_press_first_level_menu_notification_count_hovercolor'] !== '') {
			$buddy_press_first_level_menu_notification_count_hover_style[] = 'color: '.$mkd_options['buddy_press_first_level_menu_notification_count_hovercolor'];
		}

		if(isset($mkd_options['buddy_press_first_level_menu_notification_count_backgroundcolor_hover']) && $mkd_options['buddy_press_first_level_menu_notification_count_backgroundcolor_hover'] !== '') {
			$buddy_press_first_level_menu_notification_count_hover_style[] = 'background-color: '.$mkd_options['buddy_press_first_level_menu_notification_count_backgroundcolor_hover'];
		}

		if(isset($mkd_options['buddy_press_first_level_menu_notification_count_hover_color']) && $mkd_options['buddy_press_first_level_menu_notification_count_hover_color'] !== '') {
			$buddy_press_first_level_menu_notification_count_hover_style[] = 'border-color: '.$mkd_options['buddy_press_first_level_menu_notification_count_hover_color'];
		}

		if(is_array($buddy_press_first_level_menu_notification_count_hover_style) && count($buddy_press_first_level_menu_notification_count_hover_style)) { ?>
            #buddypress div.item-list-tabs ul li a span.count:hover,
            .buddypress.activity #buddypress .item-list-tabs.activity-type-tabs ul li a:not(.select2-choice) span:hover,
            .buddypress.groups #buddypress div.item-list-tabs ul li a:not(.select2-choice) span:hover,
            .buddypress.members #buddypress div.item-list-tabs ul li a:not(.select2-choice) span:hover{
			<?php echo esc_attr(implode(';', $buddy_press_first_level_menu_notification_count_hover_style)); ?>
            }
		<?php } ?>

		<?php
		$buddy_press_second_level_menu_style = array();
		$buddy_press_second_level_menu_hover_style = array();
		$buddy_press_second_level_menu_active_style = array();
		$buddy_press_second_level_menu_active_hover_style = array();

		if(isset($mkd_options['buddy_press_second_level_menu_title_google_fonts']) && $mkd_options['buddy_press_second_level_menu_title_google_fonts'] !== '-1') {
			$buddy_press_second_level_menu_style[] = 'font-family: '.str_replace('+', ' ', $mkd_options['buddy_press_second_level_menu_title_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['buddy_press_second_level_menu_title_fontsize']) && $mkd_options['buddy_press_second_level_menu_title_fontsize'] !== '') {
			$buddy_press_second_level_menu_style[] = 'font-size: '.intval($mkd_options['buddy_press_second_level_menu_title_fontsize']).'px';
		}

		if(isset($mkd_options['buddy_press_second_level_menu_title_lineheight']) && $mkd_options['buddy_press_second_level_menu_title_lineheight'] !== '') {
			$buddy_press_second_level_menu_style[] = 'line-height: '.intval($mkd_options['buddy_press_second_level_menu_title_lineheight']).'px';
			$buddy_press_second_level_menu_style[] = 'height: '.intval($mkd_options['buddy_press_second_level_menu_title_lineheight']).'px';
		}

		if(isset($mkd_options['buddy_press_second_level_menu_title_letter_spacing']) && $mkd_options['buddy_press_second_level_menu_title_letter_spacing'] !== '') {
			$buddy_press_second_level_menu_style[] = 'letter-spacing: '.intval($mkd_options['buddy_press_second_level_menu_title_letter_spacing']).'px';
		}

		if(isset($mkd_options['buddy_press_second_level_menu_title_fontweight']) && $mkd_options['buddy_press_second_level_menu_title_fontweight'] !== '') {
			$buddy_press_second_level_menu_style[] = 'font-weight: '.intval($mkd_options['buddy_press_second_level_menu_title_fontweight']);
		}

		if(isset($mkd_options['buddy_press_second_level_menu_title_fontstyle']) && $mkd_options['buddy_press_second_level_menu_title_fontstyle'] !== '') {
			$buddy_press_second_level_menu_style[] = 'font-style: '.$mkd_options['buddy_press_second_level_menu_title_fontstyle'];
		}

		if(isset($mkd_options['buddy_press_second_level_menu_title_texttransform']) && $mkd_options['buddy_press_second_level_menu_title_texttransform'] !== '') {
			$buddy_press_second_level_menu_style[] = 'text-transform: '.$mkd_options['buddy_press_second_level_menu_title_texttransform'];
		}

		if(isset($mkd_options['buddy_press_second_level_menu_title_color']) && $mkd_options['buddy_press_second_level_menu_title_color'] !== '') {
			$buddy_press_second_level_menu_style[] = 'color: '.$mkd_options['buddy_press_second_level_menu_title_color'];
		}

		if(isset($mkd_options['buddy_press_second_level_menu_backgroundcolor']) && $mkd_options['buddy_press_second_level_menu_backgroundcolor'] !== '') {
			$buddy_press_second_level_menu_style[] = 'background-color: '.$mkd_options['buddy_press_second_level_menu_backgroundcolor'];
		}

		if(isset($mkd_options['buddy_press_second_level_menu_border_color']) && $mkd_options['buddy_press_second_level_menu_border_color'] !== '') {
			$buddy_press_second_level_menu_style[] = 'border-color: '.$mkd_options['buddy_press_second_level_menu_border_color'];
		}

		if(isset($mkd_options['buddy_press_second_level_menu_border_width']) && $mkd_options['buddy_press_second_level_menu_border_width'] !== '') {
			$buddy_press_second_level_menu_style[] = 'border-width: '.intval($mkd_options['buddy_press_second_level_menu_border_width']).'px';
		}

		if(isset($mkd_options['buddy_press_second_level_menu_border_radius']) && $mkd_options['buddy_press_second_level_menu_border_radius'] !== '') {
			$buddy_press_second_level_menu_style[] = 'border-radius: '.intval($mkd_options['buddy_press_second_level_menu_border_radius']).'px';
		}

		if(isset($mkd_options['buddy_press_second_level_menu_padding']) && $mkd_options['buddy_press_second_level_menu_padding'] !== '') {
			$buddy_press_second_level_menu_style[] = 'padding-left: '.intval($mkd_options['buddy_press_second_level_menu_padding']).'px';
			$buddy_press_second_level_menu_style[] = 'padding-right: '.intval($mkd_options['buddy_press_second_level_menu_padding']).'px';
		}
		if(is_array($buddy_press_second_level_menu_style) && count($buddy_press_second_level_menu_style)) { ?>
            #buddypress div#item-body div.item-list-tabs ul li a:not(.select2-choice){
			<?php echo esc_attr(implode(';', $buddy_press_second_level_menu_style)); ?>
            }
		<?php } ?>
		<?php

		if(isset($mkd_options['buddy_press_second_level_menu_title_hovercolor']) && $mkd_options['buddy_press_second_level_menu_title_hovercolor'] !== '') {
			$buddy_press_second_level_menu_hover_style[] = 'color: '.$mkd_options['buddy_press_second_level_menu_title_hovercolor'];
		}

		if(isset($mkd_options['buddy_press_second_level_menu_backgroundcolor_hover']) && $mkd_options['buddy_press_second_level_menu_backgroundcolor_hover'] !== '') {
			$buddy_press_second_level_menu_hover_style[] = 'background-color: '.$mkd_options['buddy_press_second_level_menu_backgroundcolor_hover'];
		}

		if(isset($mkd_options['buddy_press_second_level_menu_border_hover_color']) && $mkd_options['buddy_press_second_level_menu_border_hover_color'] !== '') {
			$buddy_press_second_level_menu_hover_style[] = 'border-color: '.$mkd_options['buddy_press_second_level_menu_border_hover_color'];
		}

		if(is_array($buddy_press_second_level_menu_hover_style) && count($buddy_press_second_level_menu_hover_style)) { ?>
            #buddypress div#item-body div.item-list-tabs ul li a:not(.select2-choice):hover{
			<?php echo esc_attr(implode(';', $buddy_press_second_level_menu_hover_style)); ?>
            }
		<?php } ?>
		<?php

		if(isset($mkd_options['buddy_press_second_level_menu_active_title_color']) && $mkd_options['buddy_press_second_level_menu_active_title_color'] !== '') {
			$buddy_press_second_level_menu_active_style[] = 'color: '.$mkd_options['buddy_press_second_level_menu_active_title_color'];
		}

		if(isset($mkd_options['buddy_press_second_level_menu_active_backgroundcolor']) && $mkd_options['buddy_press_second_level_menu_active_backgroundcolor'] !== '') {
			$buddy_press_second_level_menu_active_style[] = 'background-color: '.$mkd_options['buddy_press_second_level_menu_active_backgroundcolor'];
		}

		if(isset($mkd_options['buddy_press_second_level_menu_active_border_color']) && $mkd_options['buddy_press_second_level_menu_active_border_color'] !== '') {
			$buddy_press_second_level_menu_active_style[] = 'border-color: '.$mkd_options['buddy_press_second_level_menu_active_border_color'];
		}

		if(is_array($buddy_press_second_level_menu_active_style) && count($buddy_press_second_level_menu_active_style)) { ?>
            #buddypress div#item-body div.item-list-tabs ul li.current a:not(.select2-choice),
            #buddypress div#item-body div.item-list-tabs ul li.selected a:not(.select2-choice){
			<?php echo esc_attr(implode(';', $buddy_press_second_level_menu_active_style)); ?>
            }
		<?php } ?>

		<?php

		if(isset($mkd_options['buddy_press_second_level_menu_active_title_hovercolor']) && $mkd_options['buddy_press_second_level_menu_active_title_hovercolor'] !== '') {
			$buddy_press_second_level_menu_active_hover_style[] = 'color: '.$mkd_options['buddy_press_second_level_menu_active_title_hovercolor'];
		}

		if(isset($mkd_options['buddy_press_second_level_menu_active_backgroundcolor_hover']) && $mkd_options['buddy_press_second_level_menu_active_backgroundcolor_hover'] !== '') {
			$buddy_press_second_level_menu_active_hover_style[] = 'background-color: '.$mkd_options['buddy_press_second_level_menu_active_backgroundcolor_hover'];
		}

		if(isset($mkd_options['buddy_press_second_level_menu_active_border_hover_color']) && $mkd_options['buddy_press_second_level_menu_active_border_hover_color'] !== '') {
			$buddy_press_second_level_menu_active_hover_style[] = 'border-color: '.$mkd_options['buddy_press_second_level_menu_active_border_hover_color'];
		}

		if(is_array($buddy_press_second_level_menu_active_hover_style) && count($buddy_press_second_level_menu_active_hover_style)) { ?>
            #buddypress div#item-body div.item-list-tabs ul li.current a:not(.select2-choice):hover,
            #buddypress div#item-body div.item-list-tabs ul li.selected a:not(.select2-choice):hover{
			<?php echo esc_attr(implode(';', $buddy_press_second_level_menu_active_hover_style)); ?>
            }
		<?php } ?>
		<?php
		$buddy_press_elements_styles = '';
		$buddy_press_element_color_placeholder = '';
		$buddy_press_submit_button_color_styles = '';


		if(isset($mkd_options['buddy_press_element_background_color']) && $mkd_options['buddy_press_element_background_color'] !== '') {
			if(isset($mkd_options['buddy_press_element_background_transparency']) && $mkd_options['buddy_press_element_background_transparency'] !== ''){
				$buddy_press_element_background_color = mikado_one_mikado_hex2rgb($mkd_options['buddy_press_element_background_color']);
				$buddy_press_elements_styles .= 'background-color: rgba('. $buddy_press_element_background_color[0] . ',' . $buddy_press_element_background_color[1] . ',' . $buddy_press_element_background_color[2] . ',' . $mkd_options['buddy_press_element_background_transparency'] .');';
				$buddy_press_submit_button_color_styles .= 'background-color:#279eff;';
			} else {
				$buddy_press_elements_styles .= 'background-color: '.$mkd_options['buddy_press_element_background_color'].';';
				$buddy_press_submit_button_color_styles .= 'background-color:#279eff;';
			}
		}


		if(isset($mkd_options['buddy_press_element_border_color']) && $mkd_options['buddy_press_element_border_color'] !== '') {
			if(isset($mkd_options['buddy_press_element_border_transparency']) && $mkd_options['buddy_press_element_border_transparency'] !== ''){
				$buddy_press_element_border_color = mikado_one_mikado_hex2rgb($mkd_options['buddy_press_element_border_color']);
				$buddy_press_elements_styles .= 'border-color: rgba('. $buddy_press_element_border_color[0] . ',' . $buddy_press_element_border_color[1] . ',' . $buddy_press_element_border_color[2] . ',' . $mkd_options['buddy_press_element_border_transparency'] .');';
				$buddy_press_submit_button_color_styles .= 'border-color: #279eff;';
			} else {
				$buddy_press_elements_styles .= 'border-color: '.$mkd_options['buddy_press_element_border_color'].';';
				$buddy_press_submit_button_color_styles .= 'border-color: #279eff;';
			}
		}

		if(isset($mkd_options['buddy_press_element_border_width']) && $mkd_options['buddy_press_element_border_width'] !== '') {
			$buddy_press_elements_styles .= 'border-width: '.intval($mkd_options['buddy_press_element_border_width']).'px;';
			$buddy_press_elements_styles .= 'border-style:solid;';
			$buddy_press_elements_styles .= 'transform: translateZ(0);';
		}

		if(isset($mkd_options['buddy_press_element_border_radius']) && $mkd_options['buddy_press_element_border_radius'] !== '') {
			$buddy_press_elements_styles .= 'border-radius: '.intval($mkd_options['buddy_press_element_border_radius']).'px;';
		}

		if(isset($mkd_options['buddy_press_element_border_bottom']) && $mkd_options['buddy_press_element_border_bottom'] == 'yes') {
			$buddy_press_elements_styles .= 'border-left: none; border-right:none; border-top: none;';
		}

		if(isset($mkd_options['buddy_press_element_font_color']) && $mkd_options['buddy_press_element_font_color'] !== '') {
			$buddy_press_elements_styles .= 'color: '.$mkd_options['buddy_press_element_font_color'].';';
			$buddy_press_element_color_placeholder .= 'color: '.$mkd_options['buddy_press_element_font_color'].';';
			$buddy_press_element_color_placeholder .= 'opacity:1;';
			$buddy_press_submit_button_color_styles .= 'color: #fff';
			?>

            #buddypress div.item-list-tabs ul li .select2-container a span,
            #buddypress div.item-list-tabs ul li.current .select2-container a span,
            #buddypress div.item-list-tabs ul li.selected .select2-container a span{
            color: <?php echo esc_attr($mkd_options['buddy_press_element_font_color']) ;?>;
            }
			<?php
		}

		if(isset($mkd_options['buddy_press_element_font_family']) && $mkd_options['buddy_press_element_font_family'] !== '-1') {
			$buddy_press_elements_styles .= 'font-family: '.str_replace('+', ' ', $mkd_options['buddy_press_element_font_family']).';';
		}

		if(isset($mkd_options['buddy_press_element_font_size']) && $mkd_options['buddy_press_element_font_size'] !== '') {
			$buddy_press_elements_styles .= 'font-size: '.intval($mkd_options['buddy_press_element_font_size']).'px;';
		}

		if(isset($mkd_options['buddy_press_element_line_height']) && $mkd_options['buddy_press_element_line_height'] !== '') {
			$buddy_press_elements_styles .= 'line-height: '.intval($mkd_options['buddy_press_element_line_height']).'px;';
			$buddy_press_elements_styles .= 'height: '.intval($mkd_options['buddy_press_element_line_height']).'px;'; ?>

            #buddypress .item-list-tabs ul li .select2-container .select2-choice span,
            #buddypress .select2-container .select2-choice span,
            #buddypress #item-body .select2-container .select2-choice span,
            #buddypress #whats-new-form .select2-container .select2-choice span{
            height: <?php echo esc_attr($mkd_options['buddy_press_element_line_height']).'px'; ?>;
            line-height:  <?php echo esc_attr($mkd_options['buddy_press_element_line_height']).'px'; ?>;
            }

            #buddypress .select2-container .select2-choice .select2-arrow:after,
            #buddypress #item-body .select2-container .select2-choice .select2-arrow:after,
            #buddypress #whats-new-form .select2-container .select2-choice .select2-arrow:after,
            #buddypress #item-body input[type=button],
            #buddypress #item-body input[type=reset],
            #buddypress #item-body input[type=submit],
            #buddypress #item-body li.groups-members-search input[type=text],
            #buddypress .message-search input[type=text]{
            line-height:  <?php echo esc_attr($mkd_options['buddy_press_element_line_height']).'px'; ?>;
            height:  <?php echo esc_attr($mkd_options['buddy_press_element_line_height']).'px'; ?>;
            }
			<?php
		}

		if(isset($mkd_options['buddy_press_element_font_style']) && $mkd_options['buddy_press_element_font_style'] !== '') {
			$buddy_press_elements_styles .= 'font-style: '.$mkd_options['buddy_press_element_font_style'].';';
		}

		if(isset($mkd_options['buddy_press_element_font_weight']) && $mkd_options['buddy_press_element_font_weight'] !== '') {
			$buddy_press_elements_styles .= 'font-weight: '.intval($mkd_options['buddy_press_element_font_weight']).';';
		}

		if(isset($mkd_options['buddy_press_element_letter_spacing']) && $mkd_options['buddy_press_element_letter_spacing'] !== '') {
			$buddy_press_elements_styles .= 'letter-spacing: '.intval($mkd_options['buddy_press_element_letter_spacing']).'px;';
		}

		if(isset($mkd_options['buddy_press_element_text_transform']) && $mkd_options['buddy_press_element_text_transform'] !== '') {
			$buddy_press_elements_styles .= 'text-transform: '.$mkd_options['buddy_press_element_text_transform'].';';
		}

		if(isset($mkd_options['buddy_press_element_padding_top']) && $mkd_options['buddy_press_element_padding_top'] !== '') {
			$buddy_press_elements_styles .= 'padding-top: '.intval($mkd_options['buddy_press_element_padding_top']).'px;';
			?>
            #buddypress .select2-container .select2-choice .select2-arrow,
            #buddypress #whats-new-form .select2-container .select2-choice .select2-arrow{
            top: <?php echo esc_attr($mkd_options['buddy_press_element_padding_top']).'px'; ?>;
            }
			<?php
		}

		if(isset($mkd_options['buddy_press_element_padding_right']) && $mkd_options['buddy_press_element_padding_right'] !== '') {
			$buddy_press_elements_styles .= 'padding-right: '.intval($mkd_options['buddy_press_element_padding_right']).'px;';
		}

		if(isset($mkd_options['buddy_press_element_padding_bottom']) && $mkd_options['buddy_press_element_padding_bottom'] !== '') {
			$buddy_press_elements_styles .= 'padding-bottom: '.intval($mkd_options['buddy_press_element_padding_bottom']).'px;';
		}

		if(isset($mkd_options['buddy_press_element_padding_left']) && $mkd_options['buddy_press_element_padding_left'] !== '') {
			$buddy_press_elements_styles .= 'padding-left: '.intval($mkd_options['buddy_press_element_padding_left']).'px;';
		}

		if(isset($mkd_options['buddy_press_element_margin_top']) && $mkd_options['buddy_press_element_margin_top'] !== '') {
			$buddy_press_elements_styles .= 'margin-top: '.intval($mkd_options['buddy_press_element_margin_top']).'px;';
		}

		if(isset($mkd_options['buddy_press_element_margin_bottom']) && $mkd_options['buddy_press_element_margin_bottom'] !== '') {
			$buddy_press_elements_styles .= 'margin-bottom: '.intval($mkd_options['buddy_press_element_margin_bottom']).'px;';
		}

		$buddy_press_elements_focus_styles = '';
		$buddy_press_focus_color_placeholder = '';


		if(isset($mkd_options['buddy_press_element_font_focus_color']) && $mkd_options['buddy_press_element_font_focus_color'] !== '') {
			$buddy_press_elements_focus_styles .= 'color: '.$mkd_options['buddy_press_element_font_focus_color'].';';
			$buddy_press_focus_color_placeholder .= 'color: '.$mkd_options['buddy_press_element_font_focus_color'].';';
		}

		if(isset($mkd_options['buddy_press_element_focus_background_color']) && $mkd_options['buddy_press_element_focus_background_color'] !== '') {
			if(isset($mkd_options['buddy_press_element_focus_background_transparency']) && $mkd_options['buddy_press_element_focus_background_transparency'] !== ''){
				$buddy_press_element_focus_background_color = mikado_one_mikado_hex2rgb($mkd_options['buddy_press_element_focus_background_color']);
				$buddy_press_elements_focus_styles .= 'background-color: rgba('. $buddy_press_element_focus_background_color[0] . ',' . $buddy_press_element_focus_background_color[1] . ',' . $buddy_press_element_focus_background_color[2] . ',' . $mkd_options['buddy_press_element_focus_background_transparency'] .');';
			} else {
				$buddy_press_elements_focus_styles .= 'background-color: '.$mkd_options['buddy_press_element_focus_background_color'].';';
			}
		}

		if(isset($mkd_options['buddy_press_element_focus_border_color']) && $mkd_options['buddy_press_element_focus_border_color'] !== '') {
			if(isset($mkd_options['buddy_press_element_focus_border_transparency']) && $mkd_options['buddy_press_element_focus_border_transparency'] !== ''){
				$buddy_press_element_focus_border_color = mikado_one_mikado_hex2rgb($mkd_options['buddy_press_element_focus_border_color']);
				$buddy_press_elements_focus_styles .= 'border-color: rgba('. $buddy_press_element_focus_border_color[0] . ',' . $buddy_press_element_focus_border_color[1] . ',' . $buddy_press_element_focus_border_color[2] . ',' . $mkd_options['buddy_press_element_focus_border_transparency'] .') !important;';

			} else {
				$buddy_press_elements_focus_styles .= 'border-color: '.$mkd_options['buddy_press_element_focus_border_color'].' !important;';
			}

			if(isset($mkd_options['buddy_press_element_border_width']) && $mkd_options['buddy_press_element_border_width'] !== '') {
				$buddy_press_elements_focus_styles .= 'border-width: '.intval($mkd_options['buddy_press_element_border_width']).'px;';
				$buddy_press_elements_focus_styles .= 'border-style:solid;';
				$buddy_press_elements_focus_styles .= 'transform: translateZ(0);';
			}

			if(isset($mkd_options['buddy_press_element_border_bottom']) && $mkd_options['buddy_press_element_border_bottom'] == 'yes') {
				$buddy_press_elements_focus_styles .= 'border-left: none; border-right:none; border-top: none;';
			}

		}
		if($buddy_press_elements_styles !== "") { ?>
            #buddypress .dir-search input[type=search],
            #buddypress .dir-search input[type=text],
            #buddypress .groups-members-search input[type=search],
            #buddypress .groups-members-search input[type=text],
            #buddypress .standard-form input[type=color],
            #buddypress .standard-form input[type=date],
            #buddypress .standard-form input[type=datetime-local],
            #buddypress .standard-form input[type=datetime],
            #buddypress .standard-form input[type=email],
            #buddypress .standard-form input[type=month],
            #buddypress .standard-form input[type=number],
            #buddypress .standard-form input[type=password],
            #buddypress .standard-form input[type=range],
            #buddypress .standard-form input[type=search],
            #buddypress .standard-form input[type=tel],
            #buddypress .standard-form input[type=text],
            #buddypress .standard-form input[type=time],
            #buddypress .standard-form input[type=url],
            #buddypress .standard-form input[type=week],
            #buddypress input[type=button]:hover,
            #buddypress input[type=reset]:hover,
            #buddypress input[type=submit]:hover,
            #buddypress input[type=button],
            #buddypress input[type=reset],
            #buddypress input[type=submit],
            #buddypress .standard-form select,
            #buddypress .standard-form textarea,
            #buddypress form#whats-new-form textarea,
            #buddypress input#messages_search,
            #buddypress div.dir-search input[type=text],
            #buddypress li.groups-members-search input[type=text],
            #buddypress div.activity-comments form textarea,
            #buddypress .item-list-tabs ul li .select2-container .select2-choice,
            #buddypress .select2-container .select2-choice,
            body.buddypress .select2-drop{
			<?php echo esc_attr($buddy_press_elements_styles); ?>
            }
		<?php }

		if($buddy_press_elements_focus_styles !== "") { ?>
            #buddypress .dir-search input[type=search]:focus,
            #buddypress .dir-search input[type=text]:focus,
            #buddypress .groups-members-search input[type=search]:focus,
            #buddypress .groups-members-search input[type=text]:focus,
            #buddypress .standard-form input[type=color]:focus,
            #buddypress .standard-form input[type=date]:focus,
            #buddypress .standard-form input[type=datetime-local]:focus,
            #buddypress .standard-form input[type=datetime]:focus,
            #buddypress .standard-form input[type=email]:focus,
            #buddypress .standard-form input[type=month]:focus,
            #buddypress .standard-form input[type=number]:focus,
            #buddypress .standard-form input[type=password]:focus,
            #buddypress .standard-form input[type=range]:focus,
            #buddypress .standard-form input[type=search]:focus,
            #buddypress .standard-form input[type=tel]:focus,
            #buddypress .standard-form input[type=text]:focus,
            #buddypress .standard-form input[type=time]:focus,
            #buddypress .standard-form input[type=url]:focus,
            #buddypress .standard-form input[type=week]:focus,
            #buddypress input[type=button]:focus,
            #buddypress input[type=reset]:focus,
            #buddypress input[type=submit]:focus,
            #buddypress .standard-form select:focus,
            #buddypress .standard-form textarea:focus,
            #buddypress form#whats-new-form textarea:focus,
            #buddypress input#messages_search:focus,
            #buddypress div.dir-search input[type=text]:focus,
            #buddypress li.groups-members-search input[type=text]:focus,
            #buddypress div.activity-comments form textarea:focus,
            #buddypress .item-list-tabs ul li .select2-container .select2-choice:focus,
            #buddypress .select2-container .select2-choice:focus,
            body.buddypress .select2-drop:focus{
			<?php echo esc_attr($buddy_press_elements_focus_styles); ?>
            }
		<?php } ?>
		<?php
		if($buddy_press_submit_button_color_styles !== "") { ?>
            #buddypress input[type=button],
            #buddypress input[type=reset],
            #buddypress input[type=submit],
            #buddypress input[type=button]:hover,
            #buddypress input[type=reset]:hover,
            #buddypress input[type=submit]:hover,
            #buddypress input[type=button]:focus,
            #buddypress input[type=reset]:focus,
            #buddypress input[type=submit]:focus{
			<?php echo esc_attr($buddy_press_submit_button_color_styles); ?>
            }
		<?php } ?>

		<?php

		$buddy_press_pagination_item_styles = array();
		$buddy_press_pagination_item_hover_styles = array();

		if(isset($mkd_options['buddy_press_pagination_item_background_color']) && $mkd_options['buddy_press_pagination_item_background_color'] !== '') {
			$buddy_press_pagination_item_styles[] = 'background-color: '.$mkd_options['buddy_press_pagination_item_background_color'];
		}

		if(isset($mkd_options['buddy_press_pagination_item_border_color']) && $mkd_options['buddy_press_pagination_item_border_color'] !== '') {
			$buddy_press_pagination_item_styles[] = 'border-color: '.$mkd_options['buddy_press_pagination_item_border_color'];
		}

		if(isset($mkd_options['buddy_press_pagination_item_border_width']) && $mkd_options['buddy_press_pagination_item_border_width'] !== '') {
			$buddy_press_pagination_item_styles[] = 'border-width: '.intval($mkd_options['buddy_press_pagination_item_border_width']).'px';
		}

		if(isset($mkd_options['buddy_press_pagination_item_border_radius']) && $mkd_options['buddy_press_pagination_item_border_radius'] !== '') {
			$buddy_press_pagination_item_styles[] = 'border-radius: '.intval($mkd_options['buddy_press_pagination_item_border_radius']).'px';
		}

		if(isset($mkd_options['buddy_press_pagination_item_color']) && $mkd_options['buddy_press_pagination_item_color'] !== '') {
			$buddy_press_pagination_item_styles[] = 'color: '.$mkd_options['buddy_press_pagination_item_color'];
		}

		if(is_array($buddy_press_pagination_item_styles) && count($buddy_press_pagination_item_styles)) { ?>
            #buddypress div.pagination .pagination-links a,
            #buddypress div.pagination .pagination-links span,
            #buddypress div.pagination .pagination-links a.next:after,
            #buddypress div.pagination .pagination-links a.prev:before{
			<?php echo esc_attr(implode(';', $buddy_press_pagination_item_styles)); ?>
            }
		<?php } ?>
		<?php

		if(isset($mkd_options['buddy_press_pagination_item_background_color_hover']) && $mkd_options['buddy_press_pagination_item_background_color_hover'] !== '') {
			$buddy_press_pagination_item_hover_styles[] = 'background-color: '.$mkd_options['buddy_press_pagination_item_background_color_hover'];
		}

		if(isset($mkd_options['buddy_press_pagination_item_border_color_hover']) && $mkd_options['buddy_press_pagination_item_border_color_hover'] !== '') {
			$buddy_press_pagination_item_hover_styles[] = 'border-color: '.$mkd_options['buddy_press_pagination_item_border_color_hover'];
		}

		if(isset($mkd_options['buddy_press_pagination_item_color_hover']) && $mkd_options['buddy_press_pagination_item_color_hover'] !== '') {
			$buddy_press_pagination_item_hover_styles[] = 'color: '.$mkd_options['buddy_press_pagination_item_color_hover'];
		}

		if(is_array($buddy_press_pagination_item_hover_styles) && count($buddy_press_pagination_item_hover_styles)) { ?>
            #buddypress div.pagination .pagination-links .page-numbers.current,
            #buddypress div.pagination .pagination-links a:hover,
            #buddypress div.pagination .pagination-links a.next:hover:after,
            #buddypress div.pagination .pagination-links a.prev:hover:before{
			<?php echo esc_attr(implode(';', $buddy_press_pagination_item_hover_styles)); ?>
            }
		<?php } ?>
		<?php

		$buddy_press_pagination_text_styles= array();

		if(isset($mkd_options['buddy_press_pagination_text_google_fonts']) && $mkd_options['buddy_press_pagination_text_google_fonts'] !== '-1') {
			$buddy_press_pagination_text_styles[] = 'font-family: '.str_replace('+', ' ', $mkd_options['buddy_press_pagination_text_google_fonts']).', sans-serif';
		}

		if(isset($mkd_options['buddy_press_pagination_text_fontsize']) && $mkd_options['buddy_press_pagination_text_fontsize'] !== '') {
			$buddy_press_pagination_text_styles[] = 'font-size: '.intval($mkd_options['buddy_press_pagination_text_fontsize']).'px';
		}

		if(isset($mkd_options['buddy_press_pagination_text_lineheight']) && $mkd_options['buddy_press_pagination_text_lineheight'] !== '') {
			$buddy_press_pagination_text_styles[] = 'line-height: '.intval($mkd_options['buddy_press_pagination_text_lineheight']).'px';
			$buddy_press_pagination_text_styles[] = 'height: '.intval($mkd_options['buddy_press_pagination_text_lineheight']).'px';
		}

		if(isset($mkd_options['buddy_press_pagination_text_letter_spacing']) && $mkd_options['buddy_press_pagination_text_letter_spacing'] !== '') {
			$buddy_press_pagination_text_styles[] = 'letter-spacing: '.intval($mkd_options['buddy_press_pagination_text_letter_spacing']).'px';
		}

		if(isset($mkd_options['buddy_press_pagination_text_fontweight']) && $mkd_options['buddy_press_pagination_text_fontweight'] !== '') {
			$buddy_press_pagination_text_styles[] = 'font-weight: '.intval($mkd_options['buddy_press_pagination_text_fontweight']);
		}

		if(isset($mkd_options['buddy_press_pagination_text_fontstyle']) && $mkd_options['buddy_press_pagination_text_fontstyle'] !== '') {
			$buddy_press_pagination_text_styles[] = 'font-style: '.$mkd_options['buddy_press_pagination_text_fontstyle'];
		}

		if(isset($mkd_options['buddy_press_pagination_text_texttransform']) && $mkd_options['buddy_press_pagination_text_texttransform'] !== '') {
			$buddy_press_pagination_text_styles[] = 'text-transform: '.$mkd_options['buddy_press_pagination_text_texttransform'];
		}

		if(isset($mkd_options['buddy_press_pagination_text_color']) && $mkd_options['buddy_press_pagination_text_color'] !== '') {
			$buddy_press_pagination_text_styles[] = 'color: '.$mkd_options['buddy_press_pagination_text_color'];
		}

		if(is_array($buddy_press_pagination_text_styles) && count($buddy_press_pagination_text_styles)) { ?>
            #buddypress div.pagination .pag-count{
			<?php echo esc_attr(implode(';', $buddy_press_pagination_text_styles)); ?>
            }
		<?php } ?>

		<?php
		$buddy_press_text_style = array();

		if(isset($mkd_options['buddy_press_text_google_fonts']) && $mkd_options['buddy_press_text_google_fonts'] !== '-1') {
			$buddy_press_text_style[] = 'font-family: '.esc_attr(str_replace('+', ' ', $mkd_options['buddy_press_text_google_fonts'])).', sans-serif';
		}

		if(isset($mkd_options['buddy_press_text_fontsize']) && $mkd_options['buddy_press_text_fontsize'] !== '') {
			$buddy_press_text_style[] = 'font-size: '.esc_attr($mkd_options['buddy_press_text_fontsize']).'px';
		}

		if(isset($mkd_options['buddy_press_text_lineheight']) && $mkd_options['buddy_press_text_lineheight'] !== '') {
			$buddy_press_text_style[] = 'line-height: '.esc_attr($mkd_options['buddy_press_text_lineheight']).'px';
		}

		if(isset($mkd_options['buddy_press_text_letter_spacing']) && $mkd_options['buddy_press_text_letter_spacing'] !== '') {
			$buddy_press_text_style[] = 'letter-spacing: '.esc_attr($mkd_options['buddy_press_text_letter_spacing']).'px';
		}

		if(isset($mkd_options['buddy_press_text_fontweight']) && $mkd_options['buddy_press_text_fontweight'] !== '') {
			$buddy_press_text_style[] = 'font-weight: '.esc_attr($mkd_options['buddy_press_text_fontweight']);
		}

		if(isset($mkd_options['buddy_press_text_fontstyle']) && $mkd_options['buddy_press_text_fontstyle'] !== '') {
			$buddy_press_text_style[] = 'font-style: '.esc_attr($mkd_options['buddy_press_text_fontstyle']);
		}

		if(isset($mkd_options['buddy_press_text_text_transform']) && $mkd_options['buddy_press_text_text_transform'] !== '') {
			$buddy_press_text_style[] = 'text-transform: '.esc_attr($mkd_options['buddy_press_text_text_transform']);
		}

		if(isset($mkd_options['buddy_press_text_color']) && $mkd_options['buddy_press_text_color'] !== '') {
			$buddy_press_text_style[] = 'color: '.esc_attr($mkd_options['buddy_press_text_color']);
		}

		if(isset($mkd_options['buddy_press_text_margin']) && $mkd_options['buddy_press_text_margin'] !== '') {
			$buddy_press_text_style[] = 'margin-top: '.esc_attr($mkd_options['buddy_press_text_margin']).'px';
			$buddy_press_text_style[] = 'margin-bottom: '.esc_attr($mkd_options['buddy_press_text_margin']).'px';
		}

		if(is_array($buddy_press_text_style) && count($buddy_press_text_style)) { ?>
            #buddypress span.activity,
            #buddypress label,
            #buddypress .field-visibility-settings-notoggle,
            #buddypress div#message p,
            #buddypress table tr td.thread-info p.thread-excerpt,
            #buddypress ul.item-list#groups-list li .item p,
            .buddypress.settings #buddypress form#settings-form p,
            #buddypress .field-visibility-settings,
            #buddypress .field-visibility-settings-notoggle,
            #buddypress .field-visibility-settings-toggle,
            #buddypress .standard-form p.description,
            #buddypress div#item-body .profile p,
            #buddypress form#whats-new-form p.activity-greeting,
            body.register #buddypress form p,
            #buddypress div#item-header div#item-meta p,
            #buddypress ul.item-list li div.item-title span,
            .buddypress.activity #buddypress .activity,
            #buddypress.buddypress-list-activities .activity-content .activity-header p,
            #buddypress.buddypress-list-activities .activity-content .activity-inner p{
			<?php echo esc_attr(implode(';', $buddy_press_text_style)); ?>
            }
		<?php }  ?>
		<?php

		$buddy_press_link_style = array();
		$buddy_press_link_hover_style = array();

		if(isset($mkd_options['buddy_press_link_google_fonts']) && $mkd_options['buddy_press_link_google_fonts'] !== '-1') {
			$buddy_press_link_style[] = 'font-family: '.esc_attr(str_replace('+', ' ', $mkd_options['buddy_press_link_google_fonts'])).', sans-serif';
		}

		if(isset($mkd_options['buddy_press_link_fontsize']) && $mkd_options['buddy_press_link_fontsize'] !== '') {
			$buddy_press_link_style[] = 'font-size: '.esc_attr($mkd_options['buddy_press_link_fontsize']).'px';
		}

		if(isset($mkd_options['buddy_press_link_lineheight']) && $mkd_options['buddy_press_link_lineheight'] !== '') {
			$buddy_press_link_style[] = 'line-height: '.esc_attr($mkd_options['buddy_press_link_lineheight']).'px';
		}

		if(isset($mkd_options['buddy_press_link_letter_spacing']) && $mkd_options['buddy_press_link_letter_spacing'] !== '') {
			$buddy_press_link_style[] = 'letter-spacing: '.esc_attr($mkd_options['buddy_press_link_letter_spacing']).'px';
		}

		if(isset($mkd_options['buddy_press_link_fontweight']) && $mkd_options['buddy_press_link_fontweight'] !== '') {
			$buddy_press_link_style[] = 'font-weight: '.esc_attr($mkd_options['buddy_press_link_fontweight']);
		}

		if(isset($mkd_options['buddy_press_link_fontstyle']) && $mkd_options['buddy_press_link_fontstyle'] !== '') {
			$buddy_press_link_style[] = 'font-style: '.esc_attr($mkd_options['buddy_press_link_fontstyle']);
		}

		if(isset($mkd_options['buddy_press_link_text_transform']) && $mkd_options['buddy_press_link_text_transform'] !== '') {
			$buddy_press_link_style[] = 'text-transform: '.esc_attr($mkd_options['buddy_press_link_text_transform']);
		}

		if(isset($mkd_options['buddy_press_link_color']) && $mkd_options['buddy_press_link_color'] !== '') {
			$buddy_press_link_style[] = 'color: '.esc_attr($mkd_options['buddy_press_link_color']);
		}

		if(isset($mkd_options['buddy_press_link_fontdecoration']) && $mkd_options['buddy_press_link_fontdecoration'] !== '') {
			$buddy_press_link_style[] = 'text-decoration: '.esc_attr($mkd_options['buddy_press_link_fontdecoration']);
		}

		if(is_array($buddy_press_link_style) && count($buddy_press_link_style)) { ?>
            #buddypress .acomment-meta a,
            #buddypress .activity-header a,
            #buddypress .comment-meta a,
            #buddypress ul.item-list li div.item-title a,
            #buddypress ul.item-list li h4 a,
            #buddypress .activity-item .activity-inner a,
            #buddypress .acomment-options a,
            #buddypress .activity-list li.load-more a,
            #buddypress .activity-list li.load-newest a,
            #buddypress.buddypress-list-activities .activity-header p a:first-child,
            #buddypress.buddypress-list-groups ul.item-list li div.item-title a{
			<?php echo esc_attr(implode(';', $buddy_press_link_style)); ?>
            }
		<?php } ?>
		<?php
		if(isset($mkd_options['buddy_press_link_hovercolor']) && $mkd_options['buddy_press_link_hovercolor'] !== '') {
			$buddy_press_link_hover_style[] = 'color: '.$mkd_options['buddy_press_link_hovercolor'];
		}

		if(is_array($buddy_press_link_hover_style) && count($buddy_press_link_hover_style)) { ?>
            #buddypress .acomment-meta a:hover,
            #buddypress .activity-header a:hover,
            #buddypress .comment-meta a:hover,
            #buddypress ul.item-list li div.item-title a:hover,
            #buddypress ul.item-list li h4 a:hover,
            #buddypress .activity-item .activity-inner a:hover,
            #buddypress .acomment-options a:hover,
            #buddypress .activity-list li.load-more a:hover,
            #buddypress .activity-list li.load-newest a:hover,
            #buddypress.buddypress-list-activities .activity-header p a:first-child:hover,
            #buddypress.buddypress-list-groups ul.item-list li div.item-title a:hover{
			<?php echo esc_attr(implode(';', $buddy_press_link_hover_style)); ?>
            }
		<?php } ?>

		<?php

		$buddy_press_members_item_styles = array();
		$buddy_press_members_item_hover_styles = array();

		if(isset($mkd_options['buddy_press_members_item_background_color']) && $mkd_options['buddy_press_members_item_background_color'] !== '') {
			$buddy_press_members_item_styles[] = 'background-color: '.$mkd_options['buddy_press_members_item_background_color'];
		}

		if(isset($mkd_options['buddy_press_members_item_border_color']) && $mkd_options['buddy_press_members_item_border_color'] !== '') {
			$buddy_press_members_item_styles[] = 'border-color: '.$mkd_options['buddy_press_members_item_border_color'];
		}

		if(isset($mkd_options['buddy_press_members_item_border_width']) && $mkd_options['buddy_press_members_item_border_width'] !== '') {
			$buddy_press_members_item_styles[] = 'border-width: '.intval($mkd_options['buddy_press_members_item_border_width']).'px';
		}

		if(isset($mkd_options['buddy_press_members_item_border_radius']) && $mkd_options['buddy_press_members_item_border_radius'] !== '') {
			$buddy_press_members_item_styles[] = 'border-radius: '.intval($mkd_options['buddy_press_members_item_border_radius']).'px';
		}

		if(is_array($buddy_press_members_item_styles) && count($buddy_press_members_item_styles)) { ?>
            #buddypress.buddypress-list-activities ul.item-list li{
			<?php echo esc_attr(implode(';', $buddy_press_members_item_styles)); ?>
            }
		<?php } ?>
		<?php

		if(isset($mkd_options['buddy_press_members_item_background_color_hover']) && $mkd_options['buddy_press_members_item_background_color_hover'] !== '') {
			$buddy_press_members_item_hover_styles[] = 'background-color: '.$mkd_options['buddy_press_members_item_background_color_hover'];
		}

		if(isset($mkd_options['buddy_press_members_item_border_color_hover']) && $mkd_options['buddy_press_members_item_border_color_hover'] !== '') {
			$buddy_press_members_item_hover_styles[] = 'border-color: '.$mkd_options['buddy_press_members_item_border_color_hover'];
		}

		if(isset($mkd_options['buddy_press_members_item_border_right_color_hover']) && $mkd_options['buddy_press_members_item_border_right_color_hover'] !== '') {?>
            #buddypress.buddypress-list-activities ul.item-list li:hover:after{
            background-color: <?php echo esc_attr($mkd_options['buddy_press_members_item_border_right_color_hover']);?>
            }
            #buddypress.buddypress-list-activities ul.item-list li:hover{
            border-right-color: <?php echo esc_attr($mkd_options['buddy_press_members_item_border_right_color_hover']);?>
            }
			<?php
		}

		if(is_array($buddy_press_members_item_hover_styles) && count($buddy_press_members_item_hover_styles)) { ?>
            #buddypress.buddypress-list-activities ul.item-list li:hover{
			<?php echo esc_attr(implode(';', $buddy_press_members_item_hover_styles)); ?>
            }
		<?php } ?>

		<?php
		if(isset($mkd_options['qs_slider_preloader_background']) && $mkd_options['qs_slider_preloader_background'] !== '') {
			?>

            .mkd_slider_preloader,
            .mkd_slider .carousel,
            .full_screen_preloader,
            .vertical_split_slider_preloader{
            background-color: <?php echo esc_attr($mkd_options['qs_slider_preloader_background']); ?>;
            }
			<?php
		}
		?>

		<?php
		if(isset($mkd_options['vss_navigation_color']) && $mkd_options['vss_navigation_color'] !== '') {
			?>

            #multiscroll-nav span{
            border-color: <?php echo esc_attr($mkd_options['vss_navigation_color']); ?>;
            }
            #multiscroll-nav li .active span{
            background-color: <?php echo esc_attr($mkd_options['vss_navigation_color']); ?>;
            }
			<?php
		}
		?>
		<?php
		if(isset($mkd_options['vss_navigation_size']) && $mkd_options['vss_navigation_size'] !== '') {
			?>

            #multiscroll-nav li,
            #multiscroll-nav span{
            width: <?php echo esc_attr($mkd_options['vss_navigation_size']); ?>px;
            height: <?php echo esc_attr($mkd_options['vss_navigation_size']); ?>px;
            }
			<?php
		}
		?>

		<?php

		if(isset($mkd_options['vss_left_panel_size']) && $mkd_options['vss_left_panel_size'] !== '' && isset($mkd_options['vss_right_panel_size']) && $mkd_options['vss_right_panel_size'] !== '' && (intval($mkd_options['vss_left_panel_size']) + intval($mkd_options['vss_right_panel_size']) == 100)) {
			?>
            .ms-left {
            width: <?php echo esc_attr($mkd_options['vss_left_panel_size']); ?>% !important;
            }

            .ms-right {
            width: <?php echo esc_attr($mkd_options['vss_right_panel_size']); ?>% !important;
            }
			<?php
		}
		?>

		<?php
		$single_image_color = '';
		$single_image_transparency = '.85';
		if (isset($mkd_options['single_image_hover_color']) && $mkd_options['single_image_hover_color'] !== '') {
			if(isset($mkd_options['single_image_hover_transparency']) && $mkd_options['single_image_hover_transparency'] !== ''){
				$single_image_transparency = $mkd_options['single_image_hover_transparency'];
			}
			$single_image_color = mikado_one_mikado_hex2rgb($mkd_options['single_image_hover_color']); ?>

            .prettyphoto_container:hover span{
            background-color: rgba(<?php echo esc_attr($single_image_color[0]); ?>,<?php echo esc_attr($single_image_color[1]); ?>, <?php echo esc_attr($single_image_color[2]); ?>, <?php echo esc_attr($single_image_transparency) ?>);
            }
		<?php } ?>

		<?php if(isset($mkd_options['paspartu']) && $mkd_options['paspartu'] == 'yes') { ?>
			<?php if(isset($mkd_options['paspartu_color']) && $mkd_options['paspartu_color'] !== ''){?>
                .paspartu_outer,
                .paspartu_left,
                .paspartu_right,
                .paspartu_bottom,
                .paspartu_outer .mkd_slider,
                .paspartu_outer .content:not(.has_slider) .content_inner{
                background-color: <?php echo esc_attr($mkd_options['paspartu_color']); ?>;
                }
			<?php } ?>

			<?php if(isset($mkd_options['paspartu_width']) && $mkd_options['paspartu_width'] !== ''){?>
                .paspartu_outer,
                .paspartu_outer .content_wrapper{
                padding: 0 <?php echo esc_attr($mkd_options['paspartu_width']); ?>% <?php echo esc_attr($mkd_options['paspartu_width']); ?>% <?php echo esc_attr($mkd_options['paspartu_width']); ?>%;
                }

                .paspartu_outer .content:not(.has_slider) .content_inner{
                padding-top: <?php echo esc_attr($mkd_options['paspartu_width']); ?>%;
                }

                .paspartu_left,
                .paspartu_right{
                width: <?php echo esc_attr($mkd_options['paspartu_width']); ?>%;
                }

                header.paspartu_header_alignment .header_bottom{
                padding: 0px <?php echo esc_attr($mkd_options['paspartu_width']); ?>%;
                }

                @media only screen and (min-width: 1024px) {
                header.paspartu_header_alignment .header_inner_left{
                left: <?php echo esc_attr($mkd_options['paspartu_width']); ?>%;
                }
                }

			<?php } ?>
		<?php }


