<?php
/*
Template Name: Blog Masonry
*/
?>
<?php get_header(); ?>
<?php
$page_object = get_post( mikado_one_mikado_get_page_id() );
$mkd_content = $page_object->post_content;

$blog_content_position = "content_above_blog_list";
if(isset($mkd_options['blog_masonry_content_position'])){
	$blog_content_position = esc_attr($mkd_options['blog_masonry_content_position']);
}

$mikado_one_mikado_sidebar = mikado_one_mikado_get_sidebar_layout(false);

if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page_background_color", true) != ""){
	$background_color = 'background-color: '.get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page_background_color", true);
}else{
	$background_color = "";
}

$content_style = "";
if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_content-top-padding", true) != ""){
	if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_content-top-padding-mobile", true) == 'yes'){
		$content_style = "padding-top:".esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_content-top-padding", true))."px !important";
	}else{
		$content_style = "padding-top:".esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_content-top-padding", true))."px";
	}
}

if(isset($mkd_options['number_of_chars_masonry'])&& ($mkd_options['number_of_chars_masonry'] != "")) {
    mikado_one_mikado_set_blog_word_count(esc_attr($mkd_options['number_of_chars_masonry']));
}
$category_filter = "no";
if(isset($mkd_options['blog_masonry_filter'])){
	$category_filter = esc_attr($mkd_options['blog_masonry_filter']);
}

?>

	<?php if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page_scroll_amount_for_sticky", true)) { ?>
		<script>
		var page_scroll_amount_for_sticky = <?php echo esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page_scroll_amount_for_sticky", true)); ?>;
		</script>
	<?php } ?>
		<?php get_template_part( 'title' ); ?>

	<?php
		$revslider = get_post_meta(mikado_one_mikado_get_page_id(), "mkd_revolution-slider", true);
		if (!empty($revslider)){ ?>
			<div class="mkd_slider"><div class="mkd_slider_inner">
			<?php echo do_shortcode($revslider); ?>
			</div></div>
		<?php
		}
		?>
	<?php
		if(isset($mkd_options['blog_page_range']) && $mkd_options['blog_page_range'] != ""){
			$blog_page_range = esc_attr($mkd_options['blog_page_range']);
		} else{
			$blog_page_range = mikado_one_mikado_get_max_number_of_pages();
		}
	?>
	<div class="container"<?php mikado_one_mikado_style_attr($background_color); ?>>
		<div class="container_inner default_template_holder clearfix" <?php mikado_one_mikado_style_attr($content_style); ?>>
			<?php if(($mikado_one_mikado_sidebar == "default")||($mikado_one_mikado_sidebar == "")) : ?>
				<?php
					echo apply_filters( 'the_content', $mkd_content );
					get_template_part('templates/blog/blog', 'structure');
				?>
			<?php elseif($mikado_one_mikado_sidebar == "1" || $mikado_one_mikado_sidebar == "2"): ?>
				<?php
					if($blog_content_position != "content_above_blog_list"){
						echo apply_filters( 'the_content', $mkd_content );
					}
				?>
				<div class="<?php if($mikado_one_mikado_sidebar == "1"):?>two_columns_66_33<?php elseif($mikado_one_mikado_sidebar == "2") : ?>two_columns_75_25<?php endif; ?> clearfix grid2 background_color_sidebar">
					<div class="column1 content_left_from_sidebar">
						<div class="column_inner">
							<?php
								if($blog_content_position == "content_above_blog_list"){
									echo apply_filters( 'the_content', $mkd_content );
								}
								get_template_part('templates/blog/blog', 'structure');
							?>
						</div>
					</div>
					<div class="column2">
						<?php get_sidebar(); ?>
					</div>
				</div>
			<?php elseif($mikado_one_mikado_sidebar == "3" || $mikado_one_mikado_sidebar == "4"): ?>
				<?php
					if($blog_content_position != "content_above_blog_list"){
						echo apply_filters( 'the_content', $mkd_content );
					}
				?>
				<div class="<?php if($mikado_one_mikado_sidebar == "3"):?>two_columns_33_66<?php elseif($mikado_one_mikado_sidebar == "4") : ?>two_columns_25_75<?php endif; ?> grid2 clearfix background_color_sidebar">
					<div class="column1">
						<?php get_sidebar(); ?>
					</div>
					<div class="column2 content_right_from_sidebar">
						<div class="column_inner">
							<?php
								if($blog_content_position == "content_above_blog_list"){
									echo apply_filters( 'the_content', $mkd_content );
								}
								get_template_part('templates/blog/blog', 'structure');
							?>
						</div>
					</div>
				</div>
				<?php endif; ?>
		</div>
	</div>
<?php get_footer(); ?>