<?php

class MkdPortfolioListShortcode {
    public function __construct() {
        add_shortcode('no_portfolio_list', array($this, 'render'));
        add_action('vc_before_init', array($this, 'vcMap'));
    }

    public function vcMap() {
        if(function_exists('vc_map')) {
            vc_map( array(
                "name" => "Portfolio List",
                "base" => "no_portfolio_list",
                "category" => 'by MIKADO',
                "icon" => "icon-wpb-portfolio",
                "allowed_container_element" => 'vc_row',
                "params" => array(
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Portfolio List Template",
                        "param_name" => "type",
                        "value" => array(
                            "Standard" => "standard",
                            "Standard No Space" => "standard_no_space",
                            "Text on Image Hover" => "text_on_hover_image",
                            "Text on Image Hover (No Space)" => "text_on_hover_image_no_space",
                            "Text Initially Over Image" => "text_before_hover",
                            "Text Initially Over Image (No Space)" => "text_before_hover_no_space",
                            "Masonry" => "masonry",
                            "Pinterest" => "masonry_with_space"
                        ),
                        "description" => ""
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Hover Animation Type",
                        "param_name" => "hover_type_standard",
                        "value" => array(
                            "Gradient" => "gradient_hover",
                            "Upward" => "upward_hover",
                            "Opposite Corners" => "opposite_corners_hover",
                            "Slide from left" => "slide_from_left_hover",
                            "Subtle Vertical" => "subtle_vertical_hover",
                            "Image Subtle Rotate Zoom" => "image_subtle_rotate_zoom_hover",
                            "Image Text Zoom" => "image_text_zoom_hover"
                        ),
                        "dependency" => array('element' => "type", 'value' => array('standard', 'standard_no_space', 'masonry_with_space'))
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Hover Animation Type",
                        "param_name" => "hover_type_text_on_hover_image",
                        "value" => array(
                            "Upward" => "upward_hover",
                            "Opposite Corners" => "opposite_corners_hover",
                            "Slide from left" => "slide_from_left_hover",
                            "Subtle Vertical" => "subtle_vertical_hover",
                            "Image Subtle Rotate Zoom" => "image_subtle_rotate_zoom_hover",
                            "Image Text Zoom" => "image_text_zoom_hover",
                            "Cursor Change" => "cursor_change_hover",
                            "Slide Up" => "slide_up_hover"
                        ),
                        "dependency" => array('element' => "type", 'value' => array('text_on_hover_image', 'text_on_hover_image_no_space'))
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Hover Animation Type",
                        "param_name" => "hover_type_text_before_hover",
                        "value" => array(
                            "Gradient" => "gradient_hover",
                            "Prominent Plain" => "prominent_plain_hover",
                            "Prominent Blur" => "prominent_blur_hover"
                        ),
                        "dependency" => array('element' => "type", 'value' => array('text_before_hover', 'text_before_hover_no_space'))
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Hover Animation Type",
                        "param_name" => "hover_type_masonry",
                        "value" => array(
                            "Gradient" => "gradient_hover",
                            "Upward" => "upward_hover",
                            "Opposite Corners" => "opposite_corners_hover",
                            "Slide from left" => "slide_from_left_hover",
                            "Subtle Vertical" => "subtle_vertical_hover",
                            "Image Subtle Rotate & Zoom" => "image_subtle_rotate_zoom_hover",
                            "Image & Text Zoom" => "image_text_zoom_hover",
                            "Prominent Plain" => "prominent_plain_hover",
                            "Prominent Blur" => "prominent_blur_hover",
                            "Cursor Change" => "cursor_change_hover",
                            "Slide Up" => "slide_up_hover"
                        ),
                        "dependency" => array('element' => "type", 'value' => array('masonry'))
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Info Box Hover Color",
                        "param_name" => "hover_box_color_standard",
                        "value" => "",
                        "description" => "",
                        "dependency" => array('element' => "hover_type_standard", 'value' => array('upward_hover','slide_from_left_hover'))
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Info Box Hover Color",
                        "param_name" => "hover_box_color_text_on_hover_image",
                        "value" => "",
                        "description" => "",
                        "dependency" => array('element' => "hover_type_text_on_hover_image", 'value' => array('upward_hover','slide_from_left_hover'))
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Info Box Hover Color",
                        "param_name" => "hover_box_color_masonry",
                        "value" => "",
                        "description" => "",
                        "dependency" => array('element' => "hover_type_masonry", 'value' => array('upward_hover','slide_from_left_hover'))
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Gradient Position Before Hover",
                        "param_name" => "gradient_position_standard",
                        "value" => "",
                        "description" => 'Enter position pixels or percentages. Ex. "30px" or "30%. Default value is 30%."',
                        "dependency" => array('element' => "hover_type_standard", 'value' => array('gradient_hover'))
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Gradient Position Before Hover",
                        "param_name" => "gradient_position_text_before_hover",
                        "value" => "",
                        "description" => 'Enter position pixels or percentages. Ex. "30px" or "30%. Default value is 30%."',
                        "dependency" => array('element' => "hover_type_text_before_hover", 'value' => array('gradient_hover'))
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Gradient Position Before Hover",
                        "param_name" => "gradient_position_masonry",
                        "value" => "",
                        "description" => 'Enter position pixels or percentages. Ex. "30px" or "30%. Default value is 30%."',
                        "dependency" => array('element' => "hover_type_masonry", 'value' => array('gradient_hover'))
                    ),
                    array(
                        "type" => "dropdown",
                        "class" => "",
                        "heading" => "Info Box Text Alignment",
                        "param_name" => "text_align",
                        "value" => array(
                            ""   => "",
                            "Left" => "left",
                            "Center" => "center",
                            "Right" => "right"
                        ),
                        "description" => "Note: Info Box, containing Portfolio Title (and Categories), is placed under Portfolio Image",
                        "dependency" => array('element' => 'type', 'value' => array('standard', 'standard_no_space', 'masonry_with_space'))
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Info Box Background Color",
                        "param_name" => "box_background_color",
                        "value" => "",
                        "description" => "",
                        "dependency" => array('element' => "type", 'value' => array('standard','standard_no_space', 'masonry_with_space'))
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Info Box Border",
                        "param_name" => "box_border",
                        "value" => array(
                            "Default" => "",
                            "No" => "no",
                            "Yes" => "yes"
                        ),
                        "description" => "",
                        "dependency" => array('element' => "type", 'value' => array('standard','standard_no_space', 'masonry_with_space'))
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Info Box Border Width (px)",
                        "param_name" => "box_border_width",
                        "value" => "",
                        "description" => "",
                        "dependency" => array('element' => "box_border", 'value' => array('yes'))
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Box Border Color",
                        "param_name" => "box_border_color",
                        "value" => "",
                        "description" => "",
                        "dependency" => array('element' => "box_border", 'value' => array('yes'))
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Image Color Overlay",
                        "param_name" => "overlay_background_color",
                        "value" => "",
                        "description" => "Disabled on Upward Hover",
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Number of Columns",
                        "param_name" => "columns",
                        "value" => array(
                            "" => "",
                            "1" => "1",
                            "2" => "2",
                            "3" => "3",
                            "4" => "4",
                            "5" => "5",
                            "6" => "6"
                        ),
                        "description" => "",
                        "save_always" => true,
                        "dependency" => array('element' => "type", 'value' => array('standard','standard_no_space','text_on_hover_image','text_on_hover_image_no_space', 'text_before_hover','text_before_hover_no_space','masonry_with_space'))
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Load portfolios one by one",
                        "param_name" => "portfolio_one_by_one",
                        "value" => array(
                            "" => "",
                            "Yes" => "yes",
                            "No" => "no"
                        ),
                        "description" => "",
                        "dependency" => array('element' => "type", 'value' => array('standard','standard_no_space','text_on_hover_image','text_on_hover_image_no_space', 'text_before_hover','text_before_hover_no_space'))
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Image Proportions",
                        "param_name" => "image_size",
                        "value" => array(
                            "Default Size" => "",
                            "Original" => "full",
                            "Square" => "square",
                            "Landscape" => "landscape",
                            "Portrait" => "portrait"
                        ),
                        "description" => "",
                        "dependency" => array('element' => "type", 'value' => array('standard','standard_no_space','text_on_hover_image','text_on_hover_image_no_space', 'text_before_hover','text_before_hover_no_space'))
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Order By",
                        "param_name" => "order_by",
                        "value" => array(
                            "" => "",
                            "Menu Order" => "menu_order",
                            "Title" => "title",
                            "Date" => "date"
                        ),
                        "description" => ""
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Order",
                        "param_name" => "order",
                        "value" => array(
                            "" => "",
                            "ASC" => "ASC",
                            "DESC" => "DESC",
                        ),
                        "description" => ""
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Enable Category Filter",
                        "param_name" => "filter",
                        "value" => array(
                            "" => "",
                            "Yes" => "yes",
                            "No" => "no"
                        ),
                        "description" => "Default value is No"
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Disable Filter Title",
                        "param_name" => "disable_filter_title",
                        "value" => array(
                            "" => "",
                            "Yes" => "yes",
                            "No" => "no"
                        ),
                        "description" => "Default value is Yes",
                        "dependency" => array('element' => "filter", 'value' => array('yes'))
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Filter Order By",
                        "param_name" => "filter_order_by",
                        "value" => array(
                            "Name"  => "name",
                            "Count" => "count",
                            "Id"    => "id",
                            "Slug"  => "slug"
                        ),
                        "description" => "Default value is Name",
                        "dependency" => array('element' => "filter", 'value' => array('yes'))
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Horizontal Filter Positioning",
                        "param_name" => "filter_align",
                        "value" => array(
                            "Left" => "left_align",
                            "Center" => "center_align",
                            "Right" => "right_align"
                        ),
                        "dependency" => array('element' => "filter", 'value' => array('yes'))
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Enable Icons on Portfolio Image",
                        "param_name" => "show_icons",
                        "value" => array(
                            "Yes" => "yes",
                            "No" => "no"
                        ),
                        "description" => "Note: Icons will always be disable if you enable 'Cursor Change' as Hover Animation"
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Show Link Icon",
                        "param_name" => "link_icon",
                        "value" => array(
                            "" => "",
                            "Yes" => "yes",
                            "No" => "no"
                        ),
                        "description" => "Default value is Yes",
                        "dependency" => array('element' => "show_icons", 'value' => array('yes'))
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Show Lightbox Icon",
                        "param_name" => "lightbox",
                        "value" => array(
                            "" => "",
                            "Yes" => "yes",
                            "No" => "no"
                        ),
                        "description" => "Default value is Yes",
                        "dependency" => array('element' => "show_icons", 'value' => array('yes'))
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Show Like Icon",
                        "param_name" => "show_like",
                        "value" => array(
                            "" => "",
                            "Yes" => "yes",
                            "No" => "no"
                        ),
                        "description" => "Default value is Yes",
                        "dependency" => array('element' => "show_icons", 'value' => array('yes'))
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Show Title",
                        "param_name" => "show_title",
                        "value" => array(
                            "" => "",
                            "Yes" => "yes",
                            "No" => "no"
                        ),
                        "description" => ""
                    ),
                    array(
                        "type" => "dropdown",
                        "class" => "",
                        "heading" => "Title Tag",
                        "param_name" => "title_tag",
                        "value" => array(
                            ""   => "",
                            "h2" => "h2",
                            "h3" => "h3",
                            "h4" => "h4",
                            "h5" => "h5",
                            "h6" => "h6",
                        ),
                        "description" => "",
                        "dependency" => array('element' => "show_title", 'value' => array('yes'))
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Title Color",
                        "param_name" => "title_color",
                        "value" => "",
                        "description" => "",
                        "dependency" => array('element' => "show_title", 'value' => array('yes'))
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Title Font Size (px)",
                        "param_name" => "title_font_size",
                        "value" => "",
                        "dependency" => array('element' => "show_title", 'value' => array('yes'))
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Disable Link On Title",
                        "param_name" => "disable_link_on_title",
                        "value" => array(
                            "No" => "no",
                            "Yes" => "yes"
                        ),
                        "description" => "",
                        "dependency" => array('element' => "show_title", 'value' => array('yes'))
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Disable Portfolio Image Link",
                        "param_name" => "disable_link",
                        "value" => array(
                            "" => "",
                            "Yes" => "yes",
                            "No" => "no"
                        ),
                        "description" => "Note: Image link will always be disabled if you enable icons in: 'Subtle Vertical', 'Image Subtle Rotate & Zoom', 'Image & Text Zoom' and 'Slide Up' hover animation type",
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Show Separator",
                        "param_name" => "separator",
                        "value" => array(
                            "" => "",
                            "Yes" => "yes",
                            "No" => "no"
                        ),
                        "description" => "",
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Separator Thickness (px)",
                        "param_name" => "separator_thickness",
                        "description" => "",
                        "dependency" => array('element' => "separator", 'value' => array('yes'))
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Separator Color",
                        "param_name" => "separator_color",
                        "value" => "",
                        "description" => "",
                        "dependency" => array('element' => "separator", 'value' => array('yes'))
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Animate Separator",
                        "param_name" => "separator_animation",
                        "value" => array(
                            "" => "",
                            "Yes" => "yes",
                            "No" => "no"
                        ),
                        "description" => "",
                        "dependency" => array('element' => "separator", 'value' => array('yes'))
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Show Category Names",
                        "param_name" => "show_categories",
                        "value" => array(
                            "Yes" => "yes",
                            "No" => "no"
                        ),
                        "description" => "Default value is Yes",
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Category Name Color",
                        "param_name" => "category_color",
                        "value" => "",
                        "description" => "",
                        "dependency" => array('element' => "show_categories", 'value' => array('yes'))
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "One-Category Portfolio List",
                        "param_name" => "category",
                        "value" => "",
                        "description" => "Enter one category slug (leave empty for showing all categories)"
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Show Load More",
                        "param_name" => "show_load_more",
                        "value" => array(
                            "" => "",
                            "Yes" => "yes",
                            "No" => "no"
                        ),
                        "description" => "Default value is Yes",
                        "dependency" => array('element' => "type", 'value' => array('standard','standard_no_space','text_on_hover_image','text_on_hover_image_no_space', 'text_before_hover','text_before_hover_no_space','masonry_with_space'))
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Load More Button Margin (px)",
                        "param_name" => "load_more_margin",
                        "value" => "",
                        "description" =>  esc_html__("Please insert top margin for load more button", 'mikado1'),
                        "dependency" => array('element' => "show_load_more", 'value' => array('yes',''))
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Number of Portfolios Per Page",
                        "param_name" => "number",
                        "value" => "-1",
                        "description" => "(enter -1 to show all)",
                        "dependency" => array('element' => "type", 'value' => array('standard','standard_no_space','text_on_hover_image','text_on_hover_image_no_space', 'text_before_hover','text_before_hover_no_space','masonry','masonry_with_space'))
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Show Only Projects with Listed IDs",
                        "param_name" => "selected_projects",
                        "value" => "",
                        "description" => "Delimit ID numbers by comma (leave empty for all)"
                    )
                )
            ) );
        }


    }

    public function render($atts, $content = null) {
        global $wp_query;
        global $mkd_options;
        $portfolio_mkd_like = "on";
        if (isset($mkd_options['portfolio_mkd_like'])) {
            $portfolio_mkd_like = esc_attr($mkd_options['portfolio_mkd_like']);
        }

        $portfolio_filter_class = "";
        if (isset($mkd_options['portfolio_filter_disable_separator']) && !empty($mkd_options['portfolio_filter_disable_separator'])) {
            if($mkd_options['portfolio_filter_disable_separator'] == "yes"){
                $portfolio_filter_class = "without_separator";
            } else {
                $portfolio_filter_class = "";
            }
        }

        $args = array(
            "type"                              => "standard",
            "hover_type_standard"               => "gradient_hover",
            "hover_type_text_on_hover_image"    => "upward_hover",
            "hover_type_text_before_hover"      => "gradient_hover",
            "hover_type_masonry"                => "gradient_hover",
            "box_border"                        => "",
            "box_background_color"              => "",
            "box_border_color"                  => "",
            "box_border_width"                  => "",
            "hover_box_color_standard"          => "",
            "hover_box_color_text_on_hover_image"  => "",
            "hover_box_color_masonry"           => "",
            "gradient_position_standard"         => "",
            "gradient_position_text_before_hover"=> "",
            "gradient_position_masonry"          => "",
            "overlay_background_color"          => "",
            "columns"                           => "3",
            "image_size"                        => "",
            "order_by"                          => "menu_order",
            "order"                             => "ASC",
            "number"                            => "-1",
            "filter"                            => "no",
            "disable_filter_title"              => "yes",
            "filter_order_by"                   => "name",
            "filter_align"                      => "left_align",
            "show_icons"                        => "yes",
            "link_icon"                         => "yes",
            "lightbox"                          => "yes",
            "show_like"                         => "yes",
            "disable_link"                      => "no",
            "show_categories"                   => "yes",
            "category_color"                    => "",
            "category"                          => "",
            "separator"                         => "",
            "separator_thickness"               => "",
            "separator_color"                   => "",
            "separator_animation"               => "",
            "selected_projects"                 => "",
            "show_load_more"                    => "yes",
            "load_more_margin"                  => "",
            "show_title"                        => "yes",
            "title_tag"                         => "h4",
            "title_font_size"                   => "",
            "title_color"                       => "",
            "disable_link_on_title"             => "",
            "text_align"                        => "",
            "portfolio_one_by_one"				=> "yes"
        );

        extract(shortcode_atts($args, $atts));

        $type = esc_attr($type);
        $hover_type_standard = esc_attr($hover_type_standard);
        $hover_type_text_on_hover_image = esc_attr($hover_type_text_on_hover_image);
        $hover_type_text_before_hover = esc_attr($hover_type_text_before_hover);
        $hover_type_masonry = esc_attr($hover_type_masonry);
        $box_border = esc_attr($box_border);
        $box_background_color = esc_attr($box_background_color);
        $box_border_color = esc_attr($box_border_color);
        $box_border_width = esc_attr($box_border_width);
        $hover_box_color_standard = esc_attr($hover_box_color_standard);
        $hover_box_color_text_on_hover_image = esc_attr($hover_box_color_text_on_hover_image);
        $hover_box_color_masonry = esc_attr($hover_box_color_masonry);
        $gradient_position_standard = esc_attr($gradient_position_standard);
        $gradient_position_text_before_hover = esc_attr($gradient_position_text_before_hover);
        $gradient_position_masonry = esc_attr($gradient_position_masonry);
        $overlay_background_color = esc_attr($overlay_background_color);
        $columns = esc_attr($columns);
        $image_size = esc_attr($image_size);
        $order_by = esc_attr($order_by);
        $order = esc_attr($order);
        $number = esc_attr($number);
        $filter = esc_attr($filter);
        $disable_filter_title = esc_attr($disable_filter_title);
        $filter_order_by = esc_attr($filter_order_by);
        $filter_align = esc_attr($filter_align);
        $show_icons = esc_attr($show_icons);
        $link_icon = esc_attr($link_icon);
        $lightbox = esc_attr($lightbox);
        $show_like = esc_attr($show_like);
        $disable_link = esc_attr($disable_link);
        $show_categories = esc_attr($show_categories);
        $category_color = esc_attr($category_color);
        $category = esc_attr($category);
        $separator = esc_attr($separator);
        $separator_thickness = esc_attr($separator_thickness);
        $separator_color = esc_attr($separator_color);
        $separator_animation = esc_attr($separator_animation);
        $selected_projects = esc_attr($selected_projects);
        $show_load_more = esc_attr($show_load_more);
        $load_more_margin = esc_attr($load_more_margin);
        $show_title = esc_attr($show_title);
        $title_tag = esc_attr($title_tag);
        $title_font_size = esc_attr($title_font_size);
        $title_color = esc_attr($title_color);
        $disable_link_on_title  =esc_attr($disable_link_on_title);
        $text_align = esc_attr($text_align);
        $portfolio_one_by_one = esc_attr($portfolio_one_by_one);

        $headings_array = array('h2', 'h3', 'h4', 'h5', 'h6');

        //get correct heading value. If provided heading isn't valid get the default one
        $title_tag = (in_array($title_tag, $headings_array)) ? $title_tag : $args['title_tag'];

        $html = "";

        // adding correct classes
        $_type_class = '';
        $_portfolio_space_class = '';
        $_portfolio_masonry_with_space_class = '';
        if ($type == "text_on_hover_image"|| $type == "text_before_hover") {
            $_type_class = " hover_text";
            $_portfolio_space_class = "portfolio_with_space portfolio_with_hover_text";
        } elseif ($type == "standard" || $type == "masonry_with_space"){
            $_type_class = " standard";
            $_portfolio_space_class = "portfolio_with_space portfolio_standard";
            if($type == "masonry_with_space"){
	            $_portfolio_masonry_with_space_class = ' masonry_with_space';
            }
        } elseif ($type == "standard_no_space"){
            $_type_class = " standard_no_space";
            $_portfolio_space_class = "portfolio_no_space portfolio_standard";
        } elseif ($type == "text_on_hover_image_no_space" || $type == "text_before_hover_no_space"){
            $_type_class = " hover_text no_space";
            $_portfolio_space_class = "portfolio_no_space portfolio_with_hover_text";
        }

        $portfolio_one_by_one_class = '';
        if($portfolio_one_by_one == 'yes' && (!in_array($type, array('masonry_with_space', 'masonry_without_space'))) ) {
            $portfolio_one_by_one_class = 'portfolio_one_by_one';
        }

        // adding hover type
        $hover_type = "";
        if($type == 'standard' || $type == 'standard_no_space' || $type == 'masonry_with_space'){
            $hover_type = $hover_type_standard;
        }
        if($type == 'text_on_hover_image' || $type == 'text_on_hover_image_no_space'){
            $hover_type = $hover_type_text_on_hover_image;
        }
        if($type == 'text_before_hover' || $type == 'text_before_hover_no_space'){
            $hover_type = $hover_type_text_before_hover;
        }
        if($type == 'masonry'){
            $hover_type = $hover_type_masonry;
        }

        $disable_text_holder = '';
        // disable text holder if there is no any element
        if ($show_title == 'no' && $separator == 'no' && $show_categories == 'no'){
            $disable_text_holder = 'yes';
        }

        // for this type holder needs to be shown
        if ($hover_type == 'slide_from_left_hover' && $show_icons == 'no'){
            $show_icons = 'yes';
            $link_icon = 'no';
            $lightbox = 'no';
            $show_like = 'no';
        }

        // disable link if icons are shown for these hover type
        if (($hover_type == 'subtle_vertical_hover' || $hover_type == 'image_subtle_rotate_zoom_hover' || $hover_type == 'image_text_zoom_hover' || $hover_type == 'slide_up_hover') && $show_icons == 'yes'){
            $disable_link = "yes";
        }

        // disable icons on this hover type
        if ($hover_type == 'cursor_change_hover'){
            $show_icons = "no";
        }

        // adding element style and class
        $separator_animation_class = "";
        if($separator_animation == 'yes'){
            $separator_animation_class = "animate";
        }

        $separator_style = "";
        if($separator_color != '' || $separator_thickness != ''){
            $separator_style = 'style="';
            if($separator_color != ''){
                $separator_style .= 'background-color: '. esc_attr($separator_color) .';';
            }
            if($separator_thickness != ''){
                $valid_height = (strstr($separator_thickness, 'px', true)) ? $separator_thickness : $separator_thickness . "px";
                $separator_style .= 'height: '. esc_attr($valid_height) .';';
            }
            $separator_style .= '"';
        }

        $gradient_position = '';
        if($hover_type == "gradient_hover") {
            if (($type == 'standard' || $type == 'standard_no_space' || $type == 'masonry_with_space') && $gradient_position_standard != '') {
                $gradient_position = $gradient_position_standard;
            } elseif (($type == 'text_before_hover' || $type == 'text_before_hover_no_space') && $gradient_position_text_before_hover != '') {
                $gradient_position = $gradient_position_text_before_hover;
            } elseif ($type == 'masonry' && $gradient_position_masonry != '') {
                $gradient_position = $gradient_position_masonry;
            }
        }

        $portfolio_shader_style = "";
        if($overlay_background_color != '' || $gradient_position != ''){
            if($hover_type == "gradient_hover"){
                if(substr( $overlay_background_color, 0, 3 ) === "rgba"){ // if rgba is set, portfolio uses default color
                    $portfolio_shader_style = '';
                }
                else{

                    $rgb = mikado_one_mikado_hex2rgb($overlay_background_color);

                    $opacity = 0;
                    $overlay_background_color1 = 'rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].','. esc_attr($opacity) .')';
                    $opacity = 0.9;
                    $overlay_background_color2 = 'rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].','. esc_attr($opacity) .')';

                    $portfolio_shader_style = 'style="';

                    $portfolio_shader_style .= 'background: -webkit-linear-gradient(to bottom, '.$overlay_background_color1.' 10%, '.$overlay_background_color2.' 100%);';
                    $portfolio_shader_style .= 'background: linear-gradient(to bottom, '.$overlay_background_color1.' 10%, '.$overlay_background_color2.' 100%);';

                    if($gradient_position != '') {
                        $portfolio_shader_style .= 'transform: translate3d(0px, ' . esc_attr($gradient_position) . ', 0px);';
                    }

                    $portfolio_shader_style .= '"';
                }
            }
            elseif($hover_type == "upward_hover"){
                // disabled
            }
            else{
                $portfolio_shader_style = 'style="background-color:'. esc_attr($overlay_background_color) .';"';
            }

        }

        $title_style = '';
        $title_link_style = ''; // with or without 'a' tag
        if ($title_font_size != "" || $title_color != "") {
            $title_link_style .= 'style="';
            $title_style .= 'style="';
            if ($title_font_size != "") {
                $title_style .= 'font-size: ' . esc_attr($title_font_size) . 'px;';
                $title_link_style .= 'font-size: inherit;';
            }
            if ($title_color != "") {
                $title_style .= 'color: ' . esc_attr($title_color) . ';';
                $title_link_style .= 'color: inherit;';
            }
            $title_style .= '"';
            $title_link_style .= '"';
        }

        $category_style = '';
        if($category_color != ''){
            $category_style = 'style="color: '. esc_attr($category_color) .';"';
        }

        $hover_box_style = "";
        if($hover_type == 'upward_hover' || $hover_type == 'slide_from_left_hover'){
            if(($type == 'standard' || $type == 'standard_no_space') && $hover_box_color_standard != ''){
                $hover_box_style = 'style="background-color:'. esc_attr($hover_box_color_standard) .';"';
            }
            elseif(($type == 'text_on_hover_image' || $type == 'text_on_hover_image_no_space') && $hover_box_color_text_on_hover_image != ''){
                $hover_box_style = 'style="background-color:'. esc_attr($hover_box_color_text_on_hover_image) .';"';
            }
            elseif(($type == 'masonry') && $hover_box_color_masonry != ''){
                $hover_box_style = 'style="background-color:'. esc_attr($hover_box_color_masonry) .';"';
            }
        }

        $show_more_style = '';
        if($load_more_margin != ''){
            $load_more_margin = (strstr($load_more_margin, 'px', true)) ? $load_more_margin : $load_more_margin . "px";
            $show_more_style .= 'style="margin-top:'. esc_attr($load_more_margin) .'"';
        }

        $portfolio_box_style = "";
        $portfolio_description_class = "";
        if($box_border == "yes" || $box_background_color != ""){

            $portfolio_box_style .= ' style="';
            if($box_border == "yes"){
                $portfolio_box_style .= "border-style:solid;";
                if($box_border_color != "" ){
                    $portfolio_box_style .= "border-color:" . esc_attr($box_border_color) . ";";
                }
                if($box_border_width != "" ){
                    $portfolio_box_style .= "border-width:" . esc_attr($box_border_width) . "px;";
                } else {
                    $portfolio_box_style .= "border-width: 1px;";
                }
            }
            if($box_background_color != ""){
                $portfolio_box_style .= "background-color:" . esc_attr($box_background_color) . ";";
            }
            $portfolio_box_style .= '"';

            $portfolio_description_class .= ' with_padding';

            $_portfolio_space_class = ' with_description_background';

        }

        if($text_align !== '') {
            $portfolio_description_class .= ' text_align_'.$text_align;
        }

        //get proper image size
        switch($image_size) {
            case 'landscape':
                $thumb_size = 'mikado-portfolio-landscape';
                break;
            case 'portrait':
                $thumb_size = 'mikado-portfolio-portrait';
                break;
            case 'square':
                $thumb_size = 'mikado-portfolio-square';
                break;
            case 'full':
                $thumb_size = 'full';
                break;
            default:
                $thumb_size = 'full';
                break;
        }

        if($type == "masonry_with_space"){
            $thumb_size = 'mikado-portfolio-masonry-with-space';
        }

        // printing html

        if($type != 'masonry') {

            // adding filter on project holder
            $html .= "<div class='projects_holder_outer v$columns $_portfolio_space_class $_portfolio_masonry_with_space_class'>";
            if ($filter == "yes") {
                $html .= "<div class='filter_outer filter_portfolio ". esc_attr($filter_align) ."'>";
                $html .= "<div class='filter_holder ". esc_attr($portfolio_filter_class) ."'><ul>";
                if($disable_filter_title != "yes"){
                    $html .= "<li class='filter_title'><span>".esc_html__('Sort Portfolio:','mikado1')."</span></li>";
                }
                if($type == 'masonry_with_space'){
                    $html .= "<li class='filter' data-filter='*'><span>" . esc_html__('All','mikado1') . "</span></li>";
                } else {
                    $html .= "<li class='filter' data-filter='all'><span>" . esc_html__('All','mikado1') . "</span></li>";
                }

                if ($category == "") {
                    $args = array(
                        'parent' => 0,
                        'orderby' => $filter_order_by
                    );
                    $portfolio_categories = get_terms('portfolio_category', $args);
                } else {
                    $top_category = get_term_by('slug', $category, 'portfolio_category');
                    $term_id = '';
                    if (isset($top_category->term_id))
                        $term_id = $top_category->term_id;
                    $args = array(
                        'parent' => $term_id,
                        'orderby' => $filter_order_by
                    );
                    $portfolio_categories = get_terms('portfolio_category', $args);
                }
                foreach ($portfolio_categories as $portfolio_category) {
                    if($type == 'masonry_with_space'){
                        $html .= "<li class='filter' data-filter='.portfolio_category_" . esc_attr($portfolio_category->term_id) . "'><span>" . esc_html($portfolio_category->name) . "</span>";
                    } else {
                        $html .= "<li class='filter' data-filter='portfolio_category_" . esc_attr($portfolio_category->term_id) . "'><span>" . esc_html($portfolio_category->name) . "</span>";
                    }
                    $args = array(
                        'child_of' => $portfolio_category->term_id
                    );
                    $html .= '</li>';
                }
                $html .= "</ul></div>";
                $html .= "</div>";
            }

            $html .= "<div class='portfolio_main_holder projects_holder clearfix v$columns$_type_class $portfolio_one_by_one_class'>\n";
            if (get_query_var('paged')) {
                $paged = get_query_var('paged');
            } elseif (get_query_var('page')) {
                $paged = get_query_var('page');
            } else {
                $paged = 1;
            }
            if ($category == "") {
                $args = array(
                    'post_type' => 'portfolio_page',
                    'orderby' => $order_by,
                    'order' => $order,
                    'posts_per_page' => $number,
                    'paged' => $paged
                );
            } else {
                $args = array(
                    'post_type' => 'portfolio_page',
                    'portfolio_category' => $category,
                    'orderby' => $order_by,
                    'order' => $order,
                    'posts_per_page' => $number,
                    'paged' => $paged
                );
            }
            $project_ids = null;
            if ($selected_projects != "") {
                $project_ids = explode(",", $selected_projects);
                $args['post__in'] = $project_ids;
            }
            query_posts($args);

            // loop start
            if (have_posts()) : while (have_posts()) : the_post();
                $terms = wp_get_post_terms(get_the_ID(), 'portfolio_category');
                $html .= "<article class='mix ";
                foreach ($terms as $term) {
                    $html .= "portfolio_category_$term->term_id ";
                }

                $title = get_the_title();
                $featured_image_array = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full'); //original size

                if(get_post_meta(get_the_ID(), 'mkd_portfolio-lightbox-link', true) != ""){
                    $large_image = esc_url(get_post_meta(get_the_ID(), 'mkd_portfolio-lightbox-link', true));
                } else {
                    $large_image = $featured_image_array[0];
                }

                $slug_list_ = "pretty_photo_gallery";

                $custom_portfolio_link = esc_url(get_post_meta(get_the_ID(), 'mkd_portfolio-external-link', true));
                $portfolio_link = $custom_portfolio_link != "" ? $custom_portfolio_link : get_permalink();
                $target = $custom_portfolio_link != "" ? '_blank' : '_self';

                $html .="'>";  //article

                // get categories for specific article
                $category_html = "";
                /*$category_html .= '<span>'. esc_html__('In ','mikado1') .'</span>';*/
                $k = 1;
                foreach ($terms as $term) {
                    $category_html .= "$term->name";
                    if (count($terms) != $k) {
                        $category_html .= ' / ';
                    }
                    $k++;
                }

                $html .= '<div class="item_holder '. esc_attr($hover_type) .'">';

                switch($hover_type) {
                    case 'gradient_hover':
                    case 'upward_hover':
                    case 'subtle_vertical_hover':
                    case 'image_subtle_rotate_zoom_hover':
                    case 'slide_up_hover':
                    case 'cursor_change_hover':
                    case 'image_text_zoom_hover': {
                        if($disable_text_holder != 'yes' || $show_icons == 'yes'){
                            $html .= '<div class="text_holder" '.esc_html($hover_box_style).'>';
                            $html .= '<div class="text_holder_outer">';
                            $html .= '<div class="text_holder_inner">';
                            if($type == 'text_on_hover_image' || $type == 'text_on_hover_image_no_space' || $type == 'text_before_hover' || $type == 'text_before_hover_no_space'){
                                if($show_title == 'yes') {
                                    if($disable_link_on_title != "yes") {
                                        $html .= '<' . esc_html($title_tag) . ' class="portfolio_title" ' . esc_attr($title_style) . '><a href="' . esc_url($portfolio_link) . '" ' . esc_attr($title_link_style) . '>' . get_the_title() . '</a></' . esc_html($title_tag) . '>';
                                    }
                                    else{
                                        $html .= '<'.esc_html($title_tag).' class="portfolio_title" '. esc_attr($title_style).'>' . get_the_title() . '</'.esc_html($title_tag).'>';
                                    }
                                }
                                if($separator == 'yes'){
                                    $html .= '<span class="separator '.esc_attr($separator_animation_class).'" '.esc_attr($separator_style).'></span>';
                                }
                                if($show_categories == 'yes'){
                                    $html .= '<span class="project_category" '.esc_attr($category_style).'>'.esc_html($category_html).'</span>';
                                }
                            }
                            if($show_icons == 'yes'){
                                $html .= '<div class="icons_holder">';
                                if ($lightbox == "yes") {
                                    $html .= '<a class="portfolio_lightbox" title="'.esc_attr($title).'" href="' . esc_url($large_image) . '" data-rel="prettyPhoto[' . esc_attr($slug_list_) . ']" rel="prettyPhoto[' . esc_attr($slug_list_) . ']"></a>';
                                }
                                if ($portfolio_mkd_like == "on" && $show_like == "yes") {
                                    if (function_exists('mkd_like_portfolio_list')) {
                                        $html .= mkd_like_portfolio_list(get_the_ID());
                                    }
                                }
                                if ($link_icon == "yes") {
                                    $html .= '<a class="preview" title="' . esc_attr__( 'Go to Project', 'mikado1' ) . '"  href="' . esc_url($portfolio_link) . '" data-type="portfolio_list" target="' . esc_attr($target) . '" ></a>';
                                }
                                $html .= '</div>'; // icons_holder
                            }
                            $html .= '</div>'; // text_holder_inner
                            $html .= '</div>';  // text_holder_outer
                            $html .= '</div>'; // text_holder
                        }
                    }
                        break;
                    case 'opposite_corners_hover':
                    case 'slide_from_left_hover':
                    case 'prominent_plain_hover':
                    case 'prominent_blur_hover': {
                        if($disable_text_holder != 'yes'){
                            if($type == 'text_on_hover_image' || $type == 'text_on_hover_image_no_space' || $type == 'text_before_hover' || $type == 'text_before_hover_no_space'){
                                $html .= '<div class="text_holder">';
                                $html .= '<div class="text_holder_outer">';
                                $html .= '<div class="text_holder_inner">';
                                if($show_title == 'yes') {
                                    if($disable_link_on_title != "yes") {
                                        $html .= '<' . esc_html($title_tag) . ' class="portfolio_title" ' . esc_attr($title_style) . '><a href="' . esc_url($portfolio_link) . '" ' . esc_attr($title_link_style) . '>' . get_the_title() . '</a></' . esc_html($title_tag) . '>';
                                    }
                                    else{
                                        $html .= '<'.esc_html($title_tag).' class="portfolio_title" '.esc_attr($title_style).'>' . get_the_title() . '</'.esc_html($title_tag).'>';
                                    }
                                }
                                if($separator == 'yes'){
                                    $html .= '<span class="separator '.esc_attr($separator_animation_class).'" '.esc_attr($separator_style).'></span>';
                                }
                                if($show_categories == 'yes'){
                                    $html .= '<span class="project_category" '.esc_attr($category_style).'>'.esc_html($category_html).'</span>';
                                }
                                $html .= '</div>'; //text_holder_inner
                                $html .= '</div>';  // text_holder_outer
                                $html .= '</div>'; // text_holder
                            }
                        }
                        if($show_icons == 'yes') {
                            $html .= '<div class="icons_holder" '.esc_attr($hover_box_style).'>';
                            if ($lightbox == "yes") {
                                $html .= '<a class="portfolio_lightbox" title="' . esc_attr($title) . '" href="' . esc_url( $large_image ) . '" data-rel="prettyPhoto[' . esc_attr($slug_list_) . ']" rel="prettyPhoto[' . esc_attr($slug_list_) . ']"></a>';
                            }
                            if ($portfolio_mkd_like == "on" && $show_like == "yes") {
                                if (function_exists('mkd_like_portfolio_list')) {
                                    $html .= mkd_like_portfolio_list(get_the_ID());
                                }
                            }
                            if ($link_icon == "yes") {
                                $html .= '<a class="preview" title="' . esc_attr__( 'Go to Project', 'mikado1' ) . '"  href="' . esc_url($portfolio_link) . '" data-type="portfolio_list" target="' . esc_attr($target) . '" ></a>';
                            }
                            $html .= '</div>';  // icons_holder
                        }
                    }
                        break;
                }

                if($disable_link != "yes"){
                    $html .= '<a class="portfolio_link_class" href="'.esc_url($portfolio_link).'" target="_self"></a>';
                }
                $html .= '<div class="portfolio_shader" '.esc_attr($portfolio_shader_style).'></div>';
                $html .= '<div class="image_holder">';
                $html .= '<span class="image">';
                $html .= get_the_post_thumbnail(get_the_ID(), $thumb_size);
                $html .= '</span>';
                $html .= '</div>'; // close image_holder
                $html .= '</div>'; // close item_holder

                // portfolio description start

                if ($type == "standard" || $type == "standard_no_space" || $type == "masonry_with_space") {
                    $html .= "<div class='portfolio_description ".esc_attr($portfolio_description_class)."'". esc_attr($portfolio_box_style) .">";

                    if($disable_link_on_title != "yes"){
                        $html .= '<'.esc_html($title_tag).' class="portfolio_title" '. esc_attr($title_style).'><a href="' . esc_url($portfolio_link) . '" target="'.esc_attr($target).'" '.esc_attr($title_link_style).'>' . get_the_title() . '</a></'.esc_attr($title_tag).'>';
                        if($separator == 'yes') {
                            $html .= '<span class="separator ' . esc_attr($separator_animation_class) . '" ' . esc_attr($separator_style) . '></span>';
                        }
                    } else {
                        $html .= '<'.esc_html($title_tag).' class="portfolio_title" '.esc_attr($title_style).'>' . get_the_title() . '</'.esc_html($title_tag).'>';
                        if($separator == 'yes') {
                            $html .= '<span class="separator ' . esc_attr($separator_animation_class) . '" ' . esc_attr($separator_style) . '></span>';
                        }
                    }
                    if($show_categories != 'no'){
                        $html .= '<span class="project_category" '.esc_attr($category_style).'>'.esc_html($category_html).'</span>';
                    }
                    $html .= '</div>'; // close portfolio_description
                }

                $html .= "</article>\n";

            endwhile;

                // loop end

                $i = 1;
                while ($i <= $columns) {
                    $i++;
                    if ($columns != 1) {
                        $html .= "<div class='filler'></div>\n";
                    }
                }

            else:
                ?>
                <p><?php esc_html_e('Sorry, no posts matched your criteria.','mikado1'); ?></p>
            <?php
            endif;


            $html .= "</div>";  // close projects_holder
            if (get_next_posts_link()) {
                if ($show_load_more == "yes" || $show_load_more == "") {
                    $html .= '<div class="portfolio_paging" '.esc_attr($show_more_style).'><span data-rel="' . $wp_query->max_num_pages . '" class="load_more">' . get_next_posts_link(esc_html__('Show more','mikado1')) . '</span></div>';
                    $html .= '<div class="portfolio_paging_loading"><a href="javascript: void(0)" class="qbutton">'.esc_html__('Loading...','mikado1').'</a></div>';
                }
            }
            $html .= "</div>"; // close projects_holder_outer
            wp_reset_query();

        } else {
            if ($filter == "yes") {

                // adding filter on project holder
                $html .= "<div class='filter_outer filter_portfolio ".esc_attr($filter_align)."'>";
                $html .= "<div class='filter_holder ".esc_attr($portfolio_filter_class)."'><ul>";
                if($disable_filter_title != "yes"){
                    $html .= "<li class='filter_title'><span>".esc_html__('Sort Portfolio:','mikado1')."</span></li>";
                }
                $html .= "<li class='filter' data-filter='*'><span>" . esc_html__('All','mikado1') . "</span></li>";
                if ($category == "") {
                    $args = array(
                        'parent' => 0,
                        'orderby' => $filter_order_by
                    );
                    $portfolio_categories = get_terms('portfolio_category', $args);
                } else {
                    $top_category = get_term_by('slug', $category, 'portfolio_category');
                    $term_id = '';
                    if (isset($top_category->term_id))
                        $term_id = $top_category->term_id;
                    $args = array(
                        'parent' => $term_id,
                        'orderby' => $filter_order_by
                    );
                    $portfolio_categories = get_terms('portfolio_category', $args);
                }
                foreach ($portfolio_categories as $portfolio_category) {
                    $html .= "<li class='filter' data-filter='.portfolio_category_" . esc_attr($portfolio_category->term_id) ."'><span>" . esc_html($portfolio_category->name) . "</span>";
                    $args = array(
                        'child_of' => $portfolio_category->term_id
                    );
                    $html .= '</li>';
                }
                $html .= "</ul></div>";
                $html .= "</div>";


            }
            $html .= "<div class='portfolio_main_holder projects_masonry_holder'>";
            if (get_query_var('paged')) {
                $paged = get_query_var('paged');
            } elseif (get_query_var('page')) {
                $paged = get_query_var('page');
            } else {
                $paged = 1;
            }
            if ($category == "") {
                $args = array(
                    'post_type' => 'portfolio_page',
                    'orderby' => $order_by,
                    'order' => $order,
                    'posts_per_page' => $number,
                    'paged' => $paged
                );
            } else {
                $args = array(
                    'post_type' => 'portfolio_page',
                    'portfolio_category' => $category,
                    'orderby' => $order_by,
                    'order' => $order,
                    'posts_per_page' => $number,
                    'paged' => $paged
                );
            }
            $project_ids = null;
            if ($selected_projects != "") {
                $project_ids = explode(",", $selected_projects);
                $args['post__in'] = $project_ids;
            }
            query_posts($args);

            // loop start
            if (have_posts()) : while (have_posts()) : the_post();
                $terms = wp_get_post_terms(get_the_ID(), 'portfolio_category');
                $featured_image_array = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full'); //original size

                if(get_post_meta(get_the_ID(), 'mkd_portfolio-lightbox-link', true) != ""){
                    $large_image = esc_url(get_post_meta(get_the_ID(), 'mkd_portfolio-lightbox-link', true));
                } else {
                    $large_image = $featured_image_array[0];
                }

                $custom_portfolio_link = esc_url(get_post_meta(get_the_ID(), 'mkd_portfolio-external-link', true));
                $portfolio_link = $custom_portfolio_link != "" ? $custom_portfolio_link : get_permalink();
                $target = $custom_portfolio_link != "" ? '_blank' : '_self';

                $masonry_size = "default";
                $masonry_size =  get_post_meta(get_the_ID(), "mkd_portfolio_type_masonry_style", true);

                $image_size = "";
                if($masonry_size == "large_width"){
                    $image_size = "mikado-portfolio-masonry-wide";
                }elseif($masonry_size == "large_height"){
                    $image_size = "mikado-portfolio-masonry-tall";
                }elseif($masonry_size == "large_width_height"){
                    $image_size = "mikado-portfolio-masonry-large";
                } else{
                    $image_size = "mikado-portfolio-square";
                }

                if($type == "masonry_with_space"){
                    $image_size = "mikado-portfolio-masonry-with-space";
                }

                $slug_list_ = "pretty_photo_gallery";
                $title = get_the_title();
                $html .= "<article class='portfolio_masonry_item ";

                foreach ($terms as $term) {
                    $html .= "portfolio_category_".esc_attr($term->term_id);
                }

                $html .= " " . esc_attr($masonry_size);
                $html .= "'>"; // article


                // get categories for specific article
                $category_html = "";
                /*$category_html .= '<span>'. esc_html__('In ','mikado1') .'</span>';*/
                $k = 1;
                foreach ($terms as $term) {
                    $category_html .= esc_attr($term->name);
                    if (count($terms) != $k) {
                        $category_html .= ' / ';
                    }
                    $k++;
                }

                $html .= '<div class="item_holder '.esc_attr($hover_type).'">';

                switch($hover_type) {
                    case 'gradient_hover':
                    case 'upward_hover':
                    case 'subtle_vertical_hover':
                    case 'image_subtle_rotate_zoom_hover':
                    case 'slide_up_hover':
                    case 'cursor_change_hover':
                    case 'image_text_zoom_hover': {
                        if($disable_text_holder != 'yes' || $show_icons == 'yes'){
                            $html .= '<div class="text_holder" '.esc_attr($hover_box_style).'>';
                            $html .= '<div class="text_holder_outer">';
                            $html .= '<div class="text_holder_inner">';
                            if($show_title == 'yes') {
                                if($disable_link_on_title != "yes") {
                                    $html .= '<' . esc_html($title_tag) . ' class="portfolio_title" ' . esc_attr($title_style) . '><a href="' . esc_url($portfolio_link) . '" ' . esc_attr($title_link_style) . '>' . get_the_title() . '</a></' . esc_html($title_tag) . '>';
                                }
                                else{
                                    $html .= '<'.esc_html($title_tag).' class="portfolio_title" '.esc_attr($title_style).'>' . get_the_title() . '</'.esc_html($title_tag).'>';
                                }
                            }
                            if($separator == 'yes'){
                                $html .= '<span class="separator '.esc_attr($separator_animation_class).'" '.esc_attr($separator_style).'></span>';
                            }
                            if($show_categories == 'yes'){
                                $html .= '<span class="project_category" '.esc_attr($category_style).'>'.esc_html($category_html).'</span>';
                            }
                            if($show_icons == "yes"){
                                $html .= '<div class="icons_holder">';
                                if ($lightbox == "yes") {
                                    $html .= '<a class="portfolio_lightbox" title="'.esc_attr($title).'" href="' . esc_url($large_image) . '" data-rel="prettyPhoto[' . esc_attr($slug_list_) . ']" rel="prettyPhoto[' . esc_attr($slug_list_) . ']"></a>';
                                }
                                if ($portfolio_mkd_like == "on" && $show_like == "yes") {
                                    if (function_exists('mkd_like_portfolio_list')) {
                                        $html .= mkd_like_portfolio_list(get_the_ID());
                                    }
                                }
                                if ($link_icon == "yes") {
                                    $html .= '<a class="preview" title="' . esc_attr__( 'Go to Project', 'mikado1' ) . '"  href="' . esc_url($portfolio_link) . '" data-type="portfolio_list" target="' . esc_attr($target) . '" ></a>';
                                }
                                $html .= '</div>'; // icons_holder
                            }
                            $html .= '</div>'; // text_holder_inner
                            $html .= '</div>';  // text_holder_outer
                            $html .= '</div>'; // text_holder
                        }
                    }
                        break;
                    case 'opposite_corners_hover':
                    case 'slide_from_left_hover':
                    case 'prominent_plain_hover':
                    case 'prominent_blur_hover': {
                        if($disable_text_holder != 'yes'){
                            $html .= '<div class="text_holder">';
                            $html .= '<div class="text_holder_outer">';
                            $html .= '<div class="text_holder_inner">';
                            if($show_title == 'yes') {
                                if($disable_link_on_title != "yes") {
                                    $html .= '<' . esc_html($title_tag) . ' class="portfolio_title" ' . esc_attr($title_style) . '><a href="' . esc_url($portfolio_link) . '" ' . esc_attr($title_link_style) . '>' . get_the_title() . '</a></' . esc_html($title_tag) . '>';
                                }
                                else{
                                    $html .= '<'. esc_html($title_tag) .' class="portfolio_title" '. esc_attr($title_style) .'>' . get_the_title() . '</'. esc_html($title_tag) .'>';
                                }
                            }
                            if($separator == 'yes'){
                                $html .= '<span class="separator '. esc_attr($separator_animation_class) .'" '. esc_attr($separator_style) .'></span>';
                            }
                            if($show_categories == 'yes'){
                                $html .= '<span class="project_category" '. esc_attr($category_style) .'>'. esc_html($category_html) .'</span>';
                            }
                            $html .= '</div>'; //text_holder_inner
                            $html .= '</div>'; // text_holder_outer
                            $html .= '</div>';  // text_holder

                        }
                        if($show_icons == "yes") {
                            $html .= '<div class="icons_holder" '. esc_attr($hover_box_style) .'>';
                            if ($lightbox == "yes") {
                                $html .= '<a class="portfolio_lightbox" title="' . esc_attr($title) . '" href="' . esc_url($large_image) . '" data-rel="prettyPhoto[' . esc_attr($slug_list_) . ']" rel="prettyPhoto[' . esc_attr($slug_list_) . ']"></a>';
                            }
                            if ($portfolio_mkd_like == "on" && $show_like == "yes") {
                                if (function_exists('mkd_like_portfolio_list')) {
                                    $html .= mkd_like_portfolio_list(get_the_ID());
                                }
                            }
                            if ($link_icon == "yes") {
                                $html .= '<a class="preview" title="' . esc_attr__( 'Preview', 'mikado1' ) . '"  href="' . esc_url($portfolio_link) . '" data-type="portfolio_list" target="' . esc_attr($target) . '" ></a>';
                            }
                            $html .= '</div>';  // icons_holder
                        }
                    }
                        break;
                }

                if($disable_link != "yes"){
                    $html .= '<a class="portfolio_link_class" href="'. esc_url($portfolio_link) .'" target="_self"></a>';
                }
                $html .= '<div class="portfolio_shader" '. esc_attr($portfolio_shader_style) .'></div>';
                $html .= '<div class="image_holder">';
                $html .= '<span class="image">';
                $html .= get_the_post_thumbnail(get_the_ID(), $image_size);
                $html .= '</span>';
                $html .= '</div>'; // close text_holder
                $html .= '</div>'; // close item_holder

                $html .= "</article>";

            endwhile;
            // loop start
            else:
                ?>
                <p><?php esc_html_e('Sorry, no posts matched your criteria.','mikado1'); ?></p>
            <?php
            endif;
            wp_reset_query();
            $html .= "</div>";
        }
        return $html;
    }
}

new MkdPortfolioListShortcode();