<?php

if ( ! function_exists( 'mikado_core_slider_meta_boxes_map' ) ) {
	function mikado_core_slider_meta_boxes_map() {
		$mkdFramework = mikado_one_mikado_return_framework();

		$mkd_custom_sidebars = array();
		foreach ( $GLOBALS['wp_registered_sidebars'] as $sidebar ) {
			if ( mikado_one_mikado_is_user_made_sidebar( ucwords( $sidebar['name'] ) ) ) {
				$mkd_custom_sidebars[ $sidebar['id'] ] = ucwords( $sidebar['name'] );
			}
		}


		$mkd_blog_categories = array();
		$categories          = get_categories();
		foreach ( $categories as $category ) {
			$mkd_blog_categories[ $category->term_id ] = $category->name;
		}

		//Mikado Slide Type

		$mkdSlideType = new MikadoMetaBox( "slides", "Mikado Slide Type" );
		$mkdFramework->mkdMetaBoxes->addMetaBox( "slides_type", $mkdSlideType );

		$mkd_slide_background_type = new MikadoMetaField( "imagevideo", "mkd_slide-background-type", "image", "Slide Background Type", "Do you want to upload an image or video?", array(), array(
			"dependence"             => true,
			"dependence_hide_on_yes" => "#mkdf-meta-box-slides_video_settings",
			"dependence_show_on_yes" => "#mkdf-meta-box-slides_image_settings"
		) );
		$mkdSlideType->addChild( "mkd_slide-background-type", $mkd_slide_background_type );

		//Mikado Slide Image

		$mkdSlideImageSettings = new MikadoMetaBox( "slides", "Mikado Slide Image", "mkd_slide-background-type", array( "video" ) );
		$mkdFramework->mkdMetaBoxes->addMetaBox( "slides_image_settings", $mkdSlideImageSettings );

		$mkd_slide_image = new MikadoMetaField( "image", "mkd_slide-image", "", "Slide Image", "Choose background image" );
		$mkdSlideImageSettings->addChild( "mkd_title-image", $mkd_slide_image );

		$mkd_slide_overlay_image = new MikadoMetaField( "image", "mkd_slide-overlay-image", "", "Overlay Image", "Choose overlay image (pattern) for background image" );
		$mkdSlideImageSettings->addChild( "mkd_slide-overlay-image", $mkd_slide_overlay_image );

		//Mikado Slide Video

		$mkdSlideVideoSettings = new MikadoMetaBox( "slides", "Mikado Slide Video", "mkd_slide-background-type", array( "image" ) );
		$mkdFramework->mkdMetaBoxes->addMetaBox( "slides_video_settings", $mkdSlideVideoSettings );

		$mkd_slide_video_webm = new MikadoMetaField( "text", "mkd_slide-video-webm", "", "Video - webm", "Path to the webm file that you have previously uploaded in Media Section" );
		$mkdSlideVideoSettings->addChild( "mkd_slide-video-webm", $mkd_slide_video_webm );

		$mkd_slide_video_mp4 = new MikadoMetaField( "text", "mkd_slide-video-mp4", "", "Video - mp4", "Path to the mp4 file that you have previously uploaded in Media Section" );
		$mkdSlideVideoSettings->addChild( "mkd_slide-video-mp4", $mkd_slide_video_mp4 );

		$mkd_slide_video_ogv = new MikadoMetaField( "text", "mkd_slide-video-ogv", "", "Video - ogv", "Path to the ogv file that you have previously uploaded in Media Section" );
		$mkdSlideVideoSettings->addChild( "mkd_slide-video-ogv", $mkd_slide_video_ogv );

		$mkd_slide_video_image = new MikadoMetaField( "image", "mkd_slide-video-image", "", "Video Preview Image", "Choose background image that will be visible until video is loaded. This image will be shown on touch devices too." );
		$mkdSlideVideoSettings->addChild( "mkd_slide-video-image", $mkd_slide_video_image );

		$mkd_slide_video_overlay = new MikadoMetaField( "yesempty", "mkd_slide-video-overlay", "", "Video Overlay Image", "Do you want to have a overlay image on video? ", array(), array(
			"dependence"             => true,
			"dependence_hide_on_yes" => "",
			"dependence_show_on_yes" => "#mkdf_mkd_slide-video-overlay_container"
		) );
		$mkdSlideVideoSettings->addChild( "mkd_slide-video-overlay", $mkd_slide_video_overlay );

		$mkd_slide_video_overlay_container = new MikadoContainer( "mkd_slide-video-overlay_container", "mkd_slide-video-overlay", "" );
		$mkdSlideVideoSettings->addChild( "mkd_slide_video_overlay_container", $mkd_slide_video_overlay_container );

		$mkd_slide_video_overlay_image = new MikadoMetaField( "image", "mkd_slide-video-overlay-image", "", "Overlay Image", "Choose overlay image (pattern) for background video" );
		$mkd_slide_video_overlay_container->addChild( "mkd_slide-video-overlay-image", $mkd_slide_video_overlay_image );

		//Mikado Slide General

		$mkdSlideGeneral = new MikadoMetaBox( "slides", "Mikado Slide General" );
		$mkdFramework->mkdMetaBoxes->addMetaBox( "slides_layout", $mkdSlideGeneral );

		$mkd_slide_header_style = new MikadoMetaField( "selectblank", "mkd_slide-header-style", "", "Header Style", "Header style will be applied when this slide is in focus", array(
			"light" => "Light",
			"dark"  => "Dark"
		) );
		$mkdSlideGeneral->addChild( "mkd_slide-header-style", $mkd_slide_header_style );

		$mkd_slide_navigation_color = new MikadoMetaField( "color", "mkd_slide-navigation-color", "", "Navigation Color", "Navigation color will be applied when this slide is in focus" );
		$mkdSlideGeneral->addChild( "mkd_slide-navigation-color", $mkd_slide_navigation_color );

		$mkd_slide_scroll_to_section = new MikadoMetaField( "text", "mkd_slide-anchor-button", "", "Scroll to Section", "An arrow will appear to take viewers to the next section of the page. Enter the section anchor here, for example, '#contact'" );
		$mkdSlideGeneral->addChild( "mkd_slide-anchor-button", $mkd_slide_scroll_to_section );

		$mkd_slide_hide_title = new MikadoMetaField( "yesempty", "mkd_slide-hide-title", "", "Hide Slide Title", "Do you want to hide slide title?", array(), array(
			"dependence"             => true,
			"dependence_hide_on_yes" => "#mkdf-meta-box-slides_title",
			"dependence_show_on_yes" => ""
		) );
		$mkdSlideGeneral->addChild( "mkd_slide-hide-title", $mkd_slide_hide_title );

		$mkd_slide_hide_shadow = new MikadoMetaField( "yesempty", "mkd_slide-hide-shadow", "", "Show Slide Text Shadow", "Do you want to show text shadow?" );
		$mkdSlideGeneral->addChild( "mkd_slide-hide-shadow", $mkd_slide_hide_shadow );

		$mkd_slide_content_fading_out = new MikadoMetaField( "select", "mkd_slide-contnet-fading-out", "on", "Slide Content Fading-Out", "Disabling this option will turn off parallax effect and fading-out on scrolling.", array(
			"fading_out_on"  => "On",
			"fading_out_off" => "Off"
		) );
		$mkdSlideGeneral->addChild( "mkd_slide-contnet-fading-out", $mkd_slide_content_fading_out );

		$mkd_slide_thumbnail_animation = new MikadoMetaField( "select", "mkd_slide-thumbnail-animation", "flip", "Graphic Animation", "This is how the graphic will enter the slide", array(
			"flip"              => "Flip",
			"fade"              => "Fade",
			"without_animation" => "Without Animation"
		) );
		$mkdSlideGeneral->addChild( "mkd_slide-thumbnail-animation", $mkd_slide_thumbnail_animation );

		$mkd_slide_content_animation = new MikadoMetaField( "select", "mkd_slide-content-animation", "all_at_once", "Content Animation", "This is how content (title, subtitle, text and buttons) will enter the slide", array(
			"all_at_once"       => "All At Once",
			"one_by_one"        => "One By One",
			"without_animation" => "Without Animation"
		) );
		$mkdSlideGeneral->addChild( "mkd_slide-content-animation", $mkd_slide_content_animation );

		//Mikado Slide Title

		$mkdSlideTitle = new MikadoMetaBox( "slides", "Mikado Slide Title", "mkd_slide-hide-title", array( "yes" ) );
		$mkdFramework->mkdMetaBoxes->addMetaBox( "slides_title", $mkdSlideTitle );

		$title_text_group = new MikadoGroup( "Title Text Style", "Define styles for title text" );
		$mkdSlideTitle->addChild( "title_text_group", $title_text_group );
		$row1 = new MikadoRow();
		$title_text_group->addChild( "row1", $row1 );
		$title_color = new MikadoMetaField( "colorsimple", "mkd_slide-title-color", "", "Font Color", "This is some description" );
		$row1->addChild( "mkd_slide-title-color", $title_color );
		$title_fontsize = new MikadoMetaField( "textsimple", "mkd_slide-title-font-size", "", "Font Size (px)", "This is some description" );
		$row1->addChild( "mkd_slide-title-font-size", $title_fontsize );
		$title_lineheight = new MikadoMetaField( "textsimple", "mkd_slide-title-line-height", "", "Line Height (px)", "This is some description" );
		$row1->addChild( "mkd_slide-title-line-height", $title_lineheight );
		$title_letterspacing = new MikadoMetaField( "textsimple", "mkd_slide-title-letter-spacing", "", "Letter Spacing (px)", "This is some description" );
		$row1->addChild( "mkd_slide-title-letter-spacing", $title_letterspacing );

		$row2 = new MikadoRow( true );
		$title_text_group->addChild( "row2", $row2 );
		$title_google_fonts = new MikadoMetaField( "Fontsimple", "mkd_slide-title-font-family", "", "Font Family", "This is some description" );
		$row2->addChild( "mkd_slide-title-font-family", $title_google_fonts );
		$title_fontstyle = new MikadoMetaField( "selectblanksimple", "mkd_slide-title-font-style", "", "Font Style", "This is some description", mikado_one_mikado_options_font_style() );
		$row2->addChild( "mkd_slide-title-font-style", $title_fontstyle );
		$title_fontweight = new MikadoMetaField( "selectblanksimple", "mkd_slide-title-font-weight", "", "Font Weight", "This is some description", mikado_one_mikado_options_font_weight() );
		$row2->addChild( "mkd_slide-title-font-weight", $title_fontweight );
		$title_texttransform = new MikadoMetaField( "selectblanksimple", "mkd_slide-title-text-transform", "", "Text Transform", "This is some description", mikado_one_mikado_options_text_transform() );
		$row2->addChild( "mkd_slide-title-text-transform", $title_texttransform );

		$title_background_group = new MikadoGroup( "Background", "Define background for title" );
		$mkdSlideTitle->addChild( "title_background_group", $title_background_group );
		$row1 = new MikadoRow( true );
		$title_background_group->addChild( "row1", $row1 );
		$title_background_color = new MikadoMetaField( "colorsimple", "mkd_slide-title-background-color", "", "Background Color", "This is some description" );
		$row1->addChild( "mkd_slide-title-background-color", $title_background_color );
		$title_background_color_transparency = new MikadoMetaField( "textsimple", "mkd_slide-title-bg-color-transparency", "", "Background Color Transparency (0 = fully transparent, 1 = opaque)", "This is some description" );
		$row1->addChild( "mkd_slide-title-bg-color-transparency", $title_background_color_transparency );

		$title_margin_group = new MikadoGroup( "Margin Bottom (px)", "Enter value for title bottom margin (default value is 14)" );
		$mkdSlideTitle->addChild( "title_margin_group", $title_margin_group );
		$row1 = new MikadoRow( true );
		$title_margin_group->addChild( "row1", $row1 );
		$title_margin_bottom = new MikadoMetaField( "textsimple", "mkd_slide_title_margin_bottom", "", "", "This is some description" );
		$row1->addChild( "mkd_slide_title_margin_bottom", $title_margin_bottom );

		$title_padding_group = new MikadoGroup( "Padding", "Define padding for title" );
		$mkdSlideTitle->addChild( "title_padding_group", $title_padding_group );
		$row1 = new MikadoRow( true );
		$title_padding_group->addChild( "row1", $row1 );
		$title_padding_top = new MikadoMetaField( "textsimple", "mkd_slide_title_padding_top", "", "Top Padding (px)", "This is some description" );
		$row1->addChild( "mkd_slide_title_padding_top", $title_padding_top );
		$title_padding_right = new MikadoMetaField( "textsimple", "mkd_slide_title_padding_right", "", "Right Padding (px)", "This is some description" );
		$row1->addChild( "mkd_slide_title_padding_right", $title_padding_right );
		$title_padding_bottom = new MikadoMetaField( "textsimple", "mkd_slide_title_padding_bottom", "", "Bottom Padding (px)", "This is some description" );
		$row1->addChild( "mkd_slide_title_padding_bottom", $title_padding_bottom );
		$title_padding_left = new MikadoMetaField( "textsimple", "mkd_slide_title_padding_left", "", "Left Padding (px)", "This is some description" );
		$row1->addChild( "mkd_slide_title_padding_left", $title_padding_left );

		$title_link_group = new MikadoGroup( "Title Link", "Define styles for title" );
		$mkdSlideTitle->addChild( "title_link_group", $title_link_group );
		$row1 = new MikadoRow();
		$title_link_group->addChild( "row1", $row1 );

		$title_link = new MikadoMetaField( "textsimple", "mkd_slide-title-link", "", "Link", "This is some description" );
		$row1->addChild( "mkd_slide-title-link", $title_link );
		$title_target = new MikadoMetaField( "selectsimple", "mkd_slide-title-target", "_self", "Target", "This is some description", array(
			"_self"  => "Self",
			"_blank" => "Blank"
		) );
		$row1->addChild( "mkd_slide-title-target", $title_target );

		$mkd_slide_title_separator = new MikadoMetaField( "yesno", "mkd_slide-separator-title", "no", "Separator Title", "Do you want to have a separator title?", array(), array(
			"dependence"             => true,
			"dependence_hide_on_yes" => "",
			"dependence_show_on_yes" => "#mkdf_mkd_slide_title_separator_container"
		) );
		$mkdSlideTitle->addChild( "mkd_slide-separator-title", $mkd_slide_title_separator );

		$mkd_slide_title_separator_container = new MikadoContainer( "mkd_slide_title_separator_container", "mkd_slide-separator-title", "no" );
		$mkdSlideTitle->addChild( "mkd_slide_title_separator_container", $mkd_slide_title_separator_container );

		$mkd_slide_title_separator_position = new MikadoMetaField( "select", "mkd_slide-title-separator-position", "both", "Position", "Choose position of slider separator", array(
			"both"   => "Top and Bottom",
			"top"    => "Top",
			"bottom" => "Bottom"
		), array(
			"dependence" => true,
			"hide"       => array(
				"both"   => "",
				"top"    => "#mkdf_mkd_slide_bottom_separator_container",
				"bottom" => "#mkdf_mkd_slide_top_separator_container"
			),
			"show"       => array(
				"both"   => "#mkdf_mkd_slide_top_separator_container,#mkdf_mkd_slide_bottom_separator_container",
				"top"    => "#mkdf_mkd_slide_top_separator_container",
				"bottom" => "#mkdf_mkd_slide_bottom_separator_container"
			)
		) );
		$mkd_slide_title_separator_container->addChild( "mkd_slide-title-separator-position", $mkd_slide_title_separator_position );

		$mkd_slide_top_separator_container = new MikadoContainer( "mkd_slide_top_separator_container", "mkd_slide-title-separator-position", "bottom" );
		$mkd_slide_title_separator_container->addChild( "mkd_slide_top_separator_container", $mkd_slide_top_separator_container );

		$group1 = new MikadoGroup( "Top Separator Style", "Enter separator style" );
		$mkd_slide_top_separator_container->addChild( "group1", $group1 );

		$row1 = new MikadoRow();
		$group1->addChild( "row1", $row1 );

		$mkd_slide_top_separator_margin_top = new MikadoMetaField( "textsimple", "mkd_slide-top-separator-margin-top", "", "Margin Top (px)", "This is some description" );
		$row1->addChild( "mkd_slide-top-separator-margin-top", $mkd_slide_top_separator_margin_top );

		$mkd_slide_top_separator_margin_bottom = new MikadoMetaField( "textsimple", "mkd_slide-top-separator-margin-bottom", "", "Margin Bottom (px)", "This is some description" );
		$row1->addChild( "mkd_slide-top-separator-margin-bottom", $mkd_slide_top_separator_margin_bottom );

		$mkd_slide_bottom_separator_container = new MikadoContainer( "mkd_slide_bottom_separator_container", "mkd_slide-title-separator-position", "top" );
		$mkd_slide_title_separator_container->addChild( "mkd_slide_bottom_separator_container", $mkd_slide_bottom_separator_container );

		$group2 = new MikadoGroup( "Bottom Separator Style", "Enter separator style" );
		$mkd_slide_bottom_separator_container->addChild( "group2", $group2 );

		$row1 = new MikadoRow();
		$group2->addChild( "row1", $row1 );

		$mkd_slide_bottom_separator_margin_top = new MikadoMetaField( "textsimple", "mkd_slide-bottom-separator-margin-top", "", "Margin Top (px)", "This is some description" );
		$row1->addChild( "mkd_slide-bottom-separator-margin-top", $mkd_slide_bottom_separator_margin_top );

		$mkd_slide_bottom_separator_margin_bottom = new MikadoMetaField( "textsimple", "mkd_slide-bottom-separator-margin-bottom", "", "Margin Bottom (px)", "This is some description" );
		$row1->addChild( "mkd_slide-bottom-separator-margin-bottom", $mkd_slide_bottom_separator_margin_bottom );

		$mkd_slide_title_separator_align = new MikadoMetaField( "select", "mkd_slide-title-separator-align", "both", "Align", "Choose align of slider separator", array(
			"none"  => "Center",
			"left"  => "Left",
			"right" => "Right"
		) );
		$mkd_slide_title_separator_container->addChild( "mkd_slide-title-separator-align", $mkd_slide_title_separator_align );

		$mkd_slide_separator_color_group = new MikadoGroup( "Separator Color", "Define color for slider separator" );
		$mkd_slide_title_separator_container->addChild( "mkd_slide_separator_color_group", $mkd_slide_separator_color_group );
		$row1 = new MikadoRow();
		$mkd_slide_separator_color_group->addChild( "row1", $row1 );

		$mkd_slide_title_separator_color = new MikadoMetaField( "colorsimple", "mkd_slide-separator-color", "", "Separator Color", "Choose a color for the separator" );
		$row1->addChild( "mkd_slide-separator-color", $mkd_slide_title_separator_color );

		$mkd_slide_title_separator_transparency = new MikadoMetaField( "textsimple", "mkd_slide-separator-transparency", "", "Separator transparency (0 = fully transparent, 1 = opaque)", "This is some description" );
		$row1->addChild( "mkd_slide-separator-transparency", $mkd_slide_title_separator_transparency );

		$mkd_slide_separator_size_group = new MikadoGroup( "Separator Size", "Define size for slider separator (separator width is in relation to title holder width)" );
		$mkd_slide_title_separator_container->addChild( "mkd_slide_separator_size_group", $mkd_slide_separator_size_group );
		$row1 = new MikadoRow();
		$mkd_slide_separator_size_group->addChild( "row1", $row1 );

		$mkd_slide_title_separator_width = new MikadoMetaField( "textsimple", "mkd_slide-separator-width", "", "Separator Width (%)", "Enter value from 0% to 100%. Enter just number." );
		$row1->addChild( "mkd_slide-separator-width", $mkd_slide_title_separator_width );

		$mkd_slide_title_separator_thickness = new MikadoMetaField( "textsimple", "mkd_slide-separator-thickness", "", "Separator Thickness (px)", "This is some description" );
		$row1->addChild( "mkd_slide-separator-thickness", $mkd_slide_title_separator_thickness );

		//Mikado Slide Subtitle

		$mkdSlideSubtitle = new MikadoMetaBox( "slides", "Mikado Slide Subtitle" );
		$mkdFramework->mkdMetaBoxes->addMetaBox( "slides_subtitle", $mkdSlideSubtitle );

		$mkd_slide_subtitle = new MikadoMetaField( "text", "mkd_slide-subtitle", "", "Slide Subtitle", "Enter slide subtitle" );
		$mkdSlideSubtitle->addChild( "mkd_slide-subtitle", $mkd_slide_subtitle );

		$subtitle_text_group = new MikadoGroup( "Subtitle Text Style", "Define styles for subtitle text" );
		$mkdSlideSubtitle->addChild( "subtitle_text_group", $subtitle_text_group );
		$row1 = new MikadoRow();
		$subtitle_text_group->addChild( "row1", $row1 );
		$subtitle_color = new MikadoMetaField( "colorsimple", "mkd_slide-subtitle-color", "", "Font Color", "This is some description" );
		$row1->addChild( "mkd_slide-subtitle-color", $subtitle_color );
		$subtitle_fontsize = new MikadoMetaField( "textsimple", "mkd_slide-subtitle-font-size", "", "Font Size (px)", "This is some description" );
		$row1->addChild( "mkd_slide-subtitle-font-size", $subtitle_fontsize );
		$subtitle_lineheight = new MikadoMetaField( "textsimple", "mkd_slide-subtitle-line-height", "", "Line Height (px)", "This is some description" );
		$row1->addChild( "mkd_slide-subtitle-line-height", $subtitle_lineheight );
		$subtitle_letterspacing = new MikadoMetaField( "textsimple", "mkd_slide-subtitle-letter-spacing", "", "Letter Spacing (px)", "This is some description" );
		$row1->addChild( "mkd_slide-subtitle-letter-spacing", $subtitle_letterspacing );

		$row2 = new MikadoRow( true );
		$subtitle_text_group->addChild( "row2", $row2 );
		$subtitle_google_fonts = new MikadoMetaField( "Fontsimple", "mkd_slide-subtitle-font-family", "", "Font Family", "This is some description" );
		$row2->addChild( "mkd_slide-subtitle-font-family", $subtitle_google_fonts );
		$subtitle_fontstyle = new MikadoMetaField( "selectblanksimple", "mkd_slide-subtitle-font-style", "", "Font Style", "This is some description", mikado_one_mikado_options_font_style() );
		$row2->addChild( "mkd_slide-subtitle-font-style", $subtitle_fontstyle );
		$subtitle_fontweight = new MikadoMetaField( "selectblanksimple", "mkd_slide-subtitle-font-weight", "", "Font Weight", "This is some description", mikado_one_mikado_options_font_weight() );
		$row2->addChild( "mkd_slide-subtitle-font-weight", $subtitle_fontweight );
		$subtitle_transform = new MikadoMetaField( "selectblanksimple", "mkd_slide-subtitle-text-transform", "", "Text Transform", "This is some description", mikado_one_mikado_options_text_transform() );
		$row2->addChild( "mkd_slide-subtitle-text-transform", $subtitle_transform );

		$subtitle_background_group = new MikadoGroup( "Background", "Define background for subtitle" );
		$mkdSlideSubtitle->addChild( "subtitle_background_group", $subtitle_background_group );
		$row1 = new MikadoRow( true );
		$subtitle_background_group->addChild( "row1", $row1 );
		$subtitle_background_color = new MikadoMetaField( "colorsimple", "mkd_slide-subtitle-background-color", "", "Background Color", "This is some description" );
		$row1->addChild( "mkd_slide-subtitle-background-color", $subtitle_background_color );
		$subtitle_background_color_transparency = new MikadoMetaField( "textsimple", "mkd_slide-subtitle-bg-color-transparency", "", "Background Color Transparency (0 = fully transparent, 1 = opaque)", "This is some description" );
		$row1->addChild( "mkd_slide-subtitle-bg-color-transparency", $subtitle_background_color_transparency );

		$subtitle_margin_group = new MikadoGroup( "Margin Bottom (px)", "Enter value for subtitle bottom margin (default value is 14)" );
		$mkdSlideSubtitle->addChild( "subtitle_margin_group", $subtitle_margin_group );
		$row1 = new MikadoRow( true );
		$subtitle_margin_group->addChild( "row1", $row1 );
		$subtitle_margin_bottom = new MikadoMetaField( "textsimple", "mkd_slide_subtitle_margin_bottom", "", "", "This is some description" );
		$row1->addChild( "mkd_slide_subtitle_margin_bottom", $subtitle_margin_bottom );

		$subtitle_padding_group = new MikadoGroup( "Padding", "Define padding for subtitle" );
		$mkdSlideSubtitle->addChild( "subtitle_padding_group", $subtitle_padding_group );
		$row1 = new MikadoRow( true );
		$subtitle_padding_group->addChild( "row1", $row1 );
		$subtitle_padding_top = new MikadoMetaField( "textsimple", "mkd_slide_subtitle_padding_top", "", "Top Padding", "This is some description" );
		$row1->addChild( "mkd_slide_subtitle_padding_top", $subtitle_padding_top );
		$subtitle_padding_right = new MikadoMetaField( "textsimple", "mkd_slide_subtitle_padding_right", "", "Right Padding", "This is some description" );
		$row1->addChild( "mkd_slide_subtitle_padding_right", $subtitle_padding_right );
		$subtitle_padding_bottom = new MikadoMetaField( "textsimple", "mkd_slide_subtitle_padding_bottom", "", "Bottom Padding", "This is some description" );
		$row1->addChild( "mkd_slide_subtitle_padding_bottom", $subtitle_padding_bottom );
		$subtitle_padding_left = new MikadoMetaField( "textsimple", "mkd_slide_subtitle_padding_left", "", "Left Padding", "This is some description" );
		$row1->addChild( "mkd_slide_subtitle_padding_left", $subtitle_padding_left );

		//Mikado Slide Text

		$mkdSlideText = new MikadoMetaBox( "slides", "Mikado Slide Text" );
		$mkdFramework->mkdMetaBoxes->addMetaBox( "slides_text", $mkdSlideText );

		$mkd_slide_text = new MikadoMetaField( "text", "mkd_slide-text", "", "Slide Text", "Enter slide text" );
		$mkdSlideText->addChild( "mkd_slide-text", $mkd_slide_text );

		$text_text_group = new MikadoGroup( "Text Text Style", "Define styles for text text" );
		$mkdSlideText->addChild( "text_text_group", $text_text_group );
		$row1 = new MikadoRow();
		$text_text_group->addChild( "row1", $row1 );
		$text_color = new MikadoMetaField( "colorsimple", "mkd_slide-text-color", "", "Font Color", "This is some description" );
		$row1->addChild( "mkd_slide-text-color", $text_color );
		$text_fontsize = new MikadoMetaField( "textsimple", "mkd_slide-text-font-size", "", "Font Size (px)", "This is some description" );
		$row1->addChild( "mkd_slide-text-font-size", $text_fontsize );
		$text_lineheight = new MikadoMetaField( "textsimple", "mkd_slide-text-line-height", "", "Line Height (px)", "This is some description" );
		$row1->addChild( "mkd_slide-text-line-height", $text_lineheight );
		$text_letterspacing = new MikadoMetaField( "textsimple", "mkd_slide-text-letter-spacing", "", "Letter Spacing (px)", "This is some description" );
		$row1->addChild( "mkd_slide-text-letter-spacing", $text_letterspacing );

		$row2 = new MikadoRow( true );
		$text_text_group->addChild( "row2", $row2 );
		$text_google_fonts = new MikadoMetaField( "Fontsimple", "mkd_slide-text-font-family", "", "Font Family", "This is some description" );
		$row2->addChild( "mkd_slide-text-font-family", $text_google_fonts );
		$text_fontstyle = new MikadoMetaField( "selectblanksimple", "mkd_slide-text-font-style", "", "Font Style", "This is some description", mikado_one_mikado_options_font_style() );
		$row2->addChild( "mkd_slide-text-font-style", $text_fontstyle );
		$text_fontweight = new MikadoMetaField( "selectblanksimple", "mkd_slide-text-font-weight", "", "Font Weight", "This is some description", mikado_one_mikado_options_font_weight() );
		$row2->addChild( "mkd_slide-text-font-weight", $text_fontweight );
		$text_transform = new MikadoMetaField( "selectblanksimple", "mkd_slide-text-text-transform", "", "Text Transform", "This is some description", mikado_one_mikado_options_text_transform() );
		$row2->addChild( "mkd_slide-text-text-transform", $text_transform );

		$text_background_group = new MikadoGroup( "Background", "Define background for text" );
		$mkdSlideText->addChild( "text_background_group", $text_background_group );
		$row1 = new MikadoRow( true );
		$text_background_group->addChild( "row1", $row1 );
		$text_background_color = new MikadoMetaField( "colorsimple", "mkd_slide-text-background-color", "", "Background Color", "This is some description" );
		$row1->addChild( "mkd_slide-text-background-color", $text_background_color );
		$text_background_color_transparency = new MikadoMetaField( "textsimple", "mkd_slide-text-bg-color-transparency", "", "Background Color Transparency (0 = fully transparent, 1 = opaque)", "This is some description" );
		$row1->addChild( "mkd_slide-text-bg-color-transparency", $text_background_color_transparency );

		$text_padding_group = new MikadoGroup( "Padding", "Define padding for text" );
		$mkdSlideText->addChild( "text_padding_group", $text_padding_group );
		$row1 = new MikadoRow( true );
		$text_padding_group->addChild( "row1", $row1 );
		$text_padding_top = new MikadoMetaField( "textsimple", "mkd_slide_text_padding_top", "", "Top Padding", "This is some description" );
		$row1->addChild( "mkd_slide_text_padding_top", $text_padding_top );
		$text_padding_right = new MikadoMetaField( "textsimple", "mkd_slide_text_padding_right", "", "Right Padding", "This is some description" );
		$row1->addChild( "mkd_slide_text_padding_right", $text_padding_right );
		$text_padding_bottom = new MikadoMetaField( "textsimple", "mkd_slide_text_padding_bottom", "", "Bottom Padding", "This is some description" );
		$row1->addChild( "mkd_slide_text_padding_bottom", $text_padding_bottom );
		$text_padding_left = new MikadoMetaField( "textsimple", "mkd_slide_text_padding_left", "", "Left Padding", "This is some description" );
		$row1->addChild( "mkd_slide_text_padding_left", $text_padding_left );


		//Mikado Slide Graphic

		$mkdSlideGraphic = new MikadoMetaBox( "slides", "Mikado Slide Graphic" );
		$mkdFramework->mkdMetaBoxes->addMetaBox( "slides_graphic", $mkdSlideGraphic );

		$mkd_slide_graphic = new MikadoMetaField( "image", "mkd_slide-thumbnail", "", "Slide Graphic", "Choose slide graphic" );
		$mkdSlideGraphic->addChild( "mkd_slide-thumbnail", $mkd_slide_graphic );

		$mkd_slide_graphic_link = new MikadoMetaField( "text", "mkd_slide-thumbnail-link", "", "Link", "Enter URL to link slide graphic" );
		$mkdSlideGraphic->addChild( "mkd_slide-thumbnail-link", $mkd_slide_graphic_link );

		//Mikado Slide Buttons
		//Button 1
		$mkdSlideButtons = new MikadoMetaBox( "slides", "Mikado Slide Buttons" );
		$mkdFramework->mkdMetaBoxes->addMetaBox( "slides_buttons", $mkdSlideButtons );

		$button1_section = new MikadoTitle( "button1_section", "Button 1" );
		$mkdSlideButtons->addChild( "button1_section", $button1_section );

		$button1_label = new MikadoMetaField( "text", "mkd_slide-button-label", "", "Button Text", " Enter text to be displayed on button 1", array(), array( "col_width" => 3 ) );
		$mkdSlideButtons->addChild( "mkd_slide-button-label", $button1_label );

		$button1_group1 = new MikadoGroup( "Link", "Url & target" );
		$mkdSlideButtons->addChild( "button1_group1", $button1_group1 );

		$row1 = new MikadoRow();
		$button1_group1->addChild( "row1", $row1 );

		$button1_link = new MikadoMetaField( "textsimple", "mkd_slide-button-link", "", "Link", "This is some description" );
		$row1->addChild( "mkd_slide-button-link", $button1_link );
		$button1_target = new MikadoMetaField( "selectsimple", "mkd_slide-button-target", "_self", "Target", "This is some description", array(
			"_self"  => "Self",
			"_blank" => "Blank"
		) );
		$row1->addChild( "mkd_slide-button-target", $button1_target );

		$button1_group2 = new MikadoGroup( "Text Style", "Define text style" );
		$mkdSlideButtons->addChild( "button1_group2", $button1_group2 );

		$row1 = new MikadoRow();
		$button1_group2->addChild( "row1", $row1 );
		$button1_font_family = new MikadoMetaField( "Fontsimple", "mkd_slide-button_font_family", "-1", "Font Family", "This is some description" );
		$row1->addChild( "mkd_slide-button_font_family", $button1_font_family );
		$button1_font_size = new MikadoMetaField( "textsimple", "mkd_slide-button_font_size", "", "Text Size(px)", "This is some description" );
		$row1->addChild( "mkd_slide-button_font_size", $button1_font_size );
		$button1_font_style = new MikadoMetaField( "selectblanksimple", "mkd_slide-button_font_style", "", "Font Style", "This is some description", mikado_one_mikado_options_font_style() );
		$row1->addChild( "mkd_slide-button_font_style", $button1_font_style );
		$button1_font_weight = new MikadoMetaField( "selectblanksimple", "mkd_slide-button_font_weight", "", "Font Weight", "This is some description", mikado_one_mikado_options_font_weight() );
		$row1->addChild( "mkd_slide-button_font_weight", $button1_font_weight );

		$row2 = new MikadoRow();
		$button1_group2->addChild( "row2", $row2 );

		$button1_letter_spacing = new MikadoMetaField( "textsimple", "mkd_slide-button_letter_spacing", "", "Letter Spacing(px)", "This is some description" );
		$row2->addChild( "mkd_slide-button_letter_spacing", $button1_letter_spacing );

		$button1_line_height = new MikadoMetaField( "textsimple", "mkd_slide-button_line_height", "", "Line Height (px)", "This is some description" );
		$row2->addChild( "mkd_slide-button_line_height", $button1_line_height );

		$button1_text_color = new MikadoMetaField( "colorsimple", "mkd_slide-button_text_color", "", "Text Color", "This is some description" );
		$row2->addChild( "mkd_slide-button_text_color", $button1_text_color );

		$button1_text_hover_color = new MikadoMetaField( "colorsimple", "mkd_slide-button_text_hover_color", "", "Text Hover Color", "This is some description" );
		$row2->addChild( "mkd_slide-button_text_hover_color", $button1_text_hover_color );

		$row3 = new MikadoRow();
		$button1_group2->addChild( "row3", $row3 );

		$button1_text_align = new MikadoMetaField( "selectblanksimple", "mkd_slide-button_text_align", "", "Text Align", "This is some description", array(
			"left"   => "Left",
			"center" => "Center",
			"right"  => "Right"
		) );
		$row3->addChild( "mkd_slide-button_text_align", $button1_text_align );
		$button1_text_transform = new MikadoMetaField( "selectblanksimple", "mkd_slide-button_text_transform", "", "Text Transform", "This is some description", mikado_one_mikado_options_text_transform() );
		$row3->addChild( "mkd_slide-button_text_transform", $button1_text_transform );

		$button1_group3 = new MikadoGroup( "Background", "Define background" );
		$mkdSlideButtons->addChild( "button1_group3", $button1_group3 );

		$row1 = new MikadoRow();
		$button1_group3->addChild( "row1", $row1 );

		$button1_background_color = new MikadoMetaField( "colorsimple", "mkd_slide-button_background_color", "", "Background Color", "This is some description" );
		$row1->addChild( "mkd_slide-button_background_color", $button1_background_color );

		$button1_background_hover_color = new MikadoMetaField( "colorsimple", "mkd_slide-button_background_hover_color", "", "Background Hover Color", "This is some description" );
		$row1->addChild( "mkd_slide-button_background_hover_color", $button1_background_hover_color );

		$button1_group4 = new MikadoGroup( "Size", "Define button size" );
		$mkdSlideButtons->addChild( "button1_group4", $button1_group4 );

		$row1 = new MikadoRow();
		$button1_group4->addChild( "row1", $row1 );

		$button1_width = new MikadoMetaField( "textsimple", "mkd_slide-button_width", "", "Width (px)", "This is some description" );
		$row1->addChild( "mkd_slide-button_width", $button1_width );

		$button1_height = new MikadoMetaField( "textsimple", "mkd_slide-button_height", "", "Height (px)", "This is some description" );
		$row1->addChild( "mkd_slide-button_height", $button1_height );

		$button1_group5 = new MikadoGroup( "Border", "Define border style" );
		$mkdSlideButtons->addChild( "button1_group5", $button1_group5 );

		$row1 = new MikadoRow();
		$button1_group5->addChild( "row1", $row1 );

		$button1_border_width = new MikadoMetaField( "textsimple", "mkd_slide-button_border_width", "", "Border Width (px)", "This is some description" );
		$row1->addChild( "mkd_slide-button_border_width", $button1_border_width );

		$button1_border_radius = new MikadoMetaField( "textsimple", "mkd_slide-button_border_radius", "", "Border Radius (px)", "This is some description" );
		$row1->addChild( "mkd_slide-button_border_radius", $button1_border_radius );

		$button1_border_color = new MikadoMetaField( "colorsimple", "mkd_slide-button_border_color", "", "Border Color", "This is some description" );
		$row1->addChild( "mkd_slide-button_border_color", $button1_border_color );

		$button1_border_hover_color = new MikadoMetaField( "colorsimple", "mkd_slide-button_border_hover_color", "", "Border Hover Color", "This is some description" );
		$row1->addChild( "mkd_slide-button_border_hover_color", $button1_border_hover_color );

		$button1_margin = new MikadoMetaField( "text", "mkd_slide-button_margin1", "", "Margin (px)", "Please insert margin in format (top right bottom left) i.e. 5px 5px 5px 5px", array(), array( "col_width" => 3 ) );
		$mkdSlideButtons->addChild( "mkd_slide-button_margin1", $button1_margin );

		$button1_group6 = new MikadoGroup( "Padding", "Define left/right padding for button (px)" );
		$mkdSlideButtons->addChild( "button1_group6", $button1_group6 );

		$row1 = new MikadoRow( true );
		$button1_group6->addChild( "row1", $row1 );

		$button1_padding = new MikadoMetaField( "textsimple", "mkd_slide-button_padding", "", "", "This is some description" );
		$row1->addChild( "mkd_slide-button_padding", $button1_padding );

		//Button 2
		$button2_section = new MikadoTitle( "button2_section", "Button 2" );
		$mkdSlideButtons->addChild( "button2_section", $button2_section );

		$button2_label = new MikadoMetaField( "text", "mkd_slide-button-label2", "", "Button Text", " Enter text to be displayed on button 2", array(), array( "col_width" => 3 ) );
		$mkdSlideButtons->addChild( "mkd_slide-button-label2", $button2_label );

		$button2_group1 = new MikadoGroup( "Link", "Url & target" );
		$mkdSlideButtons->addChild( "button2_group1", $button2_group1 );
		$row1 = new MikadoRow();
		$button2_group1->addChild( "row1", $row1 );

		$button2_link = new MikadoMetaField( "textsimple", "mkd_slide-button-link2", "", "Link", "This is some description" );
		$row1->addChild( "mkd_slide-button-link2", $button2_link );
		$button2_target = new MikadoMetaField( "selectsimple", "mkd_slide-button-target2", "_self", "Target", "This is some description", array(
			"_self"  => "Self",
			"_blank" => "Blank"
		) );
		$row1->addChild( "mkd_slide-button-target", $button2_target );

		$button2_group2 = new MikadoGroup( "Text Style", "Define text style" );
		$mkdSlideButtons->addChild( "button2_group2", $button2_group2 );
		$row1 = new MikadoRow();
		$button2_group2->addChild( "row1", $row1 );

		$button2_font_family = new MikadoMetaField( "Fontsimple", "mkd_slide-button_font_family2", "-1", "Font Family", "This is some description" );
		$row1->addChild( "mkd_slide-button_font_family2", $button2_font_family );
		$button2_font_size = new MikadoMetaField( "textsimple", "mkd_slide-button_font_size2", "", "Font Size (px)", "This is some description" );
		$row1->addChild( "mkd_slide-button_font_size2", $button2_font_size );
		$button2_font_style = new MikadoMetaField( "selectblanksimple", "mkd_slide-button_font_style2", "", "Font Style", "This is some description", mikado_one_mikado_options_font_style() );
		$row1->addChild( "mkd_slide-button_font_style2", $button2_font_style );
		$button2_font_weight = new MikadoMetaField( "selectblanksimple", "mkd_slide-button_font_weight2", "", "Font Weight", "This is some description", mikado_one_mikado_options_font_weight() );
		$row1->addChild( "mkd_slide-button_font_weight2", $button2_font_weight );

		$row2 = new MikadoRow();
		$button2_group2->addChild( "row2", $row2 );
		$button2_letter_spacing = new MikadoMetaField( "textsimple", "mkd_slide-button_letter_spacing2", "", "Letter Spacing(px)", "This is some description" );
		$row2->addChild( "mkd_slide-button_letter_spacing2", $button2_letter_spacing );
		$button2_line_height = new MikadoMetaField( "textsimple", "mkd_slide-button_line_height2", "", "Line Height (px)", "This is some description" );
		$row2->addChild( "mkd_slide-button_line_height2", $button2_line_height );
		$button2_text_color = new MikadoMetaField( "colorsimple", "mkd_slide-button_text_color2", "", "Text Color", "This is some description" );
		$row2->addChild( "mkd_slide-button_text_color2", $button2_text_color );
		$button2_text_hover_color = new MikadoMetaField( "colorsimple", "mkd_slide-button_text_hover_color2", "", "Text Hover Color", "This is some description" );
		$row2->addChild( "mkd_slide-button_text_hover_color2", $button2_text_hover_color );

		$row3 = new MikadoRow();
		$button2_group2->addChild( "row3", $row3 );
		$button2_text_align = new MikadoMetaField( "selectblanksimple", "mkd_slide-button_text_align2", "", "Text Align", "This is some description", array(
			"left"   => "Left",
			"center" => "Center",
			"right"  => "Right"
		) );
		$row3->addChild( "mkd_slide-button_text_align2", $button2_text_align );
		$button2_text_transform = new MikadoMetaField( "selectblanksimple", "mkd_slide-button_text_transform2", "", "Text Transform", "This is some description", mikado_one_mikado_options_text_transform() );
		$row3->addChild( "mkd_slide-button_text_transform2", $button2_text_transform );

		$button2_group3 = new MikadoGroup( "Background", "Define background" );
		$mkdSlideButtons->addChild( "button2_group3", $button2_group3 );
		$row4 = new MikadoRow();
		$button2_group3->addChild( "row4", $row4 );
		$button2_background_color = new MikadoMetaField( "colorsimple", "mkd_slide-button_background_color2", "", "Background Color", "This is some description" );
		$row4->addChild( "mkd_slide-button_background_color2", $button2_background_color );
		$button2_background_hover_color = new MikadoMetaField( "colorsimple", "mkd_slide-button_background_hover_color2", "", "Background Hover Color", "This is some description" );
		$row4->addChild( "mkd_slide-button_background_hover_color2", $button2_background_hover_color );

		$button2_group4 = new MikadoGroup( "Size", "Define button size" );
		$mkdSlideButtons->addChild( "button2_group4", $button2_group4 );
		$row1 = new MikadoRow();
		$button2_group4->addChild( "row1", $row1 );
		$button2_width = new MikadoMetaField( "textsimple", "mkd_slide-button_width2", "", "Width (px)", "This is some description" );
		$row1->addChild( "mkd_slide-button_width2", $button2_width );
		$button2_height = new MikadoMetaField( "textsimple", "mkd_slide-button_height2", "", "Height (px)", "This is some description" );
		$row1->addChild( "mkd_slide-button_height2", $button2_height );

		$button2_group5 = new MikadoGroup( "Border", "Define border style" );
		$mkdSlideButtons->addChild( "button2_group5", $button2_group5 );
		$row1 = new MikadoRow();
		$button2_group5->addChild( "row1", $row1 );
		$button2_border_width = new MikadoMetaField( "textsimple", "mkd_slide-button_border_width2", "", "Border Width (px)", "This is some description" );
		$row1->addChild( "mkd_slide-button_border_width2", $button2_border_width );
		$button2_border_radius = new MikadoMetaField( "textsimple", "mkd_slide-button_border_radius2", "", "Border Radius (px)", "This is some description" );
		$row1->addChild( "mkd_slide-button_border_radius2", $button2_border_radius );
		$button2_border_color = new MikadoMetaField( "colorsimple", "mkd_slide-button_border_color2", "", "Border Color", "This is some description" );
		$row1->addChild( "mkd_slide-button_border_color2", $button2_border_color );
		$button2_border_hover_color = new MikadoMetaField( "colorsimple", "mkd_slide-button_border_hover_color2", "", "Border Hover Color", "This is some description" );
		$row1->addChild( "mkd_slide-button_border_hover_color2", $button2_border_hover_color );

		$button2_margin = new MikadoMetaField( "text", "mkd_slide-button_margin2", "", "Margin (px)", "Please insert margin in format (top right bottom left) i.e. 5px 5px 5px 5px", array(), array( "col_width" => 3 ) );
		$mkdSlideButtons->addChild( "mkd_slide-button_margin2", $button2_margin );

		$button2_group6 = new MikadoGroup( "Padding", "Define left/right padding for button (px)" );
		$mkdSlideButtons->addChild( "button2_group6", $button2_group6 );

		$row1 = new MikadoRow( true );
		$button2_group6->addChild( "row1", $row1 );

		$button2_padding = new MikadoMetaField( "textsimple", "mkd_slide-button_padding2", "", "", "This is some description" );
		$row1->addChild( "mkd_slide-button_padding2", $button2_padding );

		//Mikado Slide Content Positioning

		$mkdSlideContentPositioning = new MikadoMetaBox( "slides", "Mikado Slide Content Positioning" );
		$mkdFramework->mkdMetaBoxes->addMetaBox( "slides_content_positioning", $mkdSlideContentPositioning );

		$mkd_slide_text_alignment = new MikadoMetaField( "selectblank", "mkd_slide-content-alignment", "", "Text Alignment", "Choose an alignment for the slide text", array(
			"left"   => "Left",
			"center" => "Center",
			"right"  => "Right"
		) );
		$mkdSlideContentPositioning->addChild( "mkd_slide-content-alignment", $mkd_slide_text_alignment );

		$mkd_slide_separate_text_graphic = new MikadoMetaField( "selectblank", "mkd_slide-separate-text-graphic", "no", "Separate Graphic and Text Positioning", "Do you want to separately position graphic and text?", array(
			"no"  => "No",
			"yes" => "Yes"
		), array(
			"dependence" => true,
			"hide"       => array(
				""   => "#mkdf_mkd_slide_graphic_positioning_container",
				"no" => "#mkdf_mkd_slide_graphic_positioning_container"
			),
			"show"       => array(
				"yes" => "#mkdf_mkd_slide_graphic_positioning_container"
			)
		) );
		$mkdSlideContentPositioning->addChild( "mkd_slide-separate-text-graphic", $mkd_slide_separate_text_graphic );

		$mkd_slide_content_vertical_middle = new MikadoMetaField( "yesno", "mkd_slide-content-vertical-middle", "no", "Vertically Align Content to Middle", "", array(), array(
			"dependence"             => true,
			"dependence_hide_on_yes" => "#mkdf_mkd_slide-content-vertical-middle-container",
			"dependence_show_on_yes" => "#mkdf_mkd_slide-content-vertical-middle-type-container"
		) );
		$mkdSlideContentPositioning->addChild( "mkd_slide-content-vertical-middle", $mkd_slide_content_vertical_middle );

		$mkd_slide_content_vertical_middle_type_container = new MikadoContainer( "mkd_slide-content-vertical-middle-type-container", "mkd_slide-content-vertical-middle", "no" );
		$mkdSlideContentPositioning->addChild( "mkd_slide-content-vertical-middle-type-container", $mkd_slide_content_vertical_middle_type_container );

		$mkd_slide_content_vertical_middle_type = new MikadoMetaField( "selectblank", "mkd_slide-content-vertical-middle-type", "", "Align Content From", "", array(
			"bottom_of_header" => "Bottom of Header",
			"window_top"       => "Window Top"
		) );
		$mkd_slide_content_vertical_middle_type_container->addChild( "mkd_slide-content-vertical-middle-type", $mkd_slide_content_vertical_middle_type );

		$mkd_slide_content_vertical_middle_container = new MikadoContainer( "mkd_slide-content-vertical-middle-container", "mkd_slide-content-vertical-middle", "yes" );
		$mkdSlideContentPositioning->addChild( "mkd_slide-content-vertical-middle-container", $mkd_slide_content_vertical_middle_container );

		$mkd_slide_content_full_width = new MikadoMetaField( "yesno", "mkd_slide-content-full-width", "no", "Content Full Width", "Do you want to set slide content to full width?", array(), array(
			"dependence"             => true,
			"dependence_hide_on_yes" => "#mkdf_mkd_slide_content_width_container",
			"dependence_show_on_yes" => ""
		) );
		$mkd_slide_content_vertical_middle_container->addChild( "mkd_slide-content-full-width", $mkd_slide_content_full_width );

		$mkd_slide_content_width_container = new MikadoContainer( "mkd_slide_content_width_container", "mkd_slide-content-full-width", "yes" );
		$mkd_slide_content_vertical_middle_container->addChild( "mkd_slide_content_width_container", $mkd_slide_content_width_container );

		$mkd_slide_content_width = new MikadoMetaField( "text", "mkd_slide-content-width", "", "Content Width", "Enter Width for Content Area (%)", array(), array( "col_width" => 3 ) );
		$mkd_slide_content_width_container->addChild( "mkd_slide-content-width", $mkd_slide_content_width );

		$content_positioning_group = new MikadoGroup( "Space Around Content in Slide", "Enter values for margins around slide content" );
		$mkd_slide_content_vertical_middle_container->addChild( "content_positioning_group", $content_positioning_group );
		$row1 = new MikadoRow( true );
		$content_positioning_group->addChild( "row1", $row1 );
		$mkd_slide_content_top = new MikadoMetaField( "textsimple", "mkd_slide-content-top", "", "From Top (%)", "This is some description" );
		$row1->addChild( "mkd_slide-content-top", $mkd_slide_content_top );
		$mkd_slide_content_left = new MikadoMetaField( "textsimple", "mkd_slide-content-left", "", "From Left (%)", "This is some description" );
		$row1->addChild( "mkd_slide-content-left", $mkd_slide_content_left );
		$mkd_slide_content_bottom = new MikadoMetaField( "textsimple", "mkd_slide-content-bottom", "", "From Bottom (%)", "This is some description" );
		$row1->addChild( "mkd_slide-content-bottom", $mkd_slide_content_bottom );
		$mkd_slide_content_right = new MikadoMetaField( "textsimple", "mkd_slide-content-right", "", "From Right (%)", "This is some description" );
		$row1->addChild( "mkd_slide-content-right", $mkd_slide_content_right );


		$mkd_slide_graphic_positioning_container = new MikadoContainer( "mkd_slide_graphic_positioning_container", "mkd_slide-separate-text-graphic", "no" );
		$mkd_slide_content_vertical_middle_container->addChild( "mkd_slide_graphic_positioning_container", $mkd_slide_graphic_positioning_container );

		$mkd_slide_graphic_alignment = new MikadoMetaField( "selectblank", "mkd_slide-graphic-alignment", "", "Graphic Alignment", "Choose an alignment for the slide graphic", array(
			"left"   => "Left",
			"center" => "Center",
			"right"  => "Right"
		) );
		$mkd_slide_graphic_positioning_container->addChild( "mkd_slide-graphic-alignment", $mkd_slide_graphic_alignment );

		$graphic_positioning_group = new MikadoGroup( "Graphic Positioning", "Positioning for slide graphic" );
		$mkd_slide_graphic_positioning_container->addChild( "graphic_positioning_group", $graphic_positioning_group );


		$row1 = new MikadoRow( true );
		$graphic_positioning_group->addChild( "row1", $row1 );
		$mkd_slide_content_width = new MikadoMetaField( "textsimple", "mkd_slide-graphic-width", "", "Width (%)", "This is some description" );
		$row1->addChild( "mkd_slide-graphic-width", $mkd_slide_content_width );

		$row2 = new MikadoRow( true );
		$graphic_positioning_group->addChild( "row2", $row2 );
		$mkd_slide_content_top = new MikadoMetaField( "textsimple", "mkd_slide-graphic-top", "", "Content from top (%)", "This is some description" );
		$row2->addChild( "mkd_slide-graphic-top", $mkd_slide_content_top );
		$mkd_slide_content_left = new MikadoMetaField( "textsimple", "mkd_slide-graphic-left", "", "Content from left (%)", "This is some description" );
		$row2->addChild( "mkd_slide-graphic-left", $mkd_slide_content_left );

		$row3 = new MikadoRow( true );
		$graphic_positioning_group->addChild( "row3", $row3 );
		$mkd_slide_content_bottom = new MikadoMetaField( "textsimple", "mkd_slide-graphic-bottom", "", "Content from bottom (%)", "This is some description" );
		$row3->addChild( "mkd_slide-graphic-bottom", $mkd_slide_content_bottom );
		$mkd_slide_content_right = new MikadoMetaField( "textsimple", "mkd_slide-graphic-right", "", "Content from right (%)", "This is some description" );
		$row3->addChild( "mkd_slide-graphic-right", $mkd_slide_content_right );

		$mkd_slide_content_background = new MikadoMetaField( "color", "mkd_slide-content-background-color", "", "Slide Content Background Color", "Choose background color for slide content" );
		$mkdSlideContentPositioning->addChild( "mkd_slide-content-background-color", $mkd_slide_content_background );

		$mkd_slide_content_padding = new MikadoMetaField( "text", "mkd_slide-content-text-padding", "", "Slide Content Text Padding", "Define some padding around text (top right bottom left) - Default value is 0px 0px 0px 0px" );
		$mkdSlideContentPositioning->addChild( "mkd_slide-content-text-padding", $mkd_slide_content_padding );

	}

	add_action('mikado_one_mikado_action_meta_boxes', 'mikado_core_slider_meta_boxes_map');
}