<?php
if ( ! function_exists( 'mikado_one_core_general_options_map' ) ) {
	function mikado_one_core_general_options_map() {
		$mkdFramework = mikado_one_mikado_return_framework();

		$generalPage = new MikadoAdminPage("", "General");
		$mkdFramework->mkdOptions->addAdminPage("general",$generalPage);

		// Logo

		$panel_logo = new MikadoPanel("Branding", "logo");
		$generalPage->addChild("panel_logo",$panel_logo);

			$show_logo = new MikadoField("yesno","show_logo","yes","Show Logo","Disabling this option will hide logo", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_show_logo_container"));
		    $panel_logo->addChild("show_logo",$show_logo);

				$show_logo_container = new MikadoContainer("show_logo_container","show_logo","no");
				$panel_logo->addChild("show_logo_container",$show_logo_container);
				
					$logo_image = new MikadoField("image","logo_image",MIKADO_ROOT."/img/logo.png","Logo Image - Normal","Choose a default logo image to display ");
					$show_logo_container->addChild("logo_image",$logo_image);
					
					$logo_image_light = new MikadoField("image","logo_image_light",MIKADO_ROOT."/img/logo_white.png","Logo Image - Light",'Choose a logo image to display for "Light" header skin');
					$show_logo_container->addChild("logo_image_light",$logo_image_light);
					
					$logo_image_dark = new MikadoField("image","logo_image_dark",MIKADO_ROOT."/img/logo_black.png","Logo Image - Dark",'Choose a logo image to display for "Dark" header skin');
					$show_logo_container->addChild("logo_image_dark",$logo_image_dark);
					
					$logo_image_sticky = new MikadoField("image","logo_image_sticky",MIKADO_ROOT."/img/logo_black.png","Logo Image - Sticky Header",'Choose a logo image to display for "Sticky" header type');
					$show_logo_container->addChild("logo_image_sticky",$logo_image_sticky);
					
					$logo_image_fixed_hidden = new MikadoField("image","logo_image_fixed_hidden","","Logo Image - Fixed Advanced Header",'Choose a logo image to display for "Fixed Advanced" header type');
					$show_logo_container->addChild("logo_image_fixed_hidden",$logo_image_fixed_hidden);
					
					$logo_image_mobile = new MikadoField("image","logo_image_mobile","","Logo Image - Mobile Header",'Choose a logo image to display for "Mobile" header type');
					$show_logo_container->addChild("logo_image_mobile",$logo_image_mobile);

					$vertical_logo_bottom = new MikadoField("image","vertical_logo_bottom","","Side Menu Area Bottom Logo Image", 'Choose a logo image to display on the bottom of side menu area for "Initially Hidden" side menu area type');
					$show_logo_container->addChild("vertical_logo_bottom", $vertical_logo_bottom);
			
			$favicon_image = new MikadoField("image","favicon_image",MIKADO_ROOT."/img/favicon.ico","Favicon Image","Choose a favicon image to be displayed");
			$panel_logo->addChild("favicon_image",$favicon_image);

		// Design Style

		$panel_design = new MikadoPanel("Appearance","design_style");
		$generalPage->addChild("panel_design",$panel_design);
			
			$title_main_color = new MikadoTitle("title_main_color", "Main Color");
			$panel_design->addChild("title_main_color", $title_main_color);
			
			$first_color = new MikadoField("color","first_color","","First Main Color","Choose the most dominant theme color. Default color is #e6ae48.");
			$panel_design->addChild("first_color",$first_color);
			
			$title_header_position = new MikadoTitle("title_header_position", "Header Position");
			$panel_design->addChild("title_header_position", $title_header_position);
			
			$vertical_area = new MikadoField("yesno","vertical_area","no","Switch to Side Position","Enabling this option will switch to a Side Position (default is Top Position)", array(),
				array("dependence" => true,
		            "dependence_hide_on_yes" => "#mkdf_header_panel,#mkdf_top_menu_panel,#mkdf_header_top_panel,#mkdf_enable_search_panel,#mkdf_enable_side_area_panel,#mkdf_enable_popup_menu_panel",
		            "dependence_show_on_yes" => "#mkdf_vertical_areas_panel"));
			$panel_design->addChild("vertical_area",$vertical_area);

		    $title_transparent_content = new MikadoTitle("title_transparent_content", "Uniform Site Background");
		    $panel_design->addChild("title_transparent_content", $title_transparent_content);

		    $transparent_content = new MikadoField("yesno","transparent_content","no","Enable Uniform Site Background","If enabled, content background on pages will be transparent (unless set otherwise) and the background you set here will show", array(),
		        array("dependence" => true,
		            "dependence_hide_on_yes" => "",
		            "dependence_show_on_yes" => "#mkdf_transparent_content_container"));
		    $panel_design->addChild("transparent_content",$transparent_content);

		    $transparent_content_container = new MikadoContainer("transparent_content_container","transparent_content","no");
		    $panel_design->addChild("transparent_content_container",$transparent_content_container);

		        $transparent_content_background_color = new MikadoField("color","transparent_content_background_color","","Background Color","Choose body background color. Default color is #ffffff.");
		        $transparent_content_container->addChild("transparent_content_background_color",$transparent_content_background_color);

		        $transparent_content_background_image = new MikadoField("image","transparent_content_background_image","","Background Image","Choose an image to be displayed in background");
		        $transparent_content_container->addChild("transparent_content_background_image",$transparent_content_background_image);

		        $transparent_content_pattern_background_image = new MikadoField("image","transparent_content_pattern_background_image","","Background Pattern","Choose an image to be used as background pattern");
		        $transparent_content_container->addChild("transparent_content_pattern_background_image",$transparent_content_pattern_background_image);

		    $title_boxed = new MikadoTitle("title_boxed", "Boxed layout");
		    $panel_design->addChild("title_boxed", $title_boxed);

			$boxed = new MikadoField("yesno","boxed","no","Enable Boxed layout","Enabling this option will display site content in grid", array(),
				array("dependence" => true,
				"dependence_hide_on_yes" => "",
				"dependence_show_on_yes" => "#mkdf_boxed_container"));
			$panel_design->addChild("boxed",$boxed);
			
			$boxed_container = new MikadoContainer("boxed_container","boxed","no");
			$panel_design->addChild("boxed_container",$boxed_container);
			
				$background_color_box = new MikadoField("color","background_color_box","","Page Background Color","Choose the page background (body) color. Default color is #f5f5f5.");
				$boxed_container->addChild("background_color_box",$background_color_box);
				
				$background_image = new MikadoField("image","background_image","","Background Image","Choose an image to be displayed in background");
				$boxed_container->addChild("background_image",$background_image);
				
				$pattern_background_image = new MikadoField("image","pattern_background_image","","Background Pattern","Choose an image to be used as background pattern");
				$boxed_container->addChild("pattern_background_image",$pattern_background_image);

		    $title_paspartu = new MikadoTitle("title_paspartu", "Passepartout");
		    $panel_design->addChild("title_paspartu", $title_paspartu);

		    $paspartu = new MikadoField("yesno","paspartu","no","Enable Passepartout","Enabling this option will display passepartout around content", array(),
		        array("dependence" => true,
		        "dependence_hide_on_yes" => "",
		        "dependence_show_on_yes" => "#mkdf_paspartu_container"));
		    $panel_design->addChild("paspartu",$paspartu);

		    $paspartu_container = new MikadoContainer("paspartu_container","paspartu","no");
		    $panel_design->addChild("paspartu_container",$paspartu_container);

		        $paspartu_color = new MikadoField("color","paspartu_color","","Passepartout Color","Choose the background color for passepartout. Default is #ffffff.");
		        $paspartu_container->addChild("paspartu_color",$paspartu_color);

		        $paspartu_width = new MikadoField("text","paspartu_width","","Passepartout Size (%)","Enter size amount for passepartout, default value is 2% (the percent is in relation to site width)", array(), array("col_width" => 3));
		        $paspartu_container->addChild("paspartu_width",$paspartu_width);

		        $paspartu_header_alignment = new MikadoField("yesno","paspartu_header_alignment","no","Align Header With Passepartout","Enabling this option will set header content within passepartout");
		        $paspartu_container->addChild("paspartu_header_alignment",$paspartu_header_alignment);

		        $paspartu_on_top = new MikadoField("yesno","paspartu_on_top","yes","Top Passepartout","Disabling this option will disable top part of passepartout", array(),
		            array("dependence" => true,
		                "dependence_hide_on_yes" => "#mkdf_paspartu_on_bottom_slider_container",
		                "dependence_show_on_yes" => ""));
		        $paspartu_container->addChild("paspartu_on_top",$paspartu_on_top);

		        $paspartu_on_bottom_slider_container = new MikadoContainer("paspartu_on_bottom_slider_container","paspartu_on_top","yes");
		        $paspartu_container->addChild("paspartu_on_bottom_slider_container",$paspartu_on_bottom_slider_container);

		        $paspartu_on_bottom_slider = new MikadoField("yesno","paspartu_on_bottom_slider","no","Show Bottom Passepartout on Mikado Slider","Enabling this option will show bottom passepartout on Mikado Slider");
		        $paspartu_on_bottom_slider_container->addChild("paspartu_on_bottom_slider",$paspartu_on_bottom_slider);

		        $paspartu_on_bottom = new MikadoField("yesno","paspartu_on_bottom","yes","Bottom Passepartout","Disabling this option will disable bottom part of passepartout", array(),
		            array("dependence" => true,
		                "dependence_hide_on_yes" => "",
		                "dependence_show_on_yes" => "#mkdf_paspartu_on_bottom_fixed_container"));
		        $paspartu_container->addChild("paspartu_on_bottom",$paspartu_on_bottom);

		        $paspartu_on_bottom_fixed_container = new MikadoContainer("paspartu_on_bottom_fixed_container","paspartu_on_bottom","no");
		        $paspartu_container->addChild("paspartu_on_bottom_fixed_container",$paspartu_on_bottom_fixed_container);

		        $paspartu_on_bottom_fixed = new MikadoField("yesno","paspartu_on_bottom_fixed","no","Fix Bottom Passepartout","Enabling this option will fix bottom part of passepartout to the bottom of the screen");
		        $paspartu_on_bottom_fixed_container->addChild("paspartu_on_bottom_fixed",$paspartu_on_bottom_fixed);

		// Behavior

		$panel_settings = new MikadoPanel("Behavior","settings");
		$generalPage->addChild("panel_settings",$panel_settings);

			$page_transitions = new MikadoField("select","page_transitions","0","Page Transition",'Choose a a type of transition between loading pages. In order for animation to work properly, you must choose "Post name" in permalinks settings', array( 0 => "No animation",
			   1 => "Up/Down",
			   2 => "Fade",
			   3 => "Up/Down (In) / Fade (Out)",
			   4 => "Left/Right"
			  ),
		      array("dependence" => true,
		      	"hide" => array(
		      		0=>"#mkdf_page_transitions_container"),
		      	"show" => array(
		      		1=>"#mkdf_page_transitions_container",
		      		2=>"#mkdf_page_transitions_container",
		      		3=>"#mkdf_page_transitions_container",
		      		4=>"#mkdf_page_transitions_container") ));
			$panel_settings->addChild("page_transitions",$page_transitions);
			
			$page_transitions_container = new MikadoContainer("page_transitions_container","page_transitions",0);
			$panel_settings->addChild("page_transitions_container",$page_transitions_container);
			
				$loading_animation = new MikadoField("onoff","loading_animation","off","Loading Animation","Enabling this option will display animation while page loads", array(),
					array("dependence" => true,
					"dependence_hide_on_yes" => "",
					"dependence_show_on_yes" => "#mkdf_loading_animation_container"));
				$page_transitions_container->addChild("loading_animation",$loading_animation);
				
				$loading_animation_container = new MikadoContainer("loading_animation_container","loading_animation","off");
				$page_transitions_container->addChild("loading_animation_container",$loading_animation_container);
				
					$group1 = new MikadoGroup("Loading Animation Graphic","Choose type and color of preload graphic animation");
					$loading_animation_container->addChild("group1",$group1);
					
						$row1 = new MikadoRow();
						$group1->addChild("row1",$row1);
						
							$loading_animation_spinner = new MikadoField("selectsimple","loading_animation_spinner","pulse","Spinner","This is some description", array( "pulse" => "Pulse",
				       "double_pulse" => "Double Pulse",
				       "cube" => "Cube",
				       "rotating_cubes" => "Rotating Cubes",
				       "stripes" => "Stripes",
				       "wave" => "Wave",
				       "two_rotating_circles" => "2 Rotating Circles",
				       "five_rotating_circles" => "5 Rotating Circles"
				      ));
							$row1->addChild("loading_animation_spinner",$loading_animation_spinner);
							
							$spinner_color = new MikadoField("colorsimple","spinner_color","","Spinner Color","This is some description");
							$row1->addChild("spinner_color",$spinner_color);
							
					$loading_image = new MikadoField("image","loading_image","","Loading Image",'Upload custom image to be displayed while page loads (Note: Page Transition must not be set to "No Animation")');
					$loading_animation_container->addChild("loading_image",$loading_image);
				
				$internal_no_ajax_links = new MikadoField("textarea","internal_no_ajax_links","","List of Internal URLs Loaded Without AJAX (Separated With Comma)","To disable AJAX transitions on certain pages, enter their full URLs here (for example: http://www.mydomain.com/forum/)");
				$page_transitions_container->addChild("internal_no_ajax_links",$internal_no_ajax_links);
			
			$show_back_button = new MikadoField("yesno","show_back_button","yes","Show 'Back To Top Button'","Enabling this option will display a Back to Top button on every page");
			$panel_settings->addChild("show_back_button",$show_back_button);
			
			$responsiveness = new MikadoField("yesno","responsiveness","yes","Responsiveness","Enabling this option will make all pages responsive");
			$panel_settings->addChild("responsiveness",$responsiveness);
				
			$smooth_scroll = new MikadoField("yesno","smooth_scroll","yes","Smooth Scroll","Enabling this option will perform a smooth scrolling effect on every page (except on Mac and touch devices)");
			$panel_settings->addChild("smooth_scroll",$smooth_scroll);
			
			$elements_animation_on_touch = new MikadoField("yesno","elements_animation_on_touch","no","Elements Animation on Mobile/Touch Devices","Enabling this option will allow elements (shortcodes) to animate on mobile / touch devices");
			$panel_settings->addChild("elements_animation_on_touch",$elements_animation_on_touch);

		// Custom Code

		$panel3 = new MikadoPanel("Custom CSS & JS","custom_code");
		$generalPage->addChild("panel3",$panel3);

			$custom_css = new MikadoField("textarea","custom_css","","Custom CSS","Enter your custom CSS here");
			$panel3->addChild("custom_css",$custom_css);
			
			$custom_js = new MikadoField("textarea","custom_js","","Custom JS",'Enter your custom Javascript here (jQuery selector is "$j" because of the conflict mode)');
			$panel3->addChild("custom_js",$custom_js);

		// SEO

		$panel_seo = new MikadoPanel("SEO","seo");
		$generalPage->addChild("panel_seo",$panel_seo);

			$google_analytics_code = new MikadoField("text","google_analytics_code","","Google Analytics Account ID","With this field you can monitor traffic on your website. Example UA-000000-01");
			$panel_seo->addChild("google_analytics_code",$google_analytics_code);
			
			$disable_mkd_seo = new MikadoField("yesno","disable_mkd_seo","no","Disable Theme SEO","Enabling this option will turn off theme SEO", array(),
				array("dependence" => true,
				"dependence_hide_on_yes" => "#mkdf_disable_mkd_seo_container",
				"dependence_show_on_yes" => ""));
			$panel_seo->addChild("disable_mkd_seo",$disable_mkd_seo);
			
			$disable_mkd_seo_container = new MikadoContainer("disable_mkd_seo_container","disable_mkd_seo","yes");
			$panel_seo->addChild("disable_mkd_seo_container",$disable_mkd_seo_container);
			
				$meta_keywords = new MikadoField("textarea","meta_keywords","","Meta Keywords","Add relevant keywords separated with commas to improve SEO");
				$disable_mkd_seo_container->addChild("meta_keywords",$meta_keywords);
				
				$meta_description = new MikadoField("textarea","meta_description","","Meta Description","Enter a short description of the website for SEO");
				$disable_mkd_seo_container->addChild("meta_description",$meta_description);

		// Google Maps

		$panel_google_maps = new MikadoPanel("Google Maps", "google_maps");
		$generalPage->addChild("panel_google_maps", $panel_google_maps);

		    $google_maps_api_key = new MikadoField("text", "google_maps_api_key", "", "Google Maps Api Key", "Insert your Google Maps API key here.");
		    $panel_google_maps->addChild("google_maps_api_key", $google_maps_api_key);
			
		// Maintenance

		$mkd_pages = array();
		$pages = get_posts(array(
		    'post_type' => 'page',
		    'meta_key' => '_wp_page_template',
		    'meta_value' => 'landing_page.php'
		));
		foreach($pages as $page) {
		    $mkd_pages[$page->ID] = $page->post_title;
		}

		$panel_maintenance = new MikadoPanel("Maintenance Mode","panel_maintenance");
		$generalPage->addChild("panel_maintenance",$panel_maintenance);

			$maintenance_mode = new MikadoField("yesno","mkd_maintenance_mode","no","Enable Maintenance Mode","Turn on this option if you want to enable maintenance mode on your site", array(),
		        array("dependence" => true,
		            "dependence_hide_on_yes" => "",
		            "dependence_show_on_yes" => "#mkdf_maintenance_container"
		        ));
			$panel_maintenance->addChild("mkd_maintenance_mode",$maintenance_mode);

		    $maintenance_container = new MikadoContainer("maintenance_container","mkd_maintenance_mode","no");
		    $panel_maintenance->addChild("maintenance_container",$maintenance_container);

		    $maintenance_page = new MikadoField("selectblank","mkd_maintenance_page","",'Maintenance Page','Choose maintenance page to display when user visits your site',$mkd_pages);
		    $maintenance_container->addChild("mkd_maintenance_page",$maintenance_page);
	}

	add_action('mikado_one_mikado_action_options', 'mikado_one_core_general_options_map', 1);
}