<?php

/********************************************
 * Display meta boxes for post formats
 ********************************************/

if( ! function_exists('mikado_core_return_post_formats') ){
    function mikado_core_return_post_formats(){
        $metaboxes = array(
            'link_post_format'  => array(
                'title'             => 'Link post format',
                'applicableto'      => 'post',
                'location'          => 'normal',
                'display_condition' => 'post-format-link',
                'priority'          => 'high',
                'fields'            => array(
                    'title_link' => array(
                        'title'       => 'Link',
                        'type'        => 'text',
                        'description' => '',
                        'size'        => 100
                    )
                )
            ),
            'quote_post_format' => array(
                'title'             => 'Quote post format',
                'applicableto'      => 'post',
                'location'          => 'normal',
                'display_condition' => 'post-format-quote',
                'priority'          => 'high',
                'fields'            => array(
                    'quote_format' => array(
                        'title'       => 'Quote',
                        'type'        => 'text',
                        'description' => '',
                        'size'        => 100
                    )
                )
            ),
            'video_post_format' => array(
                'title'             => 'Video post format',
                'applicableto'      => 'post',
                'location'          => 'normal',
                'display_condition' => 'post-format-video',
                'priority'          => 'high',
                'fields'            => array(
                    'video_format_choose' => array(
                        'title'       => 'Choose Video Type',
                        'type'        => 'selectbox',
                        'description' => ''
                    ),
                    'video_format_link'   => array(
                        'title'       => 'Video ID',
                        'type'        => 'text',
                        'description' => '',
                        'size'        => 100
                    ),
                    'video_format_image'  => array(
                        'title'       => 'Video image',
                        'type'        => 'image',
                        'description' => '',
                        'size'        => 100
                    ),
                    'video_format_webm'   => array(
                        'title'       => 'Video webm',
                        'type'        => 'text',
                        'description' => '',
                        'size'        => 100
                    ),
                    'video_format_mp4'    => array(
                        'title'       => 'Video mp4',
                        'type'        => 'text',
                        'description' => '',
                        'size'        => 100
                    ),
                    'video_format_ogv'    => array(
                        'title'       => 'Video ogv',
                        'type'        => 'text',
                        'description' => '',
                        'size'        => 100
                    )

                )
            ),
            'audio_post_format' => array(
                'title'             => 'Audio post format',
                'applicableto'      => 'post',
                'location'          => 'normal',
                'display_condition' => 'post-format-audio',
                'priority'          => 'high',
                'fields'            => array(
                    'audio_link' => array(
                        'title'       => 'Audio Link',
                        'type'        => 'text',
                        'description' => '',
                        'size'        => 100
                    )


                )
            ),
        );

        return $metaboxes;
    }
}



if ( ! function_exists( 'mikado_one_mikado_add_metaboxes' ) ) {
	function mikado_one_mikado_add_metaboxes() {
		$metaboxes = mikado_core_return_post_formats();

		if ( ! empty( $metaboxes ) ) {
			foreach ( $metaboxes as $id => $metabox ) {
				add_meta_box( $id, $metabox['title'], 'mkd_show_metaboxes', $metabox['applicableto'], $metabox['location'], $metabox['priority'], $id );
			}
		}
	}

	// add meta boxes
	add_action( 'admin_init', 'mikado_one_mikado_add_metaboxes' );
}

if ( ! function_exists( 'mikado_one_mikado_save_metaboxes' ) ) {
	function mikado_one_mikado_save_metaboxes( $post_id ) {
        $metaboxes = mikado_core_return_post_formats();
		if ( isset( $_POST['post_format_meta_box_nonce'] ) ) {
			$nonce = $_POST['post_format_meta_box_nonce'];
		} else {
			$nonce = wp_create_nonce( 'post_format_meta_box_nonce' );
		}
		// verify nonce
		if ( ! wp_verify_nonce( $nonce, basename( __FILE__ ) ) ) {
			return $post_id;
		}

		// check autosave
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return $post_id;
		}

		// check permissions
		if ( 'page' == $_POST['post_type'] ) {
			if ( ! current_user_can( 'edit_page', $post_id ) ) {
				return $post_id;
			}
		} elseif ( ! current_user_can( 'edit_post', $post_id ) ) {
			return $post_id;
		}

		$post_type = get_post_type();

		// loop through fields and save the data
		foreach ( $metaboxes as $id => $metabox ) {
			// check if metabox is applicable for current post type
			if ( $metabox['applicableto'] == $post_type ) {
				$fields = $metaboxes[ $id ]['fields'];

				foreach ( $fields as $id => $field ) {
					$old = get_post_meta( $post_id, $id, true );
					$new = $_POST[ $id ];

					if ( $new && $new != $old ) {
						update_post_meta( $post_id, $id, $new );
					} elseif ( '' == $new && $old || ! isset( $_POST[ $id ] ) ) {
						delete_post_meta( $post_id, $id, $old );
					}
				}
			}
		}
	}

	// save meta boxes
	add_action( 'save_post', 'mikado_one_mikado_save_metaboxes' );
}


if ( ! function_exists( 'mkd_show_metaboxes' ) ) {
	// show meta boxes
	function mkd_show_metaboxes( $post, $args ) {
        $metaboxes = mikado_core_return_post_formats();

		$custom = get_post_custom( $post->ID );
		$fields = $metaboxes[ $args['id'] ]['fields'];

		/** Nonce **/
		$output = '<input type="hidden" name="post_format_meta_box_nonce" value="' . wp_create_nonce( basename( __FILE__ ) ) . '" />';

		if ( sizeof( $fields ) ) {
			foreach ( $fields as $id => $field ) {

				if ( isset( $custom[ $id ][0] ) && $custom[ $id ][0] != "" ) {
					$value = $custom[ $id ][0];
				} else {
					$value = "";
				}

				switch ( $field['type'] ) {
					default:
					case "text":
						$output .= '<div class="form-field"><label for="' . esc_attr( $id ) . '"><b>' . $field['title'] . '</b></label><br/><input id="' . esc_attr( $id ) . '" type="text" name="' . esc_attr( $id ) . '" value="' . esc_attr( $value ) . '" size="' . $field['size'] . '" /></div>';
						break;
					case "image":
						$output .= '<div class="form-field"><label for="' . esc_attr( $id ) . '"><b>' . $field['title'] . '</b></label><br/><div class="image_holder"><input id="' . esc_attr( $id ) . '" class="' . esc_attr( $id ) . '" type="text" name="' . esc_attr( $id ) . '" value="' . esc_attr( $value ) . '" size="' . $field['size'] . '" /><input class="upload_button" type="button" value="Upload file"></div></div>';
						break;
					case "selectbox":
						$output .= '<div class="form-field"><label for="' . $id . '"><b>' . $field['title'] . '</b></label><br/><select id="' . $id . '" name="' . $id . '">';
						$output .= '<option ';
						if ( $value == "youtube" ) {
							$output .= 'selected="selected"';
						}
						$output .= ' value="youtube">' . esc_html__( 'Youtube', 'mikado1' ) . '</option>
								<option ';
						if ( $value == "vimeo" ) {
							$output .= 'selected="selected"';
						}
						$output .= ' value="vimeo">' . esc_html__( 'Vimeo', 'mikado1' ) . '</option>
								<option ';
						if ( $value == "self" ) {
							$output .= 'selected="selected"';
						}
						$output .= ' value="self">' . esc_html__( 'Self hosted', 'mikado1' ) . '</option>  
								</select></div>';
						break;
				}
			}
		}

		echo wp_kses( $output, array(
			'a'      => array(
				'href'  => true,
				'class' => true,
				'id'    => true,
				'title' => true
			),
			'div'    => array(
				'class' => true,
				'id'    => true
			),
			'input'  => array(
				'name'  => true,
				'value' => true,
				'type'  => true,
				'id'    => true,
				'size'  => true,
				'class' => true
			),
			'label'  => array(
				'for'
			),
			'b'      => array(),
			'br'     => array(),
			'select' => array(
				'name'  => true,
				'id'    => true,
				'class' => true
			),
			'option' => array(
				'selected' => true,
				'value'    => true
			)
		) );
	}
}


if ( ! function_exists( 'mkd_display_metaboxes' ) ) {
	function mkd_display_metaboxes() {
        $metaboxes = mikado_core_return_post_formats();
		if ( get_post_type() == "post" ) :
			?>
            <script type="text/javascript">// <![CDATA[
                $j = jQuery;

				<?php
				$formats = $ids = array();
				foreach ( $metaboxes as $id => $metabox ) {
					array_push( $formats, "'" . $metabox['display_condition'] . "': '" . $id . "'" );
					array_push( $ids, "#" . $id );
				}
				?>

                var formats = { <?php echo implode( ',', $formats );?> };
                var ids = "<?php echo implode( ',', $ids ); ?>";

                function displayMetaboxes() {
                    // Hide all post format metaboxes
                    $j(ids).hide();
                    // Get current post format
                    var selectedElt = $j("input[name='post_format']:checked").attr("id");

                    // If exists, fade in current post format metabox
                    if (formats[selectedElt])
                        $j("#" + formats[selectedElt]).fadeIn();
                }

                $j(function () {
                    // Show/hide metaboxes on page load
                    displayMetaboxes();

                    // Show/hide metaboxes on change event
                    $j("input[name='post_format']").change(function () {
                        displayMetaboxes();
                    });
                });

                // ]]></script>
		<?php
		endif;
	}

	add_action( 'admin_print_scripts', 'mkd_display_metaboxes', 1000 );
}